<!-- NEWS.md was auto-generated by NEWS.Rmd. Please DO NOT edit by hand!-->

# Changes in version 1.0.1 (2025-03-07)

## Bugfixes

### `analyse_baSAR()`

- The number of aliquots used was only partially reported if no aliquots
  were removed, resulting in an incomplete message in the output to the
  terminal.

### `analyse_FadingMeasurement()`

- The function now checks that an input object generated from an XSYG
  file contains irradiation steps and returns an error if none are
  available, instead of producing an unhelpful output (#588).

- A regression in `plot_RLum.Analysis()` caused part of the plot of the
  luminescence curves to be garbled (#589).

- The function crashed on a file generated by `read_XSYG2R()` if the
  number of curves available after removal of the irradiation step was
  not enough for the the fading measurement to be analysed (#603).

### `analyse_pIRIRSequence()`

- The check on the minimum device plot size used to fail if only one
  dimension was below our minimum threshold, and when it was incorrectly
  triggered by the floating point values computed by
  `grDevices::dev.size()`, which sometimes could be spuriously just
  below threshold. We also changed the minimum device size from 18 to 16
  inches (#593).

### `calc_CosmicDoseRate()`

- The function crashed if the number of depths provided exceeded that of
  the densities and the latter contained more than one value (#595).

### `calc_FadingCorr()`

- The function sporadically returned an implausibly large error estimate
  if any of the Monte Carlo simulations produced an outlier solution
  (#597).

- The function now allocates only as much memory as required if the user
  specifies a value for `n.MC` other than `"auto"`, which brings a small
  speed-up if fewer than 10 million samples are requested.

- Input arguments are now more thoroughly checked to avoid warnings or
  unhelpful messages (#599).

### `calc_FastRatio()`

- The function crashed if the input was an RLum.Analysis object (#586).

### `plot_AbanicoPlot()`

- The `xlim`, `ylim` and `zlim` parameters are now better validated to
  avoid possible crashes if misspecified (#581).

### `plot_RLum.Analysis()`

- The function reset incorrectly the graphical parameters for the case
  `plot_singlePanels = TRUE`. This caused a regression in the plot
  output from `analyse_FadingMeasurement()` (#589).

### `sort_RLum()`

- The function doesn’t crash when multiple fields are specified,
  although the actual sort at the moment occurs only on the first field
  (#606).

- Attempting to sort an empty object returns the object itself instead
  of crashing (#608).

------------------------------------------------------------------------

# Changes in version 1.0.0 (2025-02-21)

## New functions

- `apply_Crosstalk()`, `calc_MoransI()`, `plot_SingleGrainDisc()` and
  `plot_MoranScatterplot()` were contributed by Anna-Maartje de Boer and
  Luc Steinbuch (#560). An introductory example on how to use these
  functions is available by executing `vignette("crosstalk")`.

- `calc_EED_Model()` models incomplete and heterogeneous bleaching of
  mobile grains after Guibert et al. (2017). Along with the function,
  the new `ExampleData.MortarData` data set was added.

- `fit_DoseResponseCurve()` and `plot_DoseResponseCurve()` are two new
  functions derived from `plot_GrowthCurve()`: the first only performs
  the fitting of a dose-response curve, while the second plots it. This
  brings greater flexibility and increased speed, as plotting is now
  independent of fitting (#141, fixed in \#318).

- `melt_RLum()`: Creates a new flat `data.frame` that can be used for
  instance in combination with `'ggplot2'`. It works only on
  `RLum.Data.Curve-class` and `RLum.Analysis-class` objects and lists of
  such objects.

- `merge_RLum.Data.Spectrum()`: This new function allows to merge two or
  more `RLum.Data.Spectrum` objects in different ways (#368, fixed in
  \#419).

- `add_metadata()`, `rename_metadata()`, `replace_metadata()`: These
  function allow to manipulate the metadata of `Risoe.BINfileData`,
  `RLum.Analysis` and `RLum.Data` objects (#480, fixed in \#514, \#524,
  \#525, \#527, \#534, \#545).

- `sort_RLum()`: Allows to sort the records of `RLum.Analysis` and
  `Risoe.BINfileData` objects according to a given slot or info element
  (#528, fixed in \#571 and \#576).

- `view()`: Provides a shortcut to the `utils::View()` spreadsheet-like
  data viewer tailored to the objects in the package (#489, fixed in
  \#490).

## Breaking changes

- We have dropped our dependency on the `readxl` package: functions
  `analyse_baSAR()` and `use_DRAC()` now do not accept XLS files anymore
  but CSV files instead (#237, fixed in \#270). CSV files can be easily
  generated from XLS files by Excel or similar applications, or by
  reading them with `readxl::read_excel()` and saving them with
  `write.csv()`.

- The `plot.single` option, which was available for several functions,
  sometimes under a slightly different name, has now been renamed to
  `plot_singlePanels` for overall consistency and clarity. Function
  `scale_GammaDose()` used that option but gave it the opposite meaning:
  now also this function conforms to the rest of the package. The use of
  the older names is now deprecated and will produce a warning (#351,
  fixed in \#408).

- The `NumberIterations.MC` option of `plot_GrowthCurve()` has now been
  renamed to `n.MC` for consistency with other functions. Potentially
  affected are also `analyse_Al2O3C_ITC()`, `analyse_baSAR()`,
  `analyse_SAR.CWOSL()`, `analyse_SAR.TL()`, `calc_Huntley2006()`,
  `calc_Lamothe2003()`, as they may pass that option
  `plot_GrowthCurve()` via their `...` argument. The use of the older
  name is now deprecated and will produce a warning (#546, fixed in
  \#547).

## Renamed functions and deprecations

- Function `Analyse_SAR.OSLdata()` is now officially deprecated,
  `analyse_SAR.CWOSL()` should be used instead (#216, fixed in \#264).

- Functions `CW2pHMi()`, `CW2pLM()`, `CW2pLMi()` and `CW2pPMi()` have
  been renamed to `convert_CW2pHMi()`, `convert_CW2pLM()`,
  `convert_CW2pLMi()` and `convert_CW2pPMi()`, respectively. The use of
  the older names is now deprecated and will produce a warning (#499,
  fixed in \#503).

- Function `Second2Gray()` has been renamed to `convert_Second2Gray()`
  (#498, fixed in \#500).

- Function `PSL2Risoe.BINfileData()` has been renamed to
  `convert_PSL2Risoe.BINfileData()` (#555, fixed in \#556).

## New dependencies

- We have added package `’vdiffr’` as dependency in `suggests`. The
  package enables us to automatically verify the consistency of plot
  outputs generated by package functions against reference figures
  captured earlier. Although this new dependency does not have any
  user-visible impact, it is required when building `’Luminescence’`
  from source. The primary advantage lies in the developer’s domain, as
  it ensures that modifications to functions do not inadvertently alter
  plot outputs.

## Bugfixes

### `analyse_Al2O3C_CrossTalk()`

- The function doesn’t crash anymore if option `recordType` is specified
  and none of the records in the data set is of that type (#487, fixed
  in \#488).

### `analyse_baSAR()`

- Argument `XLS_file` has been replaced by `CSV_file` and, as mentioned
  above, the function now only accepts CSV files as input (#237, fixed
  in \#270).
- Add support for `recordType` passed to `get_RLum` in the additional
  arguments.
- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).
- The function crashed if the number of MCMC iterations was set equal to
  the thinning interval; on the other hand, we saw errors reported from
  JAGS if the number of MCMC iterations was not at least double the
  thinning interval. To address this, we slightly retouched our
  automatic setting of the thinning interval (which was problematic only
  if the number of MCMC iterations was extremely low); on the other
  hand, if a user sets a thinning interval that is too high, we now
  reset it to a lower value and raise a warning (#407, fixed in \#409).
- The function crashed if a `Risoe.BINFileData` object was provided and
  the argument `irradiation_times` was set; fixed.
- The function was supposed to remove non-OSL curves from the dataset,
  but it almost never did; fixed.
- The function is more robust against input that may have been subset
  inconsistently (#517, fixed in \#518).
- The function doesn’t crash but reports more helpful messages in case
  the user overrides the default set of monitored variables using
  `variable.names` within the `method_control` argument (#521, fixed in
  \#522).

### `analyse_SAR.CWOSL()`

- The function crashed for a list input that led to `NULL` for various
  reasons (e.g., unsuitable set of curves). Here the self-call attempted
  to extract information from the results that did not exist in the
  first place instead of returning `NULL`; fixed.
- The produced `RLum.Results` object now also contains a column for the
  grain (#553, fixed in \#554).

### `analyse_FadingMeasurement()`

- The function now checks for the version of the BIN-file that
  originated the `RLum.Analysis` object given as input, and reports a
  message if a version older than 5 was used (#281, fixed in \#282).
- The function doesn’t crash anymore on some `RLum.Analysis` input files
  (#283, fixed in \#288).
- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).
- The function doesn’t crash anymore if no record is left after removal
  of records with negative time since irradiation (#454, fixed in
  \#456).
- The function has been made more robust in the calculation of rho’
  (#558, fixed in \#559).

### `analyse_IRSAR.RF()`

- The performance of this function has been improved for the “SLIDE” and
  “VSLIDE” methods, thanks both to tweaks in the C++ implementation of
  the sliding algorithm and in how that is managed on the R side. In
  particular, the default number of sliding windows tested in the
  algorithm has been reduced from 10 to 3: this value is no longer
  hardcoded, but can be tuned through the new `num_slide_windows`
  setting (part of the `method.control` option), thus allowing to find a
  balance between computation time and quality of fit (#372, fixed in
  \#388, \#398 and \#399).
- The function is more robust against `sequence_structure`
  misspecifications (#393, fixed in \#394).
- Some data preparation steps where not correctly applied for
  `method = "VSLIDE"` (#396, fixed in \#397).
- Option `method.control` has been renamed to `method_control` for
  consistency with all other functions in the package (#411, fixed in
  \#412).

### `analyse_pIRIRSequence()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).
- The produced `RLum.Results` object now also contains a column for the
  grain (#553, fixed in \#554).
- The function now checks that the `sequence.structure` argument
  contains at least one IR step (#579, fixed in \#580).

### `analyse_SAR.CWOSL()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).
- The function shifted the curves correctly in cases where the first
  channel is zero and a log-transformation on the x-axis is requested
  (#580, fixed in \#531).

### `apply_CosmicRayRamoval()`

- Support has been added for the internal function `smooth_RLum` that
  can be passed as new argument for `method`.

### `calc_AverageDose()`

- The function crashed if the data contained non-positive values: now
  these are removed before proceeding (#532, fixed in \#533).

### `calc_CentralDose()`

- Argument `na.rm` is now deprecated: the function will now always
  remove missing values, as otherwise the presence of any `NA` would
  propagate and produce unusable results (all `NA`s) or buggy behaviour
  (#302, fixed in \#304).
- The function stops the fixed-point iteration for the computation of
  the profile log-likelihood as soon as `sigma < 1e-16`, as allowing
  `sigma` to become zero leads to infinities and buggy behaviour (also
  fixed in \#304).

### `calc_FastRatio()`

- A number of crashes related to input validation have been fixed (#471,
  fixed in \#472).

### `calc_FiniteMixture()`

- Arguments `dose.scale` and `pdf.scale` were not used and have been
  removed (#566, fixed in \#567).

### `calc_gSGC()`

- The function crashed if the data contained negative errors: to avoid
  this, we now take the absolute values of errors (#479, fixed in
  \#481).

### `calc_Huntley2006()`

- Some crashes in case of model misspecification have been solved (#538,
  fixed in \#539).
- Some details in the implementation of the function have been
  optimized, and now it is much faster than before. As part of this, we
  have changed the default setting of the `rprime` vector that is used
  in the calculation of the natural dose response and the field
  saturation, so that more points are concentrated in the bulk of the
  distribution: this previously depended incorrectly on the number of
  Monte Carlo iterations requested, so this change brings an additional
  speed boost. The default setting can be overridden via the `rprime`
  argument (#258, fixed in \#541 and \#542).
- Fitting the “GOK” model on the unfaded data failed when the “EXP”
  model we use to find a good starting point failed: in such cases, we
  try again using the simulated fit (#549, fixed in \#500; thanks to
  @SalOehl for reporting and providing data to reproduce the error).
- The natural/simulated curve was not plotted in the negative quadrant
  for `mode = "extrapolation"`, which made it harder to see where it
  extrapolated to (#551, fixed in \#552; thanks to @SalOehl for
  reporting).

### `calc_IEU()`

- The code of this function has been consolidated to avoid duplication
  and make its debugging easier: this has uncovered a small coding error
  and also led to some speed up (#429, fixed in \#430, \#431 and \#432).
- Some crashes in the function have been solved (#424, fixed in \#433).

### `calc_Lamothe2003()`

- We addressed a long-standing issue regarding the calculation of the
  `Ln/Tn` error after fading correction, which led to smaller than
  expected errors (#96, fixed in \#296).

### `convert_RLum2Risoe.BINFileData()`

- The function could crash with a
  `incompatible types (from raw to character)` error under particular
  circumstances; fixed.
- The function would fail in edge cases where different objects are
  mixed so that certain fields for `METADATA` are already available but
  in the wrong format; fixed.

### `extract_IrradiationTimes()`

- In some circumstances the function failed to update an existing
  BIN/BINX file due to an incorrect way of subsetting an intermediate
  data frame of results (#445, fixed in \#446).
- The function crashed if the info element `startDate` was missing in
  the irradiation curve; fixed.

### `fit_CWCurve()`

- The function crashed if the computation of the confidence intervals
  done in `confint()` failed. This has now been fixed, and in cases of
  failures we report the error message received from `confint()` (#509,
  fixed in \#510).
- Argument `output.terminal` has been renamed to `verbose` for
  consistency with other functions.
- The function has gained the new `method_control` argument, which can
  be used to control the saving of the component contribution matrix in
  the RLum.Results object it returns. This is now disabled by default:
  to restore the previous behaviour, add
  `method_control = list(export.comp.contrib.matrix = TRUE)` to the
  function call (fixed in \#573).
- In case of plot failure the function now is able to recover gracefully
  and produce an output object (#574, fixed in \#578).

### `fit_EmissionSpectra()`

- The function can now return a data frame with the values of all curves
  plotted, so that it’s much easier to produce alternative plots, by
  setting option `export.plot.data = TRUE` within the `method_control`
  argument (#569, fixed in \#570 and \#573).

### `fit_LMCurve()`

- The function has gained the new `method_control` argument, which can
  be used to control the saving of the component contribution matrix in
  the RLum.Results object it returns. This is now disabled by default:
  to restore the previous behaviour, add
  `method_control = list(export.comp.contrib.matrix = TRUE)` to the
  function call (fixed in \#573).
- In case of plot failure the function now is able to recover gracefully
  and produce an output object (#574, fixed in \#578; thanks to @LumTKO
  for reporting).

### `get_RLum()`

- If the `subset` option was used on info elements of an `RLum.Analysis`
  object, it would return wrong results if the info element was not
  present in all records; fixed.

### `import_Data()`

- The function automatically determines the available import functions
  and ensures that formats supported by the package are tested and used.
- A minor change in the code enables the support of `character` vectors
  of length \> 1 as input (e.g., different file names). Furthermore, the
  function received more testing against a mixture of input formats.
  Therefore you can provide many different files formats and the
  function will try to import them all in one go.

### `plot_AbanicoPlot()`

- If negative values were provided, the function sometimes produced
  wrong plots for `z.log = TRUE` (the default); fixed.
- Support for `tcl` and `tck` arguments via `...` was removed as they
  were never used internally.

### `plot_DetPlot()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).

### `plot_DRTResults()`

- The function crashed if option `na.rm` was used alongside the
  `preheat` option but the data set contained no missing values (#474,
  fixed in \#475).

### `plot_GrowthCurve()`

- The function is now implemented as a wrapper around
  `fit_DoseResponseCurve()` and `plot_DoseResponseCurve()`. There should
  be no visible user-facing changes (#319, fixed in \#322).
- Support new `...` arguments for plotting (implementation in
  `plot_DoseResponseCurve()`) for `legend` (turn on/off legend) and
  `reg_points_pch` for fine grained control over the point shape.
- Add `density_polygon`, `density_polygon_col`, `density_rug`, `box` as
  `...` arguments to plot and add respective plot options
- The function crashed for single grain data that sometimes caused a lot
  of `NaN` values during log conversions required for estimating the
  start parameters. The result was the error `object 'b.MC' not found`
  (#374; fixed)
- For the non-linear choices of `fit.method` (`"EXP+LIN"`, `"EXP+EXP"`,
  `"GOK"` and `"LambertW"`), the function could get stuck in an endless
  loop when the number of parameters was larger than or equal to the
  number of data points. This is now checked, and in those cases the
  method is changed to `"LIN"` (#381, fixed in \#465).
- We replaced `nls()` with `minpack.lm::nlsLM()` as it’s more robust and
  can find a fit in cases where `nls()` would fail. Please keep in mind
  that it does not mean that fit results in those cases make any sense,
  it just helps to avoid uncontained events in the R session (addresses
  \#381).
- Option `output.plotExtended.single` has been renamed to
  `plot_singlePanels` (#351, fixed in \#408).
- The function now supports a list of data frames as input, in which
  case it calls itself on each element of the list and produces a list
  of `RLum.Results` as output (#405, fixed in \#434).
- The function reported negative dose values in the MC runs plot when
  using `fit.method = "QDR"` and `mode = "extrapolation"` (#504, fixed
  in \#505).
- Argument `NumberIterations.MC` has been renamed to `n.MC` (#546, fixed
  in \#547).

### `plot_RLum.Analysis()`

- Option `plot.single` has been renamed to `plot_singlePanels` (#351,
  fixed in \#408).

### `plot_RLum.Data.Curve()`

- Argument `norm` is now better validated so that specifying an
  incorrect value returns an error instead of silently skipping curve
  normalisation (#250, fixed in \#263).

### `plot_RLum.Data.Spectrum()`

- The gradient between colours when `plot.type = "persp"` is now more
  consistent and doesn’t produce artefacts in the regions of transition
  between colours (#371, fixed in \#380).
- The function would crash if the `bin.rows` or `bin.cols` value was set
  too high or if `xlim` and `ylim` were set too tight (#415, fixed in
  \#416).

### `read_BIN2R()`

- The function is now much faster: we have recorded an overall
  improvement of over 60% on a 46M file, with potentially bigger time
  savings for larger files (#298, fixed in \#333, \#355 and \#360).
- Argument `n.records` is now better supported for BIN files v3 and v4
  and doesn’t lead to a crash when used in conjunction with the
  `fastForward` option (#343, fixed in \#344).
- Argument `zero_data.rm` was not correctly propagated if the input
  object was provided as a list (#342, fixed in \#345).
- The `METADATA` fields that are not actually read from the BINX file in
  case of a ROI record are now set to `NA` rather than being assigned
  the value from the previous record (#336, fixed in \#360).
- The `.RESERVED` slot is now kept in sync with the rest of the object
  when records are dropped from the input BIN/BINX file (#337, fixed in
  \#348).
- The function doesn’t crash anymore when reading a file that contains a
  record with an unrecognised version after other records with a valid
  version have been read (#352, fixed in \#353).
- The function doesn’t crash anymore when reading a file that contains a
  ROI record while using `fastForward = TRUE` (#356, fixed in \#360).

### `read_HeliosOSL2R()`

- If the function encounters problems in the provided list of files, it
  shows a more relaxed handling; throws an error but continues reading.

### `read_XSYG2R()`

- The new `n_records` argument now enables to control the number of
  records to import, which can be useful in case the file is faulty.
- The function failed to import files when a directory name was
  provided; this was a regression introduced in v0.9.25 and it has now
  been fixed.
- The function truncated the terminal output under certain
  circumstances; fixed.

### `scale_GammaDose()`

- Option `plot_single` has been renamed to `plot_singlePanels` and was
  changed so that `plot_singlePanels = TRUE` will produce one plot per
  panel, for consistency with other functions (#351, fixed in \#408).

### `template_DRAC()`

- The function gained a new argument `file_input` that enables the
  creating of a DRAC template based on an existing DRAC CSV file. This
  way, already available DRAC files can be conveniently modified without
  having to call `use_DRAC()` first.
- The template contained a couple of minor mistakes that got fixed along
  with a more strict enforcement of the class of each field, which is
  now set as an attribute; the change should have no user-visible
  effect.
- The function now supports the conversion factors by Cresswell et
  al. (2018) (`Cresswelletal2018`). Please ensure that the server
  supports that option.

### `trim_RLum.Data()`

- The function has been made more robust against misspecifications of
  its `trim_range` argument that could lead to crashes (#460, fixed in
  \#461).

### `use_DRAC()`

- Support for DRAC v1.1 XLS/XLSX files has been dropped, users should
  use CSV files according to the DRAC v1.2 CSV template.
- The function gained support for three new `...` arguments:
  `version_ignore` to ignore the DRAC version check, `user` and
  `password` to access password protected websites.
- The identifiers submitted to the DRAC server are now better randomized
  to to guarantee more confidentiality of the data transmitted (#435,
  fixed in \#438).

### `verify_SingleGrainData()`

- **Potentially breaking old code!**: if `cleanup = TRUE` the result was
  not consistent and produced a mixture of `RLum.Results` and
  `RLum.Analysis`/`Risoe.BINFileData` objects in particular when run
  over a list, this was not what stated in the manual. Now the function
  indeed cleans up the object, hence if a list of `RLum.Analysis`
  objects is provided, the result is a cleaned list of that object. If
  the clean-up ends up removing everything, the result is `NULL`.
- The function doesn’t crash anymore when applied to an empty list
  (#365, fixed in \#366).
- Silence the very talkative terminal output even if nothing was removed
  from a record for `cleanup = TRUE`.
- The function now provides better terminal feedback if the selection
  results in an empty record.
- Add a new logical argument `use_fft` that will apply an additional
  Fast Discrete Fourier Transform (FFT) verification on the data if
  wanted.

### `write_R2BIN()`

- The function now supports the `verbose` argument, which can be used to
  suppress output to the terminal (#442, fixed in \#444).

------------------------------------------------------------------------

# Changes in version 0.9.26 (2024-11-18)

## Removed functions

- Function `calc_Kars2008()` (deprecated since version 0.8.1) is now
  officially defunct, `calc_Huntley2006()` should be used instead (#252,
  fixed in \#257).

## Bugfixes

### `analyse_pIRIRSequence()`

- The function crashed with a object merge error if run in a loop
  because of a `merge_RLum()` error. This was caused by a regression
  while implementing the `n_N` calculation in `plot_GrowthCurve()`.
  Potentially affected was also `analyse_SAR.CWOSL()`.
- The function now shows a warning and sets `plot = FALSE` when option
  `plot.single = FALSE` is set but the device size is too small. This
  should prevent “Figure margins too large” errors.
- The function will not crash anymore during the plotting in another
  edge case related to single grain data.

### `analyse_SAR.CWOSL()`

- The function crashed for mixed set of `RLum.Analysis-class` objects
  typically observed for single grain data, e.g., one object contains
  only TL curves while all others contain the OSL/IRSL data from the
  grain. As the function filters those records automatically, it crashed
  because the aliquot number assignment internally relied on the length
  of the object (regression, \#373, fixed)

### `analyse_SAR.TL()`

- The function now produces a more correct `rejection.criteria` data
  frame (#245, fixed in \#246).
- Several edge cases that led to crashes have been fixed (#147, fixed in
  \#247).

### `get_RLum()`

- When the function was used on a list of `RLum.Analysis-class` objects
  with the argument `null.rm = TRUE` it would remove all `NULL` objects,
  but not elements that became `list()` (empty list) during the
  selection; fixed.
- Fix an edge case that caused a rather non-expected, more visible
  output problem. When curves were selected via `recordType` on
  `RLum.Analysis-class` objects (or a list of them) containing only a
  single `RLum.Data-class` object, the function returned the
  `RLum.Data.Curve-class` object *regardless* of the selection in
  `recordType`. In other words: if a user tried `recordType = "TL"` on
  an `RLum.Analysis-class` object that contained only a single IRSL
  curve, the function would still return that single IRSL curve instead
  of an empty element. The reason for this behaviour was a poor attempt
  to deal with `NA` in the `recordType` name that led to missing values
  and unexpected behaviour for a logical comparison. Now, before the
  subset happens, `NA` values in `recordType` are converted to `"NA"` (a
  character), allowing us to fix the incorrect subsetting.

### `plot_RLum.Data.Spectrum()`

- Add support for `lphi` and `ltheta` light direction arguments for
  `plot.type = "persp"`.
- Fix the reason for the unclear warning
  `In col.unique == col :  longer object length is not a multiple of shorter object length`

### `write_R2BIN()`

- Recently, non-ASCII characters in comments or file names have become
  more common and that led to crashes during the file export. To avoid
  this, now all non-ASCII characters are replaced by `_` before writing
  them to the BIN/BINX files.
- The function now returns the file path of the export.
- Fix a bug that left connections open if the function crashed.

## Internals

- Two new internal functions `.throw_warning()` and `.throw_error()`
  sometimes flushed the terminal with messages if called (internally) in
  particular circumstances. Now we maintain a stack of function names,
  so that at any time we can report correctly the name of the function
  where an error or a warning is thrown (#254, fixed in \#256).

------------------------------------------------------------------------

# Changes in version 0.9.25 (2024-09-12)

**This package version requires R \>= 4.3**

## New functions

- `read_HeliosOSL2R()`: New import function to support the new zero rad
  Helios luminescence reader and its `.osl` file format. The output is
  an `RLum.Analysis-class` object.

## Bugfixes

### `analyse_baSAR()`

- Fix \#183 addressing an edge-case crash when the function was called
  on an object containing no records of the appropriate type (#184,
  @mcol).

### `analyse_FadingMeasurements()`

- Add `...` support to disable the blue trend line via
  `plot.trend = FALSE`
- Fix \#175 to deal gracefully with the case when the size of Lx and Tx
  doesn’t match (#192, @mcol).

### `analyse_portableOSL()`

- Function did not respect argument `main`; fixed.

### `convert_Wavelength2Energy()`

- Fix \#133 addressing cases where R throws an uncontained error when R
  drops the object structure in very rare cases (#134; thanks @mcol)

### `calc_Huntley2006()`

- Improve success rate of GOK fitting of the unfaded data using a two
  step approach: first an exponential fit is applied then this values
  are used as start parameters.

### `calc_Statistics()`

- The skewness and kurtosis depended on number of MC samples (#122);
  fixed with \#123 (thanks to @mcol)

### `calc_TLLxTxRatio()`

- Function crashed for `Tx.data.background = NULL` (#129); fixed with
  \#130 thanks to @mcol

### `calc_WodaFuchs2008()`

- The function now officially supports numeric vectors and single-column
  data frames as input (#200).
- The function computed the number of breaks for the histogram
  incorrectly (#197, fixed with \#198).
- The function now supports more types of `RLum.Results` objects without
  crashing, although if the object contains only one data point it will
  stop immediately to avoid problems with `nls()` (#199, fixed in
  \#219).

### `extract_IrradiationTimes()`

- If a BIN/BINX-file is provided, the function will now check that it
  contains the same amount of data as the corresponding XSYG file a bit
  earlier than before, thus avoiding a possible crash (#228, fixed in
  \#229).

### `fit_CWCurve()`

- Argument `output.path` has been removed, and a warning is raised when
  attempting to use it (#207, fixed in \#209).

### `fit_EmissionSpectra()`

- Parameter `input_scale` was not correctly propagated when the function
  would self-call (#160, @mcol).

### `fit_OSLLifeTimes()`

- The validation of the minimum dataset size didn’t account for the use
  of the `signal.range` argument (#182, fixed by \#195, @mcol).

### `fit_SurfaceExposure()`

- Fix \#162 to remove a dimension mismatch if the input data contained
  `NA`s, which would generate unexpected warnings (#163, @mcol).
- The function doesn’t stop anymore with an error if called on an
  `RLum.Results` object (#165, @mcol).

### `plot_AbanicoPlot()`

- Argument `plot.ratio` will now throw an error on non-positive
  numerical values (#221, fixed in \#222).
- The function doesn’t crash anymore when setting `interactive = TRUE`
  (#220, fixed in \#233).

### `plot_DetPlot()`

- Argument `signal.integral.max` is now enforced to be greater than
  `signal.integral.min`, as otherwise the computation of the number of
  channels would produce `Inf` (#203, fixed in \#206).
- Fix a crash when using option
  `analyse_function = "analyse_pIRIRSequence"` (#210, fixed in \#211).

### `plot_GrowthCurve()`

- The function now calculates the relative saturation (`n/N`) using the
  ratio of the two integrates. The value is part of the output table.
- Argument `na.rm` has been removed: as of version 0.9.23, it was
  defunct and only accepted `TRUE` as valid value and produced an error
  otherwise, so there is no effective change in behaviour (#137, fixed
  in \#214).

### `plot_Histogram()`

- The function doesn’t crash anymore when setting `interactive = TRUE`
  (#186, fixed in \#231).

### `plot_KDE()`

- It now officially supports numeric vectors and single-column data
  frames, for which it assumes that the De error at each measurement is
  10^-9 (#189, fixed in \#194, @mcol).

### `plot_NRt()`

- The function reports an helpful message rather than crashing when
  applied to an object of unexpected type or when there is a mismatch in
  time values (#177, fixed with \#179 by @mcol).

### `plot_RadialPlot()`

- The function doesn’t crash anymore when a single-column data frame is
  provided (#191, fixed in \#212).

### `plot_RLum.Data.Analysis()`

- The function now supports all arguments from
  `plot_RLum.Data.Spectrum()`; before it had only basic functionality
  for `RLum.Data.Spectrum-class` data.

### `plot_RLum.Data.Spectrum()`

- The plot function can now handle non-increasing column values for
  plotting (with a warning).

### `read_BIN2R()`

- `ignore.RECTYPE` now supports numeric values, e.g., 128. Records for
  this type will be ignored during import.
- BINX-files with `RECTYPE = 128` will not crash anymore, thanks for
  asking Anna-Maartje Boer and replying Karsten Bracht.
- The function now stops graciously when attempting to read an empty
  file (#225, fixed in \#226).

### `read_PSL2R()`

- The function is out of the beta status, hence the flag was removed.
- The `RLum.Analysis-class` object returned by the function gained a new
  element `Sequence`, which is a data frame. with the measured sequence.
  This way, if the original sequence was lost, it can still be extracted
  from the `.psl` data.
- If no `.psl` file was found the function got trapped in an infinite
  loop (#127); fixed with \#128 (thanks to @mcol)

### `read_XSYG2R()`

- Fix spectrometer data import for basically broken files.

### `read_Daybreak2R()`

- Fix \#135 to improve detection of non-ASCII files (#140, @mcol).

### `Risoe.BINfileData2RLum.Analysis()`

- Fix a crash when reading an empty Risoe.BINfileData input (#215, fixed
  in \#224).

## Internals

- New internal function + tests added `.get_named_list_element()`. It
  just does what the names says.
