% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merPlots.R
\name{plotREsim}
\alias{plotREsim}
\title{Plot the results of a simulation of the random effects}
\usage{
plotREsim(
  data,
  level = 0.95,
  stat = "median",
  sd = TRUE,
  sigmaScale = NULL,
  oddsRatio = FALSE,
  labs = FALSE,
  facet = TRUE
)
}
\arguments{
\item{data}{a data.frame generated by \code{\link{REsim}} with simulations of
the random effects of a \code{\link{merMod}}}

\item{level}{the width of the confidence interval}

\item{stat}{a character value indicating the variable name in data of the
midpoint of the estimated interval, e.g. "mean" or "median"}

\item{sd}{a logical indicating whether or not to plot error bars around
the estimates (default is TRUE). Calculates the width of the error bars
based on \code{level} and the variable named "sd" in \code{data}}

\item{sigmaScale}{a numeric value to divide the estimate and the standard
deviation by in the case of doing an effect size calculation}

\item{oddsRatio}{logical, should the parameters be converted to odds ratios
before plotting}

\item{labs}{logical, include the labels of the groups on the x-axis}

\item{facet}{Accepts either logical (\code{TRUE}) or \code{list} to specify which
random effects to plot. If \code{TRUE}, facets by both \code{groupFctr} and \code{term}.
If \code{list} selects the panel specified by the named elements of the list}
}
\value{
a ggplot2 plot of the coefficient effects
}
\description{
Plot the simulated random effects on a ggplot2 chart. Points that
are distinguishable from zero (i.e. the confidence band based on \code{level}
does not cross the red line) are highlighted. Currently, the plots are ordered
according to the grouping factor.
}
\examples{
\donttest{
 fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
 (p1 <- plotREsim(REsim(fm1)))
 #Plot just the random effects for the Days slope
 (p2 <- plotREsim(REsim(fm1), facet= list(groupFctr= "Subject", term= "Days")))
 }
}
