% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_manipulate.R
\name{ph_hyperlink}
\alias{ph_hyperlink}
\title{Hyperlink a placeholder}
\usage{
ph_hyperlink(x, type = "body", id = 1, id_chr = NULL, ph_label = NULL, href)
}
\arguments{
\item{x}{an rpptx object}

\item{type}{placeholder type}

\item{id}{placeholder index (integer) for a duplicated type. This is to be used when a placeholder
type is not unique in the layout of the current slide, e.g. two placeholders with type 'body'. To
add onto the first, use \code{id = 1} and \code{id = 2} for the second one.
Values can be read from \code{\link{slide_summary}}.}

\item{id_chr}{deprecated.}

\item{ph_label}{label associated to the placeholder. Use column
\code{ph_label} of result returned by \code{\link{slide_summary}}.}

\item{href}{hyperlink (do not forget http or https prefix)}
}
\description{
Add hyperlink to a placeholder in the current slide.
}
\examples{
fileout <- tempfile(fileext = ".pptx")
loc_manual <- ph_location(bg = "red", newlabel= "mytitle")
doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(x = doc, "Un titre 1", location = loc_manual)
slide_summary(doc) # read column ph_label here
doc <- ph_hyperlink(x = doc, ph_label = "mytitle",
  href = "https://cran.r-project.org")

print(doc, target = fileout )
}
\seealso{
\code{\link{ph_with}}

Other functions for placeholders manipulation: 
\code{\link{ph_remove}()},
\code{\link{ph_slidelink}()}
}
\concept{functions for placeholders manipulation}
