% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{stri_sort_key}
\alias{stri_sort_key}
\title{Sort Keys}
\usage{
stri_sort_key(str, ..., opts_collator = NULL)
}
\arguments{
\item{str}{a character vector}

\item{...}{additional settings for \code{opts_collator}}

\item{opts_collator}{a named list with \pkg{ICU} Collator's options,
see \code{\link{stri_opts_collator}}, \code{NULL}
for default collation options}
}
\value{
The result is a character vector with the same length as \code{str} that
contains the sort keys. The output is marked as \code{bytes}-encoded.
}
\description{
This function computes a locale-dependent sort key, which is an alternative
character representation of the string that, when ordered in the C locale
(which orders using the underlying bytes directly), will give an equivalent
ordering to the original string. It is useful for enhancing algorithms
that sort only in the C locale (e.g., the \code{strcmp} function in libc)
with the ability to be locale-aware.
}
\details{
For more information on \pkg{ICU}'s Collator and how to tune it up
in \pkg{stringi}, refer to \code{\link{stri_opts_collator}}.

See also \code{\link{stri_rank}} for ranking strings with a single character
vector, i.e., generating relative sort keys.
}
\examples{
stri_sort_key(c('hladny', 'chladny'), locale='pl_PL')
stri_sort_key(c('hladny', 'chladny'), locale='sk_SK')

}
\references{
\emph{Collation} - ICU User Guide,
\url{https://unicode-org.github.io/icu/userguide/collation/}
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other locale_sensitive: 
\code{\link{\%s<\%}()},
\code{\link{about_locale}},
\code{\link{about_search_boundaries}},
\code{\link{about_search_coll}},
\code{\link{stri_compare}()},
\code{\link{stri_count_boundaries}()},
\code{\link{stri_duplicated}()},
\code{\link{stri_enc_detect2}()},
\code{\link{stri_extract_all_boundaries}()},
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_opts_collator}()},
\code{\link{stri_order}()},
\code{\link{stri_rank}()},
\code{\link{stri_sort}()},
\code{\link{stri_split_boundaries}()},
\code{\link{stri_trans_tolower}()},
\code{\link{stri_unique}()},
\code{\link{stri_wrap}()}
}
\concept{locale_sensitive}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
