% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-no-condition.R
\name{expect_no_error}
\alias{expect_no_error}
\alias{expect_no_warning}
\alias{expect_no_message}
\alias{expect_no_condition}
\title{Does code run without error, warning, message, or other condition?}
\usage{
expect_no_error(object, ..., message = NULL, class = NULL)

expect_no_warning(object, ..., message = NULL, class = NULL)

expect_no_message(object, ..., message = NULL, class = NULL)

expect_no_condition(object, ..., message = NULL, class = NULL)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{...}{These dots are for future extensions and must be empty.}

\item{message, class}{The default, \verb{message = NULL, class = NULL},
will fail if there is any error/warning/message/condition.

In many cases, particularly when testing warnings and messages, you will
want to be more specific about the condition you are hoping \strong{not} to see,
i.e. the condition that motivated you to write the test.  Similar to
\code{expect_error()} and friends, you can specify the \code{message} (a regular
expression that the message of the condition must match) and/or the
\code{class} (a class the condition must inherit from). This ensures that
the message/warnings you don't want never recur, while allowing new
messages/warnings to bubble up for you to deal with.

Note that you should only use \code{message} with errors/warnings/messages
that you generate, or that base R generates (which tend to be stable).
Avoid tests that rely on the specific text generated by another package
since this can easily change. If you do need to test text generated by
another package, either protect the test with \code{skip_on_cran()} or
use \code{expect_snapshot()}.}
}
\description{
These expectations are the opposite of \code{\link[=expect_error]{expect_error()}},
\code{expect_warning()}, \code{expect_message()}, and \code{expect_condition()}. They
assert the absence of an error, warning, or message, respectively.
}
\examples{
expect_no_warning(1 + 1)

foo <- function(x) {
  warning("This is a problem!")
}

# warning doesn't match so bubbles up:
expect_no_warning(foo(), message = "bananas")

# warning does match so causes a failure:
try(expect_no_warning(foo(), message = "problem"))
}
