/*	mygtk.c
	Copyright (C) 2004-2007 Mark Tyler and Dmitry Groshev

	This file is part of rgbPaint.

	rgbPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	rgbPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with rgbPaint in the file COPYING.
*/

#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "global.h"
#include "memory.h"
#include "png.h"
#include "mainwindow.h"
#include "mygtk.h"


///	GENERIC WIDGET PRIMITIVES

GtkWidget *add_a_spin( int value, int min, int max )
{
	GtkWidget *spin;
	GtkObject *adj;

	adj = gtk_adjustment_new( value, min, max, 1, 10, 10 );
	spin = gtk_spin_button_new( GTK_ADJUSTMENT (adj), 1, 0 );
	gtk_widget_show(spin);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin), TRUE);

	return spin;
}

GtkWidget *add_a_table( int rows, int columns, int bord, GtkWidget *box )
{
	GtkWidget *table = gtk_table_new(rows, columns, FALSE);
	gtk_widget_show(table);
	gtk_box_pack_start(GTK_BOX(box), table, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (table), bord);

	return table;
}

GtkWidget *add_to_table(char *text, GtkWidget *table, int row, int column, int spacing)
{
	GtkWidget *label;

	label = gtk_label_new ( text );
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table), label, column, column+1, row, row+1,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), spacing, spacing);
	gtk_label_set_justify(GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment(GTK_MISC (label), 0.0, 0.5);

	return label;
}

GtkWidget *spin_to_table(GtkWidget *table, int row, int column, int spacing,
	int value, int min, int max)
{
	GtkWidget *spin = add_a_spin( value, min, max );
	gtk_table_attach(GTK_TABLE(table), spin, column, column+1, row, row+1,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (0), 0, spacing);
	return (spin);
}




////	ALERT BOX

gint alert_result = 0;

gint alert_reply( GtkWidget *widget, gpointer data )
{
	if ( alert_result == 0 ) alert_result = (gint) data;
	if ( alert_result == 10 ) gtk_widget_destroy( widget );
	
	return FALSE;
}

int alert_box_stock( char *title, char *message, char *text1, char *text2, char *text3 )
{
	GtkWidget *alert, *buttons[3], *label;
	char *butxt[3] = {text1, text2, text3};
	gint i;
	GtkAccelGroup* ag = gtk_accel_group_new();

	alert = gtk_dialog_new();
	gtk_window_set_title( GTK_WINDOW(alert), title );
	gtk_window_set_modal( GTK_WINDOW(alert), TRUE );
	gtk_window_set_position( GTK_WINDOW(alert), GTK_WIN_POS_CENTER );
	gtk_container_set_border_width( GTK_CONTAINER(alert), 6 );
	gtk_signal_connect( GTK_OBJECT(alert), "destroy",
			GTK_SIGNAL_FUNC(alert_reply), (gpointer) 10 );
	
	label = gtk_label_new( message );
	gtk_label_set_line_wrap( GTK_LABEL(label), TRUE );
	gtk_box_pack_start( GTK_BOX(GTK_DIALOG(alert)->vbox), label, TRUE, FALSE, 8 );
	gtk_widget_show( label );

	for ( i=0; i<=2; i++ )
	{
		if ( butxt[i] )
		{
			buttons[i] = gtk_button_new_from_stock(butxt[i]);
			gtk_widget_show( buttons[i] );
			gtk_box_pack_start( GTK_BOX(GTK_DIALOG(alert)->action_area),
				buttons[i], TRUE, TRUE, 4 );
			//add_a_button( butxt[i], 2, GTK_DIALOG(alert)->action_area, TRUE );
			gtk_signal_connect( GTK_OBJECT(buttons[i]), "clicked",
				GTK_SIGNAL_FUNC(alert_reply), (gpointer) (i+1) );
		}
	}
	gtk_widget_add_accelerator (buttons[0], "clicked", ag, GDK_Escape, 0, (GtkAccelFlags) 0);

	gtk_window_set_transient_for( GTK_WINDOW(alert), GTK_WINDOW(main_window) );
	gtk_widget_show(alert);
	alert_result = 0;
	gtk_window_add_accel_group(GTK_WINDOW(alert), ag);

	while ( alert_result == 0 ) gtk_main_iteration();
	if ( alert_result != 10 ) gtk_widget_destroy( alert );

	return alert_result;
}

// Slider-spin combo (practically a new widget class)

GtkWidget *mt_spinslide_new(gint swidth, gint sheight)
{
	GtkWidget *slider;
	GtkObject *adj;

	adj = gtk_adjustment_new(0, 0, 1, 1, 10, 0);

	slider = gtk_hscale_new(GTK_ADJUSTMENT(adj));
	gtk_widget_show(slider);
	gtk_widget_set_usize(slider, swidth, sheight);
	gtk_scale_set_draw_value(GTK_SCALE(slider), FALSE);
	gtk_scale_set_digits(GTK_SCALE(slider), 0);

	return slider;
}

void mt_spinslide_set_range(GtkWidget *spinslide, gint minv, gint maxv)
{
	GtkAdjustment *adj;
	
	adj = gtk_range_get_adjustment(GTK_RANGE(spinslide));
	adj->lower = minv;
	adj->upper = maxv;
	gtk_adjustment_changed(adj);
}

void mt_spinslide_set_value(GtkWidget *spinslide, gint value)
{
	gtk_adjustment_set_value( GTK_HSCALE(spinslide)->scale.range.adjustment, value );
}

void mt_spinslide_connect(GtkWidget *spinslide, GtkSignalFunc handler, gpointer user_data)
{
	gtk_signal_connect(GTK_OBJECT(GTK_HSCALE(spinslide)->scale.range.adjustment),
			"value_changed", handler, user_data);
}


// Easier way with spinbuttons

int read_spin(GtkWidget *spin)
{
	/* Needed in GTK+2 for late changes */
	gtk_spin_button_update(GTK_SPIN_BUTTON(spin));
	return (gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)));
}

GtkWidget *add_float_spin(double value, double min, double max)
{
	GtkWidget *spin;
	GtkObject *adj;

	adj = gtk_adjustment_new(value, min, max, 1, 10, 10);
	spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 2);
	gtk_widget_show(spin);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin), TRUE);

	return (spin);
}

/* void handler(GtkAdjustment *adjustment, gpointer user_data); */
void spin_connect(GtkWidget *spin, GtkSignalFunc handler, gpointer user_data)
{
	GtkAdjustment *adj;
	
	adj = gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spin));
	gtk_signal_connect(GTK_OBJECT(adj), "value_changed", handler, user_data);
}

// Wrapper for utf8->C translation

char *gtkncpy(char *dest, const char *src, int cnt)
{
	char *c = g_locale_from_utf8((gchar *)src, -1, NULL, NULL, NULL);
	if (c)
	{
		strncpy(dest, c, cnt);
		g_free(c);
	}
	else strncpy(dest, src, cnt);

	return (dest);
}


// Whatever is needed to move mouse pointer 

#if defined GDK_WINDOWING_X11 /* Call X */

#include <X11/Xlib.h>
#include <gdk/gdkx.h>

int move_mouse_relative(int dx, int dy)
{
	XWarpPointer(GDK_WINDOW_XDISPLAY(drawing_canvas->window),
		None, None, 0, 0, 0, 0, dx, dy);
	return (TRUE);
}

#elif defined GDK_WINDOWING_WIN32 /* Call GDI */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

int move_mouse_relative(int dx, int dy)
{
	POINT point;
	if (GetCursorPos(&point))
	{
		SetCursorPos(point.x + dx, point.y + dy);
		return (TRUE);
	}
	else return (FALSE);
}

#elif (GTK_MINOR_VERSION >= 8) /* GTK+ 2.8+ */

int move_mouse_relative(int dx, int dy)
{
	gint x0, y0;
	GdkScreen *screen;
	GdkDisplay *display = gtk_widget_get_display(drawing_canvas);

	gdk_display_get_pointer(display, &screen, &x0, &y0, NULL);
	gdk_display_warp_pointer(display, screen, x0 + dx, y0 + dy);
	return (TRUE);
}

#else /* Always fail */

int move_mouse_relative(int dx, int dy)
{
	return (FALSE);
}

#endif

// Whatever is needed to map keyval to key

guint real_key(GdkEventKey *event)
{
	return (event->hardware_keycode);
}

guint keyval_key(guint keyval)
{
	GdkDisplay *display = gtk_widget_get_display(drawing_canvas);
	GdkKeymap *keymap = gdk_keymap_get_for_display(display);
	GdkKeymapKey *key;
	gint nkeys;

	if (!gdk_keymap_get_entries_for_keyval(keymap, keyval, &key, &nkeys))
	{
#ifdef GDK_WINDOWING_WIN32
		/* Keypad numbers need specialcasing on Windows */
		if ((keyval >= GDK_KP_0) && (keyval <= GDK_KP_9))
			return(keyval - GDK_KP_0 + VK_NUMPAD0);
#endif
		return (0);
	}
	if (!nkeys) return (0);
	keyval = key[0].keycode;
	g_free(key);
	return (keyval);
}

