#!/bin/bash

cat > test_main.rs << 'TESTEOF'
fn main() {
    use microformats_types::Document;
    use microformats_parser::parse_document;

    let html = std::fs::read_to_string("test_language_support.html").expect("Failed to read HTML");
    
    match parse_document(&html, "http://example.com") {
        Ok(document) => {
            println!("Parsed document: {:?}", document);
            
            for (i, item) in document.items.iter().enumerate() {
                println!("\n=== Item {} ===", i);
                println!("Type: {:?}", item.r#type);
                println!("Language: {:?}", item.lang);
                
                for (prop_name, prop_values) in &item.properties {
                    println!("Property '{}':", prop_name);
                    for (j, value) in prop_values.iter().enumerate() {
                        println!("  Value {}: {:?}", j, value);
                        
                        // Check if fragments have language
                        if let microformats_types::PropertyValue::Fragment(fragment) = value {
                            println!("    Fragment lang: {:?}", fragment.lang);
                        }
                    }
                }
                
                for (j, child) in item.children.iter().enumerate() {
                    println!("Child {}: lang={:?}, type={:?}", j, child.lang, child.r#type);
                }
            }
        }
        Err(e) => {
            eprintln!("Parse error: {}", e);
        }
    }
}
TESTEOF

cd /home/vrgl/Code/microformats-rust/library
cargo run --bin test_main --quiet
