
use builtin;
use str;

set edit:completion:arg-completer[gpg-sq] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'gpg-sq'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'gpg-sq'= {
            cand --tofu-policy 'set the TOFU policy for a key'
            cand --options 'read options from FILE'
            cand --log-file 'write server mode logs to FILE'
            cand --default-key 'use NAME as default secret key'
            cand --encrypt-to 'encrypt to user ID NAME as well'
            cand --group 'set up email aliases'
            cand -o 'write output to FILE'
            cand --output 'write output to FILE'
            cand -z 'set compress level to N (0 disables)'
            cand --auto-key-locate 'use MECHANISMS to locate keys by mail address'
            cand -r 'encrypt for USERID'
            cand --recipient 'encrypt for USERID'
            cand -u 'use USERID to sign or decrypt'
            cand --local-user 'use USERID to sign or decrypt'
            cand -s 'make a signature'
            cand --sign 'make a signature'
            cand --clear-sign 'make a clear text signature'
            cand --clearsign '@'
            cand -b 'make a detached signature'
            cand --detach-sign 'make a detached signature'
            cand -e 'encrypt data'
            cand --encrypt 'encrypt data'
            cand --encrypt-files '@'
            cand -c 'encryption only with symmetric cipher'
            cand --symmetric 'encryption only with symmetric cipher'
            cand --store '@'
            cand -d 'decrypt data (default)'
            cand --decrypt 'decrypt data (default)'
            cand --decrypt-files '@'
            cand --verify 'verify a signature'
            cand --verify-files '@'
            cand -k 'list keys'
            cand --list-keys 'list keys'
            cand --list-public-keys '@'
            cand --list-signatures 'list keys and signatures'
            cand --list-sigs '@'
            cand --check-signatures 'list and check key signatures'
            cand --check-sigs '@'
            cand --fingerprint 'list keys and fingerprints'
            cand -K 'list secret keys'
            cand --list-secret-keys 'list secret keys'
            cand --generate-key 'generate a new key pair'
            cand --gen-key '@'
            cand --quick-generate-key 'quickly generate a new key pair'
            cand --quick-gen-key '@'
            cand --quick-add-uid 'quickly add a new user-id'
            cand --quick-adduid '@'
            cand --quick-add-key '@'
            cand --quick-addkey '@'
            cand --quick-revoke-uid 'quickly revoke a user-id'
            cand --quick-revuid '@'
            cand --quick-set-expire 'quickly set a new expiration date'
            cand --quick-set-primary-uid '@'
            cand --full-generate-key 'full featured key pair generation'
            cand --full-gen-key '@'
            cand --generate-revocation 'generate a revocation certificate'
            cand --gen-revoke '@'
            cand --delete-keys 'remove keys from the public keyring'
            cand --delete-secret-keys 'remove keys from the secret keyring'
            cand --quick-sign-key 'quickly sign a key'
            cand --quick-lsign-key 'quickly sign a key locally'
            cand --quick-revoke-sig 'quickly revoke a key signature'
            cand --sign-key 'sign a key'
            cand --lsign-key 'sign a key locally'
            cand --edit-key 'sign or edit a key'
            cand --key-edit '@'
            cand --change-passphrase 'change a passphrase'
            cand --passwd '@'
            cand --generate-designated-revocation '@'
            cand --desig-revoke '@'
            cand --export 'export keys'
            cand --send-keys 'export keys to a keyserver'
            cand --receive-keys 'import keys from a keyserver'
            cand --recv-keys '@'
            cand --search-keys 'search for keys on a keyserver'
            cand --refresh-keys 'update all keys from a keyserver'
            cand --locate-keys '@'
            cand --locate-external-keys '@'
            cand --fetch-keys '@'
            cand --show-keys '@'
            cand --export-secret-keys '@'
            cand --export-secret-subkeys '@'
            cand --export-ssh-key '@'
            cand --import 'import/merge keys'
            cand --fast-import '@'
            cand --list-config '@'
            cand --list-gcrypt-config '@'
            cand --gpgconf-list '@'
            cand --gpgconf-test '@'
            cand --list-packets '@'
            cand --export-ownertrust '@'
            cand --import-ownertrust '@'
            cand --update-trustdb 'update the trust database'
            cand --check-trustdb '@'
            cand --fix-trustdb '@'
            cand --list-trustdb '@'
            cand --dearmor '@'
            cand --dearmour '@'
            cand --enarmor '@'
            cand --enarmour '@'
            cand --print-md 'print message digests'
            cand --print-mds '@'
            cand --gen-prime '@'
            cand --gen-random '@'
            cand --server 'run in server mode'
            cand --delete-secret-and-public-keys '@'
            cand --rebuild-keydb-caches '@'
            cand --list-key '@'
            cand --list-sig '@'
            cand --check-sig '@'
            cand --show-key '@'
            cand --Monitor 'Options controlling the diagnostic output'
            cand -v 'verbose'
            cand --verbose 'verbose'
            cand --no-verbose '@'
            cand -q 'be somewhat more quiet'
            cand --quiet 'be somewhat more quiet'
            cand --no-tty '@'
            cand --no-greeting '@'
            cand --debug '@'
            cand --debug-level '@'
            cand --debug-all '@'
            cand --debug-iolbf '@'
            cand --display-charset '@'
            cand --charset '@'
            cand --no-options '@'
            cand --logger-fd '@'
            cand --logger-file '@'
            cand --debug-quick-random '@'
            cand --Configuration 'Options controlling the configuration'
            cand --homedir '@'
            cand --faked-system-time '@'
            cand --no-encrypt-to '@'
            cand --hidden-encrypt-to '@'
            cand --encrypt-to-default-key '@'
            cand --default-recipient '@'
            cand --default-recipient-self '@'
            cand --no-default-recipient '@'
            cand --ungroup '@'
            cand --no-groups '@'
            cand --compliance '@'
            cand --gnupg '@'
            cand --no-pgp2 '@'
            cand --no-pgp6 '@'
            cand --no-pgp7 '@'
            cand --no-pgp8 '@'
            cand --rfc2440 '@'
            cand --rfc4880 '@'
            cand --rfc4880bis '@'
            cand --openpgp 'use strict OpenPGP behavior'
            cand --pgp6 '@'
            cand --pgp7 '@'
            cand --pgp8 '@'
            cand --default-new-key-algo '@'
            cand --min-rsa-length '@'
            cand --always-trust '@'
            cand --trust-model '@'
            cand --photo-viewer '@'
            cand --known-notation '@'
            cand --agent-program '@'
            cand --dirmngr-program '@'
            cand --exit-on-status-write-error '@'
            cand --limit-card-insert-tries '@'
            cand --enable-progress-filter '@'
            cand --temp-directory '@'
            cand --exec-path '@'
            cand --expert '@'
            cand --no-expert '@'
            cand --no-secmem-warning '@'
            cand --require-secmem '@'
            cand --no-require-secmem '@'
            cand --no-permission-warning '@'
            cand -n 'do not make any changes'
            cand --dry-run 'do not make any changes'
            cand -i 'prompt before overwriting'
            cand --interactive 'prompt before overwriting'
            cand --default-sig-expire '@'
            cand --ask-sig-expire '@'
            cand --no-ask-sig-expire '@'
            cand --default-cert-expire '@'
            cand --ask-cert-expire '@'
            cand --no-ask-cert-expire '@'
            cand --default-cert-level '@'
            cand --min-cert-level '@'
            cand --ask-cert-level '@'
            cand --no-ask-cert-level '@'
            cand --only-sign-text-ids '@'
            cand --enable-large-rsa '@'
            cand --disable-large-rsa '@'
            cand --enable-dsa2 '@'
            cand --disable-dsa2 '@'
            cand --personal-cipher-preferences '@'
            cand --personal-digest-preferences '@'
            cand --personal-compress-preferences '@'
            cand --default-preference-list '@'
            cand --default-keyserver-url '@'
            cand --no-expensive-trust-checks '@'
            cand --allow-non-selfsigned-uid '@'
            cand --no-allow-non-selfsigned-uid '@'
            cand --allow-freeform-uid '@'
            cand --no-allow-freeform-uid '@'
            cand --preserve-permissions '@'
            cand --default-cert-check-level '@'
            cand --tofu-default-policy '@'
            cand --lock-once '@'
            cand --lock-multiple '@'
            cand --lock-never '@'
            cand --compress-algo '@'
            cand --compression-algo '@'
            cand --bzip2-decompress-lowmem '@'
            cand --completes-needed '@'
            cand --marginals-needed '@'
            cand --max-cert-depth '@'
            cand --trustdb-name '@'
            cand --auto-check-trustdb '@'
            cand --no-auto-check-trustdb '@'
            cand --force-ownertrust '@'
            cand --Input 'Options controlling the input'
            cand --multifile '@'
            cand --input-size-hint '@'
            cand --utf8-strings '@'
            cand --no-utf8-strings '@'
            cand --set-filesize '@'
            cand --no-literal '@'
            cand --set-notation '@'
            cand --sig-notation '@'
            cand --cert-notation '@'
            cand --set-policy-url '@'
            cand --sig-policy-url '@'
            cand --cert-policy-url '@'
            cand --sig-keyserver-url '@'
            cand --Output 'Options controlling the output'
            cand -a 'create ascii armored output'
            cand --armor 'create ascii armored output'
            cand --armour '@'
            cand --no-armor '@'
            cand --no-armour '@'
            cand --max-output '@'
            cand --comment '@'
            cand --default-comment '@'
            cand --no-comments '@'
            cand --emit-version '@'
            cand --no-emit-version '@'
            cand --no-version '@'
            cand --not-dash-escaped '@'
            cand --escape-from-lines '@'
            cand --no-escape-from-lines '@'
            cand --mimemode '@'
            cand --textmode 'use canonical text mode'
            cand --no-textmode '@'
            cand --set-filename '@'
            cand --for-your-eyes-only '@'
            cand --no-for-your-eyes-only '@'
            cand --show-notation '@'
            cand --no-show-notation '@'
            cand --show-session-key '@'
            cand --use-embedded-filename '@'
            cand --no-use-embedded-filename '@'
            cand --unwrap '@'
            cand --mangle-dos-filenames '@'
            cand --no-mangle-dos-filenames '@'
            cand --no-symkey-cache '@'
            cand --skip-verify '@'
            cand --list-only '@'
            cand --compress-level '@'
            cand --bzip2-compress-level '@'
            cand --disable-signer-uid '@'
            cand --ImportExport 'Options controlling key import and export'
            cand --no-auto-key-locate '@'
            cand --auto-key-import 'import missing key from a signature'
            cand --no-auto-key-import '@'
            cand --auto-key-retrieve '@'
            cand --no-auto-key-retrieve '@'
            cand --include-key-block 'include the public key in signatures'
            cand --no-include-key-block '@'
            cand --disable-dirmngr 'disable all access to the dirmngr'
            cand --keyserver '@'
            cand --keyserver-options '@'
            cand --key-origin '@'
            cand --import-options '@'
            cand --import-filter '@'
            cand --export-options '@'
            cand --export-filter '@'
            cand --merge-only '@'
            cand --allow-secret-key-import '@'
            cand --Keylist 'Options controlling key listings'
            cand --list-options '@'
            cand --show-photos '@'
            cand --no-show-photos '@'
            cand --show-policy-url '@'
            cand --no-show-policy-url '@'
            cand --with-colons '@'
            cand --with-tofu-info '@'
            cand --with-key-data '@'
            cand --with-sig-list '@'
            cand --with-sig-check '@'
            cand --with-fingerprint '@'
            cand --with-subkey-fingerprint '@'
            cand --with-subkey-fingerprints '@'
            cand --with-icao-spelling '@'
            cand --with-keygrip '@'
            cand --with-secret '@'
            cand --with-wkd-hash '@'
            cand --with-key-origin '@'
            cand --fast-list-mode '@'
            cand --fixed-list-mode '@'
            cand --legacy-list-mode '@'
            cand --print-pka-records '@'
            cand --print-dane-records '@'
            cand --keyid-format '@'
            cand --show-keyring '@'
            cand --hidden-recipient '@'
            cand --recipient-file '@'
            cand --hidden-recipient-file '@'
            cand --remote-user '@'
            cand --throw-keyids '@'
            cand --no-throw-keyids '@'
            cand --trusted-key '@'
            cand --sender '@'
            cand --try-secret-key '@'
            cand --try-all-secrets '@'
            cand --no-default-keyring '@'
            cand --no-keyring '@'
            cand --keyring '@'
            cand --primary-keyring '@'
            cand --secret-keyring '@'
            cand --skip-hidden-recipients '@'
            cand --no-skip-hidden-recipients '@'
            cand --override-session-key '@'
            cand --override-session-key-fd '@'
            cand --Security 'Options controlling the security'
            cand --s2k-mode '@'
            cand --s2k-digest-algo '@'
            cand --s2k-cipher-algo '@'
            cand --s2k-count '@'
            cand --require-backsigs '@'
            cand --require-cross-certification '@'
            cand --no-require-backsigs '@'
            cand --no-require-cross-certification '@'
            cand --verify-options '@'
            cand --enable-special-filenames '@'
            cand --no-random-seed-file '@'
            cand --no-sig-cache '@'
            cand --ignore-time-conflict '@'
            cand --ignore-valid-from '@'
            cand --ignore-crc-error '@'
            cand --ignore-mdc-error '@'
            cand --disable-cipher-algo '@'
            cand --disable-pubkey-algo '@'
            cand --cipher-algo '@'
            cand --digest-algo '@'
            cand --cert-digest-algo '@'
            cand --override-compliance-check '@'
            cand --allow-weak-key-signatures '@'
            cand --allow-weak-digest-algos '@'
            cand --weak-digest '@'
            cand --allow-multisig-verification '@'
            cand --allow-multiple-messages '@'
            cand --no-allow-multiple-messages '@'
            cand --batch '@'
            cand --no-batch '@'
            cand --yes '@'
            cand --no '@'
            cand --status-fd '@'
            cand --status-file '@'
            cand --attribute-fd '@'
            cand --attribute-file '@'
            cand --command-fd '@'
            cand --command-file '@'
            cand --passphrase '@'
            cand --passphrase-fd '@'
            cand --passphrase-file '@'
            cand --passphrase-repeat '@'
            cand --pinentry-mode '@'
            cand --force-sign-key '@'
            cand --request-origin '@'
            cand --display '@'
            cand --ttyname '@'
            cand --ttytype '@'
            cand --lc-ctype '@'
            cand --lc-messages '@'
            cand --xauthority '@'
            cand --no-autostart '@'
            cand --forbid-gen-key '@'
            cand --require-compliance '@'
            cand --use-only-openpgp-card '@'
            cand --rfc2440-text '@'
            cand --no-rfc2440-text '@'
            cand --personal-cipher-prefs '@'
            cand --personal-digest-prefs '@'
            cand --personal-compress-prefs '@'
            cand --sign-with '@'
            cand --user '@'
            cand --use-agent '@'
            cand --no-use-agent '@'
            cand --gpg-agent-info '@'
            cand --reader-port '@'
            cand --ctapi-driver '@'
            cand --pcsc-driver '@'
            cand --disable-ccid '@'
            cand --honor-http-proxy '@'
            cand --tofu-db-format '@'
            cand --strict '@'
            cand --no-strict '@'
            cand --load-extension '@'
            cand --sk-comments '@'
            cand --no-sk-comments '@'
            cand --compress-keys '@'
            cand --compress-sigs '@'
            cand --force-v3-sigs '@'
            cand --no-force-v3-sigs '@'
            cand --force-v4-certs '@'
            cand --no-force-v4-certs '@'
            cand --no-mdc-warning '@'
            cand --force-mdc '@'
            cand --no-force-mdc '@'
            cand --disable-mdc '@'
            cand --no-disable-mdc '@'
            cand --x-sequoia-parcimonie 'continuously update certificates'
            cand --x-sequoia-autostart-parcimonie 'automatically start daemon to update certs'
            cand --x-sequoia-parcimonie-daemonize '@'
            cand --version '@'
            cand --warranty '@'
            cand --dump-option-table '@'
            cand --dump-options '@'
            cand -h 'Print help'
            cand --help 'Print help'
        }
    ]
    $completions[$command]
}
