# 2023-05-30 Triage Log

A good week overall, with a broad set of improvements to many primary benchmarks.
The main single source of primary regressions is from rollup PR #111869; we are
in the process of narrowing that down to see if there is a root cause.

Triage done by **@pnkfelix**.
Revision range: [cda5becc..1221e43b](https://perf.rust-lang.org/?start=cda5becc27cbc7106646fbc40aacea5e7896d954&end=1221e43bdf413f7c405e9b17ef19d76c88222098&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.5%]   | 19    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 2.7%]   | 35    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.2%, -0.1%] | 84    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.1%, -0.1%] | 15    |
| All ❌✅ (primary)                 | -0.4% | [-1.2%, 0.5%]  | 103   |


3 Regressions, 3 Improvements, 3 Mixed; 4 of them in rollups
26 artifact comparisons made in total

#### Regressions

[rustc_ty_utils] Treat `drop_in_place`'s *mut argument like &mut when adding LLVM attributes [#111807](https://github.com/rust-lang/rust/pull/111807) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cda5becc27cbc7106646fbc40aacea5e7896d954&end=f3d597b31c0f101a02c230798afa31a36bdacbc6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.7%]   | 17    |
| Regressions ❌ <br /> (secondary)  | 1.3%  | [0.2%, 2.9%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.4%  | [-0.2%, 0.7%]  | 18    |

* already triaged last week

Rollup of 6 pull requests [#111869](https://github.com/rust-lang/rust/pull/111869) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f3d597b31c0f101a02c230798afa31a36bdacbc6&end=b08148f6a76010ea3d4e91d61245aa7aac59e4b4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 0.6%] | 12    |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.2%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 0.6%] | 12    |

* The five primary regressions over 0.4% are to diesel full and incr-full scenarios.
* It is not clear what caused these regressions; pnkfelix started requesting individual rust-timer runs, but has not yet identified any root cause.

Support #[global_allocator] without the allocator shim [#86844](https://github.com/rust-lang/rust/pull/86844) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cade26637fe1c23965ce644299ed5200db7c92dd&end=a2b1646c597329d0a25efa3889b66650f65de1de&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 0.7%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 1     |

* The 0.2% hit to primary benchmark serde_derive check-incr_unchanged is easily justified by the feature addition here.
* The more interesting question is 44 primary benchmarks saw a regression to their binary size. However, the only one of those of note, in my opinion, is ripgrep, which suffered a 0.43% increase to binary size on various opt scenarios.
* marked as triaged.

#### Improvements

Rollup of 6 pull requests [#111919](https://github.com/rust-lang/rust/pull/111919) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c373194cb6d882dc455a588bcc29c92a96b50252&end=096309e6dc4378e175e524e963332d1a3830ed63&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 2     |
| All ❌✅ (primary)                 | -0.7% | [-0.7%, -0.6%] | 2     |

* a small improvement to serde_derive check-{full, incr-full} that seems like its not noise, not completely.

fix: :bug: etc/bash_complettion -> src/etc/... to avoid copy error [#110906](https://github.com/rust-lang/rust/pull/110906) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eb9da7bfa375ad58bcb946115f3191a2756785e5&end=d300bffa4f0036e9138ef752610d08fc63f87a77&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-0.8%, -0.7%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] | 6     |
| All ❌✅ (primary)                 | -0.8% | [-0.8%, -0.7%] | 2     |

* lol helloworld check-{full, incr-unchanged} improved by [-0.80%, -0.74%].
* based on the PR itself, we should consider this to be some confounding factor, not meaningful.

Rollup of 7 pull requests [#111960](https://github.com/rust-lang/rust/pull/111960) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a2b1646c597329d0a25efa3889b66650f65de1de&end=0004b3b984b19646c1f78b09ba497b7bd6e882c1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.3%, -0.2%] | 65    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.2%, -0.2%] | 18    |
| All ❌✅ (primary)                 | -0.5% | [-1.3%, -0.2%] | 65    |

* a lot of primary improvements here, mostly to incr-{unchanged, patched} scenarios
* fired off rust-timer run on specific PR just to see if it was root cause of improvement.


#### Mixed

Rollup of 7 pull requests [#111882](https://github.com/rust-lang/rust/pull/111882) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=52dd1cde59ee86e5d61469ee1befe09c132c777d&end=d5699874dc07d2dfb262d007293853f73c171f7e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 5     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 18    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 9     |
| All ❌✅ (primary)                 | -0.2% | [-0.7%, 0.3%]  | 23    |

* regressions are to bitmaps {{check, debug}-full, {check, debug, opt}-incr-full}.
* improvements clearly outweigh regressions here
* marked as triaged

Preprocess and cache dominator tree [#111673](https://github.com/rust-lang/rust/pull/111673) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b3cbf7c8351dd48dc2e07a1cdc69620f8e40dd2f&end=97d328012b9ed9b7d481c40e84aa1f2c65b33ec8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.2%, -1.2%] | 3     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 3     |

* primary benchmarks libc {check, debug}-full and bitmaps check-full regressed a little.
* this pays a bit of upfront cost to avoid a O(n^2) pathology in other planned code.
* marked as triaged.

rustc_privacy: Cleanups and perf improvements to `EmbargoVisitor` [#111260](https://github.com/rust-lang/rust/pull/111260) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=97d328012b9ed9b7d481c40e84aa1f2c65b33ec8&end=c373194cb6d882dc455a588bcc29c92a96b50252&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.6%]   | 9     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.3%, -0.1%] | 67    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -0.4% | [-1.3%, -0.1%] | 67    |

* already marked as triaged

#### Untriaged Pull Requests

- [#112083 Make `TrustedStep` require `Copy`](https://github.com/rust-lang/rust/pull/112083)
- [#112016 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/112016)
- [#112001 Enable MatchBranchSimplification](https://github.com/rust-lang/rust/pull/112001)
- [#111882 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/111882)
- [#111869 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/111869)
- [#111813 MIR: opt-in normalization of `BasicBlock` and `Local` numbering](https://github.com/rust-lang/rust/pull/111813)
- [#111673 Preprocess and cache dominator tree](https://github.com/rust-lang/rust/pull/111673)
- [#111524 `ascii::Char`-ify the escaping code in `core`](https://github.com/rust-lang/rust/pull/111524)
- [#111425 Populate effective visibilities in `rustc_privacy` (take 2)](https://github.com/rust-lang/rust/pull/111425)
- [#111364 Remove the ThinLTO CU hack](https://github.com/rust-lang/rust/pull/111364)
- [#111311 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/111311)
- [#111306 Update hashbrown from 0.12.3 to 0.13.1 for std](https://github.com/rust-lang/rust/pull/111306)
- [#111221 Combine three generalizer implementations](https://github.com/rust-lang/rust/pull/111221)
- [#111007 Disable nrvo mir opt](https://github.com/rust-lang/rust/pull/111007)
- [#110967 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/110967)
- [#110546 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/110546)
- [#110542 resolve: Remove `module_children_untracked`](https://github.com/rust-lang/rust/pull/110542)
- [#110440 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110440)
- [#110012 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110012)
- [#109900 Only enable ConstProp at mir-opt-level >= 2.](https://github.com/rust-lang/rust/pull/109900)
- [#109732 Uplift `clippy::{drop,forget}_{ref,copy}` lints](https://github.com/rust-lang/rust/pull/109732)
- [#109692 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/109692)
- [#109588 Alloc `hir::Lit` in an arena to remove the destructor from `Expr`](https://github.com/rust-lang/rust/pull/109588)
- [#109247 Permit MIR inlining without #[inline]](https://github.com/rust-lang/rust/pull/109247)
- [#109097 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/109097)
- [#108934 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/108934)
- [#108872 Strengthen state tracking in const-prop](https://github.com/rust-lang/rust/pull/108872)
- [#108830 Treat projections with infer as placeholder during fast reject in new solver](https://github.com/rust-lang/rust/pull/108830)
- [#108587 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/108587)
- [#108080 Add a builtin `FnPtr` trait that is implemented for all function pointers](https://github.com/rust-lang/rust/pull/108080)
