
;; Copyright (C) 2025 Tommi Höynälänmaa
;; Distributed under GNU Lesser General Public Licence version 3,
;; see file doc/LGPL-3.

;; Singleton


(define-module (th-scheme-utilities singleton)
  #:declarative? #t
  #:export (<singleton>
            make-singleton
            singleton?
            singleton-get-element
            singleton-set-element!))


(use-modules (oop goops))


(define-class <singleton> ()
  (x-element #:init-keyword #:x-element))


(define (make-singleton x)
  (make <singleton> #:x-element x))


(define (singleton? x)
  (is-a? x <singleton>))

  
(define (singleton-get-element sgt)
  (slot-ref sgt 'x-element))


(define (singleton-set-element! sgt x)
  (slot-set! sgt 'x-element x))

