﻿// Copyright (c) Microsoft Corporation. All rights reserved. See License.txt in the project root for license information.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#GetInitializationScripts()", Justification = "It is analogous to the get pattern users are familiar with")]
[assembly: SuppressMessage("Microsoft.Design", "CA1024:UsePropertiesWhereAppropriate", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#GetFacebookUserProfile()", Justification = "It is analogous to the get pattern users are familiar with")]
[assembly: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "Microsoft.Web.Helpers.Maps+MapLocation",
    Justification = "This type is only meant to be consumed but not instantiated by users.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.Analytics", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.Bing", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.Facebook", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.FileUpload", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.GamerCard", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.LinkShare", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.Maps", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.ReCaptcha", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1053:StaticHolderTypesShouldNotHaveConstructors", Scope = "type", Target = "Microsoft.Web.Helpers.Twitter", Justification = "This is the default format in which helpers are generated.")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "2#", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LoginButton(System.String,System.String,System.String,System.String,System.Boolean,System.String,System.String,System.Boolean,System.String)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "4#", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#OpenGraphRequiredProperties(System.String,System.String,System.String,System.String,System.String,System.String)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "0#", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LoginButton(System.String,System.String,System.String,System.String,System.Boolean,System.String,System.String,System.Boolean,System.String)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "1#", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LoginButton(System.String,System.String,System.String,System.String,System.Boolean,System.String,System.String,System.Boolean,System.String)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "1#", Scope = "member", Target = "Microsoft.Web.Helpers.Bing.#SearchBox(System.String,System.String,System.String)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "3#", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#OpenGraphRequiredProperties(System.String,System.String,System.String,System.String,System.String,System.String)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "3#", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#TweetButton(System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.String)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1054:UriParametersShouldNotBeStrings", MessageId = "3#", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LiveStream(System.Int32,System.Int32,System.String,System.String,System.Boolean)", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Design", "CA1056:UriPropertiesShouldNotBeStrings", Scope = "member", Target = "Microsoft.Web.Helpers.Bing.#SiteUrl", Justification = "We prefer strings to URIs for helpers")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1303:Do not pass literals as localized parameters", MessageId = "Microsoft.Web.Helpers.Twitter.RawJS(System.String)", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Faves(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1303:Do not pass literals as localized parameters", MessageId = "Microsoft.Web.Helpers.Twitter.RawJS(System.String)", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#List(System.String,System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Value is a hex color code")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1303:Do not pass literals as localized parameters", MessageId = "Microsoft.Web.Helpers.Twitter.RawJS(System.String)", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Profile(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Value is a hex color code")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1303:Do not pass literals as localized parameters", MessageId = "Microsoft.Web.Helpers.Twitter.RawJS(System.String)", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Search(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Value is a hex color code")]
[assembly: SuppressMessage("Microsoft.Design", "CA1034:NestedTypesShouldNotBeVisible", Scope = "type", Target = "Microsoft.Web.Helpers.Facebook+UserProfile", Justification = "The type is consumed but never instantiated by a user")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "Microsoft.Web.Helpers.Maps.#GetBingHtml(System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.String,System.Boolean,System.String,System.Collections.Generic.IEnumerable`1<Microsoft.Web.Helpers.Maps+MapLocation>)", Justification = "We're printing a JSON value that needs to be lower case")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Faves(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "We're printing a JSON value that needs to be lower case")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#List(System.String,System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "We're printing a JSON value that needs to be lower case")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Profile(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "We're printing a JSON value that needs to be lower case")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Search(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "We're printing a JSON value that needs to be lower case")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Facepile", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#Facepile(System.Int32,System.Int32)", Justification = "Facebook related term")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Faves", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Faves(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Facebook related term")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Fbml", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#FbmlNamespaces()", Justification = "Facebook related term")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "num", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#Comments(System.String,System.Int32,System.Int32,System.Boolean,System.Boolean)", Justification = "num is not Hungarian notation")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "xid", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#Comments(System.String,System.Int32,System.Int32,System.Boolean,System.Boolean)", Justification = "Facebook related term")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "xid", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LiveStream(System.Int32,System.Int32,System.String,System.String,System.Boolean)", Justification = "Facebook related term")]
[assembly: SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#TweetButton(System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.String)")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1709:IdentifiersShouldBeCasedCorrectly", MessageId = "Re", Scope = "type", Target = "Microsoft.Web.Helpers.ReCaptcha")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1719:ParameterNamesShouldNotMatchMemberNames", MessageId = "1#", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#List(System.String,System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "The parameter corresponds a Twitter API parameter")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1726:UsePreferredTerms", MessageId = "Logout", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LoginButton(System.String,System.String,System.String,System.String,System.Boolean,System.String,System.String,System.Boolean,System.String)", Justification = "We use login and logout in WebMatrix.Security")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1726:UsePreferredTerms", MessageId = "Login", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LoginButtonTagOnly(System.String,System.Boolean,System.String,System.String,System.String,System.Boolean,System.String)", Justification = "We use login and logout in WebMatrix.Security")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1726:UsePreferredTerms", MessageId = "Logout", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LoginButtonTagOnly(System.String,System.Boolean,System.String,System.String,System.String,System.Boolean,System.String)", Justification = "We use login and logout in WebMatrix.Security")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1726:UsePreferredTerms", MessageId = "Login", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#LoginButton(System.String,System.String,System.String,System.String,System.Boolean,System.String,System.String,System.Boolean,System.String)", Justification = "We use login and logout in WebMatrix.Security")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1726:UsePreferredTerms", MessageId = "Login", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook.#MembershipLogin()", Justification = "We use login and logout in WebMatrix.Security")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1726:UsePreferredTerms", MessageId = "Login", Scope = "member", Target = "Microsoft.Web.Helpers.LinkShare.#BitlyLogin", Justification = "We use login and logout in WebMatrix.Security")]
[assembly: SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "ffffff", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Faves(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Value is a hex color value")]
[assembly: SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "ffffff", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#List(System.String,System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Value is a hex color value")]
[assembly: SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "ffffff", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Profile(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Value is a hex color value")]
[assembly: SuppressMessage("Microsoft.Naming", "CA2204:Literals should be spelled correctly", MessageId = "ffffff", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Search(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)", Justification = "Value is a hex color value")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Bing.#SiteUrl", Justification = "Property name is used instead of the generic term value to make it simpler to debug.")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.GamerCard.#GetHtml(System.String)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.LinkShare.#GetHtml(System.String,System.String,System.String,System.String,Microsoft.Web.Helpers.LinkShareSite[])")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Maps.#GetBingHtml(System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.String,System.Boolean,System.String,System.Collections.Generic.IEnumerable`1<Microsoft.Web.Helpers.Maps+MapLocation>)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Maps.#GetMapQuestHtml(System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.String,System.Boolean,System.String,System.Boolean,System.Collections.Generic.IEnumerable`1<Microsoft.Web.Helpers.Maps+MapLocation>)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Maps.#GetYahooHtml(System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.String,System.Boolean,System.String,System.Collections.Generic.IEnumerable`1<Microsoft.Web.Helpers.Maps+MapLocation>)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Faves(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#List(System.String,System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Profile(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.Int32,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Bing.#SiteTitle", Justification = "Property name is used instead of the generic term value to make it simpler to debug.")]
[assembly: SuppressMessage("Microsoft.Usage", "CA2208:InstantiateArgumentExceptionsCorrectly", Scope = "member", Target = "Microsoft.Web.Helpers.Twitter.#Search(System.String,System.Int32,System.Int32,System.String,System.String,System.String,System.String,System.String,System.String,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String,System.Int32)")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1707:IdentifiersShouldNotContainUnderscores", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook+UserProfile.#Updated_Time", Justification = "This is serailzed from a JSON schema, so member names have to be exactly this way.")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1707:IdentifiersShouldNotContainUnderscores", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook+UserProfile.#Last_Name", Justification = "This is serailzed from a JSON schema, so member names have to be exactly this way.")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1707:IdentifiersShouldNotContainUnderscores", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook+UserProfile.#First_Name", Justification = "This is serailzed from a JSON schema, so member names have to be exactly this way.")]
[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Timezone", Scope = "member", Target = "Microsoft.Web.Helpers.Facebook+UserProfile.#Timezone", Justification = "This is serailzed from a JSON schema, so member names have to be exactly this way.")]
