typedef struct whatnow_t
{
  const char *old,  *name, *oldarg, *newarg;
} whatnow_t;

#define SAME NULL
#define REMOV (char *)1L

#define _REMOV REMOV,NULL,NULL
#define _SAME  SAME,NULL,NULL
static const whatnow_t whatnowlist[]={
{"!_",_SAME},
{"#_",_SAME},
{"%",_SAME},
{"+_",_SAME},
{"-_",_SAME},
{"_!",_SAME},
{"_!=_",_SAME},
{"_%=_",_SAME},
{"_%_",_SAME},
{"_&&_",_SAME},
{"_'",_SAME},
{"_*=_",_SAME},
{"_*_",_SAME},
{"_++",_SAME},
{"_+=_",_SAME},
{"_+_",_SAME},
{"_--",_SAME},
{"_-=_",_SAME},
{"_-_",_SAME},
{"_.a1",_SAME},
{"_.a2",_SAME},
{"_.a3",_SAME},
{"_.a4",_SAME},
{"_.a6",_SAME},
{"_.area",_SAME},
{"_.b2",_SAME},
{"_.b4",_SAME},
{"_.b6",_SAME},
{"_.b8",_SAME},
{"_.bid",_SAME},
{"_.bnf",_SAME},
{"_.c4",_SAME},
{"_.c6",_SAME},
{"_.clgp",_SAME},
{"_.codiff",_SAME},
{"_.cyc",_SAME},
{"_.diff",_SAME},
{"_.disc",_SAME},
{"_.e",_SAME},
{"_.eta",_SAME},
{"_.f",_SAME},
{"_.fu",_SAME},
{"_.futu",_SAME},
{"_.gen",_SAME},
{"_.group",_SAME},
{"_.index",_SAME},
{"_.j",_SAME},
{"_.mod",_SAME},
{"_.nf",_SAME},
{"_.no",_SAME},
{"_.omega",_SAME},
{"_.orders",_SAME},
{"_.p",_SAME},
{"_.pol",_SAME},
{"_.r1",_SAME},
{"_.r2",_SAME},
{"_.reg",_SAME},
{"_.roots",_SAME},
{"_.sign",_SAME},
{"_.t2",_SAME},
{"_.tate",_SAME},
{"_.tu",_SAME},
{"_.tufu",_SAME},
{"_.zk",_SAME},
{"_.zkst",_SAME},
{"_/=_",_SAME},
{"_/_",_SAME},
{"_<<=_",_SAME},
{"_<<_",_SAME},
{"_<=_",_SAME},
{"_<_",_SAME},
{"_==_",_SAME},
{"_>=_",_SAME},
{"_>>=_",_SAME},
{"_>>_",_SAME},
{"_>_",_SAME},
{"_[_.._,_.._]",_SAME},
{"_[_.._]",_SAME},
{"_\\/=_",_SAME},
{"_\\/_",_SAME},
{"_\\=_",_SAME},
{"_\\_",_SAME},
{"_^_",_SAME},
{"_^s",_SAME},
{"__",_SAME},
{"_derivfun",_SAME},
{"_eval_mnemonic",_SAME},
{"_multi_if",_SAME},
{"_void_if",_SAME},
{"_||_",_SAME},
{"_~",_SAME},
{"O",_SAME},
{"O(_^_)",_SAME},
{"Str",_SAME},
{"abs",_SAME},
{"acos",_SAME},
{"acosh",_SAME},
{"addell","elladd","(e,z1,z2)","(e,z1,z2)"},
{"addprimes",_SAME},
{"adj","matadjoint","(x)","(x)"},
{"agm",_SAME},
{"akell","ellak","(e,n)","(e,n)"},
{"algdep",_SAME},
{"algdep2","algdep","(x,n,dec)","(x,n,dec)"},
{"algtobasis","nfalgtobasis","(nf,x)","(nf,x)"},
{"anell","ellan","(e,n)","(e,n)"},
{"apell","ellap","(e,n)","(e,n)"},
{"apell2","ellap","(e,n)","(e,n)"},
{"apprpadic","padicappr","(x,a)","(x,a)"},
{"arg",_SAME},
{"asin",_SAME},
{"asinh",_SAME},
{"assmat","matcompanion","(x)","(x)"},
{"atan",_SAME},
{"atanh",_SAME},
{"basis","nfbasis","(x)","(x)"},
{"basis2","nfbasis","(x)","(x,2)"},
{"basistoalg","nfbasistoalg","(nf,x)","(nf,x)"},
{"bernreal",_SAME},
{"bernvec",_SAME},
{"bestappr",_SAME},
{"bezout","gcdext","(a,b)","(a,b)"},
{"bezoutres",_SAME},
{"bigomega",_SAME},
{"bilhell","ellbil","(e,z1,z2)","(e,z1,z2)"},
{"bin","binomial","(x,y)","(x,y)"},
{"binary",_SAME},
{"bittest",_SAME},
{"boundcf","contfrac","(x,lmax)","(x,,lmax)"},
{"boundfact","factor","(x,lim)","(x,lim)"},
{"buchcertify","bnfcertify","(bnf)","(bnf)"},
{"buchfu",_REMOV},
{"buchgen",_REMOV},
{"buchgenforcefu",_REMOV},
{"buchgenfu",_REMOV},
{"buchimag","quadclassunit","(D,c1,c2,g)","(D,,[c1,c2,g])"},
{"buchinit","bnfinit","(P)","(P,2)"},
{"buchinitforcefu","bnfinit","(P)","(P,1)"},
{"buchinitfu","bnfinit","(P)","(P)"},
{"buchnarrow","bnfnarrow","(bnf)","(bnf)"},
{"buchray","bnrinit","(bnf,ideal)","(bnf,ideal)"},
{"buchrayinit","bnrinit","(bnf,ideal)","(bnf,ideal)"},
{"buchrayinitgen","bnrinit","(bnf,ideal)","(bnf,ideal,1)"},
{"buchreal","quadclassunit","(D)","(D)"},
{"bytesize","sizebyte","(x)","(x)"},
{"ceil",_SAME},
{"centerlift",_SAME},
{"cf","contfrac","(x)","(x)"},
{"cf2","contfrac","(b,x)","(x,b)"},
{"changevar",_REMOV},
{"char","charpoly","(x,y)","(x,y)"},
{"char1","charpoly","(x,y)","(x,y,1)"},
{"char2","charpoly","(x,y)","(x,y,2)"},
{"chell","ellchangecurve","(x,y)","(x,y)"},
{"chinese",_SAME},
{"chptell","ellchangepoint","(x,y)","(x,y)"},
{"classno","qfbclassno","(x)","(x)"},
{"classno2","qfbclassno","(x)","(x,1)"},
{"coeff","polcoeff","(x,s)","(x,s)"},
{"compimag","x*y","(x,y)",""},
{"compo","component","(x,s)","(x,s)"},
{"compositum","polcompositum","(pol1,pol2)","(pol1,pol2)"},
{"compositum2","polcompositum","(pol1,pol2)","(pol1,pol2,1)"},
{"comprealraw","qfbcompraw","(x,y)","(x,y)"},
{"concat",_SAME},
{"conductor","bnrconductor","(a1)","(a1)"},
{"conductorofchar","bnrconductorofchar","(bnr,chi)","(bnr,chi)"},
{"conj",_SAME},
{"conjvec",_SAME},
{"content",_SAME},
{"convol","serconvol","(x,y)","(x,y)"},
{"core",_SAME},
{"core2","core","(x)","(x,1)"},
{"coredisc",_SAME},
{"coredisc2","coredisc","(x)","(x,1)"},
{"cos",_SAME},
{"cosh",_SAME},
{"cvtoi","truncate","(x)","(x,&e)"},
{"cyclo","polcyclo","(n)","(n)"},
{"decodefactor","factorback","(fa)","(fa)"},
{"decodemodule","bnfdecodemodule","(nf,fa)","(nf,fa)"},
{"degree","poldegree","(x)","(x)"},
{"denom","denominator","(x)","(x)"},
{"deplin","lindep","(x)","(x,-1)"},
{"deriv",_SAME},
{"det","matdet","(x)","(x)"},
{"det2","matdet","(x)","(x,1)"},
{"detint","matdetint","(x)","(x)"},
{"diagonal","matdiagonal","(x)","(x)"},
{"dilog",_SAME},
{"dirdiv",_SAME},
{"direuler",_SAME},
{"dirmul",_SAME},
{"dirzetak",_SAME},
{"disc","poldisc","(x)","(x)"},
{"discf","nfdisc","(x)","(x)"},
{"discf2","nfdisc","(x)","(x,2)"},
{"discrayabs","bnrdisc","(bnr,subgroup)","(bnr,subgroup)"},
{"discrayabscond","bnrdisc","(bnr)","(bnr,,,2)"},
{"discrayabslist","bnrdisclist","(bnf,list)","(bnf,list)"},
{"discrayabslistarch","bnrdisclist","(bnf,arch,bound)","(bnf,bound,arch)"},
{"discrayabslistarchall","bnrdisclist","(bnf,bound)","(bnf,bound,,1)"},
{"discrayabslistlong","bnrdisclist","(bnf,bound)","(bnf,bound)"},
{"discrayrel","bnrdisc","(bnr,subgroup)","(bnr,subgroup,,1)"},
{"discrayrelcond","bnrdisc","(bnr,subgroup)","(bnr,subgroup,,3)"},
{"divisors",_SAME},
{"divres","divrem","(x,y)","(x,y)"},
{"divsum","sumdiv","(n,X,expr)","(n,X,expr)"},
{"eigen","mateigen","(x)","(x)"},
{"eint1",_SAME},
{"erfc",_SAME},
{"eta",_SAME},
{"euler","Euler","",""},
{"eval",_SAME},
{"exp",_SAME},
{"extract","vecextract","(x,y)","(x,y)"},
{"fact","factorial","(x)","(x)"},
{"factcantor","factorcantor","(x,p)","(x,p)"},
{"factfq","factorff","(x,p,a)","(x,p,a)"},
{"factmod","factormod","(x,p)","(x,p)"},
{"factor",_SAME},
{"factoredbasis","nfbasis","(x,p)","(x,,p)"},
{"factoreddiscf","nfdisc","(x,p)","(x,,p)"},
{"factoredpolred","polred","(x,p)","(x,,p)"},
{"factoredpolred2","polred","(x,p)","(x,2,p)"},
{"factornf",_SAME},
{"factorpadic",_SAME},
{"factorpadic2","factorpadic","(x,p,r)","(x,p,r,1)"},
{"factpol","factor","(x,l,hint)","(x)"},
{"factpol2","factor","(x,l,hint)","(x)"},
{"fibo","fibonacci","(x)","(x)"},
{"floor",_SAME},
{"for",_SAME},
{"fordiv",_SAME},
{"forprime",_SAME},
{"forstep",_SAME},
{"forvec",_SAME},
{"fpn","ffinit","(p,n)","(p,n)"},
{"frac",_SAME},
{"galois","polgalois","(x)","(x)"},
{"galoisapply","nfgaloisapply","(nf,aut,x)","(nf,aut,x)"},
{"galoisconj","nfgaloisconj","(nf)","(nf)"},
{"galoisconj1","nfgaloisconj","(nf)","(nf,2)"},
{"galoisconjforce","nfgaloisconj","","(nf,1)"},
{"gamh","gammah","(x)","(x)"},
{"gamma",_SAME},
{"gauss","matsolve","(a,b)","(a,b)"},
{"gaussmodulo","matsolvemod","(M,D,Y)","(M,D,Y)"},
{"gaussmodulo2","matsolvemod","(M,D,Y)","(M,D,Y,1)"},
{"gcd",_SAME},
{"getheap",_SAME},
{"getrand",_SAME},
{"getstack",_SAME},
{"gettime",_SAME},
{"globalred","ellglobalred","(x,y)","(x,y)"},
{"goto",_REMOV},
{"hclassno","qfbhclassno","(x)","(x)"},
{"hell","ellheight","(e,x)","(e,x)"},
{"hell2","ellheight","(e,x)","(e,x,1)"},
{"hermite","mathnf","(x)","(x)"},
{"hermite2","mathnf","(x)","(x,1)"},
{"hermitehavas",_REMOV},
{"hermitemod","mathnfmod","(x,d)","(x,d)"},
{"hermitemodid","mathnfmodid","(x,d)","(x,d)"},
{"hermiteperm","mathnf","(x)","(x,3)"},
{"hess","mathess","(x)","(x)"},
{"hilb","hilbert","(x,y)","(x,y)"},
{"hilbert","mathilbert","(n)","(n)"},
{"hilbp","hilbert","(x,y,p)","(x,y,p)"},
{"hvector","vector","(n,X,expr)","(n,X,expr)"},
{"hyperu",_SAME},
{"i","I","",""},
{"idealadd",_SAME},
{"idealaddmultone","idealaddtoone","(nf,list)","(nf,list)"},
{"idealaddone","idealaddtoone","(nf,x,y)","(nf,x,y)"},
{"idealappr",_SAME},
{"idealapprfact","idealappr","(nf,x)","(nf,x,1)"},
{"idealchinese",_SAME},
{"idealcoprime",_SAME},
{"idealdiv",_SAME},
{"idealdivexact","idealdiv","(nf,x,y)","(nf,x,y,1)"},
{"idealfactor",_SAME},
{"idealhermite","idealhnf","(nf,x)","(nf,x)"},
{"idealhermite2","idealhnf","(nf,x)","(nf,x)"},
{"idealintersect",_SAME},
{"idealinv",_SAME},
{"idealinv2","idealinv","(nf,x)","(nf,x,1)"},
{"ideallist",_SAME},
{"ideallistarch",_SAME},
{"ideallistarchgen","ideallistarch","(nf,list,arch)","(nf,list,arch)"},
{"ideallistunit","ideallist","(nf,list)","(nf,list,2)"},
{"ideallistunitarch","ideallistarch","","(nf,list,arch)"},
{"ideallistunitarchgen","ideallistarch","","(nf,list,arch)"},
{"ideallistunitgen","ideallist","","(nf,list,3)"},
{"ideallistzstar","ideallist","(nf,bound)","(nf,bound)"},
{"ideallistzstargen","ideallist","(nf,bound)","(nf,bound,1)"},
{"ideallllred","idealred","(nf,x,vdir)","(nf,x,vdir)"},
{"idealmul",_SAME},
{"idealmulred","idealmul","(nf,x,y)","(nf,x,y,1)"},
{"idealnorm",_SAME},
{"idealpow",_SAME},
{"idealpowred","idealpow","(nf,x,y)","(nf,x,y,1)"},
{"idealtwoelt",_SAME},
{"idealtwoelt2","idealtwoelt","(nf,x,a)","(nf,x,a)"},
{"idealval",_SAME},
{"idmat","matid","(n)","(n)"},
{"if",_SAME},
{"imag",_SAME},
{"image","matimage","(x)","(x)"},
{"image2","matimage","(x)","(x,1)"},
{"imagecompl","matimagecompl","(x)","(x)"},
{"incgam",_SAME},
{"incgam1",_REMOV},
{"incgam2",_REMOV},
{"incgam3",_REMOV},
{"incgam4","incgam","(s,x,y)","(s,x,y)"},
{"indexrank","matindexrank","(x)","(x)"},
{"indsort","vecsort","(x)","(x,,1)"},
{"initalg","nfinit","(pol)","(pol)"},
{"initalgred","nfinit","(x)","(x,2)"},
{"initalgred2","nfinit","(x)","(x,3)"},
{"initell","ellinit","(x)","(x)"},
{"initzeta",_REMOV},
{"integ","intformal","(x,y)","(x,y)"},
{"intersect","matintersect","(x,y)","(x,y)"},
{"intgen","intnum","(x=a,b,s)","(x=a,b,s,1)"},
{"intinf","intnum","(x=a,b,s)","(x=a,b,s,2)"},
{"intnum",_SAME},
{"intopen","intnum","(x=a,b,s)","(x=a,b,s,3)"},
{"inverseimage","matinverseimage","(x,y)","(x,y)"},
{"isdiagonal","matisdiagonal","(x)","(x)"},
{"isfund","isfundamental","(x)","(x)"},
{"isideal","nfisideal","(nf,x)","(nf,x)"},
{"isincl","nfisincl","(x,y)","(x,y)"},
{"isinclfast","nfisincl","(nf1,nf2)","(nf1,nf2,1)"},
{"isirreducible","polisirreducible","(x)","(x)"},
{"isisom","nfisisom","(x,y)","(x,y)"},
{"isisomfast","nfisisom","(x,y)","(x,y)"},
{"isoncurve","ellisoncurve","(e,x)","(e,x)"},
{"isprime",_SAME},
{"isprincipal","bnfisprincipal","(bnf,x)","(bnf,x,0)"},
{"isprincipalforce","bnfisprincipal","(bnf,x)","(bnf,x,2)"},
{"isprincipalgen","bnfisprincipal","(bnf,x)","(bnf,x)"},
{"isprincipalgenforce","bnfisprincipal","(bnf,x)","(bnf,x,3)"},
{"isprincipalray","bnrisprincipal","(bnf,x)","(bnf,x)"},
{"isprincipalraygen",_SAME},
{"ispsp","ispseudoprime","(x)","(x)"},
{"isqrt","sqrtint","(x)","(x)"},
{"isset","setisset","(x)","(x)"},
{"issqfree","issquarefree","(x)","(x)"},
{"issquare",_SAME},
{"isunit","bnfisunit","(bnf,x)","(bnf,x)"},
{"jacobi","qfjacobi","(x)","(x)"},
{"jbesselh","besseljh","(n,x)","(n,x)"},
{"jell","ellj","(x)","(x)"},
{"karamul",_REMOV},
{"kbessel","besselk","(nu,x)","(nu,x)"},
{"kbessel2","besselk","(nu,x)","(nu,x)"},
{"ker","matker","(x)","(x)"},
{"keri","matker","(x)","(x,1)"},
{"kerint","matkerint","(x)","(x)"},
{"kerint1","matkerint","(x)","(x,1)"},
{"kerint2",_REMOV},
{"kro","kronecker","(x,y)","(x,y)"},
{"label",_REMOV},
{"lambdak",_REMOV},
{"laplace","serlaplace","(x)","(x)"},
{"lcm",_SAME},
{"legendre","pollegendre","(n)","(n)"},
{"length",_SAME},
{"lex",_SAME},
{"lexsort","vecsort","(x)","(x,,2)"},
{"lift",_SAME},
{"lindep",_SAME},
{"lindep2","lindep","(x)","(x,1)"},
{"lll","qflll","(x)","(x)"},
{"lll1",_REMOV},
{"lllgen","qflll","(x)","(x,8)"},
{"lllgram","qflllgram","(x)","(x)"},
{"lllgram1",_REMOV},
{"lllgramgen","qflllgram","(x)","(x,8)"},
{"lllgramint","qflllgram","(x)","(x,1)"},
{"lllgramkerim","qflllgram","(x)","(x,4)"},
{"lllgramkerimgen","qflllgram","(x)","(x,5)"},
{"lllint","qflll","(x)","(x,1)"},
{"lllintpartial","qflll","(x)","(x,2)"},
{"lllkerim","qflll","(x)","(x,4)"},
{"lllkerimgen","qflll","(x)","(x,5)"},
{"lllrat",_REMOV},
{"ln","log","(x)","(x)"},
{"lngamma",_SAME},
{"localred","elllocalred","(e)","(e)"},
{"log",_SAME},
{"logagm","log","(x)","(x,1)"},
{"lseriesell","elllseries","(e,s,N,A)","(e,s,A)"},
{"makebigbnf","bnfinit","(sbnf)","(sbnf)"},
{"mat","Mat","(x)","(x)"},
{"matextract","vecextract","(x,y,z)","(x,y,z)"},
{"mathell","ellheightmatrix","(e,x)","(e,x)"},
{"matrix",_SAME},
{"matrixqz",_SAME},
{"matrixqz2","matrixqz","(x,p)","(x,-1)"},
{"matrixqz3","matrixqz","(x,p)","(x,-2)"},
{"matsize",_SAME},
{"max",_SAME},
{"min",_SAME},
{"minideal","idealmin","(nf,ix,vdir)","(nf,ix,vdir)"},
{"minim","qfminim","(x,bound,maxnum)","(x,bound,maxnum)"},
{"minim2","qfminim","(x,bound)","(x,bound,,1)"},
{"mod","Mod","(x,y)","(x,y)"},
{"modp","Mod","(x,y,p)","(x,y)"},
{"modreverse",_SAME},
{"modulargcd","gcd","(x,y)","(x,y,1)"},
{"mu","moebius","(n)","(n)"},
{"newtonpoly",_SAME},
{"nextprime",_SAME},
{"nfdetint",_SAME},
{"nfdiv","nfeltdiv","(nf,a,b)","(nf,a,b)"},
{"nfdiveuc","nfeltdiveuc","(nf,a,b)","(nf,a,b)"},
{"nfdivres","nfeltdivrem","(nf,a,b)","(nf,a,b)"},
{"nfhermite","nfhnf","(nf,x)","(nf,x)"},
{"nfhermitemod","nfhnfmod","(nf,x,detx)","(nf,x,detx)"},
{"nfmod","nfeltmod","(nf,a,b)","(nf,a,b)"},
{"nfmul","nfeltmul","(nf,a,b)","(nf,a,b)"},
{"nfpow","nfeltpow","(nf,a,k)","(nf,a,k)"},
{"nfreduce","nfeltreduce","(nf,a,id)","(nf,a,id)"},
{"nfsmith","nfsnf","(nf,x)","(nf,x)"},
{"nfval","nfeltval","(nf,a,pr)","(nf,a,pr)"},
{"norm",_SAME},
{"norml2",_SAME},
{"nucomp","qfbnucomp","(x,y,l)","(x,y,l)"},
{"numdiv",_SAME},
{"numer","numerator","(x)","(x)"},
{"nupow","qfbnupow","(x,n)","(x,n)"},
{"o","O","(x)","(x)"},
{"omega",_SAME},
{"ordell","ellordinate","(e,x)","(e,x)"},
{"order","znorder","(x)","(x)"},
{"orderell","ellorder","(e,x)","(e,x)"},
{"ordred","polredord","(x)","(x)"},
{"padicprec",_SAME},
{"pascal","matpascal","(n)","(n)"},
{"perf","qfperfection","(a)","(a)"},
{"permutation","numtoperm","(n,k)","(n,k)"},
{"permutation2num","permtonum","(vect)","(vect)"},
{"pf","qfbprimeform","(x,p)","(x,p)"},
{"phi","eulerphi","(x)","(x)"},
{"pi","Pi","",""},
{"pnqn","contfracpnqn","(x)","(x)"},
{"pointell","ellztopoint","(e,z)","(e,z)"},
{"polint","polinterpolate","(xa,ya,x)","(xa,ya,p)"},
{"polred",_SAME},
{"polred2","polred","(x)","(x,2)"},
{"polredabs",_SAME},
{"polredabs2","polredabs","(x)","(x,1)"},
{"polredabsall","polredabs","(x)","(x,4)"},
{"polredabsfast","polredabs","(x)","(x,8)"},
{"polredabsnored","polredabs","(x)","(x,2)"},
{"polsym",_SAME},
{"polvar","variable","(x)","(x)"},
{"poly","Pol","(x,v)","(x,v)"},
{"polylog",_SAME},
{"polylogd","polylog","(m,x)","(m,x,1)"},
{"polylogdold","polylog","(m,x)","(m,x,2)"},
{"polylogp","polylog","(m,x)","(m,x,3)"},
{"polyrev","Polrev","(x,v)","(x,v)"},
{"polzag","polzagier","(n,m)","(n,m)"},
{"powell","ellmul","(e,x,n)","(e,x,n)"},
{"powrealraw","qfbpowraw","(x,n)","(x,n)"},
{"prec","precision","(x,n)","(x,n)"},
{"precision",_SAME},
{"prime",_SAME},
{"primedec","idealprimedec","(nf,p)","(nf,p)"},
{"primes",_SAME},
{"primroot","znprimroot","(n)","(n)"},
{"principalideal",_REMOV},
{"principalidele",_REMOV},
{"prod","prod","(x,X=a,b,expr)","(X=a,b,expr,x)"},
{"prodeuler",_SAME},
{"prodinf",_SAME},
{"prodinf1","prodinf","(X=a,expr)","(X=a,expr,1)"},
{"psi",_SAME},
{"qfi","Qfb","(a,b,c)","(a,b,c)"},
{"qfr","Qfb","(a,b,c,d)","(a,b,c,d)"},
{"quaddisc",_SAME},
{"quadgen",_SAME},
{"quadpoly",_SAME},
{"random",_SAME},
{"rank","matrank","(x)","(x)"},
{"rayclassno","bnrclassno","(bnf,x)","(bnf,x)"},
{"rayclassnolist","bnrclassnolist","(bnf,liste)","(bnf,liste)"},
{"real",_SAME},
{"recip","polrecip","(x)","(x)"},
{"redimag","qfbred","(x)","(x)"},
{"redreal","qfbred","(x)","(x)"},
{"redrealnod","qfbred","(x,d)","(x,2,,d)"},
{"reduceddisc","poldiscreduced","(f)","(f)"},
{"regula","quadregulator","(x)","(x)"},
{"reorder",_REMOV},
{"resultant","polresultant","(x,y)","(x,y)"},
{"resultant2","polresultant","(x,y)","(x,y,1)"},
{"reverse","serreverse","(x)","(x)"},
{"rhoreal","qfbred","(x)","(x,1)"},
{"rhorealnod","qfbred","(x,d)","(x,3,,d)"},
{"rndtoi","round","(x)","(x,&e)"},
{"rnfbasis",_SAME},
{"rnfdiscf","rnfdisc","(nf,pol)","(nf,pol)"},
{"rnfequation",_SAME},
{"rnfequation2","rnfequation","(nf,pol)","(nf,pol,1)"},
{"rnfhermitebasis","rnfhnfbasis","(bnf,order)","(bnf,order)"},
{"rnfisfree",_SAME},
{"rnflllgram",_SAME},
{"rnfpolred",_SAME},
{"rnfpseudobasis",_SAME},
{"rnfsteinitz",_SAME},
{"rootmod","polrootsmod","(x,p)","(x,p)"},
{"rootmod2","polrootsmod","(x,p)","(x,p)"},
{"rootpadic","polrootspadic","(x,p,r)","(x,p,r)"},
{"roots","polroots","(x)","(x)"},
{"rootsof1","nfrootsof1","(nf)","(nf)"},
{"rootsold",_REMOV},
{"round",_SAME},
{"rounderror","round","(x)","(x,&e)"},
{"series","Ser","(x,v)","(x,v)"},
{"set","Set","(x)","(x)"},
{"setintersect",_SAME},
{"setminus",_SAME},
{"setrand",_SAME},
{"setsearch",_SAME},
{"setunion",_SAME},
{"shift",_SAME},
{"shiftmul",_SAME},
{"sigma",_SAME},
{"sigmak","sigma","(k,x)","(x,k)"},
{"sign",_SAME},
{"signat","qfsign","(x)","(x)"},
{"signunit","bnfsignunit","(bnf)","(bnf)"},
{"simplefactmod","factormod","(x,p)","(x,p,1)"},
{"simplify",_SAME},
{"sin",_SAME},
{"sinh",_SAME},
{"size","sizedigit","(x)","(x)"},
{"smallbasis","nfbasis","(x)","(x,1)"},
{"smallbuchinit",_REMOV},
{"smalldiscf","nfdisc","(x)","(x,1)"},
{"smallfact","factor","(x)","(x,0)"},
{"smallinitell","ellinit","(x)","(x,1)"},
{"smallpolred","polred","(x)","(x,1)"},
{"smallpolred2","polred","(x)","(x,3)"},
{"smith","matsnf","(x)","(x)"},
{"smith2","matsnf","(x)","(x,1)"},
{"smithclean","matsnf","(x)","(x,4)"},
{"smithpol","matsnf","(x)","(x,2)"},
{"solve",_SAME},
{"sort","vecsort","(x)","(x)"},
{"sqr",_SAME},
{"sqred","qfgaussred","(x)","(x)"},
{"sqrt",_SAME},
{"srgcd","gcd","(x,y)","(x,y,2)"},
{"sturm","polsturm","(x)","(x)"},
{"sturmpart","polsturm","(x,a,b)","(x,a,b)"},
{"subcyclo","polsubcyclo","(p,d)","(p,d)"},
{"subell","ellsub","(e,a,b)","(e,a,b)"},
{"subst",_SAME},
{"sum","sum","(x,X=a,b,expr)","(X=a,b,expr,x)"},
{"sumalt",_SAME},
{"sumalt2","sumalt","(X=a,expr)","(X=a,expr,1)"},
{"suminf",_SAME},
{"sumpos",_SAME},
{"sumpos2","sumpos","(X=a,expr)","(X=a,expr,1)"},
{"supplement","matsupplement","(x)","(x)"},
{"sylvestermatrix","polsylvestermatrix","(x,y)","(x,y)"},
{"system",_SAME},
{"tan",_SAME},
{"tanh",_SAME},
{"taniyama","elltaniyama","(e)","(e)"},
{"taylor",_SAME},
{"tchebi","polchebyshev","(n)","(n)"},
{"teich","teichmuller","(x)","(x)"},
{"theta",_SAME},
{"thetanullk",_SAME},
{"threetotwo",_REMOV},
{"threetotwo2",_REMOV},
{"torsell","elltors","(e)","(e)"},
{"trace",_SAME},
{"trans","mattranspose","(x)","(x)"},
{"trunc","truncate","(x)","(x)"},
{"tschirnhaus","poltschirnhaus","(x)","(x)"},
{"twototwo",_REMOV},
{"unit","quadunit","(x)","(x)"},
{"until",_SAME},
{"valuation",_SAME},
{"vec","Vec","(x)","(x)"},
{"vecindexsort","vecsort","(x)","(x,,1)"},
{"veclexsort","vecsort","(x)","(x,,2)"},
{"vecmax",_SAME},
{"vecmin",_SAME},
{"vecsort",_SAME},
{"vector",_SAME},
{"vvector","vectorv","(n,X,expr)","(n,X,expr)"},
{"weipell","ellwp","(e)","(e)"},
{"wf","weber","(x)","(x)"},
{"wf2","weber","(x)","(x,2)"},
{"while",_SAME},
{"zell","ellpointtoz","(e,P)","(e,P)"},
{"zeta",_SAME},
{"zetak","lfun","(nfz,s)","(L,s)"},
{"zideallog","ideallog","(nf,x,bid)","(nf,x,bid)"},
{"zidealstar","idealstar","(nf,I)","(nf,I)"},
{"zidealstarinit","idealstar","(nf,id)","(nf,id,1)"},
{"zidealstarinitgen","idealstar","(nf,id)","(nf,id,2)"},
{"znstar",_SAME},
{"allocatemem",_SAME},
{"box","plotbox","(x,a)","(x,a)"},
{"color","plotcolor","(w,c)","(w,c)"},
{"cursor","plotcursor","(w)","(w)"},
{"default",_SAME},
{"draw","plotdraw","(list)","(list)"},
{"plotinit","plotinit","(w,x,y)","(w,x,y)"},
{"kill",_SAME},
{"plotkill","plotkill","(w)","(w)"},
{"line","plotlines","(w,x2,y2)","(w,x2,y2)"},
{"lines","plotlines","(w,x2,y2)","(w,x2,y2)"},
{"move","plotmove","(w,x,y)","(w,x,y)"},
{"plot",_SAME},
{"ploth",_SAME},
{"ploth2","ploth","(X=a,b,expr)","(X=a,b,expr,1)"},
{"plothmult","ploth","(X=a,b,expr)","(X=a,b,expr)"},
{"plothraw",_SAME},
{"point","plotpoints","(w,x,y)","(w,x,y)"},
{"points","plotpoints","(w,x,y)","(w,x,y)"},
{"psdraw","psdraw","(list)","(list)"},
{"psploth","psploth","(X=a,b,expr)","(X=a,b,expr)"},
{"postploth2","psploth","(X=a,b,expr)","(X=a,b,expr,1)"},
{"psplothraw","psplothraw","(listx,listy)","(listx,listy)"},
{"pprint",_REMOV},
{"pprint1",_REMOV},
{"print",_SAME},
{"print1",_SAME},
{"rbox","plotrbox","(w,dx,dy)","(w,dx,dy)"},
{"read","input","(x)","(x)"},
{"rline","plotrline","(w,dx,dy)","(w,dx,dy)"},
{"rlines","plotrlines","(w,dx,dy)","(w,dx,dy,1)"},
{"rmove","plotrmove","(w,dx,dy)","(w,dx,dy)"},
{"rpoint","plotrpoint","(w,dx,dy)","(w,dx,dy)"},
{"rpoints","plotrpoints","(w,dx,dy)","(w,dx,dy)"},
{"scale","plotscale","(w,x1,x2,y1,y2)","(w,x1,x2,y1,y2)"},
{"setprecision","default","(n)","(realprecision,n)"},
{"setserieslength","default","(n)","(seriesprecision,n)"},
{"settype","type","(x,t)","(x,t)"},
{"string","plotstring","(w,x)","(w,x)"},
{"texprint","printtex","(x)","(x)"},
{"type",_SAME},
/* not in  1.39.15 */
{"intfouriercos",_REMOV},
{"intfouriersin",_REMOV},
{"intfourierexp",_REMOV},
{"intlaplaceinv",_REMOV},
{"intmellininv",_REMOV},
{"intmellininvshort",_REMOV},
{"zetakinit","lfuninit","(T)","(T,sdom)"},
{NULL,_SAME}
};
