% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lesion_segregation.R
\name{plot_lesion_segregation}
\alias{plot_lesion_segregation}
\title{Plot the strands of variants to show lesion segregation}
\usage{
plot_lesion_segregation(vcf, per_chrom = FALSE, sample_name = NA)
}
\arguments{
\item{vcf}{GRanges object}

\item{per_chrom}{Boolean. Determines whether to create a separate plot per chromosome}

\item{sample_name}{Name of the sample}
}
\value{
ggplot2 object
}
\description{
The strands of variants in a GRanges object is plotted.
This way the presence of any lesion segregation is visualized.
}
\examples{

## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
grl <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
  package = "MutationalPatterns"
))
## Select a single GRanges object to plot.
gr <- grl[[1]]

## Plot lesion segregation
plot_lesion_segregation(gr, sample_name = "Colon1")

## Plot lesion segregation per chromosome
plot_lesion_segregation(gr, per_chrom = TRUE, sample_name = "Colon1")
}
\seealso{
\code{\link{calculate_lesion_segregation}}

Other Lesion_segregation: 
\code{\link{calculate_lesion_segregation}()}
}
\concept{Lesion_segregation}
