// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralDevicePackage.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.peripheral {

  public class PackageInfo_6_0_0 : ICloneable {
    public object Clone() {
      PackageInfo_6_0_0 copy = new PackageInfo_6_0_0();
      copy.state = this.state;
      copy.position = this.position;
      copy.hwInfo = this.hwInfo;
      copy.fwInfo = this.fwInfo;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["state"] = (int)this.state;
      json["position"] = new JsonArray(this.position.Select(
        _value => (JsonValue)(_value.Encode())));
      json["hwInfo"] = this.hwInfo.Encode();
      json["fwInfo"] = this.fwInfo.Encode();
      return json;
    }

    public static PackageInfo_6_0_0 Decode(LightJson.JsonObject json, Agent agent) {
      PackageInfo_6_0_0 inst = new PackageInfo_6_0_0();
      inst.state = (Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.State)(int)json["state"];
      inst.position = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.PosElement_4_0_0>(json["position"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.peripheral.PosElement_4_0_0.Decode(_value, agent)));
      inst.hwInfo = Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.HardwareInfo.Decode(json["hwInfo"], agent);
      inst.fwInfo = Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.FirmwareInfo.Decode(json["fwInfo"], agent);
      return inst;
    }


    public enum State {
      NORMAL,
      FW_UPDATE,
      INTERNAL_ERROR,
      CONFIG_ERROR,
    }

    public class HardwareInfo : ICloneable {
      public object Clone() {
        HardwareInfo copy = new HardwareInfo();
        copy.serial = this.serial;
        copy.packageClass = this.packageClass;
        copy.model = this.model;
        copy.minDowngradeVersion = this.minDowngradeVersion;
        copy.revision = this.revision;
        copy.address = this.address;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["serial"] = this.serial;
        json["packageClass"] = this.packageClass;
        json["model"] = this.model;
        json["minDowngradeVersion"] = this.minDowngradeVersion;
        json["revision"] = this.revision;
        json["address"] = this.address;
        return json;
      }

      public static HardwareInfo Decode(LightJson.JsonObject json, Agent agent) {
        HardwareInfo inst = new HardwareInfo();
        inst.serial = (string)json["serial"];
        inst.packageClass = (string)json["packageClass"];
        inst.model = (string)json["model"];
        inst.minDowngradeVersion = (int)json["minDowngradeVersion"];
        inst.revision = (string)json["revision"];
        inst.address = (string)json["address"];
        return inst;
      }

      public string serial = "";
      public string packageClass = "";
      public string model = "";
      public int minDowngradeVersion = 0;
      public string revision = "";
      public string address = "";
    }

    public class FirmwareInfo : ICloneable {
      public object Clone() {
        FirmwareInfo copy = new FirmwareInfo();
        copy.compileDate = this.compileDate;
        copy.version = this.version;
        copy.updateDate = this.updateDate;
        copy.firmwareName = this.firmwareName;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["compileDate"] = (this.compileDate.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["version"] = this.version.Encode();
        json["updateDate"] = (this.updateDate.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["firmwareName"] = this.firmwareName;
        return json;
      }

      public static FirmwareInfo Decode(LightJson.JsonObject json, Agent agent) {
        FirmwareInfo inst = new FirmwareInfo();
        inst.compileDate = new System.DateTime(json["compileDate"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.version = Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.FirmwareInfo.Version.Decode(json["version"], agent);
        inst.updateDate = new System.DateTime(json["updateDate"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.firmwareName = (string)json["firmwareName"];
        return inst;
      }


      public class Version : ICloneable {
        public object Clone() {
          Version copy = new Version();
          copy.majorNumber = this.majorNumber;
          copy.minorNumber = this.minorNumber;
          copy.bootloaderVersion = this.bootloaderVersion;
          return copy;
        }

        public LightJson.JsonObject Encode() {
          LightJson.JsonObject json = new LightJson.JsonObject();
          json["majorNumber"] = this.majorNumber;
          json["minorNumber"] = this.minorNumber;
          json["bootloaderVersion"] = this.bootloaderVersion;
          return json;
        }

        public static Version Decode(LightJson.JsonObject json, Agent agent) {
          Version inst = new Version();
          inst.majorNumber = (int)json["majorNumber"];
          inst.minorNumber = (int)json["minorNumber"];
          inst.bootloaderVersion = (int)json["bootloaderVersion"];
          return inst;
        }

        public int majorNumber = 0;
        public int minorNumber = 0;
        public int bootloaderVersion = 0;
      }
      public System.DateTime compileDate = new System.DateTime(0);
      public Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.FirmwareInfo.Version version = new Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.FirmwareInfo.Version();
      public System.DateTime updateDate = new System.DateTime(0);
      public string firmwareName = "";
    }
    public Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.State state = Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.State.NORMAL;
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.PosElement_4_0_0> position = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.PosElement_4_0_0>();
    public Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.HardwareInfo hwInfo = new Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.HardwareInfo();
    public Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.FirmwareInfo fwInfo = new Com.Raritan.Idl.peripheral.PackageInfo_6_0_0.FirmwareInfo();
  }
}
