/****************************************************************************/
// Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
// Copyright (C) 2001-2025 German Aerospace Center (DLR) and others.
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0/
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License 2.0 are satisfied: GNU General Public License, version 2
// or later which is available at
// https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later
/****************************************************************************/
/// @file    HelpersHBEFA4.cpp
/// @author  Daniel Krajzewicz
/// @author  Jakob Erdmann
/// @author  Michael Behrisch
/// @date    Mon, 10.05.2004
///
// Helper methods for HBEFA4-based emission computation
/****************************************************************************/
#include <config.h>

#include <limits>
#include <cmath>
#include <algorithm>
#include <utils/common/StringUtils.h>

#include "HelpersHBEFA4.h"


// ===========================================================================
// static definitions
// ===========================================================================
double
HelpersHBEFA4::myFunctionParameter[833][7][7] = {
    {
        // PC_petrol_ltECE
        { 1.707e+03, 1.538e+01, 1.044e+03, 0.000e+00, 1.557e-01, 1.184e+02, 5.952e+00 }, // CO2(total)
        { 1.002e+02, 3.562e+00, 0.000e+00, 0.000e+00, 1.278e-02, 0.000e+00, 1.204e+00 }, // CO
        { 3.049e+01, 1.764e-01, 1.458e+00, 0.000e+00, 4.676e-04, 0.000e+00, 3.881e-02 }, // HC
        { 5.532e+02, 4.987e+00, 3.384e+02, 0.000e+00, 5.047e-02, 3.839e+01, 1.930e+00 }, // FC
        { 1.485e+00, 1.457e+00, 1.015e+01, 0.000e+00, 6.143e-04, 2.584e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_ECE-15_00
        { 1.707e+03, 1.538e+01, 1.044e+03, 0.000e+00, 1.557e-01, 1.184e+02, 5.952e+00 }, // CO2(total)
        { 1.002e+02, 3.562e+00, 0.000e+00, 0.000e+00, 1.278e-02, 0.000e+00, 1.204e+00 }, // CO
        { 2.492e+01, 3.486e-01, 1.567e+00, 0.000e+00, 2.971e-04, 0.000e+00, 3.404e-02 }, // HC
        { 5.532e+02, 4.987e+00, 3.384e+02, 0.000e+00, 5.047e-02, 3.839e+01, 1.930e+00 }, // FC
        { 1.485e+00, 1.457e+00, 1.015e+01, 0.000e+00, 6.143e-04, 2.584e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_ECE-15_01_02
        { 1.707e+03, 1.538e+01, 1.044e+03, 0.000e+00, 1.557e-01, 1.184e+02, 5.952e+00 }, // CO2(total)
        { 1.002e+02, 3.562e+00, 0.000e+00, 0.000e+00, 1.278e-02, 0.000e+00, 1.204e+00 }, // CO
        { 2.055e+01, 1.450e-01, 5.129e-01, 0.000e+00, 3.724e-04, 0.000e+00, 2.883e-02 }, // HC
        { 5.532e+02, 4.987e+00, 3.384e+02, 0.000e+00, 5.047e-02, 3.839e+01, 1.930e+00 }, // FC
        { 1.485e+00, 1.457e+00, 1.015e+01, 0.000e+00, 6.143e-04, 2.584e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_ECE-15_03
        { 1.707e+03, 1.538e+01, 1.044e+03, 0.000e+00, 1.557e-01, 1.184e+02, 5.952e+00 }, // CO2(total)
        { 1.002e+02, 3.562e+00, 0.000e+00, 0.000e+00, 1.278e-02, 0.000e+00, 1.204e+00 }, // CO
        { 1.902e+01, 0.000e+00, 5.154e-01, 0.000e+00, 3.629e-04, 0.000e+00, 2.375e-02 }, // HC
        { 5.532e+02, 4.987e+00, 3.384e+02, 0.000e+00, 5.047e-02, 3.839e+01, 1.930e+00 }, // FC
        { 3.605e+00, 1.233e+00, 5.448e+00, 0.000e+00, 9.386e-04, 2.946e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_ECE-15_04
        { 1.700e+03, 1.532e+01, 1.040e+03, 0.000e+00, 1.551e-01, 1.179e+02, 5.928e+00 }, // CO2(total)
        { 1.180e+02, 0.000e+00, 0.000e+00, 0.000e+00, 9.794e-03, 0.000e+00, 8.346e-01 }, // CO
        { 1.803e+01, 0.000e+00, 1.333e+00, 0.000e+00, 2.333e-04, 0.000e+00, 1.861e-02 }, // HC
        { 5.510e+02, 4.967e+00, 3.371e+02, 0.000e+00, 5.026e-02, 3.823e+01, 1.922e+00 }, // FC
        { 4.077e+00, 1.055e+00, 2.500e+00, 0.000e+00, 1.023e-03, 2.925e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_AGV82_(CH)
        { 1.700e+03, 1.532e+01, 1.040e+03, 0.000e+00, 1.551e-01, 1.179e+02, 5.928e+00 }, // CO2(total)
        { 5.618e+01, 0.000e+00, 0.000e+00, 0.000e+00, 7.241e-03, 0.000e+00, 5.531e-01 }, // CO
        { 1.198e+01, 2.656e-01, 1.548e+00, 0.000e+00, 3.948e-05, 0.000e+00, 1.494e-02 }, // HC
        { 5.510e+02, 4.967e+00, 3.371e+02, 0.000e+00, 5.026e-02, 3.823e+01, 1.922e+00 }, // FC
        { 2.175e+00, 6.090e-01, 0.000e+00, 0.000e+00, 8.836e-04, 2.084e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_conv_other_concepts
        { 1.700e+03, 1.532e+01, 1.040e+03, 0.000e+00, 1.551e-01, 1.179e+02, 5.928e+00 }, // CO2(total)
        { 5.618e+01, 0.000e+00, 0.000e+00, 0.000e+00, 7.241e-03, 0.000e+00, 5.531e-01 }, // CO
        { 1.198e+01, 2.656e-01, 1.548e+00, 0.000e+00, 3.948e-05, 0.000e+00, 1.494e-02 }, // HC
        { 5.510e+02, 4.967e+00, 3.371e+02, 0.000e+00, 5.026e-02, 3.823e+01, 1.922e+00 }, // FC
        { 2.175e+00, 6.090e-01, 0.000e+00, 0.000e+00, 8.836e-04, 2.084e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Ucat
        { 1.700e+03, 1.532e+01, 1.040e+03, 0.000e+00, 1.551e-01, 1.179e+02, 5.928e+00 }, // CO2(total)
        { 8.337e+01, 0.000e+00, 0.000e+00, 0.000e+00, 7.702e-03, 0.000e+00, 6.296e-01 }, // CO
        { 6.410e+00, 0.000e+00, 4.668e-01, 0.000e+00, 7.934e-05, 0.000e+00, 6.487e-03 }, // HC
        { 5.510e+02, 4.967e+00, 3.371e+02, 0.000e+00, 5.026e-02, 3.823e+01, 1.922e+00 }, // FC
        { 2.846e-01, 5.850e-01, 0.000e+00, 0.000e+00, 6.654e-04, 1.676e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-1
        { 1.568e+03, 1.746e+01, 7.128e+02, 0.000e+00, 1.384e-01, 1.410e+02, 4.251e+00 }, // CO2(total)
        { 9.562e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.178e-03, 0.000e+00, 2.457e-01 }, // CO
        { 1.147e+00, 0.000e+00, 6.498e-01, 0.000e+00, 1.017e-04, 0.000e+00, 8.618e-03 }, // HC
        { 5.084e+02, 5.661e+00, 2.311e+02, 0.000e+00, 4.488e-02, 4.570e+01, 1.378e+00 }, // FC
        { 2.363e+00, 0.000e+00, 0.000e+00, 6.659e-03, 1.864e-04, 3.219e-01, 5.528e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 1.805e-05, 0.000e+00, 1.242e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_PreEuro_3WCat_lt1987
        { 1.591e+03, 1.771e+01, 7.230e+02, 0.000e+00, 1.404e-01, 1.430e+02, 4.311e+00 }, // CO2(total)
        { 9.562e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.178e-03, 0.000e+00, 2.457e-01 }, // CO
        { 1.147e+00, 0.000e+00, 6.498e-01, 0.000e+00, 1.017e-04, 0.000e+00, 8.618e-03 }, // HC
        { 5.157e+02, 5.742e+00, 2.344e+02, 0.000e+00, 4.552e-02, 4.635e+01, 1.398e+00 }, // FC
        { 2.363e+00, 0.000e+00, 0.000e+00, 6.659e-03, 1.864e-04, 3.219e-01, 5.528e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 1.805e-05, 0.000e+00, 1.242e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_PreEuro_3WCat_1987-90
        { 1.567e+03, 1.745e+01, 7.123e+02, 0.000e+00, 1.383e-01, 1.409e+02, 4.247e+00 }, // CO2(total)
        { 9.562e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.178e-03, 0.000e+00, 2.457e-01 }, // CO
        { 1.147e+00, 0.000e+00, 6.498e-01, 0.000e+00, 1.017e-04, 0.000e+00, 8.618e-03 }, // HC
        { 5.081e+02, 5.657e+00, 2.309e+02, 0.000e+00, 4.485e-02, 4.567e+01, 1.377e+00 }, // FC
        { 2.363e+00, 0.000e+00, 0.000e+00, 6.659e-03, 1.864e-04, 3.219e-01, 5.528e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 1.805e-05, 0.000e+00, 1.242e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-2
        { 1.578e+03, 1.665e+01, 7.018e+02, 0.000e+00, 1.324e-01, 1.375e+02, 4.013e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.679e-03, 0.000e+00, 3.649e-01 }, // CO
        { 0.000e+00, 3.243e-02, 0.000e+00, 5.254e-04, 0.000e+00, 6.622e-02, 9.482e-04 }, // HC
        { 5.116e+02, 5.399e+00, 2.275e+02, 0.000e+00, 4.294e-02, 4.458e+01, 1.301e+00 }, // FC
        { 1.586e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.721e-04, 0.000e+00, 8.793e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.228e-04, 2.974e-05, 0.000e+00, 2.139e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-3
        { 1.515e+03, 1.606e+01, 6.912e+02, 0.000e+00, 1.245e-01, 1.302e+02, 3.811e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.440e-03, 0.000e+00, 3.497e-01 }, // CO
        { 7.401e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.770e-05, 0.000e+00, 2.746e-03 }, // HC
        { 4.912e+02, 5.207e+00, 2.241e+02, 0.000e+00, 4.035e-02, 4.220e+01, 1.235e+00 }, // FC
        { 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.224e-05, 0.000e+00, 2.665e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.227e-04, 1.052e-05, 0.000e+00, 7.089e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-4
        { 1.521e+03, 1.559e+01, 6.951e+02, 0.000e+00, 1.199e-01, 1.325e+02, 3.434e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.059e-03, 0.000e+00, 1.832e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.132e-05, 0.000e+00, 1.202e-03 }, // HC
        { 4.931e+02, 5.054e+00, 2.253e+02, 0.000e+00, 3.887e-02, 4.296e+01, 1.113e+00 }, // FC
        { 6.117e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.485e-05, 4.339e-02, 2.726e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 5.704e-06, 0.000e+00, 3.620e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-5
        { 1.391e+03, 1.735e+01, 6.968e+02, 0.000e+00, 1.067e-01, 1.191e+02, 3.209e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.636e-03, 0.000e+00, 2.842e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.343e-05, 0.000e+00, 1.566e-03 }, // HC
        { 4.510e+02, 5.626e+00, 2.259e+02, 0.000e+00, 3.460e-02, 3.862e+01, 1.040e+00 }, // FC
        { 3.233e-01, 0.000e+00, 1.097e-01, 0.000e+00, 6.108e-06, 0.000e+00, 5.713e-04 }, // NOx
        { 7.254e-03, 2.591e-02, 0.000e+00, 1.222e-04, 3.142e-06, 6.239e-04, 1.355e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-6ab
        { 1.415e+03, 1.965e+01, 8.683e+02, 0.000e+00, 9.666e-02, 1.018e+02, 3.452e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.408e-03, 0.000e+00, 1.003e-01 }, // CO
        { 2.848e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.024e-05, 0.000e+00, 7.255e-04 }, // HC
        { 4.588e+02, 6.371e+00, 2.815e+02, 0.000e+00, 3.133e-02, 3.299e+01, 1.119e+00 }, // FC
        { 4.354e-01, 7.053e-03, 5.637e-01, 0.000e+00, 9.367e-06, 0.000e+00, 7.952e-04 }, // NOx
        { 1.255e-02, 2.592e-02, 4.491e-03, 1.215e-04, 5.535e-07, 4.365e-06, 2.068e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-6c
        { 1.465e+03, 2.071e+01, 8.826e+02, 0.000e+00, 9.886e-02, 1.074e+02, 3.474e+00 }, // CO2(total)
        { 8.851e-02, 0.000e+00, 0.000e+00, 0.000e+00, 7.724e-04, 0.000e+00, 5.287e-02 }, // CO
        { 4.523e-03, 0.000e+00, 0.000e+00, 0.000e+00, 4.427e-06, 0.000e+00, 3.364e-04 }, // HC
        { 4.750e+02, 6.714e+00, 2.861e+02, 0.000e+00, 3.205e-02, 3.481e+01, 1.126e+00 }, // FC
        { 1.596e-01, 0.000e+00, 0.000e+00, 0.000e+00, 9.269e-06, 0.000e+00, 7.923e-04 }, // NOx
        { 4.899e-03, 2.593e-02, 0.000e+00, 1.253e-04, 0.000e+00, 9.278e-05, 2.007e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-6d-temp
        { 1.498e+03, 2.487e+01, 8.713e+02, 0.000e+00, 1.014e-01, 1.244e+02, 3.378e+00 }, // CO2(total)
        { 2.929e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.203e-04, 0.000e+00, 3.141e-02 }, // CO
        { 2.228e-02, 0.000e+00, 0.000e+00, 1.201e-04, 3.816e-06, 9.731e-03, 0.000e+00 }, // HC
        { 4.855e+02, 8.063e+00, 2.825e+02, 0.000e+00, 3.287e-02, 4.031e+01, 1.095e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.257e-05, 0.000e+00, 4.355e-03 }, // NOx
        { 0.000e+00, 2.656e-02, 8.411e-03, 1.498e-04, 0.000e+00, 1.306e-03, 1.788e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-6d
        { 1.275e+03, 2.643e+01, 7.801e+02, 0.000e+00, 8.965e-02, 1.217e+02, 2.900e+00 }, // CO2(total)
        { 3.242e+00, 4.320e-02, 2.953e+00, 0.000e+00, 1.459e-04, 1.116e-01, 7.019e-03 }, // CO
        { 1.389e-02, 0.000e+00, 3.798e-02, 1.645e-04, 1.780e-06, 5.444e-03, 0.000e+00 }, // HC
        { 4.132e+02, 8.567e+00, 2.529e+02, 0.000e+00, 2.906e-02, 3.946e+01, 9.401e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.379e-05, 0.000e+00, 4.489e-03 }, // NOx
        { 0.000e+00, 2.654e-02, 1.022e-02, 1.581e-04, 0.000e+00, 1.608e-03, 1.276e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_petrol_Euro-7
        { 1.049e+03, 3.059e+01, 6.875e+02, 0.000e+00, 7.894e-02, 1.279e+02, 2.372e+00 }, // CO2(total)
        { 2.086e+00, 4.167e-02, 1.311e+00, 0.000e+00, 8.895e-05, 1.578e-01, 2.700e-03 }, // CO
        { 1.193e-02, 0.000e+00, 2.001e-02, 8.418e-05, 2.033e-06, 3.934e-03, 0.000e+00 }, // HC
        { 3.401e+02, 9.916e+00, 2.229e+02, 0.000e+00, 2.559e-02, 4.145e+01, 7.689e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.119e-05, 0.000e+00, 2.885e-03 }, // NOx
        { 0.000e+00, 2.604e-02, 1.653e-03, 1.313e-04, 0.000e+00, 4.079e-04, 8.256e-08 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_conv
        { 1.424e+03, 3.495e+01, 2.364e+02, 0.000e+00, 1.489e-01, 2.220e+02, 4.963e+00 }, // CO2(total)
        { 1.089e+01, 0.000e+00, 7.177e+00, 0.000e+00, 7.111e-04, 0.000e+00, 3.500e-02 }, // CO
        { 2.982e+00, 0.000e+00, 1.246e+00, 0.000e+00, 5.146e-05, 0.000e+00, 0.000e+00 }, // HC
        { 4.577e+02, 1.123e+01, 7.596e+01, 0.000e+00, 4.787e-02, 7.135e+01, 1.595e+00 }, // FC
        { 1.389e+00, 7.491e-01, 0.000e+00, 0.000e+00, 3.888e-04, 1.368e+00, 2.047e-02 }, // NOx
        { 9.946e-01, 2.577e-02, 1.805e+00, 1.281e-04, 2.366e-04, 1.383e-02, 6.026e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_1986-1988
        { 1.409e+03, 3.457e+01, 2.338e+02, 0.000e+00, 1.473e-01, 2.196e+02, 4.910e+00 }, // CO2(total)
        { 5.830e+00, 0.000e+00, 3.513e+00, 0.000e+00, 3.334e-04, 0.000e+00, 1.820e-02 }, // CO
        { 1.203e+00, 4.261e-04, 7.097e-01, 9.175e-04, 3.212e-06, 0.000e+00, 0.000e+00 }, // HC
        { 4.527e+02, 1.111e+01, 7.514e+01, 0.000e+00, 4.735e-02, 7.058e+01, 1.578e+00 }, // FC
        { 5.572e+00, 6.001e-02, 0.000e+00, 0.000e+00, 6.593e-04, 5.453e-01, 3.146e-02 }, // NOx
        { 7.749e-01, 2.577e-02, 0.000e+00, 9.246e-04, 1.013e-04, 1.500e-01, 4.579e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-1
        { 1.436e+03, 3.391e+01, 2.800e+02, 0.000e+00, 1.430e-01, 2.147e+02, 4.783e+00 }, // CO2(total)
        { 4.174e+00, 0.000e+00, 2.617e+00, 0.000e+00, 1.924e-04, 0.000e+00, 7.185e-03 }, // CO
        { 7.714e-01, 6.332e-03, 3.388e-01, 2.218e-04, 2.993e-06, 0.000e+00, 0.000e+00 }, // HC
        { 4.616e+02, 1.090e+01, 9.000e+01, 0.000e+00, 4.595e-02, 6.901e+01, 1.537e+00 }, // FC
        { 5.588e+00, 8.653e-02, 0.000e+00, 0.000e+00, 7.204e-04, 5.429e-01, 3.866e-02 }, // NOx
        { 9.653e-01, 2.580e-02, 0.000e+00, 1.352e-03, 7.422e-05, 1.337e-01, 2.119e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-2
        { 1.489e+03, 3.367e+01, 6.982e+02, 0.000e+00, 1.324e-01, 1.681e+02, 5.402e+00 }, // CO2(total)
        { 2.016e+00, 0.000e+00, 6.353e-01, 0.000e+00, 1.085e-05, 0.000e+00, 0.000e+00 }, // CO
        { 4.671e-01, 3.715e-03, 5.062e-02, 0.000e+00, 1.233e-06, 0.000e+00, 0.000e+00 }, // HC
        { 4.784e+02, 1.082e+01, 2.244e+02, 0.000e+00, 4.256e-02, 5.403e+01, 1.736e+00 }, // FC
        { 6.968e+00, 0.000e+00, 3.961e+00, 0.000e+00, 8.815e-04, 5.995e-03, 5.782e-02 }, // NOx
        { 7.037e-01, 2.587e-02, 3.516e-01, 1.548e-03, 1.757e-05, 5.052e-02, 1.895e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-2_(DPF)
        { 1.504e+03, 3.400e+01, 7.051e+02, 0.000e+00, 1.338e-01, 1.698e+02, 5.456e+00 }, // CO2(total)
        { 2.016e+00, 0.000e+00, 6.353e-01, 0.000e+00, 1.085e-05, 0.000e+00, 0.000e+00 }, // CO
        { 4.671e-01, 3.715e-03, 5.062e-02, 0.000e+00, 1.233e-06, 0.000e+00, 0.000e+00 }, // HC
        { 4.832e+02, 1.093e+01, 2.266e+02, 0.000e+00, 4.299e-02, 5.457e+01, 1.753e+00 }, // FC
        { 6.968e+00, 0.000e+00, 3.961e+00, 0.000e+00, 8.815e-04, 5.995e-03, 5.782e-02 }, // NOx
        { 4.926e-01, 2.587e-02, 2.462e-01, 1.121e-03, 1.230e-05, 3.537e-02, 1.895e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-3
        { 1.303e+03, 4.091e+01, 8.631e+02, 0.000e+00, 1.112e-01, 1.332e+02, 5.631e+00 }, // CO2(total)
        { 7.072e-01, 0.000e+00, 6.223e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.853e-01, 0.000e+00, 8.464e-02, 0.000e+00, 5.374e-06, 1.121e-02, 0.000e+00 }, // HC
        { 4.187e+02, 1.315e+01, 2.774e+02, 0.000e+00, 3.575e-02, 4.280e+01, 1.810e+00 }, // FC
        { 8.619e+00, 0.000e+00, 3.068e+00, 0.000e+00, 1.315e-03, 0.000e+00, 9.321e-02 }, // NOx
        { 3.827e-01, 2.739e-02, 0.000e+00, 1.228e-04, 3.161e-05, 4.437e-02, 6.649e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-3_(DPF)
        { 1.316e+03, 4.132e+01, 8.717e+02, 0.000e+00, 1.123e-01, 1.345e+02, 5.687e+00 }, // CO2(total)
        { 7.072e-01, 0.000e+00, 6.223e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.853e-01, 0.000e+00, 8.464e-02, 0.000e+00, 5.374e-06, 1.121e-02, 0.000e+00 }, // HC
        { 4.229e+02, 1.328e+01, 2.801e+02, 0.000e+00, 3.610e-02, 4.323e+01, 1.828e+00 }, // FC
        { 8.619e+00, 0.000e+00, 3.068e+00, 0.000e+00, 1.315e-03, 0.000e+00, 9.321e-02 }, // NOx
        { 2.679e-01, 2.694e-02, 0.000e+00, 1.228e-04, 2.212e-05, 3.106e-02, 4.658e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-4
        { 1.322e+03, 4.688e+01, 1.029e+03, 0.000e+00, 1.017e-01, 1.261e+02, 5.705e+00 }, // CO2(total)
        { 5.105e-01, 0.000e+00, 4.618e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.252e-01, 1.291e-03, 2.824e-02, 0.000e+00, 2.363e-06, 3.194e-03, 2.035e-05 }, // HC
        { 4.249e+02, 1.507e+01, 3.306e+02, 0.000e+00, 3.269e-02, 4.053e+01, 1.833e+00 }, // FC
        { 5.261e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.182e-03, 0.000e+00, 8.146e-02 }, // NOx
        { 3.195e-01, 3.786e-02, 9.338e-02, 1.217e-04, 1.292e-05, 3.408e-02, 3.259e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-4_(DPF)
        { 1.322e+03, 4.688e+01, 1.029e+03, 0.000e+00, 1.017e-01, 1.261e+02, 5.705e+00 }, // CO2(total)
        { 5.130e-01, 0.000e+00, 4.641e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.282e-01, 1.322e-03, 2.891e-02, 0.000e+00, 2.420e-06, 3.271e-03, 2.084e-05 }, // HC
        { 4.249e+02, 1.507e+01, 3.306e+02, 0.000e+00, 3.269e-02, 4.053e+01, 1.833e+00 }, // FC
        { 5.508e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.237e-03, 0.000e+00, 8.529e-02 }, // NOx
        { 0.000e+00, 2.592e-02, 0.000e+00, 1.217e-04, 7.885e-06, 0.000e+00, 6.286e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-5
        { 1.246e+03, 4.541e+01, 9.019e+02, 0.000e+00, 9.496e-02, 1.285e+02, 5.049e+00 }, // CO2(total)
        { 3.936e-01, 0.000e+00, 4.226e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.097e-01, 0.000e+00, 2.103e-02, 0.000e+00, 1.313e-06, 9.644e-04, 0.000e+00 }, // HC
        { 4.004e+02, 1.459e+01, 2.899e+02, 0.000e+00, 3.052e-02, 4.129e+01, 1.623e+00 }, // FC
        { 1.005e+01, 1.932e-02, 1.517e+00, 0.000e+00, 1.125e-03, 1.982e-01, 7.930e-02 }, // NOx
        { 2.772e-02, 2.592e-02, 1.079e-02, 1.217e-04, 7.573e-07, 0.000e+00, 3.005e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-5_other_SU_before_software_update
        { 1.246e+03, 4.541e+01, 9.019e+02, 0.000e+00, 9.496e-02, 1.285e+02, 5.049e+00 }, // CO2(total)
        { 3.936e-01, 0.000e+00, 4.226e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.097e-01, 0.000e+00, 2.103e-02, 0.000e+00, 1.313e-06, 9.644e-04, 0.000e+00 }, // HC
        { 4.004e+02, 1.459e+01, 2.899e+02, 0.000e+00, 3.052e-02, 4.129e+01, 1.623e+00 }, // FC
        { 9.240e+00, 1.776e-02, 1.395e+00, 0.000e+00, 1.034e-03, 1.823e-01, 7.293e-02 }, // NOx
        { 2.772e-02, 2.592e-02, 1.079e-02, 1.217e-04, 7.573e-07, 0.000e+00, 3.005e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-5_EA189_before_software_update
        { 1.246e+03, 4.541e+01, 9.019e+02, 0.000e+00, 9.496e-02, 1.285e+02, 5.049e+00 }, // CO2(total)
        { 3.936e-01, 0.000e+00, 4.226e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.097e-01, 0.000e+00, 2.103e-02, 0.000e+00, 1.313e-06, 9.644e-04, 0.000e+00 }, // HC
        { 4.004e+02, 1.459e+01, 2.899e+02, 0.000e+00, 3.052e-02, 4.129e+01, 1.623e+00 }, // FC
        { 6.822e+00, 1.311e-02, 1.030e+00, 0.000e+00, 7.635e-04, 1.346e-01, 5.384e-02 }, // NOx
        { 2.772e-02, 2.592e-02, 1.079e-02, 1.217e-04, 7.573e-07, 0.000e+00, 3.005e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-5_EA189_after_software_update
        { 1.294e+03, 4.716e+01, 9.367e+02, 0.000e+00, 9.862e-02, 1.334e+02, 5.243e+00 }, // CO2(total)
        { 1.135e-01, 0.000e+00, 2.991e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.390e-01, 0.000e+00, 0.000e+00, 0.000e+00, 7.821e-07, 0.000e+00, 0.000e+00 }, // HC
        { 4.159e+02, 1.516e+01, 3.010e+02, 0.000e+00, 3.170e-02, 4.288e+01, 1.685e+00 }, // FC
        { 2.881e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.185e-04, 0.000e+00, 6.065e-02 }, // NOx
        { 2.772e-02, 2.592e-02, 3.902e-04, 1.217e-04, 1.445e-07, 0.000e+00, 3.391e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-5_other_SU_after_software_update
        { 1.258e+03, 4.589e+01, 9.068e+02, 0.000e+00, 9.586e-02, 1.302e+02, 5.088e+00 }, // CO2(total)
        { 6.694e-01, 0.000e+00, 6.279e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.098e-01, 0.000e+00, 2.112e-02, 0.000e+00, 1.309e-06, 9.638e-04, 0.000e+00 }, // HC
        { 4.044e+02, 1.475e+01, 2.914e+02, 0.000e+00, 3.081e-02, 4.186e+01, 1.635e+00 }, // FC
        { 3.267e+00, 8.569e-03, 0.000e+00, 1.233e-02, 2.320e-04, 6.566e-01, 1.565e-02 }, // NOx
        { 2.772e-02, 2.592e-02, 1.080e-02, 1.217e-04, 7.557e-07, 0.000e+00, 2.994e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-6ab
        { 1.260e+03, 4.817e+01, 8.350e+02, 0.000e+00, 9.099e-02, 1.438e+02, 4.551e+00 }, // CO2(total)
        { 9.962e-01, 0.000e+00, 4.265e-01, 0.000e+00, 3.406e-05, 0.000e+00, 2.555e-03 }, // CO
        { 1.659e-01, 4.137e-03, 1.374e-01, 0.000e+00, 8.975e-06, 4.434e-03, 7.280e-04 }, // HC
        { 4.049e+02, 1.548e+01, 2.684e+02, 0.000e+00, 2.924e-02, 4.621e+01, 1.463e+00 }, // FC
        { 3.561e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.544e-04, 0.000e+00, 4.371e-02 }, // NOx
        { 5.706e-03, 2.593e-02, 0.000e+00, 1.213e-04, 8.150e-07, 7.685e-04, 1.829e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-6ab_SU_before_software_update
        { 1.260e+03, 4.817e+01, 8.350e+02, 0.000e+00, 9.099e-02, 1.438e+02, 4.551e+00 }, // CO2(total)
        { 9.962e-01, 0.000e+00, 4.265e-01, 0.000e+00, 3.406e-05, 0.000e+00, 2.555e-03 }, // CO
        { 1.659e-01, 4.137e-03, 1.374e-01, 0.000e+00, 8.975e-06, 4.434e-03, 7.280e-04 }, // HC
        { 4.049e+02, 1.548e+01, 2.684e+02, 0.000e+00, 2.924e-02, 4.621e+01, 1.463e+00 }, // FC
        { 1.008e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.569e-03, 0.000e+00, 1.237e-01 }, // NOx
        { 5.706e-03, 2.593e-02, 0.000e+00, 1.213e-04, 8.150e-07, 7.685e-04, 1.829e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-6ab_SU_after_software_update
        { 1.267e+03, 4.837e+01, 8.376e+02, 0.000e+00, 9.141e-02, 1.448e+02, 4.560e+00 }, // CO2(total)
        { 7.629e-01, 0.000e+00, 2.225e-01, 0.000e+00, 2.676e-05, 0.000e+00, 2.988e-03 }, // CO
        { 1.659e-01, 4.140e-03, 1.373e-01, 0.000e+00, 8.961e-06, 4.485e-03, 7.253e-04 }, // HC
        { 4.072e+02, 1.554e+01, 2.692e+02, 0.000e+00, 2.938e-02, 4.655e+01, 1.465e+00 }, // FC
        { 3.021e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.751e-04, 0.000e+00, 5.908e-02 }, // NOx
        { 5.707e-03, 2.593e-02, 0.000e+00, 1.213e-04, 8.149e-07, 7.701e-04, 1.821e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-6c
        { 1.310e+03, 5.055e+01, 8.488e+02, 0.000e+00, 9.371e-02, 1.527e+02, 4.624e+00 }, // CO2(total)
        { 4.459e-01, 1.678e-03, 1.815e-01, 0.000e+00, 1.684e-05, 0.000e+00, 1.232e-03 }, // CO
        { 6.953e-03, 1.090e-02, 0.000e+00, 1.710e-04, 0.000e+00, 2.663e-02, 1.664e-04 }, // HC
        { 4.212e+02, 1.624e+01, 2.728e+02, 0.000e+00, 3.012e-02, 4.906e+01, 1.486e+00 }, // FC
        { 1.965e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.045e-04, 0.000e+00, 2.338e-02 }, // NOx
        { 3.784e-03, 2.593e-02, 0.000e+00, 1.213e-04, 7.824e-07, 0.000e+00, 5.195e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-6d-temp
        { 1.388e+03, 5.559e+01, 9.061e+02, 0.000e+00, 9.872e-02, 1.678e+02, 4.825e+00 }, // CO2(total)
        { 1.533e-01, 0.000e+00, 0.000e+00, 3.152e-04, 1.996e-06, 7.265e-03, 4.382e-04 }, // CO
        { 0.000e+00, 9.922e-03, 0.000e+00, 1.700e-04, 0.000e+00, 2.900e-02, 9.104e-05 }, // HC
        { 4.462e+02, 1.787e+01, 2.912e+02, 0.000e+00, 3.173e-02, 5.391e+01, 1.551e+00 }, // FC
        { 3.375e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.836e-05, 1.484e-02, 3.690e-03 }, // NOx
        { 2.982e-03, 2.593e-02, 0.000e+00, 1.213e-04, 7.279e-07, 0.000e+00, 5.376e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-6d
        { 1.299e+03, 5.480e+01, 8.665e+02, 0.000e+00, 9.259e-02, 1.651e+02, 4.467e+00 }, // CO2(total)
        { 1.402e-01, 0.000e+00, 0.000e+00, 2.497e-04, 2.618e-06, 5.392e-03, 4.259e-04 }, // CO
        { 0.000e+00, 8.486e-03, 0.000e+00, 1.655e-04, 0.000e+00, 2.449e-02, 1.440e-04 }, // HC
        { 4.174e+02, 1.761e+01, 2.785e+02, 0.000e+00, 2.976e-02, 5.307e+01, 1.435e+00 }, // FC
        { 2.819e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.057e-05, 1.544e-02, 3.125e-03 }, // NOx
        { 2.851e-03, 2.593e-02, 0.000e+00, 1.213e-04, 6.171e-07, 0.000e+00, 4.547e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_diesel_Euro-7
        { 1.150e+03, 5.308e+01, 8.093e+02, 0.000e+00, 8.234e-02, 1.578e+02, 3.917e+00 }, // CO2(total)
        { 1.199e+00, 0.000e+00, 9.974e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.693e-02, 0.000e+00, 1.082e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 3.695e+02, 1.706e+01, 2.601e+02, 0.000e+00, 2.646e-02, 5.072e+01, 1.259e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.024e-05, 0.000e+00, 1.802e-03 }, // NOx
        { 2.829e-03, 2.593e-02, 0.000e+00, 1.213e-04, 4.966e-07, 4.323e-07, 3.628e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-2_(CNG)
        { 1.321e+03, 1.394e+01, 5.873e+02, 0.000e+00, 1.108e-01, 1.151e+02, 3.358e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.147e-03, 0.000e+00, 4.014e-01 }, // CO
        { 0.000e+00, 4.865e-02, 0.000e+00, 7.881e-04, 0.000e+00, 9.933e-02, 1.422e-03 }, // HC
        { 4.249e+02, 4.484e+00, 1.890e+02, 0.000e+00, 3.566e-02, 3.703e+01, 1.081e+00 }, // FC
        { 1.586e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.721e-04, 0.000e+00, 8.793e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.228e-04, 4.461e-05, 0.000e+00, 3.208e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-2_(P)
        { 1.481e+03, 1.563e+01, 6.587e+02, 0.000e+00, 1.243e-01, 1.291e+02, 3.767e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.679e-03, 0.000e+00, 3.649e-01 }, // CO
        { 0.000e+00, 3.243e-02, 0.000e+00, 5.254e-04, 0.000e+00, 6.622e-02, 9.482e-04 }, // HC
        { 4.802e+02, 5.067e+00, 2.135e+02, 0.000e+00, 4.030e-02, 4.184e+01, 1.221e+00 }, // FC
        { 1.586e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.721e-04, 0.000e+00, 8.793e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.228e-04, 2.974e-05, 0.000e+00, 2.139e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-3_(CNG)
        { 1.351e+03, 1.432e+01, 6.162e+02, 0.000e+00, 1.110e-01, 1.160e+02, 3.397e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.884e-03, 0.000e+00, 3.846e-01 }, // CO
        { 1.110e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.656e-05, 0.000e+00, 4.118e-03 }, // HC
        { 4.347e+02, 4.608e+00, 1.983e+02, 0.000e+00, 3.570e-02, 3.734e+01, 1.093e+00 }, // FC
        { 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.224e-05, 0.000e+00, 2.665e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.227e-04, 1.578e-05, 0.000e+00, 1.063e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-3_(P)
        { 1.515e+03, 1.606e+01, 6.912e+02, 0.000e+00, 1.245e-01, 1.302e+02, 3.811e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.440e-03, 0.000e+00, 3.497e-01 }, // CO
        { 7.401e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.770e-05, 0.000e+00, 2.746e-03 }, // HC
        { 4.912e+02, 5.207e+00, 2.241e+02, 0.000e+00, 4.035e-02, 4.220e+01, 1.235e+00 }, // FC
        { 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.224e-05, 0.000e+00, 2.665e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.227e-04, 1.052e-05, 0.000e+00, 7.089e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-4_(CNG)
        { 1.381e+03, 1.565e+01, 6.106e+02, 0.000e+00, 1.088e-01, 1.251e+02, 3.145e+00 }, // CO2(total)
        { 0.000e+00, 2.496e-01, 2.085e+00, 5.308e-03, 0.000e+00, 3.498e-01, 0.000e+00 }, // CO
        { 2.862e-01, 0.000e+00, 0.000e+00, 1.321e-03, 3.989e-06, 5.056e-02, 4.038e-04 }, // HC
        { 4.444e+02, 5.034e+00, 1.965e+02, 0.000e+00, 3.499e-02, 4.027e+01, 1.012e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.088e-04, 0.000e+00, 2.975e-02 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.231e-04, 1.609e-05, 3.540e-03, 4.799e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-4_(P)
        { 1.552e+03, 1.758e+01, 6.861e+02, 0.000e+00, 1.222e-01, 1.406e+02, 3.534e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.132e-03, 0.000e+00, 1.905e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.170e-05, 0.000e+00, 1.241e-03 }, // HC
        { 5.031e+02, 5.699e+00, 2.224e+02, 0.000e+00, 3.961e-02, 4.558e+01, 1.146e+00 }, // FC
        { 6.070e-01, 1.361e-03, 0.000e+00, 0.000e+00, 5.441e-05, 4.530e-02, 2.739e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.231e-04, 5.787e-06, 0.000e+00, 3.696e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-5_(CNG)
        { 1.206e+03, 1.530e+01, 6.394e+02, 0.000e+00, 9.225e-02, 9.996e+01, 2.945e+00 }, // CO2(total)
        { 0.000e+00, 2.222e-01, 6.680e-01, 1.006e-02, 0.000e+00, 5.349e-01, 0.000e+00 }, // CO
        { 3.767e-01, 0.000e+00, 0.000e+00, 1.455e-03, 1.102e-05, 4.956e-02, 1.088e-03 }, // HC
        { 3.882e+02, 4.925e+00, 2.057e+02, 0.000e+00, 2.968e-02, 3.217e+01, 9.475e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.558e-04, 0.000e+00, 1.073e-02 }, // NOx
        { 0.000e+00, 2.591e-02, 0.000e+00, 1.219e-04, 1.895e-05, 0.000e+00, 8.564e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-5_(P)
        { 1.355e+03, 1.720e+01, 7.184e+02, 0.000e+00, 1.037e-01, 1.123e+02, 3.309e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.799e-03, 0.000e+00, 2.998e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.406e-05, 0.000e+00, 1.626e-03 }, // HC
        { 4.394e+02, 5.576e+00, 2.329e+02, 0.000e+00, 3.360e-02, 3.641e+01, 1.073e+00 }, // FC
        { 3.237e-01, 0.000e+00, 1.109e-01, 0.000e+00, 6.170e-06, 0.000e+00, 5.733e-04 }, // NOx
        { 8.119e-03, 2.591e-02, 0.000e+00, 1.219e-04, 3.131e-06, 8.992e-04, 1.285e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-6_(CNG)
        { 1.098e+03, 1.543e+01, 6.995e+02, 0.000e+00, 7.481e-02, 7.646e+01, 2.804e+00 }, // CO2(total)
        { 1.783e+00, 0.000e+00, 1.357e+00, 0.000e+00, 7.820e-05, 0.000e+00, 3.762e-03 }, // CO
        { 1.638e-01, 0.000e+00, 0.000e+00, 0.000e+00, 2.439e-05, 0.000e+00, 1.553e-03 }, // HC
        { 3.532e+02, 4.964e+00, 2.251e+02, 0.000e+00, 2.407e-02, 2.460e+01, 9.022e-01 }, // FC
        { 8.225e-02, 0.000e+00, 0.000e+00, 0.000e+00, 9.429e-06, 0.000e+00, 6.191e-04 }, // NOx
        { 5.162e-03, 2.593e-02, 0.000e+00, 1.215e-04, 2.003e-06, 0.000e+00, 8.574e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_CNG_petrol_Euro-6_(P)
        { 1.233e+03, 1.733e+01, 7.860e+02, 0.000e+00, 8.405e-02, 8.591e+01, 3.150e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.428e-03, 0.000e+00, 1.021e-01 }, // CO
        { 2.912e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.041e-05, 0.000e+00, 7.440e-04 }, // HC
        { 3.998e+02, 5.620e+00, 2.548e+02, 0.000e+00, 2.725e-02, 2.785e+01, 1.021e+00 }, // FC
        { 4.453e-01, 6.698e-03, 5.629e-01, 0.000e+00, 9.810e-06, 0.000e+00, 8.420e-04 }, // NOx
        { 1.268e-02, 2.593e-02, 4.616e-03, 1.215e-04, 5.474e-07, 0.000e+00, 2.133e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-3__(E85)
        { 1.550e+03, 1.643e+01, 7.068e+02, 0.000e+00, 1.273e-01, 1.331e+02, 3.897e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.440e-03, 0.000e+00, 3.497e-01 }, // CO
        { 7.401e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.770e-05, 0.000e+00, 2.746e-03 }, // HC
        { 7.564e+02, 8.018e+00, 3.450e+02, 0.000e+00, 6.212e-02, 6.497e+01, 1.902e+00 }, // FC
        { 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.224e-05, 0.000e+00, 2.665e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.227e-04, 1.052e-05, 0.000e+00, 7.089e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-3__(P)
        { 1.515e+03, 1.606e+01, 6.912e+02, 0.000e+00, 1.245e-01, 1.302e+02, 3.811e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.440e-03, 0.000e+00, 3.497e-01 }, // CO
        { 7.401e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.770e-05, 0.000e+00, 2.746e-03 }, // HC
        { 4.912e+02, 5.207e+00, 2.241e+02, 0.000e+00, 4.035e-02, 4.220e+01, 1.235e+00 }, // FC
        { 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.224e-05, 0.000e+00, 2.665e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.227e-04, 1.052e-05, 0.000e+00, 7.089e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-4__(E85)
        { 2.087e+03, 2.139e+01, 9.537e+02, 0.000e+00, 1.645e-01, 1.818e+02, 4.711e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.059e-03, 0.000e+00, 1.832e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.132e-05, 0.000e+00, 1.202e-03 }, // HC
        { 1.019e+03, 1.044e+01, 4.655e+02, 0.000e+00, 8.030e-02, 8.874e+01, 2.299e+00 }, // FC
        { 6.117e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.485e-05, 4.339e-02, 2.726e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 3.992e-06, 0.000e+00, 2.538e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-4__(P)
        { 1.511e+03, 1.549e+01, 6.908e+02, 0.000e+00, 1.192e-01, 1.317e+02, 3.412e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.059e-03, 0.000e+00, 1.832e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.132e-05, 0.000e+00, 1.202e-03 }, // HC
        { 4.900e+02, 5.022e+00, 2.239e+02, 0.000e+00, 3.863e-02, 4.269e+01, 1.106e+00 }, // FC
        { 6.117e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.485e-05, 4.339e-02, 2.726e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 5.704e-06, 0.000e+00, 3.620e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-5__(E85)
        { 1.916e+03, 2.390e+01, 9.597e+02, 0.000e+00, 1.470e-01, 1.641e+02, 4.419e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.636e-03, 0.000e+00, 2.842e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.343e-05, 0.000e+00, 1.566e-03 }, // HC
        { 9.352e+02, 1.167e+01, 4.684e+02, 0.000e+00, 7.175e-02, 8.009e+01, 2.157e+00 }, // FC
        { 3.233e-01, 0.000e+00, 1.097e-01, 0.000e+00, 6.108e-06, 0.000e+00, 5.713e-04 }, // NOx
        { 5.077e-03, 2.591e-02, 0.000e+00, 1.222e-04, 2.200e-06, 4.367e-04, 9.511e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-5__(P)
        { 1.388e+03, 1.731e+01, 6.952e+02, 0.000e+00, 1.065e-01, 1.189e+02, 3.201e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.636e-03, 0.000e+00, 2.842e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.343e-05, 0.000e+00, 1.566e-03 }, // HC
        { 4.499e+02, 5.613e+00, 2.254e+02, 0.000e+00, 3.452e-02, 3.853e+01, 1.038e+00 }, // FC
        { 3.233e-01, 0.000e+00, 1.097e-01, 0.000e+00, 6.108e-06, 0.000e+00, 5.713e-04 }, // NOx
        { 7.254e-03, 2.591e-02, 0.000e+00, 1.222e-04, 3.142e-06, 6.239e-04, 1.355e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-6__(E85)
        { 1.949e+03, 2.706e+01, 1.195e+03, 0.000e+00, 1.331e-01, 1.401e+02, 4.752e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.408e-03, 0.000e+00, 1.003e-01 }, // CO
        { 2.848e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.024e-05, 0.000e+00, 7.255e-04 }, // HC
        { 9.511e+02, 1.321e+01, 5.835e+02, 0.000e+00, 6.495e-02, 6.839e+01, 2.319e+00 }, // FC
        { 4.354e-01, 7.053e-03, 5.637e-01, 0.000e+00, 9.367e-06, 0.000e+00, 7.952e-04 }, // NOx
        { 8.787e-03, 2.592e-02, 3.144e-03, 1.215e-04, 3.875e-07, 3.055e-06, 2.068e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FFV_Euro-6__(P)
        { 1.411e+03, 1.960e+01, 8.660e+02, 0.000e+00, 9.639e-02, 1.015e+02, 3.442e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.408e-03, 0.000e+00, 1.003e-01 }, // CO
        { 2.848e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.024e-05, 0.000e+00, 7.255e-04 }, // HC
        { 4.576e+02, 6.354e+00, 2.807e+02, 0.000e+00, 3.125e-02, 3.290e+01, 1.116e+00 }, // FC
        { 4.354e-01, 7.053e-03, 5.637e-01, 0.000e+00, 9.367e-06, 0.000e+00, 7.952e-04 }, // NOx
        { 1.255e-02, 2.592e-02, 4.491e-03, 1.215e-04, 5.535e-07, 4.365e-06, 2.068e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_BEV
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.593e-02, 0.000e+00, 1.213e-04, 0.000e+00, 4.941e-18, 0.000e+00 }, // PM + PM (non-exhaust)
        { 8.055e-01, 4.277e-02, 7.606e-01, 0.000e+00, 9.867e-05, 2.461e-01, 1.906e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-4_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.568e-02, 0.000e+00, 1.330e-04, 0.000e+00, 0.000e+00, 1.156e-05 }, // PM + PM (non-exhaust)
        { 6.658e-01, 6.083e-02, 0.000e+00, 0.000e+00, 1.291e-04, 3.559e-01, 1.768e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-4_(P)
        { 1.095e+03, 6.500e+01, 1.458e+02, 0.000e+00, 9.933e-02, 1.732e+02, 4.238e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.799e-03, 0.000e+00, 1.651e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.056e-05, 0.000e+00, 1.163e-03 }, // HC
        { 3.551e+02, 2.107e+01, 4.727e+01, 0.000e+00, 3.220e-02, 5.614e+01, 1.374e+00 }, // FC
        { 5.298e-01, 6.836e-03, 0.000e+00, 0.000e+00, 5.301e-05, 4.691e-02, 2.826e-03 }, // NOx
        { 0.000e+00, 2.568e-02, 0.000e+00, 1.330e-04, 5.555e-06, 0.000e+00, 3.625e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.574e-02, 0.000e+00, 1.302e-04, 0.000e+00, 0.000e+00, 9.834e-06 }, // PM + PM (non-exhaust)
        { 6.031e-01, 6.283e-02, 0.000e+00, 0.000e+00, 1.291e-04, 3.527e-01, 2.090e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-5_(P)
        { 7.748e+02, 6.472e+01, 1.818e+02, 0.000e+00, 9.202e-02, 1.488e+02, 4.497e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.260e-03, 0.000e+00, 2.553e-01 }, // CO
        { 1.843e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.238e-05, 0.000e+00, 1.544e-03 }, // HC
        { 2.512e+02, 2.098e+01, 5.895e+01, 0.000e+00, 2.983e-02, 4.825e+01, 1.458e+00 }, // FC
        { 2.800e-01, 3.274e-03, 1.047e-01, 0.000e+00, 4.355e-06, 0.000e+00, 5.759e-04 }, // NOx
        { 6.752e-03, 2.574e-02, 0.000e+00, 1.302e-04, 3.298e-06, 1.945e-04, 1.734e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-6d_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.579e-02, 0.000e+00, 1.273e-04, 0.000e+00, 0.000e+00, 5.496e-06 }, // PM + PM (non-exhaust)
        { 8.915e-01, 5.406e-02, 0.000e+00, 0.000e+00, 1.328e-04, 3.515e-01, 2.720e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-6d_(P)
        { 9.793e+02, 4.393e+01, 0.000e+00, 0.000e+00, 8.914e-02, 1.854e+02, 2.821e+00 }, // CO2(total)
        { 3.151e+00, 0.000e+00, 1.327e-01, 0.000e+00, 4.156e-04, 0.000e+00, 3.169e-02 }, // CO
        { 2.247e-02, 1.119e-03, 0.000e+00, 0.000e+00, 6.569e-06, 1.022e-02, 0.000e+00 }, // HC
        { 3.175e+02, 1.424e+01, 0.000e+00, 0.000e+00, 2.890e-02, 6.010e+01, 9.144e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.309e-05, 0.000e+00, 4.444e-03 }, // NOx
        { 0.000e+00, 2.625e-02, 2.272e-03, 1.625e-04, 0.000e+00, 1.622e-03, 5.496e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-6ab_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.579e-02, 0.000e+00, 1.282e-04, 0.000e+00, 0.000e+00, 8.206e-06 }, // PM + PM (non-exhaust)
        { 7.792e-01, 5.934e-02, 0.000e+00, 0.000e+00, 1.306e-04, 3.514e-01, 2.548e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_petrol_Euro-6ab_(P)
        { 1.015e+03, 4.670e+01, 0.000e+00, 0.000e+00, 9.112e-02, 1.619e+02, 4.265e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.384e-03, 0.000e+00, 9.960e-02 }, // CO
        { 3.990e-02, 0.000e+00, 0.000e+00, 0.000e+00, 9.858e-06, 0.000e+00, 7.310e-04 }, // HC
        { 3.290e+02, 1.514e+01, 0.000e+00, 0.000e+00, 2.954e-02, 5.248e+01, 1.383e+00 }, // FC
        { 2.791e-01, 2.024e-02, 3.231e-01, 0.000e+00, 9.536e-07, 3.053e-02, 0.000e+00 }, // NOx
        { 1.178e-02, 2.579e-02, 0.000e+00, 1.282e-04, 6.106e-07, 2.435e-04, 8.206e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-4_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.575e-02, 0.000e+00, 1.290e-04, 0.000e+00, 0.000e+00, 6.685e-06 }, // PM + PM (non-exhaust)
        { 9.204e-01, 8.152e-02, 0.000e+00, 0.000e+00, 1.368e-04, 4.708e-01, 1.603e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-4_(D)
        { 1.020e+03, 9.640e+01, 2.399e+02, 0.000e+00, 9.136e-02, 2.380e+02, 4.020e+00 }, // CO2(total)
        { 5.083e-01, 0.000e+00, 4.543e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.218e-01, 1.591e-03, 2.149e-02, 0.000e+00, 2.181e-06, 4.050e-03, 0.000e+00 }, // HC
        { 3.278e+02, 3.098e+01, 7.711e+01, 0.000e+00, 2.936e-02, 7.650e+01, 1.292e+00 }, // FC
        { 4.376e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.071e-04, 0.000e+00, 6.405e-02 }, // NOx
        { 3.316e-01, 3.653e-02, 6.366e-02, 1.290e-04, 1.391e-05, 3.592e-02, 6.685e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.575e-02, 0.000e+00, 1.290e-04, 0.000e+00, 0.000e+00, 6.634e-06 }, // PM + PM (non-exhaust)
        { 1.042e+00, 7.780e-02, 0.000e+00, 0.000e+00, 1.505e-04, 4.715e-01, 2.382e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-5_(D)
        { 1.089e+03, 8.747e+01, 1.004e+01, 0.000e+00, 8.849e-02, 2.311e+02, 3.686e+00 }, // CO2(total)
        { 3.928e-01, 0.000e+00, 4.199e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.105e-01, 0.000e+00, 2.499e-02, 0.000e+00, 1.258e-06, 7.655e-04, 0.000e+00 }, // HC
        { 3.499e+02, 2.811e+01, 3.228e+00, 0.000e+00, 2.844e-02, 7.429e+01, 1.185e+00 }, // FC
        { 6.837e+00, 9.580e-03, 1.302e+00, 0.000e+00, 8.001e-04, 3.246e-02, 5.998e-02 }, // NOx
        { 2.517e-02, 2.602e-02, 3.787e-03, 1.290e-04, 5.561e-07, 1.090e-03, 6.634e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-6d_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.585e-02, 0.000e+00, 1.245e-04, 0.000e+00, 0.000e+00, 2.553e-06 }, // PM + PM (non-exhaust)
        { 1.094e+00, 8.091e-02, 0.000e+00, 0.000e+00, 1.481e-04, 4.762e-01, 3.069e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-6d_(D)
        { 1.097e+03, 9.069e+01, 0.000e+00, 0.000e+00, 7.755e-02, 2.160e+02, 4.262e+00 }, // CO2(total)
        { 1.723e-01, 0.000e+00, 0.000e+00, 1.519e-04, 6.563e-06, 3.542e-03, 5.827e-04 }, // CO
        { 0.000e+00, 8.752e-03, 0.000e+00, 2.138e-04, 0.000e+00, 2.478e-02, 2.492e-04 }, // HC
        { 3.526e+02, 2.914e+01, 0.000e+00, 0.000e+00, 2.492e-02, 6.942e+01, 1.370e+00 }, // FC
        { 3.237e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.898e-05, 8.745e-03, 3.932e-03 }, // NOx
        { 3.504e-03, 2.585e-02, 0.000e+00, 1.245e-04, 7.016e-07, 0.000e+00, 5.555e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-6ab_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.584e-02, 0.000e+00, 1.250e-04, 0.000e+00, 0.000e+00, 3.045e-06 }, // PM + PM (non-exhaust)
        { 1.017e+00, 8.283e-02, 0.000e+00, 0.000e+00, 1.445e-04, 4.803e-01, 2.518e-03 }, // FC_MJ
    },
    {
        // PC_PHEV_diesel_Euro-6ab_(D)
        { 1.123e+03, 9.269e+01, 0.000e+00, 0.000e+00, 8.372e-02, 2.208e+02, 4.361e+00 }, // CO2(total)
        { 1.011e+00, 0.000e+00, 4.723e-01, 0.000e+00, 3.342e-05, 0.000e+00, 2.501e-03 }, // CO
        { 1.679e-01, 3.903e-03, 1.639e-01, 0.000e+00, 9.265e-06, 9.468e-04, 8.263e-04 }, // HC
        { 3.611e+02, 2.979e+01, 0.000e+00, 0.000e+00, 2.691e-02, 7.098e+01, 1.401e+00 }, // FC
        { 3.519e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.409e-04, 0.000e+00, 4.304e-02 }, // NOx
        { 5.705e-03, 2.584e-02, 0.000e+00, 1.250e-04, 8.220e-07, 7.659e-04, 2.216e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-2_(LPG)
        { 1.412e+03, 1.490e+01, 6.278e+02, 0.000e+00, 1.185e-01, 1.230e+02, 3.590e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.679e-03, 0.000e+00, 3.649e-01 }, // CO
        { 0.000e+00, 3.243e-02, 0.000e+00, 5.254e-04, 0.000e+00, 6.622e-02, 9.482e-04 }, // HC
        { 4.570e+02, 4.822e+00, 2.032e+02, 0.000e+00, 3.835e-02, 3.982e+01, 1.162e+00 }, // FC
        { 1.586e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.721e-04, 0.000e+00, 8.793e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.228e-04, 0.000e+00, 0.000e+00, 1.308e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-2_(P)
        { 1.487e+03, 1.569e+01, 6.612e+02, 0.000e+00, 1.248e-01, 1.296e+02, 3.781e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.679e-03, 0.000e+00, 3.649e-01 }, // CO
        { 0.000e+00, 3.243e-02, 0.000e+00, 5.254e-04, 0.000e+00, 6.622e-02, 9.482e-04 }, // HC
        { 4.820e+02, 5.086e+00, 2.144e+02, 0.000e+00, 4.045e-02, 4.200e+01, 1.226e+00 }, // FC
        { 1.586e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.721e-04, 0.000e+00, 8.793e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.228e-04, 2.974e-05, 0.000e+00, 2.139e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-3_(LPG)
        { 1.439e+03, 1.525e+01, 6.562e+02, 0.000e+00, 1.182e-01, 1.236e+02, 3.618e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.440e-03, 0.000e+00, 3.497e-01 }, // CO
        { 7.401e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.770e-05, 0.000e+00, 2.746e-03 }, // HC
        { 4.657e+02, 4.937e+00, 2.124e+02, 0.000e+00, 3.825e-02, 4.000e+01, 1.171e+00 }, // FC
        { 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.224e-05, 0.000e+00, 2.665e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.227e-04, 0.000e+00, 0.000e+00, 1.235e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-3_(P)
        { 1.515e+03, 1.606e+01, 6.912e+02, 0.000e+00, 1.245e-01, 1.302e+02, 3.811e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.440e-03, 0.000e+00, 3.497e-01 }, // CO
        { 7.401e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.770e-05, 0.000e+00, 2.746e-03 }, // HC
        { 4.912e+02, 5.207e+00, 2.241e+02, 0.000e+00, 4.035e-02, 4.220e+01, 1.235e+00 }, // FC
        { 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.224e-05, 0.000e+00, 2.665e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.227e-04, 1.052e-05, 0.000e+00, 7.089e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-4_(LPG)
        { 1.434e+03, 1.469e+01, 6.552e+02, 0.000e+00, 1.130e-01, 1.249e+02, 3.237e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.059e-03, 0.000e+00, 1.832e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.132e-05, 0.000e+00, 1.202e-03 }, // HC
        { 4.640e+02, 4.756e+00, 2.121e+02, 0.000e+00, 3.659e-02, 4.043e+01, 1.048e+00 }, // FC
        { 6.117e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.485e-05, 4.339e-02, 2.726e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 0.000e+00, 0.000e+00, 1.405e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-4_(P)
        { 1.510e+03, 1.548e+01, 6.901e+02, 0.000e+00, 1.190e-01, 1.316e+02, 3.409e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.059e-03, 0.000e+00, 1.832e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.132e-05, 0.000e+00, 1.202e-03 }, // HC
        { 4.895e+02, 5.017e+00, 2.237e+02, 0.000e+00, 3.859e-02, 4.265e+01, 1.105e+00 }, // FC
        { 6.117e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.485e-05, 4.339e-02, 2.726e-03 }, // NOx
        { 0.000e+00, 2.589e-02, 0.000e+00, 1.229e-04, 5.704e-06, 0.000e+00, 3.620e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-5_(LPG)
        { 1.280e+03, 1.597e+01, 6.412e+02, 0.000e+00, 9.821e-02, 1.096e+02, 2.952e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.636e-03, 0.000e+00, 2.842e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.343e-05, 0.000e+00, 1.566e-03 }, // HC
        { 4.143e+02, 5.169e+00, 2.075e+02, 0.000e+00, 3.179e-02, 3.549e+01, 9.557e-01 }, // FC
        { 3.233e-01, 0.000e+00, 1.097e-01, 0.000e+00, 6.108e-06, 0.000e+00, 5.713e-04 }, // NOx
        { 0.000e+00, 2.591e-02, 0.000e+00, 1.222e-04, 0.000e+00, 0.000e+00, 8.023e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-5_(P)
        { 1.348e+03, 1.682e+01, 6.753e+02, 0.000e+00, 1.034e-01, 1.155e+02, 3.109e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.636e-03, 0.000e+00, 2.842e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.343e-05, 0.000e+00, 1.566e-03 }, // HC
        { 4.370e+02, 5.452e+00, 2.189e+02, 0.000e+00, 3.353e-02, 3.743e+01, 1.008e+00 }, // FC
        { 3.233e-01, 0.000e+00, 1.097e-01, 0.000e+00, 6.108e-06, 0.000e+00, 5.713e-04 }, // NOx
        { 7.254e-03, 2.591e-02, 0.000e+00, 1.222e-04, 3.142e-06, 6.239e-04, 1.355e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-6_(LPG)
        { 1.373e+03, 1.907e+01, 8.427e+02, 0.000e+00, 9.380e-02, 9.877e+01, 3.350e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.408e-03, 0.000e+00, 1.003e-01 }, // CO
        { 2.848e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.024e-05, 0.000e+00, 7.255e-04 }, // HC
        { 4.446e+02, 6.173e+00, 2.728e+02, 0.000e+00, 3.036e-02, 3.197e+01, 1.084e+00 }, // FC
        { 4.354e-01, 7.053e-03, 5.637e-01, 0.000e+00, 9.367e-06, 0.000e+00, 7.952e-04 }, // NOx
        { 0.000e+00, 2.592e-02, 0.000e+00, 1.215e-04, 0.000e+00, 0.000e+00, 2.068e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_LPG_petrol_Euro-6_(P)
        { 1.447e+03, 2.009e+01, 8.875e+02, 0.000e+00, 9.879e-02, 1.040e+02, 3.528e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.408e-03, 0.000e+00, 1.003e-01 }, // CO
        { 2.848e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.024e-05, 0.000e+00, 7.255e-04 }, // HC
        { 4.689e+02, 6.512e+00, 2.877e+02, 0.000e+00, 3.203e-02, 3.372e+01, 1.144e+00 }, // FC
        { 4.354e-01, 7.053e-03, 5.637e-01, 0.000e+00, 9.367e-06, 0.000e+00, 7.952e-04 }, // NOx
        { 1.255e-02, 2.592e-02, 4.491e-03, 1.215e-04, 5.535e-07, 4.365e-06, 2.068e-07 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_FuelCell
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 5.948e+01, 3.158e+00, 5.617e+01, 0.000e+00, 7.286e-03, 1.817e+01, 1.408e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.593e-02, 0.000e+00, 1.213e-04, 0.000e+00, 4.941e-18, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_2S_EE
        { 1.516e+03, 1.367e+01, 9.276e+02, 0.000e+00, 1.383e-01, 1.052e+02, 5.289e+00 }, // CO2(total)
        { 2.438e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.419e-02, 0.000e+00, 1.523e+00 }, // CO
        { 5.426e+01, 0.000e+00, 0.000e+00, 0.000e+00, 9.102e-03, 0.000e+00, 2.746e-01 }, // HC
        { 4.782e+02, 4.310e+00, 2.925e+02, 0.000e+00, 4.362e-02, 3.318e+01, 1.668e+00 }, // FC
        { 0.000e+00, 2.024e+00, 1.467e+01, 0.000e+00, 0.000e+00, 2.517e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // PC_4S_EE
        { 1.474e+03, 1.328e+01, 9.016e+02, 0.000e+00, 1.344e-01, 1.023e+02, 5.141e+00 }, // CO2(total)
        { 3.120e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.462e-02, 0.000e+00, 2.197e+00 }, // CO
        { 1.763e+01, 0.000e+00, 0.000e+00, 0.000e+00, 9.188e-04, 0.000e+00, 3.571e-02 }, // HC
        { 4.778e+02, 4.307e+00, 2.923e+02, 0.000e+00, 4.359e-02, 3.315e+01, 1.666e+00 }, // FC
        { 1.184e+00, 3.728e+00, 4.500e+01, 0.000e+00, 0.000e+00, 4.028e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.587e-02, 0.000e+00, 1.239e-04, 2.936e-05, 0.000e+00, 2.271e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Conv_lt1981
        { 1.439e+03, 3.693e+01, 4.867e+01, 0.000e+00, 1.679e-01, 2.349e+02, 4.547e+00 }, // CO2(total)
        { 1.341e+02, 0.000e+00, 0.000e+00, 0.000e+00, 2.726e-02, 0.000e+00, 2.085e+00 }, // CO
        { 1.394e+01, 0.000e+00, 0.000e+00, 0.000e+00, 5.420e-04, 1.690e-01, 3.468e-02 }, // HC
        { 4.664e+02, 1.197e+01, 1.578e+01, 0.000e+00, 5.443e-02, 7.615e+01, 1.474e+00 }, // FC
        { 3.472e+00, 1.264e+00, 3.950e+01, 0.000e+00, 2.047e-04, 1.557e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.565e-02, 0.000e+00, 1.334e-04, 4.811e-05, 0.000e+00, 3.508e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Conv_gt1981
        { 1.439e+03, 3.693e+01, 4.867e+01, 0.000e+00, 1.679e-01, 2.349e+02, 4.547e+00 }, // CO2(total)
        { 1.341e+02, 0.000e+00, 0.000e+00, 0.000e+00, 2.726e-02, 0.000e+00, 2.085e+00 }, // CO
        { 1.394e+01, 0.000e+00, 0.000e+00, 0.000e+00, 5.420e-04, 1.690e-01, 3.468e-02 }, // HC
        { 4.664e+02, 1.197e+01, 1.578e+01, 0.000e+00, 5.443e-02, 7.615e+01, 1.474e+00 }, // FC
        { 3.472e+00, 1.264e+00, 3.950e+01, 0.000e+00, 2.047e-04, 1.557e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.565e-02, 0.000e+00, 1.334e-04, 4.811e-05, 0.000e+00, 3.508e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-1
        { 1.219e+03, 4.417e+01, 0.000e+00, 0.000e+00, 1.346e-01, 2.305e+02, 3.442e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.864e-02, 0.000e+00, 2.119e+00 }, // CO
        { 7.146e-01, 0.000e+00, 0.000e+00, 0.000e+00, 4.398e-04, 0.000e+00, 3.123e-02 }, // HC
        { 3.953e+02, 1.432e+01, 0.000e+00, 0.000e+00, 4.363e-02, 7.474e+01, 1.116e+00 }, // FC
        { 4.706e+00, 0.000e+00, 1.741e+00, 8.961e-03, 1.189e-04, 5.874e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.565e-02, 0.000e+00, 1.336e-04, 2.932e-05, 0.000e+00, 2.153e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_3WCat_1987-1990
        { 1.188e+03, 4.303e+01, 0.000e+00, 0.000e+00, 1.311e-01, 2.246e+02, 3.354e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.864e-02, 0.000e+00, 2.119e+00 }, // CO
        { 7.146e-01, 0.000e+00, 0.000e+00, 0.000e+00, 4.398e-04, 0.000e+00, 3.123e-02 }, // HC
        { 3.852e+02, 1.395e+01, 0.000e+00, 0.000e+00, 4.251e-02, 7.282e+01, 1.087e+00 }, // FC
        { 4.706e+00, 0.000e+00, 1.741e+00, 8.961e-03, 1.189e-04, 5.874e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.565e-02, 0.000e+00, 1.336e-04, 2.932e-05, 0.000e+00, 2.153e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-2
        { 1.214e+03, 4.565e+01, 0.000e+00, 0.000e+00, 1.374e-01, 2.303e+02, 3.932e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.704e-02, 0.000e+00, 1.259e+00 }, // CO
        { 3.661e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.675e-04, 0.000e+00, 1.191e-02 }, // HC
        { 3.934e+02, 1.480e+01, 0.000e+00, 0.000e+00, 4.453e-02, 7.466e+01, 1.275e+00 }, // FC
        { 1.742e+00, 0.000e+00, 1.203e+00, 3.560e-03, 2.814e-05, 1.824e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.564e-02, 0.000e+00, 1.340e-04, 5.907e-05, 0.000e+00, 4.509e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-3
        { 9.984e+02, 3.649e+01, 2.324e+01, 0.000e+00, 1.076e-01, 1.841e+02, 3.131e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 7.543e-01 }, // CO
        { 8.573e-02, 0.000e+00, 0.000e+00, 0.000e+00, 5.564e-05, 0.000e+00, 4.033e-03 }, // HC
        { 3.236e+02, 1.183e+01, 7.535e+00, 0.000e+00, 3.489e-02, 5.969e+01, 1.015e+00 }, // FC
        { 6.569e-01, 0.000e+00, 1.493e-01, 7.475e-04, 1.239e-05, 5.773e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.570e-02, 0.000e+00, 1.314e-04, 2.130e-05, 0.000e+00, 1.620e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-4
        { 1.031e+03, 3.606e+01, 7.863e+01, 0.000e+00, 1.071e-01, 1.820e+02, 3.152e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.191e-03, 0.000e+00, 4.327e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.103e-05, 0.000e+00, 1.979e-03 }, // HC
        { 3.343e+02, 1.169e+01, 2.549e+01, 0.000e+00, 3.472e-02, 5.899e+01, 1.022e+00 }, // FC
        { 4.235e-01, 9.159e-03, 3.564e-01, 0.000e+00, 1.005e-05, 2.906e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.302e-04, 1.222e-05, 0.000e+00, 8.904e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-5
        { 9.718e+02, 2.938e+01, 2.978e+02, 0.000e+00, 1.003e-01, 1.378e+02, 3.553e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.394e-03, 0.000e+00, 4.558e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.229e-05, 0.000e+00, 2.096e-03 }, // HC
        { 3.150e+02, 9.526e+00, 9.655e+01, 0.000e+00, 3.251e-02, 4.468e+01, 1.152e+00 }, // FC
        { 1.583e-01, 2.889e-03, 1.552e-01, 0.000e+00, 3.524e-06, 8.723e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.579e-02, 0.000e+00, 1.273e-04, 1.271e-05, 0.000e+00, 9.478e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-6ab
        { 9.843e+02, 2.742e+01, 1.887e+02, 0.000e+00, 1.093e-01, 1.492e+02, 3.400e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.137e-03, 0.000e+00, 4.992e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.469e-05, 0.000e+00, 2.216e-03 }, // HC
        { 3.191e+02, 8.890e+00, 6.119e+01, 0.000e+00, 3.542e-02, 4.838e+01, 1.102e+00 }, // FC
        { 1.753e-01, 3.293e-03, 1.699e-01, 0.000e+00, 4.284e-06, 9.932e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.285e-04, 1.379e-05, 0.000e+00, 1.005e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-6c
        { 8.979e+02, 2.494e+01, 1.821e+02, 0.000e+00, 9.929e-02, 1.350e+02, 3.112e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.120e-03, 0.000e+00, 4.987e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.461e-05, 0.000e+00, 2.213e-03 }, // HC
        { 2.911e+02, 8.084e+00, 5.904e+01, 0.000e+00, 3.219e-02, 4.377e+01, 1.009e+00 }, // FC
        { 1.753e-01, 3.288e-03, 1.701e-01, 0.000e+00, 4.268e-06, 9.911e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.285e-04, 1.373e-05, 0.000e+00, 1.002e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-6d-temp
        { 9.201e+02, 2.569e+01, 1.911e+02, 0.000e+00, 1.011e-01, 1.382e+02, 3.183e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.067e-03, 0.000e+00, 4.955e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.438e-05, 0.000e+00, 2.200e-03 }, // HC
        { 2.983e+02, 8.329e+00, 6.194e+01, 0.000e+00, 3.277e-02, 4.480e+01, 1.032e+00 }, // FC
        { 1.751e-01, 3.307e-03, 1.705e-01, 0.000e+00, 4.221e-06, 9.888e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.284e-04, 1.364e-05, 0.000e+00, 9.963e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_M+N1-I_Euro-6d
        { 8.697e+02, 2.452e+01, 1.895e+02, 0.000e+00, 9.518e-02, 1.298e+02, 3.042e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.022e-03, 0.000e+00, 4.932e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.418e-05, 0.000e+00, 2.191e-03 }, // HC
        { 2.819e+02, 7.948e+00, 6.144e+01, 0.000e+00, 3.086e-02, 4.207e+01, 9.863e-01 }, // FC
        { 1.751e-01, 3.296e-03, 1.705e-01, 0.000e+00, 4.197e-06, 9.888e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.284e-04, 1.357e-05, 0.000e+00, 9.935e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Conv_lt1981
        { 2.139e+03, 3.113e+01, 0.000e+00, 0.000e+00, 3.127e-01, 3.425e+02, 5.832e+00 }, // CO2(total)
        { 1.180e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.196e-02, 0.000e+00, 3.224e+00 }, // CO
        { 1.872e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-03, 3.458e-01, 4.507e-02 }, // HC
        { 6.935e+02, 1.009e+01, 0.000e+00, 0.000e+00, 1.014e-01, 1.110e+02, 1.891e+00 }, // FC
        { 1.425e+00, 2.087e+00, 4.935e+01, 0.000e+00, 3.065e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.550e-02, 0.000e+00, 1.403e-04, 8.426e-05, 0.000e+00, 5.310e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Conv_gt1981
        { 2.139e+03, 3.113e+01, 0.000e+00, 0.000e+00, 3.127e-01, 3.425e+02, 5.832e+00 }, // CO2(total)
        { 1.180e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.196e-02, 0.000e+00, 3.224e+00 }, // CO
        { 1.872e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-03, 3.458e-01, 4.507e-02 }, // HC
        { 6.935e+02, 1.009e+01, 0.000e+00, 0.000e+00, 1.014e-01, 1.110e+02, 1.891e+00 }, // FC
        { 1.425e+00, 2.087e+00, 4.935e+01, 0.000e+00, 3.065e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.550e-02, 0.000e+00, 1.403e-04, 8.426e-05, 0.000e+00, 5.310e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-1
        { 1.936e+03, 3.724e+01, 0.000e+00, 0.000e+00, 2.985e-01, 3.363e+02, 5.420e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.192e-02, 0.000e+00, 3.727e+00 }, // CO
        { 5.560e-02, 0.000e+00, 0.000e+00, 0.000e+00, 9.641e-04, 0.000e+00, 5.448e-02 }, // HC
        { 6.276e+02, 1.207e+01, 0.000e+00, 0.000e+00, 9.678e-02, 1.090e+02, 1.757e+00 }, // FC
        { 7.310e+00, 0.000e+00, 6.469e+00, 8.140e-03, 4.075e-04, 5.593e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.540e-02, 0.000e+00, 1.450e-04, 6.244e-05, 0.000e+00, 3.947e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_3WCat_1987-1990
        { 1.893e+03, 3.642e+01, 0.000e+00, 0.000e+00, 2.919e-01, 3.289e+02, 5.300e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.192e-02, 0.000e+00, 3.727e+00 }, // CO
        { 5.560e-02, 0.000e+00, 0.000e+00, 0.000e+00, 9.641e-04, 0.000e+00, 5.448e-02 }, // HC
        { 6.137e+02, 1.181e+01, 0.000e+00, 0.000e+00, 9.464e-02, 1.066e+02, 1.718e+00 }, // FC
        { 7.310e+00, 0.000e+00, 6.469e+00, 8.140e-03, 4.075e-04, 5.593e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.540e-02, 0.000e+00, 1.450e-04, 6.244e-05, 0.000e+00, 3.947e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-2
        { 1.890e+03, 2.599e+01, 0.000e+00, 0.000e+00, 2.663e-01, 2.933e+02, 5.380e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.830e-02, 0.000e+00, 1.786e+00 }, // CO
        { 1.153e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.919e-04, 0.000e+00, 1.629e-02 }, // HC
        { 6.129e+02, 8.424e+00, 0.000e+00, 0.000e+00, 8.634e-02, 9.508e+01, 1.744e+00 }, // FC
        { 2.327e+00, 0.000e+00, 2.280e+00, 4.510e-03, 8.440e-05, 1.955e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.554e-02, 0.000e+00, 1.383e-04, 9.738e-05, 0.000e+00, 6.500e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-3
        { 1.545e+03, 2.023e+01, 6.433e+01, 0.000e+00, 1.968e-01, 2.288e+02, 3.864e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.474e-02, 0.000e+00, 9.551e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.733e-05, 0.000e+00, 5.211e-03 }, // HC
        { 5.008e+02, 6.559e+00, 2.086e+01, 0.000e+00, 6.379e-02, 7.419e+01, 1.253e+00 }, // FC
        { 9.082e-01, 0.000e+00, 2.649e-01, 7.490e-04, 3.348e-05, 7.073e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.323e-04, 2.964e-05, 0.000e+00, 1.959e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-4
        { 1.359e+03, 2.636e+01, 0.000e+00, 0.000e+00, 1.819e-01, 2.297e+02, 3.599e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.022e-02, 0.000e+00, 6.533e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.888e-05, 0.000e+00, 2.847e-03 }, // HC
        { 4.407e+02, 8.547e+00, 0.000e+00, 0.000e+00, 5.896e-02, 7.446e+01, 1.167e+00 }, // FC
        { 4.970e-01, 1.145e-02, 4.322e-01, 0.000e+00, 1.715e-05, 3.366e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.559e-02, 0.000e+00, 1.361e-04, 2.201e-05, 0.000e+00, 1.507e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-5
        { 1.267e+03, 2.059e+01, 0.000e+00, 0.000e+00, 1.694e-01, 2.029e+02, 3.541e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 6.289e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.924e-05, 0.000e+00, 2.822e-03 }, // HC
        { 4.107e+02, 6.673e+00, 0.000e+00, 0.000e+00, 5.491e-02, 6.579e+01, 1.148e+00 }, // FC
        { 1.830e-01, 3.831e-03, 1.808e-01, 0.000e+00, 5.918e-06, 1.048e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.331e-04, 2.081e-05, 0.000e+00, 1.404e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-6ab
        { 1.243e+03, 1.765e+01, 1.751e+02, 0.000e+00, 1.569e-01, 1.717e+02, 3.761e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.225e-03, 0.000e+00, 5.970e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.459e-05, 0.000e+00, 2.620e-03 }, // HC
        { 4.029e+02, 5.722e+00, 5.677e+01, 0.000e+00, 5.088e-02, 5.565e+01, 1.219e+00 }, // FC
        { 2.005e-01, 4.022e-03, 2.060e-01, 0.000e+00, 6.089e-06, 1.071e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.299e-04, 1.783e-05, 0.000e+00, 1.221e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-6c
        { 1.132e+03, 1.612e+01, 1.676e+02, 0.000e+00, 1.426e-01, 1.555e+02, 3.445e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.197e-03, 0.000e+00, 5.961e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.447e-05, 0.000e+00, 2.616e-03 }, // HC
        { 3.670e+02, 5.225e+00, 5.432e+01, 0.000e+00, 4.622e-02, 5.041e+01, 1.117e+00 }, // FC
        { 2.007e-01, 3.997e-03, 2.057e-01, 0.000e+00, 6.082e-06, 1.072e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.298e-04, 1.777e-05, 0.000e+00, 1.218e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-6d-temp
        { 1.163e+03, 1.638e+01, 1.894e+02, 0.000e+00, 1.455e-01, 1.574e+02, 3.578e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.140e-03, 0.000e+00, 5.943e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.422e-05, 0.000e+00, 2.610e-03 }, // HC
        { 3.771e+02, 5.310e+00, 6.141e+01, 0.000e+00, 4.717e-02, 5.103e+01, 1.160e+00 }, // FC
        { 2.008e-01, 3.979e-03, 2.051e-01, 0.000e+00, 6.052e-06, 1.075e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.297e-04, 1.765e-05, 0.000e+00, 1.214e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-II_Euro-6d
        { 1.100e+03, 1.575e+01, 1.840e+02, 0.000e+00, 1.369e-01, 1.485e+02, 3.399e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.068e-03, 0.000e+00, 5.912e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.393e-05, 0.000e+00, 2.600e-03 }, // HC
        { 3.565e+02, 5.105e+00, 5.966e+01, 0.000e+00, 4.438e-02, 4.814e+01, 1.102e+00 }, // FC
        { 2.010e-01, 3.945e-03, 2.045e-01, 0.000e+00, 6.027e-06, 1.078e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.574e-02, 0.000e+00, 1.296e-04, 1.750e-05, 0.000e+00, 1.206e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Conv_lt1981
        { 2.539e+03, 4.826e+01, 0.000e+00, 0.000e+00, 3.201e-01, 4.048e+02, 7.550e+00 }, // CO2(total)
        { 1.996e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.034e-02, 0.000e+00, 3.605e+00 }, // CO
        { 2.324e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-03, 3.153e-01, 5.713e-02 }, // HC
        { 8.230e+02, 1.564e+01, 0.000e+00, 0.000e+00, 1.038e-01, 1.312e+02, 2.448e+00 }, // FC
        { 4.812e+00, 2.204e+00, 6.924e+01, 0.000e+00, 4.380e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.560e-02, 0.000e+00, 1.356e-04, 8.642e-05, 0.000e+00, 6.154e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Conv_gt1981
        { 2.539e+03, 4.826e+01, 0.000e+00, 0.000e+00, 3.201e-01, 4.048e+02, 7.550e+00 }, // CO2(total)
        { 1.996e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.034e-02, 0.000e+00, 3.605e+00 }, // CO
        { 2.324e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-03, 3.153e-01, 5.713e-02 }, // HC
        { 8.230e+02, 1.564e+01, 0.000e+00, 0.000e+00, 1.038e-01, 1.312e+02, 2.448e+00 }, // FC
        { 4.812e+00, 2.204e+00, 6.924e+01, 0.000e+00, 4.380e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.560e-02, 0.000e+00, 1.356e-04, 8.642e-05, 0.000e+00, 6.154e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-1
        { 2.249e+03, 5.969e+01, 0.000e+00, 0.000e+00, 3.024e-01, 4.047e+02, 6.770e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.327e-02, 0.000e+00, 4.274e+00 }, // CO
        { 8.224e-01, 0.000e+00, 0.000e+00, 0.000e+00, 9.731e-04, 0.000e+00, 6.222e-02 }, // HC
        { 7.290e+02, 1.935e+01, 0.000e+00, 0.000e+00, 9.803e-02, 1.312e+02, 2.195e+00 }, // FC
        { 8.616e+00, 0.000e+00, 5.768e+00, 1.220e-02, 3.572e-04, 8.371e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.553e-02, 0.000e+00, 1.394e-04, 6.244e-05, 0.000e+00, 4.203e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_3WCat_1987-1990
        { 2.210e+03, 5.867e+01, 0.000e+00, 0.000e+00, 2.972e-01, 3.978e+02, 6.654e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.327e-02, 0.000e+00, 4.274e+00 }, // CO
        { 8.224e-01, 0.000e+00, 0.000e+00, 0.000e+00, 9.731e-04, 0.000e+00, 6.222e-02 }, // HC
        { 7.165e+02, 1.902e+01, 0.000e+00, 0.000e+00, 9.635e-02, 1.290e+02, 2.157e+00 }, // FC
        { 8.616e+00, 0.000e+00, 5.768e+00, 1.220e-02, 3.572e-04, 8.371e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.553e-02, 0.000e+00, 1.394e-04, 6.244e-05, 0.000e+00, 4.203e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-2
        { 2.294e+03, 5.137e+01, 0.000e+00, 0.000e+00, 2.917e-01, 3.874e+02, 6.587e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.197e-02, 0.000e+00, 2.161e+00 }, // CO
        { 2.097e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.330e-04, 0.000e+00, 2.082e-02 }, // HC
        { 7.436e+02, 1.665e+01, 0.000e+00, 0.000e+00, 9.457e-02, 1.256e+02, 2.135e+00 }, // FC
        { 3.009e+00, 0.000e+00, 2.169e+00, 5.656e-03, 9.258e-05, 3.051e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.561e-02, 0.000e+00, 1.352e-04, 1.118e-04, 0.000e+00, 7.893e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-3
        { 1.951e+03, 4.266e+01, 3.867e+01, 0.000e+00, 2.333e-01, 3.195e+02, 5.427e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.458e-02, 0.000e+00, 1.016e+00 }, // CO
        { 4.528e-03, 0.000e+00, 0.000e+00, 0.000e+00, 8.545e-05, 0.000e+00, 5.490e-03 }, // HC
        { 6.324e+02, 1.383e+01, 1.254e+01, 0.000e+00, 7.562e-02, 1.036e+02, 1.759e+00 }, // FC
        { 9.219e-01, 0.000e+00, 2.187e-01, 8.826e-04, 2.654e-05, 7.771e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.569e-02, 0.000e+00, 1.318e-04, 3.002e-05, 0.000e+00, 2.122e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-4
        { 1.905e+03, 4.594e+01, 0.000e+00, 0.000e+00, 2.300e-01, 3.247e+02, 5.464e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.276e-02, 0.000e+00, 8.521e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.212e-05, 0.000e+00, 3.776e-03 }, // HC
        { 6.177e+02, 1.489e+01, 0.000e+00, 0.000e+00, 7.456e-02, 1.053e+02, 1.771e+00 }, // FC
        { 7.238e-01, 1.616e-02, 6.296e-01, 0.000e+00, 2.147e-05, 4.931e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.324e-04, 2.513e-05, 0.000e+00, 1.748e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-5
        { 1.775e+03, 3.743e+01, 1.447e+02, 0.000e+00, 2.154e-01, 2.775e+02, 5.425e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.290e-02, 0.000e+00, 8.622e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.425e-05, 0.000e+00, 3.918e-03 }, // HC
        { 5.754e+02, 1.214e+01, 4.692e+01, 0.000e+00, 6.984e-02, 8.997e+01, 1.759e+00 }, // FC
        { 2.699e-01, 5.134e-03, 2.621e-01, 0.000e+00, 7.707e-06, 1.545e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.301e-04, 2.589e-05, 0.000e+00, 1.834e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-6ab
        { 1.766e+03, 3.703e+01, 1.700e+02, 0.000e+00, 2.145e-01, 2.726e+02, 5.519e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.330e-02, 0.000e+00, 8.913e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.418e-05, 0.000e+00, 3.923e-03 }, // HC
        { 5.725e+02, 1.200e+01, 5.511e+01, 0.000e+00, 6.953e-02, 8.837e+01, 1.789e+00 }, // FC
        { 2.997e-01, 5.703e-03, 2.945e-01, 0.000e+00, 8.512e-06, 1.703e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.300e-04, 2.593e-05, 0.000e+00, 1.838e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-6c
        { 1.595e+03, 3.506e+01, 1.124e+02, 0.000e+00, 1.939e-01, 2.537e+02, 4.882e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.324e-02, 0.000e+00, 8.860e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.398e-05, 0.000e+00, 3.909e-03 }, // HC
        { 5.172e+02, 1.137e+01, 3.642e+01, 0.000e+00, 6.285e-02, 8.226e+01, 1.583e+00 }, // FC
        { 2.995e-01, 5.717e-03, 2.936e-01, 0.000e+00, 8.474e-06, 1.708e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.301e-04, 2.581e-05, 0.000e+00, 1.824e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-6d-temp
        { 1.628e+03, 3.668e+01, 1.256e+02, 0.000e+00, 1.972e-01, 2.589e+02, 5.028e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.321e-02, 0.000e+00, 8.884e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.380e-05, 0.000e+00, 3.915e-03 }, // HC
        { 5.279e+02, 1.189e+01, 4.072e+01, 0.000e+00, 6.392e-02, 8.394e+01, 1.630e+00 }, // FC
        { 2.994e-01, 5.721e-03, 2.954e-01, 0.000e+00, 8.379e-06, 1.695e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.301e-04, 2.574e-05, 0.000e+00, 1.825e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_petrol_N1-III_Euro-6d
        { 1.542e+03, 3.481e+01, 1.433e+02, 0.000e+00, 1.856e-01, 2.424e+02, 4.819e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.313e-02, 0.000e+00, 8.856e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.346e-05, 0.000e+00, 3.903e-03 }, // HC
        { 5.000e+02, 1.128e+01, 4.645e+01, 0.000e+00, 6.018e-02, 7.857e+01, 1.562e+00 }, // FC
        { 2.995e-01, 5.712e-03, 2.957e-01, 0.000e+00, 8.318e-06, 1.694e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.300e-04, 2.559e-05, 0.000e+00, 1.818e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_convlt_1986
        { 1.639e+03, 1.607e+01, 0.000e+00, 0.000e+00, 2.047e-01, 2.940e+02, 2.328e+00 }, // CO2(total)
        { 4.785e+00, 0.000e+00, 3.411e+00, 1.333e-02, 1.385e-04, 0.000e+00, 2.406e-02 }, // CO
        { 9.792e-01, 2.982e-02, 5.278e-01, 7.428e-04, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 5.268e+02, 5.166e+00, 0.000e+00, 0.000e+00, 6.577e-02, 9.448e+01, 7.483e-01 }, // FC
        { 4.015e+00, 2.238e-01, 0.000e+00, 7.662e-03, 6.352e-04, 9.196e-01, 2.750e-02 }, // NOx
        { 0.000e+00, 8.628e-02, 1.205e-01, 4.740e-03, 0.000e+00, 1.497e-01, 7.472e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-1
        { 1.541e+03, 2.851e+01, 0.000e+00, 0.000e+00, 1.889e-01, 3.024e+02, 2.427e+00 }, // CO2(total)
        { 4.263e+00, 0.000e+00, 2.858e+00, 3.336e-03, 2.378e-04, 0.000e+00, 1.013e-02 }, // CO
        { 7.001e-01, 1.637e-02, 2.920e-01, 2.877e-04, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 4.953e+02, 9.163e+00, 0.000e+00, 0.000e+00, 6.071e-02, 9.718e+01, 7.799e-01 }, // FC
        { 2.096e+00, 5.849e-01, 0.000e+00, 0.000e+00, 7.767e-04, 1.194e+00, 3.472e-02 }, // NOx
        { 0.000e+00, 1.364e-01, 3.815e-01, 2.730e-03, 0.000e+00, 1.231e-01, 1.123e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_XXIII
        { 1.682e+03, 1.650e+01, 0.000e+00, 0.000e+00, 2.100e-01, 3.017e+02, 2.390e+00 }, // CO2(total)
        { 4.785e+00, 0.000e+00, 3.411e+00, 1.333e-02, 1.385e-04, 0.000e+00, 2.406e-02 }, // CO
        { 9.792e-01, 2.982e-02, 5.278e-01, 7.428e-04, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 5.406e+02, 5.302e+00, 0.000e+00, 0.000e+00, 6.750e-02, 9.696e+01, 7.679e-01 }, // FC
        { 4.015e+00, 2.238e-01, 0.000e+00, 7.662e-03, 6.352e-04, 9.196e-01, 2.750e-02 }, // NOx
        { 0.000e+00, 8.628e-02, 1.205e-01, 4.740e-03, 0.000e+00, 1.497e-01, 7.472e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-2
        { 1.353e+03, 3.327e+01, 0.000e+00, 0.000e+00, 1.661e-01, 2.582e+02, 3.604e+00 }, // CO2(total)
        { 2.045e+00, 0.000e+00, 5.138e-01, 0.000e+00, 3.492e-05, 0.000e+00, 1.254e-03 }, // CO
        { 4.651e-01, 3.900e-03, 6.874e-02, 1.203e-04, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 4.348e+02, 1.069e+01, 0.000e+00, 0.000e+00, 5.339e-02, 8.297e+01, 1.158e+00 }, // FC
        { 3.178e+00, 6.258e-01, 0.000e+00, 1.995e-03, 1.062e-03, 1.363e+00, 5.190e-02 }, // NOx
        { 5.977e-02, 1.119e-01, 6.148e-01, 9.846e-04, 0.000e+00, 4.610e-02, 6.521e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-3
        { 7.963e+02, 3.848e+01, 0.000e+00, 0.000e+00, 1.013e-01, 1.751e+02, 3.198e+00 }, // CO2(total)
        { 7.683e-01, 0.000e+00, 6.516e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.985e-01, 0.000e+00, 1.315e-01, 0.000e+00, 1.093e-05, 1.359e-02, 0.000e+00 }, // HC
        { 2.559e+02, 1.237e+01, 0.000e+00, 0.000e+00, 3.257e-02, 5.627e+01, 1.028e+00 }, // FC
        { 3.829e+00, 9.829e-01, 0.000e+00, 0.000e+00, 1.836e-03, 1.876e+00, 1.054e-01 }, // NOx
        { 2.239e-01, 5.406e-02, 0.000e+00, 1.348e-04, 3.822e-05, 8.779e-02, 2.914e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-3_(DPF)
        { 8.043e+02, 3.887e+01, 0.000e+00, 0.000e+00, 1.023e-01, 1.768e+02, 3.230e+00 }, // CO2(total)
        { 7.683e-01, 0.000e+00, 6.516e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.985e-01, 0.000e+00, 1.315e-01, 0.000e+00, 1.093e-05, 1.359e-02, 0.000e+00 }, // HC
        { 2.585e+02, 1.249e+01, 0.000e+00, 0.000e+00, 3.289e-02, 5.683e+01, 1.038e+00 }, // FC
        { 3.829e+00, 9.829e-01, 0.000e+00, 0.000e+00, 1.836e-03, 1.876e+00, 1.054e-01 }, // NOx
        { 1.567e-01, 4.553e-02, 0.000e+00, 1.348e-04, 2.675e-05, 6.146e-02, 2.080e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-4
        { 9.648e+02, 2.843e+01, 4.683e+02, 0.000e+00, 1.068e-01, 1.117e+02, 4.959e+00 }, // CO2(total)
        { 5.395e-01, 0.000e+00, 4.476e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.336e-01, 3.571e-04, 2.331e-02, 1.008e-04, 2.410e-06, 5.449e-03, 0.000e+00 }, // HC
        { 3.101e+02, 9.138e+00, 1.505e+02, 0.000e+00, 3.431e-02, 3.590e+01, 1.594e+00 }, // FC
        { 7.716e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.385e-03, 4.265e-01, 1.237e-01 }, // NOx
        { 3.279e-01, 4.336e-02, 1.415e-01, 1.274e-04, 2.055e-05, 4.141e-02, 4.848e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-4_(DPF)
        { 9.648e+02, 2.843e+01, 4.683e+02, 0.000e+00, 1.068e-01, 1.117e+02, 4.959e+00 }, // CO2(total)
        { 5.422e-01, 0.000e+00, 4.498e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.368e-01, 3.656e-04, 2.387e-02, 1.032e-04, 2.468e-06, 5.580e-03, 0.000e+00 }, // HC
        { 3.101e+02, 9.138e+00, 1.505e+02, 0.000e+00, 3.431e-02, 3.590e+01, 1.594e+00 }, // FC
        { 8.078e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.497e-03, 4.466e-01, 1.295e-01 }, // NOx
        { 0.000e+00, 2.578e-02, 0.000e+00, 1.274e-04, 2.352e-05, 0.000e+00, 1.575e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-5
        { 9.039e+02, 2.551e+01, 5.255e+02, 0.000e+00, 9.728e-02, 9.351e+01, 4.726e+00 }, // CO2(total)
        { 3.858e-01, 0.000e+00, 3.001e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.118e-01, 0.000e+00, 4.954e-02, 0.000e+00, 3.445e-06, 6.373e-05, 0.000e+00 }, // HC
        { 2.905e+02, 8.200e+00, 1.689e+02, 0.000e+00, 3.126e-02, 3.005e+01, 1.519e+00 }, // FC
        { 4.221e+00, 7.830e-01, 0.000e+00, 0.000e+00, 1.224e-03, 2.016e+00, 4.113e-02 }, // NOx
        { 2.594e-02, 2.580e-02, 9.889e-03, 1.266e-04, 1.985e-06, 0.000e+00, 6.747e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-6ab
        { 9.862e+02, 1.981e+01, 3.312e+02, 0.000e+00, 1.185e-01, 1.180e+02, 4.536e+00 }, // CO2(total)
        { 1.029e+00, 1.469e-02, 6.801e-01, 0.000e+00, 6.438e-05, 0.000e+00, 4.626e-03 }, // CO
        { 1.936e-01, 6.870e-03, 0.000e+00, 0.000e+00, 1.744e-05, 3.458e-02, 3.482e-04 }, // HC
        { 3.169e+02, 6.367e+00, 1.065e+02, 0.000e+00, 3.807e-02, 3.793e+01, 1.458e+00 }, // FC
        { 3.446e+00, 2.815e-01, 1.299e+00, 0.000e+00, 1.154e-03, 0.000e+00, 8.985e-02 }, // NOx
        { 5.056e-02, 2.575e-02, 0.000e+00, 1.286e-04, 1.171e-05, 0.000e+00, 7.137e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-6c
        { 9.654e+02, 1.930e+01, 3.384e+02, 0.000e+00, 1.155e-01, 1.137e+02, 4.471e+00 }, // CO2(total)
        { 3.595e-01, 1.300e-02, 0.000e+00, 8.250e-04, 0.000e+00, 6.061e-02, 0.000e+00 }, // CO
        { 3.889e-02, 1.972e-02, 3.568e-01, 0.000e+00, 0.000e+00, 1.758e-02, 0.000e+00 }, // HC
        { 3.102e+02, 6.203e+00, 1.087e+02, 0.000e+00, 3.713e-02, 3.655e+01, 1.437e+00 }, // FC
        { 1.472e+00, 1.216e-01, 0.000e+00, 0.000e+00, 4.609e-04, 3.792e-02, 3.512e-02 }, // NOx
        { 0.000e+00, 2.576e-02, 1.224e-01, 1.285e-04, 3.570e-05, 1.557e-02, 5.451e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-6d-temp
        { 9.450e+02, 1.885e+01, 3.399e+02, 0.000e+00, 1.120e-01, 1.101e+02, 4.368e+00 }, // CO2(total)
        { 1.438e-01, 1.502e-02, 3.573e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.405e-01, 1.160e-02, 5.916e-01, 0.000e+00, 0.000e+00, 2.444e-03, 0.000e+00 }, // HC
        { 3.037e+02, 6.057e+00, 1.092e+02, 0.000e+00, 3.598e-02, 3.537e+01, 1.404e+00 }, // FC
        { 2.531e-01, 3.285e-02, 0.000e+00, 0.000e+00, 1.048e-04, 7.073e-02, 5.706e-03 }, // NOx
        { 0.000e+00, 2.576e-02, 3.746e-01, 1.285e-04, 4.585e-05, 3.548e-03, 5.470e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_M+N1-I_Euro-6d
        { 8.900e+02, 1.810e+01, 3.398e+02, 0.000e+00, 1.054e-01, 1.021e+02, 4.185e+00 }, // CO2(total)
        { 1.287e-01, 1.355e-02, 3.224e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.244e-01, 1.058e-02, 5.278e-01, 0.000e+00, 0.000e+00, 2.695e-03, 0.000e+00 }, // HC
        { 2.860e+02, 5.818e+00, 1.092e+02, 0.000e+00, 3.386e-02, 3.280e+01, 1.345e+00 }, // FC
        { 1.731e-01, 3.111e-02, 0.000e+00, 0.000e+00, 9.184e-05, 7.472e-02, 4.688e-03 }, // NOx
        { 0.000e+00, 2.576e-02, 2.864e-01, 1.283e-04, 4.119e-05, 5.475e-03, 5.269e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_convlt_1986
        { 2.118e+03, 2.072e+01, 0.000e+00, 0.000e+00, 3.313e-01, 4.342e+02, 1.599e+00 }, // CO2(total)
        { 9.860e+00, 0.000e+00, 4.480e+00, 0.000e+00, 5.227e-04, 0.000e+00, 1.709e-02 }, // CO
        { 2.110e+00, 6.115e-02, 1.231e+00, 1.708e-03, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 6.807e+02, 6.660e+00, 0.000e+00, 0.000e+00, 1.065e-01, 1.395e+02, 5.140e-01 }, // FC
        { 6.847e+00, 4.052e-01, 0.000e+00, 0.000e+00, 2.103e-03, 1.543e+00, 6.924e-02 }, // NOx
        { 8.071e-01, 1.848e-01, 8.587e-01, 5.602e-03, 0.000e+00, 2.241e-01, 2.104e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-1
        { 2.162e+03, 1.187e+01, 0.000e+00, 0.000e+00, 3.257e-01, 4.142e+02, 1.854e+00 }, // CO2(total)
        { 7.277e+00, 0.000e+00, 3.336e+00, 0.000e+00, 3.636e-04, 0.000e+00, 1.162e-02 }, // CO
        { 1.065e+00, 2.919e-02, 5.655e-01, 8.833e-04, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 6.948e+02, 3.815e+00, 0.000e+00, 0.000e+00, 1.047e-01, 1.331e+02, 5.957e-01 }, // FC
        { 5.667e+00, 3.646e-01, 0.000e+00, 0.000e+00, 1.785e-03, 1.258e+00, 6.258e-02 }, // NOx
        { 1.154e-01, 1.074e-01, 3.561e-01, 4.659e-03, 0.000e+00, 1.125e-01, 1.901e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_XXIII
        { 2.172e+03, 2.125e+01, 0.000e+00, 0.000e+00, 3.398e-01, 4.453e+02, 1.640e+00 }, // CO2(total)
        { 9.860e+00, 0.000e+00, 4.480e+00, 0.000e+00, 5.227e-04, 0.000e+00, 1.709e-02 }, // CO
        { 2.110e+00, 6.115e-02, 1.231e+00, 1.708e-03, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 6.980e+02, 6.829e+00, 0.000e+00, 0.000e+00, 1.092e-01, 1.431e+02, 5.271e-01 }, // FC
        { 6.847e+00, 4.052e-01, 0.000e+00, 0.000e+00, 2.103e-03, 1.543e+00, 6.924e-02 }, // NOx
        { 8.071e-01, 1.848e-01, 8.587e-01, 5.602e-03, 0.000e+00, 2.241e-01, 2.104e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-2
        { 2.014e+03, 9.565e+00, 0.000e+00, 0.000e+00, 2.978e-01, 3.473e+02, 3.899e+00 }, // CO2(total)
        { 2.077e+00, 0.000e+00, 9.243e-01, 0.000e+00, 1.027e-04, 0.000e+00, 3.455e-03 }, // CO
        { 5.513e-01, 1.362e-02, 2.839e-01, 4.859e-04, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 6.473e+02, 3.074e+00, 0.000e+00, 0.000e+00, 9.570e-02, 1.116e+02, 1.253e+00 }, // FC
        { 5.158e+00, 3.208e-01, 0.000e+00, 0.000e+00, 1.567e-03, 1.089e+00, 5.635e-02 }, // NOx
        { 2.554e-01, 7.345e-02, 4.760e-01, 1.901e-03, 0.000e+00, 3.847e-02, 7.429e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-3
        { 1.318e+03, 1.807e+01, 0.000e+00, 0.000e+00, 1.903e-01, 2.252e+02, 4.040e+00 }, // CO2(total)
        { 3.595e-01, 0.000e+00, 3.079e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.053e-01, 1.753e-05, 1.911e-01, 0.000e+00, 9.652e-06, 3.897e-03, 0.000e+00 }, // HC
        { 4.237e+02, 5.807e+00, 0.000e+00, 0.000e+00, 6.117e-02, 7.239e+01, 1.298e+00 }, // FC
        { 6.017e+00, 4.940e-01, 0.000e+00, 0.000e+00, 1.441e-03, 1.749e+00, 3.862e-02 }, // NOx
        { 2.734e-01, 3.794e-02, 0.000e+00, 2.211e-04, 3.640e-05, 6.368e-02, 1.268e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-3_(DPF)
        { 1.331e+03, 1.825e+01, 0.000e+00, 0.000e+00, 1.922e-01, 2.275e+02, 4.080e+00 }, // CO2(total)
        { 3.595e-01, 0.000e+00, 3.079e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.053e-01, 1.753e-05, 1.911e-01, 0.000e+00, 9.652e-06, 3.897e-03, 0.000e+00 }, // HC
        { 4.279e+02, 5.865e+00, 0.000e+00, 0.000e+00, 6.178e-02, 7.311e+01, 1.311e+00 }, // FC
        { 6.017e+00, 4.940e-01, 0.000e+00, 0.000e+00, 1.441e-03, 1.749e+00, 3.862e-02 }, // NOx
        { 1.914e-01, 3.424e-02, 0.000e+00, 1.955e-04, 2.548e-05, 4.457e-02, 1.268e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-4
        { 1.381e+03, 1.381e+01, 1.632e+02, 0.000e+00, 1.933e-01, 1.851e+02, 5.678e+00 }, // CO2(total)
        { 2.985e-01, 0.000e+00, 2.479e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.616e-01, 3.245e-03, 1.170e-02, 0.000e+00, 6.641e-06, 9.974e-03, 0.000e+00 }, // HC
        { 4.438e+02, 4.438e+00, 5.245e+01, 0.000e+00, 6.212e-02, 5.947e+01, 1.825e+00 }, // FC
        { 7.678e+00, 1.629e-01, 0.000e+00, 0.000e+00, 1.960e-03, 1.600e+00, 5.072e-02 }, // NOx
        { 2.942e-01, 2.567e-02, 4.288e-02, 1.392e-03, 2.071e-06, 3.818e-02, 8.249e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-4_(DPF)
        { 1.381e+03, 1.381e+01, 1.632e+02, 0.000e+00, 1.933e-01, 1.851e+02, 5.678e+00 }, // CO2(total)
        { 2.985e-01, 0.000e+00, 2.479e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.616e-01, 3.245e-03, 1.170e-02, 0.000e+00, 6.641e-06, 9.974e-03, 0.000e+00 }, // HC
        { 4.438e+02, 4.438e+00, 5.245e+01, 0.000e+00, 6.212e-02, 5.947e+01, 1.825e+00 }, // FC
        { 7.678e+00, 1.629e-01, 0.000e+00, 0.000e+00, 1.960e-03, 1.600e+00, 5.072e-02 }, // NOx
        { 6.314e-03, 2.567e-02, 0.000e+00, 1.324e-04, 1.046e-06, 1.516e-04, 3.921e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-5
        { 1.365e+03, 1.840e+01, 1.533e+02, 0.000e+00, 1.686e-01, 1.859e+02, 4.416e+00 }, // CO2(total)
        { 6.250e-02, 0.000e+00, 5.304e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.755e-01, 0.000e+00, 3.929e-02, 7.578e-06, 2.077e-06, 0.000e+00, 1.769e-05 }, // HC
        { 4.387e+02, 5.912e+00, 4.926e+01, 0.000e+00, 5.418e-02, 5.975e+01, 1.419e+00 }, // FC
        { 7.055e+00, 3.774e-01, 0.000e+00, 0.000e+00, 1.500e-03, 1.402e+00, 7.017e-02 }, // NOx
        { 3.129e-03, 2.624e-02, 4.905e-03, 1.393e-04, 0.000e+00, 6.331e-04, 8.031e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-6ab
        { 1.438e+03, 2.012e+01, 2.170e+02, 0.000e+00, 1.833e-01, 1.932e+02, 5.280e+00 }, // CO2(total)
        { 1.095e+00, 4.285e-03, 5.914e-01, 0.000e+00, 7.900e-05, 0.000e+00, 4.730e-03 }, // CO
        { 2.338e-01, 2.172e-03, 0.000e+00, 0.000e+00, 2.326e-05, 3.206e-02, 4.448e-04 }, // HC
        { 4.621e+02, 6.466e+00, 6.975e+01, 0.000e+00, 5.891e-02, 6.210e+01, 1.697e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.750e-04, 0.000e+00, 5.428e-02 }, // NOx
        { 4.603e-02, 2.572e-02, 0.000e+00, 1.300e-04, 1.231e-05, 0.000e+00, 7.183e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-6c
        { 1.405e+03, 1.980e+01, 2.219e+02, 0.000e+00, 1.786e-01, 1.878e+02, 5.189e+00 }, // CO2(total)
        { 2.962e-01, 2.153e-02, 0.000e+00, 3.280e-04, 1.091e-05, 5.979e-02, 0.000e+00 }, // CO
        { 0.000e+00, 2.223e-02, 3.422e-01, 0.000e+00, 0.000e+00, 1.780e-02, 0.000e+00 }, // HC
        { 4.514e+02, 6.363e+00, 7.131e+01, 0.000e+00, 5.741e-02, 6.034e+01, 1.668e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.826e-04, 0.000e+00, 4.939e-02 }, // NOx
        { 0.000e+00, 2.572e-02, 3.413e-01, 1.299e-04, 3.405e-05, 4.508e-04, 6.262e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-6d-temp
        { 1.367e+03, 1.971e+01, 2.284e+02, 0.000e+00, 1.730e-01, 1.819e+02, 5.084e+00 }, // CO2(total)
        { 1.357e-01, 1.516e-02, 3.419e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.145e-01, 1.302e-02, 5.814e-01, 0.000e+00, 0.000e+00, 2.242e-03, 0.000e+00 }, // HC
        { 4.394e+02, 6.333e+00, 7.340e+01, 0.000e+00, 5.560e-02, 5.846e+01, 1.634e+00 }, // FC
        { 4.804e-01, 5.028e-03, 0.000e+00, 0.000e+00, 1.341e-04, 3.507e-02, 7.228e-03 }, // NOx
        { 0.000e+00, 2.573e-02, 3.174e-01, 1.297e-04, 4.428e-05, 0.000e+00, 6.152e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-II_Euro-6d
        { 1.292e+03, 1.897e+01, 2.316e+02, 0.000e+00, 1.627e-01, 1.705e+02, 4.849e+00 }, // CO2(total)
        { 1.221e-01, 1.364e-02, 3.081e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.039e-01, 1.164e-02, 5.234e-01, 0.000e+00, 0.000e+00, 2.051e-03, 0.000e+00 }, // HC
        { 4.152e+02, 6.095e+00, 7.444e+01, 0.000e+00, 5.228e-02, 5.479e+01, 1.558e+00 }, // FC
        { 3.688e-01, 7.987e-03, 0.000e+00, 0.000e+00, 1.164e-04, 4.247e-02, 5.995e-03 }, // NOx
        { 0.000e+00, 2.573e-02, 2.848e-01, 1.296e-04, 3.938e-05, 0.000e+00, 6.016e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_convlt_1986
        { 2.467e+03, 7.145e+01, 0.000e+00, 0.000e+00, 4.042e-01, 5.917e+02, 4.975e+00 }, // CO2(total)
        { 1.267e+01, 0.000e+00, 6.527e+00, 3.381e-03, 6.148e-04, 0.000e+00, 2.700e-02 }, // CO
        { 1.191e-01, 4.545e-03, 9.172e-02, 8.593e-05, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 7.929e+02, 2.296e+01, 0.000e+00, 0.000e+00, 1.299e-01, 1.902e+02, 1.599e+00 }, // FC
        { 5.148e+00, 6.606e-01, 0.000e+00, 0.000e+00, 1.786e-03, 1.844e+00, 6.407e-02 }, // NOx
        { 7.241e-01, 2.460e-01, 1.116e+00, 5.333e-03, 0.000e+00, 2.890e-01, 2.416e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-1
        { 2.429e+03, 6.073e+01, 0.000e+00, 0.000e+00, 3.890e-01, 5.564e+02, 5.037e+00 }, // CO2(total)
        { 7.938e+00, 0.000e+00, 3.795e+00, 1.711e-03, 3.813e-04, 0.000e+00, 1.631e-02 }, // CO
        { 7.642e-02, 2.747e-03, 5.480e-02, 5.733e-05, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 7.805e+02, 1.952e+01, 0.000e+00, 0.000e+00, 1.250e-01, 1.788e+02, 1.619e+00 }, // FC
        { 4.978e+00, 5.766e-01, 0.000e+00, 0.000e+00, 1.648e-03, 1.613e+00, 6.087e-02 }, // NOx
        { 0.000e+00, 1.475e-01, 1.352e-01, 4.495e-03, 0.000e+00, 1.965e-01, 1.112e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_XXIII
        { 2.511e+03, 7.273e+01, 0.000e+00, 0.000e+00, 4.114e-01, 6.023e+02, 5.064e+00 }, // CO2(total)
        { 1.267e+01, 0.000e+00, 6.527e+00, 3.381e-03, 6.148e-04, 0.000e+00, 2.700e-02 }, // CO
        { 1.191e-01, 4.545e-03, 9.172e-02, 8.593e-05, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 8.071e+02, 2.337e+01, 0.000e+00, 0.000e+00, 1.322e-01, 1.936e+02, 1.627e+00 }, // FC
        { 5.148e+00, 6.606e-01, 0.000e+00, 0.000e+00, 1.786e-03, 1.844e+00, 6.407e-02 }, // NOx
        { 7.241e-01, 2.460e-01, 1.116e+00, 5.333e-03, 0.000e+00, 2.890e-01, 2.416e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-2
        { 2.475e+03, 4.161e+01, 0.000e+00, 0.000e+00, 3.558e-01, 4.786e+02, 5.851e+00 }, // CO2(total)
        { 2.558e+00, 0.000e+00, 1.297e+00, 3.886e-04, 1.125e-04, 0.000e+00, 4.350e-03 }, // CO
        { 2.935e-02, 9.380e-04, 1.785e-02, 2.345e-05, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 7.953e+02, 1.337e+01, 0.000e+00, 0.000e+00, 1.143e-01, 1.538e+02, 1.880e+00 }, // FC
        { 2.469e+00, 3.437e-01, 0.000e+00, 0.000e+00, 8.986e-04, 8.597e-01, 3.581e-02 }, // NOx
        { 2.947e-01, 1.435e-01, 7.855e-01, 2.660e-03, 0.000e+00, 1.044e-01, 7.609e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-3
        { 1.626e+03, 4.318e+01, 0.000e+00, 0.000e+00, 2.311e-01, 3.116e+02, 5.820e+00 }, // CO2(total)
        { 4.254e-01, 0.000e+00, 3.713e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.206e-02, 0.000e+00, 9.543e-03, 0.000e+00, 5.455e-07, 3.697e-04, 0.000e+00 }, // HC
        { 5.225e+02, 1.388e+01, 0.000e+00, 0.000e+00, 7.428e-02, 1.001e+02, 1.870e+00 }, // FC
        { 5.423e+00, 5.786e-01, 0.000e+00, 0.000e+00, 1.245e-03, 1.763e+00, 3.829e-02 }, // NOx
        { 6.342e-01, 6.668e-02, 0.000e+00, 1.361e-04, 8.715e-05, 1.712e-01, 1.359e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-3_(DPF)
        { 1.642e+03, 4.361e+01, 0.000e+00, 0.000e+00, 2.334e-01, 3.147e+02, 5.878e+00 }, // CO2(total)
        { 4.254e-01, 0.000e+00, 3.713e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.206e-02, 0.000e+00, 9.543e-03, 0.000e+00, 5.455e-07, 3.697e-04, 0.000e+00 }, // HC
        { 5.278e+02, 1.402e+01, 0.000e+00, 0.000e+00, 7.503e-02, 1.011e+02, 1.889e+00 }, // FC
        { 5.423e+00, 5.786e-01, 0.000e+00, 0.000e+00, 1.245e-03, 1.763e+00, 3.829e-02 }, // NOx
        { 4.439e-01, 5.436e-02, 0.000e+00, 1.361e-04, 6.100e-05, 1.199e-01, 1.359e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-4
        { 1.801e+03, 3.445e+01, 3.695e+02, 0.000e+00, 2.334e-01, 2.498e+02, 7.833e+00 }, // CO2(total)
        { 5.861e-01, 0.000e+00, 4.974e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.729e-03, 1.190e-04, 5.834e-04, 0.000e+00, 2.153e-07, 3.362e-04, 0.000e+00 }, // HC
        { 5.789e+02, 1.107e+01, 1.187e+02, 0.000e+00, 7.501e-02, 8.027e+01, 2.517e+00 }, // FC
        { 8.012e+00, 2.215e-01, 0.000e+00, 0.000e+00, 1.962e-03, 1.623e+00, 5.850e-02 }, // NOx
        { 3.313e-01, 2.573e-02, 8.114e-02, 1.550e-03, 0.000e+00, 3.945e-02, 6.391e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-4_(DPF)
        { 1.801e+03, 3.445e+01, 3.695e+02, 0.000e+00, 2.334e-01, 2.498e+02, 7.833e+00 }, // CO2(total)
        { 5.861e-01, 0.000e+00, 4.974e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.729e-03, 1.190e-04, 5.834e-04, 0.000e+00, 2.153e-07, 3.362e-04, 0.000e+00 }, // HC
        { 5.789e+02, 1.107e+01, 1.187e+02, 0.000e+00, 7.501e-02, 8.027e+01, 2.517e+00 }, // FC
        { 8.012e+00, 2.215e-01, 0.000e+00, 0.000e+00, 1.962e-03, 1.623e+00, 5.850e-02 }, // NOx
        { 2.264e-02, 2.573e-02, 0.000e+00, 1.297e-04, 3.465e-06, 5.750e-04, 1.003e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-5
        { 1.933e+03, 3.865e+01, 4.370e+02, 0.000e+00, 2.241e-01, 2.590e+02, 7.088e+00 }, // CO2(total)
        { 1.090e-01, 0.000e+00, 7.874e-02, 0.000e+00, 4.014e-06, 0.000e+00, 2.926e-04 }, // CO
        { 7.305e-02, 6.232e-04, 9.088e-03, 1.881e-05, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 6.211e+02, 1.242e+01, 1.404e+02, 0.000e+00, 7.201e-02, 8.325e+01, 2.278e+00 }, // FC
        { 8.498e+00, 0.000e+00, 1.572e+00, 0.000e+00, 2.003e-03, 0.000e+00, 1.285e-01 }, // NOx
        { 2.166e-02, 2.587e-02, 2.492e-03, 1.523e-04, 1.777e-07, 5.700e-04, 6.659e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-6ab
        { 1.949e+03, 3.407e+01, 6.596e+02, 0.000e+00, 2.332e-01, 2.306e+02, 8.244e+00 }, // CO2(total)
        { 2.952e+00, 0.000e+00, 3.952e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.523e-02, 0.000e+00, 0.000e+00, 0.000e+00, 7.089e-07, 0.000e+00, 0.000e+00 }, // HC
        { 6.265e+02, 1.095e+01, 2.120e+02, 0.000e+00, 7.494e-02, 7.410e+01, 2.649e+00 }, // FC
        { 3.352e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.798e-04, 2.640e-01, 3.613e-02 }, // NOx
        { 1.009e-02, 2.578e-02, 0.000e+00, 1.440e-04, 1.316e-06, 0.000e+00, 1.059e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-6c
        { 1.904e+03, 3.357e+01, 6.518e+02, 0.000e+00, 2.271e-01, 2.248e+02, 8.066e+00 }, // CO2(total)
        { 3.644e-01, 8.524e-03, 0.000e+00, 9.575e-04, 0.000e+00, 5.964e-02, 0.000e+00 }, // CO
        { 8.782e-03, 2.106e-02, 3.100e-01, 0.000e+00, 0.000e+00, 2.021e-02, 0.000e+00 }, // HC
        { 6.119e+02, 1.079e+01, 2.095e+02, 0.000e+00, 7.300e-02, 7.224e+01, 2.592e+00 }, // FC
        { 1.310e+00, 9.940e-02, 0.000e+00, 0.000e+00, 4.676e-04, 6.424e-02, 3.279e-02 }, // NOx
        { 0.000e+00, 2.578e-02, 3.058e-01, 1.276e-04, 3.344e-05, 0.000e+00, 4.596e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-6d-temp
        { 1.854e+03, 3.325e+01, 6.531e+02, 0.000e+00, 2.200e-01, 2.175e+02, 7.896e+00 }, // CO2(total)
        { 1.140e-01, 1.636e-02, 3.751e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.043e-01, 1.345e-02, 5.189e-01, 0.000e+00, 0.000e+00, 7.235e-03, 0.000e+00 }, // HC
        { 5.957e+02, 1.069e+01, 2.099e+02, 0.000e+00, 7.071e-02, 6.991e+01, 2.538e+00 }, // FC
        { 2.171e-01, 2.882e-02, 0.000e+00, 0.000e+00, 1.048e-04, 7.030e-02, 5.236e-03 }, // NOx
        { 0.000e+00, 2.578e-02, 2.835e-01, 1.275e-04, 4.403e-05, 0.000e+00, 4.527e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_diesel_N1-III_Euro-6d
        { 1.754e+03, 3.171e+01, 6.500e+02, 0.000e+00, 2.070e-01, 2.022e+02, 7.559e+00 }, // CO2(total)
        { 1.019e-01, 1.475e-02, 3.386e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.206e-02, 1.219e-02, 4.587e-01, 0.000e+00, 0.000e+00, 7.039e-03, 0.000e+00 }, // HC
        { 5.636e+02, 1.019e+01, 2.089e+02, 0.000e+00, 6.654e-02, 6.500e+01, 2.429e+00 }, // FC
        { 1.608e-01, 2.736e-02, 0.000e+00, 0.000e+00, 9.206e-05, 6.855e-02, 4.466e-03 }, // NOx
        { 0.000e+00, 2.578e-02, 2.750e-01, 1.274e-04, 3.976e-05, 0.000e+00, 4.438e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_2S_EE
        { 1.218e+03, 3.125e+01, 4.118e+01, 0.000e+00, 1.421e-01, 1.988e+02, 3.848e+00 }, // CO2(total)
        { 9.194e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.106e-02, 0.000e+00, 2.215e+00 }, // CO
        { 7.900e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.142e-02, 0.000e+00, 4.932e-01 }, // HC
        { 3.840e+02, 9.856e+00, 1.299e+01, 0.000e+00, 4.481e-02, 6.268e+01, 1.213e+00 }, // FC
        { 0.000e+00, 1.533e+00, 2.801e+01, 3.316e-03, 0.000e+00, 7.407e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.565e-02, 0.000e+00, 1.334e-04, 4.811e-05, 0.000e+00, 3.508e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-2_(CNG)
        { 1.202e+03, 4.522e+01, 0.000e+00, 0.000e+00, 1.361e-01, 2.281e+02, 3.895e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.704e-02, 0.000e+00, 1.259e+00 }, // CO
        { 3.661e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.675e-04, 0.000e+00, 1.191e-02 }, // HC
        { 3.868e+02, 1.455e+01, 0.000e+00, 0.000e+00, 4.378e-02, 7.341e+01, 1.253e+00 }, // FC
        { 1.742e+00, 0.000e+00, 1.203e+00, 3.560e-03, 2.814e-05, 1.824e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.564e-02, 0.000e+00, 1.340e-04, 5.907e-05, 0.000e+00, 4.509e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-2_(P)
        { 1.214e+03, 4.565e+01, 0.000e+00, 0.000e+00, 1.374e-01, 2.303e+02, 3.932e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.704e-02, 0.000e+00, 1.259e+00 }, // CO
        { 3.661e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.675e-04, 0.000e+00, 1.191e-02 }, // HC
        { 3.934e+02, 1.480e+01, 0.000e+00, 0.000e+00, 4.453e-02, 7.466e+01, 1.275e+00 }, // FC
        { 1.742e+00, 0.000e+00, 1.203e+00, 3.560e-03, 2.814e-05, 1.824e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.564e-02, 0.000e+00, 1.340e-04, 5.907e-05, 0.000e+00, 4.509e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-3_(CNG)
        { 9.889e+02, 3.615e+01, 2.302e+01, 0.000e+00, 1.066e-01, 1.824e+02, 3.102e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 7.543e-01 }, // CO
        { 8.573e-02, 0.000e+00, 0.000e+00, 0.000e+00, 5.564e-05, 0.000e+00, 4.033e-03 }, // HC
        { 3.182e+02, 1.163e+01, 7.408e+00, 0.000e+00, 3.430e-02, 5.869e+01, 9.981e-01 }, // FC
        { 6.569e-01, 0.000e+00, 1.493e-01, 7.475e-04, 1.239e-05, 5.773e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.570e-02, 0.000e+00, 1.314e-04, 2.130e-05, 0.000e+00, 1.620e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-3_(P)
        { 9.984e+02, 3.649e+01, 2.324e+01, 0.000e+00, 1.076e-01, 1.841e+02, 3.131e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 7.543e-01 }, // CO
        { 8.573e-02, 0.000e+00, 0.000e+00, 0.000e+00, 5.564e-05, 0.000e+00, 4.033e-03 }, // HC
        { 3.236e+02, 1.183e+01, 7.535e+00, 0.000e+00, 3.489e-02, 5.969e+01, 1.015e+00 }, // FC
        { 6.569e-01, 0.000e+00, 1.493e-01, 7.475e-04, 1.239e-05, 5.773e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.570e-02, 0.000e+00, 1.314e-04, 2.130e-05, 0.000e+00, 1.620e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-4_(CNG)
        { 1.021e+03, 3.572e+01, 7.788e+01, 0.000e+00, 1.061e-01, 1.803e+02, 3.122e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.191e-03, 0.000e+00, 4.327e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.103e-05, 0.000e+00, 1.979e-03 }, // HC
        { 3.287e+02, 1.149e+01, 2.506e+01, 0.000e+00, 3.413e-02, 5.801e+01, 1.005e+00 }, // FC
        { 4.235e-01, 9.159e-03, 3.564e-01, 0.000e+00, 1.005e-05, 2.906e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.302e-04, 1.222e-05, 0.000e+00, 8.904e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-4_(P)
        { 1.031e+03, 3.606e+01, 7.863e+01, 0.000e+00, 1.071e-01, 1.820e+02, 3.152e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.191e-03, 0.000e+00, 4.327e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.103e-05, 0.000e+00, 1.979e-03 }, // HC
        { 3.343e+02, 1.169e+01, 2.549e+01, 0.000e+00, 3.472e-02, 5.899e+01, 1.022e+00 }, // FC
        { 4.235e-01, 9.159e-03, 3.564e-01, 0.000e+00, 1.005e-05, 2.906e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.302e-04, 1.222e-05, 0.000e+00, 8.904e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-5_(CNG)
        { 9.626e+02, 2.911e+01, 2.950e+02, 0.000e+00, 9.933e-02, 1.365e+02, 3.519e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.394e-03, 0.000e+00, 4.558e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.229e-05, 0.000e+00, 2.096e-03 }, // HC
        { 3.097e+02, 9.366e+00, 9.493e+01, 0.000e+00, 3.196e-02, 4.393e+01, 1.132e+00 }, // FC
        { 1.583e-01, 2.889e-03, 1.552e-01, 0.000e+00, 3.524e-06, 8.723e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.579e-02, 0.000e+00, 1.273e-04, 1.271e-05, 0.000e+00, 9.478e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-5_(P)
        { 9.718e+02, 2.938e+01, 2.978e+02, 0.000e+00, 1.003e-01, 1.378e+02, 3.553e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.394e-03, 0.000e+00, 4.558e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.229e-05, 0.000e+00, 2.096e-03 }, // HC
        { 3.150e+02, 9.526e+00, 9.655e+01, 0.000e+00, 3.251e-02, 4.468e+01, 1.152e+00 }, // FC
        { 1.583e-01, 2.889e-03, 1.552e-01, 0.000e+00, 3.524e-06, 8.723e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.579e-02, 0.000e+00, 1.273e-04, 1.271e-05, 0.000e+00, 9.478e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-6_(CNG)
        { 9.240e+02, 2.605e+01, 2.014e+02, 0.000e+00, 1.011e-01, 1.379e+02, 3.233e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.022e-03, 0.000e+00, 4.932e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.418e-05, 0.000e+00, 2.191e-03 }, // HC
        { 2.973e+02, 8.383e+00, 6.480e+01, 0.000e+00, 3.254e-02, 4.437e+01, 1.040e+00 }, // FC
        { 1.751e-01, 3.296e-03, 1.705e-01, 0.000e+00, 4.197e-06, 9.888e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.284e-04, 1.357e-05, 0.000e+00, 9.935e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_M+N1-I_Euro-6_(P)
        { 9.328e+02, 2.630e+01, 2.033e+02, 0.000e+00, 1.021e-01, 1.392e+02, 3.263e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.022e-03, 0.000e+00, 4.932e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.418e-05, 0.000e+00, 2.191e-03 }, // HC
        { 3.024e+02, 8.526e+00, 6.591e+01, 0.000e+00, 3.310e-02, 4.513e+01, 1.058e+00 }, // FC
        { 1.751e-01, 3.296e-03, 1.705e-01, 0.000e+00, 4.197e-06, 9.888e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.284e-04, 1.357e-05, 0.000e+00, 9.935e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-2_(CNG)
        { 1.873e+03, 2.574e+01, 0.000e+00, 0.000e+00, 2.638e-01, 2.905e+02, 5.329e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.830e-02, 0.000e+00, 1.786e+00 }, // CO
        { 1.153e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.919e-04, 0.000e+00, 1.629e-02 }, // HC
        { 6.026e+02, 8.283e+00, 0.000e+00, 0.000e+00, 8.489e-02, 9.349e+01, 1.715e+00 }, // FC
        { 2.327e+00, 0.000e+00, 2.280e+00, 4.510e-03, 8.440e-05, 1.955e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.554e-02, 0.000e+00, 1.383e-04, 9.738e-05, 0.000e+00, 6.500e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-2_(P)
        { 1.890e+03, 2.599e+01, 0.000e+00, 0.000e+00, 2.663e-01, 2.933e+02, 5.380e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.830e-02, 0.000e+00, 1.786e+00 }, // CO
        { 1.153e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.919e-04, 0.000e+00, 1.629e-02 }, // HC
        { 6.129e+02, 8.424e+00, 0.000e+00, 0.000e+00, 8.634e-02, 9.508e+01, 1.744e+00 }, // FC
        { 2.327e+00, 0.000e+00, 2.280e+00, 4.510e-03, 8.440e-05, 1.955e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.554e-02, 0.000e+00, 1.383e-04, 9.738e-05, 0.000e+00, 6.500e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-3_(CNG)
        { 1.530e+03, 2.004e+01, 6.373e+01, 0.000e+00, 1.949e-01, 2.267e+02, 3.828e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.474e-02, 0.000e+00, 9.551e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.733e-05, 0.000e+00, 5.211e-03 }, // HC
        { 4.924e+02, 6.449e+00, 2.051e+01, 0.000e+00, 6.272e-02, 7.294e+01, 1.232e+00 }, // FC
        { 9.082e-01, 0.000e+00, 2.649e-01, 7.490e-04, 3.348e-05, 7.073e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.323e-04, 2.964e-05, 0.000e+00, 1.959e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-3_(P)
        { 1.545e+03, 2.023e+01, 6.433e+01, 0.000e+00, 1.968e-01, 2.288e+02, 3.864e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.474e-02, 0.000e+00, 9.551e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.733e-05, 0.000e+00, 5.211e-03 }, // HC
        { 5.008e+02, 6.559e+00, 2.086e+01, 0.000e+00, 6.379e-02, 7.419e+01, 1.253e+00 }, // FC
        { 9.082e-01, 0.000e+00, 2.649e-01, 7.490e-04, 3.348e-05, 7.073e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.323e-04, 2.964e-05, 0.000e+00, 1.959e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-4_(CNG)
        { 1.347e+03, 2.611e+01, 0.000e+00, 0.000e+00, 1.802e-01, 2.275e+02, 3.565e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.022e-02, 0.000e+00, 6.533e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.888e-05, 0.000e+00, 2.847e-03 }, // HC
        { 4.333e+02, 8.403e+00, 0.000e+00, 0.000e+00, 5.797e-02, 7.321e+01, 1.147e+00 }, // FC
        { 4.970e-01, 1.145e-02, 4.322e-01, 0.000e+00, 1.715e-05, 3.366e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.559e-02, 0.000e+00, 1.361e-04, 2.201e-05, 0.000e+00, 1.507e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-4_(P)
        { 1.359e+03, 2.636e+01, 0.000e+00, 0.000e+00, 1.819e-01, 2.297e+02, 3.599e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.022e-02, 0.000e+00, 6.533e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.888e-05, 0.000e+00, 2.847e-03 }, // HC
        { 4.407e+02, 8.547e+00, 0.000e+00, 0.000e+00, 5.896e-02, 7.446e+01, 1.167e+00 }, // FC
        { 4.970e-01, 1.145e-02, 4.322e-01, 0.000e+00, 1.715e-05, 3.366e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.559e-02, 0.000e+00, 1.361e-04, 2.201e-05, 0.000e+00, 1.507e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-5_(CNG)
        { 1.255e+03, 2.039e+01, 0.000e+00, 0.000e+00, 1.678e-01, 2.010e+02, 3.508e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 6.289e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.924e-05, 0.000e+00, 2.822e-03 }, // HC
        { 4.038e+02, 6.562e+00, 0.000e+00, 0.000e+00, 5.398e-02, 6.469e+01, 1.129e+00 }, // FC
        { 1.830e-01, 3.831e-03, 1.808e-01, 0.000e+00, 5.918e-06, 1.048e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.331e-04, 2.081e-05, 0.000e+00, 1.404e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-5_(P)
        { 1.267e+03, 2.059e+01, 0.000e+00, 0.000e+00, 1.694e-01, 2.029e+02, 3.541e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 6.289e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.924e-05, 0.000e+00, 2.822e-03 }, // HC
        { 4.107e+02, 6.673e+00, 0.000e+00, 0.000e+00, 5.491e-02, 6.579e+01, 1.148e+00 }, // FC
        { 1.830e-01, 3.831e-03, 1.808e-01, 0.000e+00, 5.918e-06, 1.048e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.331e-04, 2.081e-05, 0.000e+00, 1.404e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-6_(CNG)
        { 1.169e+03, 1.673e+01, 1.955e+02, 0.000e+00, 1.455e-01, 1.578e+02, 3.612e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.068e-03, 0.000e+00, 5.912e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.393e-05, 0.000e+00, 2.600e-03 }, // HC
        { 3.760e+02, 5.384e+00, 6.292e+01, 0.000e+00, 4.680e-02, 5.077e+01, 1.162e+00 }, // FC
        { 2.010e-01, 3.945e-03, 2.045e-01, 0.000e+00, 6.027e-06, 1.078e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.574e-02, 0.000e+00, 1.296e-04, 1.750e-05, 0.000e+00, 1.206e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-II_Euro-6_(P)
        { 1.180e+03, 1.689e+01, 1.974e+02, 0.000e+00, 1.468e-01, 1.593e+02, 3.646e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.068e-03, 0.000e+00, 5.912e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.393e-05, 0.000e+00, 2.600e-03 }, // HC
        { 3.824e+02, 5.475e+00, 6.399e+01, 0.000e+00, 4.760e-02, 5.164e+01, 1.182e+00 }, // FC
        { 2.010e-01, 3.945e-03, 2.045e-01, 0.000e+00, 6.027e-06, 1.078e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.574e-02, 0.000e+00, 1.296e-04, 1.750e-05, 0.000e+00, 1.206e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-2_(CNG)
        { 2.272e+03, 5.089e+01, 0.000e+00, 0.000e+00, 2.890e-01, 3.838e+02, 6.525e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.197e-02, 0.000e+00, 2.161e+00 }, // CO
        { 2.097e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.330e-04, 0.000e+00, 2.082e-02 }, // HC
        { 7.311e+02, 1.637e+01, 0.000e+00, 0.000e+00, 9.298e-02, 1.235e+02, 2.100e+00 }, // FC
        { 3.009e+00, 0.000e+00, 2.169e+00, 5.656e-03, 9.258e-05, 3.051e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.561e-02, 0.000e+00, 1.352e-04, 1.118e-04, 0.000e+00, 7.893e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-2_(P)
        { 2.294e+03, 5.137e+01, 0.000e+00, 0.000e+00, 2.917e-01, 3.874e+02, 6.587e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.197e-02, 0.000e+00, 2.161e+00 }, // CO
        { 2.097e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.330e-04, 0.000e+00, 2.082e-02 }, // HC
        { 7.436e+02, 1.665e+01, 0.000e+00, 0.000e+00, 9.457e-02, 1.256e+02, 2.135e+00 }, // FC
        { 3.009e+00, 0.000e+00, 2.169e+00, 5.656e-03, 9.258e-05, 3.051e-01, 0.000e+00 }, // NOx
        { 0.000e+00, 2.561e-02, 0.000e+00, 1.352e-04, 1.118e-04, 0.000e+00, 7.893e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-3_(CNG)
        { 1.932e+03, 4.225e+01, 3.830e+01, 0.000e+00, 2.311e-01, 3.165e+02, 5.376e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.458e-02, 0.000e+00, 1.016e+00 }, // CO
        { 4.528e-03, 0.000e+00, 0.000e+00, 0.000e+00, 8.545e-05, 0.000e+00, 5.490e-03 }, // HC
        { 6.218e+02, 1.360e+01, 1.233e+01, 0.000e+00, 7.435e-02, 1.018e+02, 1.730e+00 }, // FC
        { 9.219e-01, 0.000e+00, 2.187e-01, 8.826e-04, 2.654e-05, 7.771e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.569e-02, 0.000e+00, 1.318e-04, 3.002e-05, 0.000e+00, 2.122e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-3_(P)
        { 1.951e+03, 4.266e+01, 3.867e+01, 0.000e+00, 2.333e-01, 3.195e+02, 5.427e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.458e-02, 0.000e+00, 1.016e+00 }, // CO
        { 4.528e-03, 0.000e+00, 0.000e+00, 0.000e+00, 8.545e-05, 0.000e+00, 5.490e-03 }, // HC
        { 6.324e+02, 1.383e+01, 1.254e+01, 0.000e+00, 7.562e-02, 1.036e+02, 1.759e+00 }, // FC
        { 9.219e-01, 0.000e+00, 2.187e-01, 8.826e-04, 2.654e-05, 7.771e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.569e-02, 0.000e+00, 1.318e-04, 3.002e-05, 0.000e+00, 2.122e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-4_(CNG)
        { 1.887e+03, 4.551e+01, 0.000e+00, 0.000e+00, 2.278e-01, 3.216e+02, 5.412e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.276e-02, 0.000e+00, 8.521e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.212e-05, 0.000e+00, 3.776e-03 }, // HC
        { 6.073e+02, 1.464e+01, 0.000e+00, 0.000e+00, 7.331e-02, 1.035e+02, 1.742e+00 }, // FC
        { 7.238e-01, 1.616e-02, 6.296e-01, 0.000e+00, 2.147e-05, 4.931e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.324e-04, 2.513e-05, 0.000e+00, 1.748e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-4_(P)
        { 1.905e+03, 4.594e+01, 0.000e+00, 0.000e+00, 2.300e-01, 3.247e+02, 5.464e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.276e-02, 0.000e+00, 8.521e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.212e-05, 0.000e+00, 3.776e-03 }, // HC
        { 6.177e+02, 1.489e+01, 0.000e+00, 0.000e+00, 7.456e-02, 1.053e+02, 1.771e+00 }, // FC
        { 7.238e-01, 1.616e-02, 6.296e-01, 0.000e+00, 2.147e-05, 4.931e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.324e-04, 2.513e-05, 0.000e+00, 1.748e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-5_(CNG)
        { 1.758e+03, 3.708e+01, 1.434e+02, 0.000e+00, 2.134e-01, 2.749e+02, 5.374e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.290e-02, 0.000e+00, 8.622e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.425e-05, 0.000e+00, 3.918e-03 }, // HC
        { 5.658e+02, 1.193e+01, 4.613e+01, 0.000e+00, 6.867e-02, 8.846e+01, 1.729e+00 }, // FC
        { 2.699e-01, 5.134e-03, 2.621e-01, 0.000e+00, 7.707e-06, 1.545e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.301e-04, 2.589e-05, 0.000e+00, 1.834e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-5_(P)
        { 1.775e+03, 3.743e+01, 1.447e+02, 0.000e+00, 2.154e-01, 2.775e+02, 5.425e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.290e-02, 0.000e+00, 8.622e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.425e-05, 0.000e+00, 3.918e-03 }, // HC
        { 5.754e+02, 1.214e+01, 4.692e+01, 0.000e+00, 6.984e-02, 8.997e+01, 1.759e+00 }, // FC
        { 2.699e-01, 5.134e-03, 2.621e-01, 0.000e+00, 7.707e-06, 1.545e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.301e-04, 2.589e-05, 0.000e+00, 1.834e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-6_(CNG)
        { 1.639e+03, 3.699e+01, 1.522e+02, 0.000e+00, 1.973e-01, 2.575e+02, 5.120e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.313e-02, 0.000e+00, 8.856e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.346e-05, 0.000e+00, 3.903e-03 }, // HC
        { 5.274e+02, 1.190e+01, 4.899e+01, 0.000e+00, 6.347e-02, 8.287e+01, 1.647e+00 }, // FC
        { 2.995e-01, 5.712e-03, 2.957e-01, 0.000e+00, 8.318e-06, 1.694e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.300e-04, 2.559e-05, 0.000e+00, 1.818e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_CNG_petrol_N1-III_Euro-6_(P)
        { 1.655e+03, 3.734e+01, 1.537e+02, 0.000e+00, 1.991e-01, 2.600e+02, 5.169e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.313e-02, 0.000e+00, 8.856e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.346e-05, 0.000e+00, 3.903e-03 }, // HC
        { 5.364e+02, 1.210e+01, 4.982e+01, 0.000e+00, 6.455e-02, 8.428e+01, 1.676e+00 }, // FC
        { 2.995e-01, 5.712e-03, 2.957e-01, 0.000e+00, 8.318e-06, 1.694e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.300e-04, 2.559e-05, 0.000e+00, 1.818e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-3__(E85)
        { 1.021e+03, 3.732e+01, 2.377e+01, 0.000e+00, 1.101e-01, 1.883e+02, 3.202e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 7.543e-01 }, // CO
        { 8.573e-02, 0.000e+00, 0.000e+00, 0.000e+00, 5.564e-05, 0.000e+00, 4.033e-03 }, // HC
        { 4.983e+02, 1.822e+01, 1.160e+01, 0.000e+00, 5.372e-02, 9.191e+01, 1.563e+00 }, // FC
        { 6.569e-01, 0.000e+00, 1.493e-01, 7.475e-04, 1.239e-05, 5.773e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.570e-02, 0.000e+00, 1.314e-04, 2.130e-05, 0.000e+00, 1.620e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-3__(P)
        { 9.984e+02, 3.649e+01, 2.324e+01, 0.000e+00, 1.076e-01, 1.841e+02, 3.131e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 7.543e-01 }, // CO
        { 8.573e-02, 0.000e+00, 0.000e+00, 0.000e+00, 5.564e-05, 0.000e+00, 4.033e-03 }, // HC
        { 3.236e+02, 1.183e+01, 7.535e+00, 0.000e+00, 3.489e-02, 5.969e+01, 1.015e+00 }, // FC
        { 6.569e-01, 0.000e+00, 1.493e-01, 7.475e-04, 1.239e-05, 5.773e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.570e-02, 0.000e+00, 1.314e-04, 2.130e-05, 0.000e+00, 1.620e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-4__(E85)
        { 1.028e+03, 3.595e+01, 7.838e+01, 0.000e+00, 1.068e-01, 1.814e+02, 3.142e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.096e-03, 0.000e+00, 2.163e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.034e-05, 0.000e+00, 2.572e-03 }, // HC
        { 5.017e+02, 1.755e+01, 3.826e+01, 0.000e+00, 5.211e-02, 8.855e+01, 1.534e+00 }, // FC
        { 4.235e-01, 9.159e-03, 3.564e-01, 0.000e+00, 1.005e-05, 2.906e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.302e-04, 1.222e-05, 0.000e+00, 8.904e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-4__(P)
        { 1.005e+03, 3.515e+01, 7.665e+01, 0.000e+00, 1.044e-01, 1.774e+02, 3.073e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.191e-03, 0.000e+00, 4.327e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.103e-05, 0.000e+00, 1.979e-03 }, // HC
        { 3.259e+02, 1.140e+01, 2.485e+01, 0.000e+00, 3.384e-02, 5.751e+01, 9.961e-01 }, // FC
        { 4.235e-01, 9.159e-03, 3.564e-01, 0.000e+00, 1.005e-05, 2.906e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.302e-04, 1.222e-05, 0.000e+00, 8.904e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-5__(E85)
        { 9.663e+02, 2.922e+01, 2.962e+02, 0.000e+00, 9.972e-02, 1.371e+02, 3.533e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.197e-03, 0.000e+00, 2.279e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.198e-05, 0.000e+00, 2.725e-03 }, // HC
        { 4.717e+02, 1.426e+01, 1.446e+02, 0.000e+00, 4.867e-02, 6.690e+01, 1.725e+00 }, // FC
        { 1.583e-01, 2.889e-03, 1.552e-01, 0.000e+00, 3.524e-06, 8.723e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.579e-02, 0.000e+00, 1.273e-04, 1.271e-05, 0.000e+00, 9.478e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-5__(P)
        { 9.450e+02, 2.857e+01, 2.896e+02, 0.000e+00, 9.752e-02, 1.340e+02, 3.455e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.394e-03, 0.000e+00, 4.558e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.229e-05, 0.000e+00, 2.096e-03 }, // HC
        { 3.064e+02, 9.263e+00, 9.390e+01, 0.000e+00, 3.161e-02, 4.345e+01, 1.120e+00 }, // FC
        { 1.583e-01, 2.889e-03, 1.552e-01, 0.000e+00, 3.524e-06, 8.723e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.579e-02, 0.000e+00, 1.273e-04, 1.271e-05, 0.000e+00, 9.478e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-6__(E85)
        { 9.483e+02, 2.642e+01, 1.818e+02, 0.000e+00, 1.053e-01, 1.438e+02, 3.275e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.569e-03, 0.000e+00, 2.496e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.510e-05, 0.000e+00, 2.880e-03 }, // HC
        { 4.629e+02, 1.290e+01, 8.876e+01, 0.000e+00, 5.139e-02, 7.018e+01, 1.599e+00 }, // FC
        { 1.753e-01, 3.293e-03, 1.699e-01, 0.000e+00, 4.284e-06, 9.932e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.285e-04, 1.379e-05, 0.000e+00, 1.005e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_M+N1-I_Euro-6__(P)
        { 9.273e+02, 2.584e+01, 1.778e+02, 0.000e+00, 1.029e-01, 1.406e+02, 3.203e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.137e-03, 0.000e+00, 4.992e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.469e-05, 0.000e+00, 2.216e-03 }, // HC
        { 3.006e+02, 8.376e+00, 5.764e+01, 0.000e+00, 3.337e-02, 4.558e+01, 1.038e+00 }, // FC
        { 1.753e-01, 3.293e-03, 1.699e-01, 0.000e+00, 4.284e-06, 9.932e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.576e-02, 0.000e+00, 1.285e-04, 1.379e-05, 0.000e+00, 1.005e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-3__(E85)
        { 1.580e+03, 2.069e+01, 6.579e+01, 0.000e+00, 2.012e-01, 2.340e+02, 3.952e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.474e-02, 0.000e+00, 9.551e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.733e-05, 0.000e+00, 5.211e-03 }, // HC
        { 7.710e+02, 1.010e+01, 3.211e+01, 0.000e+00, 9.822e-02, 1.142e+02, 1.929e+00 }, // FC
        { 9.082e-01, 0.000e+00, 2.649e-01, 7.490e-04, 3.348e-05, 7.073e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.323e-04, 2.964e-05, 0.000e+00, 1.959e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-3__(P)
        { 1.545e+03, 2.023e+01, 6.433e+01, 0.000e+00, 1.968e-01, 2.288e+02, 3.864e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.474e-02, 0.000e+00, 9.551e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.733e-05, 0.000e+00, 5.211e-03 }, // HC
        { 5.008e+02, 6.559e+00, 2.086e+01, 0.000e+00, 6.379e-02, 7.419e+01, 1.253e+00 }, // FC
        { 9.082e-01, 0.000e+00, 2.649e-01, 7.490e-04, 3.348e-05, 7.073e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.323e-04, 2.964e-05, 0.000e+00, 1.959e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-4__(E85)
        { 1.355e+03, 2.628e+01, 0.000e+00, 0.000e+00, 1.813e-01, 2.290e+02, 3.588e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.111e-03, 0.000e+00, 3.267e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.354e-05, 0.000e+00, 3.701e-03 }, // HC
        { 6.615e+02, 1.283e+01, 0.000e+00, 0.000e+00, 8.850e-02, 1.118e+02, 1.751e+00 }, // FC
        { 4.970e-01, 1.145e-02, 4.322e-01, 0.000e+00, 1.715e-05, 3.366e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.559e-02, 0.000e+00, 1.361e-04, 2.201e-05, 0.000e+00, 1.507e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-4__(P)
        { 1.325e+03, 2.570e+01, 0.000e+00, 0.000e+00, 1.773e-01, 2.239e+02, 3.509e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.022e-02, 0.000e+00, 6.533e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.888e-05, 0.000e+00, 2.847e-03 }, // HC
        { 4.296e+02, 8.332e+00, 0.000e+00, 0.000e+00, 5.748e-02, 7.259e+01, 1.138e+00 }, // FC
        { 4.970e-01, 1.145e-02, 4.322e-01, 0.000e+00, 1.715e-05, 3.366e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.559e-02, 0.000e+00, 1.361e-04, 2.201e-05, 0.000e+00, 1.507e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-5__(E85)
        { 1.260e+03, 2.047e+01, 0.000e+00, 0.000e+00, 1.684e-01, 2.018e+02, 3.521e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.012e-03, 0.000e+00, 3.145e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.402e-05, 0.000e+00, 3.668e-03 }, // HC
        { 6.150e+02, 9.992e+00, 0.000e+00, 0.000e+00, 8.221e-02, 9.851e+01, 1.719e+00 }, // FC
        { 1.830e-01, 3.831e-03, 1.808e-01, 0.000e+00, 5.918e-06, 1.048e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.331e-04, 2.081e-05, 0.000e+00, 1.404e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-5__(P)
        { 1.232e+03, 2.002e+01, 0.000e+00, 0.000e+00, 1.647e-01, 1.974e+02, 3.444e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.002e-02, 0.000e+00, 6.289e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.924e-05, 0.000e+00, 2.822e-03 }, // HC
        { 3.994e+02, 6.490e+00, 0.000e+00, 0.000e+00, 5.339e-02, 6.398e+01, 1.116e+00 }, // FC
        { 1.830e-01, 3.831e-03, 1.808e-01, 0.000e+00, 5.918e-06, 1.048e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.331e-04, 2.081e-05, 0.000e+00, 1.404e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-6__(E85)
        { 1.197e+03, 1.701e+01, 1.687e+02, 0.000e+00, 1.512e-01, 1.654e+02, 3.623e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.612e-03, 0.000e+00, 2.985e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.797e-05, 0.000e+00, 3.406e-03 }, // HC
        { 5.845e+02, 8.301e+00, 8.235e+01, 0.000e+00, 7.380e-02, 8.073e+01, 1.769e+00 }, // FC
        { 2.005e-01, 4.022e-03, 2.060e-01, 0.000e+00, 6.089e-06, 1.071e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.299e-04, 1.783e-05, 0.000e+00, 1.221e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-II_Euro-6__(P)
        { 1.171e+03, 1.663e+01, 1.650e+02, 0.000e+00, 1.479e-01, 1.617e+02, 3.543e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.225e-03, 0.000e+00, 5.970e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.459e-05, 0.000e+00, 2.620e-03 }, // HC
        { 3.796e+02, 5.391e+00, 5.349e+01, 0.000e+00, 4.793e-02, 5.243e+01, 1.149e+00 }, // FC
        { 2.005e-01, 4.022e-03, 2.060e-01, 0.000e+00, 6.089e-06, 1.071e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.299e-04, 1.783e-05, 0.000e+00, 1.221e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-3__(E85)
        { 1.995e+03, 4.362e+01, 3.954e+01, 0.000e+00, 2.385e-01, 3.267e+02, 5.549e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.458e-02, 0.000e+00, 1.016e+00 }, // CO
        { 4.528e-03, 0.000e+00, 0.000e+00, 0.000e+00, 8.545e-05, 0.000e+00, 5.490e-03 }, // HC
        { 9.737e+02, 2.129e+01, 1.930e+01, 0.000e+00, 1.164e-01, 1.595e+02, 2.709e+00 }, // FC
        { 9.219e-01, 0.000e+00, 2.187e-01, 8.826e-04, 2.654e-05, 7.771e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.569e-02, 0.000e+00, 1.318e-04, 3.002e-05, 0.000e+00, 2.122e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-3__(P)
        { 1.951e+03, 4.266e+01, 3.867e+01, 0.000e+00, 2.333e-01, 3.195e+02, 5.427e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.458e-02, 0.000e+00, 1.016e+00 }, // CO
        { 4.528e-03, 0.000e+00, 0.000e+00, 0.000e+00, 8.545e-05, 0.000e+00, 5.490e-03 }, // HC
        { 6.324e+02, 1.383e+01, 1.254e+01, 0.000e+00, 7.562e-02, 1.036e+02, 1.759e+00 }, // FC
        { 9.219e-01, 0.000e+00, 2.187e-01, 8.826e-04, 2.654e-05, 7.771e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.569e-02, 0.000e+00, 1.318e-04, 3.002e-05, 0.000e+00, 2.122e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-4__(E85)
        { 1.899e+03, 4.580e+01, 0.000e+00, 0.000e+00, 2.293e-01, 3.237e+02, 5.447e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.382e-03, 0.000e+00, 4.261e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.075e-05, 0.000e+00, 4.909e-03 }, // HC
        { 9.271e+02, 2.236e+01, 0.000e+00, 0.000e+00, 1.119e-01, 1.580e+02, 2.659e+00 }, // FC
        { 7.238e-01, 1.616e-02, 6.296e-01, 0.000e+00, 2.147e-05, 4.931e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.324e-04, 2.513e-05, 0.000e+00, 1.748e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-4__(P)
        { 1.857e+03, 4.479e+01, 0.000e+00, 0.000e+00, 2.242e-01, 3.165e+02, 5.327e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.276e-02, 0.000e+00, 8.521e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.212e-05, 0.000e+00, 3.776e-03 }, // HC
        { 6.022e+02, 1.452e+01, 0.000e+00, 0.000e+00, 7.269e-02, 1.026e+02, 1.727e+00 }, // FC
        { 7.238e-01, 1.616e-02, 6.296e-01, 0.000e+00, 2.147e-05, 4.931e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.567e-02, 0.000e+00, 1.324e-04, 2.513e-05, 0.000e+00, 1.748e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-5__(E85)
        { 1.765e+03, 3.723e+01, 1.439e+02, 0.000e+00, 2.142e-01, 2.760e+02, 5.395e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.451e-03, 0.000e+00, 4.311e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.353e-05, 0.000e+00, 5.094e-03 }, // HC
        { 8.616e+02, 1.817e+01, 7.025e+01, 0.000e+00, 1.046e-01, 1.347e+02, 2.633e+00 }, // FC
        { 2.699e-01, 5.134e-03, 2.621e-01, 0.000e+00, 7.707e-06, 1.545e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.301e-04, 2.589e-05, 0.000e+00, 1.834e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-5__(P)
        { 1.726e+03, 3.640e+01, 1.407e+02, 0.000e+00, 2.095e-01, 2.699e+02, 5.276e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.290e-02, 0.000e+00, 8.622e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.425e-05, 0.000e+00, 3.918e-03 }, // HC
        { 5.596e+02, 1.180e+01, 4.563e+01, 0.000e+00, 6.792e-02, 8.749e+01, 1.710e+00 }, // FC
        { 2.699e-01, 5.134e-03, 2.621e-01, 0.000e+00, 7.707e-06, 1.545e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.301e-04, 2.589e-05, 0.000e+00, 1.834e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-6__(E85)
        { 1.702e+03, 3.567e+01, 1.638e+02, 0.000e+00, 2.066e-01, 2.626e+02, 5.317e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.649e-03, 0.000e+00, 4.456e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.343e-05, 0.000e+00, 5.100e-03 }, // HC
        { 8.305e+02, 1.741e+01, 7.994e+01, 0.000e+00, 1.009e-01, 1.282e+02, 2.595e+00 }, // FC
        { 2.997e-01, 5.703e-03, 2.945e-01, 0.000e+00, 8.512e-06, 1.703e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.300e-04, 2.593e-05, 0.000e+00, 1.838e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FFV_N1-III_Euro-6__(P)
        { 1.664e+03, 3.489e+01, 1.602e+02, 0.000e+00, 2.021e-01, 2.568e+02, 5.199e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.330e-02, 0.000e+00, 8.913e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.418e-05, 0.000e+00, 3.923e-03 }, // HC
        { 5.394e+02, 1.131e+01, 5.192e+01, 0.000e+00, 6.551e-02, 8.326e+01, 1.686e+00 }, // FC
        { 2.997e-01, 5.703e-03, 2.945e-01, 0.000e+00, 8.512e-06, 1.703e-02, 0.000e+00 }, // NOx
        { 0.000e+00, 2.573e-02, 0.000e+00, 1.300e-04, 2.593e-05, 0.000e+00, 1.838e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_BEV_M+N1-I
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.592e-02, 0.000e+00, 1.217e-04, 0.000e+00, 0.000e+00, 2.860e-07 }, // PM + PM (non-exhaust)
        { 1.013e+00, 6.565e-02, 1.220e+00, 0.000e+00, 1.963e-04, 2.749e-01, 4.792e-03 }, // FC_MJ
    },
    {
        // LCV_BEV_N1-II
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.585e-02, 0.000e+00, 1.243e-04, 0.000e+00, 0.000e+00, 2.099e-06 }, // PM + PM (non-exhaust)
        { 1.165e+00, 6.878e-02, 1.282e+00, 0.000e+00, 2.725e-04, 3.351e-01, 6.672e-03 }, // FC_MJ
    },
    {
        // LCV_BEV_N1-IIII
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.577e-02, 0.000e+00, 1.278e-04, 0.000e+00, 0.000e+00, 4.852e-06 }, // PM + PM (non-exhaust)
        { 1.284e+00, 1.068e-01, 1.271e+00, 0.000e+00, 3.441e-04, 5.144e-01, 8.748e-03 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_M+N1-I_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.553e-02, 0.000e+00, 1.415e-04, 0.000e+00, 0.000e+00, 2.232e-05 }, // PM + PM (non-exhaust)
        { 2.732e-01, 1.074e-01, 0.000e+00, 0.000e+00, 9.997e-05, 4.178e-01, 6.746e-04 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_M+N1-I_Euro-5_(P)
        { 3.598e+02, 7.769e+01, 0.000e+00, 0.000e+00, 7.921e-02, 2.536e+02, 2.165e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 3.219e-03, 6.181e-03, 0.000e+00, 4.505e-01 }, // CO
        { 4.830e-03, 0.000e+00, 0.000e+00, 2.405e-04, 2.528e-05, 0.000e+00, 2.140e-03 }, // HC
        { 1.166e+02, 2.519e+01, 0.000e+00, 0.000e+00, 2.568e-02, 8.221e+01, 7.018e-01 }, // FC
        { 1.615e-01, 2.559e-03, 1.481e-01, 0.000e+00, 3.761e-06, 8.979e-03, 0.000e+00 }, // NOx
        { 0.000e+00, 2.553e-02, 0.000e+00, 3.962e-04, 4.473e-06, 2.190e-03, 8.410e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_M+N1-I_Euro-6_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.551e-02, 0.000e+00, 1.429e-04, 0.000e+00, 0.000e+00, 2.388e-05 }, // PM + PM (non-exhaust)
        { 3.142e-01, 1.039e-01, 0.000e+00, 0.000e+00, 1.127e-04, 4.212e-01, 6.603e-04 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_M+N1-I_Euro-6_(P)
        { 5.399e+02, 5.682e+01, 1.212e+03, 0.000e+00, 2.675e-02, 1.253e+02, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.966e-03, 0.000e+00, 4.925e-01 }, // CO
        { 1.079e-02, 0.000e+00, 0.000e+00, 1.792e-04, 2.919e-05, 0.000e+00, 2.261e-03 }, // HC
        { 1.750e+02, 1.842e+01, 3.929e+02, 0.000e+00, 8.673e-03, 4.062e+01, 0.000e+00 }, // FC
        { 1.796e-01, 2.830e-03, 1.640e-01, 0.000e+00, 4.601e-06, 9.839e-03, 1.308e-05 }, // NOx
        { 0.000e+00, 2.551e-02, 0.000e+00, 3.752e-04, 6.165e-06, 1.026e-03, 9.415e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-II_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.532e-02, 0.000e+00, 1.509e-04, 0.000e+00, 0.000e+00, 2.714e-05 }, // PM + PM (non-exhaust)
        { 5.809e-01, 9.509e-02, 0.000e+00, 0.000e+00, 1.954e-04, 4.722e-01, 7.686e-04 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-II_Euro-5_(P)
        { 7.025e+02, 5.366e+01, 0.000e+00, 0.000e+00, 1.622e-01, 2.837e+02, 2.901e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.029e-02, 0.000e+00, 6.569e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.181e-05, 0.000e+00, 3.051e-03 }, // HC
        { 2.277e+02, 1.740e+01, 0.000e+00, 0.000e+00, 5.259e-02, 9.197e+01, 9.405e-01 }, // FC
        { 1.925e-01, 2.858e-03, 1.709e-01, 0.000e+00, 6.837e-06, 1.031e-02, 3.646e-05 }, // NOx
        { 0.000e+00, 2.532e-02, 0.000e+00, 1.816e-04, 2.033e-05, 0.000e+00, 1.464e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-II_Euro-6_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.539e-02, 0.000e+00, 1.474e-04, 0.000e+00, 0.000e+00, 2.490e-05 }, // PM + PM (non-exhaust)
        { 5.136e-01, 1.001e-01, 0.000e+00, 0.000e+00, 1.751e-04, 4.619e-01, 1.065e-03 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-II_Euro-6_(P)
        { 6.586e+02, 6.290e+01, 1.363e+03, 0.000e+00, 3.894e-02, 1.365e+02, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.179e-03, 0.000e+00, 6.045e-01 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.593e-05, 0.000e+00, 2.779e-03 }, // HC
        { 2.135e+02, 2.039e+01, 4.420e+02, 0.000e+00, 1.262e-02, 4.426e+01, 0.000e+00 }, // FC
        { 2.075e-01, 3.250e-03, 1.874e-01, 0.000e+00, 6.768e-06, 1.140e-02, 1.661e-05 }, // NOx
        { 0.000e+00, 2.539e-02, 0.000e+00, 2.273e-04, 1.529e-05, 0.000e+00, 1.246e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-III_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.542e-02, 0.000e+00, 1.464e-04, 0.000e+00, 0.000e+00, 2.459e-05 }, // PM + PM (non-exhaust)
        { 6.050e-01, 1.668e-01, 0.000e+00, 0.000e+00, 2.418e-04, 6.658e-01, 2.662e-03 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-III_Euro-5_(P)
        { 9.913e+02, 8.876e+01, 0.000e+00, 0.000e+00, 1.999e-01, 4.035e+02, 4.262e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.305e-02, 0.000e+00, 8.822e-01 }, // CO
        { 4.732e-03, 0.000e+00, 0.000e+00, 0.000e+00, 6.678e-05, 0.000e+00, 4.172e-03 }, // HC
        { 3.214e+02, 2.877e+01, 0.000e+00, 0.000e+00, 6.479e-02, 1.308e+02, 1.382e+00 }, // FC
        { 2.791e-01, 4.170e-03, 2.547e-01, 0.000e+00, 8.608e-06, 1.482e-02, 4.875e-05 }, // NOx
        { 0.000e+00, 2.542e-02, 0.000e+00, 3.716e-04, 1.911e-05, 0.000e+00, 1.853e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-III_Euro-6_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.542e-02, 0.000e+00, 1.465e-04, 0.000e+00, 0.000e+00, 2.489e-05 }, // PM + PM (non-exhaust)
        { 6.126e-01, 1.653e-01, 0.000e+00, 0.000e+00, 2.422e-04, 6.630e-01, 2.782e-03 }, // FC_MJ
    },
    {
        // LCV_PHEV_petrol_N1-III_Euro-6_(P)
        { 1.046e+03, 8.643e+01, 2.285e+03, 0.000e+00, 5.594e-02, 1.792e+02, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.326e-02, 0.000e+00, 9.031e-01 }, // CO
        { 1.252e-02, 0.000e+00, 0.000e+00, 0.000e+00, 6.575e-05, 0.000e+00, 4.148e-03 }, // HC
        { 3.392e+02, 2.802e+01, 7.408e+02, 0.000e+00, 1.813e-02, 5.809e+01, 0.000e+00 }, // FC
        { 3.083e-01, 4.788e-03, 2.765e-01, 0.000e+00, 9.244e-06, 1.748e-02, 2.203e-05 }, // NOx
        { 0.000e+00, 2.542e-02, 0.000e+00, 3.969e-04, 1.799e-05, 0.000e+00, 1.833e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_M+N1-I_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.556e-02, 0.000e+00, 1.393e-04, 0.000e+00, 0.000e+00, 1.846e-05 }, // PM + PM (non-exhaust)
        { 4.963e-01, 1.003e-01, 0.000e+00, 0.000e+00, 1.003e-04, 4.316e-01, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_M+N1-I_Euro-5_(D)
        { 4.164e+02, 7.024e+01, 0.000e+00, 0.000e+00, 7.850e-02, 2.439e+02, 2.068e+00 }, // CO2(total)
        { 3.836e-01, 0.000e+00, 2.930e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.125e-01, 0.000e+00, 5.217e-02, 0.000e+00, 3.446e-06, 0.000e+00, 0.000e+00 }, // HC
        { 1.338e+02, 2.257e+01, 0.000e+00, 0.000e+00, 2.523e-02, 7.838e+01, 6.646e-01 }, // FC
        { 3.627e+00, 5.404e-01, 0.000e+00, 0.000e+00, 1.057e-03, 1.286e+00, 4.761e-02 }, // NOx
        { 2.819e-02, 2.556e-02, 0.000e+00, 1.393e-04, 1.901e-06, 2.065e-03, 2.540e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_M+N1-I_Euro-6_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.548e-02, 0.000e+00, 1.429e-04, 0.000e+00, 0.000e+00, 2.151e-05 }, // PM + PM (non-exhaust)
        { 5.930e-01, 9.368e-02, 4.886e-02, 0.000e+00, 1.263e-04, 4.364e-01, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_M+N1-I_Euro-6_(D)
        { 5.308e+02, 5.979e+01, 0.000e+00, 0.000e+00, 9.788e-02, 2.453e+02, 2.094e+00 }, // CO2(total)
        { 7.494e-02, 1.830e-02, 3.344e-01, 0.000e+00, 0.000e+00, 1.711e-03, 0.000e+00 }, // CO
        { 8.660e-02, 1.410e-02, 4.193e-01, 0.000e+00, 0.000e+00, 1.043e-02, 0.000e+00 }, // HC
        { 1.706e+02, 1.921e+01, 0.000e+00, 0.000e+00, 3.146e-02, 7.882e+01, 6.730e-01 }, // FC
        { 0.000e+00, 3.850e-02, 0.000e+00, 2.295e-03, 3.422e-05, 1.762e-01, 1.897e-03 }, // NOx
        { 0.000e+00, 2.548e-02, 0.000e+00, 1.429e-04, 5.139e-05, 3.003e-02, 2.151e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-II_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.536e-02, 0.000e+00, 1.486e-04, 0.000e+00, 0.000e+00, 2.462e-05 }, // PM + PM (non-exhaust)
        { 7.460e-01, 1.123e-01, 4.248e-01, 0.000e+00, 1.846e-04, 5.023e-01, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-II_Euro-5_(D)
        { 8.222e+02, 5.781e+01, 0.000e+00, 0.000e+00, 1.554e-01, 3.169e+02, 2.090e+00 }, // CO2(total)
        { 6.252e-02, 0.000e+00, 5.307e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.699e-01, 2.225e-04, 3.693e-02, 6.291e-05, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 2.643e+02, 1.858e+01, 0.000e+00, 0.000e+00, 4.994e-02, 1.018e+02, 6.716e-01 }, // FC
        { 6.916e+00, 1.071e-01, 0.000e+00, 0.000e+00, 1.419e-03, 5.488e-01, 8.398e-02 }, // NOx
        { 7.422e-03, 2.556e-02, 5.025e-03, 1.486e-04, 5.360e-07, 0.000e+00, 5.419e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-II_Euro-6_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.542e-02, 0.000e+00, 1.455e-04, 0.000e+00, 0.000e+00, 2.195e-05 }, // PM + PM (non-exhaust)
        { 9.103e-01, 9.656e-02, 3.682e-01, 0.000e+00, 1.893e-04, 4.959e-01, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-II_Euro-6_(D)
        { 8.890e+02, 6.269e+01, 0.000e+00, 0.000e+00, 1.617e-01, 3.350e+02, 2.354e+00 }, // CO2(total)
        { 7.321e-02, 1.812e-02, 3.483e-01, 0.000e+00, 0.000e+00, 2.812e-04, 0.000e+00 }, // CO
        { 7.019e-02, 1.506e-02, 4.471e-01, 0.000e+00, 0.000e+00, 8.384e-03, 0.000e+00 }, // HC
        { 2.857e+02, 2.015e+01, 0.000e+00, 0.000e+00, 5.195e-02, 1.077e+02, 7.567e-01 }, // FC
        { 0.000e+00, 3.755e-02, 0.000e+00, 1.524e-03, 6.949e-05, 1.484e-01, 3.247e-03 }, // NOx
        { 0.000e+00, 2.542e-02, 3.044e-01, 1.455e-04, 4.831e-05, 7.130e-03, 2.195e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-III_Euro-5_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.546e-02, 0.000e+00, 1.437e-04, 0.000e+00, 0.000e+00, 2.116e-05 }, // PM + PM (non-exhaust)
        { 1.059e+00, 1.527e-01, 1.420e-01, 0.000e+00, 2.380e-04, 7.064e-01, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-III_Euro-5_(D)
        { 1.216e+03, 9.331e+01, 0.000e+00, 0.000e+00, 2.030e-01, 4.611e+02, 2.954e+00 }, // CO2(total)
        { 1.194e-01, 0.000e+00, 1.070e-01, 0.000e+00, 3.424e-06, 0.000e+00, 2.457e-04 }, // CO
        { 7.199e-02, 8.182e-04, 5.651e-03, 1.147e-05, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 3.909e+02, 2.999e+01, 0.000e+00, 0.000e+00, 6.525e-02, 1.482e+02, 9.494e-01 }, // FC
        { 7.420e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.570e-03, 5.207e-01, 8.938e-02 }, // NOx
        { 2.252e-02, 2.573e-02, 0.000e+00, 1.437e-04, 7.723e-07, 7.039e-04, 2.387e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-III_Euro-6_(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.550e-02, 0.000e+00, 1.412e-04, 0.000e+00, 0.000e+00, 1.865e-05 }, // PM + PM (non-exhaust)
        { 9.580e-01, 1.574e-01, 0.000e+00, 0.000e+00, 2.347e-04, 7.151e-01, 2.851e-05 }, // FC_MJ
    },
    {
        // LCV_PHEV_diesel_N1-III_Euro-6_(D)
        { 1.277e+03, 8.892e+01, 0.000e+00, 0.000e+00, 2.041e-01, 4.559e+02, 3.047e+00 }, // CO2(total)
        { 5.373e-02, 1.924e-02, 3.012e-01, 0.000e+00, 0.000e+00, 3.933e-03, 0.000e+00 }, // CO
        { 6.316e-02, 1.536e-02, 3.936e-01, 0.000e+00, 0.000e+00, 1.302e-02, 0.000e+00 }, // HC
        { 4.102e+02, 2.858e+01, 0.000e+00, 0.000e+00, 6.559e-02, 1.465e+02, 9.793e-01 }, // FC
        { 0.000e+00, 2.964e-02, 0.000e+00, 2.155e-03, 4.403e-05, 1.485e-01, 2.533e-03 }, // NOx
        { 0.000e+00, 2.550e-02, 2.689e-01, 1.412e-04, 4.821e-05, 6.923e-03, 1.865e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // LCV_FuelCell_N1-III
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 7.114e+01, 5.914e+00, 7.037e+01, 0.000e+00, 1.906e-02, 2.849e+01, 4.845e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 2.577e-02, 0.000e+00, 1.278e-04, 0.000e+00, 0.000e+00, 4.852e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_50ties
        { 3.820e+03, 5.403e+02, 0.000e+00, 9.843e+00, 0.000e+00, 2.122e+03, 6.104e-01 }, // CO2(total)
        { 2.777e+01, 4.890e-01, 1.976e+01, 0.000e+00, 6.969e-05, 1.455e+00, 0.000e+00 }, // CO
        { 9.746e+00, 0.000e+00, 4.569e+00, 0.000e+00, 8.883e-05, 4.576e-02, 2.021e-03 }, // HC
        { 1.228e+03, 1.736e+02, 0.000e+00, 3.163e+00, 0.000e+00, 6.820e+02, 1.962e-01 }, // FC
        { 4.784e+01, 8.948e+00, 0.000e+00, 1.324e-01, 0.000e+00, 3.154e+01, 3.542e-02 }, // NOx
        { 6.597e+00, 1.219e-01, 1.141e+00, 4.213e-03, 6.024e-05, 5.283e-01, 1.336e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_60ties
        { 3.820e+03, 5.403e+02, 0.000e+00, 9.843e+00, 0.000e+00, 2.122e+03, 6.104e-01 }, // CO2(total)
        { 2.777e+01, 4.890e-01, 1.976e+01, 0.000e+00, 6.969e-05, 1.455e+00, 0.000e+00 }, // CO
        { 9.746e+00, 0.000e+00, 4.569e+00, 0.000e+00, 8.883e-05, 4.576e-02, 2.021e-03 }, // HC
        { 1.228e+03, 1.736e+02, 0.000e+00, 3.163e+00, 0.000e+00, 6.820e+02, 1.962e-01 }, // FC
        { 4.784e+01, 8.948e+00, 0.000e+00, 1.324e-01, 0.000e+00, 3.154e+01, 3.542e-02 }, // NOx
        { 6.597e+00, 1.219e-01, 1.141e+00, 4.213e-03, 6.024e-05, 5.283e-01, 1.336e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_70ties
        { 3.820e+03, 5.403e+02, 0.000e+00, 9.843e+00, 0.000e+00, 2.122e+03, 6.104e-01 }, // CO2(total)
        { 2.777e+01, 4.890e-01, 1.976e+01, 0.000e+00, 6.969e-05, 1.455e+00, 0.000e+00 }, // CO
        { 9.746e+00, 0.000e+00, 4.569e+00, 0.000e+00, 8.883e-05, 4.576e-02, 2.021e-03 }, // HC
        { 1.228e+03, 1.736e+02, 0.000e+00, 3.163e+00, 0.000e+00, 6.820e+02, 1.962e-01 }, // FC
        { 4.784e+01, 8.948e+00, 0.000e+00, 1.324e-01, 0.000e+00, 3.154e+01, 3.542e-02 }, // NOx
        { 6.597e+00, 1.219e-01, 1.141e+00, 4.213e-03, 6.024e-05, 5.283e-01, 1.336e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_80ties
        { 3.820e+03, 5.403e+02, 0.000e+00, 9.843e+00, 0.000e+00, 2.122e+03, 6.104e-01 }, // CO2(total)
        { 2.777e+01, 4.890e-01, 1.976e+01, 0.000e+00, 6.969e-05, 1.455e+00, 0.000e+00 }, // CO
        { 9.746e+00, 0.000e+00, 4.569e+00, 0.000e+00, 8.883e-05, 4.576e-02, 2.021e-03 }, // HC
        { 1.228e+03, 1.736e+02, 0.000e+00, 3.163e+00, 0.000e+00, 6.820e+02, 1.962e-01 }, // FC
        { 4.784e+01, 8.948e+00, 0.000e+00, 1.324e-01, 0.000e+00, 3.154e+01, 3.542e-02 }, // NOx
        { 6.597e+00, 1.219e-01, 1.141e+00, 4.213e-03, 6.024e-05, 5.283e-01, 1.336e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-I
        { 3.225e+03, 5.996e+02, 0.000e+00, 6.978e+00, 0.000e+00, 2.062e+03, 0.000e+00 }, // CO2(total)
        { 1.395e+01, 1.026e+00, 0.000e+00, 5.421e-03, 0.000e+00, 3.069e+00, 6.439e-03 }, // CO
        { 8.721e+00, 0.000e+00, 3.548e+00, 0.000e+00, 1.209e-04, 3.297e-01, 1.826e-03 }, // HC
        { 1.037e+03, 1.927e+02, 0.000e+00, 2.242e+00, 0.000e+00, 6.627e+02, 0.000e+00 }, // FC
        { 3.317e+01, 7.200e+00, 0.000e+00, 4.470e-02, 0.000e+00, 2.168e+01, 0.000e+00 }, // NOx
        { 6.240e+00, 0.000e+00, 0.000e+00, 6.116e-03, 6.562e-05, 3.867e-01, 4.812e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-II
        { 2.132e+03, 7.547e+02, 6.397e+02, 5.888e-01, 0.000e+00, 1.916e+03, 0.000e+00 }, // CO2(total)
        { 1.302e+01, 6.516e-01, 1.034e+01, 0.000e+00, 0.000e+00, 1.631e+00, 0.000e+00 }, // CO
        { 5.507e+00, 0.000e+00, 3.037e+00, 0.000e+00, 7.057e-05, 4.911e-02, 5.389e-03 }, // HC
        { 6.851e+02, 2.425e+02, 2.056e+02, 1.892e-01, 0.000e+00, 6.157e+02, 0.000e+00 }, // FC
        { 3.753e+01, 7.872e+00, 3.710e+01, 2.785e-03, 0.000e+00, 1.917e+01, 0.000e+00 }, // NOx
        { 2.810e+00, 8.861e-02, 1.079e+00, 1.232e-03, 6.109e-05, 1.992e-01, 1.748e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-III
        { 2.968e+03, 6.866e+02, 1.799e+02, 0.000e+00, 8.933e-02, 1.970e+03, 0.000e+00 }, // CO2(total)
        { 2.060e+01, 4.292e-01, 6.576e+00, 0.000e+00, 0.000e+00, 1.412e+00, 0.000e+00 }, // CO
        { 5.166e+00, 0.000e+00, 2.793e+00, 0.000e+00, 4.845e-05, 0.000e+00, 5.850e-03 }, // HC
        { 9.537e+02, 2.206e+02, 5.781e+01, 0.000e+00, 2.871e-02, 6.332e+02, 0.000e+00 }, // FC
        { 2.574e+01, 6.351e+00, 2.131e+01, 0.000e+00, 0.000e+00, 1.520e+01, 0.000e+00 }, // NOx
        { 4.052e+00, 0.000e+00, 2.192e-02, 1.357e-03, 9.859e-05, 1.326e-01, 8.545e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-IV_EGR
        { 1.575e+03, 7.917e+02, 2.019e+03, 0.000e+00, 0.000e+00, 1.900e+03, 0.000e+00 }, // CO2(total)
        { 1.075e+01, 4.436e-01, 1.611e+01, 0.000e+00, 0.000e+00, 1.075e+00, 0.000e+00 }, // CO
        { 2.636e-01, 4.660e-02, 3.043e-01, 0.000e+00, 0.000e+00, 1.052e-01, 0.000e+00 }, // HC
        { 5.060e+02, 2.544e+02, 6.487e+02, 0.000e+00, 0.000e+00, 6.107e+02, 0.000e+00 }, // FC
        { 3.844e+01, 4.639e+00, 6.508e+01, 0.000e+00, 0.000e+00, 1.144e+01, 0.000e+00 }, // NOx
        { 1.931e+00, 1.913e-02, 7.545e-01, 1.234e-03, 6.090e-05, 4.086e-02, 1.677e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-IV_SCR
        { 1.442e+03, 7.904e+02, 1.662e+03, 0.000e+00, 0.000e+00, 1.899e+03, 0.000e+00 }, // CO2(total)
        { 4.229e+01, 2.797e-01, 9.091e+01, 0.000e+00, 0.000e+00, 1.154e-01, 0.000e+00 }, // CO
        { 1.507e-01, 1.382e-02, 1.374e-01, 0.000e+00, 3.256e-06, 3.729e-02, 0.000e+00 }, // HC
        { 4.635e+02, 2.540e+02, 5.342e+02, 0.000e+00, 0.000e+00, 6.104e+02, 0.000e+00 }, // FC
        { 3.642e+01, 1.324e+00, 0.000e+00, 0.000e+00, 8.120e-04, 6.068e+00, 4.811e-03 }, // NOx
        { 2.094e+00, 1.197e-02, 1.314e+00, 1.278e-03, 5.903e-05, 1.805e-02, 1.438e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-IV_SCRs
        { 1.442e+03, 7.904e+02, 1.662e+03, 0.000e+00, 0.000e+00, 1.899e+03, 0.000e+00 }, // CO2(total)
        { 4.229e+01, 2.797e-01, 9.091e+01, 0.000e+00, 0.000e+00, 1.154e-01, 0.000e+00 }, // CO
        { 1.507e-01, 1.382e-02, 1.374e-01, 0.000e+00, 3.256e-06, 3.729e-02, 0.000e+00 }, // HC
        { 4.635e+02, 2.540e+02, 5.342e+02, 0.000e+00, 0.000e+00, 6.104e+02, 0.000e+00 }, // FC
        { 3.386e+01, 7.475e+00, 3.749e+01, 0.000e+00, 4.240e-04, 1.881e+01, 0.000e+00 }, // NOx
        { 2.094e+00, 1.197e-02, 1.314e+00, 1.278e-03, 5.903e-05, 1.805e-02, 1.438e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-V_EGR
        { 1.191e+03, 7.880e+02, 9.422e+02, 0.000e+00, 0.000e+00, 1.919e+03, 0.000e+00 }, // CO2(total)
        { 1.241e+01, 0.000e+00, 2.097e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.034e+00, 1.824e-02, 6.761e-01, 0.000e+00, 2.207e-05, 1.051e-01, 0.000e+00 }, // HC
        { 3.826e+02, 2.533e+02, 3.028e+02, 0.000e+00, 0.000e+00, 6.167e+02, 0.000e+00 }, // FC
        { 4.173e+01, 2.497e+00, 6.709e+01, 0.000e+00, 0.000e+00, 6.007e+00, 0.000e+00 }, // NOx
        { 1.691e+00, 1.010e-02, 1.023e-01, 1.231e-03, 7.803e-05, 6.359e-02, 1.582e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-V_SCR
        { 1.093e+03, 7.772e+02, 6.901e+02, 0.000e+00, 0.000e+00, 1.896e+03, 0.000e+00 }, // CO2(total)
        { 3.992e+01, 1.484e-01, 7.542e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.412e-01, 1.624e-02, 7.376e-02, 2.841e-05, 0.000e+00, 3.788e-02, 0.000e+00 }, // HC
        { 3.512e+02, 2.498e+02, 2.218e+02, 0.000e+00, 0.000e+00, 6.095e+02, 0.000e+00 }, // FC
        { 3.792e+01, 1.271e-01, 0.000e+00, 0.000e+00, 6.423e-04, 1.110e+00, 5.242e-02 }, // NOx
        { 2.126e+00, 9.537e-03, 1.295e+00, 1.284e-03, 5.887e-05, 1.058e-02, 1.442e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-V_SCRs
        { 1.093e+03, 7.772e+02, 6.901e+02, 0.000e+00, 0.000e+00, 1.896e+03, 0.000e+00 }, // CO2(total)
        { 3.992e+01, 1.484e-01, 7.542e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.412e-01, 1.624e-02, 7.376e-02, 2.841e-05, 0.000e+00, 3.788e-02, 0.000e+00 }, // HC
        { 3.512e+02, 2.498e+02, 2.218e+02, 0.000e+00, 0.000e+00, 6.095e+02, 0.000e+00 }, // FC
        { 3.591e+01, 7.653e+00, 2.383e+01, 6.092e-03, 0.000e+00, 1.886e+01, 0.000e+00 }, // NOx
        { 2.126e+00, 9.537e-03, 1.295e+00, 1.284e-03, 5.887e-05, 1.058e-02, 1.442e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-VI_A-C
        { 1.148e+03, 7.651e+02, 1.240e+03, 0.000e+00, 0.000e+00, 1.862e+03, 0.000e+00 }, // CO2(total)
        { 2.909e+00, 2.573e-02, 3.835e+00, 1.932e-04, 0.000e+00, 4.965e-02, 0.000e+00 }, // CO
        { 1.622e-01, 1.123e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.950e-02, 0.000e+00 }, // HC
        { 3.690e+02, 2.459e+02, 3.984e+02, 0.000e+00, 0.000e+00, 5.984e+02, 0.000e+00 }, // FC
        { 5.466e+00, 0.000e+00, 8.501e-01, 0.000e+00, 2.842e-05, 0.000e+00, 1.733e-03 }, // NOx
        { 1.580e+00, 0.000e+00, 2.352e-01, 1.299e-03, 5.832e-05, 0.000e+00, 1.404e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-VIs_A-C
        { 1.148e+03, 7.651e+02, 1.240e+03, 0.000e+00, 0.000e+00, 1.862e+03, 0.000e+00 }, // CO2(total)
        { 2.909e+00, 2.573e-02, 3.835e+00, 1.932e-04, 0.000e+00, 4.965e-02, 0.000e+00 }, // CO
        { 1.622e-01, 1.123e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.950e-02, 0.000e+00 }, // HC
        { 3.690e+02, 2.459e+02, 3.984e+02, 0.000e+00, 0.000e+00, 5.984e+02, 0.000e+00 }, // FC
        { 6.470e+00, 5.705e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.391e+01, 0.000e+00 }, // NOx
        { 1.580e+00, 0.000e+00, 2.352e-01, 1.299e-03, 5.832e-05, 0.000e+00, 1.404e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-VI_D-E
        { 9.487e+02, 7.605e+02, 4.872e+02, 0.000e+00, 0.000e+00, 1.866e+03, 0.000e+00 }, // CO2(total)
        { 1.467e+00, 0.000e+00, 2.016e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.334e-01, 6.370e-04, 1.132e-01, 1.789e-04, 0.000e+00, 1.332e-02, 8.610e-05 }, // HC
        { 3.049e+02, 2.444e+02, 1.566e+02, 0.000e+00, 0.000e+00, 5.996e+02, 0.000e+00 }, // FC
        { 3.331e+00, 6.882e-03, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.985e-03 }, // NOx
        { 1.440e+00, 1.610e-03, 6.017e-03, 1.314e-03, 5.814e-05, 4.996e-03, 1.344e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_Euro-VIs_D-E
        { 9.487e+02, 7.605e+02, 4.872e+02, 0.000e+00, 0.000e+00, 1.866e+03, 0.000e+00 }, // CO2(total)
        { 1.467e+00, 0.000e+00, 2.016e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.334e-01, 6.370e-04, 1.132e-01, 1.789e-04, 0.000e+00, 1.332e-02, 8.610e-05 }, // HC
        { 3.049e+02, 2.444e+02, 1.566e+02, 0.000e+00, 0.000e+00, 5.996e+02, 0.000e+00 }, // FC
        { 2.041e+01, 6.416e+00, 3.870e+01, 0.000e+00, 0.000e+00, 1.448e+01, 0.000e+00 }, // NOx
        { 1.440e+00, 1.610e-03, 6.017e-03, 1.314e-03, 5.814e-05, 4.996e-03, 1.344e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_50ties
        { 2.745e+03, 9.152e+02, 7.265e+02, 2.312e+00, 0.000e+00, 2.473e+03, 0.000e+00 }, // CO2(total)
        { 3.344e+01, 0.000e+00, 1.696e+01, 1.885e-02, 1.109e-04, 1.931e+00, 0.000e+00 }, // CO
        { 1.049e+01, 0.000e+00, 4.130e+00, 0.000e+00, 1.513e-04, 1.731e-01, 0.000e+00 }, // HC
        { 8.820e+02, 2.941e+02, 2.335e+02, 7.430e-01, 0.000e+00, 7.949e+02, 0.000e+00 }, // FC
        { 3.197e+01, 1.489e+01, 1.074e+01, 1.436e-02, 0.000e+00, 3.794e+01, 0.000e+00 }, // NOx
        { 7.356e+00, 1.060e-01, 1.441e+00, 6.315e-03, 6.024e-05, 6.103e-01, 1.679e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_60ties
        { 2.745e+03, 9.152e+02, 7.265e+02, 2.312e+00, 0.000e+00, 2.473e+03, 0.000e+00 }, // CO2(total)
        { 3.344e+01, 0.000e+00, 1.696e+01, 1.885e-02, 1.109e-04, 1.931e+00, 0.000e+00 }, // CO
        { 1.049e+01, 0.000e+00, 4.130e+00, 0.000e+00, 1.513e-04, 1.731e-01, 0.000e+00 }, // HC
        { 8.820e+02, 2.941e+02, 2.335e+02, 7.430e-01, 0.000e+00, 7.949e+02, 0.000e+00 }, // FC
        { 3.197e+01, 1.489e+01, 1.074e+01, 1.436e-02, 0.000e+00, 3.794e+01, 0.000e+00 }, // NOx
        { 7.356e+00, 1.060e-01, 1.441e+00, 6.315e-03, 6.024e-05, 6.103e-01, 1.679e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_70ties
        { 2.745e+03, 9.152e+02, 7.265e+02, 2.312e+00, 0.000e+00, 2.473e+03, 0.000e+00 }, // CO2(total)
        { 3.344e+01, 0.000e+00, 1.696e+01, 1.885e-02, 1.109e-04, 1.931e+00, 0.000e+00 }, // CO
        { 1.049e+01, 0.000e+00, 4.130e+00, 0.000e+00, 1.513e-04, 1.731e-01, 0.000e+00 }, // HC
        { 8.820e+02, 2.941e+02, 2.335e+02, 7.430e-01, 0.000e+00, 7.949e+02, 0.000e+00 }, // FC
        { 3.197e+01, 1.489e+01, 1.074e+01, 1.436e-02, 0.000e+00, 3.794e+01, 0.000e+00 }, // NOx
        { 7.356e+00, 1.060e-01, 1.441e+00, 6.315e-03, 6.024e-05, 6.103e-01, 1.679e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_80ties
        { 2.745e+03, 9.152e+02, 7.265e+02, 2.312e+00, 0.000e+00, 2.473e+03, 0.000e+00 }, // CO2(total)
        { 3.344e+01, 0.000e+00, 1.696e+01, 1.885e-02, 1.109e-04, 1.931e+00, 0.000e+00 }, // CO
        { 1.049e+01, 0.000e+00, 4.130e+00, 0.000e+00, 1.513e-04, 1.731e-01, 0.000e+00 }, // HC
        { 8.820e+02, 2.941e+02, 2.335e+02, 7.430e-01, 0.000e+00, 7.949e+02, 0.000e+00 }, // FC
        { 3.197e+01, 1.489e+01, 1.074e+01, 1.436e-02, 0.000e+00, 3.794e+01, 0.000e+00 }, // NOx
        { 7.356e+00, 1.060e-01, 1.441e+00, 6.315e-03, 6.024e-05, 6.103e-01, 1.679e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-I
        { 2.364e+03, 9.444e+02, 1.565e+03, 0.000e+00, 0.000e+00, 2.342e+03, 0.000e+00 }, // CO2(total)
        { 1.349e+01, 1.430e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.667e+00, 0.000e+00 }, // CO
        { 9.425e+00, 0.000e+00, 3.139e+00, 0.000e+00, 1.886e-04, 5.010e-01, 0.000e+00 }, // HC
        { 7.596e+02, 3.035e+02, 5.028e+02, 0.000e+00, 0.000e+00, 7.527e+02, 0.000e+00 }, // FC
        { 3.587e+01, 9.661e+00, 3.561e+01, 0.000e+00, 0.000e+00, 2.387e+01, 0.000e+00 }, // NOx
        { 6.366e+00, 4.705e-02, 0.000e+00, 6.532e-03, 6.136e-05, 5.984e-01, 1.857e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-II
        { 3.270e+03, 8.458e+02, 4.633e+03, 0.000e+00, 0.000e+00, 2.056e+03, 0.000e+00 }, // CO2(total)
        { 1.493e+01, 7.331e-01, 1.256e+01, 0.000e+00, 0.000e+00, 1.853e+00, 0.000e+00 }, // CO
        { 5.907e+00, 0.000e+00, 2.551e+00, 0.000e+00, 1.100e-04, 1.349e-01, 5.672e-03 }, // HC
        { 1.051e+03, 2.718e+02, 1.489e+03, 0.000e+00, 0.000e+00, 6.606e+02, 0.000e+00 }, // FC
        { 5.589e+01, 8.486e+00, 8.073e+01, 0.000e+00, 0.000e+00, 2.062e+01, 0.000e+00 }, // NOx
        { 2.928e+00, 1.082e-01, 9.837e-01, 1.285e-03, 5.952e-05, 2.505e-01, 1.910e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-III
        { 3.740e+03, 8.207e+02, 5.633e+03, 0.000e+00, 0.000e+00, 2.010e+03, 0.000e+00 }, // CO2(total)
        { 2.064e+01, 6.567e-01, 6.502e+00, 0.000e+00, 0.000e+00, 1.928e+00, 0.000e+00 }, // CO
        { 5.476e+00, 0.000e+00, 2.823e+00, 0.000e+00, 7.622e-05, 0.000e+00, 8.235e-03 }, // HC
        { 1.202e+03, 2.638e+02, 1.810e+03, 0.000e+00, 0.000e+00, 6.458e+02, 0.000e+00 }, // FC
        { 4.924e+01, 6.296e+00, 7.296e+01, 0.000e+00, 0.000e+00, 1.561e+01, 0.000e+00 }, // NOx
        { 3.661e+00, 6.254e-02, 0.000e+00, 1.259e-03, 5.999e-05, 1.799e-01, 1.671e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-IV_EGR
        { 3.103e+03, 8.516e+02, 5.988e+03, 0.000e+00, 0.000e+00, 2.046e+03, 0.000e+00 }, // CO2(total)
        { 1.110e+01, 5.301e-01, 1.615e+01, 0.000e+00, 0.000e+00, 1.340e+00, 0.000e+00 }, // CO
        { 4.001e-01, 4.771e-02, 6.505e-01, 0.000e+00, 0.000e+00, 1.033e-01, 0.000e+00 }, // HC
        { 9.971e+02, 2.737e+02, 1.924e+03, 0.000e+00, 0.000e+00, 6.575e+02, 0.000e+00 }, // FC
        { 4.812e+01, 5.013e+00, 8.578e+01, 0.000e+00, 0.000e+00, 1.270e+01, 0.000e+00 }, // NOx
        { 1.994e+00, 2.026e-02, 7.803e-01, 1.216e-03, 6.145e-05, 4.875e-02, 1.645e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-IV_SCR
        { 2.801e+03, 8.595e+02, 5.087e+03, 0.000e+00, 0.000e+00, 2.077e+03, 0.000e+00 }, // CO2(total)
        { 3.977e+01, 5.302e-01, 8.061e+01, 0.000e+00, 0.000e+00, 9.955e-01, 0.000e+00 }, // CO
        { 1.870e-01, 1.559e-02, 1.719e-01, 0.000e+00, 4.867e-06, 4.472e-02, 0.000e+00 }, // HC
        { 9.003e+02, 2.762e+02, 1.635e+03, 0.000e+00, 0.000e+00, 6.675e+02, 0.000e+00 }, // FC
        { 4.320e+01, 1.542e+00, 0.000e+00, 0.000e+00, 8.044e-04, 7.363e+00, 0.000e+00 }, // NOx
        { 2.122e+00, 1.487e-02, 1.261e+00, 1.211e-03, 6.137e-05, 2.999e-02, 1.454e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-IV_SCRs
        { 2.801e+03, 8.595e+02, 5.087e+03, 0.000e+00, 0.000e+00, 2.077e+03, 0.000e+00 }, // CO2(total)
        { 3.977e+01, 5.302e-01, 8.061e+01, 0.000e+00, 0.000e+00, 9.955e-01, 0.000e+00 }, // CO
        { 1.870e-01, 1.559e-02, 1.719e-01, 0.000e+00, 4.867e-06, 4.472e-02, 0.000e+00 }, // HC
        { 9.003e+02, 2.762e+02, 1.635e+03, 0.000e+00, 0.000e+00, 6.675e+02, 0.000e+00 }, // FC
        { 4.548e+01, 8.602e+00, 7.622e+01, 0.000e+00, 0.000e+00, 2.053e+01, 0.000e+00 }, // NOx
        { 2.122e+00, 1.487e-02, 1.261e+00, 1.211e-03, 6.137e-05, 2.999e-02, 1.454e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-V_EGR
        { 2.546e+03, 8.598e+02, 4.360e+03, 0.000e+00, 0.000e+00, 2.108e+03, 0.000e+00 }, // CO2(total)
        { 1.267e+01, 5.863e-03, 2.027e+01, 0.000e+00, 0.000e+00, 6.330e-02, 0.000e+00 }, // CO
        { 1.222e+00, 1.919e-02, 8.766e-01, 0.000e+00, 2.230e-05, 1.164e-01, 0.000e+00 }, // HC
        { 8.182e+02, 2.763e+02, 1.401e+03, 0.000e+00, 0.000e+00, 6.775e+02, 0.000e+00 }, // FC
        { 4.625e+01, 2.809e+00, 7.316e+01, 0.000e+00, 0.000e+00, 6.973e+00, 0.000e+00 }, // NOx
        { 1.877e+00, 4.091e-04, 2.484e-01, 1.239e-03, 8.984e-05, 6.533e-02, 3.325e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-V_SCR
        { 2.310e+03, 8.562e+02, 3.688e+03, 0.000e+00, 0.000e+00, 2.111e+03, 0.000e+00 }, // CO2(total)
        { 3.737e+01, 3.982e-01, 6.749e+01, 0.000e+00, 0.000e+00, 5.610e-01, 0.000e+00 }, // CO
        { 1.672e-01, 2.000e-02, 6.936e-02, 0.000e+00, 6.815e-07, 4.801e-02, 0.000e+00 }, // HC
        { 7.424e+02, 2.752e+02, 1.185e+03, 0.000e+00, 0.000e+00, 6.784e+02, 0.000e+00 }, // FC
        { 4.254e+01, 3.536e-01, 0.000e+00, 0.000e+00, 3.969e-04, 2.027e+00, 3.453e-02 }, // NOx
        { 2.152e+00, 1.217e-02, 1.201e+00, 1.306e-03, 5.787e-05, 2.240e-02, 1.222e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-V_SCRs
        { 2.310e+03, 8.562e+02, 3.688e+03, 0.000e+00, 0.000e+00, 2.111e+03, 0.000e+00 }, // CO2(total)
        { 3.737e+01, 3.982e-01, 6.749e+01, 0.000e+00, 0.000e+00, 5.610e-01, 0.000e+00 }, // CO
        { 1.672e-01, 2.000e-02, 6.936e-02, 0.000e+00, 6.815e-07, 4.801e-02, 0.000e+00 }, // HC
        { 7.424e+02, 2.752e+02, 1.185e+03, 0.000e+00, 0.000e+00, 6.784e+02, 0.000e+00 }, // FC
        { 5.091e+01, 8.595e+00, 5.840e+01, 0.000e+00, 0.000e+00, 2.089e+01, 0.000e+00 }, // NOx
        { 2.152e+00, 1.217e-02, 1.201e+00, 1.306e-03, 5.787e-05, 2.240e-02, 1.222e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-VI_A-C
        { 2.381e+03, 8.391e+02, 4.333e+03, 0.000e+00, 0.000e+00, 2.056e+03, 0.000e+00 }, // CO2(total)
        { 2.522e+00, 7.333e-02, 2.882e+00, 0.000e+00, 0.000e+00, 1.375e-01, 0.000e+00 }, // CO
        { 1.629e-01, 1.482e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.725e-02, 0.000e+00 }, // HC
        { 7.651e+02, 2.697e+02, 1.393e+03, 0.000e+00, 0.000e+00, 6.608e+02, 0.000e+00 }, // FC
        { 6.218e+00, 0.000e+00, 2.816e-01, 0.000e+00, 4.322e-05, 0.000e+00, 4.579e-03 }, // NOx
        { 1.600e+00, 0.000e+00, 2.103e-01, 1.263e-03, 5.969e-05, 2.943e-03, 1.298e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-VIs_A-C
        { 2.381e+03, 8.391e+02, 4.333e+03, 0.000e+00, 0.000e+00, 2.056e+03, 0.000e+00 }, // CO2(total)
        { 2.522e+00, 7.333e-02, 2.882e+00, 0.000e+00, 0.000e+00, 1.375e-01, 0.000e+00 }, // CO
        { 1.629e-01, 1.482e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.725e-02, 0.000e+00 }, // HC
        { 7.651e+02, 2.697e+02, 1.393e+03, 0.000e+00, 0.000e+00, 6.608e+02, 0.000e+00 }, // FC
        { 1.823e+01, 6.136e+00, 2.843e+01, 0.000e+00, 0.000e+00, 1.501e+01, 0.000e+00 }, // NOx
        { 1.600e+00, 0.000e+00, 2.103e-01, 1.263e-03, 5.969e-05, 2.943e-03, 1.298e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-VI_D-E
        { 2.116e+03, 8.393e+02, 3.315e+03, 0.000e+00, 0.000e+00, 2.077e+03, 0.000e+00 }, // CO2(total)
        { 1.187e+00, 0.000e+00, 1.541e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.823e-01, 2.056e-03, 8.773e-02, 1.456e-04, 0.000e+00, 1.976e-02, 0.000e+00 }, // HC
        { 6.800e+02, 2.697e+02, 1.066e+03, 0.000e+00, 0.000e+00, 6.675e+02, 0.000e+00 }, // FC
        { 3.660e+00, 8.431e-03, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.126e-03 }, // NOx
        { 1.446e+00, 2.309e-03, 8.832e-03, 1.264e-03, 5.946e-05, 6.071e-03, 1.299e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_Euro-VIs_D-E
        { 2.116e+03, 8.393e+02, 3.315e+03, 0.000e+00, 0.000e+00, 2.077e+03, 0.000e+00 }, // CO2(total)
        { 1.187e+00, 0.000e+00, 1.541e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.823e-01, 2.056e-03, 8.773e-02, 1.456e-04, 0.000e+00, 1.976e-02, 0.000e+00 }, // HC
        { 6.800e+02, 2.697e+02, 1.066e+03, 0.000e+00, 0.000e+00, 6.675e+02, 0.000e+00 }, // FC
        { 4.154e+01, 6.321e+00, 8.539e+01, 0.000e+00, 0.000e+00, 1.423e+01, 0.000e+00 }, // NOx
        { 1.446e+00, 2.309e-03, 8.832e-03, 1.264e-03, 5.946e-05, 6.071e-03, 1.299e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_50ties
        { 2.647e+03, 3.239e+02, 0.000e+00, 0.000e+00, 2.521e-01, 1.166e+03, 0.000e+00 }, // CO2(total)
        { 3.183e+01, 0.000e+00, 0.000e+00, 1.920e-02, 1.819e-03, 3.550e+00, 6.574e-02 }, // CO
        { 1.508e+01, 0.000e+00, 6.738e+00, 0.000e+00, 2.245e-04, 0.000e+00, 2.749e-03 }, // HC
        { 8.507e+02, 1.041e+02, 0.000e+00, 0.000e+00, 8.102e-02, 3.747e+02, 0.000e+00 }, // FC
        { 3.911e+01, 3.530e+00, 0.000e+00, 0.000e+00, 3.513e-03, 1.418e+01, 1.011e-03 }, // NOx
        { 6.367e+00, 0.000e+00, 0.000e+00, 6.795e-03, 2.019e-04, 6.499e-01, 2.619e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_60ties
        { 2.647e+03, 3.239e+02, 0.000e+00, 0.000e+00, 2.521e-01, 1.166e+03, 0.000e+00 }, // CO2(total)
        { 3.183e+01, 0.000e+00, 0.000e+00, 1.920e-02, 1.819e-03, 3.550e+00, 6.574e-02 }, // CO
        { 1.508e+01, 0.000e+00, 6.738e+00, 0.000e+00, 2.245e-04, 0.000e+00, 2.749e-03 }, // HC
        { 8.507e+02, 1.041e+02, 0.000e+00, 0.000e+00, 8.102e-02, 3.747e+02, 0.000e+00 }, // FC
        { 3.911e+01, 3.530e+00, 0.000e+00, 0.000e+00, 3.513e-03, 1.418e+01, 1.011e-03 }, // NOx
        { 6.367e+00, 0.000e+00, 0.000e+00, 6.795e-03, 2.019e-04, 6.499e-01, 2.619e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_70ties
        { 2.647e+03, 3.239e+02, 0.000e+00, 0.000e+00, 2.521e-01, 1.166e+03, 0.000e+00 }, // CO2(total)
        { 3.183e+01, 0.000e+00, 0.000e+00, 1.920e-02, 1.819e-03, 3.550e+00, 6.574e-02 }, // CO
        { 1.508e+01, 0.000e+00, 6.738e+00, 0.000e+00, 2.245e-04, 0.000e+00, 2.749e-03 }, // HC
        { 8.507e+02, 1.041e+02, 0.000e+00, 0.000e+00, 8.102e-02, 3.747e+02, 0.000e+00 }, // FC
        { 3.911e+01, 3.530e+00, 0.000e+00, 0.000e+00, 3.513e-03, 1.418e+01, 1.011e-03 }, // NOx
        { 6.367e+00, 0.000e+00, 0.000e+00, 6.795e-03, 2.019e-04, 6.499e-01, 2.619e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_80ties
        { 2.647e+03, 3.239e+02, 0.000e+00, 0.000e+00, 2.521e-01, 1.166e+03, 0.000e+00 }, // CO2(total)
        { 3.183e+01, 0.000e+00, 0.000e+00, 1.920e-02, 1.819e-03, 3.550e+00, 6.574e-02 }, // CO
        { 1.508e+01, 0.000e+00, 6.738e+00, 0.000e+00, 2.245e-04, 0.000e+00, 2.749e-03 }, // HC
        { 8.507e+02, 1.041e+02, 0.000e+00, 0.000e+00, 8.102e-02, 3.747e+02, 0.000e+00 }, // FC
        { 3.911e+01, 3.530e+00, 0.000e+00, 0.000e+00, 3.513e-03, 1.418e+01, 1.011e-03 }, // NOx
        { 6.367e+00, 0.000e+00, 0.000e+00, 6.795e-03, 2.019e-04, 6.499e-01, 2.619e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-I
        { 2.586e+03, 3.146e+02, 0.000e+00, 0.000e+00, 2.287e-01, 1.121e+03, 0.000e+00 }, // CO2(total)
        { 1.492e+01, 0.000e+00, 7.425e+00, 4.522e-03, 3.162e-04, 1.172e+00, 0.000e+00 }, // CO
        { 3.137e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.355e-04, 2.310e-01, 1.201e-03 }, // HC
        { 8.310e+02, 1.011e+02, 0.000e+00, 0.000e+00, 7.349e-02, 3.602e+02, 0.000e+00 }, // FC
        { 2.251e+01, 3.452e+00, 5.626e+00, 0.000e+00, 1.734e-03, 1.055e+01, 0.000e+00 }, // NOx
        { 3.911e+00, 0.000e+00, 0.000e+00, 1.162e-03, 1.791e-04, 2.329e-01, 1.223e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-II
        { 2.359e+03, 3.230e+02, 6.397e+02, 0.000e+00, 1.745e-01, 1.035e+03, 0.000e+00 }, // CO2(total)
        { 1.377e+01, 0.000e+00, 1.862e+01, 0.000e+00, 2.990e-05, 8.627e-02, 0.000e+00 }, // CO
        { 2.035e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.808e-05, 1.554e-01, 4.504e-04 }, // HC
        { 7.581e+02, 1.038e+02, 2.056e+02, 0.000e+00, 5.610e-02, 3.326e+02, 0.000e+00 }, // FC
        { 2.543e+01, 3.216e+00, 6.583e+00, 0.000e+00, 1.717e-03, 1.016e+01, 0.000e+00 }, // NOx
        { 2.916e+00, 0.000e+00, 1.251e+00, 1.034e-03, 9.606e-05, 6.645e-02, 2.218e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-III
        { 1.794e+03, 4.063e+02, 9.018e+02, 0.000e+00, 1.078e-01, 1.081e+03, 0.000e+00 }, // CO2(total)
        { 1.253e+01, 0.000e+00, 7.256e+00, 0.000e+00, 8.845e-05, 0.000e+00, 1.016e-02 }, // CO
        { 1.839e+00, 6.853e-03, 2.832e-01, 0.000e+00, 4.455e-05, 1.184e-01, 0.000e+00 }, // HC
        { 5.767e+02, 1.306e+02, 2.898e+02, 0.000e+00, 3.464e-02, 3.474e+02, 0.000e+00 }, // FC
        { 1.742e+01, 2.706e+00, 6.072e+00, 2.965e-02, 0.000e+00, 7.899e+00, 0.000e+00 }, // NOx
        { 2.506e+00, 1.520e-02, 3.959e-01, 1.102e-03, 7.806e-05, 6.433e-02, 3.070e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-IV_EGR
        { 6.999e+02, 4.745e+02, 1.293e+03, 0.000e+00, 6.566e-02, 1.076e+03, 0.000e+00 }, // CO2(total)
        { 5.707e+00, 0.000e+00, 6.260e+00, 2.276e-03, 2.221e-04, 0.000e+00, 1.976e-02 }, // CO
        { 2.892e-01, 0.000e+00, 3.544e-01, 2.001e-04, 1.631e-05, 0.000e+00, 1.222e-03 }, // HC
        { 2.249e+02, 1.525e+02, 4.156e+02, 0.000e+00, 2.110e-02, 3.457e+02, 0.000e+00 }, // FC
        { 1.757e+01, 2.151e+00, 3.049e+01, 6.418e-03, 0.000e+00, 4.217e+00, 1.603e-02 }, // NOx
        { 1.701e+00, 0.000e+00, 2.932e-01, 1.107e-03, 7.598e-05, 0.000e+00, 7.783e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-IV_SCR
        { 7.832e+02, 4.636e+02, 1.781e+03, 0.000e+00, 5.647e-02, 1.024e+03, 0.000e+00 }, // CO2(total)
        { 1.652e+01, 0.000e+00, 2.138e+01, 0.000e+00, 4.924e-05, 0.000e+00, 4.764e-03 }, // CO
        { 7.128e-02, 7.203e-03, 1.182e-01, 0.000e+00, 3.080e-06, 1.673e-02, 0.000e+00 }, // HC
        { 2.517e+02, 1.490e+02, 5.723e+02, 0.000e+00, 1.815e-02, 3.292e+02, 0.000e+00 }, // FC
        { 1.512e+01, 8.614e-01, 0.000e+00, 0.000e+00, 7.326e-04, 2.915e+00, 1.117e-02 }, // NOx
        { 1.722e+00, 0.000e+00, 3.865e-01, 1.203e-03, 7.102e-05, 0.000e+00, 6.295e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-IV_SCRs
        { 7.832e+02, 4.636e+02, 1.781e+03, 0.000e+00, 5.647e-02, 1.024e+03, 0.000e+00 }, // CO2(total)
        { 1.652e+01, 0.000e+00, 2.138e+01, 0.000e+00, 4.924e-05, 0.000e+00, 4.764e-03 }, // CO
        { 7.128e-02, 7.203e-03, 1.182e-01, 0.000e+00, 3.080e-06, 1.673e-02, 0.000e+00 }, // HC
        { 2.517e+02, 1.490e+02, 5.723e+02, 0.000e+00, 1.815e-02, 3.292e+02, 0.000e+00 }, // FC
        { 1.751e+01, 3.759e+00, 1.381e+01, 0.000e+00, 1.173e-03, 9.881e+00, 0.000e+00 }, // NOx
        { 1.722e+00, 0.000e+00, 3.865e-01, 1.203e-03, 7.102e-05, 0.000e+00, 6.295e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-V_EGR
        { 6.105e+02, 4.723e+02, 1.877e+03, 0.000e+00, 3.410e-02, 1.004e+03, 0.000e+00 }, // CO2(total)
        { 4.155e+00, 0.000e+00, 4.366e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.567e-04 }, // CO
        { 4.500e-01, 6.152e-03, 4.894e-01, 0.000e+00, 2.118e-05, 1.131e-02, 1.251e-03 }, // HC
        { 1.962e+02, 1.518e+02, 6.033e+02, 0.000e+00, 1.096e-02, 3.227e+02, 0.000e+00 }, // FC
        { 2.134e+01, 4.592e-01, 3.665e+01, 3.408e-02, 0.000e+00, 0.000e+00, 1.019e-01 }, // NOx
        { 1.564e+00, 2.971e-03, 0.000e+00, 1.169e-03, 8.228e-05, 3.641e-02, 3.017e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-V_SCR
        { 7.002e+02, 4.538e+02, 2.112e+03, 0.000e+00, 3.387e-02, 9.614e+02, 0.000e+00 }, // CO2(total)
        { 1.495e+01, 0.000e+00, 1.470e+01, 4.125e-03, 1.026e-04, 0.000e+00, 2.188e-02 }, // CO
        { 6.714e-02, 8.335e-03, 1.017e-01, 0.000e+00, 9.358e-07, 1.554e-02, 0.000e+00 }, // HC
        { 2.250e+02, 1.458e+02, 6.787e+02, 0.000e+00, 1.088e-02, 3.090e+02, 0.000e+00 }, // FC
        { 1.269e+01, 5.018e-01, 0.000e+00, 0.000e+00, 1.499e-04, 7.477e-01, 2.283e-02 }, // NOx
        { 1.706e+00, 0.000e+00, 3.116e-01, 1.451e-03, 6.435e-05, 0.000e+00, 8.206e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-V_SCRs
        { 7.002e+02, 4.538e+02, 2.112e+03, 0.000e+00, 3.387e-02, 9.614e+02, 0.000e+00 }, // CO2(total)
        { 1.495e+01, 0.000e+00, 1.470e+01, 4.125e-03, 1.026e-04, 0.000e+00, 2.188e-02 }, // CO
        { 6.714e-02, 8.335e-03, 1.017e-01, 0.000e+00, 9.358e-07, 1.554e-02, 0.000e+00 }, // HC
        { 2.250e+02, 1.458e+02, 6.787e+02, 0.000e+00, 1.088e-02, 3.090e+02, 0.000e+00 }, // FC
        { 1.863e+01, 3.868e+00, 1.550e+01, 0.000e+00, 8.310e-04, 9.488e+00, 0.000e+00 }, // NOx
        { 1.706e+00, 0.000e+00, 3.116e-01, 1.451e-03, 6.435e-05, 0.000e+00, 8.206e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-VI_A-C
        { 4.728e+02, 4.655e+02, 2.096e+03, 0.000e+00, 2.268e-02, 9.605e+02, 0.000e+00 }, // CO2(total)
        { 1.223e+00, 7.185e-04, 1.495e+00, 0.000e+00, 2.131e-05, 1.719e-02, 0.000e+00 }, // CO
        { 7.564e-02, 6.104e-03, 1.142e-01, 0.000e+00, 0.000e+00, 1.092e-02, 0.000e+00 }, // HC
        { 1.520e+02, 1.496e+02, 6.735e+02, 0.000e+00, 7.290e-03, 3.087e+02, 0.000e+00 }, // FC
        { 2.587e+00, 0.000e+00, 2.699e-01, 0.000e+00, 3.503e-05, 0.000e+00, 5.132e-04 }, // NOx
        { 1.480e+00, 0.000e+00, 5.979e-02, 1.109e-03, 6.904e-05, 9.590e-04, 3.019e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-VIs_A-C
        { 4.728e+02, 4.655e+02, 2.096e+03, 0.000e+00, 2.268e-02, 9.605e+02, 0.000e+00 }, // CO2(total)
        { 1.223e+00, 7.185e-04, 1.495e+00, 0.000e+00, 2.131e-05, 1.719e-02, 0.000e+00 }, // CO
        { 7.564e-02, 6.104e-03, 1.142e-01, 0.000e+00, 0.000e+00, 1.092e-02, 0.000e+00 }, // HC
        { 1.520e+02, 1.496e+02, 6.735e+02, 0.000e+00, 7.290e-03, 3.087e+02, 0.000e+00 }, // FC
        { 3.749e+00, 2.804e+00, 0.000e+00, 2.165e-02, 0.000e+00, 7.252e+00, 0.000e+00 }, // NOx
        { 1.480e+00, 0.000e+00, 5.979e-02, 1.109e-03, 6.904e-05, 9.590e-04, 3.019e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-VI_D-E
        { 2.860e+02, 4.783e+02, 1.445e+03, 0.000e+00, 1.821e-02, 9.964e+02, 0.000e+00 }, // CO2(total)
        { 3.217e-01, 0.000e+00, 2.175e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.631e-01, 0.000e+00, 3.570e-02, 1.561e-04, 5.217e-07, 4.183e-03, 2.428e-04 }, // HC
        { 9.191e+01, 1.537e+02, 4.645e+02, 0.000e+00, 5.854e-03, 3.202e+02, 0.000e+00 }, // FC
        { 8.011e-01, 0.000e+00, 4.832e-01, 0.000e+00, 2.371e-05, 0.000e+00, 1.488e-03 }, // NOx
        { 1.433e+00, 1.229e-03, 3.485e-03, 1.099e-03, 6.869e-05, 2.830e-03, 3.045e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_Euro-VIs_D-E
        { 2.860e+02, 4.783e+02, 1.445e+03, 0.000e+00, 1.821e-02, 9.964e+02, 0.000e+00 }, // CO2(total)
        { 3.217e-01, 0.000e+00, 2.175e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.631e-01, 0.000e+00, 3.570e-02, 1.561e-04, 5.217e-07, 4.183e-03, 2.428e-04 }, // HC
        { 9.191e+01, 1.537e+02, 4.645e+02, 0.000e+00, 5.854e-03, 3.202e+02, 0.000e+00 }, // FC
        { 3.116e+01, 0.000e+00, 5.667e+01, 1.076e-01, 0.000e+00, 0.000e+00, 2.142e-01 }, // NOx
        { 1.433e+00, 1.229e-03, 3.485e-03, 1.099e-03, 6.869e-05, 2.830e-03, 3.045e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_CNG_Euro-I
        { 3.680e+03, 6.842e+02, 0.000e+00, 7.962e+00, 0.000e+00, 2.353e+03, 0.000e+00 }, // CO2(total)
        { 1.454e+01, 1.070e+00, 0.000e+00, 5.649e-03, 0.000e+00, 3.198e+00, 6.710e-03 }, // CO
        { 9.782e+00, 0.000e+00, 3.979e+00, 0.000e+00, 1.356e-04, 3.698e-01, 2.048e-03 }, // HC
        { 1.184e+03, 2.202e+02, 0.000e+00, 2.562e+00, 0.000e+00, 7.571e+02, 0.000e+00 }, // FC
        { 3.451e+01, 7.493e+00, 0.000e+00, 4.652e-02, 0.000e+00, 2.257e+01, 0.000e+00 }, // NOx
        { 6.929e+00, 0.000e+00, 0.000e+00, 6.817e-03, 6.626e-05, 4.421e-01, 5.480e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_CNG_Euro-II
        { 2.433e+03, 8.611e+02, 7.300e+02, 6.718e-01, 0.000e+00, 2.186e+03, 0.000e+00 }, // CO2(total)
        { 1.335e+01, 6.684e-01, 1.061e+01, 0.000e+00, 0.000e+00, 1.673e+00, 0.000e+00 }, // CO
        { 5.885e+00, 0.000e+00, 3.246e+00, 0.000e+00, 7.543e-05, 5.248e-02, 5.760e-03 }, // HC
        { 7.828e+02, 2.771e+02, 2.349e+02, 2.162e-01, 0.000e+00, 7.035e+02, 0.000e+00 }, // FC
        { 3.822e+01, 8.016e+00, 3.779e+01, 2.836e-03, 0.000e+00, 1.952e+01, 0.000e+00 }, // NOx
        { 2.870e+00, 9.244e-02, 1.125e+00, 1.232e-03, 6.109e-05, 2.078e-01, 1.748e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_CNG_Euro-III
        { 3.386e+03, 7.834e+02, 2.052e+02, 0.000e+00, 1.019e-01, 2.248e+03, 0.000e+00 }, // CO2(total)
        { 2.098e+01, 4.371e-01, 6.697e+00, 0.000e+00, 0.000e+00, 1.438e+00, 0.000e+00 }, // CO
        { 5.354e+00, 0.000e+00, 2.894e+00, 0.000e+00, 5.021e-05, 0.000e+00, 6.063e-03 }, // HC
        { 1.090e+03, 2.521e+02, 6.604e+01, 0.000e+00, 3.280e-02, 7.234e+02, 0.000e+00 }, // FC
        { 2.612e+01, 6.445e+00, 2.163e+01, 0.000e+00, 0.000e+00, 1.542e+01, 0.000e+00 }, // NOx
        { 4.089e+00, 0.000e+00, 2.223e-02, 1.357e-03, 9.920e-05, 1.344e-01, 8.658e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_CNG_Euro-IV
        { 1.797e+03, 9.034e+02, 2.303e+03, 0.000e+00, 0.000e+00, 2.168e+03, 0.000e+00 }, // CO2(total)
        { 6.205e+00, 0.000e+00, 1.049e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.069e+00, 3.648e-02, 1.352e+00, 0.000e+00, 4.413e-05, 2.102e-01, 0.000e+00 }, // HC
        { 5.781e+02, 2.907e+02, 7.411e+02, 0.000e+00, 0.000e+00, 6.977e+02, 0.000e+00 }, // FC
        { 2.504e+01, 1.498e+00, 4.025e+01, 0.000e+00, 0.000e+00, 3.604e+00, 0.000e+00 }, // NOx
        { 1.931e+00, 1.914e-02, 7.549e-01, 1.234e-03, 6.090e-05, 4.088e-02, 1.677e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_CNG_Euro-V
        { 1.191e+03, 8.467e+02, 7.518e+02, 0.000e+00, 0.000e+00, 2.066e+03, 0.000e+00 }, // CO2(total)
        { 8.845e-01, 6.290e-01, 5.585e-01, 0.000e+00, 0.000e+00, 1.535e+00, 0.000e+00 }, // CO
        { 4.173e-01, 2.968e-01, 2.635e-01, 0.000e+00, 0.000e+00, 7.242e-01, 0.000e+00 }, // HC
        { 3.831e+02, 2.724e+02, 2.419e+02, 0.000e+00, 0.000e+00, 6.648e+02, 0.000e+00 }, // FC
        { 1.608e+00, 1.144e+00, 1.016e+00, 0.000e+00, 0.000e+00, 2.791e+00, 0.000e+00 }, // NOx
        { 1.428e+00, 4.908e-03, 4.358e-03, 1.284e-03, 5.887e-05, 1.198e-02, 1.442e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_CNG_Euro-VI
        { 1.251e+03, 8.336e+02, 1.351e+03, 0.000e+00, 0.000e+00, 2.028e+03, 0.000e+00 }, // CO2(total)
        { 8.101e-01, 5.399e-01, 8.747e-01, 0.000e+00, 0.000e+00, 1.314e+00, 0.000e+00 }, // CO
        { 2.147e-01, 1.430e-01, 2.318e-01, 0.000e+00, 0.000e+00, 3.481e-01, 0.000e+00 }, // HC
        { 4.025e+02, 2.682e+02, 4.346e+02, 0.000e+00, 0.000e+00, 6.527e+02, 0.000e+00 }, // FC
        { 5.378e-01, 3.584e-01, 5.807e-01, 0.000e+00, 0.000e+00, 8.721e-01, 0.000e+00 }, // NOx
        { 1.427e+00, 4.832e-03, 7.829e-03, 1.299e-03, 5.832e-05, 1.176e-02, 1.404e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_CNG_Euro-I
        { 2.697e+03, 1.078e+03, 1.785e+03, 0.000e+00, 0.000e+00, 2.673e+03, 0.000e+00 }, // CO2(total)
        { 1.405e+01, 1.490e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.822e+00, 0.000e+00 }, // CO
        { 1.057e+01, 0.000e+00, 3.521e+00, 0.000e+00, 2.116e-04, 5.620e-01, 0.000e+00 }, // HC
        { 8.678e+02, 3.467e+02, 5.745e+02, 0.000e+00, 0.000e+00, 8.600e+02, 0.000e+00 }, // FC
        { 3.732e+01, 1.005e+01, 3.706e+01, 0.000e+00, 0.000e+00, 2.483e+01, 0.000e+00 }, // NOx
        { 7.074e+00, 5.379e-02, 0.000e+00, 7.291e-03, 6.136e-05, 6.840e-01, 1.857e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_CNG_Euro-II
        { 3.731e+03, 9.652e+02, 5.287e+03, 0.000e+00, 0.000e+00, 2.346e+03, 0.000e+00 }, // CO2(total)
        { 1.532e+01, 7.520e-01, 1.288e+01, 0.000e+00, 0.000e+00, 1.901e+00, 0.000e+00 }, // CO
        { 6.313e+00, 0.000e+00, 2.726e+00, 0.000e+00, 1.176e-04, 1.442e-01, 6.062e-03 }, // HC
        { 1.201e+03, 3.106e+02, 1.701e+03, 0.000e+00, 0.000e+00, 7.548e+02, 0.000e+00 }, // FC
        { 5.692e+01, 8.643e+00, 8.222e+01, 0.000e+00, 0.000e+00, 2.100e+01, 0.000e+00 }, // NOx
        { 2.993e+00, 1.129e-01, 1.026e+00, 1.285e-03, 5.952e-05, 2.613e-01, 1.910e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_CNG_Euro-III
        { 4.267e+03, 9.365e+02, 6.428e+03, 0.000e+00, 0.000e+00, 2.293e+03, 0.000e+00 }, // CO2(total)
        { 2.102e+01, 6.688e-01, 6.622e+00, 0.000e+00, 0.000e+00, 1.963e+00, 0.000e+00 }, // CO
        { 5.675e+00, 0.000e+00, 2.926e+00, 0.000e+00, 7.899e-05, 0.000e+00, 8.534e-03 }, // HC
        { 1.373e+03, 3.013e+02, 2.068e+03, 0.000e+00, 0.000e+00, 7.379e+02, 0.000e+00 }, // FC
        { 4.996e+01, 6.388e+00, 7.403e+01, 0.000e+00, 0.000e+00, 1.584e+01, 0.000e+00 }, // NOx
        { 3.692e+00, 6.343e-02, 0.000e+00, 1.259e-03, 5.999e-05, 1.824e-01, 1.671e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_CNG_Euro-IV
        { 3.540e+03, 9.717e+02, 6.833e+03, 0.000e+00, 0.000e+00, 2.335e+03, 0.000e+00 }, // CO2(total)
        { 6.334e+00, 2.932e-03, 1.014e+01, 0.000e+00, 0.000e+00, 3.165e-02, 0.000e+00 }, // CO
        { 2.443e+00, 3.838e-02, 1.753e+00, 0.000e+00, 4.460e-05, 2.327e-01, 0.000e+00 }, // HC
        { 1.139e+03, 3.127e+02, 2.199e+03, 0.000e+00, 0.000e+00, 7.512e+02, 0.000e+00 }, // FC
        { 2.775e+01, 1.685e+00, 4.390e+01, 0.000e+00, 0.000e+00, 4.184e+00, 0.000e+00 }, // NOx
        { 1.994e+00, 2.027e-02, 7.807e-01, 1.216e-03, 6.145e-05, 4.878e-02, 1.645e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_CNG_Euro-V
        { 2.517e+03, 9.328e+02, 4.018e+03, 0.000e+00, 0.000e+00, 2.300e+03, 0.000e+00 }, // CO2(total)
        { 1.870e+00, 6.930e-01, 2.985e+00, 0.000e+00, 0.000e+00, 1.709e+00, 0.000e+00 }, // CO
        { 8.821e-01, 3.270e-01, 1.408e+00, 0.000e+00, 0.000e+00, 8.061e-01, 0.000e+00 }, // HC
        { 8.098e+02, 3.002e+02, 1.293e+03, 0.000e+00, 0.000e+00, 7.400e+02, 0.000e+00 }, // FC
        { 3.400e+00, 1.260e+00, 5.428e+00, 0.000e+00, 0.000e+00, 3.107e+00, 0.000e+00 }, // NOx
        { 1.436e+00, 5.407e-03, 2.329e-02, 1.306e-03, 5.787e-05, 1.352e-02, 1.222e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_3-Axes_gt18t_CNG_Euro-VI
        { 2.594e+03, 9.141e+02, 4.721e+03, 0.000e+00, 0.000e+00, 2.240e+03, 0.000e+00 }, // CO2(total)
        { 1.680e+00, 5.920e-01, 3.058e+00, 0.000e+00, 0.000e+00, 1.451e+00, 0.000e+00 }, // CO
        { 4.451e-01, 1.569e-01, 8.102e-01, 0.000e+00, 0.000e+00, 3.844e-01, 0.000e+00 }, // HC
        { 8.346e+02, 2.941e+02, 1.519e+03, 0.000e+00, 0.000e+00, 7.208e+02, 0.000e+00 }, // FC
        { 1.115e+00, 3.930e-01, 2.030e+00, 0.000e+00, 0.000e+00, 9.631e-01, 0.000e+00 }, // NOx
        { 1.440e+00, 5.299e-03, 2.744e-02, 1.263e-03, 5.931e-05, 1.299e-02, 1.298e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_CNG_Euro-I
        { 2.950e+03, 3.590e+02, 0.000e+00, 0.000e+00, 2.609e-01, 1.279e+03, 0.000e+00 }, // CO2(total)
        { 1.555e+01, 0.000e+00, 7.738e+00, 4.712e-03, 3.295e-04, 1.221e+00, 0.000e+00 }, // CO
        { 3.519e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.520e-04, 2.591e-01, 1.347e-03 }, // HC
        { 9.494e+02, 1.155e+02, 0.000e+00, 0.000e+00, 8.396e-02, 4.115e+02, 0.000e+00 }, // FC
        { 2.343e+01, 3.593e+00, 5.854e+00, 0.000e+00, 1.804e-03, 1.098e+01, 0.000e+00 }, // NOx
        { 4.272e+00, 0.000e+00, 0.000e+00, 1.162e-03, 1.951e-04, 2.663e-01, 1.369e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_CNG_Euro-II
        { 2.692e+03, 3.686e+02, 7.299e+02, 0.000e+00, 1.992e-01, 1.181e+03, 0.000e+00 }, // CO2(total)
        { 1.413e+01, 0.000e+00, 1.910e+01, 0.000e+00, 3.067e-05, 8.850e-02, 0.000e+00 }, // CO
        { 2.175e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.345e-05, 1.660e-01, 4.814e-04 }, // HC
        { 8.661e+02, 1.186e+02, 2.349e+02, 0.000e+00, 6.409e-02, 3.800e+02, 0.000e+00 }, // FC
        { 2.590e+01, 3.275e+00, 6.704e+00, 0.000e+00, 1.749e-03, 1.035e+01, 0.000e+00 }, // NOx
        { 2.981e+00, 0.000e+00, 1.305e+00, 1.034e-03, 9.713e-05, 6.932e-02, 2.218e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_CNG_Euro-III
        { 2.048e+03, 4.636e+02, 1.029e+03, 0.000e+00, 1.230e-01, 1.233e+03, 0.000e+00 }, // CO2(total)
        { 1.276e+01, 0.000e+00, 7.390e+00, 0.000e+00, 9.008e-05, 0.000e+00, 1.035e-02 }, // CO
        { 1.906e+00, 7.102e-03, 2.935e-01, 0.000e+00, 4.616e-05, 1.227e-01, 0.000e+00 }, // HC
        { 6.589e+02, 1.492e+02, 3.311e+02, 0.000e+00, 3.958e-02, 3.969e+02, 0.000e+00 }, // FC
        { 1.767e+01, 2.745e+00, 6.161e+00, 3.009e-02, 0.000e+00, 8.015e+00, 0.000e+00 }, // NOx
        { 2.521e+00, 1.542e-02, 4.015e-01, 1.102e-03, 7.820e-05, 6.524e-02, 3.070e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_CNG_Euro-IV
        { 7.986e+02, 5.414e+02, 1.476e+03, 0.000e+00, 7.492e-02, 1.227e+03, 0.000e+00 }, // CO2(total)
        { 2.078e+00, 0.000e+00, 2.183e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.283e-04 }, // CO
        { 9.001e-01, 1.230e-02, 9.788e-01, 0.000e+00, 4.236e-05, 2.261e-02, 2.501e-03 }, // HC
        { 2.570e+02, 1.742e+02, 4.748e+02, 0.000e+00, 2.411e-02, 3.949e+02, 0.000e+00 }, // FC
        { 1.280e+01, 2.755e-01, 2.199e+01, 2.045e-02, 0.000e+00, 0.000e+00, 6.117e-02 }, // NOx
        { 1.701e+00, 0.000e+00, 2.933e-01, 1.107e-03, 7.599e-05, 0.000e+00, 7.785e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_CNG_Euro-V
        { 7.628e+02, 4.944e+02, 2.301e+03, 0.000e+00, 3.690e-02, 1.047e+03, 0.000e+00 }, // CO2(total)
        { 5.667e-01, 3.673e-01, 1.709e+00, 0.000e+00, 2.741e-05, 7.781e-01, 0.000e+00 }, // CO
        { 2.674e-01, 1.733e-01, 8.064e-01, 0.000e+00, 1.293e-05, 3.671e-01, 0.000e+00 }, // HC
        { 2.454e+02, 1.591e+02, 7.403e+02, 0.000e+00, 1.187e-02, 3.370e+02, 0.000e+00 }, // FC
        { 1.031e+00, 6.679e-01, 3.108e+00, 0.000e+00, 4.985e-05, 1.415e+00, 0.000e+00 }, // NOx
        { 1.421e+00, 2.866e-03, 1.334e-02, 1.241e-03, 6.381e-05, 6.071e-03, 2.892e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Midi_le15t_CNG_Euro-VI
        { 1.100e+03, 4.904e+02, 2.494e+03, 0.000e+00, 8.164e-02, 1.076e+03, 0.000e+00 }, // CO2(total)
        { 7.122e-01, 3.176e-01, 1.615e+00, 0.000e+00, 5.288e-05, 6.967e-01, 0.000e+00 }, // CO
        { 1.887e-01, 8.416e-02, 4.280e-01, 0.000e+00, 1.401e-05, 1.846e-01, 0.000e+00 }, // HC
        { 3.538e+02, 1.578e+02, 8.025e+02, 0.000e+00, 2.627e-02, 3.462e+02, 0.000e+00 }, // FC
        { 4.728e-01, 2.108e-01, 1.072e+00, 0.000e+00, 3.510e-05, 4.625e-01, 0.000e+00 }, // NOx
        { 1.431e+00, 2.843e-03, 1.446e-02, 1.193e-03, 6.493e-05, 6.236e-03, 2.453e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_BEV_Std_le18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.215e+00, 0.000e+00, 0.000e+00, 2.278e-03, 3.215e-05, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 6.191e+00, 4.184e-01, 2.528e+00, 0.000e+00, 6.665e-04, 4.410e+00, 5.400e-03 }, // FC_MJ
    },
    {
        // Coach_BEV_3-Axes_gt18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.212e+00, 0.000e+00, 0.000e+00, 2.440e-03, 2.559e-05, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 9.862e+00, 4.494e-01, 1.597e+00, 0.000e+00, 6.783e-04, 5.644e+00, 7.777e-04 }, // FC_MJ
    },
    {
        // Coach_BEV_Midi
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 9.996e-01, 1.006e-02, 0.000e+00, 3.117e-03, 0.000e+00, 0.000e+00, 1.104e-04 }, // PM + PM (non-exhaust)
        { 3.137e+00, 4.235e-01, 1.677e-02, 0.000e+00, 6.167e-04, 2.589e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_FuelCell_Std_le18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 3.429e+02, 2.318e+01, 1.400e+02, 0.000e+00, 3.691e-02, 2.442e+02, 2.991e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.215e+00, 0.000e+00, 0.000e+00, 2.278e-03, 3.215e-05, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_FuelCell_Std_3-Axes_gt18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 5.462e+02, 2.489e+01, 8.847e+01, 0.000e+00, 3.757e-02, 3.126e+02, 4.307e-02 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.212e+00, 0.000e+00, 0.000e+00, 2.440e-03, 2.559e-05, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_FuelCell_Std_Midi
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 1.737e+02, 2.345e+01, 9.289e-01, 0.000e+00, 3.416e-02, 1.434e+02, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 9.996e-01, 1.006e-02, 0.000e+00, 3.117e-03, 0.000e+00, 0.000e+00, 1.104e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Coach_Std_le18t_EE
        { 3.820e+03, 5.403e+02, 0.000e+00, 9.843e+00, 0.000e+00, 2.122e+03, 6.104e-01 }, // CO2(total)
        { 8.331e+01, 1.467e+00, 5.928e+01, 0.000e+00, 2.091e-04, 4.365e+00, 0.000e+00 }, // CO
        { 2.924e+01, 0.000e+00, 1.371e+01, 0.000e+00, 2.665e-04, 1.373e-01, 6.064e-03 }, // HC
        { 1.228e+03, 1.736e+02, 0.000e+00, 3.163e+00, 0.000e+00, 6.820e+02, 1.962e-01 }, // FC
        { 4.784e+01, 8.948e+00, 0.000e+00, 1.324e-01, 0.000e+00, 3.154e+01, 3.542e-02 }, // NOx
        { 9.186e+00, 1.828e-01, 1.711e+00, 5.698e-03, 6.024e-05, 7.924e-01, 1.336e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_P_le15t_Euro-IV
        { 1.814e+03, 4.294e+02, 1.683e+03, 0.000e+00, 0.000e+00, 1.008e+03, 0.000e+00 }, // CO2(total)
        { 9.102e+00, 2.162e-01, 1.108e+01, 0.000e+00, 0.000e+00, 6.813e-01, 0.000e+00 }, // CO
        { 9.790e-02, 6.719e-03, 1.536e-01, 0.000e+00, 0.000e+00, 1.204e-02, 0.000e+00 }, // HC
        { 5.880e+02, 1.392e+02, 5.457e+02, 0.000e+00, 0.000e+00, 3.266e+02, 0.000e+00 }, // FC
        { 2.209e+00, 8.936e-02, 3.409e+00, 0.000e+00, 0.000e+00, 2.547e-01, 0.000e+00 }, // NOx
        { 1.402e+00, 3.870e-03, 7.378e-03, 0.000e+00, 1.222e-04, 2.784e-04, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_P_le15t_Euro-V
        { 2.195e+03, 5.656e+02, 1.857e+03, 0.000e+00, 0.000e+00, 1.348e+03, 0.000e+00 }, // CO2(total)
        { 1.014e+01, 0.000e+00, 1.862e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.285e-01, 1.302e-02, 1.264e-01, 0.000e+00, 4.160e-06, 3.631e-02, 0.000e+00 }, // HC
        { 7.117e+02, 1.834e+02, 6.019e+02, 0.000e+00, 0.000e+00, 4.370e+02, 0.000e+00 }, // FC
        { 5.754e-01, 1.436e-02, 8.435e-01, 0.000e+00, 0.000e+00, 4.155e-02, 0.000e+00 }, // NOx
        { 1.389e+00, 4.952e-03, 2.424e-04, 1.382e-05, 1.221e-04, 5.104e-04, 8.009e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_P_le15t_Euro-VI
        { 2.370e+03, 5.277e+02, 2.603e+03, 0.000e+00, 0.000e+00, 1.257e+03, 0.000e+00 }, // CO2(total)
        { 2.707e+00, 9.106e-03, 3.862e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.806e-02, 3.565e-03, 3.113e-02, 0.000e+00, 0.000e+00, 8.258e-03, 0.000e+00 }, // HC
        { 7.683e+02, 1.711e+02, 8.438e+02, 0.000e+00, 0.000e+00, 4.076e+02, 0.000e+00 }, // FC
        { 5.986e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.610e-05 }, // NOx
        { 1.389e+00, 5.087e-03, 2.650e-03, 0.000e+00, 1.217e-04, 0.000e+00, 5.885e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_50ties
        { 2.436e+03, 5.075e+02, 1.186e+03, 0.000e+00, 0.000e+00, 1.208e+03, 0.000e+00 }, // CO2(total)
        { 3.516e+01, 0.000e+00, 1.459e+01, 4.931e-02, 8.577e-04, 1.680e+00, 1.339e-01 }, // CO
        { 1.454e+01, 0.000e+00, 2.188e+00, 0.000e+00, 5.923e-04, 0.000e+00, 1.993e-02 }, // HC
        { 7.829e+02, 1.631e+02, 3.811e+02, 0.000e+00, 0.000e+00, 3.884e+02, 0.000e+00 }, // FC
        { 3.026e+01, 6.303e+00, 1.123e+01, 0.000e+00, 0.000e+00, 1.486e+01, 0.000e+00 }, // NOx
        { 6.688e+00, 8.209e-02, 4.382e-01, 6.237e-03, 1.169e-04, 6.974e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_60ties
        { 2.436e+03, 5.075e+02, 1.186e+03, 0.000e+00, 0.000e+00, 1.208e+03, 0.000e+00 }, // CO2(total)
        { 3.516e+01, 0.000e+00, 1.459e+01, 4.931e-02, 8.577e-04, 1.680e+00, 1.339e-01 }, // CO
        { 1.454e+01, 0.000e+00, 2.188e+00, 0.000e+00, 5.923e-04, 0.000e+00, 1.993e-02 }, // HC
        { 7.829e+02, 1.631e+02, 3.811e+02, 0.000e+00, 0.000e+00, 3.884e+02, 0.000e+00 }, // FC
        { 3.026e+01, 6.303e+00, 1.123e+01, 0.000e+00, 0.000e+00, 1.486e+01, 0.000e+00 }, // NOx
        { 6.688e+00, 8.209e-02, 4.382e-01, 6.237e-03, 1.169e-04, 6.974e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_70ties
        { 2.436e+03, 5.075e+02, 1.186e+03, 0.000e+00, 0.000e+00, 1.208e+03, 0.000e+00 }, // CO2(total)
        { 3.516e+01, 0.000e+00, 1.459e+01, 4.931e-02, 8.577e-04, 1.680e+00, 1.339e-01 }, // CO
        { 1.454e+01, 0.000e+00, 2.188e+00, 0.000e+00, 5.923e-04, 0.000e+00, 1.993e-02 }, // HC
        { 7.829e+02, 1.631e+02, 3.811e+02, 0.000e+00, 0.000e+00, 3.884e+02, 0.000e+00 }, // FC
        { 3.026e+01, 6.303e+00, 1.123e+01, 0.000e+00, 0.000e+00, 1.486e+01, 0.000e+00 }, // NOx
        { 6.688e+00, 8.209e-02, 4.382e-01, 6.237e-03, 1.169e-04, 6.974e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_80ties
        { 2.436e+03, 5.075e+02, 1.186e+03, 0.000e+00, 0.000e+00, 1.208e+03, 0.000e+00 }, // CO2(total)
        { 3.516e+01, 0.000e+00, 1.459e+01, 4.931e-02, 8.577e-04, 1.680e+00, 1.339e-01 }, // CO
        { 1.454e+01, 0.000e+00, 2.188e+00, 0.000e+00, 5.923e-04, 0.000e+00, 1.993e-02 }, // HC
        { 7.829e+02, 1.631e+02, 3.811e+02, 0.000e+00, 0.000e+00, 3.884e+02, 0.000e+00 }, // FC
        { 3.026e+01, 6.303e+00, 1.123e+01, 0.000e+00, 0.000e+00, 1.486e+01, 0.000e+00 }, // NOx
        { 6.688e+00, 8.209e-02, 4.382e-01, 6.237e-03, 1.169e-04, 6.974e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-I
        { 2.484e+03, 4.730e+02, 1.344e+03, 0.000e+00, 0.000e+00, 1.132e+03, 0.000e+00 }, // CO2(total)
        { 1.694e+01, 2.792e-01, 1.231e+01, 0.000e+00, 0.000e+00, 1.196e+00, 0.000e+00 }, // CO
        { 3.085e+00, 0.000e+00, 1.109e+00, 0.000e+00, 2.133e-04, 0.000e+00, 1.137e-02 }, // HC
        { 7.985e+02, 1.520e+02, 4.318e+02, 0.000e+00, 0.000e+00, 3.639e+02, 0.000e+00 }, // FC
        { 2.655e+01, 4.403e+00, 1.793e+01, 0.000e+00, 0.000e+00, 1.064e+01, 0.000e+00 }, // NOx
        { 4.029e+00, 0.000e+00, 5.782e-01, 3.327e-03, 1.246e-04, 1.306e-01, 4.760e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-I_(DPF)
        { 2.509e+03, 4.777e+02, 1.357e+03, 0.000e+00, 0.000e+00, 1.144e+03, 0.000e+00 }, // CO2(total)
        { 5.589e+00, 9.214e-02, 4.063e+00, 0.000e+00, 0.000e+00, 3.947e-01, 0.000e+00 }, // CO
        { 1.018e+00, 0.000e+00, 3.658e-01, 0.000e+00, 7.039e-05, 0.000e+00, 3.753e-03 }, // HC
        { 8.064e+02, 1.535e+02, 4.361e+02, 0.000e+00, 0.000e+00, 3.676e+02, 0.000e+00 }, // FC
        { 2.655e+01, 4.403e+00, 1.793e+01, 0.000e+00, 0.000e+00, 1.064e+01, 0.000e+00 }, // NOx
        { 2.118e+00, 0.000e+00, 1.503e-01, 8.650e-04, 1.246e-04, 3.395e-02, 1.238e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-II
        { 2.230e+03, 4.697e+02, 6.299e+02, 0.000e+00, 0.000e+00, 1.159e+03, 0.000e+00 }, // CO2(total)
        { 1.496e+01, 0.000e+00, 1.557e+01, 0.000e+00, 0.000e+00, 2.844e-01, 0.000e+00 }, // CO
        { 1.733e+00, 1.022e-02, 0.000e+00, 2.963e-03, 0.000e+00, 1.006e-01, 4.976e-03 }, // HC
        { 7.167e+02, 1.510e+02, 2.024e+02, 0.000e+00, 0.000e+00, 3.725e+02, 0.000e+00 }, // FC
        { 2.571e+01, 4.462e+00, 1.088e+01, 0.000e+00, 0.000e+00, 1.102e+01, 0.000e+00 }, // NOx
        { 2.850e+00, 2.802e-02, 4.888e-01, 0.000e+00, 1.226e-04, 1.169e-01, 5.063e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-II_(DPF)
        { 2.252e+03, 4.744e+02, 6.362e+02, 0.000e+00, 0.000e+00, 1.171e+03, 0.000e+00 }, // CO2(total)
        { 4.937e+00, 0.000e+00, 5.137e+00, 0.000e+00, 0.000e+00, 9.385e-02, 0.000e+00 }, // CO
        { 5.720e-01, 3.373e-03, 0.000e+00, 9.779e-04, 0.000e+00, 3.319e-02, 1.642e-03 }, // HC
        { 7.239e+02, 1.525e+02, 2.045e+02, 0.000e+00, 0.000e+00, 3.763e+02, 0.000e+00 }, // FC
        { 2.571e+01, 4.462e+00, 1.088e+01, 0.000e+00, 0.000e+00, 1.102e+01, 0.000e+00 }, // NOx
        { 1.773e+00, 1.036e-02, 1.271e-01, 0.000e+00, 1.226e-04, 3.038e-02, 5.063e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-III
        { 2.429e+03, 4.712e+02, 8.719e+02, 0.000e+00, 0.000e+00, 1.178e+03, 0.000e+00 }, // CO2(total)
        { 1.505e+01, 0.000e+00, 1.143e+01, 0.000e+00, 0.000e+00, 2.460e-01, 0.000e+00 }, // CO
        { 1.505e+00, 3.385e-02, 0.000e+00, 0.000e+00, 4.775e-05, 1.064e-01, 2.287e-03 }, // HC
        { 7.806e+02, 1.514e+02, 2.802e+02, 0.000e+00, 0.000e+00, 3.786e+02, 0.000e+00 }, // FC
        { 3.103e+01, 2.902e+00, 2.078e+01, 0.000e+00, 0.000e+00, 7.987e+00, 0.000e+00 }, // NOx
        { 2.338e+00, 3.785e-02, 0.000e+00, 0.000e+00, 1.208e-04, 9.368e-02, 4.824e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-III_(DPF)
        { 2.453e+03, 4.759e+02, 8.806e+02, 0.000e+00, 0.000e+00, 1.190e+03, 0.000e+00 }, // CO2(total)
        { 4.966e+00, 0.000e+00, 3.773e+00, 0.000e+00, 0.000e+00, 8.118e-02, 0.000e+00 }, // CO
        { 4.968e-01, 1.117e-02, 0.000e+00, 0.000e+00, 1.576e-05, 3.511e-02, 7.547e-04 }, // HC
        { 7.884e+02, 1.530e+02, 2.830e+02, 0.000e+00, 0.000e+00, 3.824e+02, 0.000e+00 }, // FC
        { 3.103e+01, 2.902e+00, 2.078e+01, 0.000e+00, 0.000e+00, 7.987e+00, 0.000e+00 }, // NOx
        { 1.622e+00, 1.442e-02, 0.000e+00, 0.000e+00, 1.208e-04, 2.436e-02, 4.824e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-IV_EGR
        { 2.006e+03, 4.750e+02, 1.862e+03, 0.000e+00, 0.000e+00, 1.114e+03, 0.000e+00 }, // CO2(total)
        { 6.644e+00, 1.578e-01, 8.091e+00, 0.000e+00, 0.000e+00, 4.973e-01, 0.000e+00 }, // CO
        { 2.447e-01, 1.680e-02, 3.840e-01, 0.000e+00, 0.000e+00, 3.011e-02, 0.000e+00 }, // HC
        { 6.448e+02, 1.527e+02, 5.984e+02, 0.000e+00, 0.000e+00, 3.582e+02, 0.000e+00 }, // FC
        { 3.682e+01, 1.489e+00, 5.682e+01, 0.000e+00, 0.000e+00, 4.245e+00, 0.000e+00 }, // NOx
        { 1.701e+00, 7.383e-03, 3.687e-01, 0.000e+00, 1.222e-04, 1.391e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-IV_SCR
        { 1.858e+03, 4.852e+02, 1.401e+03, 0.000e+00, 0.000e+00, 1.152e+03, 0.000e+00 }, // CO2(total)
        { 1.966e+01, 0.000e+00, 3.500e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.728e-02, 1.051e-02, 8.956e-02, 0.000e+00, 0.000e+00, 1.924e-02, 0.000e+00 }, // HC
        { 5.970e+02, 1.559e+02, 4.503e+02, 0.000e+00, 0.000e+00, 3.703e+02, 0.000e+00 }, // FC
        { 1.935e+01, 8.174e-01, 0.000e+00, 1.888e-02, 0.000e+00, 2.119e+00, 6.607e-02 }, // NOx
        { 1.735e+00, 5.511e-03, 5.383e-01, 0.000e+00, 1.217e-04, 1.585e-03, 6.070e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-IV_SCRs
        { 1.858e+03, 4.852e+02, 1.401e+03, 0.000e+00, 0.000e+00, 1.152e+03, 0.000e+00 }, // CO2(total)
        { 1.966e+01, 0.000e+00, 3.500e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.728e-02, 1.051e-02, 8.956e-02, 0.000e+00, 0.000e+00, 1.924e-02, 0.000e+00 }, // HC
        { 5.970e+02, 1.559e+02, 4.503e+02, 0.000e+00, 0.000e+00, 3.703e+02, 0.000e+00 }, // FC
        { 2.194e+01, 4.579e+00, 1.051e+01, 0.000e+00, 0.000e+00, 1.110e+01, 0.000e+00 }, // NOx
        { 1.735e+00, 5.511e-03, 5.383e-01, 0.000e+00, 1.217e-04, 1.585e-03, 6.070e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-IV_EGR_(DPF)
        { 2.050e+03, 4.855e+02, 1.903e+03, 0.000e+00, 0.000e+00, 1.139e+03, 0.000e+00 }, // CO2(total)
        { 1.129e+00, 2.683e-02, 1.375e+00, 0.000e+00, 0.000e+00, 8.454e-02, 0.000e+00 }, // CO
        { 1.224e-02, 8.399e-04, 1.920e-02, 0.000e+00, 0.000e+00, 1.505e-03, 0.000e+00 }, // HC
        { 6.590e+02, 1.560e+02, 6.116e+02, 0.000e+00, 0.000e+00, 3.660e+02, 0.000e+00 }, // FC
        { 3.682e+01, 1.489e+00, 5.682e+01, 0.000e+00, 0.000e+00, 4.245e+00, 0.000e+00 }, // NOx
        { 1.417e+00, 4.049e-03, 2.581e-02, 0.000e+00, 1.222e-04, 9.739e-04, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-IV_SCR_(DPF)
        { 1.899e+03, 4.959e+02, 1.432e+03, 0.000e+00, 0.000e+00, 1.178e+03, 0.000e+00 }, // CO2(total)
        { 3.342e+00, 0.000e+00, 5.950e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.364e-03, 5.257e-04, 4.478e-03, 0.000e+00, 0.000e+00, 9.622e-04, 0.000e+00 }, // HC
        { 6.102e+02, 1.594e+02, 4.602e+02, 0.000e+00, 0.000e+00, 3.785e+02, 0.000e+00 }, // FC
        { 1.935e+01, 8.174e-01, 0.000e+00, 1.888e-02, 0.000e+00, 2.119e+00, 6.607e-02 }, // NOx
        { 1.393e+00, 5.511e-03, 2.153e-02, 0.000e+00, 1.217e-04, 6.339e-05, 6.070e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-IV_SCRs_(DPF)
        { 1.899e+03, 4.959e+02, 1.432e+03, 0.000e+00, 0.000e+00, 1.178e+03, 0.000e+00 }, // CO2(total)
        { 3.342e+00, 0.000e+00, 5.950e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.364e-03, 5.257e-04, 4.478e-03, 0.000e+00, 0.000e+00, 9.622e-04, 0.000e+00 }, // HC
        { 6.102e+02, 1.594e+02, 4.602e+02, 0.000e+00, 0.000e+00, 3.785e+02, 0.000e+00 }, // FC
        { 2.194e+01, 4.579e+00, 1.051e+01, 0.000e+00, 0.000e+00, 1.110e+01, 0.000e+00 }, // NOx
        { 1.393e+00, 5.511e-03, 2.153e-02, 0.000e+00, 1.217e-04, 6.339e-05, 6.070e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-V_EGR
        { 1.836e+03, 4.730e+02, 1.553e+03, 0.000e+00, 0.000e+00, 1.128e+03, 0.000e+00 }, // CO2(total)
        { 5.666e+00, 0.000e+00, 1.040e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.462e-01, 1.973e-02, 1.915e-01, 0.000e+00, 6.302e-06, 5.502e-02, 0.000e+00 }, // HC
        { 5.901e+02, 1.520e+02, 4.990e+02, 0.000e+00, 0.000e+00, 3.624e+02, 0.000e+00 }, // FC
        { 2.877e+01, 7.182e-01, 4.217e+01, 0.000e+00, 0.000e+00, 2.077e+00, 0.000e+00 }, // NOx
        { 1.465e+00, 9.953e-03, 1.212e-02, 6.908e-04, 1.221e-04, 2.552e-02, 9.698e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-V_SCR
        { 1.827e+03, 4.609e+02, 1.610e+03, 0.000e+00, 0.000e+00, 1.098e+03, 0.000e+00 }, // CO2(total)
        { 1.765e+01, 0.000e+00, 3.034e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.072e-02, 9.071e-03, 9.783e-02, 0.000e+00, 0.000e+00, 1.701e-02, 0.000e+00 }, // HC
        { 5.871e+02, 1.481e+02, 5.174e+02, 0.000e+00, 0.000e+00, 3.527e+02, 0.000e+00 }, // FC
        { 1.631e+01, 2.265e-01, 0.000e+00, 1.432e-02, 0.000e+00, 0.000e+00, 7.317e-02 }, // NOx
        { 1.735e+00, 5.008e-03, 5.155e-01, 0.000e+00, 1.216e-04, 7.727e-04, 6.856e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-V_SCRs
        { 1.827e+03, 4.609e+02, 1.610e+03, 0.000e+00, 0.000e+00, 1.098e+03, 0.000e+00 }, // CO2(total)
        { 1.765e+01, 0.000e+00, 3.034e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.072e-02, 9.071e-03, 9.783e-02, 0.000e+00, 0.000e+00, 1.701e-02, 0.000e+00 }, // HC
        { 5.871e+02, 1.481e+02, 5.174e+02, 0.000e+00, 0.000e+00, 3.527e+02, 0.000e+00 }, // FC
        { 2.156e+01, 4.638e+00, 8.386e+00, 0.000e+00, 0.000e+00, 1.112e+01, 0.000e+00 }, // NOx
        { 1.735e+00, 5.008e-03, 5.155e-01, 0.000e+00, 1.216e-04, 7.727e-04, 6.856e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-V_EGR_(DPF)
        { 1.876e+03, 4.834e+02, 1.587e+03, 0.000e+00, 0.000e+00, 1.152e+03, 0.000e+00 }, // CO2(total)
        { 9.632e-01, 0.000e+00, 1.768e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.731e-02, 9.864e-04, 9.576e-03, 0.000e+00, 3.151e-07, 2.751e-03, 0.000e+00 }, // HC
        { 6.030e+02, 1.554e+02, 5.100e+02, 0.000e+00, 0.000e+00, 3.703e+02, 0.000e+00 }, // FC
        { 2.877e+01, 7.182e-01, 4.217e+01, 0.000e+00, 0.000e+00, 2.077e+00, 0.000e+00 }, // NOx
        { 1.393e+00, 5.207e-03, 8.484e-04, 4.835e-05, 1.221e-04, 1.786e-03, 1.255e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-V_SCR_(DPF)
        { 1.867e+03, 4.710e+02, 1.645e+03, 0.000e+00, 0.000e+00, 1.122e+03, 0.000e+00 }, // CO2(total)
        { 3.001e+00, 0.000e+00, 5.157e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.036e-03, 4.536e-04, 4.891e-03, 0.000e+00, 0.000e+00, 8.507e-04, 0.000e+00 }, // HC
        { 6.001e+02, 1.514e+02, 5.288e+02, 0.000e+00, 0.000e+00, 3.605e+02, 0.000e+00 }, // FC
        { 1.631e+01, 2.265e-01, 0.000e+00, 1.432e-02, 0.000e+00, 0.000e+00, 7.317e-02 }, // NOx
        { 1.405e+00, 5.008e-03, 2.062e-02, 0.000e+00, 1.216e-04, 3.091e-05, 6.856e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-V_SCRs_(DPF)
        { 1.867e+03, 4.710e+02, 1.645e+03, 0.000e+00, 0.000e+00, 1.122e+03, 0.000e+00 }, // CO2(total)
        { 3.001e+00, 0.000e+00, 5.157e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.036e-03, 4.536e-04, 4.891e-03, 0.000e+00, 0.000e+00, 8.507e-04, 0.000e+00 }, // HC
        { 6.001e+02, 1.514e+02, 5.288e+02, 0.000e+00, 0.000e+00, 3.605e+02, 0.000e+00 }, // FC
        { 2.156e+01, 4.638e+00, 8.386e+00, 0.000e+00, 0.000e+00, 1.112e+01, 0.000e+00 }, // NOx
        { 1.405e+00, 5.008e-03, 2.062e-02, 0.000e+00, 1.216e-04, 3.091e-05, 6.856e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-VI_A-C
        { 1.982e+03, 4.413e+02, 2.177e+03, 0.000e+00, 0.000e+00, 1.052e+03, 0.000e+00 }, // CO2(total)
        { 1.512e+00, 5.087e-03, 2.157e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.797e-02, 5.402e-03, 4.717e-02, 0.000e+00, 0.000e+00, 1.251e-02, 0.000e+00 }, // HC
        { 6.370e+02, 1.418e+02, 6.996e+02, 0.000e+00, 0.000e+00, 3.379e+02, 0.000e+00 }, // FC
        { 2.993e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.305e-03 }, // NOx
        { 1.467e+00, 5.087e-03, 1.325e-01, 0.000e+00, 1.217e-04, 0.000e+00, 5.885e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-VIs_A-C
        { 1.982e+03, 4.413e+02, 2.177e+03, 0.000e+00, 0.000e+00, 1.052e+03, 0.000e+00 }, // CO2(total)
        { 1.512e+00, 5.087e-03, 2.157e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.797e-02, 5.402e-03, 4.717e-02, 0.000e+00, 0.000e+00, 1.251e-02, 0.000e+00 }, // HC
        { 6.370e+02, 1.418e+02, 6.996e+02, 0.000e+00, 0.000e+00, 3.379e+02, 0.000e+00 }, // FC
        { 1.496e+01, 3.012e+00, 2.046e+01, 0.000e+00, 0.000e+00, 7.056e+00, 0.000e+00 }, // NOx
        { 1.467e+00, 5.087e-03, 1.325e-01, 0.000e+00, 1.217e-04, 0.000e+00, 5.885e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-VI_D-E
        { 1.712e+03, 4.566e+02, 1.551e+03, 0.000e+00, 0.000e+00, 1.090e+03, 0.000e+00 }, // CO2(total)
        { 5.374e-01, 0.000e+00, 7.547e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.168e-01, 6.240e-03, 1.779e-02, 1.854e-05, 0.000e+00, 6.784e-03, 2.808e-04 }, // HC
        { 5.502e+02, 1.468e+02, 4.985e+02, 0.000e+00, 0.000e+00, 3.502e+02, 0.000e+00 }, // FC
        { 7.569e-01, 1.416e-02, 5.711e-01, 0.000e+00, 0.000e+00, 3.978e-02, 0.000e+00 }, // NOx
        { 1.401e+00, 5.735e-03, 0.000e+00, 0.000e+00, 1.225e-04, 3.285e-03, 5.348e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_le15t_Euro-VIs_D-E
        { 1.712e+03, 4.566e+02, 1.551e+03, 0.000e+00, 0.000e+00, 1.090e+03, 0.000e+00 }, // CO2(total)
        { 5.374e-01, 0.000e+00, 7.547e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.168e-01, 6.240e-03, 1.779e-02, 1.854e-05, 0.000e+00, 6.784e-03, 2.808e-04 }, // HC
        { 5.502e+02, 1.468e+02, 4.985e+02, 0.000e+00, 0.000e+00, 3.502e+02, 0.000e+00 }, // FC
        { 2.103e+01, 3.159e+00, 3.428e+01, 0.000e+00, 0.000e+00, 6.820e+00, 0.000e+00 }, // NOx
        { 1.401e+00, 5.735e-03, 0.000e+00, 0.000e+00, 1.225e-04, 3.285e-03, 5.348e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_50ties
        { 3.275e+03, 7.631e+02, 1.062e+03, 0.000e+00, 0.000e+00, 1.934e+03, 0.000e+00 }, // CO2(total)
        { 3.462e+01, 1.551e+00, 3.721e+00, 0.000e+00, 0.000e+00, 6.083e+00, 0.000e+00 }, // CO
        { 1.374e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.853e-04, 0.000e+00, 4.082e-02 }, // HC
        { 1.053e+03, 2.453e+02, 3.413e+02, 0.000e+00, 0.000e+00, 6.217e+02, 0.000e+00 }, // FC
        { 7.089e+01, 1.043e+01, 3.161e+01, 0.000e+00, 0.000e+00, 2.991e+01, 0.000e+00 }, // NOx
        { 6.273e+00, 2.506e-01, 0.000e+00, 0.000e+00, 1.291e-04, 8.929e-01, 2.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_60ties
        { 3.275e+03, 7.631e+02, 1.062e+03, 0.000e+00, 0.000e+00, 1.934e+03, 0.000e+00 }, // CO2(total)
        { 3.462e+01, 1.551e+00, 3.721e+00, 0.000e+00, 0.000e+00, 6.083e+00, 0.000e+00 }, // CO
        { 1.374e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.853e-04, 0.000e+00, 4.082e-02 }, // HC
        { 1.053e+03, 2.453e+02, 3.413e+02, 0.000e+00, 0.000e+00, 6.217e+02, 0.000e+00 }, // FC
        { 7.089e+01, 1.043e+01, 3.161e+01, 0.000e+00, 0.000e+00, 2.991e+01, 0.000e+00 }, // NOx
        { 6.273e+00, 2.506e-01, 0.000e+00, 0.000e+00, 1.291e-04, 8.929e-01, 2.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_70ties
        { 3.275e+03, 7.631e+02, 1.062e+03, 0.000e+00, 0.000e+00, 1.934e+03, 0.000e+00 }, // CO2(total)
        { 3.462e+01, 1.551e+00, 3.721e+00, 0.000e+00, 0.000e+00, 6.083e+00, 0.000e+00 }, // CO
        { 1.374e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.853e-04, 0.000e+00, 4.082e-02 }, // HC
        { 1.053e+03, 2.453e+02, 3.413e+02, 0.000e+00, 0.000e+00, 6.217e+02, 0.000e+00 }, // FC
        { 7.089e+01, 1.043e+01, 3.161e+01, 0.000e+00, 0.000e+00, 2.991e+01, 0.000e+00 }, // NOx
        { 6.273e+00, 2.506e-01, 0.000e+00, 0.000e+00, 1.291e-04, 8.929e-01, 2.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_80ties
        { 3.275e+03, 7.631e+02, 1.062e+03, 0.000e+00, 0.000e+00, 1.934e+03, 0.000e+00 }, // CO2(total)
        { 3.462e+01, 1.551e+00, 3.721e+00, 0.000e+00, 0.000e+00, 6.083e+00, 0.000e+00 }, // CO
        { 1.374e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.853e-04, 0.000e+00, 4.082e-02 }, // HC
        { 1.053e+03, 2.453e+02, 3.413e+02, 0.000e+00, 0.000e+00, 6.217e+02, 0.000e+00 }, // FC
        { 7.089e+01, 1.043e+01, 3.161e+01, 0.000e+00, 0.000e+00, 2.991e+01, 0.000e+00 }, // NOx
        { 6.273e+00, 2.506e-01, 0.000e+00, 0.000e+00, 1.291e-04, 8.929e-01, 2.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-I
        { 3.199e+03, 7.388e+02, 1.301e+03, 0.000e+00, 0.000e+00, 1.855e+03, 0.000e+00 }, // CO2(total)
        { 1.847e+01, 3.978e-01, 6.184e+00, 0.000e+00, 0.000e+00, 1.729e+00, 0.000e+00 }, // CO
        { 5.774e+00, 0.000e+00, 8.938e-01, 2.113e-03, 3.716e-04, 0.000e+00, 3.264e-02 }, // HC
        { 1.028e+03, 2.374e+02, 4.180e+02, 0.000e+00, 0.000e+00, 5.963e+02, 0.000e+00 }, // FC
        { 4.979e+01, 5.610e+00, 3.145e+01, 0.000e+00, 0.000e+00, 1.689e+01, 0.000e+00 }, // NOx
        { 4.253e+00, 1.705e-01, 0.000e+00, 1.238e-03, 1.242e-04, 3.342e-01, 1.047e-02 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-I_(DPF)
        { 3.231e+03, 7.461e+02, 1.314e+03, 0.000e+00, 0.000e+00, 1.874e+03, 0.000e+00 }, // CO2(total)
        { 6.094e+00, 1.313e-01, 2.041e+00, 0.000e+00, 0.000e+00, 5.704e-01, 0.000e+00 }, // CO
        { 1.905e+00, 0.000e+00, 2.949e-01, 6.974e-04, 1.226e-04, 0.000e+00, 1.077e-02 }, // HC
        { 1.038e+03, 2.398e+02, 4.222e+02, 0.000e+00, 0.000e+00, 6.023e+02, 0.000e+00 }, // FC
        { 4.979e+01, 5.610e+00, 3.145e+01, 0.000e+00, 0.000e+00, 1.689e+01, 0.000e+00 }, // NOx
        { 2.186e+00, 4.621e-02, 0.000e+00, 3.219e-04, 1.242e-04, 8.689e-02, 2.896e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-II
        { 3.101e+03, 7.035e+02, 1.420e+03, 0.000e+00, 0.000e+00, 1.765e+03, 0.000e+00 }, // CO2(total)
        { 1.652e+01, 0.000e+00, 1.139e+01, 5.511e-03, 0.000e+00, 0.000e+00, 3.682e-02 }, // CO
        { 3.473e+00, 0.000e+00, 8.762e-01, 4.638e-03, 5.096e-05, 0.000e+00, 1.710e-02 }, // HC
        { 9.965e+02, 2.261e+02, 4.564e+02, 0.000e+00, 0.000e+00, 5.673e+02, 0.000e+00 }, // FC
        { 5.662e+01, 4.990e+00, 4.516e+01, 0.000e+00, 0.000e+00, 1.515e+01, 0.000e+00 }, // NOx
        { 2.887e+00, 5.687e-02, 1.083e+00, 1.298e-03, 1.195e-04, 3.617e-03, 9.409e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-II_(DPF)
        { 3.132e+03, 7.106e+02, 1.434e+03, 0.000e+00, 0.000e+00, 1.783e+03, 0.000e+00 }, // CO2(total)
        { 5.453e+00, 0.000e+00, 3.759e+00, 1.819e-03, 0.000e+00, 0.000e+00, 1.215e-02 }, // CO
        { 1.146e+00, 0.000e+00, 2.891e-01, 1.530e-03, 1.682e-05, 0.000e+00, 5.644e-03 }, // HC
        { 1.006e+03, 2.284e+02, 4.609e+02, 0.000e+00, 0.000e+00, 5.730e+02, 0.000e+00 }, // FC
        { 5.662e+01, 4.990e+00, 4.516e+01, 0.000e+00, 0.000e+00, 1.515e+01, 0.000e+00 }, // NOx
        { 1.820e+00, 1.831e-02, 2.816e-01, 3.375e-04, 1.195e-04, 9.404e-04, 2.608e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-III
        { 3.164e+03, 7.177e+02, 1.461e+03, 0.000e+00, 0.000e+00, 1.809e+03, 0.000e+00 }, // CO2(total)
        { 1.866e+01, 0.000e+00, 6.405e+00, 0.000e+00, 2.526e-04, 0.000e+00, 3.887e-02 }, // CO
        { 3.230e+00, 0.000e+00, 4.379e-01, 0.000e+00, 1.716e-04, 0.000e+00, 1.494e-02 }, // HC
        { 1.017e+03, 2.306e+02, 4.695e+02, 0.000e+00, 0.000e+00, 5.813e+02, 0.000e+00 }, // FC
        { 4.937e+01, 3.787e+00, 2.393e+01, 0.000e+00, 0.000e+00, 1.327e+01, 0.000e+00 }, // NOx
        { 2.798e+00, 4.692e-02, 2.452e-01, 1.499e-03, 1.161e-04, 0.000e+00, 8.962e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-III_(DPF)
        { 3.196e+03, 7.249e+02, 1.476e+03, 0.000e+00, 0.000e+00, 1.827e+03, 0.000e+00 }, // CO2(total)
        { 6.157e+00, 0.000e+00, 2.114e+00, 0.000e+00, 8.337e-05, 0.000e+00, 1.283e-02 }, // CO
        { 1.066e+00, 0.000e+00, 1.445e-01, 0.000e+00, 5.663e-05, 0.000e+00, 4.930e-03 }, // HC
        { 1.027e+03, 2.330e+02, 4.742e+02, 0.000e+00, 0.000e+00, 5.871e+02, 0.000e+00 }, // FC
        { 4.937e+01, 3.787e+00, 2.393e+01, 0.000e+00, 0.000e+00, 1.327e+01, 0.000e+00 }, // NOx
        { 1.794e+00, 1.646e-02, 6.375e-02, 3.897e-04, 1.161e-04, 0.000e+00, 2.436e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-IV_EGR
        { 2.687e+03, 7.324e+02, 1.754e+03, 0.000e+00, 0.000e+00, 1.820e+03, 0.000e+00 }, // CO2(total)
        { 1.014e+01, 2.255e-01, 1.319e+01, 0.000e+00, 0.000e+00, 4.954e-01, 0.000e+00 }, // CO
        { 3.653e-01, 2.118e-02, 5.792e-01, 0.000e+00, 3.877e-05, 1.999e-02, 4.164e-04 }, // HC
        { 8.636e+02, 2.354e+02, 5.638e+02, 0.000e+00, 0.000e+00, 5.849e+02, 0.000e+00 }, // FC
        { 4.877e+01, 1.979e+00, 6.222e+01, 0.000e+00, 0.000e+00, 6.357e+00, 0.000e+00 }, // NOx
        { 1.864e+00, 6.321e-03, 4.503e-01, 0.000e+00, 1.443e-04, 0.000e+00, 1.130e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-IV_SCR
        { 2.773e+03, 7.057e+02, 2.134e+03, 0.000e+00, 0.000e+00, 1.728e+03, 0.000e+00 }, // CO2(total)
        { 2.754e+01, 0.000e+00, 4.827e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.442e-01, 3.058e-03, 1.727e-01, 9.535e-04, 0.000e+00, 0.000e+00, 1.713e-03 }, // HC
        { 8.911e+02, 2.268e+02, 6.858e+02, 0.000e+00, 0.000e+00, 5.554e+02, 0.000e+00 }, // FC
        { 3.281e+01, 1.038e+00, 0.000e+00, 2.942e-02, 0.000e+00, 3.610e+00, 8.450e-02 }, // NOx
        { 1.992e+00, 8.294e-04, 6.590e-01, 0.000e+00, 1.475e-04, 1.646e-02, 6.752e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-IV_SCRs
        { 2.773e+03, 7.057e+02, 2.134e+03, 0.000e+00, 0.000e+00, 1.728e+03, 0.000e+00 }, // CO2(total)
        { 2.754e+01, 0.000e+00, 4.827e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.442e-01, 3.058e-03, 1.727e-01, 9.535e-04, 0.000e+00, 0.000e+00, 1.713e-03 }, // HC
        { 8.911e+02, 2.268e+02, 6.858e+02, 0.000e+00, 0.000e+00, 5.554e+02, 0.000e+00 }, // FC
        { 5.138e+01, 5.087e+00, 4.511e+01, 0.000e+00, 0.000e+00, 1.456e+01, 0.000e+00 }, // NOx
        { 1.992e+00, 8.294e-04, 6.590e-01, 0.000e+00, 1.475e-04, 1.646e-02, 6.752e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-IV_EGR_(DPF)
        { 2.746e+03, 7.485e+02, 1.793e+03, 0.000e+00, 0.000e+00, 1.860e+03, 0.000e+00 }, // CO2(total)
        { 1.724e+00, 3.833e-02, 2.243e+00, 0.000e+00, 0.000e+00, 8.421e-02, 0.000e+00 }, // CO
        { 1.826e-02, 1.059e-03, 2.896e-02, 0.000e+00, 1.938e-06, 9.997e-04, 2.082e-05 }, // HC
        { 8.826e+02, 2.406e+02, 5.762e+02, 0.000e+00, 0.000e+00, 5.978e+02, 0.000e+00 }, // FC
        { 4.877e+01, 1.979e+00, 6.222e+01, 0.000e+00, 0.000e+00, 6.357e+00, 0.000e+00 }, // NOx
        { 1.463e+00, 6.321e-03, 3.152e-02, 0.000e+00, 1.178e-04, 0.000e+00, 2.166e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-IV_SCR_(DPF)
        { 2.834e+03, 7.213e+02, 2.181e+03, 0.000e+00, 0.000e+00, 1.766e+03, 0.000e+00 }, // CO2(total)
        { 4.683e+00, 0.000e+00, 8.206e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.209e-03, 1.529e-04, 8.635e-03, 4.768e-05, 0.000e+00, 0.000e+00, 8.564e-05 }, // HC
        { 9.107e+02, 2.318e+02, 7.009e+02, 0.000e+00, 0.000e+00, 5.676e+02, 0.000e+00 }, // FC
        { 3.281e+01, 1.038e+00, 0.000e+00, 2.942e-02, 0.000e+00, 3.610e+00, 8.450e-02 }, // NOx
        { 1.478e+00, 8.294e-04, 2.636e-02, 0.000e+00, 1.246e-04, 6.585e-04, 6.752e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-IV_SCRs_(DPF)
        { 2.834e+03, 7.213e+02, 2.181e+03, 0.000e+00, 0.000e+00, 1.766e+03, 0.000e+00 }, // CO2(total)
        { 4.683e+00, 0.000e+00, 8.206e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.209e-03, 1.529e-04, 8.635e-03, 4.768e-05, 0.000e+00, 0.000e+00, 8.564e-05 }, // HC
        { 9.107e+02, 2.318e+02, 7.009e+02, 0.000e+00, 0.000e+00, 5.676e+02, 0.000e+00 }, // FC
        { 5.138e+01, 5.087e+00, 4.511e+01, 0.000e+00, 0.000e+00, 1.456e+01, 0.000e+00 }, // NOx
        { 1.478e+00, 8.294e-04, 2.636e-02, 0.000e+00, 1.246e-04, 6.585e-04, 6.752e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-V_EGR
        { 2.708e+03, 6.864e+02, 2.282e+03, 0.000e+00, 0.000e+00, 1.697e+03, 0.000e+00 }, // CO2(total)
        { 8.872e+00, 0.000e+00, 1.117e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.757e-01, 3.307e-02, 4.211e-01, 0.000e+00, 3.428e-05, 7.963e-02, 0.000e+00 }, // HC
        { 8.704e+02, 2.206e+02, 7.335e+02, 0.000e+00, 0.000e+00, 5.452e+02, 0.000e+00 }, // FC
        { 4.323e+01, 1.334e+00, 8.117e+01, 0.000e+00, 0.000e+00, 2.046e+00, 0.000e+00 }, // NOx
        { 1.592e+00, 9.658e-03, 1.891e-01, 1.083e-03, 1.227e-04, 0.000e+00, 2.654e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-V_SCR
        { 2.645e+03, 6.701e+02, 2.210e+03, 0.000e+00, 0.000e+00, 1.651e+03, 0.000e+00 }, // CO2(total)
        { 2.794e+01, 0.000e+00, 5.108e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.416e-01, 3.683e-03, 5.926e-02, 9.487e-04, 0.000e+00, 3.404e-02, 0.000e+00 }, // HC
        { 8.499e+02, 2.154e+02, 7.103e+02, 0.000e+00, 0.000e+00, 5.307e+02, 0.000e+00 }, // FC
        { 2.686e+01, 4.541e-01, 0.000e+00, 3.210e-03, 0.000e+00, 4.871e-02, 1.033e-01 }, // NOx
        { 1.959e+00, 7.786e-03, 8.410e-01, 0.000e+00, 1.433e-04, 0.000e+00, 3.998e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-V_SCRs
        { 2.645e+03, 6.701e+02, 2.210e+03, 0.000e+00, 0.000e+00, 1.651e+03, 0.000e+00 }, // CO2(total)
        { 2.794e+01, 0.000e+00, 5.108e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.416e-01, 3.683e-03, 5.926e-02, 9.487e-04, 0.000e+00, 3.404e-02, 0.000e+00 }, // HC
        { 8.499e+02, 2.154e+02, 7.103e+02, 0.000e+00, 0.000e+00, 5.307e+02, 0.000e+00 }, // FC
        { 5.270e+01, 4.763e+00, 4.571e+01, 0.000e+00, 0.000e+00, 1.371e+01, 0.000e+00 }, // NOx
        { 1.959e+00, 7.786e-03, 8.410e-01, 0.000e+00, 1.433e-04, 0.000e+00, 3.998e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-V_EGR_(DPF)
        { 2.768e+03, 7.015e+02, 2.333e+03, 0.000e+00, 0.000e+00, 1.734e+03, 0.000e+00 }, // CO2(total)
        { 1.508e+00, 0.000e+00, 1.899e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.879e-02, 1.653e-03, 2.105e-02, 0.000e+00, 1.714e-06, 3.981e-03, 0.000e+00 }, // HC
        { 8.895e+02, 2.255e+02, 7.497e+02, 0.000e+00, 0.000e+00, 5.572e+02, 0.000e+00 }, // FC
        { 4.323e+01, 1.334e+00, 8.117e+01, 0.000e+00, 0.000e+00, 2.046e+00, 0.000e+00 }, // NOx
        { 1.466e+00, 1.743e-03, 1.324e-02, 7.584e-05, 1.227e-04, 0.000e+00, 2.396e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-V_SCR_(DPF)
        { 2.703e+03, 6.849e+02, 2.259e+03, 0.000e+00, 0.000e+00, 1.688e+03, 0.000e+00 }, // CO2(total)
        { 4.749e+00, 0.000e+00, 8.683e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.082e-03, 1.842e-04, 2.963e-03, 4.744e-05, 0.000e+00, 1.702e-03, 0.000e+00 }, // HC
        { 8.686e+02, 2.201e+02, 7.260e+02, 0.000e+00, 0.000e+00, 5.424e+02, 0.000e+00 }, // FC
        { 2.686e+01, 4.541e-01, 0.000e+00, 3.210e-03, 0.000e+00, 4.871e-02, 1.033e-01 }, // NOx
        { 1.474e+00, 3.114e-04, 3.364e-02, 0.000e+00, 1.258e-04, 0.000e+00, 3.998e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-V_SCRs_(DPF)
        { 2.703e+03, 6.849e+02, 2.259e+03, 0.000e+00, 0.000e+00, 1.688e+03, 0.000e+00 }, // CO2(total)
        { 4.749e+00, 0.000e+00, 8.683e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.082e-03, 1.842e-04, 2.963e-03, 4.744e-05, 0.000e+00, 1.702e-03, 0.000e+00 }, // HC
        { 8.686e+02, 2.201e+02, 7.260e+02, 0.000e+00, 0.000e+00, 5.424e+02, 0.000e+00 }, // FC
        { 5.270e+01, 4.763e+00, 4.571e+01, 0.000e+00, 0.000e+00, 1.371e+01, 0.000e+00 }, // NOx
        { 1.474e+00, 3.114e-04, 3.364e-02, 0.000e+00, 1.258e-04, 0.000e+00, 3.998e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-VI_A-C
        { 2.775e+03, 6.510e+02, 2.643e+03, 0.000e+00, 0.000e+00, 1.627e+03, 0.000e+00 }, // CO2(total)
        { 2.079e+00, 0.000e+00, 1.816e+00, 1.405e-03, 1.217e-05, 0.000e+00, 2.728e-03 }, // CO
        { 1.277e-01, 8.753e-03, 5.046e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.131e-03 }, // HC
        { 8.918e+02, 2.092e+02, 8.493e+02, 0.000e+00, 0.000e+00, 5.229e+02, 0.000e+00 }, // FC
        { 4.335e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.582e-04, 0.000e+00, 1.626e-02 }, // NOx
        { 1.487e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.739e-04, 0.000e+00, 1.711e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-VIs_A-C
        { 2.775e+03, 6.510e+02, 2.643e+03, 0.000e+00, 0.000e+00, 1.627e+03, 0.000e+00 }, // CO2(total)
        { 2.079e+00, 0.000e+00, 1.816e+00, 1.405e-03, 1.217e-05, 0.000e+00, 2.728e-03 }, // CO
        { 1.277e-01, 8.753e-03, 5.046e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.131e-03 }, // HC
        { 8.918e+02, 2.092e+02, 8.493e+02, 0.000e+00, 0.000e+00, 5.229e+02, 0.000e+00 }, // FC
        { 3.453e+01, 3.810e+00, 7.273e+01, 0.000e+00, 0.000e+00, 9.032e+00, 0.000e+00 }, // NOx
        { 1.487e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.739e-04, 0.000e+00, 1.711e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-VI_D-E
        { 2.471e+03, 6.651e+02, 2.176e+03, 0.000e+00, 0.000e+00, 1.651e+03, 0.000e+00 }, // CO2(total)
        { 6.469e-01, 0.000e+00, 5.184e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.044e-01, 0.000e+00, 0.000e+00, 0.000e+00, 7.896e-05, 0.000e+00, 0.000e+00 }, // HC
        { 7.941e+02, 2.138e+02, 6.993e+02, 0.000e+00, 0.000e+00, 5.304e+02, 0.000e+00 }, // FC
        { 1.960e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.055e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.466e+00, 4.514e-03, 1.026e-02, 1.045e-05, 1.199e-04, 2.134e-03, 1.646e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Euro-VIs_D-E
        { 2.471e+03, 6.651e+02, 2.176e+03, 0.000e+00, 0.000e+00, 1.651e+03, 0.000e+00 }, // CO2(total)
        { 6.469e-01, 0.000e+00, 5.184e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.044e-01, 0.000e+00, 0.000e+00, 0.000e+00, 7.896e-05, 0.000e+00, 0.000e+00 }, // HC
        { 7.941e+02, 2.138e+02, 6.993e+02, 0.000e+00, 0.000e+00, 5.304e+02, 0.000e+00 }, // FC
        { 4.982e+01, 3.224e+00, 1.028e+02, 0.000e+00, 0.000e+00, 7.296e+00, 0.000e+00 }, // NOx
        { 1.466e+00, 4.514e-03, 1.026e-02, 1.045e-05, 1.199e-04, 2.134e-03, 1.646e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_50ties
        { 5.721e+03, 8.999e+02, 4.222e+03, 0.000e+00, 0.000e+00, 2.486e+03, 0.000e+00 }, // CO2(total)
        { 3.043e+01, 2.940e-02, 1.394e+01, 1.319e-02, 0.000e+00, 8.160e-01, 5.074e-02 }, // CO
        { 8.305e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.382e-04, 0.000e+00, 2.802e-02 }, // HC
        { 1.839e+03, 2.892e+02, 1.357e+03, 0.000e+00, 0.000e+00, 7.990e+02, 0.000e+00 }, // FC
        { 9.973e+01, 1.137e+01, 8.470e+01, 0.000e+00, 0.000e+00, 3.487e+01, 0.000e+00 }, // NOx
        { 6.270e+00, 2.630e-01, 2.007e+00, 0.000e+00, 1.403e-04, 5.224e-01, 1.457e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_60ties
        { 5.721e+03, 8.999e+02, 4.222e+03, 0.000e+00, 0.000e+00, 2.486e+03, 0.000e+00 }, // CO2(total)
        { 3.043e+01, 2.940e-02, 1.394e+01, 1.319e-02, 0.000e+00, 8.160e-01, 5.074e-02 }, // CO
        { 8.305e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.382e-04, 0.000e+00, 2.802e-02 }, // HC
        { 1.839e+03, 2.892e+02, 1.357e+03, 0.000e+00, 0.000e+00, 7.990e+02, 0.000e+00 }, // FC
        { 9.973e+01, 1.137e+01, 8.470e+01, 0.000e+00, 0.000e+00, 3.487e+01, 0.000e+00 }, // NOx
        { 6.270e+00, 2.630e-01, 2.007e+00, 0.000e+00, 1.403e-04, 5.224e-01, 1.457e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_70ties
        { 5.721e+03, 8.999e+02, 4.222e+03, 0.000e+00, 0.000e+00, 2.486e+03, 0.000e+00 }, // CO2(total)
        { 3.043e+01, 2.940e-02, 1.394e+01, 1.319e-02, 0.000e+00, 8.160e-01, 5.074e-02 }, // CO
        { 8.305e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.382e-04, 0.000e+00, 2.802e-02 }, // HC
        { 1.839e+03, 2.892e+02, 1.357e+03, 0.000e+00, 0.000e+00, 7.990e+02, 0.000e+00 }, // FC
        { 9.973e+01, 1.137e+01, 8.470e+01, 0.000e+00, 0.000e+00, 3.487e+01, 0.000e+00 }, // NOx
        { 6.270e+00, 2.630e-01, 2.007e+00, 0.000e+00, 1.403e-04, 5.224e-01, 1.457e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_80ties
        { 5.721e+03, 8.999e+02, 4.222e+03, 0.000e+00, 0.000e+00, 2.486e+03, 0.000e+00 }, // CO2(total)
        { 3.043e+01, 2.940e-02, 1.394e+01, 1.319e-02, 0.000e+00, 8.160e-01, 5.074e-02 }, // CO
        { 8.305e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.382e-04, 0.000e+00, 2.802e-02 }, // HC
        { 1.839e+03, 2.892e+02, 1.357e+03, 0.000e+00, 0.000e+00, 7.990e+02, 0.000e+00 }, // FC
        { 9.973e+01, 1.137e+01, 8.470e+01, 0.000e+00, 0.000e+00, 3.487e+01, 0.000e+00 }, // NOx
        { 6.270e+00, 2.630e-01, 2.007e+00, 0.000e+00, 1.403e-04, 5.224e-01, 1.457e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-I
        { 5.648e+03, 8.660e+02, 4.762e+03, 0.000e+00, 0.000e+00, 2.356e+03, 0.000e+00 }, // CO2(total)
        { 2.583e+01, 2.948e-01, 1.442e+01, 0.000e+00, 0.000e+00, 2.271e+00, 0.000e+00 }, // CO
        { 7.057e+00, 0.000e+00, 5.691e-01, 8.723e-03, 2.753e-04, 0.000e+00, 5.483e-02 }, // HC
        { 1.815e+03, 2.783e+02, 1.530e+03, 0.000e+00, 0.000e+00, 7.573e+02, 0.000e+00 }, // FC
        { 8.370e+01, 6.073e+00, 8.153e+01, 0.000e+00, 0.000e+00, 2.076e+01, 0.000e+00 }, // NOx
        { 5.227e+00, 2.208e-01, 0.000e+00, 0.000e+00, 1.368e-04, 6.307e-01, 7.249e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-I_(DPF)
        { 5.705e+03, 8.747e+02, 4.809e+03, 0.000e+00, 0.000e+00, 2.380e+03, 0.000e+00 }, // CO2(total)
        { 8.522e+00, 9.730e-02, 4.760e+00, 0.000e+00, 0.000e+00, 7.495e-01, 0.000e+00 }, // CO
        { 2.329e+00, 0.000e+00, 1.878e-01, 2.879e-03, 9.084e-05, 0.000e+00, 1.809e-02 }, // HC
        { 1.833e+03, 2.811e+02, 1.546e+03, 0.000e+00, 0.000e+00, 7.649e+02, 0.000e+00 }, // FC
        { 8.370e+01, 6.073e+00, 8.153e+01, 0.000e+00, 0.000e+00, 2.076e+01, 0.000e+00 }, // NOx
        { 2.438e+00, 5.741e-02, 0.000e+00, 0.000e+00, 1.368e-04, 1.640e-01, 2.001e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-II
        { 5.483e+03, 8.298e+02, 4.931e+03, 0.000e+00, 0.000e+00, 2.229e+03, 0.000e+00 }, // CO2(total)
        { 2.099e+01, 6.414e-03, 1.366e+01, 0.000e+00, 0.000e+00, 6.660e-01, 2.298e-02 }, // CO
        { 4.418e+00, 0.000e+00, 7.508e-01, 7.629e-03, 0.000e+00, 0.000e+00, 2.942e-02 }, // HC
        { 1.762e+03, 2.667e+02, 1.585e+03, 0.000e+00, 0.000e+00, 7.162e+02, 0.000e+00 }, // FC
        { 8.993e+01, 5.398e+00, 9.442e+01, 0.000e+00, 0.000e+00, 1.852e+01, 0.000e+00 }, // NOx
        { 3.148e+00, 9.906e-02, 1.059e+00, 0.000e+00, 1.349e-04, 1.113e-01, 9.293e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-II_(DPF)
        { 5.538e+03, 8.381e+02, 4.980e+03, 0.000e+00, 0.000e+00, 2.251e+03, 0.000e+00 }, // CO2(total)
        { 6.928e+00, 2.117e-03, 4.507e+00, 0.000e+00, 0.000e+00, 2.198e-01, 7.584e-03 }, // CO
        { 1.458e+00, 0.000e+00, 2.478e-01, 2.518e-03, 0.000e+00, 0.000e+00, 9.709e-03 }, // HC
        { 1.780e+03, 2.693e+02, 1.601e+03, 0.000e+00, 0.000e+00, 7.234e+02, 0.000e+00 }, // FC
        { 8.993e+01, 5.398e+00, 9.442e+01, 0.000e+00, 0.000e+00, 1.852e+01, 0.000e+00 }, // NOx
        { 1.896e+00, 2.576e-02, 2.754e-01, 0.000e+00, 1.349e-04, 2.893e-02, 2.547e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-III
        { 5.624e+03, 8.295e+02, 5.427e+03, 0.000e+00, 0.000e+00, 2.161e+03, 0.000e+00 }, // CO2(total)
        { 2.552e+01, 0.000e+00, 1.987e+01, 0.000e+00, 0.000e+00, 9.079e-01, 0.000e+00 }, // CO
        { 4.095e+00, 0.000e+00, 4.805e-01, 0.000e+00, 2.386e-04, 0.000e+00, 2.446e-02 }, // HC
        { 1.807e+03, 2.666e+02, 1.744e+03, 0.000e+00, 0.000e+00, 6.946e+02, 0.000e+00 }, // FC
        { 8.080e+01, 3.724e+00, 8.232e+01, 0.000e+00, 0.000e+00, 1.440e+01, 0.000e+00 }, // NOx
        { 2.937e+00, 1.033e-01, 0.000e+00, 0.000e+00, 1.331e-04, 1.159e-01, 9.025e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-III_(DPF)
        { 5.680e+03, 8.378e+02, 5.482e+03, 0.000e+00, 0.000e+00, 2.183e+03, 0.000e+00 }, // CO2(total)
        { 8.423e+00, 0.000e+00, 6.557e+00, 0.000e+00, 0.000e+00, 2.996e-01, 0.000e+00 }, // CO
        { 1.351e+00, 0.000e+00, 1.586e-01, 0.000e+00, 7.874e-05, 0.000e+00, 8.071e-03 }, // HC
        { 1.826e+03, 2.692e+02, 1.762e+03, 0.000e+00, 0.000e+00, 7.015e+02, 0.000e+00 }, // FC
        { 8.080e+01, 3.724e+00, 8.232e+01, 0.000e+00, 0.000e+00, 1.440e+01, 0.000e+00 }, // NOx
        { 1.818e+00, 2.685e-02, 0.000e+00, 0.000e+00, 1.331e-04, 3.013e-02, 2.410e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-IV_EGR
        { 5.176e+03, 8.393e+02, 6.595e+03, 0.000e+00, 0.000e+00, 2.115e+03, 0.000e+00 }, // CO2(total)
        { 1.332e+01, 2.833e-01, 1.775e+01, 0.000e+00, 0.000e+00, 7.095e-01, 0.000e+00 }, // CO
        { 3.683e-01, 5.744e-02, 7.493e-01, 0.000e+00, 0.000e+00, 6.153e-02, 0.000e+00 }, // HC
        { 1.664e+03, 2.697e+02, 2.119e+03, 0.000e+00, 0.000e+00, 6.798e+02, 0.000e+00 }, // FC
        { 8.149e+01, 1.690e+00, 1.440e+02, 0.000e+00, 0.000e+00, 5.821e+00, 0.000e+00 }, // NOx
        { 1.883e+00, 2.400e-02, 5.684e-01, 0.000e+00, 1.406e-04, 3.780e-02, 7.696e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-IV_SCR
        { 5.029e+03, 8.416e+02, 6.205e+03, 0.000e+00, 0.000e+00, 2.115e+03, 0.000e+00 }, // CO2(total)
        { 3.516e+01, 0.000e+00, 6.793e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.521e-01, 1.510e-02, 2.322e-01, 9.656e-04, 0.000e+00, 1.105e-02, 2.254e-03 }, // HC
        { 1.616e+03, 2.705e+02, 1.994e+03, 0.000e+00, 0.000e+00, 6.796e+02, 0.000e+00 }, // FC
        { 4.024e+01, 2.166e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.505e+00, 8.813e-02 }, // NOx
        { 2.086e+00, 0.000e+00, 8.313e-01, 0.000e+00, 1.929e-04, 2.436e-02, 5.275e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-IV_SCRs
        { 5.029e+03, 8.416e+02, 6.205e+03, 0.000e+00, 0.000e+00, 2.115e+03, 0.000e+00 }, // CO2(total)
        { 3.516e+01, 0.000e+00, 6.793e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.521e-01, 1.510e-02, 2.322e-01, 9.656e-04, 0.000e+00, 1.105e-02, 2.254e-03 }, // HC
        { 1.616e+03, 2.705e+02, 1.994e+03, 0.000e+00, 0.000e+00, 6.796e+02, 0.000e+00 }, // FC
        { 8.530e+01, 5.241e+00, 1.009e+02, 0.000e+00, 0.000e+00, 1.663e+01, 0.000e+00 }, // NOx
        { 2.086e+00, 0.000e+00, 8.313e-01, 0.000e+00, 1.929e-04, 2.436e-02, 5.275e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-IV_EGR_(DPF)
        { 5.290e+03, 8.577e+02, 6.740e+03, 0.000e+00, 0.000e+00, 2.162e+03, 0.000e+00 }, // CO2(total)
        { 2.265e+00, 4.816e-02, 3.018e+00, 0.000e+00, 0.000e+00, 1.206e-01, 0.000e+00 }, // CO
        { 1.841e-02, 2.872e-03, 3.746e-02, 0.000e+00, 0.000e+00, 3.076e-03, 0.000e+00 }, // HC
        { 1.700e+03, 2.757e+02, 2.166e+03, 0.000e+00, 0.000e+00, 6.948e+02, 0.000e+00 }, // FC
        { 8.149e+01, 1.690e+00, 1.440e+02, 0.000e+00, 0.000e+00, 5.821e+00, 0.000e+00 }, // NOx
        { 1.455e+00, 1.680e-03, 3.979e-02, 0.000e+00, 1.342e-04, 2.646e-03, 2.049e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-IV_SCR_(DPF)
        { 5.140e+03, 8.601e+02, 6.342e+03, 0.000e+00, 0.000e+00, 2.161e+03, 0.000e+00 }, // CO2(total)
        { 5.977e+00, 0.000e+00, 1.155e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.605e-03, 7.548e-04, 1.161e-02, 4.828e-05, 0.000e+00, 5.526e-04, 1.127e-04 }, // HC
        { 1.652e+03, 2.764e+02, 2.038e+03, 0.000e+00, 0.000e+00, 6.946e+02, 0.000e+00 }, // FC
        { 4.024e+01, 2.166e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.505e+00, 8.813e-02 }, // NOx
        { 1.448e+00, 0.000e+00, 3.325e-02, 0.000e+00, 1.356e-04, 9.745e-04, 1.607e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-IV_SCRs_(DPF)
        { 5.140e+03, 8.601e+02, 6.342e+03, 0.000e+00, 0.000e+00, 2.161e+03, 0.000e+00 }, // CO2(total)
        { 5.977e+00, 0.000e+00, 1.155e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.605e-03, 7.548e-04, 1.161e-02, 4.828e-05, 0.000e+00, 5.526e-04, 1.127e-04 }, // HC
        { 1.652e+03, 2.764e+02, 2.038e+03, 0.000e+00, 0.000e+00, 6.946e+02, 0.000e+00 }, // FC
        { 8.530e+01, 5.241e+00, 1.009e+02, 0.000e+00, 0.000e+00, 1.663e+01, 0.000e+00 }, // NOx
        { 1.448e+00, 0.000e+00, 3.325e-02, 0.000e+00, 1.356e-04, 9.745e-04, 1.607e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-V_EGR
        { 4.868e+03, 8.245e+02, 6.334e+03, 0.000e+00, 0.000e+00, 2.073e+03, 0.000e+00 }, // CO2(total)
        { 1.291e+01, 0.000e+00, 1.763e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.026e-01, 3.494e-02, 6.059e-01, 0.000e+00, 7.801e-05, 1.008e-01, 0.000e+00 }, // HC
        { 1.564e+03, 2.650e+02, 2.036e+03, 0.000e+00, 0.000e+00, 6.663e+02, 0.000e+00 }, // FC
        { 5.772e+01, 1.524e+00, 1.066e+02, 0.000e+00, 0.000e+00, 2.375e+00, 0.000e+00 }, // NOx
        { 1.577e+00, 2.981e-02, 3.636e-01, 0.000e+00, 1.665e-04, 0.000e+00, 3.584e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-V_SCR
        { 4.740e+03, 8.139e+02, 6.079e+03, 0.000e+00, 0.000e+00, 2.046e+03, 0.000e+00 }, // CO2(total)
        { 3.308e+01, 0.000e+00, 5.883e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.388e-01, 1.669e-02, 1.245e-01, 9.959e-04, 0.000e+00, 4.405e-02, 0.000e+00 }, // HC
        { 1.523e+03, 2.616e+02, 1.954e+03, 0.000e+00, 0.000e+00, 6.575e+02, 0.000e+00 }, // FC
        { 3.482e+01, 6.186e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.582e-01, 1.337e-01 }, // NOx
        { 2.067e+00, 0.000e+00, 7.276e-01, 0.000e+00, 2.269e-04, 0.000e+00, 1.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-V_SCRs
        { 4.740e+03, 8.139e+02, 6.079e+03, 0.000e+00, 0.000e+00, 2.046e+03, 0.000e+00 }, // CO2(total)
        { 3.308e+01, 0.000e+00, 5.883e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.388e-01, 1.669e-02, 1.245e-01, 9.959e-04, 0.000e+00, 4.405e-02, 0.000e+00 }, // HC
        { 1.523e+03, 2.616e+02, 1.954e+03, 0.000e+00, 0.000e+00, 6.575e+02, 0.000e+00 }, // FC
        { 8.827e+01, 4.779e+00, 1.069e+02, 0.000e+00, 0.000e+00, 1.529e+01, 0.000e+00 }, // NOx
        { 2.067e+00, 0.000e+00, 7.276e-01, 0.000e+00, 2.269e-04, 0.000e+00, 1.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-V_EGR_(DPF)
        { 4.975e+03, 8.426e+02, 6.474e+03, 0.000e+00, 0.000e+00, 2.119e+03, 0.000e+00 }, // CO2(total)
        { 2.194e+00, 0.000e+00, 2.998e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.013e-02, 1.747e-03, 3.029e-02, 0.000e+00, 3.900e-06, 5.042e-03, 0.000e+00 }, // HC
        { 1.599e+03, 2.708e+02, 2.080e+03, 0.000e+00, 0.000e+00, 6.809e+02, 0.000e+00 }, // FC
        { 5.772e+01, 1.524e+00, 1.066e+02, 0.000e+00, 0.000e+00, 2.375e+00, 0.000e+00 }, // NOx
        { 1.439e+00, 2.087e-03, 2.545e-02, 0.000e+00, 1.337e-04, 0.000e+00, 4.019e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-V_SCR_(DPF)
        { 4.844e+03, 8.318e+02, 6.213e+03, 0.000e+00, 0.000e+00, 2.091e+03, 0.000e+00 }, // CO2(total)
        { 5.623e+00, 0.000e+00, 1.000e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.941e-03, 8.343e-04, 6.223e-03, 4.979e-05, 0.000e+00, 2.203e-03, 0.000e+00 }, // HC
        { 1.557e+03, 2.673e+02, 1.997e+03, 0.000e+00, 0.000e+00, 6.720e+02, 0.000e+00 }, // FC
        { 3.482e+01, 6.186e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.582e-01, 1.337e-01 }, // NOx
        { 1.457e+00, 0.000e+00, 2.910e-02, 0.000e+00, 1.342e-04, 0.000e+00, 1.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-V_SCRs_(DPF)
        { 4.844e+03, 8.318e+02, 6.213e+03, 0.000e+00, 0.000e+00, 2.091e+03, 0.000e+00 }, // CO2(total)
        { 5.623e+00, 0.000e+00, 1.000e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.941e-03, 8.343e-04, 6.223e-03, 4.979e-05, 0.000e+00, 2.203e-03, 0.000e+00 }, // HC
        { 1.557e+03, 2.673e+02, 1.997e+03, 0.000e+00, 0.000e+00, 6.720e+02, 0.000e+00 }, // FC
        { 8.827e+01, 4.779e+00, 1.069e+02, 0.000e+00, 0.000e+00, 1.529e+01, 0.000e+00 }, // NOx
        { 1.457e+00, 0.000e+00, 2.910e-02, 0.000e+00, 1.342e-04, 0.000e+00, 1.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-VI_A-C
        { 5.018e+03, 7.782e+02, 6.529e+03, 0.000e+00, 0.000e+00, 2.019e+03, 0.000e+00 }, // CO2(total)
        { 2.616e+00, 7.980e-02, 3.031e+00, 0.000e+00, 6.215e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.027e-01, 1.086e-02, 0.000e+00, 0.000e+00, 0.000e+00, 4.178e-02, 0.000e+00 }, // HC
        { 1.613e+03, 2.501e+02, 2.098e+03, 0.000e+00, 0.000e+00, 6.488e+02, 0.000e+00 }, // FC
        { 5.234e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.052e-03, 0.000e+00, 3.830e-02 }, // NOx
        { 1.432e+00, 6.455e-04, 0.000e+00, 0.000e+00, 2.528e-04, 0.000e+00, 4.927e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-VIs_A-C
        { 5.018e+03, 7.782e+02, 6.529e+03, 0.000e+00, 0.000e+00, 2.019e+03, 0.000e+00 }, // CO2(total)
        { 2.616e+00, 7.980e-02, 3.031e+00, 0.000e+00, 6.215e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.027e-01, 1.086e-02, 0.000e+00, 0.000e+00, 0.000e+00, 4.178e-02, 0.000e+00 }, // HC
        { 1.613e+03, 2.501e+02, 2.098e+03, 0.000e+00, 0.000e+00, 6.488e+02, 0.000e+00 }, // FC
        { 4.552e+01, 4.683e+00, 7.791e+01, 0.000e+00, 0.000e+00, 1.192e+01, 0.000e+00 }, // NOx
        { 1.432e+00, 6.455e-04, 0.000e+00, 0.000e+00, 2.528e-04, 0.000e+00, 4.927e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-VI_D-E
        { 7.752e+03, 4.582e+02, 1.136e+04, 0.000e+00, 0.000e+00, 1.473e+03, 0.000e+00 }, // CO2(total)
        { 8.926e-01, 0.000e+00, 1.283e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.220e-01, 1.144e-03, 0.000e+00, 0.000e+00, 1.041e-04, 0.000e+00, 0.000e+00 }, // HC
        { 2.491e+03, 1.472e+02, 3.652e+03, 0.000e+00, 0.000e+00, 4.735e+02, 0.000e+00 }, // FC
        { 2.719e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.304e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.458e+00, 2.579e-03, 9.054e-04, 0.000e+00, 1.273e-04, 6.884e-03, 8.211e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Euro-VIs_D-E
        { 7.752e+03, 4.582e+02, 1.136e+04, 0.000e+00, 0.000e+00, 1.473e+03, 0.000e+00 }, // CO2(total)
        { 8.926e-01, 0.000e+00, 1.283e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.220e-01, 1.144e-03, 0.000e+00, 0.000e+00, 1.041e-04, 0.000e+00, 0.000e+00 }, // HC
        { 2.491e+03, 1.472e+02, 3.652e+03, 0.000e+00, 0.000e+00, 4.735e+02, 0.000e+00 }, // FC
        { 6.581e+01, 4.091e+00, 1.296e+02, 0.000e+00, 0.000e+00, 9.332e+00, 0.000e+00 }, // NOx
        { 1.458e+00, 2.579e-03, 9.054e-04, 0.000e+00, 1.273e-04, 6.884e-03, 8.211e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_le18t_EE
        { 3.275e+03, 7.631e+02, 1.062e+03, 0.000e+00, 0.000e+00, 1.934e+03, 0.000e+00 }, // CO2(total)
        { 8.155e+01, 0.000e+00, 5.496e+01, 0.000e+00, 0.000e+00, 4.310e+00, 0.000e+00 }, // CO
        { 2.317e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.499e-02 }, // HC
        { 1.053e+03, 2.453e+02, 3.413e+02, 0.000e+00, 0.000e+00, 6.217e+02, 0.000e+00 }, // FC
        { 4.721e+01, 6.949e+00, 2.105e+01, 0.000e+00, 0.000e+00, 1.992e+01, 0.000e+00 }, // NOx
        { 1.348e+01, 6.254e-01, 0.000e+00, 0.000e+00, 1.291e-04, 2.232e+00, 2.416e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_EE
        { 5.721e+03, 8.999e+02, 4.222e+03, 0.000e+00, 0.000e+00, 2.486e+03, 0.000e+00 }, // CO2(total)
        { 6.086e+01, 5.879e-02, 2.788e+01, 2.639e-02, 0.000e+00, 1.632e+00, 1.015e-01 }, // CO
        { 1.661e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.276e-03, 0.000e+00, 5.604e-02 }, // HC
        { 1.839e+03, 2.892e+02, 1.357e+03, 0.000e+00, 0.000e+00, 7.990e+02, 0.000e+00 }, // FC
        { 4.987e+01, 5.686e+00, 4.235e+01, 0.000e+00, 0.000e+00, 1.743e+01, 0.000e+00 }, // NOx
        { 1.350e+01, 6.575e-01, 5.017e+00, 0.000e+00, 1.403e-04, 1.306e+00, 1.457e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_HEV_Euro-IV
        { 1.073e+03, 5.747e+02, 4.442e+03, 0.000e+00, 0.000e+00, 1.095e+03, 0.000e+00 }, // CO2(total)
        { 6.644e+00, 1.578e-01, 8.091e+00, 0.000e+00, 0.000e+00, 4.973e-01, 0.000e+00 }, // CO
        { 2.447e-01, 1.680e-02, 3.840e-01, 0.000e+00, 0.000e+00, 3.011e-02, 0.000e+00 }, // HC
        { 3.450e+02, 1.847e+02, 1.427e+03, 0.000e+00, 0.000e+00, 3.520e+02, 0.000e+00 }, // FC
        { 3.682e+01, 1.489e+00, 5.682e+01, 0.000e+00, 0.000e+00, 4.245e+00, 0.000e+00 }, // NOx
        { 1.719e+00, 8.845e-03, 3.689e-01, 0.000e+00, 1.186e-04, 1.392e-02, 1.924e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_HEV_Euro-V
        { 1.073e+03, 5.747e+02, 4.442e+03, 0.000e+00, 0.000e+00, 1.095e+03, 0.000e+00 }, // CO2(total)
        { 1.779e+01, 0.000e+00, 3.149e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.736e-02, 8.449e-03, 1.197e-01, 0.000e+00, 0.000e+00, 1.522e-02, 0.000e+00 }, // HC
        { 3.450e+02, 1.847e+02, 1.427e+03, 0.000e+00, 0.000e+00, 3.520e+02, 0.000e+00 }, // FC
        { 1.644e+01, 2.554e-01, 0.000e+00, 1.195e-02, 0.000e+00, 0.000e+00, 7.115e-02 }, // NOx
        { 1.758e+00, 5.258e-03, 5.151e-01, 0.000e+00, 1.186e-04, 1.753e-03, 1.924e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_HEV_Euro-VI_A-C
        { 1.026e+03, 5.684e+02, 4.443e+03, 0.000e+00, 0.000e+00, 1.089e+03, 0.000e+00 }, // CO2(total)
        { 1.470e+00, 9.025e-03, 2.304e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.841e-02, 4.468e-03, 7.981e-02, 0.000e+00, 0.000e+00, 9.800e-03, 0.000e+00 }, // HC
        { 3.296e+02, 1.827e+02, 1.428e+03, 0.000e+00, 0.000e+00, 3.500e+02, 0.000e+00 }, // FC
        { 1.638e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.502e+00, 4.473e-03, 1.429e-01, 0.000e+00, 1.197e-04, 0.000e+00, 2.557e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_HEV_Euro-VI_D-E
        { 1.026e+03, 5.684e+02, 4.443e+03, 0.000e+00, 0.000e+00, 1.089e+03, 0.000e+00 }, // CO2(total)
        { 1.470e+00, 9.025e-03, 2.304e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.841e-02, 4.468e-03, 7.981e-02, 0.000e+00, 0.000e+00, 9.800e-03, 0.000e+00 }, // HC
        { 3.296e+02, 1.827e+02, 1.428e+03, 0.000e+00, 0.000e+00, 3.500e+02, 0.000e+00 }, // FC
        { 1.638e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.502e+00, 4.473e-03, 1.429e-01, 0.000e+00, 1.197e-04, 0.000e+00, 2.557e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_HEV_Euro-IV
        { 3.700e+03, 5.403e+02, 1.073e+04, 0.000e+00, 0.000e+00, 1.076e+03, 0.000e+00 }, // CO2(total)
        { 6.644e+00, 1.578e-01, 8.091e+00, 0.000e+00, 0.000e+00, 4.973e-01, 0.000e+00 }, // CO
        { 2.447e-01, 1.680e-02, 3.840e-01, 0.000e+00, 0.000e+00, 3.011e-02, 0.000e+00 }, // HC
        { 1.189e+03, 1.736e+02, 3.447e+03, 0.000e+00, 0.000e+00, 3.458e+02, 0.000e+00 }, // FC
        { 3.682e+01, 1.489e+00, 5.682e+01, 0.000e+00, 0.000e+00, 4.245e+00, 0.000e+00 }, // NOx
        { 1.649e+00, 1.051e-02, 3.689e-01, 0.000e+00, 1.210e-04, 1.392e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_HEV_Euro-V
        { 3.700e+03, 5.403e+02, 1.073e+04, 0.000e+00, 0.000e+00, 1.076e+03, 0.000e+00 }, // CO2(total)
        { 2.460e+01, 0.000e+00, 4.076e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.117e-01, 9.429e-03, 4.935e-02, 7.591e-04, 0.000e+00, 3.473e-02, 0.000e+00 }, // HC
        { 1.189e+03, 1.736e+02, 3.447e+03, 0.000e+00, 0.000e+00, 3.458e+02, 0.000e+00 }, // FC
        { 2.694e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.373e-03, 0.000e+00, 1.231e-01 }, // NOx
        { 1.817e+00, 6.923e-03, 7.474e-01, 0.000e+00, 1.584e-04, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_HEV_Euro-VI_A-C
        { 3.635e+03, 5.299e+02, 1.076e+04, 0.000e+00, 0.000e+00, 1.054e+03, 0.000e+00 }, // CO2(total)
        { 1.978e+00, 1.663e-02, 1.632e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.017e-01, 9.340e-04, 5.993e-02, 0.000e+00, 0.000e+00, 1.164e-02, 0.000e+00 }, // HC
        { 1.168e+03, 1.703e+02, 3.460e+03, 0.000e+00, 0.000e+00, 3.386e+02, 0.000e+00 }, // FC
        { 2.544e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.856e-04, 0.000e+00, 1.291e-02 }, // NOx
        { 1.350e+00, 6.338e-03, 0.000e+00, 8.446e-04, 1.545e-04, 0.000e+00, 2.952e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_HEV_Euro-VI_D-E
        { 3.635e+03, 5.299e+02, 1.076e+04, 0.000e+00, 0.000e+00, 1.054e+03, 0.000e+00 }, // CO2(total)
        { 1.978e+00, 1.663e-02, 1.632e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.017e-01, 9.340e-04, 5.993e-02, 0.000e+00, 0.000e+00, 1.164e-02, 0.000e+00 }, // HC
        { 1.168e+03, 1.703e+02, 3.460e+03, 0.000e+00, 0.000e+00, 3.386e+02, 0.000e+00 }, // FC
        { 2.544e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.856e-04, 0.000e+00, 1.291e-02 }, // NOx
        { 1.350e+00, 6.338e-03, 0.000e+00, 8.446e-04, 1.545e-04, 0.000e+00, 2.952e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_HEV_Euro-IV
        { 6.699e+03, 4.523e+02, 1.593e+04, 0.000e+00, 0.000e+00, 1.016e+03, 0.000e+00 }, // CO2(total)
        { 1.332e+01, 2.833e-01, 1.775e+01, 0.000e+00, 0.000e+00, 7.095e-01, 0.000e+00 }, // CO
        { 3.683e-01, 5.744e-02, 7.493e-01, 0.000e+00, 0.000e+00, 6.153e-02, 0.000e+00 }, // HC
        { 2.153e+03, 1.454e+02, 5.119e+03, 0.000e+00, 0.000e+00, 3.264e+02, 0.000e+00 }, // FC
        { 8.149e+01, 1.690e+00, 1.440e+02, 0.000e+00, 0.000e+00, 5.821e+00, 0.000e+00 }, // NOx
        { 1.533e+00, 5.390e-02, 5.687e-01, 0.000e+00, 1.064e-04, 3.782e-02, 6.075e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_HEV_Euro-V
        { 6.699e+03, 4.523e+02, 1.593e+04, 0.000e+00, 0.000e+00, 1.016e+03, 0.000e+00 }, // CO2(total)
        { 2.645e+01, 0.000e+00, 3.726e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.810e-02, 2.400e-02, 9.875e-02, 7.087e-04, 0.000e+00, 4.288e-02, 0.000e+00 }, // HC
        { 2.153e+03, 1.454e+02, 5.119e+03, 0.000e+00, 0.000e+00, 3.264e+02, 0.000e+00 }, // FC
        { 3.207e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.197e-03, 0.000e+00, 1.862e-01 }, // NOx
        { 1.541e+00, 2.989e-02, 6.902e-01, 0.000e+00, 2.222e-04, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_HEV_Euro-VI_A-C
        { 6.569e+03, 4.464e+02, 1.586e+04, 0.000e+00, 0.000e+00, 9.987e+02, 0.000e+00 }, // CO2(total)
        { 2.688e+00, 0.000e+00, 1.606e+00, 0.000e+00, 1.800e-04, 0.000e+00, 0.000e+00 }, // CO
        { 2.770e-01, 0.000e+00, 1.316e-01, 0.000e+00, 0.000e+00, 1.431e-02, 0.000e+00 }, // HC
        { 2.111e+03, 1.435e+02, 5.099e+03, 0.000e+00, 0.000e+00, 3.210e+02, 0.000e+00 }, // FC
        { 1.374e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.998e-04, 0.000e+00, 2.836e-02 }, // NOx
        { 1.081e+00, 2.939e-02, 0.000e+00, 3.557e-03, 1.001e-04, 0.000e+00, 7.190e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_HEV_Euro-VI_D-E
        { 6.569e+03, 4.464e+02, 1.586e+04, 0.000e+00, 0.000e+00, 9.987e+02, 0.000e+00 }, // CO2(total)
        { 2.688e+00, 0.000e+00, 1.606e+00, 0.000e+00, 1.800e-04, 0.000e+00, 0.000e+00 }, // CO
        { 2.770e-01, 0.000e+00, 1.316e-01, 0.000e+00, 0.000e+00, 1.431e-02, 0.000e+00 }, // HC
        { 2.111e+03, 1.435e+02, 5.099e+03, 0.000e+00, 0.000e+00, 3.210e+02, 0.000e+00 }, // FC
        { 1.374e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.998e-04, 0.000e+00, 2.836e-02 }, // NOx
        { 1.081e+00, 2.939e-02, 0.000e+00, 3.557e-03, 1.001e-04, 0.000e+00, 7.190e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_CNG_Euro-II
        { 2.362e+03, 4.976e+02, 6.672e+02, 0.000e+00, 0.000e+00, 1.228e+03, 0.000e+00 }, // CO2(total)
        { 1.842e+01, 0.000e+00, 1.916e+01, 0.000e+00, 0.000e+00, 3.500e-01, 0.000e+00 }, // CO
        { 2.223e+01, 1.311e-01, 0.000e+00, 3.801e-02, 0.000e+00, 1.290e+00, 6.382e-02 }, // HC
        { 7.601e+02, 1.601e+02, 2.147e+02, 0.000e+00, 0.000e+00, 3.951e+02, 0.000e+00 }, // FC
        { 3.404e+01, 5.907e+00, 1.441e+01, 0.000e+00, 0.000e+00, 1.458e+01, 0.000e+00 }, // NOx
        { 1.547e+00, 6.640e-03, 5.099e-02, 0.000e+00, 1.226e-04, 1.219e-02, 5.063e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_CNG_Euro-III
        { 2.573e+03, 4.991e+02, 9.235e+02, 0.000e+00, 0.000e+00, 1.248e+03, 0.000e+00 }, // CO2(total)
        { 1.839e+01, 0.000e+00, 1.397e+01, 0.000e+00, 0.000e+00, 3.007e-01, 0.000e+00 }, // CO
        { 1.872e+01, 4.209e-01, 0.000e+00, 0.000e+00, 5.938e-04, 1.323e+00, 2.844e-02 }, // HC
        { 8.278e+02, 1.606e+02, 2.972e+02, 0.000e+00, 0.000e+00, 4.015e+02, 0.000e+00 }, // FC
        { 4.094e+01, 3.828e+00, 2.741e+01, 0.000e+00, 0.000e+00, 1.054e+01, 0.000e+00 }, // NOx
        { 1.469e+00, 9.396e-03, 0.000e+00, 0.000e+00, 1.208e-04, 9.501e-03, 4.824e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_CNG_Euro-IV
        { 2.125e+03, 5.031e+02, 1.972e+03, 0.000e+00, 0.000e+00, 1.180e+03, 0.000e+00 }, // CO2(total)
        { 7.973e+00, 1.894e-01, 9.709e+00, 0.000e+00, 0.000e+00, 5.968e-01, 0.000e+00 }, // CO
        { 2.937e+00, 2.016e-01, 4.608e+00, 0.000e+00, 0.000e+00, 3.613e-01, 0.000e+00 }, // HC
        { 6.838e+02, 1.619e+02, 6.347e+02, 0.000e+00, 0.000e+00, 3.798e+02, 0.000e+00 }, // FC
        { 4.786e+01, 1.936e+00, 7.386e+01, 0.000e+00, 0.000e+00, 5.518e+00, 0.000e+00 }, // NOx
        { 1.426e+00, 4.157e-03, 3.689e-02, 0.000e+00, 1.222e-04, 1.392e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_CNG_Euro-V
        { 2.217e+03, 5.485e+02, 2.057e+03, 0.000e+00, 0.000e+00, 1.267e+03, 0.000e+00 }, // CO2(total)
        { 1.647e+00, 4.075e-01, 1.528e+00, 0.000e+00, 0.000e+00, 9.410e-01, 0.000e+00 }, // CO
        { 7.772e-01, 1.923e-01, 7.209e-01, 0.000e+00, 0.000e+00, 4.440e-01, 0.000e+00 }, // HC
        { 7.135e+02, 1.765e+02, 6.618e+02, 0.000e+00, 0.000e+00, 4.076e+02, 0.000e+00 }, // FC
        { 2.996e+00, 7.411e-01, 2.779e+00, 0.000e+00, 0.000e+00, 1.711e+00, 0.000e+00 }, // NOx
        { 1.422e+00, 1.049e-02, 1.192e-02, 0.000e+00, 1.163e-04, 7.342e-03, 1.251e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_CNG_Euro-VI
        { 2.338e+03, 5.183e+02, 2.493e+03, 0.000e+00, 0.000e+00, 1.187e+03, 0.000e+00 }, // CO2(total)
        { 1.514e+00, 3.357e-01, 1.615e+00, 0.000e+00, 0.000e+00, 7.689e-01, 0.000e+00 }, // CO
        { 4.011e-01, 8.894e-02, 4.279e-01, 0.000e+00, 0.000e+00, 2.037e-01, 0.000e+00 }, // HC
        { 7.522e+02, 1.668e+02, 8.023e+02, 0.000e+00, 0.000e+00, 3.820e+02, 0.000e+00 }, // FC
        { 1.005e+00, 2.228e-01, 1.072e+00, 0.000e+00, 0.000e+00, 5.104e-01, 0.000e+00 }, // NOx
        { 1.416e+00, 7.700e-03, 1.445e-02, 0.000e+00, 1.217e-04, 6.881e-03, 8.769e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_CNG_Euro-II
        { 3.284e+03, 7.452e+02, 1.504e+03, 0.000e+00, 0.000e+00, 1.870e+03, 0.000e+00 }, // CO2(total)
        { 2.034e+01, 0.000e+00, 1.402e+01, 6.784e-03, 0.000e+00, 0.000e+00, 4.533e-02 }, // CO
        { 4.454e+01, 0.000e+00, 1.124e+01, 5.948e-02, 6.536e-04, 0.000e+00, 2.194e-01 }, // HC
        { 1.057e+03, 2.398e+02, 4.840e+02, 0.000e+00, 0.000e+00, 6.017e+02, 0.000e+00 }, // FC
        { 7.496e+01, 6.606e+00, 5.979e+01, 0.000e+00, 0.000e+00, 2.006e+01, 0.000e+00 }, // NOx
        { 1.596e+00, 1.020e-02, 1.130e-01, 1.354e-04, 1.195e-04, 3.773e-04, 1.177e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_CNG_Euro-III
        { 3.351e+03, 7.602e+02, 1.547e+03, 0.000e+00, 0.000e+00, 1.916e+03, 0.000e+00 }, // CO2(total)
        { 2.280e+01, 0.000e+00, 7.828e+00, 0.000e+00, 3.087e-04, 0.000e+00, 4.751e-02 }, // CO
        { 4.017e+01, 0.000e+00, 5.445e+00, 0.000e+00, 2.134e-03, 0.000e+00, 1.858e-01 }, // HC
        { 1.078e+03, 2.446e+02, 4.979e+02, 0.000e+00, 0.000e+00, 6.165e+02, 0.000e+00 }, // FC
        { 6.513e+01, 4.996e+00, 3.156e+01, 0.000e+00, 0.000e+00, 1.750e+01, 0.000e+00 }, // NOx
        { 1.579e+00, 9.927e-03, 2.487e-02, 1.520e-04, 1.161e-04, 0.000e+00, 1.038e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_CNG_Euro-IV
        { 2.846e+03, 7.758e+02, 1.858e+03, 0.000e+00, 0.000e+00, 1.928e+03, 0.000e+00 }, // CO2(total)
        { 1.217e+01, 2.706e-01, 1.583e+01, 0.000e+00, 0.000e+00, 5.944e-01, 0.000e+00 }, // CO
        { 4.383e+00, 2.541e-01, 6.951e+00, 0.000e+00, 4.652e-04, 2.399e-01, 4.997e-03 }, // HC
        { 9.159e+02, 2.496e+02, 5.979e+02, 0.000e+00, 0.000e+00, 6.204e+02, 0.000e+00 }, // FC
        { 6.340e+01, 2.573e+00, 8.088e+01, 0.000e+00, 0.000e+00, 8.264e+00, 0.000e+00 }, // NOx
        { 1.476e+00, 6.321e-03, 4.505e-02, 0.000e+00, 1.187e-04, 0.000e+00, 2.461e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_CNG_Euro-V
        { 2.942e+03, 7.272e+02, 2.407e+03, 0.000e+00, 0.000e+00, 1.799e+03, 0.000e+00 }, // CO2(total)
        { 2.186e+00, 5.402e-01, 1.788e+00, 0.000e+00, 0.000e+00, 1.336e+00, 0.000e+00 }, // CO
        { 1.031e+00, 2.549e-01, 8.435e-01, 0.000e+00, 0.000e+00, 6.304e-01, 0.000e+00 }, // HC
        { 9.467e+02, 2.340e+02, 7.744e+02, 0.000e+00, 0.000e+00, 5.787e+02, 0.000e+00 }, // FC
        { 3.975e+00, 9.824e-01, 3.251e+00, 0.000e+00, 0.000e+00, 2.430e+00, 0.000e+00 }, // NOx
        { 1.475e+00, 4.215e-03, 1.395e-02, 0.000e+00, 1.247e-04, 1.043e-02, 3.820e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_CNG_Euro-VI
        { 3.001e+03, 7.103e+02, 2.739e+03, 0.000e+00, 0.000e+00, 1.779e+03, 0.000e+00 }, // CO2(total)
        { 1.944e+00, 4.600e-01, 1.774e+00, 0.000e+00, 0.000e+00, 1.152e+00, 0.000e+00 }, // CO
        { 5.151e-01, 1.219e-01, 4.701e-01, 0.000e+00, 0.000e+00, 3.053e-01, 0.000e+00 }, // HC
        { 9.657e+02, 2.286e+02, 8.815e+02, 0.000e+00, 0.000e+00, 5.725e+02, 0.000e+00 }, // FC
        { 1.290e+00, 3.054e-01, 1.178e+00, 0.000e+00, 0.000e+00, 7.649e-01, 0.000e+00 }, // NOx
        { 1.477e+00, 4.117e-03, 1.588e-02, 0.000e+00, 1.242e-04, 1.031e-02, 2.051e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_CNG_Euro-II
        { 5.808e+03, 8.789e+02, 5.223e+03, 0.000e+00, 0.000e+00, 2.361e+03, 0.000e+00 }, // CO2(total)
        { 2.584e+01, 7.895e-03, 1.681e+01, 0.000e+00, 0.000e+00, 8.198e-01, 2.829e-02 }, // CO
        { 5.667e+01, 0.000e+00, 9.630e+00, 9.785e-02, 0.000e+00, 0.000e+00, 3.773e-01 }, // HC
        { 1.869e+03, 2.828e+02, 1.681e+03, 0.000e+00, 0.000e+00, 7.596e+02, 0.000e+00 }, // FC
        { 1.191e+02, 7.147e+00, 1.250e+02, 0.000e+00, 0.000e+00, 2.452e+01, 0.000e+00 }, // NOx
        { 1.632e+00, 1.033e-02, 1.105e-01, 0.000e+00, 1.349e-04, 1.161e-02, 1.128e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_CNG_Euro-III
        { 5.957e+03, 8.786e+02, 5.749e+03, 0.000e+00, 0.000e+00, 2.289e+03, 0.000e+00 }, // CO2(total)
        { 3.119e+01, 0.000e+00, 2.428e+01, 0.000e+00, 0.000e+00, 1.110e+00, 0.000e+00 }, // CO
        { 5.093e+01, 0.000e+00, 5.976e+00, 0.000e+00, 2.967e-03, 0.000e+00, 3.041e-01 }, // HC
        { 1.917e+03, 2.827e+02, 1.850e+03, 0.000e+00, 0.000e+00, 7.366e+02, 0.000e+00 }, // FC
        { 1.066e+02, 4.913e+00, 1.086e+02, 0.000e+00, 0.000e+00, 1.900e+01, 0.000e+00 }, // NOx
        { 1.578e+00, 1.047e-02, 0.000e+00, 0.000e+00, 1.331e-04, 1.175e-02, 9.920e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_CNG_Euro-IV
        { 5.483e+03, 8.890e+02, 6.985e+03, 0.000e+00, 0.000e+00, 2.241e+03, 0.000e+00 }, // CO2(total)
        { 1.599e+01, 3.399e-01, 2.130e+01, 0.000e+00, 0.000e+00, 8.514e-01, 0.000e+00 }, // CO
        { 4.419e+00, 6.892e-01, 8.991e+00, 0.000e+00, 0.000e+00, 7.383e-01, 0.000e+00 }, // HC
        { 1.764e+03, 2.860e+02, 2.248e+03, 0.000e+00, 0.000e+00, 7.209e+02, 0.000e+00 }, // FC
        { 1.059e+02, 2.197e+00, 1.872e+02, 0.000e+00, 0.000e+00, 7.567e+00, 0.000e+00 }, // NOx
        { 1.469e+00, 2.401e-03, 5.687e-02, 0.000e+00, 1.344e-04, 3.782e-03, 2.231e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_CNG_Euro-V
        { 5.219e+03, 8.839e+02, 6.599e+03, 0.000e+00, 0.000e+00, 2.229e+03, 0.000e+00 }, // CO2(total)
        { 3.877e+00, 6.567e-01, 4.903e+00, 0.000e+00, 0.000e+00, 1.656e+00, 0.000e+00 }, // CO
        { 1.829e+00, 3.098e-01, 2.313e+00, 0.000e+00, 0.000e+00, 7.814e-01, 0.000e+00 }, // HC
        { 1.679e+03, 2.844e+02, 2.123e+03, 0.000e+00, 0.000e+00, 7.173e+02, 0.000e+00 }, // FC
        { 7.051e+00, 1.194e+00, 8.916e+00, 0.000e+00, 0.000e+00, 3.012e+00, 0.000e+00 }, // NOx
        { 1.463e+00, 5.124e-03, 3.825e-02, 0.000e+00, 1.302e-04, 1.292e-02, 1.420e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_CNG_Euro-VI
        { 5.434e+03, 8.496e+02, 6.996e+03, 0.000e+00, 0.000e+00, 2.206e+03, 0.000e+00 }, // CO2(total)
        { 3.519e+00, 5.502e-01, 4.531e+00, 0.000e+00, 0.000e+00, 1.428e+00, 0.000e+00 }, // CO
        { 9.325e-01, 1.458e-01, 1.201e+00, 0.000e+00, 0.000e+00, 3.785e-01, 0.000e+00 }, // HC
        { 1.748e+03, 2.734e+02, 2.251e+03, 0.000e+00, 0.000e+00, 7.097e+02, 0.000e+00 }, // FC
        { 2.336e+00, 3.653e-01, 3.008e+00, 0.000e+00, 0.000e+00, 9.483e-01, 0.000e+00 }, // NOx
        { 1.468e+00, 5.226e-03, 4.056e-02, 0.000e+00, 1.271e-04, 1.279e-02, 8.791e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_Ethanol_Euro-II
        { 3.875e+03, 8.163e+02, 1.095e+03, 0.000e+00, 0.000e+00, 2.014e+03, 0.000e+00 }, // CO2(total)
        { 1.535e+01, 0.000e+00, 1.597e+01, 0.000e+00, 0.000e+00, 2.917e-01, 0.000e+00 }, // CO
        { 1.806e+01, 1.065e-01, 0.000e+00, 3.088e-02, 0.000e+00, 1.048e+00, 5.186e-02 }, // HC
        { 2.011e+03, 4.235e+02, 5.679e+02, 0.000e+00, 0.000e+00, 1.045e+03, 0.000e+00 }, // FC
        { 2.226e+01, 3.862e+00, 9.420e+00, 0.000e+00, 0.000e+00, 9.535e+00, 0.000e+00 }, // NOx
        { 2.154e+00, 1.660e-02, 2.550e-01, 0.000e+00, 1.226e-04, 6.095e-02, 5.063e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_Ethanol_Euro-III
        { 4.221e+03, 8.189e+02, 1.515e+03, 0.000e+00, 0.000e+00, 2.047e+03, 0.000e+00 }, // CO2(total)
        { 1.533e+01, 0.000e+00, 1.164e+01, 0.000e+00, 0.000e+00, 2.505e-01, 0.000e+00 }, // CO
        { 1.521e+01, 3.420e-01, 0.000e+00, 0.000e+00, 4.824e-04, 1.075e+00, 2.311e-02 }, // HC
        { 2.190e+03, 4.248e+02, 7.861e+02, 0.000e+00, 0.000e+00, 1.062e+03, 0.000e+00 }, // FC
        { 2.677e+01, 2.503e+00, 1.792e+01, 0.000e+00, 0.000e+00, 6.889e+00, 0.000e+00 }, // NOx
        { 1.861e+00, 2.224e-02, 0.000e+00, 0.000e+00, 1.208e-04, 4.750e-02, 4.824e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_Ethanol_Euro-IV
        { 3.487e+03, 8.254e+02, 3.236e+03, 0.000e+00, 0.000e+00, 1.937e+03, 0.000e+00 }, // CO2(total)
        { 6.644e+00, 1.578e-01, 8.091e+00, 0.000e+00, 0.000e+00, 4.973e-01, 0.000e+00 }, // CO
        { 2.386e+00, 1.638e-01, 3.744e+00, 0.000e+00, 0.000e+00, 2.935e-01, 0.000e+00 }, // HC
        { 1.809e+03, 4.283e+02, 1.679e+03, 0.000e+00, 0.000e+00, 1.005e+03, 0.000e+00 }, // FC
        { 3.129e+01, 1.266e+00, 4.830e+01, 0.000e+00, 0.000e+00, 3.608e+00, 0.000e+00 }, // NOx
        { 1.548e+00, 5.591e-03, 1.844e-01, 0.000e+00, 1.222e-04, 6.959e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_Ethanol_Euro-V
        { 3.191e+03, 8.220e+02, 2.698e+03, 0.000e+00, 0.000e+00, 1.959e+03, 0.000e+00 }, // CO2(total)
        { 5.666e+00, 0.000e+00, 1.040e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.375e+00, 1.924e-01, 1.867e+00, 0.000e+00, 6.145e-05, 5.364e-01, 0.000e+00 }, // HC
        { 1.655e+03, 4.265e+02, 1.400e+03, 0.000e+00, 0.000e+00, 1.017e+03, 0.000e+00 }, // FC
        { 2.445e+01, 6.105e-01, 3.585e+01, 0.000e+00, 0.000e+00, 1.766e+00, 0.000e+00 }, // NOx
        { 1.426e+00, 7.402e-03, 6.060e-03, 3.454e-04, 1.221e-04, 1.276e-02, 5.159e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_Ethanol_Euro-VI
        { 3.445e+03, 7.669e+02, 3.783e+03, 0.000e+00, 0.000e+00, 1.827e+03, 0.000e+00 }, // CO2(total)
        { 1.512e+00, 5.087e-03, 2.157e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.577e-01, 5.267e-02, 4.599e-01, 0.000e+00, 0.000e+00, 1.220e-01, 0.000e+00 }, // HC
        { 1.787e+03, 3.979e+02, 1.963e+03, 0.000e+00, 0.000e+00, 9.480e+02, 0.000e+00 }, // FC
        { 2.544e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.109e-03 }, // NOx
        { 1.427e+00, 5.087e-03, 6.626e-02, 0.000e+00, 1.217e-04, 0.000e+00, 5.885e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Ethanol_Euro-II
        { 5.388e+03, 1.223e+03, 2.468e+03, 0.000e+00, 0.000e+00, 3.068e+03, 0.000e+00 }, // CO2(total)
        { 1.695e+01, 0.000e+00, 1.169e+01, 5.653e-03, 0.000e+00, 0.000e+00, 3.777e-02 }, // CO
        { 3.619e+01, 0.000e+00, 9.131e+00, 4.833e-02, 5.311e-04, 0.000e+00, 1.782e-01 }, // HC
        { 2.795e+03, 6.343e+02, 1.280e+03, 0.000e+00, 0.000e+00, 1.592e+03, 0.000e+00 }, // FC
        { 4.901e+01, 4.319e+00, 3.909e+01, 0.000e+00, 0.000e+00, 1.311e+01, 0.000e+00 }, // NOx
        { 2.198e+00, 3.194e-02, 5.650e-01, 6.771e-04, 1.195e-04, 1.886e-03, 5.012e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Ethanol_Euro-III
        { 5.498e+03, 1.247e+03, 2.539e+03, 0.000e+00, 0.000e+00, 3.143e+03, 0.000e+00 }, // CO2(total)
        { 1.900e+01, 0.000e+00, 6.523e+00, 0.000e+00, 2.573e-04, 0.000e+00, 3.959e-02 }, // CO
        { 3.264e+01, 0.000e+00, 4.424e+00, 0.000e+00, 1.734e-03, 0.000e+00, 1.510e-01 }, // HC
        { 2.852e+03, 6.470e+02, 1.317e+03, 0.000e+00, 0.000e+00, 1.631e+03, 0.000e+00 }, // FC
        { 4.258e+01, 3.266e+00, 2.064e+01, 0.000e+00, 0.000e+00, 1.144e+01, 0.000e+00 }, // NOx
        { 2.130e+00, 2.663e-02, 1.243e-01, 7.600e-04, 1.161e-04, 0.000e+00, 4.615e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Ethanol_Euro-IV
        { 4.670e+03, 1.273e+03, 3.048e+03, 0.000e+00, 0.000e+00, 3.163e+03, 0.000e+00 }, // CO2(total)
        { 1.014e+01, 2.255e-01, 1.319e+01, 0.000e+00, 0.000e+00, 4.954e-01, 0.000e+00 }, // CO
        { 3.561e+00, 2.065e-01, 5.647e+00, 0.000e+00, 3.780e-04, 1.949e-01, 4.060e-03 }, // HC
        { 2.423e+03, 6.603e+02, 1.582e+03, 0.000e+00, 0.000e+00, 1.641e+03, 0.000e+00 }, // FC
        { 4.146e+01, 1.682e+00, 5.288e+01, 0.000e+00, 0.000e+00, 5.403e+00, 0.000e+00 }, // NOx
        { 1.649e+00, 6.321e-03, 2.252e-01, 0.000e+00, 1.301e-04, 0.000e+00, 6.390e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Ethanol_Euro-V
        { 4.706e+03, 1.193e+03, 3.966e+03, 0.000e+00, 0.000e+00, 2.948e+03, 0.000e+00 }, // CO2(total)
        { 8.872e+00, 0.000e+00, 1.117e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.613e+00, 3.224e-01, 4.105e+00, 0.000e+00, 3.342e-04, 7.764e-01, 0.000e+00 }, // HC
        { 2.442e+03, 6.188e+02, 2.058e+03, 0.000e+00, 0.000e+00, 1.530e+03, 0.000e+00 }, // FC
        { 3.674e+01, 1.134e+00, 6.899e+01, 0.000e+00, 0.000e+00, 1.739e+00, 0.000e+00 }, // NOx
        { 1.525e+00, 5.402e-03, 9.456e-02, 5.417e-04, 1.227e-04, 0.000e+00, 1.356e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_Ethanol_Euro-VI
        { 4.822e+03, 1.131e+03, 4.592e+03, 0.000e+00, 0.000e+00, 2.827e+03, 0.000e+00 }, // CO2(total)
        { 2.079e+00, 0.000e+00, 1.816e+00, 1.405e-03, 1.217e-05, 0.000e+00, 2.728e-03 }, // CO
        { 1.245e+00, 8.534e-02, 4.919e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.103e-02 }, // HC
        { 2.502e+03, 5.869e+02, 2.383e+03, 0.000e+00, 0.000e+00, 1.467e+03, 0.000e+00 }, // FC
        { 3.685e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.595e-04, 0.000e+00, 1.382e-02 }, // NOx
        { 1.473e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.491e-04, 0.000e+00, 8.662e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Ethanol_Euro-II
        { 9.528e+03, 1.442e+03, 8.569e+03, 0.000e+00, 0.000e+00, 3.873e+03, 0.000e+00 }, // CO2(total)
        { 2.153e+01, 6.579e-03, 1.401e+01, 0.000e+00, 0.000e+00, 6.831e-01, 2.357e-02 }, // CO
        { 4.604e+01, 0.000e+00, 7.824e+00, 7.950e-02, 0.000e+00, 0.000e+00, 3.066e-01 }, // HC
        { 4.943e+03, 7.481e+02, 4.446e+03, 0.000e+00, 0.000e+00, 2.009e+03, 0.000e+00 }, // FC
        { 7.785e+01, 4.673e+00, 8.174e+01, 0.000e+00, 0.000e+00, 1.603e+01, 0.000e+00 }, // NOx
        { 2.339e+00, 5.167e-02, 5.525e-01, 0.000e+00, 1.349e-04, 5.803e-02, 4.932e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Ethanol_Euro-III
        { 9.773e+03, 1.441e+03, 9.431e+03, 0.000e+00, 0.000e+00, 3.756e+03, 0.000e+00 }, // CO2(total)
        { 2.600e+01, 0.000e+00, 2.024e+01, 0.000e+00, 0.000e+00, 9.247e-01, 0.000e+00 }, // CO
        { 4.138e+01, 0.000e+00, 4.855e+00, 0.000e+00, 2.411e-03, 0.000e+00, 2.471e-01 }, // HC
        { 5.071e+03, 7.478e+02, 4.893e+03, 0.000e+00, 0.000e+00, 1.948e+03, 0.000e+00 }, // FC
        { 6.970e+01, 3.212e+00, 7.100e+01, 0.000e+00, 0.000e+00, 1.242e+01, 0.000e+00 }, // NOx
        { 2.191e+00, 5.236e-02, 0.000e+00, 0.000e+00, 1.331e-04, 5.876e-02, 4.618e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Ethanol_Euro-IV
        { 8.995e+03, 1.458e+03, 1.146e+04, 0.000e+00, 0.000e+00, 3.676e+03, 0.000e+00 }, // CO2(total)
        { 1.332e+01, 2.833e-01, 1.775e+01, 0.000e+00, 0.000e+00, 7.095e-01, 0.000e+00 }, // CO
        { 3.591e+00, 5.600e-01, 7.305e+00, 0.000e+00, 0.000e+00, 5.999e-01, 0.000e+00 }, // HC
        { 4.667e+03, 7.566e+02, 5.945e+03, 0.000e+00, 0.000e+00, 1.907e+03, 0.000e+00 }, // FC
        { 6.926e+01, 1.437e+00, 1.224e+02, 0.000e+00, 0.000e+00, 4.948e+00, 0.000e+00 }, // NOx
        { 1.653e+00, 1.200e-02, 2.843e-01, 0.000e+00, 1.372e-04, 1.891e-02, 4.661e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Ethanol_Euro-V
        { 8.458e+03, 1.433e+03, 1.101e+04, 0.000e+00, 0.000e+00, 3.603e+03, 0.000e+00 }, // CO2(total)
        { 1.291e+01, 0.000e+00, 1.763e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.825e+00, 3.407e-01, 5.907e+00, 0.000e+00, 7.606e-04, 9.832e-01, 0.000e+00 }, // HC
        { 4.388e+03, 7.433e+02, 5.711e+03, 0.000e+00, 0.000e+00, 1.869e+03, 0.000e+00 }, // FC
        { 4.906e+01, 1.295e+00, 9.059e+01, 0.000e+00, 0.000e+00, 2.019e+00, 0.000e+00 }, // NOx
        { 1.503e+00, 1.491e-02, 1.818e-01, 0.000e+00, 1.489e-04, 0.000e+00, 1.873e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_Ethanol_Euro-VI
        { 8.720e+03, 1.352e+03, 1.134e+04, 0.000e+00, 0.000e+00, 3.508e+03, 0.000e+00 }, // CO2(total)
        { 2.616e+00, 7.980e-02, 3.031e+00, 0.000e+00, 6.215e-05, 0.000e+00, 0.000e+00 }, // CO
        { 1.976e+00, 1.059e-01, 0.000e+00, 0.000e+00, 0.000e+00, 4.074e-01, 0.000e+00 }, // HC
        { 4.524e+03, 7.016e+02, 5.886e+03, 0.000e+00, 0.000e+00, 1.820e+03, 0.000e+00 }, // FC
        { 4.449e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.939e-04, 0.000e+00, 3.256e-02 }, // NOx
        { 1.432e+00, 6.455e-04, 0.000e+00, 0.000e+00, 1.898e-04, 0.000e+00, 2.507e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_FuelCell_Midi_lt15t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 1.940e+02, 2.749e+01, 9.302e+01, 7.792e-01, 0.000e+00, 1.330e+02, 9.029e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 7.938e-01, 5.622e-02, 0.000e+00, 0.000e+00, 7.323e-05, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_FuelCell_Std_gt15-18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 2.998e+02, 4.793e+01, 1.308e+02, 0.000e+00, 0.000e+00, 2.110e+02, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.197e+00, 1.400e-02, 0.000e+00, 0.000e+00, 1.205e-04, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_FuelCell_Artic_gt18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 5.849e+02, 5.149e+01, 2.805e+02, 0.000e+00, 0.000e+00, 3.044e+02, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.326e+00, 1.445e-02, 0.000e+00, 0.000e+00, 1.079e-04, 0.000e+00, 5.091e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Electric_Midi_lt15t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 7.938e-01, 5.622e-02, 0.000e+00, 0.000e+00, 7.323e-05, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 3.503e+00, 4.964e-01, 1.680e+00, 1.407e-02, 0.000e+00, 2.401e+00, 1.630e-02 }, // FC_MJ
    },
    {
        // UBus_Electric_Std_gt15-18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.197e+00, 1.400e-02, 0.000e+00, 0.000e+00, 1.205e-04, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 5.412e+00, 8.654e-01, 2.362e+00, 0.000e+00, 0.000e+00, 3.810e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Electric_Artic_gt18t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.326e+00, 1.445e-02, 0.000e+00, 0.000e+00, 1.079e-04, 0.000e+00, 5.091e-06 }, // PM + PM (non-exhaust)
        { 1.056e+01, 9.296e-01, 5.064e+00, 0.000e+00, 0.000e+00, 5.496e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_LNG_Euro-IV
        { 2.125e+03, 5.031e+02, 1.972e+03, 0.000e+00, 0.000e+00, 1.180e+03, 0.000e+00 }, // CO2(total)
        { 7.973e+00, 1.894e-01, 9.709e+00, 0.000e+00, 0.000e+00, 5.968e-01, 0.000e+00 }, // CO
        { 2.937e+00, 2.016e-01, 4.608e+00, 0.000e+00, 0.000e+00, 3.613e-01, 0.000e+00 }, // HC
        { 6.838e+02, 1.619e+02, 6.347e+02, 0.000e+00, 0.000e+00, 3.798e+02, 0.000e+00 }, // FC
        { 4.786e+01, 1.936e+00, 7.386e+01, 0.000e+00, 0.000e+00, 5.518e+00, 0.000e+00 }, // NOx
        { 1.426e+00, 4.157e-03, 3.689e-02, 0.000e+00, 1.222e-04, 1.392e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_LNG_Euro-V
        { 2.217e+03, 5.485e+02, 2.057e+03, 0.000e+00, 0.000e+00, 1.267e+03, 0.000e+00 }, // CO2(total)
        { 1.647e+00, 4.075e-01, 1.528e+00, 0.000e+00, 0.000e+00, 9.410e-01, 0.000e+00 }, // CO
        { 7.772e-01, 1.923e-01, 7.209e-01, 0.000e+00, 0.000e+00, 4.440e-01, 0.000e+00 }, // HC
        { 7.135e+02, 1.765e+02, 6.618e+02, 0.000e+00, 0.000e+00, 4.076e+02, 0.000e+00 }, // FC
        { 2.996e+00, 7.411e-01, 2.779e+00, 0.000e+00, 0.000e+00, 1.711e+00, 0.000e+00 }, // NOx
        { 1.422e+00, 1.049e-02, 1.192e-02, 0.000e+00, 1.163e-04, 7.342e-03, 1.251e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Midi_lt15t_LNG_Euro-VI
        { 2.338e+03, 5.183e+02, 2.493e+03, 0.000e+00, 0.000e+00, 1.187e+03, 0.000e+00 }, // CO2(total)
        { 1.514e+00, 3.357e-01, 1.615e+00, 0.000e+00, 0.000e+00, 7.689e-01, 0.000e+00 }, // CO
        { 4.011e-01, 8.894e-02, 4.279e-01, 0.000e+00, 0.000e+00, 2.037e-01, 0.000e+00 }, // HC
        { 7.522e+02, 1.668e+02, 8.023e+02, 0.000e+00, 0.000e+00, 3.820e+02, 0.000e+00 }, // FC
        { 1.005e+00, 2.228e-01, 1.072e+00, 0.000e+00, 0.000e+00, 5.104e-01, 0.000e+00 }, // NOx
        { 1.416e+00, 7.700e-03, 1.445e-02, 0.000e+00, 1.217e-04, 6.881e-03, 8.769e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_LNG_Euro-IV
        { 2.846e+03, 7.758e+02, 1.858e+03, 0.000e+00, 0.000e+00, 1.928e+03, 0.000e+00 }, // CO2(total)
        { 1.217e+01, 2.706e-01, 1.583e+01, 0.000e+00, 0.000e+00, 5.944e-01, 0.000e+00 }, // CO
        { 4.383e+00, 2.541e-01, 6.951e+00, 0.000e+00, 4.652e-04, 2.399e-01, 4.997e-03 }, // HC
        { 9.159e+02, 2.496e+02, 5.979e+02, 0.000e+00, 0.000e+00, 6.204e+02, 0.000e+00 }, // FC
        { 6.340e+01, 2.573e+00, 8.088e+01, 0.000e+00, 0.000e+00, 8.264e+00, 0.000e+00 }, // NOx
        { 1.476e+00, 6.321e-03, 4.505e-02, 0.000e+00, 1.187e-04, 0.000e+00, 2.461e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_LNG_Euro-V
        { 2.942e+03, 7.272e+02, 2.407e+03, 0.000e+00, 0.000e+00, 1.799e+03, 0.000e+00 }, // CO2(total)
        { 2.186e+00, 5.402e-01, 1.788e+00, 0.000e+00, 0.000e+00, 1.336e+00, 0.000e+00 }, // CO
        { 1.031e+00, 2.549e-01, 8.435e-01, 0.000e+00, 0.000e+00, 6.304e-01, 0.000e+00 }, // HC
        { 9.467e+02, 2.340e+02, 7.744e+02, 0.000e+00, 0.000e+00, 5.787e+02, 0.000e+00 }, // FC
        { 3.975e+00, 9.824e-01, 3.251e+00, 0.000e+00, 0.000e+00, 2.430e+00, 0.000e+00 }, // NOx
        { 1.475e+00, 4.215e-03, 1.395e-02, 0.000e+00, 1.247e-04, 1.043e-02, 3.820e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Std_gt15-18t_LNG_Euro-VI
        { 3.001e+03, 7.103e+02, 2.739e+03, 0.000e+00, 0.000e+00, 1.779e+03, 0.000e+00 }, // CO2(total)
        { 1.944e+00, 4.600e-01, 1.774e+00, 0.000e+00, 0.000e+00, 1.152e+00, 0.000e+00 }, // CO
        { 5.151e-01, 1.219e-01, 4.701e-01, 0.000e+00, 0.000e+00, 3.053e-01, 0.000e+00 }, // HC
        { 9.657e+02, 2.286e+02, 8.815e+02, 0.000e+00, 0.000e+00, 5.725e+02, 0.000e+00 }, // FC
        { 1.290e+00, 3.054e-01, 1.178e+00, 0.000e+00, 0.000e+00, 7.649e-01, 0.000e+00 }, // NOx
        { 1.477e+00, 4.117e-03, 1.588e-02, 0.000e+00, 1.242e-04, 1.031e-02, 2.051e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_LNG_Euro-IV
        { 5.483e+03, 8.890e+02, 6.985e+03, 0.000e+00, 0.000e+00, 2.241e+03, 0.000e+00 }, // CO2(total)
        { 1.599e+01, 3.399e-01, 2.130e+01, 0.000e+00, 0.000e+00, 8.514e-01, 0.000e+00 }, // CO
        { 4.419e+00, 6.892e-01, 8.991e+00, 0.000e+00, 0.000e+00, 7.383e-01, 0.000e+00 }, // HC
        { 1.764e+03, 2.860e+02, 2.248e+03, 0.000e+00, 0.000e+00, 7.209e+02, 0.000e+00 }, // FC
        { 1.059e+02, 2.197e+00, 1.872e+02, 0.000e+00, 0.000e+00, 7.567e+00, 0.000e+00 }, // NOx
        { 1.469e+00, 2.401e-03, 5.687e-02, 0.000e+00, 1.344e-04, 3.782e-03, 2.231e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_LNG_Euro-V
        { 5.219e+03, 8.839e+02, 6.599e+03, 0.000e+00, 0.000e+00, 2.229e+03, 0.000e+00 }, // CO2(total)
        { 3.877e+00, 6.567e-01, 4.903e+00, 0.000e+00, 0.000e+00, 1.656e+00, 0.000e+00 }, // CO
        { 1.829e+00, 3.098e-01, 2.313e+00, 0.000e+00, 0.000e+00, 7.814e-01, 0.000e+00 }, // HC
        { 1.679e+03, 2.844e+02, 2.123e+03, 0.000e+00, 0.000e+00, 7.173e+02, 0.000e+00 }, // FC
        { 7.051e+00, 1.194e+00, 8.916e+00, 0.000e+00, 0.000e+00, 3.012e+00, 0.000e+00 }, // NOx
        { 1.463e+00, 5.124e-03, 3.825e-02, 0.000e+00, 1.302e-04, 1.292e-02, 1.420e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // UBus_Artic_gt18t_LNG_Euro-VI
        { 5.434e+03, 8.496e+02, 6.996e+03, 0.000e+00, 0.000e+00, 2.206e+03, 0.000e+00 }, // CO2(total)
        { 3.519e+00, 5.502e-01, 4.531e+00, 0.000e+00, 0.000e+00, 1.428e+00, 0.000e+00 }, // CO
        { 9.325e-01, 1.458e-01, 1.201e+00, 0.000e+00, 0.000e+00, 3.785e-01, 0.000e+00 }, // HC
        { 1.748e+03, 2.734e+02, 2.251e+03, 0.000e+00, 0.000e+00, 7.097e+02, 0.000e+00 }, // FC
        { 2.336e+00, 3.653e-01, 3.008e+00, 0.000e+00, 0.000e+00, 9.483e-01, 0.000e+00 }, // NOx
        { 1.468e+00, 5.226e-03, 4.056e-02, 0.000e+00, 1.271e-04, 1.279e-02, 8.791e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_le250cc_preEuro
        { 2.341e+02, 7.359e+00, 0.000e+00, 5.950e-01, 4.597e-02, 2.631e+01, 4.983e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 5.561e+00, 0.000e+00, 3.299e-02, 0.000e+00, 2.437e-01 }, // CO
        { 0.000e+00, 0.000e+00, 3.450e+00, 3.055e-02, 6.113e-04, 0.000e+00, 4.842e-03 }, // HC
        { 7.588e+01, 2.386e+00, 0.000e+00, 1.929e-01, 1.490e-02, 8.530e+00, 1.615e-01 }, // FC
        { 1.448e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.411e-04, 5.638e-02, 9.110e-03 }, // NOx
        { 1.356e-01, 1.417e-03, 0.000e+00, 0.000e+00, 4.238e-05, 5.803e-03, 1.297e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_le250cc_Euro-1
        { 2.123e+02, 6.676e+00, 0.000e+00, 5.398e-01, 4.170e-02, 2.387e+01, 4.520e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 3.806e+00, 0.000e+00, 2.258e-02, 0.000e+00, 1.668e-01 }, // CO
        { 0.000e+00, 0.000e+00, 2.272e+00, 2.012e-02, 4.026e-04, 0.000e+00, 3.188e-03 }, // HC
        { 6.883e+01, 2.164e+00, 0.000e+00, 1.750e-01, 1.352e-02, 7.738e+00, 1.465e-01 }, // FC
        { 1.346e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.099e-04, 5.240e-02, 8.467e-03 }, // NOx
        { 1.356e-01, 1.417e-03, 0.000e+00, 0.000e+00, 4.238e-05, 5.803e-03, 1.297e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_le250cc_Euro-2
        { 2.345e+02, 7.373e+00, 0.000e+00, 5.962e-01, 4.605e-02, 2.636e+01, 4.992e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 3.745e+00, 0.000e+00, 2.222e-02, 0.000e+00, 1.641e-01 }, // CO
        { 0.000e+00, 0.000e+00, 1.498e+00, 1.327e-02, 2.654e-04, 0.000e+00, 2.102e-03 }, // HC
        { 7.602e+01, 2.390e+00, 0.000e+00, 1.933e-01, 1.493e-02, 8.546e+00, 1.618e-01 }, // FC
        { 1.180e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.594e-04, 4.594e-02, 7.423e-03 }, // NOx
        { 1.356e-01, 1.417e-03, 0.000e+00, 0.000e+00, 1.059e-05, 1.451e-03, 3.242e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_le250cc_Euro-3
        { 2.290e+02, 7.200e+00, 0.000e+00, 5.821e-01, 4.497e-02, 2.574e+01, 4.875e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 6.359e-01, 0.000e+00, 3.773e-03, 0.000e+00, 2.787e-02 }, // CO
        { 0.000e+00, 0.000e+00, 3.029e-01, 2.682e-03, 5.367e-05, 0.000e+00, 4.251e-04 }, // HC
        { 7.424e+01, 2.334e+00, 0.000e+00, 1.887e-01, 1.458e-02, 8.345e+00, 1.580e-01 }, // FC
        { 3.884e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.183e-04, 1.512e-02, 2.443e-03 }, // NOx
        { 1.356e-01, 1.417e-03, 0.000e+00, 0.000e+00, 1.059e-05, 1.451e-03, 3.242e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_le250cc_Euro-4
        { 2.285e+02, 1.167e+01, 1.939e+02, 0.000e+00, 5.939e-02, 3.960e-01, 1.255e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.898e-03, 0.000e+00, 4.835e-02 }, // CO
        { 0.000e+00, 2.555e-03, 0.000e+00, 4.321e-03, 0.000e+00, 0.000e+00, 1.378e-03 }, // HC
        { 7.408e+01, 3.784e+00, 6.284e+01, 0.000e+00, 1.925e-02, 1.284e-01, 4.067e-01 }, // FC
        { 0.000e+00, 3.025e-02, 3.726e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 2.402e-01, 1.589e-03, 1.454e-01, 0.000e+00, 0.000e+00, 2.718e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_le250cc_Euro-5
        { 2.285e+02, 1.167e+01, 1.939e+02, 0.000e+00, 5.939e-02, 3.960e-01, 1.255e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.544e-03, 0.000e+00, 4.243e-02 }, // CO
        { 0.000e+00, 1.504e-03, 0.000e+00, 2.543e-03, 0.000e+00, 0.000e+00, 8.114e-04 }, // HC
        { 7.408e+01, 3.784e+00, 6.284e+01, 0.000e+00, 1.925e-02, 1.284e-01, 4.067e-01 }, // FC
        { 0.000e+00, 2.018e-02, 2.486e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 2.402e-01, 1.589e-03, 1.454e-01, 0.000e+00, 0.000e+00, 2.718e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_le250cc_Euro-6
        { 2.285e+02, 1.167e+01, 1.939e+02, 0.000e+00, 5.939e-02, 3.960e-01, 1.255e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.544e-03, 0.000e+00, 4.243e-02 }, // CO
        { 0.000e+00, 1.504e-03, 0.000e+00, 2.543e-03, 0.000e+00, 0.000e+00, 8.114e-04 }, // HC
        { 7.408e+01, 3.784e+00, 6.284e+01, 0.000e+00, 1.925e-02, 1.284e-01, 4.067e-01 }, // FC
        { 0.000e+00, 2.018e-02, 2.486e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 2.402e-01, 1.589e-03, 1.454e-01, 0.000e+00, 0.000e+00, 2.718e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_gt250cc_preEuro
        { 1.405e+03, 0.000e+00, 7.442e+02, 2.350e+00, 2.944e-02, 0.000e+00, 6.179e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.699e-02, 0.000e+00, 2.318e-01 }, // CO
        { 2.344e+01, 1.366e-01, 0.000e+00, 0.000e+00, 0.000e+00, 5.577e-01, 0.000e+00 }, // HC
        { 4.556e+02, 0.000e+00, 2.413e+02, 7.620e-01, 9.544e-03, 0.000e+00, 2.003e-01 }, // FC
        { 5.242e-01, 0.000e+00, 0.000e+00, 1.004e-02, 6.851e-06, 1.337e-01, 1.821e-03 }, // NOx
        { 4.903e-01, 4.170e-03, 8.529e-02, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_gt250cc_Euro-1
        { 1.347e+03, 0.000e+00, 7.130e+02, 2.252e+00, 2.821e-02, 0.000e+00, 5.920e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.681e-02, 0.000e+00, 1.444e-01 }, // CO
        { 1.164e+01, 6.781e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.768e-01, 0.000e+00 }, // HC
        { 4.365e+02, 0.000e+00, 2.312e+02, 7.301e-01, 9.144e-03, 0.000e+00, 1.919e-01 }, // FC
        { 5.015e-01, 0.000e+00, 0.000e+00, 9.602e-03, 6.554e-06, 1.279e-01, 1.742e-03 }, // NOx
        { 4.903e-01, 4.170e-03, 8.529e-02, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_gt250cc_Euro-2
        { 1.292e+03, 0.000e+00, 6.839e+02, 2.160e+00, 2.706e-02, 0.000e+00, 5.679e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.808e-03, 0.000e+00, 8.425e-02 }, // CO
        { 9.865e+00, 5.748e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.347e-01, 0.000e+00 }, // HC
        { 4.187e+02, 0.000e+00, 2.217e+02, 7.003e-01, 8.771e-03, 0.000e+00, 1.841e-01 }, // FC
        { 6.618e-01, 0.000e+00, 0.000e+00, 1.267e-02, 8.649e-06, 1.688e-01, 2.299e-03 }, // NOx
        { 2.303e-01, 1.475e-03, 2.132e-02, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_gt250cc_Euro-3
        { 1.363e+03, 0.000e+00, 7.216e+02, 2.279e+00, 2.855e-02, 0.000e+00, 5.991e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.059e-03, 0.000e+00, 9.097e-03 }, // CO
        { 2.362e+00, 1.376e-02, 0.000e+00, 0.000e+00, 0.000e+00, 5.618e-02, 0.000e+00 }, // HC
        { 4.417e+02, 0.000e+00, 2.339e+02, 7.388e-01, 9.254e-03, 0.000e+00, 1.942e-01 }, // FC
        { 1.507e-01, 0.000e+00, 0.000e+00, 2.885e-03, 1.969e-06, 3.842e-02, 5.235e-04 }, // NOx
        { 2.303e-01, 1.475e-03, 2.132e-02, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_gt250cc_Euro-4
        { 1.008e+03, 0.000e+00, 3.401e+01, 1.062e+00, 7.482e-02, 2.541e+01, 1.053e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.221e-03, 0.000e+00, 1.436e-02 }, // CO
        { 4.186e-02, 0.000e+00, 1.447e-02, 2.041e-03, 0.000e+00, 1.827e-02, 0.000e+00 }, // HC
        { 3.268e+02, 0.000e+00, 1.102e+01, 3.443e-01, 2.425e-02, 8.236e+00, 3.414e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.923e-05, 1.280e-03, 1.118e-03 }, // NOx
        { 2.206e-01, 1.962e-03, 0.000e+00, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_gt250cc_Euro-5
        { 1.008e+03, 0.000e+00, 3.401e+01, 1.062e+00, 7.482e-02, 2.541e+01, 1.053e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.072e-03, 0.000e+00, 1.260e-02 }, // CO
        { 2.464e-02, 0.000e+00, 8.519e-03, 1.202e-03, 0.000e+00, 1.075e-02, 0.000e+00 }, // HC
        { 3.268e+02, 0.000e+00, 1.102e+01, 3.443e-01, 2.425e-02, 8.236e+00, 3.414e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.952e-05, 8.542e-04, 7.457e-04 }, // NOx
        { 2.206e-01, 1.962e-03, 0.000e+00, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_4S_gt250cc_Euro-6
        { 1.008e+03, 0.000e+00, 3.401e+01, 1.062e+00, 7.482e-02, 2.541e+01, 1.053e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.072e-03, 0.000e+00, 1.260e-02 }, // CO
        { 2.464e-02, 0.000e+00, 8.519e-03, 1.202e-03, 0.000e+00, 1.075e-02, 0.000e+00 }, // HC
        { 3.268e+02, 0.000e+00, 1.102e+01, 3.443e-01, 2.425e-02, 8.236e+00, 3.414e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.952e-05, 8.542e-04, 7.457e-04 }, // NOx
        { 2.206e-01, 1.962e-03, 0.000e+00, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_(vlt30)_without_cat
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 9.038e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.639e-01, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.970e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.850e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.880e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_(vlt30)_with_cat___FAV4
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.200e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.371e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.880e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_(vlt30)_EU2
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.003e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.067e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.640e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_(vlt30)_EU3
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 1.238e-30, 0.000e+00, 3.203e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.454e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.912e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_(vlt30)_EU4
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 1.238e-30, 0.000e+00, 3.203e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.963e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.530e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_(vlt30)_EU5
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.242e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.668e-03, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.802e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_preEuro
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 2.476e-30, 0.000e+00, 9.000e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.126e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.061e-03, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_Euro-1
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 2.476e-30, 0.000e+00, 9.000e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.126e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.061e-03, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_Euro-2
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.996e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.076e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 8.490e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_Euro-3
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.204e-02, 1.485e-31, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.461e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.792e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_Euro-4
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.204e-02, 1.485e-31, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.963e-02, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.434e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // Moped_le50cc_Euro-5
        { 0.000e+00, 0.000e+00, 1.980e-29, 0.000e+00, 8.393e-01, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 6.189e-31, 0.000e+00, 2.250e-02, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.690e-03, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.647e-01, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.714e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 3.000e-03, 1.857e-32, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_2S_le250cc_preEuro
        { 3.464e+02, 1.089e+01, 0.000e+00, 8.806e-01, 6.803e-02, 3.894e+01, 7.374e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 7.064e+00, 0.000e+00, 4.191e-02, 0.000e+00, 3.095e-01 }, // CO
        { 0.000e+00, 0.000e+00, 2.348e+01, 2.079e-01, 4.160e-03, 0.000e+00, 3.295e-02 }, // HC
        { 1.092e+02, 3.434e+00, 0.000e+00, 2.777e-01, 2.145e-02, 1.228e+01, 2.325e-01 }, // FC
        { 3.380e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.029e-04, 1.316e-02, 2.126e-03 }, // NOx
        { 1.356e-01, 2.014e-01, 0.000e+00, 0.000e+00, 1.682e-19, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_2S_le250cc_Euro-1
        { 3.252e+02, 1.023e+01, 0.000e+00, 8.268e-01, 6.387e-02, 3.656e+01, 6.924e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 6.041e+00, 0.000e+00, 3.584e-02, 0.000e+00, 2.647e-01 }, // CO
        { 0.000e+00, 0.000e+00, 1.331e+01, 1.179e-01, 2.360e-03, 0.000e+00, 1.869e-02 }, // HC
        { 1.026e+02, 3.225e+00, 0.000e+00, 2.607e-01, 2.014e-02, 1.153e+01, 2.183e-01 }, // FC
        { 2.595e-01, 0.000e+00, 0.000e+00, 0.000e+00, 7.900e-05, 1.010e-02, 1.632e-03 }, // NOx
        { 1.356e-01, 8.142e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_2S_le250cc_Euro-2
        { 2.806e+02, 8.821e+00, 0.000e+00, 7.132e-01, 5.510e-02, 3.154e+01, 5.972e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 4.868e+00, 0.000e+00, 2.888e-02, 0.000e+00, 2.133e-01 }, // CO
        { 0.000e+00, 0.000e+00, 6.568e+00, 5.817e-02, 1.164e-03, 0.000e+00, 9.218e-03 }, // HC
        { 8.847e+01, 2.782e+00, 0.000e+00, 2.249e-01, 1.738e-02, 9.946e+00, 1.883e-01 }, // FC
        { 3.133e-01, 0.000e+00, 0.000e+00, 0.000e+00, 9.541e-05, 1.220e-02, 1.971e-03 }, // NOx
        { 1.356e-01, 4.142e-02, 0.000e+00, 0.000e+00, 0.000e+00, 1.691e-18, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_2S_le250cc_Euro-3
        { 2.356e+02, 7.408e+00, 0.000e+00, 5.989e-01, 4.627e-02, 2.649e+01, 5.016e-01 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 2.777e+00, 0.000e+00, 1.647e-02, 0.000e+00, 1.217e-01 }, // CO
        { 0.000e+00, 0.000e+00, 4.263e+00, 3.776e-02, 7.555e-04, 0.000e+00, 5.983e-03 }, // HC
        { 7.430e+01, 2.336e+00, 0.000e+00, 1.889e-01, 1.459e-02, 8.352e+00, 1.582e-01 }, // FC
        { 2.930e-01, 0.000e+00, 0.000e+00, 0.000e+00, 8.921e-05, 1.140e-02, 1.843e-03 }, // NOx
        { 1.356e-01, 1.342e-02, 8.381e-18, 0.000e+00, 0.000e+00, 3.920e-18, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_2S_le250cc_Euro-4
        { 2.351e+02, 1.201e+01, 1.994e+02, 0.000e+00, 6.110e-02, 4.074e-01, 1.291e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.412e-02, 0.000e+00, 2.355e-01 }, // CO
        { 0.000e+00, 2.600e-02, 0.000e+00, 4.397e-02, 0.000e+00, 0.000e+00, 1.403e-02 }, // HC
        { 7.414e+01, 3.788e+00, 6.290e+01, 0.000e+00, 1.927e-02, 1.285e-01, 4.070e-01 }, // FC
        { 0.000e+00, 5.155e-02, 6.351e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.329e-01, 1.359e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.243e-19 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_2S_le250cc_Euro-5
        { 2.351e+02, 1.201e+01, 1.994e+02, 0.000e+00, 6.110e-02, 4.074e-01, 1.291e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.238e-02, 0.000e+00, 2.066e-01 }, // CO
        { 0.000e+00, 1.529e-02, 0.000e+00, 2.586e-02, 0.000e+00, 0.000e+00, 8.252e-03 }, // HC
        { 7.414e+01, 3.788e+00, 6.290e+01, 0.000e+00, 1.927e-02, 1.285e-01, 4.070e-01 }, // FC
        { 0.000e+00, 3.437e-02, 4.234e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.329e-01, 1.359e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.243e-19 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // MC_2S_le250cc_Euro-6
        { 2.351e+02, 1.201e+01, 1.994e+02, 0.000e+00, 6.110e-02, 4.074e-01, 1.291e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.238e-02, 0.000e+00, 2.066e-01 }, // CO
        { 0.000e+00, 1.529e-02, 0.000e+00, 2.586e-02, 0.000e+00, 0.000e+00, 8.252e-03 }, // HC
        { 7.414e+01, 3.788e+00, 6.290e+01, 0.000e+00, 1.927e-02, 1.285e-01, 4.070e-01 }, // FC
        { 0.000e+00, 3.437e-02, 4.234e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.329e-01, 1.359e-02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.243e-19 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // eBike
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.202e-04, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 1.343e-33, 0.000e+00, 1.878e-05, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // eScooter
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.531e-01, 1.063e-04, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // PM + PM (non-exhaust)
        { 8.187e-02, 3.821e-03, 1.524e-02, 0.000e+00, 4.190e-05, 2.451e-02, 1.252e-04 }, // FC_MJ
    },
    {
        // MC_BEV
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.436e-01, 5.770e-04, 0.000e+00, 0.000e+00, 1.046e-06, 8.244e-19, 7.039e-21 }, // PM + PM (non-exhaust)
        { 2.268e-01, 2.956e-03, 1.132e-01, 4.177e-04, 8.993e-05, 4.996e-02, 4.935e-04 }, // FC_MJ
    },
    {
        // RT_petrol
        { 3.592e+03, 7.757e+01, 0.000e+00, 7.120e+00, 5.381e-01, 6.622e+02, 2.003e+01 }, // CO2(total)
        { 6.343e+01, 0.000e+00, 0.000e+00, 0.000e+00, 4.154e-03, 5.578e+00, 1.416e-02 }, // CO
        { 6.301e+01, 0.000e+00, 1.155e+01, 0.000e+00, 5.664e-04, 0.000e+00, 0.000e+00 }, // HC
        { 1.164e+03, 2.515e+01, 0.000e+00, 2.308e+00, 1.744e-01, 2.147e+02, 6.495e+00 }, // FC
        { 3.895e+01, 1.571e+00, 0.000e+00, 0.000e+00, 7.481e-03, 8.251e+00, 1.319e-01 }, // NOx
        { 1.433e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.256e-04, 2.393e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_50ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_60ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_70ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_80ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7_5t_EE
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 1.532e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.003e-03, 1.348e+00, 3.422e-03 }, // CO
        { 1.247e+01, 0.000e+00, 2.286e+00, 0.000e+00, 1.121e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 2.246e+01, 9.059e-01, 0.000e+00, 0.000e+00, 4.314e-03, 4.758e+00, 7.603e-02 }, // NOx
        { 5.500e+00, 0.000e+00, 0.000e+00, 3.407e-03, 2.782e-04, 3.162e-01, 3.661e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-I
        { 2.829e+03, 3.253e+01, 0.000e+00, 5.774e+00, 3.882e-01, 4.741e+02, 1.668e+01 }, // CO2(total)
        { 1.140e+01, 0.000e+00, 0.000e+00, 6.671e-03, 4.057e-04, 9.650e-01, 8.418e-03 }, // CO
        { 3.440e+00, 0.000e+00, 1.738e+00, 0.000e+00, 1.165e-04, 0.000e+00, 3.512e-03 }, // HC
        { 9.091e+02, 1.045e+01, 0.000e+00, 1.856e+00, 1.248e-01, 1.524e+02, 5.360e+00 }, // FC
        { 1.983e+01, 1.652e+00, 0.000e+00, 0.000e+00, 4.551e-03, 5.045e+00, 1.425e-01 }, // NOx
        { 3.697e+00, 0.000e+00, 4.790e-01, 0.000e+00, 2.260e-04, 1.272e-03, 6.785e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-II
        { 2.368e+03, 1.011e+02, 0.000e+00, 4.702e-01, 4.672e-01, 4.408e+02, 1.636e+01 }, // CO2(total)
        { 8.994e+00, 5.296e-02, 7.244e+00, 5.933e-03, 0.000e+00, 3.049e-01, 0.000e+00 }, // CO
        { 2.113e+00, 0.000e+00, 9.123e-01, 0.000e+00, 7.595e-05, 0.000e+00, 2.913e-03 }, // HC
        { 7.611e+02, 3.250e+01, 0.000e+00, 1.511e-01, 1.501e-01, 1.417e+02, 5.256e+00 }, // FC
        { 2.168e+01, 1.762e+00, 0.000e+00, 0.000e+00, 3.992e-03, 5.950e+00, 8.394e-02 }, // NOx
        { 2.546e+00, 0.000e+00, 4.633e-01, 0.000e+00, 1.715e-04, 7.406e-02, 4.725e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-III
        { 2.726e+03, 1.907e+01, 0.000e+00, 8.286e+00, 2.655e-01, 4.727e+02, 1.612e+01 }, // CO2(total)
        { 1.177e+01, 0.000e+00, 5.048e+00, 3.587e-03, 0.000e+00, 2.216e-01, 0.000e+00 }, // CO
        { 2.028e+00, 0.000e+00, 7.814e-01, 0.000e+00, 4.529e-05, 0.000e+00, 1.580e-03 }, // HC
        { 8.762e+02, 6.129e+00, 0.000e+00, 2.663e+00, 8.533e-02, 1.519e+02, 5.181e+00 }, // FC
        { 2.194e+01, 0.000e+00, 0.000e+00, 1.073e-01, 5.775e-04, 4.157e+00, 9.078e-02 }, // NOx
        { 2.546e+00, 0.000e+00, 2.817e-01, 0.000e+00, 1.495e-04, 1.155e-03, 1.821e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-IV_EGR
        { 2.050e+03, 0.000e+00, 0.000e+00, 1.728e+01, 2.354e-02, 5.632e+02, 1.334e+01 }, // CO2(total)
        { 2.256e+00, 3.400e-01, 3.917e+00, 0.000e+00, 0.000e+00, 3.972e-01, 0.000e+00 }, // CO
        { 1.757e-01, 6.652e-03, 2.423e-01, 0.000e+00, 2.848e-05, 0.000e+00, 1.389e-03 }, // HC
        { 6.590e+02, 0.000e+00, 0.000e+00, 5.553e+00, 7.566e-03, 1.810e+02, 4.286e+00 }, // FC
        { 1.178e+00, 2.750e+00, 0.000e+00, 1.935e-02, 0.000e+00, 5.186e+00, 1.126e-02 }, // NOx
        { 1.527e+00, 1.519e-02, 2.806e-01, 0.000e+00, 1.271e-04, 4.807e-03, 5.013e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-IV_SCR
        { 2.073e+03, 0.000e+00, 0.000e+00, 1.642e+01, 4.710e-02, 5.527e+02, 1.323e+01 }, // CO2(total)
        { 1.038e+01, 5.021e-01, 2.514e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.168e-02, 5.245e-03, 0.000e+00, 0.000e+00, 7.439e-06, 1.572e-02, 6.593e-06 }, // HC
        { 6.662e+02, 0.000e+00, 0.000e+00, 5.277e+00, 1.514e-02, 1.776e+02, 4.252e+00 }, // FC
        { 2.024e+01, 0.000e+00, 0.000e+00, 1.517e-03, 1.760e-03, 1.009e+00, 4.956e-02 }, // NOx
        { 1.598e+00, 1.237e-02, 4.685e-01, 0.000e+00, 1.268e-04, 0.000e+00, 1.330e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-IV_SCRs
        { 2.073e+03, 0.000e+00, 0.000e+00, 1.642e+01, 4.710e-02, 5.527e+02, 1.323e+01 }, // CO2(total)
        { 1.038e+01, 5.021e-01, 2.514e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.168e-02, 5.245e-03, 0.000e+00, 0.000e+00, 7.439e-06, 1.572e-02, 6.593e-06 }, // HC
        { 6.662e+02, 0.000e+00, 0.000e+00, 5.277e+00, 1.514e-02, 1.776e+02, 4.252e+00 }, // FC
        { 1.797e+01, 2.036e+00, 2.668e+00, 0.000e+00, 4.030e-03, 6.159e+00, 7.481e-02 }, // NOx
        { 1.598e+00, 1.237e-02, 4.685e-01, 0.000e+00, 1.268e-04, 0.000e+00, 1.330e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-V_EGR
        { 2.018e+03, 0.000e+00, 0.000e+00, 1.621e+01, 3.649e-02, 5.379e+02, 1.365e+01 }, // CO2(total)
        { 4.304e+00, 3.005e-02, 4.893e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.411e-01, 3.391e-03, 4.309e-01, 0.000e+00, 3.432e-05, 5.437e-03, 7.725e-04 }, // HC
        { 6.485e+02, 0.000e+00, 0.000e+00, 5.208e+00, 1.173e-02, 1.729e+02, 4.387e+00 }, // FC
        { 1.729e+00, 1.464e+00, 0.000e+00, 8.112e-02, 0.000e+00, 3.268e+00, 1.368e-01 }, // NOx
        { 1.531e+00, 2.995e-03, 2.102e-02, 0.000e+00, 1.437e-04, 2.346e-02, 1.205e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-V_SCR
        { 1.943e+03, 0.000e+00, 0.000e+00, 1.653e+01, 8.809e-03, 5.346e+02, 1.293e+01 }, // CO2(total)
        { 7.617e+00, 6.359e-01, 1.810e+01, 0.000e+00, 0.000e+00, 3.779e-01, 0.000e+00 }, // CO
        { 7.667e-02, 9.104e-04, 0.000e+00, 3.093e-04, 0.000e+00, 1.253e-02, 1.315e-04 }, // HC
        { 6.244e+02, 0.000e+00, 0.000e+00, 5.311e+00, 2.831e-03, 1.718e+02, 4.156e+00 }, // FC
        { 1.710e+01, 0.000e+00, 0.000e+00, 0.000e+00, 6.453e-04, 0.000e+00, 3.489e-02 }, // NOx
        { 1.578e+00, 1.444e-02, 3.675e-01, 0.000e+00, 1.269e-04, 6.693e-03, 1.429e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-V_SCRs
        { 1.943e+03, 0.000e+00, 0.000e+00, 1.653e+01, 8.809e-03, 5.346e+02, 1.293e+01 }, // CO2(total)
        { 7.617e+00, 6.359e-01, 1.810e+01, 0.000e+00, 0.000e+00, 3.779e-01, 0.000e+00 }, // CO
        { 7.667e-02, 9.104e-04, 0.000e+00, 3.093e-04, 0.000e+00, 1.253e-02, 1.315e-04 }, // HC
        { 6.244e+02, 0.000e+00, 0.000e+00, 5.311e+00, 2.831e-03, 1.718e+02, 4.156e+00 }, // FC
        { 1.994e+01, 2.011e+00, 0.000e+00, 0.000e+00, 3.770e-03, 6.083e+00, 7.758e-02 }, // NOx
        { 1.578e+00, 1.444e-02, 3.675e-01, 0.000e+00, 1.269e-04, 6.693e-03, 1.429e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-VI_A-C
        { 1.936e+03, 0.000e+00, 0.000e+00, 1.621e+01, 6.403e-03, 5.511e+02, 1.203e+01 }, // CO2(total)
        { 1.053e+00, 3.609e-03, 1.179e+00, 8.138e-04, 0.000e+00, 0.000e+00, 3.190e-04 }, // CO
        { 8.609e-02, 0.000e+00, 1.124e-02, 1.815e-04, 8.715e-07, 4.578e-03, 2.644e-04 }, // HC
        { 6.221e+02, 0.000e+00, 0.000e+00, 5.211e+00, 2.058e-03, 1.771e+02, 3.866e+00 }, // FC
        { 1.158e-01, 2.321e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.005e-02 }, // NOx
        { 1.483e+00, 0.000e+00, 4.753e-02, 0.000e+00, 1.279e-04, 0.000e+00, 1.270e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-VIs_A-C
        { 1.936e+03, 0.000e+00, 0.000e+00, 1.621e+01, 6.403e-03, 5.511e+02, 1.203e+01 }, // CO2(total)
        { 1.053e+00, 3.609e-03, 1.179e+00, 8.138e-04, 0.000e+00, 0.000e+00, 3.190e-04 }, // CO
        { 8.609e-02, 0.000e+00, 1.124e-02, 1.815e-04, 8.715e-07, 4.578e-03, 2.644e-04 }, // HC
        { 6.221e+02, 0.000e+00, 0.000e+00, 5.211e+00, 2.058e-03, 1.771e+02, 3.866e+00 }, // FC
        { 6.537e+00, 1.884e-01, 0.000e+00, 1.544e-01, 0.000e+00, 2.619e+00, 2.379e-01 }, // NOx
        { 1.483e+00, 0.000e+00, 4.753e-02, 0.000e+00, 1.279e-04, 0.000e+00, 1.270e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-VI_D-E
        { 1.632e+03, 3.302e+01, 0.000e+00, 1.493e+01, 0.000e+00, 5.226e+02, 1.297e+01 }, // CO2(total)
        { 4.487e-01, 0.000e+00, 3.677e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.666e-01, 9.109e-04, 6.593e-02, 0.000e+00, 4.788e-06, 0.000e+00, 1.697e-04 }, // HC
        { 5.246e+02, 1.061e+01, 0.000e+00, 4.799e+00, 0.000e+00, 1.680e+02, 4.168e+00 }, // FC
        { 7.422e-01, 0.000e+00, 5.967e-01, 1.024e-03, 8.439e-06, 0.000e+00, 0.000e+00 }, // NOx
        { 1.435e+00, 4.843e-04, 0.000e+00, 2.371e-05, 1.265e-04, 1.685e-03, 1.389e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_le7.5t_Euro-VIs_D-E
        { 1.632e+03, 3.302e+01, 0.000e+00, 1.493e+01, 0.000e+00, 5.226e+02, 1.297e+01 }, // CO2(total)
        { 4.487e-01, 0.000e+00, 3.677e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.666e-01, 9.109e-04, 6.593e-02, 0.000e+00, 4.788e-06, 0.000e+00, 1.697e-04 }, // HC
        { 5.246e+02, 1.061e+01, 0.000e+00, 4.799e+00, 0.000e+00, 1.680e+02, 4.168e+00 }, // FC
        { 1.693e+01, 1.115e+00, 2.838e+01, 0.000e+00, 4.042e-03, 8.362e-01, 2.038e-01 }, // NOx
        { 1.435e+00, 4.843e-04, 0.000e+00, 2.371e-05, 1.265e-04, 1.685e-03, 1.389e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_50ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_60ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_70ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_80ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_EE
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 3.130e+01, 2.570e+00, 0.000e+00, 1.466e-01, 0.000e+00, 8.123e+00, 2.112e-01 }, // CO
        { 3.921e+01, 0.000e+00, 1.161e+01, 0.000e+00, 1.877e-03, 0.000e+00, 2.038e-02 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.324e+01, 7.387e+00, 0.000e+00, 7.084e-02, 0.000e+00, 1.785e+01, 5.410e-02 }, // NOx
        { 7.072e+00, 1.766e+00, 0.000e+00, 0.000e+00, 1.278e-04, 3.181e+00, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-I
        { 0.000e+00, 5.834e+02, 0.000e+00, 1.727e+00, 0.000e+00, 1.258e+03, 0.000e+00 }, // CO2(total)
        { 1.017e+01, 1.246e-01, 1.151e+01, 1.563e-02, 0.000e+00, 0.000e+00, 3.686e-02 }, // CO
        { 3.479e+00, 0.000e+00, 1.163e+00, 0.000e+00, 2.869e-04, 1.309e-01, 8.355e-03 }, // HC
        { 0.000e+00, 1.875e+02, 0.000e+00, 5.550e-01, 0.000e+00, 4.041e+02, 0.000e+00 }, // FC
        { 3.625e+00, 5.508e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.184e+01, 0.000e+00 }, // NOx
        { 2.600e+00, 1.316e-01, 0.000e+00, 1.562e-03, 1.268e-04, 2.677e-01, 2.631e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-II
        { 1.016e+03, 3.980e+02, 0.000e+00, 6.894e+00, 0.000e+00, 1.112e+03, 4.459e+00 }, // CO2(total)
        { 1.036e+01, 2.724e-01, 1.828e+01, 0.000e+00, 0.000e+00, 3.306e-01, 0.000e+00 }, // CO
        { 2.383e+00, 0.000e+00, 6.374e-01, 0.000e+00, 1.790e-04, 0.000e+00, 8.020e-03 }, // HC
        { 3.266e+02, 1.279e+02, 0.000e+00, 2.215e+00, 0.000e+00, 3.574e+02, 1.433e+00 }, // FC
        { 1.044e+01, 5.247e+00, 8.778e+00, 0.000e+00, 0.000e+00, 1.127e+01, 0.000e+00 }, // NOx
        { 2.254e+00, 4.329e-02, 5.531e-01, 1.145e-03, 1.253e-04, 1.349e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-III
        { 6.886e+02, 4.788e+02, 0.000e+00, 4.216e+00, 0.000e+00, 1.172e+03, 2.898e+00 }, // CO2(total)
        { 1.176e+01, 2.334e-01, 9.207e+00, 0.000e+00, 0.000e+00, 4.144e-01, 0.000e+00 }, // CO
        { 2.324e+00, 0.000e+00, 8.327e-01, 0.000e+00, 1.137e-04, 0.000e+00, 5.577e-03 }, // HC
        { 2.213e+02, 1.539e+02, 0.000e+00, 1.355e+00, 0.000e+00, 3.766e+02, 9.313e-01 }, // FC
        { 1.000e+01, 3.902e+00, 7.203e+00, 0.000e+00, 0.000e+00, 9.012e+00, 0.000e+00 }, // NOx
        { 2.724e+00, 0.000e+00, 3.934e-01, 0.000e+00, 1.922e-04, 1.169e-02, 3.273e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-IV_EGR
        { 0.000e+00, 5.244e+02, 0.000e+00, 3.309e+00, 0.000e+00, 1.219e+03, 1.676e+00 }, // CO2(total)
        { 6.722e+00, 1.467e-01, 1.429e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.374e-01, 2.592e-02, 7.390e-01, 0.000e+00, 0.000e+00, 4.166e-03, 0.000e+00 }, // HC
        { 0.000e+00, 1.685e+02, 0.000e+00, 1.063e+00, 0.000e+00, 3.919e+02, 5.386e-01 }, // FC
        { 2.809e+01, 1.909e+00, 6.047e+01, 0.000e+00, 0.000e+00, 4.202e+00, 0.000e+00 }, // NOx
        { 1.742e+00, 5.504e-03, 6.174e-01, 0.000e+00, 1.254e-04, 2.172e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-IV_SCR
        { 0.000e+00, 5.204e+02, 0.000e+00, 3.173e+00, 0.000e+00, 1.209e+03, 1.443e+00 }, // CO2(total)
        { 2.111e+01, 0.000e+00, 4.039e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.162e-02, 4.479e-03, 7.566e-02, 0.000e+00, 1.865e-05, 2.063e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.673e+02, 0.000e+00, 1.020e+00, 0.000e+00, 3.884e+02, 4.636e-01 }, // FC
        { 1.052e+01, 1.411e+00, 0.000e+00, 1.521e-02, 0.000e+00, 2.650e+00, 4.038e-02 }, // NOx
        { 1.805e+00, 2.760e-03, 7.167e-01, 0.000e+00, 1.289e-04, 2.319e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-IV_SCRs
        { 0.000e+00, 5.204e+02, 0.000e+00, 3.173e+00, 0.000e+00, 1.209e+03, 1.443e+00 }, // CO2(total)
        { 2.111e+01, 0.000e+00, 4.039e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.162e-02, 4.479e-03, 7.566e-02, 0.000e+00, 1.865e-05, 2.063e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.673e+02, 0.000e+00, 1.020e+00, 0.000e+00, 3.884e+02, 4.636e-01 }, // FC
        { 3.563e+00, 5.536e+00, 7.666e-01, 0.000e+00, 0.000e+00, 1.173e+01, 0.000e+00 }, // NOx
        { 1.805e+00, 2.760e-03, 7.167e-01, 0.000e+00, 1.289e-04, 2.319e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-V_EGR
        { 0.000e+00, 5.161e+02, 0.000e+00, 2.687e+00, 0.000e+00, 1.204e+03, 1.018e+00 }, // CO2(total)
        { 6.291e+00, 0.000e+00, 1.024e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.937e-01, 7.378e-03, 3.758e-01, 0.000e+00, 3.528e-05, 4.773e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.659e+02, 0.000e+00, 8.635e-01, 0.000e+00, 3.870e+02, 3.271e-01 }, // FC
        { 2.603e+01, 1.006e+00, 5.663e+01, 0.000e+00, 0.000e+00, 1.436e+00, 0.000e+00 }, // NOx
        { 1.554e+00, 0.000e+00, 9.193e-02, 0.000e+00, 1.762e-04, 2.802e-03, 2.004e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-V_SCR
        { 0.000e+00, 5.072e+02, 0.000e+00, 2.535e+00, 0.000e+00, 1.183e+03, 7.498e-01 }, // CO2(total)
        { 1.941e+01, 0.000e+00, 3.546e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.249e-02, 7.048e-03, 3.485e-02, 0.000e+00, 1.173e-05, 2.281e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.630e+02, 0.000e+00, 8.148e-01, 0.000e+00, 3.802e+02, 2.410e-01 }, // FC
        { 1.518e+01, 2.835e-01, 0.000e+00, 1.586e-02, 0.000e+00, 0.000e+00, 7.208e-02 }, // NOx
        { 1.827e+00, 2.001e-03, 6.742e-01, 0.000e+00, 1.273e-04, 2.921e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-V_SCRs
        { 0.000e+00, 5.072e+02, 0.000e+00, 2.535e+00, 0.000e+00, 1.183e+03, 7.498e-01 }, // CO2(total)
        { 1.941e+01, 0.000e+00, 3.546e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.249e-02, 7.048e-03, 3.485e-02, 0.000e+00, 1.173e-05, 2.281e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.630e+02, 0.000e+00, 8.148e-01, 0.000e+00, 3.802e+02, 2.410e-01 }, // FC
        { 5.880e+00, 5.446e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.078e+01, 4.016e-02 }, // NOx
        { 1.827e+00, 2.001e-03, 6.742e-01, 0.000e+00, 1.273e-04, 2.921e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-VI_A-C
        { 0.000e+00, 5.000e+02, 0.000e+00, 2.803e+00, 0.000e+00, 1.166e+03, 2.644e+00 }, // CO2(total)
        { 1.383e+00, 2.558e-02, 2.189e+00, 0.000e+00, 1.106e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.982e-02, 1.174e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.097e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.607e+02, 0.000e+00, 9.009e-01, 0.000e+00, 3.747e+02, 8.497e-01 }, // FC
        { 2.327e+00, 2.144e-02, 0.000e+00, 5.407e-03, 0.000e+00, 0.000e+00, 5.745e-03 }, // NOx
        { 1.480e+00, 0.000e+00, 7.698e-02, 0.000e+00, 1.362e-04, 1.563e-03, 1.308e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-VIs_A-C
        { 0.000e+00, 5.000e+02, 0.000e+00, 2.803e+00, 0.000e+00, 1.166e+03, 2.644e+00 }, // CO2(total)
        { 1.383e+00, 2.558e-02, 2.189e+00, 0.000e+00, 1.106e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.982e-02, 1.174e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.097e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.607e+02, 0.000e+00, 9.009e-01, 0.000e+00, 3.747e+02, 8.497e-01 }, // FC
        { 5.888e-01, 3.272e+00, 0.000e+00, 1.961e-02, 0.000e+00, 7.277e+00, 3.013e-02 }, // NOx
        { 1.480e+00, 0.000e+00, 7.698e-02, 0.000e+00, 1.362e-04, 1.563e-03, 1.308e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-VI_D-E
        { 0.000e+00, 4.903e+02, 0.000e+00, 3.054e+00, 0.000e+00, 1.141e+03, 3.487e+00 }, // CO2(total)
        { 5.022e-01, 0.000e+00, 6.107e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.979e-01, 0.000e+00, 7.798e-02, 0.000e+00, 1.131e-05, 4.849e-03, 0.000e+00 }, // HC
        { 0.000e+00, 1.576e+02, 0.000e+00, 9.816e-01, 0.000e+00, 3.665e+02, 1.121e+00 }, // FC
        { 7.158e-01, 4.177e-02, 1.748e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.445e+00, 0.000e+00, 0.000e+00, 5.679e-05, 1.267e-04, 4.605e-03, 9.898e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt7_5-12t_Euro-VIs_D-E
        { 0.000e+00, 4.903e+02, 0.000e+00, 3.054e+00, 0.000e+00, 1.141e+03, 3.487e+00 }, // CO2(total)
        { 5.022e-01, 0.000e+00, 6.107e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.979e-01, 0.000e+00, 7.798e-02, 0.000e+00, 1.131e-05, 4.849e-03, 0.000e+00 }, // HC
        { 0.000e+00, 1.576e+02, 0.000e+00, 9.816e-01, 0.000e+00, 3.665e+02, 1.121e+00 }, // FC
        { 1.513e+01, 3.057e+00, 4.129e+01, 0.000e+00, 2.357e-04, 4.854e+00, 2.970e-02 }, // NOx
        { 1.445e+00, 0.000e+00, 0.000e+00, 5.679e-05, 1.267e-04, 4.605e-03, 9.898e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_50ties
        { 1.881e+03, 5.612e+02, 3.944e+03, 0.000e+00, 0.000e+00, 1.168e+03, 0.000e+00 }, // CO2(total)
        { 2.543e+01, 1.867e+00, 3.581e+01, 0.000e+00, 0.000e+00, 3.979e+00, 0.000e+00 }, // CO
        { 1.528e+01, 0.000e+00, 1.912e+00, 0.000e+00, 3.676e-04, 0.000e+00, 2.704e-02 }, // HC
        { 6.046e+02, 1.804e+02, 1.267e+03, 0.000e+00, 0.000e+00, 3.753e+02, 0.000e+00 }, // FC
        { 2.414e+01, 6.923e+00, 4.490e+01, 0.000e+00, 0.000e+00, 1.437e+01, 0.000e+00 }, // NOx
        { 5.482e+00, 2.717e-01, 4.585e+00, 0.000e+00, 1.310e-04, 5.945e-01, 2.109e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_60ties
        { 1.881e+03, 5.612e+02, 3.944e+03, 0.000e+00, 0.000e+00, 1.168e+03, 0.000e+00 }, // CO2(total)
        { 2.543e+01, 1.867e+00, 3.581e+01, 0.000e+00, 0.000e+00, 3.979e+00, 0.000e+00 }, // CO
        { 1.528e+01, 0.000e+00, 1.912e+00, 0.000e+00, 3.676e-04, 0.000e+00, 2.704e-02 }, // HC
        { 6.046e+02, 1.804e+02, 1.267e+03, 0.000e+00, 0.000e+00, 3.753e+02, 0.000e+00 }, // FC
        { 2.414e+01, 6.923e+00, 4.490e+01, 0.000e+00, 0.000e+00, 1.437e+01, 0.000e+00 }, // NOx
        { 5.482e+00, 2.717e-01, 4.585e+00, 0.000e+00, 1.310e-04, 5.945e-01, 2.109e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_70ties
        { 1.881e+03, 5.612e+02, 3.944e+03, 0.000e+00, 0.000e+00, 1.168e+03, 0.000e+00 }, // CO2(total)
        { 2.543e+01, 1.867e+00, 3.581e+01, 0.000e+00, 0.000e+00, 3.979e+00, 0.000e+00 }, // CO
        { 1.528e+01, 0.000e+00, 1.912e+00, 0.000e+00, 3.676e-04, 0.000e+00, 2.704e-02 }, // HC
        { 6.046e+02, 1.804e+02, 1.267e+03, 0.000e+00, 0.000e+00, 3.753e+02, 0.000e+00 }, // FC
        { 2.414e+01, 6.923e+00, 4.490e+01, 0.000e+00, 0.000e+00, 1.437e+01, 0.000e+00 }, // NOx
        { 5.482e+00, 2.717e-01, 4.585e+00, 0.000e+00, 1.310e-04, 5.945e-01, 2.109e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_80ties
        { 1.881e+03, 5.612e+02, 3.944e+03, 0.000e+00, 0.000e+00, 1.168e+03, 0.000e+00 }, // CO2(total)
        { 2.543e+01, 1.867e+00, 3.581e+01, 0.000e+00, 0.000e+00, 3.979e+00, 0.000e+00 }, // CO
        { 1.528e+01, 0.000e+00, 1.912e+00, 0.000e+00, 3.676e-04, 0.000e+00, 2.704e-02 }, // HC
        { 6.046e+02, 1.804e+02, 1.267e+03, 0.000e+00, 0.000e+00, 3.753e+02, 0.000e+00 }, // FC
        { 2.414e+01, 6.923e+00, 4.490e+01, 0.000e+00, 0.000e+00, 1.437e+01, 0.000e+00 }, // NOx
        { 5.482e+00, 2.717e-01, 4.585e+00, 0.000e+00, 1.310e-04, 5.945e-01, 2.109e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-I
        { 2.107e+03, 5.259e+02, 4.590e+03, 0.000e+00, 0.000e+00, 1.108e+03, 0.000e+00 }, // CO2(total)
        { 1.037e+01, 1.708e-01, 9.344e+00, 2.403e-02, 0.000e+00, 0.000e+00, 7.280e-02 }, // CO
        { 3.874e+00, 5.130e-04, 1.713e+00, 0.000e+00, 9.497e-05, 2.408e-01, 0.000e+00 }, // HC
        { 6.771e+02, 1.690e+02, 1.475e+03, 0.000e+00, 0.000e+00, 3.560e+02, 0.000e+00 }, // FC
        { 1.832e+01, 5.203e+00, 3.673e+01, 0.000e+00, 0.000e+00, 1.099e+01, 0.000e+00 }, // NOx
        { 3.419e+00, 9.997e-02, 1.123e+00, 0.000e+00, 1.288e-04, 2.608e-01, 2.384e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-II
        { 9.111e+02, 5.878e+02, 7.107e+02, 0.000e+00, 0.000e+00, 1.315e+03, 0.000e+00 }, // CO2(total)
        { 1.276e+01, 2.053e-01, 2.463e+01, 0.000e+00, 0.000e+00, 1.456e-01, 0.000e+00 }, // CO
        { 2.558e+00, 0.000e+00, 1.037e+00, 8.019e-04, 6.625e-05, 0.000e+00, 8.090e-03 }, // HC
        { 2.928e+02, 1.889e+02, 2.284e+02, 0.000e+00, 0.000e+00, 4.227e+02, 0.000e+00 }, // FC
        { 1.441e+01, 5.677e+00, 1.864e+01, 0.000e+00, 0.000e+00, 1.225e+01, 0.000e+00 }, // NOx
        { 2.436e+00, 5.592e-02, 1.269e+00, 0.000e+00, 1.288e-04, 1.101e-01, 1.047e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-III
        { 1.184e+03, 5.854e+02, 1.349e+03, 0.000e+00, 0.000e+00, 1.314e+03, 0.000e+00 }, // CO2(total)
        { 1.292e+01, 1.929e-01, 1.250e+01, 0.000e+00, 0.000e+00, 3.985e-01, 0.000e+00 }, // CO
        { 2.364e+00, 0.000e+00, 1.161e+00, 3.212e-04, 4.845e-05, 0.000e+00, 5.085e-03 }, // HC
        { 3.805e+02, 1.881e+02, 4.335e+02, 0.000e+00, 0.000e+00, 4.224e+02, 0.000e+00 }, // FC
        { 1.216e+01, 4.450e+00, 2.645e+01, 0.000e+00, 0.000e+00, 9.168e+00, 0.000e+00 }, // NOx
        { 2.459e+00, 3.666e-02, 5.797e-02, 0.000e+00, 1.284e-04, 1.033e-01, 1.224e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-IV_EGR
        { 6.013e+02, 6.121e+02, 1.748e+03, 0.000e+00, 0.000e+00, 1.324e+03, 0.000e+00 }, // CO2(total)
        { 6.704e+00, 1.546e-01, 1.269e+01, 0.000e+00, 9.956e-05, 0.000e+00, 1.610e-02 }, // CO
        { 3.213e-01, 6.598e-03, 6.049e-01, 0.000e+00, 2.242e-05, 0.000e+00, 1.371e-03 }, // HC
        { 1.932e+02, 1.967e+02, 5.616e+02, 0.000e+00, 0.000e+00, 4.255e+02, 0.000e+00 }, // FC
        { 2.208e+01, 2.849e+00, 4.211e+01, 0.000e+00, 0.000e+00, 6.121e+00, 0.000e+00 }, // NOx
        { 1.763e+00, 2.080e-03, 5.226e-01, 0.000e+00, 1.339e-04, 0.000e+00, 5.678e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-IV_SCR
        { 7.974e+02, 5.890e+02, 2.220e+03, 0.000e+00, 0.000e+00, 1.269e+03, 0.000e+00 }, // CO2(total)
        { 2.325e+01, 0.000e+00, 4.006e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.032e-02, 1.121e-02, 1.520e-01, 0.000e+00, 0.000e+00, 2.068e-02, 0.000e+00 }, // HC
        { 2.563e+02, 1.893e+02, 7.133e+02, 0.000e+00, 0.000e+00, 4.079e+02, 0.000e+00 }, // FC
        { 1.122e+01, 1.580e+00, 0.000e+00, 9.840e-03, 0.000e+00, 3.677e+00, 1.903e-02 }, // NOx
        { 1.807e+00, 1.340e-03, 6.574e-01, 0.000e+00, 1.329e-04, 0.000e+00, 3.922e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-IV_SCRs
        { 7.974e+02, 5.890e+02, 2.220e+03, 0.000e+00, 0.000e+00, 1.269e+03, 0.000e+00 }, // CO2(total)
        { 2.325e+01, 0.000e+00, 4.006e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 7.032e-02, 1.121e-02, 1.520e-01, 0.000e+00, 0.000e+00, 2.068e-02, 0.000e+00 }, // HC
        { 2.563e+02, 1.893e+02, 7.133e+02, 0.000e+00, 0.000e+00, 4.079e+02, 0.000e+00 }, // FC
        { 1.304e+01, 5.558e+00, 2.288e+01, 0.000e+00, 0.000e+00, 1.196e+01, 0.000e+00 }, // NOx
        { 1.807e+00, 1.340e-03, 6.574e-01, 0.000e+00, 1.329e-04, 0.000e+00, 3.922e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-V_EGR
        { 1.471e+02, 6.248e+02, 2.060e+02, 0.000e+00, 0.000e+00, 1.395e+03, 0.000e+00 }, // CO2(total)
        { 7.924e+00, 0.000e+00, 1.372e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.043e-01, 1.706e-02, 5.392e-01, 0.000e+00, 2.255e-05, 3.775e-02, 1.169e-03 }, // HC
        { 4.728e+01, 2.008e+02, 6.622e+01, 0.000e+00, 0.000e+00, 4.484e+02, 0.000e+00 }, // FC
        { 2.836e+01, 1.570e+00, 5.591e+01, 0.000e+00, 0.000e+00, 3.167e+00, 0.000e+00 }, // NOx
        { 1.628e+00, 1.455e-04, 2.898e-01, 0.000e+00, 1.509e-04, 1.704e-03, 1.351e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-V_SCR
        { 1.499e+02, 6.109e+02, 2.251e+02, 0.000e+00, 0.000e+00, 1.362e+03, 0.000e+00 }, // CO2(total)
        { 2.787e+01, 0.000e+00, 5.053e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.625e-02, 1.378e-02, 4.521e-02, 0.000e+00, 0.000e+00, 2.746e-02, 0.000e+00 }, // HC
        { 4.816e+01, 1.963e+02, 7.234e+01, 0.000e+00, 0.000e+00, 4.378e+02, 0.000e+00 }, // FC
        { 1.720e+01, 4.971e-01, 0.000e+00, 0.000e+00, 3.523e-04, 5.169e-01, 5.073e-02 }, // NOx
        { 1.870e+00, 6.107e-03, 8.612e-01, 0.000e+00, 1.260e-04, 4.605e-03, 5.982e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-V_SCRs
        { 1.499e+02, 6.109e+02, 2.251e+02, 0.000e+00, 0.000e+00, 1.362e+03, 0.000e+00 }, // CO2(total)
        { 2.787e+01, 0.000e+00, 5.053e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.625e-02, 1.378e-02, 4.521e-02, 0.000e+00, 0.000e+00, 2.746e-02, 0.000e+00 }, // HC
        { 4.816e+01, 1.963e+02, 7.234e+01, 0.000e+00, 0.000e+00, 4.378e+02, 0.000e+00 }, // FC
        { 1.605e+01, 5.496e+00, 6.782e+00, 8.568e-03, 0.000e+00, 1.278e+01, 0.000e+00 }, // NOx
        { 1.870e+00, 6.107e-03, 8.612e-01, 0.000e+00, 1.260e-04, 4.605e-03, 5.982e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-VI_A-C
        { 4.116e+02, 5.903e+02, 9.977e+02, 0.000e+00, 0.000e+00, 1.317e+03, 0.000e+00 }, // CO2(total)
        { 1.811e+00, 2.101e-02, 2.506e+00, 0.000e+00, 0.000e+00, 3.713e-02, 0.000e+00 }, // CO
        { 9.688e-02, 4.705e-03, 8.203e-04, 1.676e-04, 0.000e+00, 1.275e-02, 4.223e-04 }, // HC
        { 1.323e+02, 1.897e+02, 3.207e+02, 0.000e+00, 0.000e+00, 4.232e+02, 0.000e+00 }, // FC
        { 2.919e+00, 2.620e-02, 1.861e-01, 1.142e-03, 0.000e+00, 0.000e+00, 1.642e-03 }, // NOx
        { 1.531e+00, 0.000e+00, 1.583e-01, 0.000e+00, 1.258e-04, 1.350e-03, 8.970e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-VIs_A-C
        { 4.116e+02, 5.903e+02, 9.977e+02, 0.000e+00, 0.000e+00, 1.317e+03, 0.000e+00 }, // CO2(total)
        { 1.811e+00, 2.101e-02, 2.506e+00, 0.000e+00, 0.000e+00, 3.713e-02, 0.000e+00 }, // CO
        { 9.688e-02, 4.705e-03, 8.203e-04, 1.676e-04, 0.000e+00, 1.275e-02, 4.223e-04 }, // HC
        { 1.323e+02, 1.897e+02, 3.207e+02, 0.000e+00, 0.000e+00, 4.232e+02, 0.000e+00 }, // FC
        { 7.645e+00, 3.872e+00, 2.215e+01, 0.000e+00, 0.000e+00, 8.339e+00, 0.000e+00 }, // NOx
        { 1.531e+00, 0.000e+00, 1.583e-01, 0.000e+00, 1.258e-04, 1.350e-03, 8.970e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-VI_D-E
        { 1.884e+02, 5.980e+02, 3.397e+02, 0.000e+00, 0.000e+00, 1.345e+03, 0.000e+00 }, // CO2(total)
        { 8.133e-01, 0.000e+00, 1.002e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.375e-01, 0.000e+00, 1.084e-01, 0.000e+00, 6.980e-06, 0.000e+00, 3.397e-04 }, // HC
        { 6.054e+01, 1.922e+02, 1.092e+02, 0.000e+00, 0.000e+00, 4.321e+02, 0.000e+00 }, // FC
        { 1.101e+00, 3.323e-02, 9.399e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.438e+00, 1.207e-03, 0.000e+00, 1.566e-05, 1.258e-04, 4.876e-03, 1.560e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt12-14t_Euro-VIs_D-E
        { 1.884e+02, 5.980e+02, 3.397e+02, 0.000e+00, 0.000e+00, 1.345e+03, 0.000e+00 }, // CO2(total)
        { 8.133e-01, 0.000e+00, 1.002e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.375e-01, 0.000e+00, 1.084e-01, 0.000e+00, 6.980e-06, 0.000e+00, 3.397e-04 }, // HC
        { 6.054e+01, 1.922e+02, 1.092e+02, 0.000e+00, 0.000e+00, 4.321e+02, 0.000e+00 }, // FC
        { 1.956e+01, 4.053e+00, 6.143e+01, 0.000e+00, 0.000e+00, 7.462e+00, 0.000e+00 }, // NOx
        { 1.438e+00, 1.207e-03, 0.000e+00, 1.566e-05, 1.258e-04, 4.876e-03, 1.560e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_50ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_60ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_70ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_80ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-I
        { 3.438e+03, 4.969e+02, 6.897e+03, 0.000e+00, 0.000e+00, 1.064e+03, 0.000e+00 }, // CO2(total)
        { 1.096e+01, 6.894e-01, 1.656e+01, 1.056e-04, 0.000e+00, 1.329e+00, 0.000e+00 }, // CO
        { 2.896e+00, 7.570e-02, 1.854e-01, 8.159e-04, 0.000e+00, 3.268e-01, 0.000e+00 }, // HC
        { 1.105e+03, 1.597e+02, 2.217e+03, 0.000e+00, 0.000e+00, 3.420e+02, 0.000e+00 }, // FC
        { 3.416e+01, 4.795e+00, 6.891e+01, 0.000e+00, 0.000e+00, 1.011e+01, 0.000e+00 }, // NOx
        { 3.198e+00, 1.183e-01, 7.290e-01, 0.000e+00, 1.342e-04, 3.006e-01, 1.344e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-II
        { 2.401e+03, 5.740e+02, 4.316e+03, 0.000e+00, 0.000e+00, 1.287e+03, 0.000e+00 }, // CO2(total)
        { 1.427e+01, 0.000e+00, 2.284e+01, 0.000e+00, 3.357e-04, 0.000e+00, 1.013e-02 }, // CO
        { 2.346e+00, 1.017e-02, 0.000e+00, 2.490e-03, 0.000e+00, 2.088e-01, 1.926e-03 }, // HC
        { 7.715e+02, 1.845e+02, 1.387e+03, 0.000e+00, 0.000e+00, 4.136e+02, 0.000e+00 }, // FC
        { 2.947e+01, 5.554e+00, 4.958e+01, 0.000e+00, 0.000e+00, 1.234e+01, 0.000e+00 }, // NOx
        { 2.546e+00, 3.407e-02, 1.756e+00, 1.013e-03, 1.318e-04, 1.443e-02, 3.901e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-III
        { 2.897e+03, 5.763e+02, 5.778e+03, 0.000e+00, 0.000e+00, 1.298e+03, 0.000e+00 }, // CO2(total)
        { 1.207e+01, 0.000e+00, 3.366e+00, 0.000e+00, 6.463e-04, 0.000e+00, 4.528e-02 }, // CO
        { 1.880e+00, 6.464e-02, 6.011e-01, 0.000e+00, 0.000e+00, 1.766e-01, 0.000e+00 }, // HC
        { 9.309e+02, 1.852e+02, 1.857e+03, 0.000e+00, 0.000e+00, 4.171e+02, 0.000e+00 }, // FC
        { 2.470e+01, 4.238e+00, 4.356e+01, 0.000e+00, 0.000e+00, 9.318e+00, 0.000e+00 }, // NOx
        { 2.412e+00, 5.233e-02, 2.086e-01, 0.000e+00, 1.287e-04, 1.296e-01, 1.953e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-IV_EGR
        { 1.894e+03, 6.432e+02, 3.940e+03, 0.000e+00, 0.000e+00, 1.477e+03, 0.000e+00 }, // CO2(total)
        { 4.449e+00, 4.459e-01, 3.725e+00, 0.000e+00, 1.726e-04, 1.256e+00, 0.000e+00 }, // CO
        { 2.861e-01, 1.458e-02, 5.044e-01, 5.993e-04, 0.000e+00, 1.961e-02, 1.733e-03 }, // HC
        { 6.087e+02, 2.067e+02, 1.266e+03, 0.000e+00, 0.000e+00, 4.746e+02, 0.000e+00 }, // FC
        { 2.457e+01, 2.872e+00, 4.652e+01, 0.000e+00, 1.121e-03, 5.463e+00, 7.608e-02 }, // NOx
        { 1.780e+00, 0.000e+00, 3.800e-01, 0.000e+00, 1.501e-04, 2.913e-03, 1.133e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-IV_SCR
        { 2.681e+03, 5.551e+02, 6.238e+03, 0.000e+00, 0.000e+00, 1.213e+03, 0.000e+00 }, // CO2(total)
        { 1.630e+01, 6.392e-01, 1.756e+01, 0.000e+00, 8.984e-04, 2.554e+00, 0.000e+00 }, // CO
        { 1.085e-01, 1.041e-02, 1.555e-01, 0.000e+00, 0.000e+00, 2.319e-02, 0.000e+00 }, // HC
        { 8.617e+02, 1.784e+02, 2.005e+03, 0.000e+00, 0.000e+00, 3.898e+02, 0.000e+00 }, // FC
        { 1.794e+01, 1.728e+00, 9.664e-01, 0.000e+00, 0.000e+00, 4.677e+00, 0.000e+00 }, // NOx
        { 1.727e+00, 1.239e-02, 3.746e-01, 0.000e+00, 1.379e-04, 3.378e-02, 3.835e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-IV_SCRs
        { 2.681e+03, 5.551e+02, 6.238e+03, 0.000e+00, 0.000e+00, 1.213e+03, 0.000e+00 }, // CO2(total)
        { 1.630e+01, 6.392e-01, 1.756e+01, 0.000e+00, 8.984e-04, 2.554e+00, 0.000e+00 }, // CO
        { 1.085e-01, 1.041e-02, 1.555e-01, 0.000e+00, 0.000e+00, 2.319e-02, 0.000e+00 }, // HC
        { 8.617e+02, 1.784e+02, 2.005e+03, 0.000e+00, 0.000e+00, 3.898e+02, 0.000e+00 }, // FC
        { 2.967e+01, 5.502e+00, 5.750e+01, 0.000e+00, 0.000e+00, 1.210e+01, 0.000e+00 }, // NOx
        { 1.727e+00, 1.239e-02, 3.746e-01, 0.000e+00, 1.379e-04, 3.378e-02, 3.835e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-V_EGR
        { 1.185e+03, 6.728e+02, 1.382e+03, 0.000e+00, 0.000e+00, 1.614e+03, 0.000e+00 }, // CO2(total)
        { 5.617e+00, 2.377e-01, 1.130e+01, 0.000e+00, 0.000e+00, 2.340e-01, 0.000e+00 }, // CO
        { 7.145e-01, 1.627e-02, 8.008e-01, 0.000e+00, 2.508e-05, 2.546e-02, 2.148e-03 }, // HC
        { 3.808e+02, 2.162e+02, 4.442e+02, 0.000e+00, 0.000e+00, 5.189e+02, 0.000e+00 }, // FC
        { 1.927e+01, 2.813e+00, 3.162e+01, 0.000e+00, 0.000e+00, 5.967e+00, 0.000e+00 }, // NOx
        { 1.646e+00, 1.006e-02, 3.275e-01, 0.000e+00, 1.370e-04, 2.045e-02, 9.598e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-V_SCR
        { 1.130e+03, 6.618e+02, 1.274e+03, 0.000e+00, 0.000e+00, 1.590e+03, 0.000e+00 }, // CO2(total)
        { 1.571e+01, 9.141e-01, 2.996e+01, 0.000e+00, 2.692e-04, 1.499e+00, 0.000e+00 }, // CO
        { 1.070e-01, 1.392e-02, 2.613e-02, 0.000e+00, 0.000e+00, 3.457e-02, 0.000e+00 }, // HC
        { 3.632e+02, 2.127e+02, 4.095e+02, 0.000e+00, 0.000e+00, 5.109e+02, 0.000e+00 }, // FC
        { 2.422e+01, 6.067e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.056e+00, 4.076e-02 }, // NOx
        { 1.810e+00, 1.475e-02, 6.721e-01, 0.000e+00, 1.311e-04, 1.760e-02, 5.030e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-V_SCRs
        { 1.130e+03, 6.618e+02, 1.274e+03, 0.000e+00, 0.000e+00, 1.590e+03, 0.000e+00 }, // CO2(total)
        { 1.571e+01, 9.141e-01, 2.996e+01, 0.000e+00, 2.692e-04, 1.499e+00, 0.000e+00 }, // CO
        { 1.070e-01, 1.392e-02, 2.613e-02, 0.000e+00, 0.000e+00, 3.457e-02, 0.000e+00 }, // HC
        { 3.632e+02, 2.127e+02, 4.095e+02, 0.000e+00, 0.000e+00, 5.109e+02, 0.000e+00 }, // FC
        { 2.553e+01, 6.517e+00, 2.100e+01, 0.000e+00, 0.000e+00, 1.520e+01, 0.000e+00 }, // NOx
        { 1.810e+00, 1.475e-02, 6.721e-01, 0.000e+00, 1.311e-04, 1.760e-02, 5.030e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-VI_A-C
        { 6.377e+02, 6.844e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.666e+03, 0.000e+00 }, // CO2(total)
        { 2.101e+00, 0.000e+00, 2.304e+00, 0.000e+00, 4.911e-05, 0.000e+00, 1.260e-03 }, // CO
        { 1.393e-01, 7.328e-03, 4.641e-02, 0.000e+00, 0.000e+00, 1.730e-02, 0.000e+00 }, // HC
        { 2.049e+02, 2.200e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.353e+02, 0.000e+00 }, // FC
        { 4.529e+00, 0.000e+00, 5.443e-02, 0.000e+00, 1.247e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.549e+00, 0.000e+00, 1.283e-01, 0.000e+00, 1.263e-04, 2.772e-03, 1.759e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-VIs_A-C
        { 6.377e+02, 6.844e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.666e+03, 0.000e+00 }, // CO2(total)
        { 2.101e+00, 0.000e+00, 2.304e+00, 0.000e+00, 4.911e-05, 0.000e+00, 1.260e-03 }, // CO
        { 1.393e-01, 7.328e-03, 4.641e-02, 0.000e+00, 0.000e+00, 1.730e-02, 0.000e+00 }, // HC
        { 2.049e+02, 2.200e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.353e+02, 0.000e+00 }, // FC
        { 0.000e+00, 5.391e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.186e+01, 3.901e-02 }, // NOx
        { 1.549e+00, 0.000e+00, 1.283e-01, 0.000e+00, 1.263e-04, 2.772e-03, 1.759e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-VI_D-E
        { 1.934e+02, 7.077e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.596e+03, 4.021e+00 }, // CO2(total)
        { 9.441e-01, 0.000e+00, 7.025e-01, 0.000e+00, 2.066e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.976e-01, 5.032e-03, 0.000e+00, 8.333e-05, 0.000e+00, 2.010e-02, 8.898e-07 }, // HC
        { 6.216e+01, 2.274e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.128e+02, 1.292e+00 }, // FC
        { 1.692e+00, 4.764e-02, 7.204e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.103e-03 }, // NOx
        { 1.441e+00, 1.880e-03, 0.000e+00, 0.000e+00, 1.260e-04, 5.440e-03, 7.919e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt14-20t_Euro-VIs_D-E
        { 1.934e+02, 7.077e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.596e+03, 4.021e+00 }, // CO2(total)
        { 9.441e-01, 0.000e+00, 7.025e-01, 0.000e+00, 2.066e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.976e-01, 5.032e-03, 0.000e+00, 8.333e-05, 0.000e+00, 2.010e-02, 8.898e-07 }, // HC
        { 6.216e+01, 2.274e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.128e+02, 1.292e+00 }, // FC
        { 1.022e+01, 5.899e+00, 0.000e+00, 0.000e+00, 2.211e-04, 1.443e+01, 0.000e+00 }, // NOx
        { 1.441e+00, 1.880e-03, 0.000e+00, 0.000e+00, 1.260e-04, 5.440e-03, 7.919e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_50ties
        { 3.516e+03, 8.534e+02, 5.683e+03, 0.000e+00, 0.000e+00, 2.071e+03, 0.000e+00 }, // CO2(total)
        { 2.316e+01, 1.106e-01, 2.222e+01, 2.073e-02, 0.000e+00, 0.000e+00, 5.937e-02 }, // CO
        { 7.135e+00, 0.000e+00, 1.194e+00, 0.000e+00, 1.388e-04, 2.325e-01, 1.528e-03 }, // HC
        { 1.130e+03, 2.743e+02, 1.826e+03, 0.000e+00, 0.000e+00, 6.656e+02, 0.000e+00 }, // FC
        { 4.997e+01, 1.249e+01, 8.296e+01, 0.000e+00, 0.000e+00, 3.039e+01, 0.000e+00 }, // NOx
        { 5.068e+00, 2.344e-01, 2.521e+00, 0.000e+00, 1.265e-04, 4.755e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_60ties
        { 3.516e+03, 8.534e+02, 5.683e+03, 0.000e+00, 0.000e+00, 2.071e+03, 0.000e+00 }, // CO2(total)
        { 2.316e+01, 1.106e-01, 2.222e+01, 2.073e-02, 0.000e+00, 0.000e+00, 5.937e-02 }, // CO
        { 7.135e+00, 0.000e+00, 1.194e+00, 0.000e+00, 1.388e-04, 2.325e-01, 1.528e-03 }, // HC
        { 1.130e+03, 2.743e+02, 1.826e+03, 0.000e+00, 0.000e+00, 6.656e+02, 0.000e+00 }, // FC
        { 4.997e+01, 1.249e+01, 8.296e+01, 0.000e+00, 0.000e+00, 3.039e+01, 0.000e+00 }, // NOx
        { 5.068e+00, 2.344e-01, 2.521e+00, 0.000e+00, 1.265e-04, 4.755e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_70ties
        { 3.516e+03, 8.534e+02, 5.683e+03, 0.000e+00, 0.000e+00, 2.071e+03, 0.000e+00 }, // CO2(total)
        { 2.316e+01, 1.106e-01, 2.222e+01, 2.073e-02, 0.000e+00, 0.000e+00, 5.937e-02 }, // CO
        { 7.135e+00, 0.000e+00, 1.194e+00, 0.000e+00, 1.388e-04, 2.325e-01, 1.528e-03 }, // HC
        { 1.130e+03, 2.743e+02, 1.826e+03, 0.000e+00, 0.000e+00, 6.656e+02, 0.000e+00 }, // FC
        { 4.997e+01, 1.249e+01, 8.296e+01, 0.000e+00, 0.000e+00, 3.039e+01, 0.000e+00 }, // NOx
        { 5.068e+00, 2.344e-01, 2.521e+00, 0.000e+00, 1.265e-04, 4.755e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_80ties
        { 3.516e+03, 8.534e+02, 5.683e+03, 0.000e+00, 0.000e+00, 2.071e+03, 0.000e+00 }, // CO2(total)
        { 2.316e+01, 1.106e-01, 2.222e+01, 2.073e-02, 0.000e+00, 0.000e+00, 5.937e-02 }, // CO
        { 7.135e+00, 0.000e+00, 1.194e+00, 0.000e+00, 1.388e-04, 2.325e-01, 1.528e-03 }, // HC
        { 1.130e+03, 2.743e+02, 1.826e+03, 0.000e+00, 0.000e+00, 6.656e+02, 0.000e+00 }, // FC
        { 4.997e+01, 1.249e+01, 8.296e+01, 0.000e+00, 0.000e+00, 3.039e+01, 0.000e+00 }, // NOx
        { 5.068e+00, 2.344e-01, 2.521e+00, 0.000e+00, 1.265e-04, 4.755e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-I
        { 3.909e+03, 7.697e+02, 6.724e+03, 0.000e+00, 0.000e+00, 1.849e+03, 0.000e+00 }, // CO2(total)
        { 1.527e+01, 1.127e+00, 2.020e+01, 0.000e+00, 0.000e+00, 2.563e+00, 0.000e+00 }, // CO
        { 6.664e+00, 0.000e+00, 3.881e+00, 0.000e+00, 1.794e-04, 0.000e+00, 1.730e-02 }, // HC
        { 1.256e+03, 2.474e+02, 2.161e+03, 0.000e+00, 0.000e+00, 5.944e+02, 0.000e+00 }, // FC
        { 4.543e+01, 7.616e+00, 8.021e+01, 0.000e+00, 0.000e+00, 1.813e+01, 0.000e+00 }, // NOx
        { 4.224e+00, 1.950e-01, 0.000e+00, 0.000e+00, 1.277e-04, 5.350e-01, 8.564e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-II
        { 2.829e+03, 8.273e+02, 2.869e+03, 0.000e+00, 0.000e+00, 2.111e+03, 0.000e+00 }, // CO2(total)
        { 1.608e+01, 0.000e+00, 1.947e+01, 2.051e-02, 0.000e+00, 0.000e+00, 4.609e-02 }, // CO
        { 4.124e+00, 5.862e-02, 2.992e-01, 1.233e-03, 0.000e+00, 3.717e-01, 0.000e+00 }, // HC
        { 9.091e+02, 2.659e+02, 9.221e+02, 0.000e+00, 0.000e+00, 6.785e+02, 0.000e+00 }, // FC
        { 4.249e+01, 8.182e+00, 4.922e+01, 0.000e+00, 0.000e+00, 2.063e+01, 0.000e+00 }, // NOx
        { 2.520e+00, 1.111e-01, 9.988e-01, 0.000e+00, 1.262e-04, 1.836e-01, 2.030e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-III
        { 3.035e+03, 8.268e+02, 3.237e+03, 0.000e+00, 0.000e+00, 2.123e+03, 0.000e+00 }, // CO2(total)
        { 1.936e+01, 0.000e+00, 1.018e+01, 0.000e+00, 7.737e-04, 0.000e+00, 4.920e-02 }, // CO
        { 4.191e+00, 1.495e-02, 7.923e-01, 0.000e+00, 6.371e-05, 2.616e-01, 0.000e+00 }, // HC
        { 9.753e+02, 2.657e+02, 1.040e+03, 0.000e+00, 0.000e+00, 6.822e+02, 0.000e+00 }, // FC
        { 3.172e+01, 6.390e+00, 4.155e+01, 0.000e+00, 0.000e+00, 1.552e+01, 0.000e+00 }, // NOx
        { 3.010e+00, 7.491e-02, 0.000e+00, 0.000e+00, 1.261e-04, 1.921e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-IV_EGR
        { 2.459e+03, 8.546e+02, 3.458e+03, 0.000e+00, 0.000e+00, 2.154e+03, 0.000e+00 }, // CO2(total)
        { 8.824e+00, 3.715e-01, 1.849e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.897e-02 }, // CO
        { 6.557e-01, 0.000e+00, 9.909e-01, 0.000e+00, 3.484e-05, 0.000e+00, 1.804e-03 }, // HC
        { 7.903e+02, 2.747e+02, 1.111e+03, 0.000e+00, 0.000e+00, 6.924e+02, 0.000e+00 }, // FC
        { 3.614e+01, 4.176e+00, 5.652e+01, 0.000e+00, 0.000e+00, 1.039e+01, 0.000e+00 }, // NOx
        { 1.991e+00, 0.000e+00, 7.106e-01, 0.000e+00, 1.391e-04, 3.576e-03, 8.635e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-IV_SCR
        { 2.614e+03, 8.316e+02, 4.038e+03, 0.000e+00, 0.000e+00, 2.083e+03, 0.000e+00 }, // CO2(total)
        { 2.932e+01, 0.000e+00, 4.779e+01, 0.000e+00, 2.563e-04, 0.000e+00, 1.243e-02 }, // CO
        { 1.206e-01, 1.809e-02, 1.310e-01, 0.000e+00, 0.000e+00, 4.204e-02, 0.000e+00 }, // HC
        { 8.400e+02, 2.672e+02, 1.298e+03, 0.000e+00, 0.000e+00, 6.695e+02, 0.000e+00 }, // FC
        { 2.950e+01, 2.105e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.045e+00, 0.000e+00 }, // NOx
        { 2.017e+00, 0.000e+00, 8.747e-01, 0.000e+00, 1.374e-04, 3.578e-03, 6.359e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-IV_SCRs
        { 2.614e+03, 8.316e+02, 4.038e+03, 0.000e+00, 0.000e+00, 2.083e+03, 0.000e+00 }, // CO2(total)
        { 2.932e+01, 0.000e+00, 4.779e+01, 0.000e+00, 2.563e-04, 0.000e+00, 1.243e-02 }, // CO
        { 1.206e-01, 1.809e-02, 1.310e-01, 0.000e+00, 0.000e+00, 4.204e-02, 0.000e+00 }, // HC
        { 8.400e+02, 2.672e+02, 1.298e+03, 0.000e+00, 0.000e+00, 6.695e+02, 0.000e+00 }, // FC
        { 3.778e+01, 8.102e+00, 5.484e+01, 0.000e+00, 0.000e+00, 2.004e+01, 0.000e+00 }, // NOx
        { 2.017e+00, 0.000e+00, 8.747e-01, 0.000e+00, 1.374e-04, 3.578e-03, 6.359e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-V_EGR
        { 2.554e+03, 8.094e+02, 3.915e+03, 0.000e+00, 0.000e+00, 2.034e+03, 0.000e+00 }, // CO2(total)
        { 9.993e+00, 0.000e+00, 1.505e+01, 0.000e+00, 0.000e+00, 1.202e-01, 0.000e+00 }, // CO
        { 1.026e+00, 1.442e-02, 1.321e+00, 0.000e+00, 3.604e-05, 1.146e-02, 3.234e-03 }, // HC
        { 8.207e+02, 2.601e+02, 1.258e+03, 0.000e+00, 0.000e+00, 6.537e+02, 0.000e+00 }, // FC
        { 3.564e+01, 2.685e+00, 5.146e+01, 0.000e+00, 0.000e+00, 6.816e+00, 0.000e+00 }, // NOx
        { 1.637e+00, 2.276e-02, 2.355e-01, 1.270e-04, 1.251e-04, 6.661e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-V_SCR
        { 1.817e+03, 8.453e+02, 1.343e+03, 0.000e+00, 0.000e+00, 2.183e+03, 0.000e+00 }, // CO2(total)
        { 3.010e+01, 0.000e+00, 4.671e+01, 0.000e+00, 3.503e-04, 0.000e+00, 8.395e-03 }, // CO
        { 1.309e-01, 1.983e-02, 3.369e-02, 0.000e+00, 0.000e+00, 4.759e-02, 0.000e+00 }, // HC
        { 5.841e+02, 2.717e+02, 4.317e+02, 0.000e+00, 0.000e+00, 7.017e+02, 0.000e+00 }, // FC
        { 3.160e+01, 7.755e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.216e+00, 7.932e-02 }, // NOx
        { 2.081e+00, 0.000e+00, 9.407e-01, 0.000e+00, 1.390e-04, 3.217e-03, 5.987e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-V_SCRs
        { 1.817e+03, 8.453e+02, 1.343e+03, 0.000e+00, 0.000e+00, 2.183e+03, 0.000e+00 }, // CO2(total)
        { 3.010e+01, 0.000e+00, 4.671e+01, 0.000e+00, 3.503e-04, 0.000e+00, 8.395e-03 }, // CO
        { 1.309e-01, 1.983e-02, 3.369e-02, 0.000e+00, 0.000e+00, 4.759e-02, 0.000e+00 }, // HC
        { 5.841e+02, 2.717e+02, 4.317e+02, 0.000e+00, 0.000e+00, 7.017e+02, 0.000e+00 }, // FC
        { 4.108e+01, 8.279e+00, 3.218e+01, 0.000e+00, 0.000e+00, 2.096e+01, 0.000e+00 }, // NOx
        { 2.081e+00, 0.000e+00, 9.407e-01, 0.000e+00, 1.390e-04, 3.217e-03, 5.987e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-VI_A-C
        { 1.888e+03, 8.273e+02, 1.920e+03, 0.000e+00, 0.000e+00, 2.127e+03, 0.000e+00 }, // CO2(total)
        { 1.997e+00, 6.770e-02, 1.670e+00, 0.000e+00, 0.000e+00, 1.628e-01, 0.000e+00 }, // CO
        { 1.300e-01, 1.531e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.994e-02, 0.000e+00 }, // HC
        { 6.069e+02, 2.659e+02, 6.170e+02, 0.000e+00, 0.000e+00, 6.836e+02, 0.000e+00 }, // FC
        { 5.685e+00, 0.000e+00, 5.773e-01, 0.000e+00, 4.700e-05, 0.000e+00, 0.000e+00 }, // NOx
        { 1.570e+00, 0.000e+00, 1.545e-01, 0.000e+00, 1.260e-04, 3.229e-03, 5.224e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-VIs_A-C
        { 1.888e+03, 8.273e+02, 1.920e+03, 0.000e+00, 0.000e+00, 2.127e+03, 0.000e+00 }, // CO2(total)
        { 1.997e+00, 6.770e-02, 1.670e+00, 0.000e+00, 0.000e+00, 1.628e-01, 0.000e+00 }, // CO
        { 1.300e-01, 1.531e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.994e-02, 0.000e+00 }, // HC
        { 6.069e+02, 2.659e+02, 6.170e+02, 0.000e+00, 0.000e+00, 6.836e+02, 0.000e+00 }, // FC
        { 1.448e+01, 5.773e+00, 1.259e+01, 0.000e+00, 0.000e+00, 1.460e+01, 0.000e+00 }, // NOx
        { 1.570e+00, 0.000e+00, 1.545e-01, 0.000e+00, 1.260e-04, 3.229e-03, 5.224e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-VI_D-E
        { 1.462e+03, 8.469e+02, 5.765e+02, 0.000e+00, 0.000e+00, 2.189e+03, 0.000e+00 }, // CO2(total)
        { 6.939e-01, 0.000e+00, 7.279e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.679e-01, 6.243e-03, 8.448e-02, 3.129e-05, 0.000e+00, 1.759e-02, 0.000e+00 }, // HC
        { 4.698e+02, 2.722e+02, 1.853e+02, 0.000e+00, 0.000e+00, 7.036e+02, 0.000e+00 }, // FC
        { 2.207e+00, 0.000e+00, 2.240e-01, 0.000e+00, 1.828e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.449e+00, 2.494e-03, 1.690e-04, 0.000e+00, 1.260e-04, 9.617e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt20-26t_Euro-VIs_D-E
        { 1.462e+03, 8.469e+02, 5.765e+02, 0.000e+00, 0.000e+00, 2.189e+03, 0.000e+00 }, // CO2(total)
        { 6.939e-01, 0.000e+00, 7.279e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.679e-01, 6.243e-03, 8.448e-02, 3.129e-05, 0.000e+00, 1.759e-02, 0.000e+00 }, // HC
        { 4.698e+02, 2.722e+02, 1.853e+02, 0.000e+00, 0.000e+00, 7.036e+02, 0.000e+00 }, // FC
        { 4.701e+01, 4.254e+00, 1.289e+02, 0.000e+00, 1.753e-03, 2.980e+00, 3.014e-01 }, // NOx
        { 1.449e+00, 2.494e-03, 1.690e-04, 0.000e+00, 1.260e-04, 9.617e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_50ties
        { 5.114e+03, 7.994e+02, 1.105e+04, 0.000e+00, 0.000e+00, 1.751e+03, 0.000e+00 }, // CO2(total)
        { 3.620e+01, 2.273e+00, 4.907e+01, 0.000e+00, 0.000e+00, 5.532e+00, 0.000e+00 }, // CO
        { 1.256e+01, 0.000e+00, 1.601e-02, 0.000e+00, 5.126e-04, 0.000e+00, 3.800e-02 }, // HC
        { 1.643e+03, 2.569e+02, 3.552e+03, 0.000e+00, 0.000e+00, 5.626e+02, 0.000e+00 }, // FC
        { 9.358e+01, 1.165e+01, 1.709e+02, 0.000e+00, 0.000e+00, 2.786e+01, 0.000e+00 }, // NOx
        { 6.041e+00, 3.518e-01, 6.037e+00, 0.000e+00, 1.318e-04, 7.606e-01, 1.171e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_60ties
        { 5.114e+03, 7.994e+02, 1.105e+04, 0.000e+00, 0.000e+00, 1.751e+03, 0.000e+00 }, // CO2(total)
        { 3.620e+01, 2.273e+00, 4.907e+01, 0.000e+00, 0.000e+00, 5.532e+00, 0.000e+00 }, // CO
        { 1.256e+01, 0.000e+00, 1.601e-02, 0.000e+00, 5.126e-04, 0.000e+00, 3.800e-02 }, // HC
        { 1.643e+03, 2.569e+02, 3.552e+03, 0.000e+00, 0.000e+00, 5.626e+02, 0.000e+00 }, // FC
        { 9.358e+01, 1.165e+01, 1.709e+02, 0.000e+00, 0.000e+00, 2.786e+01, 0.000e+00 }, // NOx
        { 6.041e+00, 3.518e-01, 6.037e+00, 0.000e+00, 1.318e-04, 7.606e-01, 1.171e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_70ties
        { 5.114e+03, 7.994e+02, 1.105e+04, 0.000e+00, 0.000e+00, 1.751e+03, 0.000e+00 }, // CO2(total)
        { 3.620e+01, 2.273e+00, 4.907e+01, 0.000e+00, 0.000e+00, 5.532e+00, 0.000e+00 }, // CO
        { 1.256e+01, 0.000e+00, 1.601e-02, 0.000e+00, 5.126e-04, 0.000e+00, 3.800e-02 }, // HC
        { 1.643e+03, 2.569e+02, 3.552e+03, 0.000e+00, 0.000e+00, 5.626e+02, 0.000e+00 }, // FC
        { 9.358e+01, 1.165e+01, 1.709e+02, 0.000e+00, 0.000e+00, 2.786e+01, 0.000e+00 }, // NOx
        { 6.041e+00, 3.518e-01, 6.037e+00, 0.000e+00, 1.318e-04, 7.606e-01, 1.171e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_80ties
        { 5.114e+03, 7.994e+02, 1.105e+04, 0.000e+00, 0.000e+00, 1.751e+03, 0.000e+00 }, // CO2(total)
        { 3.620e+01, 2.273e+00, 4.907e+01, 0.000e+00, 0.000e+00, 5.532e+00, 0.000e+00 }, // CO
        { 1.256e+01, 0.000e+00, 1.601e-02, 0.000e+00, 5.126e-04, 0.000e+00, 3.800e-02 }, // HC
        { 1.643e+03, 2.569e+02, 3.552e+03, 0.000e+00, 0.000e+00, 5.626e+02, 0.000e+00 }, // FC
        { 9.358e+01, 1.165e+01, 1.709e+02, 0.000e+00, 0.000e+00, 2.786e+01, 0.000e+00 }, // NOx
        { 6.041e+00, 3.518e-01, 6.037e+00, 0.000e+00, 1.318e-04, 7.606e-01, 1.171e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-I
        { 5.792e+03, 7.121e+02, 1.391e+04, 0.000e+00, 0.000e+00, 1.504e+03, 0.000e+00 }, // CO2(total)
        { 1.642e+01, 9.706e-01, 1.349e+01, 0.000e+00, 0.000e+00, 2.430e+00, 0.000e+00 }, // CO
        { 6.143e+00, 0.000e+00, 3.489e+00, 0.000e+00, 4.498e-04, 0.000e+00, 2.768e-02 }, // HC
        { 1.861e+03, 2.289e+02, 4.471e+03, 0.000e+00, 0.000e+00, 4.834e+02, 0.000e+00 }, // FC
        { 7.694e+01, 5.561e+00, 1.609e+02, 0.000e+00, 0.000e+00, 1.300e+01, 0.000e+00 }, // NOx
        { 3.583e+00, 2.732e-01, 7.220e-02, 0.000e+00, 1.260e-04, 6.147e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-II
        { 4.277e+03, 7.851e+02, 8.677e+03, 0.000e+00, 0.000e+00, 1.774e+03, 0.000e+00 }, // CO2(total)
        { 2.094e+01, 2.322e-01, 4.370e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.172e+00, 0.000e+00, 1.746e+00, 0.000e+00, 2.541e-04, 0.000e+00, 1.655e-02 }, // HC
        { 1.374e+03, 2.523e+02, 2.789e+03, 0.000e+00, 0.000e+00, 5.701e+02, 0.000e+00 }, // FC
        { 6.937e+01, 6.316e+00, 1.172e+02, 0.000e+00, 0.000e+00, 1.593e+01, 0.000e+00 }, // NOx
        { 2.841e+00, 9.331e-02, 2.374e+00, 8.717e-04, 1.301e-04, 1.369e-01, 2.422e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-III
        { 3.778e+03, 8.675e+02, 7.057e+03, 0.000e+00, 0.000e+00, 2.047e+03, 0.000e+00 }, // CO2(total)
        { 2.009e+01, 0.000e+00, 1.018e+01, 0.000e+00, 8.235e-04, 0.000e+00, 5.180e-02 }, // CO
        { 4.156e+00, 0.000e+00, 2.029e+00, 0.000e+00, 1.878e-04, 0.000e+00, 1.267e-02 }, // HC
        { 1.214e+03, 2.788e+02, 2.268e+03, 0.000e+00, 0.000e+00, 6.580e+02, 0.000e+00 }, // FC
        { 5.217e+01, 5.362e+00, 7.844e+01, 0.000e+00, 0.000e+00, 1.456e+01, 0.000e+00 }, // NOx
        { 2.834e+00, 9.009e-02, 0.000e+00, 6.583e-04, 1.264e-04, 1.840e-01, 1.369e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-IV_EGR
        { 3.241e+03, 8.935e+02, 6.932e+03, 0.000e+00, 0.000e+00, 2.113e+03, 0.000e+00 }, // CO2(total)
        { 1.005e+01, 3.568e-01, 2.529e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.489e-01, 0.000e+00, 1.240e+00, 0.000e+00, 5.769e-05, 6.948e-03, 0.000e+00 }, // HC
        { 1.041e+03, 2.871e+02, 2.228e+03, 0.000e+00, 0.000e+00, 6.792e+02, 0.000e+00 }, // FC
        { 5.554e+01, 2.821e+00, 1.007e+02, 0.000e+00, 0.000e+00, 7.684e+00, 0.000e+00 }, // NOx
        { 1.976e+00, 0.000e+00, 8.639e-01, 0.000e+00, 1.414e-04, 3.398e-03, 2.726e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-IV_SCR
        { 3.475e+03, 8.610e+02, 7.732e+03, 0.000e+00, 0.000e+00, 2.014e+03, 0.000e+00 }, // CO2(total)
        { 2.810e+01, 0.000e+00, 4.629e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.974e-01, 8.066e-03, 1.678e-01, 0.000e+00, 3.156e-05, 3.966e-02, 0.000e+00 }, // HC
        { 1.117e+03, 2.767e+02, 2.485e+03, 0.000e+00, 0.000e+00, 6.472e+02, 0.000e+00 }, // FC
        { 2.767e+01, 2.651e+00, 3.013e+00, 0.000e+00, 0.000e+00, 7.380e+00, 0.000e+00 }, // NOx
        { 1.980e+00, 0.000e+00, 8.624e-01, 0.000e+00, 1.457e-04, 3.075e-03, 5.686e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-IV_SCRs
        { 3.475e+03, 8.610e+02, 7.732e+03, 0.000e+00, 0.000e+00, 2.014e+03, 0.000e+00 }, // CO2(total)
        { 2.810e+01, 0.000e+00, 4.629e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.974e-01, 8.066e-03, 1.678e-01, 0.000e+00, 3.156e-05, 3.966e-02, 0.000e+00 }, // HC
        { 1.117e+03, 2.767e+02, 2.485e+03, 0.000e+00, 0.000e+00, 6.472e+02, 0.000e+00 }, // FC
        { 5.618e+01, 7.584e+00, 1.067e+02, 0.000e+00, 0.000e+00, 1.833e+01, 0.000e+00 }, // NOx
        { 1.980e+00, 0.000e+00, 8.624e-01, 0.000e+00, 1.457e-04, 3.075e-03, 5.686e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-V_EGR
        { 3.551e+03, 8.326e+02, 8.006e+03, 0.000e+00, 0.000e+00, 1.954e+03, 0.000e+00 }, // CO2(total)
        { 7.360e+00, 0.000e+00, 9.630e+00, 0.000e+00, 4.898e-05, 0.000e+00, 0.000e+00 }, // CO
        { 1.081e+00, 0.000e+00, 1.287e+00, 0.000e+00, 6.947e-05, 2.501e-02, 2.086e-03 }, // HC
        { 1.141e+03, 2.676e+02, 2.573e+03, 0.000e+00, 0.000e+00, 6.278e+02, 0.000e+00 }, // FC
        { 4.480e+01, 1.750e+00, 9.448e+01, 0.000e+00, 0.000e+00, 2.843e+00, 0.000e+00 }, // NOx
        { 1.742e+00, 9.257e-03, 6.819e-02, 0.000e+00, 1.926e-04, 7.735e-02, 1.487e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-V_SCR
        { 3.618e+03, 8.014e+02, 8.274e+03, 0.000e+00, 0.000e+00, 1.866e+03, 0.000e+00 }, // CO2(total)
        { 2.680e+01, 0.000e+00, 4.341e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.832e-01, 0.000e+00, 6.679e-02, 0.000e+00, 3.439e-05, 4.158e-02, 0.000e+00 }, // HC
        { 1.163e+03, 2.576e+02, 2.659e+03, 0.000e+00, 0.000e+00, 5.998e+02, 0.000e+00 }, // FC
        { 2.970e+01, 9.350e-01, 0.000e+00, 0.000e+00, 0.000e+00, 2.269e+00, 5.936e-02 }, // NOx
        { 1.997e+00, 0.000e+00, 8.210e-01, 0.000e+00, 1.439e-04, 2.580e-04, 6.737e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-V_SCRs
        { 3.618e+03, 8.014e+02, 8.274e+03, 0.000e+00, 0.000e+00, 1.866e+03, 0.000e+00 }, // CO2(total)
        { 2.680e+01, 0.000e+00, 4.341e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.832e-01, 0.000e+00, 6.679e-02, 0.000e+00, 3.439e-05, 4.158e-02, 0.000e+00 }, // HC
        { 1.163e+03, 2.576e+02, 2.659e+03, 0.000e+00, 0.000e+00, 5.998e+02, 0.000e+00 }, // FC
        { 6.404e+01, 7.355e+00, 9.550e+01, 0.000e+00, 0.000e+00, 1.897e+01, 0.000e+00 }, // NOx
        { 1.997e+00, 0.000e+00, 8.210e-01, 0.000e+00, 1.439e-04, 2.580e-04, 6.737e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-VI_A-C
        { 2.835e+03, 8.498e+02, 6.085e+03, 0.000e+00, 0.000e+00, 2.025e+03, 0.000e+00 }, // CO2(total)
        { 1.740e+00, 1.008e-01, 2.936e+00, 0.000e+00, 0.000e+00, 6.100e-02, 0.000e+00 }, // CO
        { 1.106e-01, 1.816e-02, 1.546e-01, 0.000e+00, 0.000e+00, 2.453e-02, 0.000e+00 }, // HC
        { 9.113e+02, 2.731e+02, 1.956e+03, 0.000e+00, 0.000e+00, 6.507e+02, 0.000e+00 }, // FC
        { 4.510e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.771e-04, 0.000e+00, 1.068e-02 }, // NOx
        { 1.532e+00, 0.000e+00, 7.256e-02, 0.000e+00, 1.455e-04, 2.467e-03, 6.673e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-VIs_A-C
        { 2.835e+03, 8.498e+02, 6.085e+03, 0.000e+00, 0.000e+00, 2.025e+03, 0.000e+00 }, // CO2(total)
        { 1.740e+00, 1.008e-01, 2.936e+00, 0.000e+00, 0.000e+00, 6.100e-02, 0.000e+00 }, // CO
        { 1.106e-01, 1.816e-02, 1.546e-01, 0.000e+00, 0.000e+00, 2.453e-02, 0.000e+00 }, // HC
        { 9.113e+02, 2.731e+02, 1.956e+03, 0.000e+00, 0.000e+00, 6.507e+02, 0.000e+00 }, // FC
        { 2.415e+01, 5.867e+00, 5.082e+01, 0.000e+00, 0.000e+00, 1.391e+01, 0.000e+00 }, // NOx
        { 1.532e+00, 0.000e+00, 7.256e-02, 0.000e+00, 1.455e-04, 2.467e-03, 6.673e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-VI_D-E
        { 2.452e+03, 8.716e+02, 4.939e+03, 0.000e+00, 0.000e+00, 2.086e+03, 0.000e+00 }, // CO2(total)
        { 5.513e-01, 0.000e+00, 8.734e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.014e-01, 0.000e+00, 2.850e-01, 0.000e+00, 2.625e-05, 3.219e-03, 0.000e+00 }, // HC
        { 7.881e+02, 2.801e+02, 1.587e+03, 0.000e+00, 0.000e+00, 6.705e+02, 0.000e+00 }, // FC
        { 2.046e+00, 0.000e+00, 1.407e-01, 0.000e+00, 2.788e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.444e+00, 3.378e-03, 7.373e-03, 0.000e+00, 1.256e-04, 9.015e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt26-28t_Euro-VIs_D-E
        { 2.452e+03, 8.716e+02, 4.939e+03, 0.000e+00, 0.000e+00, 2.086e+03, 0.000e+00 }, // CO2(total)
        { 5.513e-01, 0.000e+00, 8.734e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.014e-01, 0.000e+00, 2.850e-01, 0.000e+00, 2.625e-05, 3.219e-03, 0.000e+00 }, // HC
        { 7.881e+02, 2.801e+02, 1.587e+03, 0.000e+00, 0.000e+00, 6.705e+02, 0.000e+00 }, // FC
        { 5.941e+01, 4.536e+00, 1.233e+02, 0.000e+00, 0.000e+00, 1.026e+01, 0.000e+00 }, // NOx
        { 1.444e+00, 3.378e-03, 7.373e-03, 0.000e+00, 1.256e-04, 9.015e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_50ties
        { 5.797e+03, 8.875e+02, 1.193e+04, 0.000e+00, 0.000e+00, 2.003e+03, 0.000e+00 }, // CO2(total)
        { 3.041e+01, 5.347e-01, 5.220e+01, 0.000e+00, 0.000e+00, 2.754e-01, 0.000e+00 }, // CO
        { 7.351e+00, 0.000e+00, 7.604e-01, 0.000e+00, 4.739e-04, 0.000e+00, 1.572e-02 }, // HC
        { 1.863e+03, 2.852e+02, 3.835e+03, 0.000e+00, 0.000e+00, 6.438e+02, 0.000e+00 }, // FC
        { 8.945e+01, 1.241e+01, 1.673e+02, 0.000e+00, 0.000e+00, 2.977e+01, 0.000e+00 }, // NOx
        { 6.210e+00, 2.737e-01, 9.252e+00, 0.000e+00, 1.325e-04, 1.546e-01, 1.221e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_60ties
        { 5.797e+03, 8.875e+02, 1.193e+04, 0.000e+00, 0.000e+00, 2.003e+03, 0.000e+00 }, // CO2(total)
        { 3.041e+01, 5.347e-01, 5.220e+01, 0.000e+00, 0.000e+00, 2.754e-01, 0.000e+00 }, // CO
        { 7.351e+00, 0.000e+00, 7.604e-01, 0.000e+00, 4.739e-04, 0.000e+00, 1.572e-02 }, // HC
        { 1.863e+03, 2.852e+02, 3.835e+03, 0.000e+00, 0.000e+00, 6.438e+02, 0.000e+00 }, // FC
        { 8.945e+01, 1.241e+01, 1.673e+02, 0.000e+00, 0.000e+00, 2.977e+01, 0.000e+00 }, // NOx
        { 6.210e+00, 2.737e-01, 9.252e+00, 0.000e+00, 1.325e-04, 1.546e-01, 1.221e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_70ties
        { 5.797e+03, 8.875e+02, 1.193e+04, 0.000e+00, 0.000e+00, 2.003e+03, 0.000e+00 }, // CO2(total)
        { 3.041e+01, 5.347e-01, 5.220e+01, 0.000e+00, 0.000e+00, 2.754e-01, 0.000e+00 }, // CO
        { 7.351e+00, 0.000e+00, 7.604e-01, 0.000e+00, 4.739e-04, 0.000e+00, 1.572e-02 }, // HC
        { 1.863e+03, 2.852e+02, 3.835e+03, 0.000e+00, 0.000e+00, 6.438e+02, 0.000e+00 }, // FC
        { 8.945e+01, 1.241e+01, 1.673e+02, 0.000e+00, 0.000e+00, 2.977e+01, 0.000e+00 }, // NOx
        { 6.210e+00, 2.737e-01, 9.252e+00, 0.000e+00, 1.325e-04, 1.546e-01, 1.221e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_80ties
        { 5.797e+03, 8.875e+02, 1.193e+04, 0.000e+00, 0.000e+00, 2.003e+03, 0.000e+00 }, // CO2(total)
        { 3.041e+01, 5.347e-01, 5.220e+01, 0.000e+00, 0.000e+00, 2.754e-01, 0.000e+00 }, // CO
        { 7.351e+00, 0.000e+00, 7.604e-01, 0.000e+00, 4.739e-04, 0.000e+00, 1.572e-02 }, // HC
        { 1.863e+03, 2.852e+02, 3.835e+03, 0.000e+00, 0.000e+00, 6.438e+02, 0.000e+00 }, // FC
        { 8.945e+01, 1.241e+01, 1.673e+02, 0.000e+00, 0.000e+00, 2.977e+01, 0.000e+00 }, // NOx
        { 6.210e+00, 2.737e-01, 9.252e+00, 0.000e+00, 1.325e-04, 1.546e-01, 1.221e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-I
        { 6.127e+03, 8.312e+02, 1.322e+04, 0.000e+00, 0.000e+00, 1.868e+03, 0.000e+00 }, // CO2(total)
        { 1.958e+01, 1.031e+00, 2.605e+01, 0.000e+00, 0.000e+00, 2.267e+00, 0.000e+00 }, // CO
        { 7.250e+00, 0.000e+00, 3.765e+00, 0.000e+00, 4.764e-04, 0.000e+00, 3.067e-02 }, // HC
        { 1.969e+03, 2.671e+02, 4.249e+03, 0.000e+00, 0.000e+00, 6.002e+02, 0.000e+00 }, // FC
        { 8.321e+01, 6.762e+00, 1.579e+02, 0.000e+00, 0.000e+00, 1.692e+01, 0.000e+00 }, // NOx
        { 4.192e+00, 2.951e-01, 2.260e-01, 0.000e+00, 1.298e-04, 6.948e-01, 9.257e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-II
        { 5.117e+03, 8.587e+02, 1.020e+04, 0.000e+00, 0.000e+00, 1.981e+03, 0.000e+00 }, // CO2(total)
        { 2.382e+01, 2.719e-01, 5.098e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.849e+00, 0.000e+00, 1.927e+00, 0.000e+00, 2.845e-04, 0.000e+00, 1.934e-02 }, // HC
        { 1.645e+03, 2.760e+02, 3.277e+03, 0.000e+00, 0.000e+00, 6.368e+02, 0.000e+00 }, // FC
        { 8.345e+01, 6.856e+00, 1.408e+02, 0.000e+00, 0.000e+00, 1.779e+01, 0.000e+00 }, // NOx
        { 2.824e+00, 1.381e-01, 2.145e+00, 0.000e+00, 1.301e-04, 2.444e-01, 7.529e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-III
        { 5.713e+03, 8.373e+02, 1.201e+04, 0.000e+00, 0.000e+00, 1.929e+03, 0.000e+00 }, // CO2(total)
        { 1.996e+01, 3.068e-01, 2.052e+01, 1.135e-02, 0.000e+00, 0.000e+00, 4.615e-02 }, // CO
        { 4.313e+00, 0.000e+00, 1.825e+00, 0.000e+00, 1.994e-04, 0.000e+00, 1.451e-02 }, // HC
        { 1.836e+03, 2.691e+02, 3.858e+03, 0.000e+00, 0.000e+00, 6.201e+02, 0.000e+00 }, // FC
        { 7.156e+01, 5.053e+00, 1.299e+02, 0.000e+00, 0.000e+00, 1.349e+01, 0.000e+00 }, // NOx
        { 3.534e+00, 6.129e-03, 0.000e+00, 3.344e-03, 1.280e-04, 1.745e-01, 2.344e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-IV_EGR
        { 5.218e+03, 8.529e+02, 1.190e+04, 0.000e+00, 0.000e+00, 1.965e+03, 0.000e+00 }, // CO2(total)
        { 1.182e+01, 4.042e-01, 3.163e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.330e-01, 6.102e-03, 1.919e+00, 0.000e+00, 4.303e-05, 0.000e+00, 0.000e+00 }, // HC
        { 1.677e+03, 2.741e+02, 3.824e+03, 0.000e+00, 0.000e+00, 6.316e+02, 0.000e+00 }, // FC
        { 9.176e+01, 1.531e+00, 2.180e+02, 0.000e+00, 0.000e+00, 3.207e+00, 0.000e+00 }, // NOx
        { 2.089e+00, 0.000e+00, 1.196e+00, 0.000e+00, 1.393e-04, 0.000e+00, 8.129e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-IV_SCR
        { 5.592e+03, 8.014e+02, 1.288e+04, 0.000e+00, 0.000e+00, 1.822e+03, 0.000e+00 }, // CO2(total)
        { 3.720e+01, 0.000e+00, 7.678e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.162e-01, 0.000e+00, 3.576e-01, 0.000e+00, 3.920e-05, 3.236e-02, 0.000e+00 }, // HC
        { 1.797e+03, 2.576e+02, 4.139e+03, 0.000e+00, 0.000e+00, 5.857e+02, 0.000e+00 }, // FC
        { 3.415e+01, 2.562e+00, 1.297e+01, 0.000e+00, 0.000e+00, 7.369e+00, 0.000e+00 }, // NOx
        { 2.103e+00, 0.000e+00, 1.400e+00, 0.000e+00, 1.428e-04, 1.775e-03, 6.676e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-IV_SCRs
        { 5.592e+03, 8.014e+02, 1.288e+04, 0.000e+00, 0.000e+00, 1.822e+03, 0.000e+00 }, // CO2(total)
        { 3.720e+01, 0.000e+00, 7.678e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.162e-01, 0.000e+00, 3.576e-01, 0.000e+00, 3.920e-05, 3.236e-02, 0.000e+00 }, // HC
        { 1.797e+03, 2.576e+02, 4.139e+03, 0.000e+00, 0.000e+00, 5.857e+02, 0.000e+00 }, // FC
        { 7.245e+01, 7.421e+00, 1.362e+02, 0.000e+00, 0.000e+00, 1.803e+01, 0.000e+00 }, // NOx
        { 2.103e+00, 0.000e+00, 1.400e+00, 0.000e+00, 1.428e-04, 1.775e-03, 6.676e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-V_EGR
        { 4.439e+03, 9.030e+02, 9.833e+03, 0.000e+00, 0.000e+00, 2.159e+03, 0.000e+00 }, // CO2(total)
        { 8.456e+00, 0.000e+00, 1.120e+01, 0.000e+00, 4.453e-05, 0.000e+00, 0.000e+00 }, // CO
        { 1.246e+00, 0.000e+00, 1.400e+00, 0.000e+00, 7.569e-05, 4.301e-02, 1.887e-03 }, // HC
        { 1.427e+03, 2.902e+02, 3.160e+03, 0.000e+00, 0.000e+00, 6.940e+02, 0.000e+00 }, // FC
        { 5.278e+01, 1.867e+00, 1.110e+02, 0.000e+00, 0.000e+00, 3.073e+00, 0.000e+00 }, // NOx
        { 1.789e+00, 1.095e-02, 3.878e-02, 0.000e+00, 1.989e-04, 9.659e-02, 1.352e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-V_SCR
        { 4.513e+03, 8.685e+02, 1.017e+04, 0.000e+00, 0.000e+00, 2.061e+03, 0.000e+00 }, // CO2(total)
        { 3.040e+01, 0.000e+00, 4.983e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.248e-01, 4.692e-04, 8.697e-02, 0.000e+00, 3.764e-05, 4.736e-02, 0.000e+00 }, // HC
        { 1.450e+03, 2.791e+02, 3.267e+03, 0.000e+00, 0.000e+00, 6.622e+02, 0.000e+00 }, // FC
        { 3.573e+01, 9.250e-01, 0.000e+00, 0.000e+00, 0.000e+00, 2.715e+00, 6.230e-02 }, // NOx
        { 2.082e+00, 0.000e+00, 9.584e-01, 0.000e+00, 1.453e-04, 7.276e-04, 6.700e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-V_SCRs
        { 4.513e+03, 8.685e+02, 1.017e+04, 0.000e+00, 0.000e+00, 2.061e+03, 0.000e+00 }, // CO2(total)
        { 3.040e+01, 0.000e+00, 4.983e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.248e-01, 4.692e-04, 8.697e-02, 0.000e+00, 3.764e-05, 4.736e-02, 0.000e+00 }, // HC
        { 1.450e+03, 2.791e+02, 3.267e+03, 0.000e+00, 0.000e+00, 6.622e+02, 0.000e+00 }, // FC
        { 7.836e+01, 7.992e+00, 1.194e+02, 0.000e+00, 0.000e+00, 2.108e+01, 0.000e+00 }, // NOx
        { 2.082e+00, 0.000e+00, 9.584e-01, 0.000e+00, 1.453e-04, 7.276e-04, 6.700e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-VI_A-C
        { 4.464e+03, 8.480e+02, 1.013e+04, 0.000e+00, 0.000e+00, 2.009e+03, 0.000e+00 }, // CO2(total)
        { 2.461e+00, 0.000e+00, 2.239e+00, 0.000e+00, 1.281e-04, 0.000e+00, 2.574e-03 }, // CO
        { 1.462e-01, 1.395e-02, 1.664e-01, 7.343e-05, 0.000e+00, 1.771e-02, 0.000e+00 }, // HC
        { 1.435e+03, 2.725e+02, 3.256e+03, 0.000e+00, 0.000e+00, 6.455e+02, 0.000e+00 }, // FC
        { 4.901e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.579e-04, 0.000e+00, 1.423e-02 }, // NOx
        { 1.507e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.490e-04, 0.000e+00, 9.799e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-VIs_A-C
        { 4.464e+03, 8.480e+02, 1.013e+04, 0.000e+00, 0.000e+00, 2.009e+03, 0.000e+00 }, // CO2(total)
        { 2.461e+00, 0.000e+00, 2.239e+00, 0.000e+00, 1.281e-04, 0.000e+00, 2.574e-03 }, // CO
        { 1.462e-01, 1.395e-02, 1.664e-01, 7.343e-05, 0.000e+00, 1.771e-02, 0.000e+00 }, // HC
        { 1.435e+03, 2.725e+02, 3.256e+03, 0.000e+00, 0.000e+00, 6.455e+02, 0.000e+00 }, // FC
        { 4.690e+01, 5.864e+00, 1.243e+02, 0.000e+00, 0.000e+00, 1.352e+01, 0.000e+00 }, // NOx
        { 1.507e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.490e-04, 0.000e+00, 9.799e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-VI_D-E
        { 3.849e+03, 9.019e+02, 8.359e+03, 0.000e+00, 0.000e+00, 2.175e+03, 0.000e+00 }, // CO2(total)
        { 4.584e-01, 0.000e+00, 4.680e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.445e-01, 0.000e+00, 2.969e-01, 0.000e+00, 2.964e-05, 1.043e-02, 0.000e+00 }, // HC
        { 1.237e+03, 2.899e+02, 2.686e+03, 0.000e+00, 0.000e+00, 6.990e+02, 0.000e+00 }, // FC
        { 2.243e+00, 0.000e+00, 5.690e-01, 0.000e+00, 2.571e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.446e+00, 3.661e-03, 1.576e-02, 0.000e+00, 1.265e-04, 1.067e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt28-32t_Euro-VIs_D-E
        { 3.849e+03, 9.019e+02, 8.359e+03, 0.000e+00, 0.000e+00, 2.175e+03, 0.000e+00 }, // CO2(total)
        { 4.584e-01, 0.000e+00, 4.680e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.445e-01, 0.000e+00, 2.969e-01, 0.000e+00, 2.964e-05, 1.043e-02, 0.000e+00 }, // HC
        { 1.237e+03, 2.899e+02, 2.686e+03, 0.000e+00, 0.000e+00, 6.990e+02, 0.000e+00 }, // FC
        { 7.174e+01, 4.822e+00, 1.482e+02, 0.000e+00, 0.000e+00, 1.139e+01, 0.000e+00 }, // NOx
        { 1.446e+00, 3.661e-03, 1.576e-02, 0.000e+00, 1.265e-04, 1.067e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_50ties
        { 6.919e+03, 8.973e+02, 1.453e+04, 0.000e+00, 0.000e+00, 2.034e+03, 0.000e+00 }, // CO2(total)
        { 3.116e+01, 6.242e-01, 5.159e+01, 0.000e+00, 0.000e+00, 5.160e-01, 0.000e+00 }, // CO
        { 7.871e+00, 0.000e+00, 1.263e+00, 0.000e+00, 4.954e-04, 0.000e+00, 1.597e-02 }, // HC
        { 2.224e+03, 2.884e+02, 4.669e+03, 0.000e+00, 0.000e+00, 6.536e+02, 0.000e+00 }, // FC
        { 1.074e+02, 1.256e+01, 2.088e+02, 0.000e+00, 0.000e+00, 3.023e+01, 0.000e+00 }, // NOx
        { 6.486e+00, 2.926e-01, 9.734e+00, 0.000e+00, 1.322e-04, 1.693e-01, 1.181e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_60ties
        { 6.919e+03, 8.973e+02, 1.453e+04, 0.000e+00, 0.000e+00, 2.034e+03, 0.000e+00 }, // CO2(total)
        { 3.116e+01, 6.242e-01, 5.159e+01, 0.000e+00, 0.000e+00, 5.160e-01, 0.000e+00 }, // CO
        { 7.871e+00, 0.000e+00, 1.263e+00, 0.000e+00, 4.954e-04, 0.000e+00, 1.597e-02 }, // HC
        { 2.224e+03, 2.884e+02, 4.669e+03, 0.000e+00, 0.000e+00, 6.536e+02, 0.000e+00 }, // FC
        { 1.074e+02, 1.256e+01, 2.088e+02, 0.000e+00, 0.000e+00, 3.023e+01, 0.000e+00 }, // NOx
        { 6.486e+00, 2.926e-01, 9.734e+00, 0.000e+00, 1.322e-04, 1.693e-01, 1.181e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_70ties
        { 6.919e+03, 8.973e+02, 1.453e+04, 0.000e+00, 0.000e+00, 2.034e+03, 0.000e+00 }, // CO2(total)
        { 3.116e+01, 6.242e-01, 5.159e+01, 0.000e+00, 0.000e+00, 5.160e-01, 0.000e+00 }, // CO
        { 7.871e+00, 0.000e+00, 1.263e+00, 0.000e+00, 4.954e-04, 0.000e+00, 1.597e-02 }, // HC
        { 2.224e+03, 2.884e+02, 4.669e+03, 0.000e+00, 0.000e+00, 6.536e+02, 0.000e+00 }, // FC
        { 1.074e+02, 1.256e+01, 2.088e+02, 0.000e+00, 0.000e+00, 3.023e+01, 0.000e+00 }, // NOx
        { 6.486e+00, 2.926e-01, 9.734e+00, 0.000e+00, 1.322e-04, 1.693e-01, 1.181e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_80ties
        { 6.919e+03, 8.973e+02, 1.453e+04, 0.000e+00, 0.000e+00, 2.034e+03, 0.000e+00 }, // CO2(total)
        { 3.116e+01, 6.242e-01, 5.159e+01, 0.000e+00, 0.000e+00, 5.160e-01, 0.000e+00 }, // CO
        { 7.871e+00, 0.000e+00, 1.263e+00, 0.000e+00, 4.954e-04, 0.000e+00, 1.597e-02 }, // HC
        { 2.224e+03, 2.884e+02, 4.669e+03, 0.000e+00, 0.000e+00, 6.536e+02, 0.000e+00 }, // FC
        { 1.074e+02, 1.256e+01, 2.088e+02, 0.000e+00, 0.000e+00, 3.023e+01, 0.000e+00 }, // NOx
        { 6.486e+00, 2.926e-01, 9.734e+00, 0.000e+00, 1.322e-04, 1.693e-01, 1.181e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-I
        { 7.809e+03, 8.108e+02, 1.804e+04, 0.000e+00, 0.000e+00, 1.797e+03, 0.000e+00 }, // CO2(total)
        { 1.648e+01, 1.398e+00, 7.333e+00, 0.000e+00, 0.000e+00, 3.644e+00, 0.000e+00 }, // CO
        { 7.907e+00, 0.000e+00, 5.102e+00, 0.000e+00, 4.868e-04, 0.000e+00, 3.130e-02 }, // HC
        { 2.510e+03, 2.606e+02, 5.799e+03, 0.000e+00, 0.000e+00, 5.776e+02, 0.000e+00 }, // FC
        { 1.021e+02, 6.462e+00, 2.075e+02, 0.000e+00, 0.000e+00, 1.613e+01, 0.000e+00 }, // NOx
        { 4.643e+00, 2.995e-01, 1.070e+00, 0.000e+00, 1.266e-04, 7.073e-01, 8.206e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-II
        { 6.119e+03, 8.727e+02, 1.248e+04, 0.000e+00, 0.000e+00, 2.023e+03, 0.000e+00 }, // CO2(total)
        { 2.525e+01, 2.839e-01, 5.410e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.185e+00, 0.000e+00, 2.410e+00, 3.984e-04, 2.723e-04, 0.000e+00, 1.977e-02 }, // HC
        { 1.966e+03, 2.805e+02, 4.011e+03, 0.000e+00, 0.000e+00, 6.501e+02, 0.000e+00 }, // FC
        { 9.479e+01, 6.974e+00, 1.624e+02, 0.000e+00, 0.000e+00, 1.839e+01, 0.000e+00 }, // NOx
        { 2.975e+00, 1.435e-01, 2.489e+00, 0.000e+00, 1.301e-04, 2.500e-01, 8.324e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-III
        { 6.609e+03, 8.382e+02, 1.368e+04, 0.000e+00, 0.000e+00, 1.939e+03, 0.000e+00 }, // CO2(total)
        { 2.516e+01, 3.090e-01, 3.605e+01, 0.000e+00, 1.997e-04, 0.000e+00, 2.226e-02 }, // CO
        { 4.556e+00, 0.000e+00, 1.911e+00, 0.000e+00, 2.067e-04, 0.000e+00, 1.570e-02 }, // HC
        { 2.124e+03, 2.694e+02, 4.396e+03, 0.000e+00, 0.000e+00, 6.231e+02, 0.000e+00 }, // FC
        { 8.252e+01, 4.951e+00, 1.532e+02, 0.000e+00, 0.000e+00, 1.333e+01, 0.000e+00 }, // NOx
        { 3.712e+00, 7.743e-03, 5.387e-01, 3.236e-03, 1.302e-04, 1.556e-01, 2.649e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-IV_EGR
        { 6.236e+03, 8.590e+02, 1.421e+04, 0.000e+00, 0.000e+00, 1.986e+03, 0.000e+00 }, // CO2(total)
        { 1.330e+01, 4.101e-01, 3.510e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.461e-01, 3.114e-02, 1.986e+00, 0.000e+00, 1.900e-05, 4.545e-03, 0.000e+00 }, // HC
        { 2.004e+03, 2.761e+02, 4.567e+03, 0.000e+00, 0.000e+00, 6.381e+02, 0.000e+00 }, // FC
        { 9.845e+01, 1.526e+00, 2.290e+02, 0.000e+00, 0.000e+00, 3.397e+00, 0.000e+00 }, // NOx
        { 2.129e+00, 0.000e+00, 1.286e+00, 0.000e+00, 1.405e-04, 0.000e+00, 7.758e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-IV_SCR
        { 7.462e+03, 7.284e+02, 1.788e+04, 0.000e+00, 0.000e+00, 1.599e+03, 0.000e+00 }, // CO2(total)
        { 4.237e+01, 0.000e+00, 8.850e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.983e-01, 5.161e-03, 3.806e-01, 0.000e+00, 3.519e-05, 3.623e-02, 0.000e+00 }, // HC
        { 2.398e+03, 2.341e+02, 5.747e+03, 0.000e+00, 0.000e+00, 5.138e+02, 0.000e+00 }, // FC
        { 4.162e+01, 2.268e+00, 2.836e+01, 0.000e+00, 0.000e+00, 6.677e+00, 0.000e+00 }, // NOx
        { 2.015e+00, 1.693e-02, 1.241e+00, 0.000e+00, 1.277e-04, 2.548e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-IV_SCRs
        { 7.462e+03, 7.284e+02, 1.788e+04, 0.000e+00, 0.000e+00, 1.599e+03, 0.000e+00 }, // CO2(total)
        { 4.237e+01, 0.000e+00, 8.850e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.983e-01, 5.161e-03, 3.806e-01, 0.000e+00, 3.519e-05, 3.623e-02, 0.000e+00 }, // HC
        { 2.398e+03, 2.341e+02, 5.747e+03, 0.000e+00, 0.000e+00, 5.138e+02, 0.000e+00 }, // FC
        { 9.484e+01, 6.395e+00, 1.962e+02, 0.000e+00, 0.000e+00, 1.490e+01, 0.000e+00 }, // NOx
        { 2.015e+00, 1.693e-02, 1.241e+00, 0.000e+00, 1.277e-04, 2.548e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-V_EGR
        { 5.729e+03, 8.740e+02, 1.314e+04, 0.000e+00, 0.000e+00, 2.051e+03, 0.000e+00 }, // CO2(total)
        { 1.009e+01, 0.000e+00, 1.535e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.330e+00, 5.986e-03, 1.340e+00, 0.000e+00, 6.678e-05, 1.014e-01, 0.000e+00 }, // HC
        { 1.841e+03, 2.809e+02, 4.223e+03, 0.000e+00, 0.000e+00, 6.592e+02, 0.000e+00 }, // FC
        { 6.925e+01, 1.450e+00, 1.649e+02, 0.000e+00, 0.000e+00, 1.495e+00, 0.000e+00 }, // NOx
        { 1.822e+00, 0.000e+00, 4.046e-01, 0.000e+00, 2.244e-04, 0.000e+00, 5.240e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-V_SCR
        { 5.631e+03, 8.437e+02, 1.277e+04, 0.000e+00, 0.000e+00, 1.973e+03, 0.000e+00 }, // CO2(total)
        { 3.933e+01, 0.000e+00, 8.039e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.462e-01, 3.618e-03, 2.829e-01, 0.000e+00, 3.225e-05, 4.088e-02, 0.000e+00 }, // HC
        { 1.810e+03, 2.711e+02, 4.105e+03, 0.000e+00, 0.000e+00, 6.341e+02, 0.000e+00 }, // FC
        { 3.873e+01, 8.544e-01, 0.000e+00, 0.000e+00, 0.000e+00, 2.340e+00, 8.272e-02 }, // NOx
        { 2.243e+00, 0.000e+00, 1.537e+00, 0.000e+00, 1.383e-04, 0.000e+00, 7.902e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-V_SCRs
        { 5.631e+03, 8.437e+02, 1.277e+04, 0.000e+00, 0.000e+00, 1.973e+03, 0.000e+00 }, // CO2(total)
        { 3.933e+01, 0.000e+00, 8.039e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.462e-01, 3.618e-03, 2.829e-01, 0.000e+00, 3.225e-05, 4.088e-02, 0.000e+00 }, // HC
        { 1.810e+03, 2.711e+02, 4.105e+03, 0.000e+00, 0.000e+00, 6.341e+02, 0.000e+00 }, // FC
        { 8.364e+01, 8.088e+00, 1.158e+02, 0.000e+00, 0.000e+00, 2.162e+01, 0.000e+00 }, // NOx
        { 2.243e+00, 0.000e+00, 1.537e+00, 0.000e+00, 1.383e-04, 0.000e+00, 7.902e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-VI_A-C
        { 5.770e+03, 8.226e+02, 1.356e+04, 0.000e+00, 0.000e+00, 1.915e+03, 0.000e+00 }, // CO2(total)
        { 2.945e+00, 2.039e-02, 4.259e+00, 0.000e+00, 6.947e-05, 0.000e+00, 0.000e+00 }, // CO
        { 1.711e-01, 1.544e-02, 2.925e-01, 0.000e+00, 0.000e+00, 1.293e-02, 0.000e+00 }, // HC
        { 1.854e+03, 2.644e+02, 4.357e+03, 0.000e+00, 0.000e+00, 6.154e+02, 0.000e+00 }, // FC
        { 5.473e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.497e-04, 0.000e+00, 1.827e-02 }, // NOx
        { 1.513e+00, 0.000e+00, 1.171e-01, 0.000e+00, 1.504e-04, 0.000e+00, 8.240e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-VIs_A-C
        { 5.770e+03, 8.226e+02, 1.356e+04, 0.000e+00, 0.000e+00, 1.915e+03, 0.000e+00 }, // CO2(total)
        { 2.945e+00, 2.039e-02, 4.259e+00, 0.000e+00, 6.947e-05, 0.000e+00, 0.000e+00 }, // CO
        { 1.711e-01, 1.544e-02, 2.925e-01, 0.000e+00, 0.000e+00, 1.293e-02, 0.000e+00 }, // HC
        { 1.854e+03, 2.644e+02, 4.357e+03, 0.000e+00, 0.000e+00, 6.154e+02, 0.000e+00 }, // FC
        { 5.167e+01, 5.793e+00, 1.288e+02, 0.000e+00, 0.000e+00, 1.326e+01, 0.000e+00 }, // NOx
        { 1.513e+00, 0.000e+00, 1.171e-01, 0.000e+00, 1.504e-04, 0.000e+00, 8.240e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-VI_D-E
        { 5.136e+03, 8.755e+02, 1.176e+04, 0.000e+00, 0.000e+00, 2.072e+03, 0.000e+00 }, // CO2(total)
        { 4.678e-01, 0.000e+00, 4.408e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.649e-01, 0.000e+00, 3.099e-01, 0.000e+00, 3.072e-05, 1.010e-02, 0.000e+00 }, // HC
        { 1.651e+03, 2.814e+02, 3.780e+03, 0.000e+00, 0.000e+00, 6.661e+02, 0.000e+00 }, // FC
        { 2.616e+00, 0.000e+00, 1.100e+00, 0.000e+00, 2.405e-04, 5.405e-03, 0.000e+00 }, // NOx
        { 1.435e+00, 3.656e-03, 1.211e-02, 0.000e+00, 1.271e-04, 6.986e-03, 1.148e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RT_gt32t_Euro-VIs_D-E
        { 5.136e+03, 8.755e+02, 1.176e+04, 0.000e+00, 0.000e+00, 2.072e+03, 0.000e+00 }, // CO2(total)
        { 4.678e-01, 0.000e+00, 4.408e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.649e-01, 0.000e+00, 3.099e-01, 0.000e+00, 3.072e-05, 1.010e-02, 0.000e+00 }, // HC
        { 1.651e+03, 2.814e+02, 3.780e+03, 0.000e+00, 0.000e+00, 6.661e+02, 0.000e+00 }, // FC
        { 8.960e+01, 4.984e+00, 2.038e+02, 0.000e+00, 0.000e+00, 1.168e+01, 0.000e+00 }, // NOx
        { 1.435e+00, 3.656e-03, 1.211e-02, 0.000e+00, 1.271e-04, 6.986e-03, 1.148e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_50ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_60ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_70ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_80ties
        { 2.842e+03, 6.138e+01, 0.000e+00, 5.634e+00, 4.258e-01, 5.240e+02, 1.585e+01 }, // CO2(total)
        { 3.064e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.007e-03, 2.695e+00, 6.843e-03 }, // CO
        { 1.873e+01, 0.000e+00, 3.433e+00, 0.000e+00, 1.683e-04, 0.000e+00, 0.000e+00 }, // HC
        { 9.134e+02, 1.973e+01, 0.000e+00, 1.811e+00, 1.368e-01, 1.684e+02, 5.095e+00 }, // FC
        { 3.743e+01, 1.510e+00, 0.000e+00, 0.000e+00, 7.189e-03, 7.929e+00, 1.267e-01 }, // NOx
        { 5.952e+00, 0.000e+00, 0.000e+00, 3.785e-03, 2.952e-04, 3.511e-01, 4.067e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-I
        { 2.829e+03, 3.253e+01, 0.000e+00, 5.774e+00, 3.882e-01, 4.741e+02, 1.668e+01 }, // CO2(total)
        { 1.140e+01, 0.000e+00, 0.000e+00, 6.671e-03, 4.057e-04, 9.650e-01, 8.418e-03 }, // CO
        { 3.440e+00, 0.000e+00, 1.738e+00, 0.000e+00, 1.165e-04, 0.000e+00, 3.512e-03 }, // HC
        { 9.091e+02, 1.045e+01, 0.000e+00, 1.856e+00, 1.248e-01, 1.524e+02, 5.360e+00 }, // FC
        { 1.983e+01, 1.652e+00, 0.000e+00, 0.000e+00, 4.551e-03, 5.045e+00, 1.425e-01 }, // NOx
        { 3.697e+00, 0.000e+00, 4.790e-01, 0.000e+00, 2.260e-04, 1.272e-03, 6.785e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-II
        { 2.368e+03, 1.011e+02, 0.000e+00, 4.702e-01, 4.672e-01, 4.408e+02, 1.636e+01 }, // CO2(total)
        { 8.994e+00, 5.296e-02, 7.244e+00, 5.933e-03, 0.000e+00, 3.049e-01, 0.000e+00 }, // CO
        { 2.113e+00, 0.000e+00, 9.123e-01, 0.000e+00, 7.595e-05, 0.000e+00, 2.913e-03 }, // HC
        { 7.611e+02, 3.250e+01, 0.000e+00, 1.511e-01, 1.501e-01, 1.417e+02, 5.256e+00 }, // FC
        { 2.168e+01, 1.762e+00, 0.000e+00, 0.000e+00, 3.992e-03, 5.950e+00, 8.394e-02 }, // NOx
        { 2.546e+00, 0.000e+00, 4.633e-01, 0.000e+00, 1.715e-04, 7.406e-02, 4.725e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-III
        { 2.726e+03, 1.907e+01, 0.000e+00, 8.286e+00, 2.655e-01, 4.727e+02, 1.612e+01 }, // CO2(total)
        { 1.177e+01, 0.000e+00, 5.048e+00, 3.587e-03, 0.000e+00, 2.216e-01, 0.000e+00 }, // CO
        { 2.028e+00, 0.000e+00, 7.814e-01, 0.000e+00, 4.529e-05, 0.000e+00, 1.580e-03 }, // HC
        { 8.762e+02, 6.129e+00, 0.000e+00, 2.663e+00, 8.533e-02, 1.519e+02, 5.181e+00 }, // FC
        { 2.194e+01, 0.000e+00, 0.000e+00, 1.073e-01, 5.775e-04, 4.157e+00, 9.078e-02 }, // NOx
        { 2.546e+00, 0.000e+00, 2.817e-01, 0.000e+00, 1.495e-04, 1.155e-03, 1.821e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-IV_EGR
        { 2.050e+03, 0.000e+00, 0.000e+00, 1.728e+01, 2.354e-02, 5.632e+02, 1.334e+01 }, // CO2(total)
        { 2.256e+00, 3.400e-01, 3.917e+00, 0.000e+00, 0.000e+00, 3.972e-01, 0.000e+00 }, // CO
        { 1.757e-01, 6.652e-03, 2.423e-01, 0.000e+00, 2.848e-05, 0.000e+00, 1.389e-03 }, // HC
        { 6.590e+02, 0.000e+00, 0.000e+00, 5.553e+00, 7.566e-03, 1.810e+02, 4.286e+00 }, // FC
        { 1.178e+00, 2.750e+00, 0.000e+00, 1.935e-02, 0.000e+00, 5.186e+00, 1.126e-02 }, // NOx
        { 1.527e+00, 1.519e-02, 2.806e-01, 0.000e+00, 1.271e-04, 4.807e-03, 5.013e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-IV_SCR
        { 2.073e+03, 0.000e+00, 0.000e+00, 1.642e+01, 4.710e-02, 5.527e+02, 1.323e+01 }, // CO2(total)
        { 1.038e+01, 5.021e-01, 2.514e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.168e-02, 5.245e-03, 0.000e+00, 0.000e+00, 7.439e-06, 1.572e-02, 6.593e-06 }, // HC
        { 6.662e+02, 0.000e+00, 0.000e+00, 5.277e+00, 1.514e-02, 1.776e+02, 4.252e+00 }, // FC
        { 2.024e+01, 0.000e+00, 0.000e+00, 1.517e-03, 1.760e-03, 1.009e+00, 4.956e-02 }, // NOx
        { 1.598e+00, 1.237e-02, 4.685e-01, 0.000e+00, 1.268e-04, 0.000e+00, 1.330e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-IV_SCRs
        { 2.073e+03, 0.000e+00, 0.000e+00, 1.642e+01, 4.710e-02, 5.527e+02, 1.323e+01 }, // CO2(total)
        { 1.038e+01, 5.021e-01, 2.514e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.168e-02, 5.245e-03, 0.000e+00, 0.000e+00, 7.439e-06, 1.572e-02, 6.593e-06 }, // HC
        { 6.662e+02, 0.000e+00, 0.000e+00, 5.277e+00, 1.514e-02, 1.776e+02, 4.252e+00 }, // FC
        { 1.797e+01, 2.036e+00, 2.668e+00, 0.000e+00, 4.030e-03, 6.159e+00, 7.481e-02 }, // NOx
        { 1.598e+00, 1.237e-02, 4.685e-01, 0.000e+00, 1.268e-04, 0.000e+00, 1.330e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-V_EGR
        { 2.018e+03, 0.000e+00, 0.000e+00, 1.621e+01, 3.649e-02, 5.379e+02, 1.365e+01 }, // CO2(total)
        { 4.304e+00, 3.005e-02, 4.893e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.411e-01, 3.391e-03, 4.309e-01, 0.000e+00, 3.432e-05, 5.437e-03, 7.725e-04 }, // HC
        { 6.485e+02, 0.000e+00, 0.000e+00, 5.208e+00, 1.173e-02, 1.729e+02, 4.387e+00 }, // FC
        { 1.729e+00, 1.464e+00, 0.000e+00, 8.112e-02, 0.000e+00, 3.268e+00, 1.368e-01 }, // NOx
        { 1.531e+00, 2.995e-03, 2.102e-02, 0.000e+00, 1.437e-04, 2.346e-02, 1.205e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-V_SCR
        { 1.943e+03, 0.000e+00, 0.000e+00, 1.653e+01, 8.809e-03, 5.346e+02, 1.293e+01 }, // CO2(total)
        { 7.617e+00, 6.359e-01, 1.810e+01, 0.000e+00, 0.000e+00, 3.779e-01, 0.000e+00 }, // CO
        { 7.667e-02, 9.104e-04, 0.000e+00, 3.093e-04, 0.000e+00, 1.253e-02, 1.315e-04 }, // HC
        { 6.244e+02, 0.000e+00, 0.000e+00, 5.311e+00, 2.831e-03, 1.718e+02, 4.156e+00 }, // FC
        { 1.710e+01, 0.000e+00, 0.000e+00, 0.000e+00, 6.453e-04, 0.000e+00, 3.489e-02 }, // NOx
        { 1.578e+00, 1.444e-02, 3.675e-01, 0.000e+00, 1.269e-04, 6.693e-03, 1.429e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-V_SCRs
        { 1.943e+03, 0.000e+00, 0.000e+00, 1.653e+01, 8.809e-03, 5.346e+02, 1.293e+01 }, // CO2(total)
        { 7.617e+00, 6.359e-01, 1.810e+01, 0.000e+00, 0.000e+00, 3.779e-01, 0.000e+00 }, // CO
        { 7.667e-02, 9.104e-04, 0.000e+00, 3.093e-04, 0.000e+00, 1.253e-02, 1.315e-04 }, // HC
        { 6.244e+02, 0.000e+00, 0.000e+00, 5.311e+00, 2.831e-03, 1.718e+02, 4.156e+00 }, // FC
        { 1.994e+01, 2.011e+00, 0.000e+00, 0.000e+00, 3.770e-03, 6.083e+00, 7.758e-02 }, // NOx
        { 1.578e+00, 1.444e-02, 3.675e-01, 0.000e+00, 1.269e-04, 6.693e-03, 1.429e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-VI_A-C
        { 1.936e+03, 0.000e+00, 0.000e+00, 1.621e+01, 6.403e-03, 5.511e+02, 1.203e+01 }, // CO2(total)
        { 1.053e+00, 3.609e-03, 1.179e+00, 8.138e-04, 0.000e+00, 0.000e+00, 3.190e-04 }, // CO
        { 8.609e-02, 0.000e+00, 1.124e-02, 1.815e-04, 8.715e-07, 4.578e-03, 2.644e-04 }, // HC
        { 6.221e+02, 0.000e+00, 0.000e+00, 5.211e+00, 2.058e-03, 1.771e+02, 3.866e+00 }, // FC
        { 1.158e-01, 2.321e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.005e-02 }, // NOx
        { 1.483e+00, 0.000e+00, 4.753e-02, 0.000e+00, 1.279e-04, 0.000e+00, 1.270e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-VIs_A-C
        { 1.936e+03, 0.000e+00, 0.000e+00, 1.621e+01, 6.403e-03, 5.511e+02, 1.203e+01 }, // CO2(total)
        { 1.053e+00, 3.609e-03, 1.179e+00, 8.138e-04, 0.000e+00, 0.000e+00, 3.190e-04 }, // CO
        { 8.609e-02, 0.000e+00, 1.124e-02, 1.815e-04, 8.715e-07, 4.578e-03, 2.644e-04 }, // HC
        { 6.221e+02, 0.000e+00, 0.000e+00, 5.211e+00, 2.058e-03, 1.771e+02, 3.866e+00 }, // FC
        { 6.537e+00, 1.884e-01, 0.000e+00, 1.544e-01, 0.000e+00, 2.619e+00, 2.379e-01 }, // NOx
        { 1.483e+00, 0.000e+00, 4.753e-02, 0.000e+00, 1.279e-04, 0.000e+00, 1.270e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-VI_D-E
        { 1.632e+03, 3.302e+01, 0.000e+00, 1.493e+01, 0.000e+00, 5.226e+02, 1.297e+01 }, // CO2(total)
        { 4.487e-01, 0.000e+00, 3.677e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.666e-01, 9.109e-04, 6.593e-02, 0.000e+00, 4.788e-06, 0.000e+00, 1.697e-04 }, // HC
        { 5.246e+02, 1.061e+01, 0.000e+00, 4.799e+00, 0.000e+00, 1.680e+02, 4.168e+00 }, // FC
        { 7.422e-01, 0.000e+00, 5.967e-01, 1.024e-03, 8.439e-06, 0.000e+00, 0.000e+00 }, // NOx
        { 1.435e+00, 4.843e-04, 0.000e+00, 2.371e-05, 1.265e-04, 1.685e-03, 1.389e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_le7_5t_Euro-VIs_D-E
        { 1.632e+03, 3.302e+01, 0.000e+00, 1.493e+01, 0.000e+00, 5.226e+02, 1.297e+01 }, // CO2(total)
        { 4.487e-01, 0.000e+00, 3.677e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.666e-01, 9.109e-04, 6.593e-02, 0.000e+00, 4.788e-06, 0.000e+00, 1.697e-04 }, // HC
        { 5.246e+02, 1.061e+01, 0.000e+00, 4.799e+00, 0.000e+00, 1.680e+02, 4.168e+00 }, // FC
        { 1.693e+01, 1.115e+00, 2.838e+01, 0.000e+00, 4.042e-03, 8.362e-01, 2.038e-01 }, // NOx
        { 1.435e+00, 4.843e-04, 0.000e+00, 2.371e-05, 1.265e-04, 1.685e-03, 1.389e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_50ties
        { 6.366e+02, 8.384e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.893e+03, 2.416e+00 }, // CO2(total)
        { 1.654e+01, 2.698e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.151e+00, 6.802e-02 }, // CO
        { 1.470e+01, 0.000e+00, 6.758e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.389e-03 }, // HC
        { 2.046e+02, 2.695e+02, 0.000e+00, 0.000e+00, 0.000e+00, 6.085e+02, 7.765e-01 }, // FC
        { 1.628e+01, 1.331e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.096e+01, 0.000e+00 }, // NOx
        { 4.139e+00, 3.504e-01, 0.000e+00, 0.000e+00, 1.260e-04, 7.563e-01, 5.621e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_60ties
        { 6.366e+02, 8.384e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.893e+03, 2.416e+00 }, // CO2(total)
        { 1.654e+01, 2.698e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.151e+00, 6.802e-02 }, // CO
        { 1.470e+01, 0.000e+00, 6.758e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.389e-03 }, // HC
        { 2.046e+02, 2.695e+02, 0.000e+00, 0.000e+00, 0.000e+00, 6.085e+02, 7.765e-01 }, // FC
        { 1.628e+01, 1.331e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.096e+01, 0.000e+00 }, // NOx
        { 4.139e+00, 3.504e-01, 0.000e+00, 0.000e+00, 1.260e-04, 7.563e-01, 5.621e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_70ties
        { 6.366e+02, 8.384e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.893e+03, 2.416e+00 }, // CO2(total)
        { 1.654e+01, 2.698e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.151e+00, 6.802e-02 }, // CO
        { 1.470e+01, 0.000e+00, 6.758e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.389e-03 }, // HC
        { 2.046e+02, 2.695e+02, 0.000e+00, 0.000e+00, 0.000e+00, 6.085e+02, 7.765e-01 }, // FC
        { 1.628e+01, 1.331e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.096e+01, 0.000e+00 }, // NOx
        { 4.139e+00, 3.504e-01, 0.000e+00, 0.000e+00, 1.260e-04, 7.563e-01, 5.621e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_80ties
        { 6.366e+02, 8.384e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.893e+03, 2.416e+00 }, // CO2(total)
        { 1.654e+01, 2.698e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.151e+00, 6.802e-02 }, // CO
        { 1.470e+01, 0.000e+00, 6.758e+00, 0.000e+00, 0.000e+00, 0.000e+00, 5.389e-03 }, // HC
        { 2.046e+02, 2.695e+02, 0.000e+00, 0.000e+00, 0.000e+00, 6.085e+02, 7.765e-01 }, // FC
        { 1.628e+01, 1.331e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.096e+01, 0.000e+00 }, // NOx
        { 4.139e+00, 3.504e-01, 0.000e+00, 0.000e+00, 1.260e-04, 7.563e-01, 5.621e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_lt28t_EE
        { 6.366e+02, 8.384e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.893e+03, 2.416e+00 }, // CO2(total)
        { 1.985e+01, 3.238e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.181e+00, 8.163e-02 }, // CO
        { 1.763e+01, 0.000e+00, 8.110e+00, 0.000e+00, 0.000e+00, 0.000e+00, 6.466e-03 }, // HC
        { 2.046e+02, 2.695e+02, 0.000e+00, 0.000e+00, 0.000e+00, 6.085e+02, 7.765e-01 }, // FC
        { 1.628e+01, 1.331e+01, 0.000e+00, 0.000e+00, 0.000e+00, 3.096e+01, 0.000e+00 }, // NOx
        { 4.139e+00, 3.504e-01, 0.000e+00, 0.000e+00, 1.260e-04, 7.563e-01, 5.621e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-I
        { 7.743e+02, 7.997e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.862e+03, 8.181e-01 }, // CO2(total)
        { 1.587e+01, 1.543e-01, 1.426e+01, 2.741e-02, 0.000e+00, 0.000e+00, 8.463e-02 }, // CO
        { 6.244e+00, 0.000e+00, 8.774e-01, 2.815e-03, 2.113e-05, 4.454e-01, 0.000e+00 }, // HC
        { 2.488e+02, 2.570e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.984e+02, 2.629e-01 }, // FC
        { 9.870e+00, 8.100e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.876e+01, 0.000e+00 }, // NOx
        { 3.974e+00, 1.682e-01, 0.000e+00, 0.000e+00, 1.261e-04, 3.436e-01, 5.727e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-II
        { 5.528e+02, 7.806e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.622e+03, 9.554e+00 }, // CO2(total)
        { 1.442e+01, 0.000e+00, 1.645e+01, 2.122e-02, 0.000e+00, 0.000e+00, 4.295e-02 }, // CO
        { 4.159e+00, 9.931e-03, 5.253e-03, 1.993e-03, 0.000e+00, 3.178e-01, 0.000e+00 }, // HC
        { 1.777e+02, 2.509e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.212e+02, 3.071e+00 }, // FC
        { 1.966e+01, 7.533e+00, 0.000e+00, 7.817e-03, 0.000e+00, 1.846e+01, 0.000e+00 }, // NOx
        { 2.426e+00, 9.680e-02, 1.397e-01, 0.000e+00, 1.262e-04, 2.293e-01, 1.092e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-III
        { 6.080e+02, 7.858e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.553e+03, 1.354e+01 }, // CO2(total)
        { 2.027e+01, 0.000e+00, 1.071e+01, 7.001e-03, 2.988e-04, 0.000e+00, 3.956e-02 }, // CO
        { 4.275e+00, 2.211e-02, 1.882e+00, 0.000e+00, 1.483e-05, 6.461e-02, 3.326e-03 }, // HC
        { 1.954e+02, 2.525e+02, 0.000e+00, 0.000e+00, 0.000e+00, 4.991e+02, 4.350e+00 }, // FC
        { 3.300e+01, 3.268e+00, 0.000e+00, 1.012e-01, 0.000e+00, 1.417e+01, 2.752e-02 }, // NOx
        { 3.262e+00, 4.401e-02, 0.000e+00, 0.000e+00, 1.258e-04, 9.148e-02, 1.999e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-IV_EGR
        { 2.907e+01, 8.077e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.633e+03, 1.125e+01 }, // CO2(total)
        { 5.224e+00, 6.373e-01, 4.762e+00, 0.000e+00, 0.000e+00, 1.466e+00, 1.623e-04 }, // CO
        { 3.185e-01, 2.726e-02, 4.477e-02, 0.000e+00, 1.788e-05, 9.696e-02, 0.000e+00 }, // HC
        { 9.341e+00, 2.596e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.249e+02, 3.614e+00 }, // FC
        { 2.232e+01, 3.930e+00, 5.315e+01, 0.000e+00, 1.657e-03, 5.435e+00, 1.946e-01 }, // NOx
        { 1.730e+00, 2.280e-02, 7.432e-01, 0.000e+00, 1.269e-04, 0.000e+00, 1.188e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-IV_SCR
        { 5.970e+02, 7.583e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.808e+03, 0.000e+00 }, // CO2(total)
        { 2.624e+01, 0.000e+00, 4.395e+01, 0.000e+00, 2.019e-03, 0.000e+00, 8.679e-02 }, // CO
        { 1.711e-01, 4.654e-03, 3.506e-02, 3.239e-04, 0.000e+00, 3.544e-02, 0.000e+00 }, // HC
        { 1.919e+02, 2.437e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.811e+02, 0.000e+00 }, // FC
        { 2.856e+01, 1.768e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.691e+00, 4.571e-02 }, // NOx
        { 1.962e+00, 0.000e+00, 8.289e-01, 0.000e+00, 1.624e-04, 5.543e-04, 1.723e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-IV_SCRs
        { 5.970e+02, 7.583e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.808e+03, 0.000e+00 }, // CO2(total)
        { 2.624e+01, 0.000e+00, 4.395e+01, 0.000e+00, 2.019e-03, 0.000e+00, 8.679e-02 }, // CO
        { 1.711e-01, 4.654e-03, 3.506e-02, 3.239e-04, 0.000e+00, 3.544e-02, 0.000e+00 }, // HC
        { 1.919e+02, 2.437e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.811e+02, 0.000e+00 }, // FC
        { 1.769e+01, 7.632e+00, 5.879e+00, 0.000e+00, 0.000e+00, 1.847e+01, 0.000e+00 }, // NOx
        { 1.962e+00, 0.000e+00, 8.289e-01, 0.000e+00, 1.624e-04, 5.543e-04, 1.723e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-V_EGR
        { 5.268e+02, 7.411e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.775e+03, 0.000e+00 }, // CO2(total)
        { 7.925e+00, 0.000e+00, 1.080e+01, 0.000e+00, 4.060e-04, 0.000e+00, 1.563e-02 }, // CO
        { 8.963e-01, 1.522e-02, 6.238e-01, 0.000e+00, 3.109e-05, 7.782e-02, 7.668e-04 }, // HC
        { 1.693e+02, 2.382e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.704e+02, 0.000e+00 }, // FC
        { 2.364e+01, 2.505e+00, 5.204e+01, 0.000e+00, 1.790e-03, 1.829e+00, 2.233e-01 }, // NOx
        { 1.583e+00, 1.985e-02, 1.652e-01, 0.000e+00, 1.264e-04, 5.040e-02, 7.033e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-V_SCR
        { 7.488e+02, 7.105e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.726e+03, 0.000e+00 }, // CO2(total)
        { 2.112e+01, 4.591e-01, 3.500e+01, 0.000e+00, 1.969e-03, 0.000e+00, 1.301e-01 }, // CO
        { 1.130e-01, 1.566e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.648e-02, 0.000e+00 }, // HC
        { 2.407e+02, 2.284e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.547e+02, 0.000e+00 }, // FC
        { 3.310e+01, 4.166e-01, 0.000e+00, 0.000e+00, 0.000e+00, 9.962e-01, 4.693e-02 }, // NOx
        { 1.983e+00, 0.000e+00, 7.461e-01, 0.000e+00, 1.704e-04, 2.223e-03, 2.316e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-V_SCRs
        { 7.488e+02, 7.105e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.726e+03, 0.000e+00 }, // CO2(total)
        { 2.112e+01, 4.591e-01, 3.500e+01, 0.000e+00, 1.969e-03, 0.000e+00, 1.301e-01 }, // CO
        { 1.130e-01, 1.566e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.648e-02, 0.000e+00 }, // HC
        { 2.407e+02, 2.284e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.547e+02, 0.000e+00 }, // FC
        { 2.567e+01, 7.204e+00, 8.411e+00, 0.000e+00, 0.000e+00, 1.720e+01, 0.000e+00 }, // NOx
        { 1.983e+00, 0.000e+00, 7.461e-01, 0.000e+00, 1.704e-04, 2.223e-03, 2.316e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-VI_A-C
        { 6.088e+02, 7.167e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.734e+03, 0.000e+00 }, // CO2(total)
        { 2.253e+00, 0.000e+00, 2.131e+00, 0.000e+00, 9.036e-05, 0.000e+00, 4.107e-03 }, // CO
        { 1.416e-01, 9.043e-03, 1.024e-02, 0.000e+00, 0.000e+00, 2.180e-02, 0.000e+00 }, // HC
        { 1.956e+02, 2.303e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.573e+02, 0.000e+00 }, // FC
        { 4.965e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.635e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.563e+00, 0.000e+00, 1.548e-01, 0.000e+00, 1.270e-04, 3.052e-03, 2.933e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-VIs_A-C
        { 6.088e+02, 7.167e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.734e+03, 0.000e+00 }, // CO2(total)
        { 2.253e+00, 0.000e+00, 2.131e+00, 0.000e+00, 9.036e-05, 0.000e+00, 4.107e-03 }, // CO
        { 1.416e-01, 9.043e-03, 1.024e-02, 0.000e+00, 0.000e+00, 2.180e-02, 0.000e+00 }, // HC
        { 1.956e+02, 2.303e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.573e+02, 0.000e+00 }, // FC
        { 9.150e-02, 5.557e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.247e+01, 2.129e-02 }, // NOx
        { 1.563e+00, 0.000e+00, 1.548e-01, 0.000e+00, 1.270e-04, 3.052e-03, 2.933e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-VI_D-E
        { 2.702e+02, 7.278e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.677e+03, 1.809e+00 }, // CO2(total)
        { 1.140e+00, 0.000e+00, 1.053e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.417e-01, 6.179e-03, 7.915e-02, 0.000e+00, 0.000e+00, 1.454e-02, 0.000e+00 }, // HC
        { 8.684e+01, 2.339e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.391e+02, 5.813e-01 }, // FC
        { 2.218e+00, 0.000e+00, 1.686e-01, 0.000e+00, 1.587e-04, 0.000e+00, 2.132e-03 }, // NOx
        { 1.445e+00, 1.802e-03, 2.638e-03, 0.000e+00, 1.264e-04, 5.372e-03, 9.043e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt20-28t_Euro-VIs_D-E
        { 2.702e+02, 7.278e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.677e+03, 1.809e+00 }, // CO2(total)
        { 1.140e+00, 0.000e+00, 1.053e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.417e-01, 6.179e-03, 7.915e-02, 0.000e+00, 0.000e+00, 1.454e-02, 0.000e+00 }, // HC
        { 8.684e+01, 2.339e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.391e+02, 5.813e-01 }, // FC
        { 3.843e+00, 7.005e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.580e+01, 2.293e-02 }, // NOx
        { 1.445e+00, 1.802e-03, 2.638e-03, 0.000e+00, 1.264e-04, 5.372e-03, 9.043e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_50ties
        { 7.988e+03, 6.370e+02, 1.799e+04, 0.000e+00, 0.000e+00, 1.447e+03, 0.000e+00 }, // CO2(total)
        { 3.820e+01, 2.379e+00, 4.875e+01, 0.000e+00, 0.000e+00, 6.148e+00, 0.000e+00 }, // CO
        { 1.316e+01, 0.000e+00, 4.028e+00, 0.000e+00, 1.197e-04, 0.000e+00, 2.125e-02 }, // HC
        { 2.567e+03, 2.047e+02, 5.781e+03, 0.000e+00, 0.000e+00, 4.649e+02, 0.000e+00 }, // FC
        { 1.297e+02, 1.003e+01, 2.821e+02, 0.000e+00, 0.000e+00, 2.292e+01, 0.000e+00 }, // NOx
        { 7.125e+00, 2.894e-01, 7.518e+00, 0.000e+00, 1.276e-04, 7.198e-01, 2.728e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_60ties
        { 7.988e+03, 6.370e+02, 1.799e+04, 0.000e+00, 0.000e+00, 1.447e+03, 0.000e+00 }, // CO2(total)
        { 3.820e+01, 2.379e+00, 4.875e+01, 0.000e+00, 0.000e+00, 6.148e+00, 0.000e+00 }, // CO
        { 1.316e+01, 0.000e+00, 4.028e+00, 0.000e+00, 1.197e-04, 0.000e+00, 2.125e-02 }, // HC
        { 2.567e+03, 2.047e+02, 5.781e+03, 0.000e+00, 0.000e+00, 4.649e+02, 0.000e+00 }, // FC
        { 1.297e+02, 1.003e+01, 2.821e+02, 0.000e+00, 0.000e+00, 2.292e+01, 0.000e+00 }, // NOx
        { 7.125e+00, 2.894e-01, 7.518e+00, 0.000e+00, 1.276e-04, 7.198e-01, 2.728e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_70ties
        { 7.988e+03, 6.370e+02, 1.799e+04, 0.000e+00, 0.000e+00, 1.447e+03, 0.000e+00 }, // CO2(total)
        { 3.820e+01, 2.379e+00, 4.875e+01, 0.000e+00, 0.000e+00, 6.148e+00, 0.000e+00 }, // CO
        { 1.316e+01, 0.000e+00, 4.028e+00, 0.000e+00, 1.197e-04, 0.000e+00, 2.125e-02 }, // HC
        { 2.567e+03, 2.047e+02, 5.781e+03, 0.000e+00, 0.000e+00, 4.649e+02, 0.000e+00 }, // FC
        { 1.297e+02, 1.003e+01, 2.821e+02, 0.000e+00, 0.000e+00, 2.292e+01, 0.000e+00 }, // NOx
        { 7.125e+00, 2.894e-01, 7.518e+00, 0.000e+00, 1.276e-04, 7.198e-01, 2.728e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_80ties
        { 7.988e+03, 6.370e+02, 1.799e+04, 0.000e+00, 0.000e+00, 1.447e+03, 0.000e+00 }, // CO2(total)
        { 3.820e+01, 2.379e+00, 4.875e+01, 0.000e+00, 0.000e+00, 6.148e+00, 0.000e+00 }, // CO
        { 1.316e+01, 0.000e+00, 4.028e+00, 0.000e+00, 1.197e-04, 0.000e+00, 2.125e-02 }, // HC
        { 2.567e+03, 2.047e+02, 5.781e+03, 0.000e+00, 0.000e+00, 4.649e+02, 0.000e+00 }, // FC
        { 1.297e+02, 1.003e+01, 2.821e+02, 0.000e+00, 0.000e+00, 2.292e+01, 0.000e+00 }, // NOx
        { 7.125e+00, 2.894e-01, 7.518e+00, 0.000e+00, 1.276e-04, 7.198e-01, 2.728e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_28-34t_EE
        { 7.988e+03, 6.370e+02, 1.799e+04, 0.000e+00, 0.000e+00, 1.447e+03, 0.000e+00 }, // CO2(total)
        { 5.348e+01, 3.330e+00, 6.825e+01, 0.000e+00, 0.000e+00, 8.607e+00, 0.000e+00 }, // CO
        { 3.947e+01, 0.000e+00, 1.208e+01, 0.000e+00, 3.592e-04, 0.000e+00, 6.375e-02 }, // HC
        { 2.567e+03, 2.047e+02, 5.781e+03, 0.000e+00, 0.000e+00, 4.649e+02, 0.000e+00 }, // FC
        { 1.557e+02, 1.203e+01, 3.385e+02, 0.000e+00, 0.000e+00, 2.750e+01, 0.000e+00 }, // NOx
        { 1.113e+01, 4.919e-01, 1.278e+01, 0.000e+00, 1.276e-04, 1.224e+00, 2.728e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-I
        { 7.431e+03, 6.360e+02, 1.677e+04, 0.000e+00, 0.000e+00, 1.446e+03, 0.000e+00 }, // CO2(total)
        { 1.552e+01, 1.155e+00, 6.915e+00, 0.000e+00, 0.000e+00, 3.204e+00, 0.000e+00 }, // CO
        { 6.200e+00, 7.586e-02, 3.277e+00, 0.000e+00, 2.457e-05, 4.327e-01, 0.000e+00 }, // HC
        { 2.388e+03, 2.044e+02, 5.390e+03, 0.000e+00, 0.000e+00, 4.646e+02, 0.000e+00 }, // FC
        { 7.510e+01, 6.432e+00, 1.639e+02, 0.000e+00, 0.000e+00, 1.456e+01, 0.000e+00 }, // NOx
        { 5.171e+00, 1.578e-01, 3.096e+00, 0.000e+00, 1.270e-04, 4.313e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-II
        { 6.187e+03, 7.275e+02, 1.257e+04, 0.000e+00, 0.000e+00, 1.787e+03, 0.000e+00 }, // CO2(total)
        { 1.716e+01, 0.000e+00, 1.443e+01, 0.000e+00, 1.192e-03, 0.000e+00, 7.801e-02 }, // CO
        { 4.364e+00, 6.124e-02, 2.417e+00, 0.000e+00, 0.000e+00, 2.934e-01, 0.000e+00 }, // HC
        { 1.988e+03, 2.338e+02, 4.040e+03, 0.000e+00, 0.000e+00, 5.743e+02, 0.000e+00 }, // FC
        { 6.544e+01, 7.514e+00, 1.150e+02, 0.000e+00, 0.000e+00, 1.845e+01, 0.000e+00 }, // NOx
        { 2.849e+00, 1.076e-01, 1.116e+00, 0.000e+00, 1.278e-04, 2.468e-01, 1.783e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-III
        { 5.255e+03, 8.226e+02, 9.562e+03, 0.000e+00, 0.000e+00, 2.080e+03, 0.000e+00 }, // CO2(total)
        { 2.058e+01, 0.000e+00, 9.245e+00, 0.000e+00, 1.005e-03, 0.000e+00, 7.207e-02 }, // CO
        { 3.995e+00, 6.321e-02, 1.465e+00, 0.000e+00, 0.000e+00, 2.804e-01, 0.000e+00 }, // HC
        { 1.689e+03, 2.644e+02, 3.073e+03, 0.000e+00, 0.000e+00, 6.686e+02, 0.000e+00 }, // FC
        { 4.427e+01, 6.643e+00, 8.114e+01, 0.000e+00, 0.000e+00, 1.560e+01, 0.000e+00 }, // NOx
        { 3.284e+00, 7.593e-02, 3.491e-01, 0.000e+00, 1.263e-04, 2.203e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-IV_EGR
        { 5.794e+03, 7.639e+02, 1.300e+04, 0.000e+00, 0.000e+00, 1.860e+03, 0.000e+00 }, // CO2(total)
        { 9.446e+00, 2.863e-01, 1.666e+01, 9.960e-03, 0.000e+00, 0.000e+00, 5.147e-02 }, // CO
        { 6.621e-01, 0.000e+00, 8.695e-01, 5.592e-04, 3.099e-05, 0.000e+00, 3.492e-03 }, // HC
        { 1.862e+03, 2.455e+02, 4.178e+03, 0.000e+00, 0.000e+00, 5.979e+02, 0.000e+00 }, // FC
        { 3.513e+01, 5.472e+00, 5.747e+01, 0.000e+00, 0.000e+00, 1.317e+01, 0.000e+00 }, // NOx
        { 2.008e+00, 0.000e+00, 5.720e-01, 0.000e+00, 1.563e-04, 3.101e-03, 2.057e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-IV_SCR
        { 5.328e+03, 7.886e+02, 1.161e+04, 0.000e+00, 0.000e+00, 1.940e+03, 0.000e+00 }, // CO2(total)
        { 2.753e+01, 0.000e+00, 3.325e+01, 0.000e+00, 1.436e-03, 0.000e+00, 9.143e-02 }, // CO
        { 1.947e-01, 1.678e-02, 2.798e-01, 0.000e+00, 0.000e+00, 4.326e-02, 0.000e+00 }, // HC
        { 1.712e+03, 2.534e+02, 3.730e+03, 0.000e+00, 0.000e+00, 6.234e+02, 0.000e+00 }, // FC
        { 3.844e+01, 1.926e+00, 1.209e+01, 0.000e+00, 0.000e+00, 7.209e+00, 0.000e+00 }, // NOx
        { 2.002e+00, 0.000e+00, 6.901e-01, 0.000e+00, 1.545e-04, 3.607e-03, 1.862e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-IV_SCRs
        { 5.328e+03, 7.886e+02, 1.161e+04, 0.000e+00, 0.000e+00, 1.940e+03, 0.000e+00 }, // CO2(total)
        { 2.753e+01, 0.000e+00, 3.325e+01, 0.000e+00, 1.436e-03, 0.000e+00, 9.143e-02 }, // CO
        { 1.947e-01, 1.678e-02, 2.798e-01, 0.000e+00, 0.000e+00, 4.326e-02, 0.000e+00 }, // HC
        { 1.712e+03, 2.534e+02, 3.730e+03, 0.000e+00, 0.000e+00, 6.234e+02, 0.000e+00 }, // FC
        { 6.288e+01, 7.650e+00, 1.187e+02, 0.000e+00, 0.000e+00, 1.891e+01, 0.000e+00 }, // NOx
        { 2.002e+00, 0.000e+00, 6.901e-01, 0.000e+00, 1.545e-04, 3.607e-03, 1.862e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-V_EGR
        { 4.602e+03, 8.196e+02, 9.720e+03, 0.000e+00, 0.000e+00, 2.042e+03, 0.000e+00 }, // CO2(total)
        { 7.690e+00, 0.000e+00, 8.313e+00, 0.000e+00, 1.804e-04, 0.000e+00, 1.051e-02 }, // CO
        { 9.411e-01, 1.969e-02, 1.323e+00, 5.826e-04, 0.000e+00, 2.145e-02, 2.891e-03 }, // HC
        { 1.479e+03, 2.634e+02, 3.124e+03, 0.000e+00, 0.000e+00, 6.563e+02, 0.000e+00 }, // FC
        { 6.019e+01, 0.000e+00, 9.564e+01, 0.000e+00, 3.620e-03, 0.000e+00, 2.221e-01 }, // NOx
        { 1.706e+00, 2.313e-02, 4.188e-01, 0.000e+00, 1.271e-04, 6.551e-02, 8.099e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-V_SCR
        { 4.739e+03, 7.837e+02, 1.014e+04, 0.000e+00, 0.000e+00, 1.948e+03, 0.000e+00 }, // CO2(total)
        { 2.639e+01, 0.000e+00, 3.068e+01, 0.000e+00, 1.350e-03, 0.000e+00, 6.666e-02 }, // CO
        { 1.960e-01, 1.739e-02, 1.941e-01, 0.000e+00, 0.000e+00, 4.332e-02, 0.000e+00 }, // HC
        { 1.523e+03, 2.519e+02, 3.258e+03, 0.000e+00, 0.000e+00, 6.260e+02, 0.000e+00 }, // FC
        { 3.428e+01, 6.994e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.164e+00, 1.794e-03 }, // NOx
        { 2.007e+00, 0.000e+00, 6.669e-01, 0.000e+00, 1.554e-04, 0.000e+00, 1.743e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-V_SCRs
        { 4.739e+03, 7.837e+02, 1.014e+04, 0.000e+00, 0.000e+00, 1.948e+03, 0.000e+00 }, // CO2(total)
        { 2.639e+01, 0.000e+00, 3.068e+01, 0.000e+00, 1.350e-03, 0.000e+00, 6.666e-02 }, // CO
        { 1.960e-01, 1.739e-02, 1.941e-01, 0.000e+00, 0.000e+00, 4.332e-02, 0.000e+00 }, // HC
        { 1.523e+03, 2.519e+02, 3.258e+03, 0.000e+00, 0.000e+00, 6.260e+02, 0.000e+00 }, // FC
        { 6.683e+01, 7.679e+00, 1.090e+02, 0.000e+00, 0.000e+00, 1.889e+01, 0.000e+00 }, // NOx
        { 2.007e+00, 0.000e+00, 6.669e-01, 0.000e+00, 1.554e-04, 0.000e+00, 1.743e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-VI_A-C
        { 4.776e+03, 7.694e+02, 1.037e+04, 0.000e+00, 0.000e+00, 1.901e+03, 0.000e+00 }, // CO2(total)
        { 2.028e+00, 6.400e-02, 1.836e+00, 0.000e+00, 0.000e+00, 1.302e-01, 1.266e-03 }, // CO
        { 1.835e-01, 1.300e-02, 1.235e-01, 0.000e+00, 0.000e+00, 3.445e-02, 0.000e+00 }, // HC
        { 1.535e+03, 2.473e+02, 3.332e+03, 0.000e+00, 0.000e+00, 6.110e+02, 0.000e+00 }, // FC
        { 5.601e+00, 0.000e+00, 0.000e+00, 0.000e+00, 7.402e-06, 0.000e+00, 1.704e-03 }, // NOx
        { 1.564e+00, 0.000e+00, 1.191e-01, 0.000e+00, 1.273e-04, 1.072e-03, 2.894e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-VIs_A-C
        { 4.776e+03, 7.694e+02, 1.037e+04, 0.000e+00, 0.000e+00, 1.901e+03, 0.000e+00 }, // CO2(total)
        { 2.028e+00, 6.400e-02, 1.836e+00, 0.000e+00, 0.000e+00, 1.302e-01, 1.266e-03 }, // CO
        { 1.835e-01, 1.300e-02, 1.235e-01, 0.000e+00, 0.000e+00, 3.445e-02, 0.000e+00 }, // HC
        { 1.535e+03, 2.473e+02, 3.332e+03, 0.000e+00, 0.000e+00, 6.110e+02, 0.000e+00 }, // FC
        { 3.405e+01, 5.500e+00, 7.219e+01, 0.000e+00, 0.000e+00, 1.324e+01, 0.000e+00 }, // NOx
        { 1.564e+00, 0.000e+00, 1.191e-01, 0.000e+00, 1.273e-04, 1.072e-03, 2.894e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-VI_D-E
        { 4.197e+03, 8.021e+02, 8.853e+03, 0.000e+00, 0.000e+00, 1.996e+03, 0.000e+00 }, // CO2(total)
        { 8.083e-01, 0.000e+00, 4.942e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.550e-01, 7.271e-03, 1.099e-01, 0.000e+00, 0.000e+00, 1.932e-02, 0.000e+00 }, // HC
        { 1.349e+03, 2.578e+02, 2.845e+03, 0.000e+00, 0.000e+00, 6.416e+02, 0.000e+00 }, // FC
        { 2.037e+00, 0.000e+00, 1.384e-01, 0.000e+00, 1.232e-04, 0.000e+00, 2.857e-03 }, // NOx
        { 1.455e+00, 2.364e-03, 2.520e-02, 0.000e+00, 1.269e-04, 9.094e-03, 3.145e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt28-34t_Euro-VIs_D-E
        { 4.197e+03, 8.021e+02, 8.853e+03, 0.000e+00, 0.000e+00, 1.996e+03, 0.000e+00 }, // CO2(total)
        { 8.083e-01, 0.000e+00, 4.942e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 3.550e-01, 7.271e-03, 1.099e-01, 0.000e+00, 0.000e+00, 1.932e-02, 0.000e+00 }, // HC
        { 1.349e+03, 2.578e+02, 2.845e+03, 0.000e+00, 0.000e+00, 6.416e+02, 0.000e+00 }, // FC
        { 5.708e+01, 4.163e+00, 1.408e+02, 0.000e+00, 1.839e-03, 4.017e+00, 2.821e-01 }, // NOx
        { 1.455e+00, 2.364e-03, 2.520e-02, 0.000e+00, 1.269e-04, 9.094e-03, 3.145e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_50ties
        { 7.811e+03, 8.318e+02, 1.553e+04, 0.000e+00, 0.000e+00, 2.013e+03, 0.000e+00 }, // CO2(total)
        { 3.171e+01, 5.087e-01, 4.991e+01, 0.000e+00, 0.000e+00, 8.328e-01, 0.000e+00 }, // CO
        { 7.674e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.926e-04, 3.262e-01, 4.985e-03 }, // HC
        { 2.510e+03, 2.673e+02, 4.991e+03, 0.000e+00, 0.000e+00, 6.469e+02, 0.000e+00 }, // FC
        { 1.117e+02, 1.244e+01, 2.185e+02, 0.000e+00, 0.000e+00, 3.037e+01, 0.000e+00 }, // NOx
        { 7.237e+00, 2.132e-01, 8.608e+00, 0.000e+00, 1.319e-04, 3.455e-01, 6.496e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_60ties
        { 7.811e+03, 8.318e+02, 1.553e+04, 0.000e+00, 0.000e+00, 2.013e+03, 0.000e+00 }, // CO2(total)
        { 3.171e+01, 5.087e-01, 4.991e+01, 0.000e+00, 0.000e+00, 8.328e-01, 0.000e+00 }, // CO
        { 7.674e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.926e-04, 3.262e-01, 4.985e-03 }, // HC
        { 2.510e+03, 2.673e+02, 4.991e+03, 0.000e+00, 0.000e+00, 6.469e+02, 0.000e+00 }, // FC
        { 1.117e+02, 1.244e+01, 2.185e+02, 0.000e+00, 0.000e+00, 3.037e+01, 0.000e+00 }, // NOx
        { 7.237e+00, 2.132e-01, 8.608e+00, 0.000e+00, 1.319e-04, 3.455e-01, 6.496e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_70ties
        { 7.811e+03, 8.318e+02, 1.553e+04, 0.000e+00, 0.000e+00, 2.013e+03, 0.000e+00 }, // CO2(total)
        { 3.171e+01, 5.087e-01, 4.991e+01, 0.000e+00, 0.000e+00, 8.328e-01, 0.000e+00 }, // CO
        { 7.674e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.926e-04, 3.262e-01, 4.985e-03 }, // HC
        { 2.510e+03, 2.673e+02, 4.991e+03, 0.000e+00, 0.000e+00, 6.469e+02, 0.000e+00 }, // FC
        { 1.117e+02, 1.244e+01, 2.185e+02, 0.000e+00, 0.000e+00, 3.037e+01, 0.000e+00 }, // NOx
        { 7.237e+00, 2.132e-01, 8.608e+00, 0.000e+00, 1.319e-04, 3.455e-01, 6.496e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_80ties
        { 7.811e+03, 8.318e+02, 1.553e+04, 0.000e+00, 0.000e+00, 2.013e+03, 0.000e+00 }, // CO2(total)
        { 3.171e+01, 5.087e-01, 4.991e+01, 0.000e+00, 0.000e+00, 8.328e-01, 0.000e+00 }, // CO
        { 7.674e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.926e-04, 3.262e-01, 4.985e-03 }, // HC
        { 2.510e+03, 2.673e+02, 4.991e+03, 0.000e+00, 0.000e+00, 6.469e+02, 0.000e+00 }, // FC
        { 1.117e+02, 1.244e+01, 2.185e+02, 0.000e+00, 0.000e+00, 3.037e+01, 0.000e+00 }, // NOx
        { 7.237e+00, 2.132e-01, 8.608e+00, 0.000e+00, 1.319e-04, 3.455e-01, 6.496e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-I
        { 7.843e+03, 7.835e+02, 1.550e+04, 0.000e+00, 0.000e+00, 1.921e+03, 0.000e+00 }, // CO2(total)
        { 2.115e+01, 1.132e+00, 4.610e+01, 0.000e+00, 0.000e+00, 5.462e-01, 5.957e-02 }, // CO
        { 6.522e+00, 1.607e-01, 1.051e+00, 0.000e+00, 0.000e+00, 6.903e-01, 0.000e+00 }, // HC
        { 2.521e+03, 2.518e+02, 4.980e+03, 0.000e+00, 0.000e+00, 6.173e+02, 0.000e+00 }, // FC
        { 8.575e+01, 7.750e+00, 1.680e+02, 0.000e+00, 0.000e+00, 1.889e+01, 0.000e+00 }, // NOx
        { 5.410e+00, 2.119e-01, 2.031e+00, 0.000e+00, 1.320e-04, 6.187e-01, 7.442e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-II
        { 7.441e+03, 7.912e+02, 1.482e+04, 0.000e+00, 0.000e+00, 1.963e+03, 0.000e+00 }, // CO2(total)
        { 1.827e+01, 6.488e-01, 2.831e+01, 0.000e+00, 0.000e+00, 1.321e+00, 0.000e+00 }, // CO
        { 4.377e+00, 1.132e-01, 3.007e-01, 0.000e+00, 0.000e+00, 4.645e-01, 0.000e+00 }, // HC
        { 2.391e+03, 2.543e+02, 4.762e+03, 0.000e+00, 0.000e+00, 6.309e+02, 0.000e+00 }, // FC
        { 9.070e+01, 7.704e+00, 1.693e+02, 0.000e+00, 0.000e+00, 1.914e+01, 0.000e+00 }, // NOx
        { 3.053e+00, 1.256e-01, 1.646e+00, 0.000e+00, 1.292e-04, 2.793e-01, 8.443e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-III
        { 7.738e+03, 7.828e+02, 1.543e+04, 0.000e+00, 0.000e+00, 1.955e+03, 0.000e+00 }, // CO2(total)
        { 2.139e+01, 6.645e-01, 1.912e+01, 0.000e+00, 0.000e+00, 1.564e+00, 0.000e+00 }, // CO
        { 4.932e+00, 1.826e-02, 1.452e+00, 1.080e-03, 0.000e+00, 2.780e-01, 0.000e+00 }, // HC
        { 2.487e+03, 2.516e+02, 4.959e+03, 0.000e+00, 0.000e+00, 6.282e+02, 0.000e+00 }, // FC
        { 7.137e+01, 6.433e+00, 1.454e+02, 0.000e+00, 0.000e+00, 1.524e+01, 0.000e+00 }, // NOx
        { 3.762e+00, 5.900e-02, 1.108e+00, 0.000e+00, 1.281e-04, 1.564e-01, 8.269e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-IV_EGR
        { 7.213e+03, 8.143e+02, 1.594e+04, 0.000e+00, 0.000e+00, 1.993e+03, 0.000e+00 }, // CO2(total)
        { 1.215e+01, 5.423e-01, 1.769e+01, 0.000e+00, 0.000e+00, 1.622e+00, 0.000e+00 }, // CO
        { 5.506e-01, 4.448e-02, 8.867e-01, 0.000e+00, 0.000e+00, 1.060e-01, 0.000e+00 }, // HC
        { 2.318e+03, 2.617e+02, 5.122e+03, 0.000e+00, 0.000e+00, 6.405e+02, 0.000e+00 }, // FC
        { 7.535e+01, 3.873e+00, 1.666e+02, 0.000e+00, 0.000e+00, 9.180e+00, 0.000e+00 }, // NOx
        { 2.051e+00, 1.357e-02, 8.681e-01, 0.000e+00, 1.282e-04, 4.107e-02, 9.162e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-IV_SCR
        { 8.664e+03, 6.799e+02, 2.048e+04, 0.000e+00, 0.000e+00, 1.590e+03, 0.000e+00 }, // CO2(total)
        { 3.435e+01, 7.568e-01, 5.047e+01, 0.000e+00, 0.000e+00, 2.757e+00, 0.000e+00 }, // CO
        { 2.923e-01, 1.317e-02, 5.624e-01, 0.000e+00, 0.000e+00, 2.814e-02, 0.000e+00 }, // HC
        { 2.784e+03, 2.185e+02, 6.582e+03, 0.000e+00, 0.000e+00, 5.109e+02, 0.000e+00 }, // FC
        { 5.240e+01, 1.551e+00, 3.602e+01, 0.000e+00, 0.000e+00, 6.658e+00, 0.000e+00 }, // NOx
        { 2.029e+00, 1.885e-02, 7.741e-01, 0.000e+00, 1.254e-04, 5.984e-02, 1.044e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-IV_SCRs
        { 8.664e+03, 6.799e+02, 2.048e+04, 0.000e+00, 0.000e+00, 1.590e+03, 0.000e+00 }, // CO2(total)
        { 3.435e+01, 7.568e-01, 5.047e+01, 0.000e+00, 0.000e+00, 2.757e+00, 0.000e+00 }, // CO
        { 2.923e-01, 1.317e-02, 5.624e-01, 0.000e+00, 0.000e+00, 2.814e-02, 0.000e+00 }, // HC
        { 2.784e+03, 2.185e+02, 6.582e+03, 0.000e+00, 0.000e+00, 5.109e+02, 0.000e+00 }, // FC
        { 9.320e+01, 7.271e+00, 1.920e+02, 0.000e+00, 0.000e+00, 1.761e+01, 0.000e+00 }, // NOx
        { 2.029e+00, 1.885e-02, 7.741e-01, 0.000e+00, 1.254e-04, 5.984e-02, 1.044e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-V_EGR
        { 8.432e+03, 6.838e+02, 2.005e+04, 0.000e+00, 0.000e+00, 1.613e+03, 0.000e+00 }, // CO2(total)
        { 1.096e+01, 7.216e-02, 1.442e+01, 0.000e+00, 0.000e+00, 5.060e-01, 0.000e+00 }, // CO
        { 9.444e-01, 4.848e-02, 8.346e-01, 0.000e+00, 0.000e+00, 1.402e-01, 1.132e-04 }, // HC
        { 2.710e+03, 2.198e+02, 6.442e+03, 0.000e+00, 0.000e+00, 5.185e+02, 0.000e+00 }, // FC
        { 4.962e+01, 3.195e+00, 7.442e+01, 0.000e+00, 0.000e+00, 8.732e+00, 0.000e+00 }, // NOx
        { 1.790e+00, 2.108e-02, 6.463e-01, 0.000e+00, 1.252e-04, 5.218e-02, 2.933e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-V_SCR
        { 7.726e+03, 7.326e+02, 1.817e+04, 0.000e+00, 0.000e+00, 1.785e+03, 0.000e+00 }, // CO2(total)
        { 2.582e+01, 9.254e-01, 3.728e+01, 0.000e+00, 0.000e+00, 0.000e+00, 9.774e-02 }, // CO
        { 3.079e-01, 1.524e-02, 5.235e-01, 0.000e+00, 0.000e+00, 3.271e-02, 0.000e+00 }, // HC
        { 2.483e+03, 2.355e+02, 5.839e+03, 0.000e+00, 0.000e+00, 5.736e+02, 0.000e+00 }, // FC
        { 4.279e+01, 5.477e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.588e+00, 0.000e+00 }, // NOx
        { 1.986e+00, 2.134e-02, 8.645e-01, 0.000e+00, 1.250e-04, 2.448e-03, 2.018e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-V_SCRs
        { 7.726e+03, 7.326e+02, 1.817e+04, 0.000e+00, 0.000e+00, 1.785e+03, 0.000e+00 }, // CO2(total)
        { 2.582e+01, 9.254e-01, 3.728e+01, 0.000e+00, 0.000e+00, 0.000e+00, 9.774e-02 }, // CO
        { 3.079e-01, 1.524e-02, 5.235e-01, 0.000e+00, 0.000e+00, 3.271e-02, 0.000e+00 }, // HC
        { 2.483e+03, 2.355e+02, 5.839e+03, 0.000e+00, 0.000e+00, 5.736e+02, 0.000e+00 }, // FC
        { 9.697e+01, 7.530e+00, 1.763e+02, 0.000e+00, 0.000e+00, 1.847e+01, 0.000e+00 }, // NOx
        { 1.986e+00, 2.134e-02, 8.645e-01, 0.000e+00, 1.250e-04, 2.448e-03, 2.018e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-VI_A-C
        { 7.734e+03, 7.194e+02, 1.833e+04, 0.000e+00, 0.000e+00, 1.751e+03, 0.000e+00 }, // CO2(total)
        { 2.762e+00, 5.547e-02, 3.229e+00, 0.000e+00, 0.000e+00, 1.469e-01, 0.000e+00 }, // CO
        { 3.050e-01, 9.227e-03, 4.805e-01, 0.000e+00, 0.000e+00, 2.104e-02, 0.000e+00 }, // HC
        { 2.486e+03, 2.312e+02, 5.891e+03, 0.000e+00, 0.000e+00, 5.628e+02, 0.000e+00 }, // FC
        { 6.535e+00, 0.000e+00, 1.363e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.652e-03 }, // NOx
        { 1.599e+00, 0.000e+00, 1.509e-01, 0.000e+00, 1.251e-04, 2.421e-03, 2.235e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-VIs_A-C
        { 7.734e+03, 7.194e+02, 1.833e+04, 0.000e+00, 0.000e+00, 1.751e+03, 0.000e+00 }, // CO2(total)
        { 2.762e+00, 5.547e-02, 3.229e+00, 0.000e+00, 0.000e+00, 1.469e-01, 0.000e+00 }, // CO
        { 3.050e-01, 9.227e-03, 4.805e-01, 0.000e+00, 0.000e+00, 2.104e-02, 0.000e+00 }, // HC
        { 2.486e+03, 2.312e+02, 5.891e+03, 0.000e+00, 0.000e+00, 5.628e+02, 0.000e+00 }, // FC
        { 5.189e+01, 5.604e+00, 1.104e+02, 0.000e+00, 0.000e+00, 1.373e+01, 0.000e+00 }, // NOx
        { 1.599e+00, 0.000e+00, 1.509e-01, 0.000e+00, 1.251e-04, 2.421e-03, 2.235e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-VI_D-E
        { 6.788e+03, 7.801e+02, 1.573e+04, 0.000e+00, 0.000e+00, 1.925e+03, 0.000e+00 }, // CO2(total)
        { 6.148e-01, 0.000e+00, 5.132e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.131e-01, 8.386e-03, 1.216e-01, 0.000e+00, 0.000e+00, 2.184e-02, 0.000e+00 }, // HC
        { 2.181e+03, 2.507e+02, 5.054e+03, 0.000e+00, 0.000e+00, 6.187e+02, 0.000e+00 }, // FC
        { 2.469e+00, 0.000e+00, 0.000e+00, 6.912e-04, 1.354e-04, 0.000e+00, 4.799e-03 }, // NOx
        { 1.479e+00, 1.976e-03, 5.975e-02, 0.000e+00, 1.253e-04, 7.811e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt34-40t_Euro-VIs_D-E
        { 6.788e+03, 7.801e+02, 1.573e+04, 0.000e+00, 0.000e+00, 1.925e+03, 0.000e+00 }, // CO2(total)
        { 6.148e-01, 0.000e+00, 5.132e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.131e-01, 8.386e-03, 1.216e-01, 0.000e+00, 0.000e+00, 2.184e-02, 0.000e+00 }, // HC
        { 2.181e+03, 2.507e+02, 5.054e+03, 0.000e+00, 0.000e+00, 6.187e+02, 0.000e+00 }, // FC
        { 4.364e+01, 7.598e+00, 6.750e+01, 0.000e+00, 0.000e+00, 1.654e+01, 7.863e-02 }, // NOx
        { 1.479e+00, 1.976e-03, 5.975e-02, 0.000e+00, 1.253e-04, 7.811e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_50ties
        { 9.112e+03, 9.392e+02, 1.893e+04, 0.000e+00, 0.000e+00, 2.255e+03, 0.000e+00 }, // CO2(total)
        { 2.891e+01, 9.981e-01, 2.849e+01, 0.000e+00, 0.000e+00, 2.436e+00, 0.000e+00 }, // CO
        { 9.139e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.095e-04, 4.410e-01, 2.849e-03 }, // HC
        { 2.928e+03, 3.019e+02, 6.084e+03, 0.000e+00, 0.000e+00, 7.246e+02, 0.000e+00 }, // FC
        { 1.356e+02, 1.417e+01, 2.820e+02, 0.000e+00, 0.000e+00, 3.416e+01, 0.000e+00 }, // NOx
        { 7.462e+00, 2.883e-01, 7.234e+00, 0.000e+00, 1.295e-04, 5.455e-01, 6.371e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_60ties
        { 9.112e+03, 9.392e+02, 1.893e+04, 0.000e+00, 0.000e+00, 2.255e+03, 0.000e+00 }, // CO2(total)
        { 2.891e+01, 9.981e-01, 2.849e+01, 0.000e+00, 0.000e+00, 2.436e+00, 0.000e+00 }, // CO
        { 9.139e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.095e-04, 4.410e-01, 2.849e-03 }, // HC
        { 2.928e+03, 3.019e+02, 6.084e+03, 0.000e+00, 0.000e+00, 7.246e+02, 0.000e+00 }, // FC
        { 1.356e+02, 1.417e+01, 2.820e+02, 0.000e+00, 0.000e+00, 3.416e+01, 0.000e+00 }, // NOx
        { 7.462e+00, 2.883e-01, 7.234e+00, 0.000e+00, 1.295e-04, 5.455e-01, 6.371e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_70ties
        { 9.112e+03, 9.392e+02, 1.893e+04, 0.000e+00, 0.000e+00, 2.255e+03, 0.000e+00 }, // CO2(total)
        { 2.891e+01, 9.981e-01, 2.849e+01, 0.000e+00, 0.000e+00, 2.436e+00, 0.000e+00 }, // CO
        { 9.139e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.095e-04, 4.410e-01, 2.849e-03 }, // HC
        { 2.928e+03, 3.019e+02, 6.084e+03, 0.000e+00, 0.000e+00, 7.246e+02, 0.000e+00 }, // FC
        { 1.356e+02, 1.417e+01, 2.820e+02, 0.000e+00, 0.000e+00, 3.416e+01, 0.000e+00 }, // NOx
        { 7.462e+00, 2.883e-01, 7.234e+00, 0.000e+00, 1.295e-04, 5.455e-01, 6.371e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_80ties
        { 9.112e+03, 9.392e+02, 1.893e+04, 0.000e+00, 0.000e+00, 2.255e+03, 0.000e+00 }, // CO2(total)
        { 2.891e+01, 9.981e-01, 2.849e+01, 0.000e+00, 0.000e+00, 2.436e+00, 0.000e+00 }, // CO
        { 9.139e+00, 0.000e+00, 0.000e+00, 0.000e+00, 2.095e-04, 4.410e-01, 2.849e-03 }, // HC
        { 2.928e+03, 3.019e+02, 6.084e+03, 0.000e+00, 0.000e+00, 7.246e+02, 0.000e+00 }, // FC
        { 1.356e+02, 1.417e+01, 2.820e+02, 0.000e+00, 0.000e+00, 3.416e+01, 0.000e+00 }, // NOx
        { 7.462e+00, 2.883e-01, 7.234e+00, 0.000e+00, 1.295e-04, 5.455e-01, 6.371e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-I
        { 8.629e+03, 9.035e+02, 1.684e+04, 0.000e+00, 0.000e+00, 2.226e+03, 0.000e+00 }, // CO2(total)
        { 2.678e+01, 1.079e+00, 6.171e+01, 4.903e-03, 0.000e+00, 0.000e+00, 7.793e-02 }, // CO
        { 7.480e+00, 1.964e-01, 4.548e-01, 0.000e+00, 0.000e+00, 8.486e-01, 0.000e+00 }, // HC
        { 2.773e+03, 2.904e+02, 5.412e+03, 0.000e+00, 0.000e+00, 7.154e+02, 0.000e+00 }, // FC
        { 9.764e+01, 9.043e+00, 1.901e+02, 0.000e+00, 0.000e+00, 2.212e+01, 0.000e+00 }, // NOx
        { 5.899e+00, 2.541e-01, 1.782e+00, 0.000e+00, 1.319e-04, 7.472e-01, 7.773e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-II
        { 8.396e+03, 9.314e+02, 1.714e+04, 0.000e+00, 0.000e+00, 2.327e+03, 0.000e+00 }, // CO2(total)
        { 2.124e+01, 0.000e+00, 2.381e+01, 3.255e-02, 0.000e+00, 0.000e+00, 8.323e-02 }, // CO
        { 5.347e+00, 1.239e-01, 1.475e+00, 0.000e+00, 0.000e+00, 5.043e-01, 0.000e+00 }, // HC
        { 2.698e+03, 2.993e+02, 5.509e+03, 0.000e+00, 0.000e+00, 7.480e+02, 0.000e+00 }, // FC
        { 1.042e+02, 9.102e+00, 1.963e+02, 0.000e+00, 0.000e+00, 2.285e+01, 0.000e+00 }, // NOx
        { 3.019e+00, 1.594e-01, 9.889e-01, 0.000e+00, 1.273e-04, 3.527e-01, 5.595e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-III
        { 8.727e+03, 8.797e+02, 1.748e+04, 0.000e+00, 0.000e+00, 2.195e+03, 0.000e+00 }, // CO2(total)
        { 2.393e+01, 7.876e-01, 2.142e+01, 0.000e+00, 0.000e+00, 1.818e+00, 0.000e+00 }, // CO
        { 5.742e+00, 1.019e-02, 1.647e+00, 1.582e-03, 0.000e+00, 3.220e-01, 0.000e+00 }, // HC
        { 2.805e+03, 2.827e+02, 5.619e+03, 0.000e+00, 0.000e+00, 7.055e+02, 0.000e+00 }, // FC
        { 8.219e+01, 7.348e+00, 1.677e+02, 0.000e+00, 0.000e+00, 1.741e+01, 0.000e+00 }, // NOx
        { 4.087e+00, 6.920e-02, 1.263e+00, 0.000e+00, 1.279e-04, 1.813e-01, 8.264e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-IV_EGR
        { 8.160e+03, 9.163e+02, 1.804e+04, 0.000e+00, 0.000e+00, 2.244e+03, 0.000e+00 }, // CO2(total)
        { 1.395e+01, 6.209e-01, 2.023e+01, 0.000e+00, 0.000e+00, 1.862e+00, 0.000e+00 }, // CO
        { 6.353e-01, 5.067e-02, 1.026e+00, 0.000e+00, 0.000e+00, 1.207e-01, 0.000e+00 }, // HC
        { 2.623e+03, 2.945e+02, 5.797e+03, 0.000e+00, 0.000e+00, 7.211e+02, 0.000e+00 }, // FC
        { 8.654e+01, 4.428e+00, 1.911e+02, 0.000e+00, 0.000e+00, 1.051e+01, 0.000e+00 }, // NOx
        { 2.148e+00, 1.542e-02, 9.977e-01, 0.000e+00, 1.282e-04, 4.683e-02, 9.092e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-IV_SCR
        { 9.834e+03, 7.607e+02, 2.329e+04, 0.000e+00, 0.000e+00, 1.776e+03, 0.000e+00 }, // CO2(total)
        { 3.941e+01, 8.825e-01, 5.764e+01, 0.000e+00, 0.000e+00, 3.222e+00, 0.000e+00 }, // CO
        { 3.372e-01, 1.496e-02, 6.499e-01, 0.000e+00, 0.000e+00, 3.193e-02, 0.000e+00 }, // HC
        { 3.160e+03, 2.445e+02, 7.484e+03, 0.000e+00, 0.000e+00, 5.707e+02, 0.000e+00 }, // FC
        { 6.034e+01, 1.744e+00, 4.191e+01, 0.000e+00, 0.000e+00, 7.564e+00, 0.000e+00 }, // NOx
        { 2.118e+00, 2.173e-02, 8.856e-01, 0.000e+00, 1.254e-04, 6.924e-02, 7.463e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-IV_SCRs
        { 9.834e+03, 7.607e+02, 2.329e+04, 0.000e+00, 0.000e+00, 1.776e+03, 0.000e+00 }, // CO2(total)
        { 3.941e+01, 8.825e-01, 5.764e+01, 0.000e+00, 0.000e+00, 3.222e+00, 0.000e+00 }, // CO
        { 3.372e-01, 1.496e-02, 6.499e-01, 0.000e+00, 0.000e+00, 3.193e-02, 0.000e+00 }, // HC
        { 3.160e+03, 2.445e+02, 7.484e+03, 0.000e+00, 0.000e+00, 5.707e+02, 0.000e+00 }, // FC
        { 1.075e+02, 8.281e+00, 2.219e+02, 0.000e+00, 0.000e+00, 2.004e+01, 0.000e+00 }, // NOx
        { 2.118e+00, 2.173e-02, 8.856e-01, 0.000e+00, 1.254e-04, 6.924e-02, 7.463e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-V_EGR
        { 9.541e+03, 7.680e+02, 2.269e+04, 0.000e+00, 0.000e+00, 1.812e+03, 0.000e+00 }, // CO2(total)
        { 1.261e+01, 8.155e-02, 1.657e+01, 0.000e+00, 0.000e+00, 5.805e-01, 0.000e+00 }, // CO
        { 1.085e+00, 5.545e-02, 9.567e-01, 0.000e+00, 0.000e+00, 1.610e-01, 1.181e-04 }, // HC
        { 3.066e+03, 2.468e+02, 7.291e+03, 0.000e+00, 0.000e+00, 5.824e+02, 0.000e+00 }, // FC
        { 5.716e+01, 3.648e+00, 8.585e+01, 0.000e+00, 0.000e+00, 9.986e+00, 0.000e+00 }, // NOx
        { 1.844e+00, 2.410e-02, 7.418e-01, 0.000e+00, 1.251e-04, 5.967e-02, 2.653e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-V_SCR
        { 8.749e+03, 8.240e+02, 2.062e+04, 0.000e+00, 0.000e+00, 2.007e+03, 0.000e+00 }, // CO2(total)
        { 2.971e+01, 1.048e+00, 4.283e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.110e-01 }, // CO
        { 3.529e-01, 1.751e-02, 6.015e-01, 0.000e+00, 0.000e+00, 3.752e-02, 0.000e+00 }, // HC
        { 2.812e+03, 2.648e+02, 6.626e+03, 0.000e+00, 0.000e+00, 6.449e+02, 0.000e+00 }, // FC
        { 4.931e+01, 6.035e-01, 0.000e+00, 0.000e+00, 0.000e+00, 4.095e+00, 0.000e+00 }, // NOx
        { 2.071e+00, 2.418e-02, 9.953e-01, 0.000e+00, 1.248e-04, 2.427e-03, 2.290e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-V_SCRs
        { 8.749e+03, 8.240e+02, 2.062e+04, 0.000e+00, 0.000e+00, 2.007e+03, 0.000e+00 }, // CO2(total)
        { 2.971e+01, 1.048e+00, 4.283e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.110e-01 }, // CO
        { 3.529e-01, 1.751e-02, 6.015e-01, 0.000e+00, 0.000e+00, 3.752e-02, 0.000e+00 }, // HC
        { 2.812e+03, 2.648e+02, 6.626e+03, 0.000e+00, 0.000e+00, 6.449e+02, 0.000e+00 }, // FC
        { 1.117e+02, 8.606e+00, 2.040e+02, 0.000e+00, 0.000e+00, 2.110e+01, 0.000e+00 }, // NOx
        { 2.071e+00, 2.418e-02, 9.953e-01, 0.000e+00, 1.248e-04, 2.427e-03, 2.290e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-VI_A-C
        { 8.734e+03, 8.096e+02, 2.072e+04, 0.000e+00, 0.000e+00, 1.970e+03, 0.000e+00 }, // CO2(total)
        { 3.165e+00, 6.407e-02, 3.694e+00, 0.000e+00, 0.000e+00, 1.697e-01, 0.000e+00 }, // CO
        { 3.477e-01, 1.072e-02, 5.464e-01, 0.000e+00, 0.000e+00, 2.446e-02, 0.000e+00 }, // HC
        { 2.807e+03, 2.602e+02, 6.660e+03, 0.000e+00, 0.000e+00, 6.332e+02, 0.000e+00 }, // FC
        { 7.421e+00, 0.000e+00, 1.211e-01, 0.000e+00, 0.000e+00, 0.000e+00, 4.278e-03 }, // NOx
        { 1.624e+00, 0.000e+00, 1.773e-01, 0.000e+00, 1.250e-04, 2.406e-03, 2.499e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-VIs_A-C
        { 8.734e+03, 8.096e+02, 2.072e+04, 0.000e+00, 0.000e+00, 1.970e+03, 0.000e+00 }, // CO2(total)
        { 3.165e+00, 6.407e-02, 3.694e+00, 0.000e+00, 0.000e+00, 1.697e-01, 0.000e+00 }, // CO
        { 3.477e-01, 1.072e-02, 5.464e-01, 0.000e+00, 0.000e+00, 2.446e-02, 0.000e+00 }, // HC
        { 2.807e+03, 2.602e+02, 6.660e+03, 0.000e+00, 0.000e+00, 6.332e+02, 0.000e+00 }, // FC
        { 6.007e+01, 6.379e+00, 1.281e+02, 0.000e+00, 0.000e+00, 1.563e+01, 0.000e+00 }, // NOx
        { 1.624e+00, 0.000e+00, 1.773e-01, 0.000e+00, 1.250e-04, 2.406e-03, 2.499e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-VI_D-E
        { 7.647e+03, 8.802e+02, 1.770e+04, 0.000e+00, 0.000e+00, 2.174e+03, 0.000e+00 }, // CO2(total)
        { 7.062e-01, 0.000e+00, 5.907e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.741e-01, 9.597e-03, 1.395e-01, 0.000e+00, 0.000e+00, 2.505e-02, 0.000e+00 }, // HC
        { 2.458e+03, 2.829e+02, 5.689e+03, 0.000e+00, 0.000e+00, 6.986e+02, 0.000e+00 }, // FC
        { 2.830e+00, 0.000e+00, 0.000e+00, 1.701e-03, 1.201e-04, 0.000e+00, 5.108e-03 }, // NOx
        { 1.483e+00, 2.284e-03, 6.792e-02, 0.000e+00, 1.253e-04, 8.557e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt40-50t_Euro-VIs_D-E
        { 7.647e+03, 8.802e+02, 1.770e+04, 0.000e+00, 0.000e+00, 2.174e+03, 0.000e+00 }, // CO2(total)
        { 7.062e-01, 0.000e+00, 5.907e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.741e-01, 9.597e-03, 1.395e-01, 0.000e+00, 0.000e+00, 2.505e-02, 0.000e+00 }, // HC
        { 2.458e+03, 2.829e+02, 5.689e+03, 0.000e+00, 0.000e+00, 6.986e+02, 0.000e+00 }, // FC
        { 5.056e+01, 8.656e+00, 8.355e+01, 0.000e+00, 0.000e+00, 1.816e+01, 1.103e-01 }, // NOx
        { 1.483e+00, 2.284e-03, 6.792e-02, 0.000e+00, 1.253e-04, 8.557e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_50ties
        { 1.221e+04, 1.084e+03, 2.430e+04, 0.000e+00, 0.000e+00, 2.656e+03, 0.000e+00 }, // CO2(total)
        { 5.115e+01, 2.029e-01, 8.664e+01, 1.091e-02, 0.000e+00, 0.000e+00, 1.965e-02 }, // CO
        { 1.117e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.582e-04, 5.618e-01, 2.929e-03 }, // HC
        { 3.925e+03, 3.485e+02, 7.808e+03, 0.000e+00, 0.000e+00, 8.537e+02, 0.000e+00 }, // FC
        { 1.835e+02, 1.706e+01, 3.578e+02, 0.000e+00, 0.000e+00, 4.223e+01, 0.000e+00 }, // NOx
        { 1.041e+01, 2.742e-01, 1.411e+01, 0.000e+00, 1.332e-04, 3.999e-01, 5.982e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_60ties
        { 1.221e+04, 1.084e+03, 2.430e+04, 0.000e+00, 0.000e+00, 2.656e+03, 0.000e+00 }, // CO2(total)
        { 5.115e+01, 2.029e-01, 8.664e+01, 1.091e-02, 0.000e+00, 0.000e+00, 1.965e-02 }, // CO
        { 1.117e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.582e-04, 5.618e-01, 2.929e-03 }, // HC
        { 3.925e+03, 3.485e+02, 7.808e+03, 0.000e+00, 0.000e+00, 8.537e+02, 0.000e+00 }, // FC
        { 1.835e+02, 1.706e+01, 3.578e+02, 0.000e+00, 0.000e+00, 4.223e+01, 0.000e+00 }, // NOx
        { 1.041e+01, 2.742e-01, 1.411e+01, 0.000e+00, 1.332e-04, 3.999e-01, 5.982e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_70ties
        { 1.221e+04, 1.084e+03, 2.430e+04, 0.000e+00, 0.000e+00, 2.656e+03, 0.000e+00 }, // CO2(total)
        { 5.115e+01, 2.029e-01, 8.664e+01, 1.091e-02, 0.000e+00, 0.000e+00, 1.965e-02 }, // CO
        { 1.117e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.582e-04, 5.618e-01, 2.929e-03 }, // HC
        { 3.925e+03, 3.485e+02, 7.808e+03, 0.000e+00, 0.000e+00, 8.537e+02, 0.000e+00 }, // FC
        { 1.835e+02, 1.706e+01, 3.578e+02, 0.000e+00, 0.000e+00, 4.223e+01, 0.000e+00 }, // NOx
        { 1.041e+01, 2.742e-01, 1.411e+01, 0.000e+00, 1.332e-04, 3.999e-01, 5.982e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_80ties
        { 1.221e+04, 1.084e+03, 2.430e+04, 0.000e+00, 0.000e+00, 2.656e+03, 0.000e+00 }, // CO2(total)
        { 5.115e+01, 2.029e-01, 8.664e+01, 1.091e-02, 0.000e+00, 0.000e+00, 1.965e-02 }, // CO
        { 1.117e+01, 0.000e+00, 0.000e+00, 0.000e+00, 2.582e-04, 5.618e-01, 2.929e-03 }, // HC
        { 3.925e+03, 3.485e+02, 7.808e+03, 0.000e+00, 0.000e+00, 8.537e+02, 0.000e+00 }, // FC
        { 1.835e+02, 1.706e+01, 3.578e+02, 0.000e+00, 0.000e+00, 4.223e+01, 0.000e+00 }, // NOx
        { 1.041e+01, 2.742e-01, 1.411e+01, 0.000e+00, 1.332e-04, 3.999e-01, 5.982e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-I
        { 1.380e+04, 9.670e+02, 3.076e+04, 0.000e+00, 0.000e+00, 2.314e+03, 0.000e+00 }, // CO2(total)
        { 1.821e+01, 2.441e+00, 3.316e+01, 0.000e+00, 0.000e+00, 1.564e+00, 1.483e-01 }, // CO
        { 1.139e+01, 1.241e-01, 8.466e+00, 0.000e+00, 0.000e+00, 6.507e-01, 0.000e+00 }, // HC
        { 4.436e+03, 3.108e+02, 9.886e+03, 0.000e+00, 0.000e+00, 7.437e+02, 0.000e+00 }, // FC
        { 1.486e+02, 1.039e+01, 3.132e+02, 0.000e+00, 0.000e+00, 2.524e+01, 0.000e+00 }, // NOx
        { 8.485e+00, 2.503e-01, 7.167e+00, 0.000e+00, 1.284e-04, 7.160e-01, 8.315e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-II
        { 1.163e+04, 1.030e+03, 2.287e+04, 0.000e+00, 0.000e+00, 2.583e+03, 0.000e+00 }, // CO2(total)
        { 3.743e+01, 2.650e-01, 7.833e+01, 0.000e+00, 1.998e-04, 0.000e+00, 2.262e-03 }, // CO
        { 6.411e+00, 1.458e-01, 1.017e+00, 0.000e+00, 0.000e+00, 6.253e-01, 0.000e+00 }, // HC
        { 3.737e+03, 3.311e+02, 7.349e+03, 0.000e+00, 0.000e+00, 8.300e+02, 0.000e+00 }, // FC
        { 1.394e+02, 1.073e+01, 2.517e+02, 0.000e+00, 0.000e+00, 2.730e+01, 0.000e+00 }, // NOx
        { 4.417e+00, 1.417e-01, 4.983e+00, 0.000e+00, 1.322e-04, 2.595e-01, 8.283e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-III
        { 1.268e+04, 9.985e+02, 2.763e+04, 0.000e+00, 0.000e+00, 2.466e+03, 0.000e+00 }, // CO2(total)
        { 2.690e+01, 5.888e-01, 1.870e+01, 2.580e-02, 0.000e+00, 0.000e+00, 1.255e-01 }, // CO
        { 6.809e+00, 7.638e-02, 3.459e+00, 0.000e+00, 0.000e+00, 3.846e-01, 0.000e+00 }, // HC
        { 4.076e+03, 3.209e+02, 8.880e+03, 0.000e+00, 0.000e+00, 7.926e+02, 0.000e+00 }, // FC
        { 1.121e+02, 8.692e+00, 2.298e+02, 0.000e+00, 0.000e+00, 2.064e+01, 0.000e+00 }, // NOx
        { 4.764e+00, 1.007e-01, 1.990e+00, 0.000e+00, 1.261e-04, 2.649e-01, 7.326e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-IV_EGR
        { 1.392e+04, 8.385e+02, 3.335e+04, 0.000e+00, 0.000e+00, 1.913e+03, 0.000e+00 }, // CO2(total)
        { 1.986e+01, 6.386e-01, 3.100e+01, 0.000e+00, 0.000e+00, 1.994e+00, 0.000e+00 }, // CO
        { 7.838e-01, 6.369e-02, 1.068e+00, 0.000e+00, 0.000e+00, 1.595e-01, 0.000e+00 }, // HC
        { 4.474e+03, 2.695e+02, 1.072e+04, 0.000e+00, 0.000e+00, 6.148e+02, 0.000e+00 }, // FC
        { 1.108e+02, 5.869e+00, 2.149e+02, 0.000e+00, 0.000e+00, 1.543e+01, 0.000e+00 }, // NOx
        { 2.228e+00, 2.850e-02, 7.338e-01, 0.000e+00, 1.269e-04, 9.708e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-IV_SCR
        { 1.356e+04, 8.895e+02, 3.283e+04, 0.000e+00, 0.000e+00, 2.076e+03, 0.000e+00 }, // CO2(total)
        { 4.283e+01, 1.036e+00, 6.340e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.469e-01 }, // CO
        { 4.493e-01, 1.782e-02, 8.626e-01, 0.000e+00, 0.000e+00, 4.029e-02, 0.000e+00 }, // HC
        { 4.357e+03, 2.859e+02, 1.055e+04, 0.000e+00, 0.000e+00, 6.673e+02, 0.000e+00 }, // FC
        { 8.031e+01, 1.948e+00, 7.087e+01, 0.000e+00, 0.000e+00, 8.843e+00, 0.000e+00 }, // NOx
        { 2.203e+00, 2.578e-02, 1.227e+00, 0.000e+00, 1.254e-04, 0.000e+00, 2.941e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-IV_SCRs
        { 1.356e+04, 8.895e+02, 3.283e+04, 0.000e+00, 0.000e+00, 2.076e+03, 0.000e+00 }, // CO2(total)
        { 4.283e+01, 1.036e+00, 6.340e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.469e-01 }, // CO
        { 4.493e-01, 1.782e-02, 8.626e-01, 0.000e+00, 0.000e+00, 4.029e-02, 0.000e+00 }, // HC
        { 4.357e+03, 2.859e+02, 1.055e+04, 0.000e+00, 0.000e+00, 6.673e+02, 0.000e+00 }, // FC
        { 1.512e+02, 9.787e+00, 3.246e+02, 0.000e+00, 0.000e+00, 2.370e+01, 0.000e+00 }, // NOx
        { 2.203e+00, 2.578e-02, 1.227e+00, 0.000e+00, 1.254e-04, 0.000e+00, 2.941e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-V_EGR
        { 1.314e+04, 8.965e+02, 3.178e+04, 0.000e+00, 0.000e+00, 2.112e+03, 0.000e+00 }, // CO2(total)
        { 1.274e+01, 1.727e-01, 1.317e+01, 0.000e+00, 0.000e+00, 5.911e-02, 3.491e-02 }, // CO
        { 1.352e+00, 6.429e-02, 2.062e+00, 0.000e+00, 0.000e+00, 6.103e-02, 4.182e-03 }, // HC
        { 4.222e+03, 2.881e+02, 1.021e+04, 0.000e+00, 0.000e+00, 6.787e+02, 0.000e+00 }, // FC
        { 6.855e+01, 4.353e+00, 8.695e+01, 0.000e+00, 0.000e+00, 1.223e+01, 0.000e+00 }, // NOx
        { 2.082e+00, 2.620e-02, 1.387e+00, 0.000e+00, 1.256e-04, 6.436e-02, 9.930e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-V_SCR
        { 1.266e+04, 8.902e+02, 3.040e+04, 0.000e+00, 0.000e+00, 2.106e+03, 0.000e+00 }, // CO2(total)
        { 3.992e+01, 1.049e+00, 5.594e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.239e-01 }, // CO
        { 4.579e-01, 1.858e-02, 7.404e-01, 0.000e+00, 0.000e+00, 3.946e-02, 0.000e+00 }, // HC
        { 4.070e+03, 2.861e+02, 9.771e+03, 0.000e+00, 0.000e+00, 6.768e+02, 0.000e+00 }, // FC
        { 6.310e+01, 6.533e-01, 5.853e+00, 0.000e+00, 0.000e+00, 4.979e+00, 0.000e+00 }, // NOx
        { 2.395e+00, 0.000e+00, 1.137e+00, 8.306e-04, 1.260e-04, 0.000e+00, 2.849e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-V_SCRs
        { 1.266e+04, 8.902e+02, 3.040e+04, 0.000e+00, 0.000e+00, 2.106e+03, 0.000e+00 }, // CO2(total)
        { 3.992e+01, 1.049e+00, 5.594e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.239e-01 }, // CO
        { 4.579e-01, 1.858e-02, 7.404e-01, 0.000e+00, 0.000e+00, 3.946e-02, 0.000e+00 }, // HC
        { 4.070e+03, 2.861e+02, 9.771e+03, 0.000e+00, 0.000e+00, 6.768e+02, 0.000e+00 }, // FC
        { 1.620e+02, 9.615e+00, 3.198e+02, 0.000e+00, 0.000e+00, 2.304e+01, 0.000e+00 }, // NOx
        { 2.395e+00, 0.000e+00, 1.137e+00, 8.306e-04, 1.260e-04, 0.000e+00, 2.849e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-VI_A-C
        { 1.258e+04, 8.750e+02, 3.025e+04, 0.000e+00, 0.000e+00, 2.073e+03, 0.000e+00 }, // CO2(total)
        { 3.662e+00, 7.584e-02, 3.027e+00, 0.000e+00, 0.000e+00, 2.380e-01, 0.000e+00 }, // CO
        { 4.135e-01, 1.118e-02, 5.320e-01, 0.000e+00, 0.000e+00, 2.684e-02, 0.000e+00 }, // HC
        { 4.044e+03, 2.812e+02, 9.720e+03, 0.000e+00, 0.000e+00, 6.662e+02, 0.000e+00 }, // FC
        { 8.744e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 4.843e-03 }, // NOx
        { 1.642e+00, 8.846e-04, 8.281e-02, 0.000e+00, 1.257e-04, 1.497e-02, 4.443e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-VIs_A-C
        { 1.258e+04, 8.750e+02, 3.025e+04, 0.000e+00, 0.000e+00, 2.073e+03, 0.000e+00 }, // CO2(total)
        { 3.662e+00, 7.584e-02, 3.027e+00, 0.000e+00, 0.000e+00, 2.380e-01, 0.000e+00 }, // CO
        { 4.135e-01, 1.118e-02, 5.320e-01, 0.000e+00, 0.000e+00, 2.684e-02, 0.000e+00 }, // HC
        { 4.044e+03, 2.812e+02, 9.720e+03, 0.000e+00, 0.000e+00, 6.662e+02, 0.000e+00 }, // FC
        { 9.533e+01, 7.166e+00, 2.294e+02, 0.000e+00, 0.000e+00, 1.654e+01, 0.000e+00 }, // NOx
        { 1.642e+00, 8.846e-04, 8.281e-02, 0.000e+00, 1.257e-04, 1.497e-02, 4.443e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-VI_D-E
        { 1.186e+04, 9.195e+02, 2.886e+04, 0.000e+00, 0.000e+00, 2.175e+03, 0.000e+00 }, // CO2(total)
        { 1.068e+00, 0.000e+00, 6.013e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.993e-03 }, // CO
        { 6.035e-01, 1.103e-02, 3.005e-01, 0.000e+00, 0.000e+00, 2.739e-02, 0.000e+00 }, // HC
        { 3.812e+03, 2.955e+02, 9.276e+03, 0.000e+00, 0.000e+00, 6.991e+02, 0.000e+00 }, // FC
        { 3.316e+00, 4.955e-03, 0.000e+00, 5.416e-03, 0.000e+00, 0.000e+00, 6.880e-03 }, // NOx
        { 1.488e+00, 2.503e-03, 1.092e-01, 0.000e+00, 1.254e-04, 6.612e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt50-60t_Euro-VIs_D-E
        { 1.186e+04, 9.195e+02, 2.886e+04, 0.000e+00, 0.000e+00, 2.175e+03, 0.000e+00 }, // CO2(total)
        { 1.068e+00, 0.000e+00, 6.013e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.993e-03 }, // CO
        { 6.035e-01, 1.103e-02, 3.005e-01, 0.000e+00, 0.000e+00, 2.739e-02, 0.000e+00 }, // HC
        { 3.812e+03, 2.955e+02, 9.276e+03, 0.000e+00, 0.000e+00, 6.991e+02, 0.000e+00 }, // FC
        { 8.758e+01, 9.500e+00, 1.507e+02, 0.000e+00, 0.000e+00, 2.328e+01, 0.000e+00 }, // NOx
        { 1.488e+00, 2.503e-03, 1.092e-01, 0.000e+00, 1.254e-04, 6.612e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_50ties
        { 2.132e+04, 9.438e+02, 4.948e+04, 0.000e+00, 0.000e+00, 1.949e+03, 0.000e+00 }, // CO2(total)
        { 4.975e+01, 1.416e+00, 5.016e+01, 0.000e+00, 0.000e+00, 3.396e+00, 0.000e+00 }, // CO
        { 1.284e+01, 0.000e+00, 4.804e+00, 0.000e+00, 5.118e-04, 4.444e-01, 0.000e+00 }, // HC
        { 6.851e+03, 3.033e+02, 1.590e+04, 0.000e+00, 0.000e+00, 6.265e+02, 0.000e+00 }, // FC
        { 3.343e+02, 1.506e+01, 7.750e+02, 0.000e+00, 0.000e+00, 3.130e+01, 0.000e+00 }, // NOx
        { 1.255e+01, 3.512e-01, 1.820e+01, 0.000e+00, 1.360e-04, 3.374e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_60ties
        { 2.132e+04, 9.438e+02, 4.948e+04, 0.000e+00, 0.000e+00, 1.949e+03, 0.000e+00 }, // CO2(total)
        { 4.975e+01, 1.416e+00, 5.016e+01, 0.000e+00, 0.000e+00, 3.396e+00, 0.000e+00 }, // CO
        { 1.284e+01, 0.000e+00, 4.804e+00, 0.000e+00, 5.118e-04, 4.444e-01, 0.000e+00 }, // HC
        { 6.851e+03, 3.033e+02, 1.590e+04, 0.000e+00, 0.000e+00, 6.265e+02, 0.000e+00 }, // FC
        { 3.343e+02, 1.506e+01, 7.750e+02, 0.000e+00, 0.000e+00, 3.130e+01, 0.000e+00 }, // NOx
        { 1.255e+01, 3.512e-01, 1.820e+01, 0.000e+00, 1.360e-04, 3.374e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_70ties
        { 2.132e+04, 9.438e+02, 4.948e+04, 0.000e+00, 0.000e+00, 1.949e+03, 0.000e+00 }, // CO2(total)
        { 4.975e+01, 1.416e+00, 5.016e+01, 0.000e+00, 0.000e+00, 3.396e+00, 0.000e+00 }, // CO
        { 1.284e+01, 0.000e+00, 4.804e+00, 0.000e+00, 5.118e-04, 4.444e-01, 0.000e+00 }, // HC
        { 6.851e+03, 3.033e+02, 1.590e+04, 0.000e+00, 0.000e+00, 6.265e+02, 0.000e+00 }, // FC
        { 3.343e+02, 1.506e+01, 7.750e+02, 0.000e+00, 0.000e+00, 3.130e+01, 0.000e+00 }, // NOx
        { 1.255e+01, 3.512e-01, 1.820e+01, 0.000e+00, 1.360e-04, 3.374e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_80ties
        { 2.132e+04, 9.438e+02, 4.948e+04, 0.000e+00, 0.000e+00, 1.949e+03, 0.000e+00 }, // CO2(total)
        { 4.975e+01, 1.416e+00, 5.016e+01, 0.000e+00, 0.000e+00, 3.396e+00, 0.000e+00 }, // CO
        { 1.284e+01, 0.000e+00, 4.804e+00, 0.000e+00, 5.118e-04, 4.444e-01, 0.000e+00 }, // HC
        { 6.851e+03, 3.033e+02, 1.590e+04, 0.000e+00, 0.000e+00, 6.265e+02, 0.000e+00 }, // FC
        { 3.343e+02, 1.506e+01, 7.750e+02, 0.000e+00, 0.000e+00, 3.130e+01, 0.000e+00 }, // NOx
        { 1.255e+01, 3.512e-01, 1.820e+01, 0.000e+00, 1.360e-04, 3.374e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-I
        { 2.393e+04, 6.052e+02, 5.427e+04, 0.000e+00, 0.000e+00, 1.210e+03, 0.000e+00 }, // CO2(total)
        { 3.222e+01, 3.237e+00, 2.638e+01, 0.000e+00, 0.000e+00, 7.983e+00, 0.000e+00 }, // CO
        { 1.394e+01, 0.000e+00, 9.476e+00, 0.000e+00, 3.100e-04, 6.564e-01, 0.000e+00 }, // HC
        { 7.692e+03, 1.945e+02, 1.744e+04, 0.000e+00, 0.000e+00, 3.888e+02, 0.000e+00 }, // FC
        { 2.703e+02, 6.232e+00, 5.867e+02, 0.000e+00, 0.000e+00, 1.325e+01, 0.000e+00 }, // NOx
        { 1.059e+01, 2.466e-01, 1.363e+01, 0.000e+00, 1.350e-04, 3.829e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-II
        { 2.148e+04, 8.205e+02, 4.995e+04, 0.000e+00, 0.000e+00, 1.703e+03, 0.000e+00 }, // CO2(total)
        { 3.165e+01, 1.429e+00, 2.240e+01, 0.000e+00, 0.000e+00, 4.283e+00, 0.000e+00 }, // CO
        { 8.352e+00, 1.306e-01, 6.602e+00, 0.000e+00, 0.000e+00, 4.390e-01, 0.000e+00 }, // HC
        { 6.904e+03, 2.637e+02, 1.605e+04, 0.000e+00, 0.000e+00, 5.472e+02, 0.000e+00 }, // FC
        { 2.433e+02, 8.857e+00, 5.125e+02, 0.000e+00, 0.000e+00, 2.042e+01, 0.000e+00 }, // NOx
        { 4.903e+00, 1.979e-01, 3.872e+00, 0.000e+00, 1.343e-04, 4.565e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-III
        { 1.753e+04, 1.149e+03, 3.573e+04, 0.000e+00, 0.000e+00, 2.793e+03, 0.000e+00 }, // CO2(total)
        { 4.420e+01, 0.000e+00, 4.925e+01, 0.000e+00, 1.364e-03, 0.000e+00, 7.870e-02 }, // CO
        { 6.984e+00, 1.495e-01, 1.485e+00, 0.000e+00, 0.000e+00, 6.202e-01, 0.000e+00 }, // HC
        { 5.635e+03, 3.692e+02, 1.148e+04, 0.000e+00, 0.000e+00, 8.976e+02, 0.000e+00 }, // FC
        { 1.771e+02, 8.976e+00, 3.522e+02, 0.000e+00, 0.000e+00, 2.217e+01, 0.000e+00 }, // NOx
        { 5.031e+00, 1.311e-01, 1.711e+00, 0.000e+00, 1.363e-04, 3.313e-01, 1.056e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-IV_EGR
        { 1.822e+04, 1.060e+03, 3.918e+04, 0.000e+00, 0.000e+00, 2.531e+03, 0.000e+00 }, // CO2(total)
        { 2.600e+01, 6.794e-01, 4.495e+01, 0.000e+00, 0.000e+00, 1.890e+00, 0.000e+00 }, // CO
        { 1.380e+00, 5.476e-02, 3.050e+00, 0.000e+00, 0.000e+00, 9.104e-02, 0.000e+00 }, // HC
        { 5.856e+03, 3.407e+02, 1.259e+04, 0.000e+00, 0.000e+00, 8.136e+02, 0.000e+00 }, // FC
        { 1.941e+02, 2.955e+00, 4.236e+02, 0.000e+00, 0.000e+00, 7.301e+00, 0.000e+00 }, // NOx
        { 2.618e+00, 7.985e-03, 1.893e+00, 0.000e+00, 1.361e-04, 4.203e-02, 1.909e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-IV_SCR
        { 1.874e+04, 9.918e+02, 3.828e+04, 0.000e+00, 0.000e+00, 2.498e+03, 0.000e+00 }, // CO2(total)
        { 6.750e+01, 0.000e+00, 1.385e+02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.441e-01, 2.256e-02, 1.123e+00, 0.000e+00, 0.000e+00, 3.676e-02, 0.000e+00 }, // HC
        { 6.023e+03, 3.187e+02, 1.230e+04, 0.000e+00, 0.000e+00, 8.027e+02, 0.000e+00 }, // FC
        { 9.727e+01, 2.753e+00, 8.738e+01, 0.000e+00, 0.000e+00, 1.097e+01, 0.000e+00 }, // NOx
        { 2.654e+00, 0.000e+00, 2.359e+00, 0.000e+00, 1.427e-04, 0.000e+00, 7.577e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-IV_SCRs
        { 1.874e+04, 9.918e+02, 3.828e+04, 0.000e+00, 0.000e+00, 2.498e+03, 0.000e+00 }, // CO2(total)
        { 6.750e+01, 0.000e+00, 1.385e+02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.441e-01, 2.256e-02, 1.123e+00, 0.000e+00, 0.000e+00, 3.676e-02, 0.000e+00 }, // HC
        { 6.023e+03, 3.187e+02, 1.230e+04, 0.000e+00, 0.000e+00, 8.027e+02, 0.000e+00 }, // FC
        { 2.082e+02, 1.143e+01, 3.845e+02, 0.000e+00, 0.000e+00, 2.978e+01, 0.000e+00 }, // NOx
        { 2.654e+00, 0.000e+00, 2.359e+00, 0.000e+00, 1.427e-04, 0.000e+00, 7.577e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-V_EGR
        { 1.848e+04, 9.819e+02, 3.870e+04, 0.000e+00, 0.000e+00, 2.436e+03, 0.000e+00 }, // CO2(total)
        { 1.796e+01, 0.000e+00, 3.628e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.789e+00, 7.166e-02, 2.004e+00, 0.000e+00, 0.000e+00, 2.131e-01, 0.000e+00 }, // HC
        { 5.939e+03, 3.156e+02, 1.244e+04, 0.000e+00, 0.000e+00, 7.828e+02, 0.000e+00 }, // FC
        { 1.335e+02, 2.251e+00, 2.565e+02, 0.000e+00, 0.000e+00, 6.212e+00, 0.000e+00 }, // NOx
        { 1.884e+00, 5.342e-02, 7.462e-01, 0.000e+00, 1.376e-04, 1.386e-01, 1.465e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-V_SCR
        { 1.785e+04, 9.768e+02, 3.762e+04, 0.000e+00, 0.000e+00, 2.397e+03, 0.000e+00 }, // CO2(total)
        { 6.703e+01, 0.000e+00, 1.274e+02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.786e-01, 2.240e-02, 9.750e-01, 0.000e+00, 0.000e+00, 4.218e-02, 0.000e+00 }, // HC
        { 5.736e+03, 3.139e+02, 1.209e+04, 0.000e+00, 0.000e+00, 7.703e+02, 0.000e+00 }, // FC
        { 7.673e+01, 7.118e-01, 1.052e+01, 0.000e+00, 0.000e+00, 5.949e+00, 0.000e+00 }, // NOx
        { 2.699e+00, 0.000e+00, 2.245e+00, 1.988e-04, 1.375e-04, 0.000e+00, 1.060e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-V_SCRs
        { 1.785e+04, 9.768e+02, 3.762e+04, 0.000e+00, 0.000e+00, 2.397e+03, 0.000e+00 }, // CO2(total)
        { 6.703e+01, 0.000e+00, 1.274e+02, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 5.786e-01, 2.240e-02, 9.750e-01, 0.000e+00, 0.000e+00, 4.218e-02, 0.000e+00 }, // HC
        { 5.736e+03, 3.139e+02, 1.209e+04, 0.000e+00, 0.000e+00, 7.703e+02, 0.000e+00 }, // FC
        { 2.214e+02, 1.098e+01, 3.748e+02, 0.000e+00, 0.000e+00, 2.899e+01, 0.000e+00 }, // NOx
        { 2.699e+00, 0.000e+00, 2.245e+00, 1.988e-04, 1.375e-04, 0.000e+00, 1.060e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-VI_A-C
        { 1.863e+04, 8.655e+02, 3.990e+04, 0.000e+00, 0.000e+00, 2.107e+03, 0.000e+00 }, // CO2(total)
        { 5.501e+00, 0.000e+00, 8.167e+00, 0.000e+00, 3.420e-05, 0.000e+00, 0.000e+00 }, // CO
        { 5.044e-01, 1.081e-02, 7.164e-01, 0.000e+00, 0.000e+00, 1.739e-02, 0.000e+00 }, // HC
        { 5.987e+03, 2.781e+02, 1.282e+04, 0.000e+00, 0.000e+00, 6.771e+02, 0.000e+00 }, // FC
        { 1.018e+01, 0.000e+00, 0.000e+00, 0.000e+00, 1.309e-04, 0.000e+00, 1.808e-02 }, // NOx
        { 1.583e+00, 0.000e+00, 4.702e-01, 0.000e+00, 1.377e-04, 0.000e+00, 1.225e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-VIs_A-C
        { 1.863e+04, 8.655e+02, 3.990e+04, 0.000e+00, 0.000e+00, 2.107e+03, 0.000e+00 }, // CO2(total)
        { 5.501e+00, 0.000e+00, 8.167e+00, 0.000e+00, 3.420e-05, 0.000e+00, 0.000e+00 }, // CO
        { 5.044e-01, 1.081e-02, 7.164e-01, 0.000e+00, 0.000e+00, 1.739e-02, 0.000e+00 }, // HC
        { 5.987e+03, 2.781e+02, 1.282e+04, 0.000e+00, 0.000e+00, 6.771e+02, 0.000e+00 }, // FC
        { 1.606e+02, 7.013e+00, 3.393e+02, 0.000e+00, 0.000e+00, 1.754e+01, 0.000e+00 }, // NOx
        { 1.583e+00, 0.000e+00, 4.702e-01, 0.000e+00, 1.377e-04, 0.000e+00, 1.225e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-VI_D-E
        { 1.670e+04, 1.049e+03, 3.533e+04, 0.000e+00, 0.000e+00, 2.585e+03, 0.000e+00 }, // CO2(total)
        { 1.093e+00, 0.000e+00, 1.918e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.939e-01, 1.524e-02, 1.889e-01, 0.000e+00, 0.000e+00, 4.831e-02, 0.000e+00 }, // HC
        { 5.366e+03, 3.371e+02, 1.135e+04, 0.000e+00, 0.000e+00, 8.308e+02, 0.000e+00 }, // FC
        { 4.936e+00, 0.000e+00, 1.286e+00, 0.000e+00, 1.474e-04, 0.000e+00, 6.856e-03 }, // NOx
        { 1.389e+00, 3.909e-03, 9.051e-02, 0.000e+00, 1.374e-04, 9.108e-03, 1.664e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt60t_Euro-VIs_D-E
        { 1.670e+04, 1.049e+03, 3.533e+04, 0.000e+00, 0.000e+00, 2.585e+03, 0.000e+00 }, // CO2(total)
        { 1.093e+00, 0.000e+00, 1.918e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 6.939e-01, 1.524e-02, 1.889e-01, 0.000e+00, 0.000e+00, 4.831e-02, 0.000e+00 }, // HC
        { 5.366e+03, 3.371e+02, 1.135e+04, 0.000e+00, 0.000e+00, 8.308e+02, 0.000e+00 }, // FC
        { 1.768e+02, 8.361e+00, 3.849e+02, 0.000e+00, 0.000e+00, 1.882e+01, 0.000e+00 }, // NOx
        { 1.389e+00, 3.909e-03, 9.051e-02, 0.000e+00, 1.374e-04, 9.108e-03, 1.664e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_50ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_60ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_70ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_80ties
        { 3.422e+03, 5.308e+02, 7.599e+03, 0.000e+00, 0.000e+00, 1.109e+03, 0.000e+00 }, // CO2(total)
        { 2.687e+01, 2.116e+00, 3.482e+01, 0.000e+00, 0.000e+00, 4.934e+00, 0.000e+00 }, // CO
        { 1.481e+01, 0.000e+00, 2.384e+00, 0.000e+00, 2.628e-04, 0.000e+00, 3.179e-02 }, // HC
        { 1.100e+03, 1.706e+02, 2.442e+03, 0.000e+00, 0.000e+00, 3.565e+02, 0.000e+00 }, // FC
        { 4.351e+01, 6.429e+00, 8.645e+01, 0.000e+00, 0.000e+00, 1.360e+01, 0.000e+00 }, // NOx
        { 5.934e+00, 2.925e-01, 5.034e+00, 0.000e+00, 1.323e-04, 6.946e-01, 1.417e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-I
        { 3.438e+03, 4.969e+02, 6.897e+03, 0.000e+00, 0.000e+00, 1.064e+03, 0.000e+00 }, // CO2(total)
        { 1.096e+01, 6.894e-01, 1.656e+01, 1.056e-04, 0.000e+00, 1.329e+00, 0.000e+00 }, // CO
        { 2.896e+00, 7.570e-02, 1.854e-01, 8.159e-04, 0.000e+00, 3.268e-01, 0.000e+00 }, // HC
        { 1.105e+03, 1.597e+02, 2.217e+03, 0.000e+00, 0.000e+00, 3.420e+02, 0.000e+00 }, // FC
        { 3.416e+01, 4.795e+00, 6.891e+01, 0.000e+00, 0.000e+00, 1.011e+01, 0.000e+00 }, // NOx
        { 3.198e+00, 1.183e-01, 7.290e-01, 0.000e+00, 1.342e-04, 3.006e-01, 1.344e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-II
        { 2.401e+03, 5.740e+02, 4.316e+03, 0.000e+00, 0.000e+00, 1.287e+03, 0.000e+00 }, // CO2(total)
        { 1.427e+01, 0.000e+00, 2.284e+01, 0.000e+00, 3.357e-04, 0.000e+00, 1.013e-02 }, // CO
        { 2.346e+00, 1.017e-02, 0.000e+00, 2.490e-03, 0.000e+00, 2.088e-01, 1.926e-03 }, // HC
        { 7.715e+02, 1.845e+02, 1.387e+03, 0.000e+00, 0.000e+00, 4.136e+02, 0.000e+00 }, // FC
        { 2.947e+01, 5.554e+00, 4.958e+01, 0.000e+00, 0.000e+00, 1.234e+01, 0.000e+00 }, // NOx
        { 2.546e+00, 3.407e-02, 1.756e+00, 1.013e-03, 1.318e-04, 1.443e-02, 3.901e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-III
        { 2.897e+03, 5.763e+02, 5.778e+03, 0.000e+00, 0.000e+00, 1.298e+03, 0.000e+00 }, // CO2(total)
        { 1.207e+01, 0.000e+00, 3.366e+00, 0.000e+00, 6.463e-04, 0.000e+00, 4.528e-02 }, // CO
        { 1.880e+00, 6.464e-02, 6.011e-01, 0.000e+00, 0.000e+00, 1.766e-01, 0.000e+00 }, // HC
        { 9.309e+02, 1.852e+02, 1.857e+03, 0.000e+00, 0.000e+00, 4.171e+02, 0.000e+00 }, // FC
        { 2.470e+01, 4.238e+00, 4.356e+01, 0.000e+00, 0.000e+00, 9.318e+00, 0.000e+00 }, // NOx
        { 2.412e+00, 5.233e-02, 2.086e-01, 0.000e+00, 1.287e-04, 1.296e-01, 1.953e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-IV_EGR
        { 1.894e+03, 6.432e+02, 3.940e+03, 0.000e+00, 0.000e+00, 1.477e+03, 0.000e+00 }, // CO2(total)
        { 4.449e+00, 4.459e-01, 3.725e+00, 0.000e+00, 1.726e-04, 1.256e+00, 0.000e+00 }, // CO
        { 2.861e-01, 1.458e-02, 5.044e-01, 5.993e-04, 0.000e+00, 1.961e-02, 1.733e-03 }, // HC
        { 6.087e+02, 2.067e+02, 1.266e+03, 0.000e+00, 0.000e+00, 4.746e+02, 0.000e+00 }, // FC
        { 2.457e+01, 2.872e+00, 4.652e+01, 0.000e+00, 1.121e-03, 5.463e+00, 7.608e-02 }, // NOx
        { 1.780e+00, 0.000e+00, 3.800e-01, 0.000e+00, 1.501e-04, 2.913e-03, 1.133e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-IV_SCR
        { 2.681e+03, 5.551e+02, 6.238e+03, 0.000e+00, 0.000e+00, 1.213e+03, 0.000e+00 }, // CO2(total)
        { 1.630e+01, 6.392e-01, 1.756e+01, 0.000e+00, 8.984e-04, 2.554e+00, 0.000e+00 }, // CO
        { 1.085e-01, 1.041e-02, 1.555e-01, 0.000e+00, 0.000e+00, 2.319e-02, 0.000e+00 }, // HC
        { 8.617e+02, 1.784e+02, 2.005e+03, 0.000e+00, 0.000e+00, 3.898e+02, 0.000e+00 }, // FC
        { 1.794e+01, 1.728e+00, 9.664e-01, 0.000e+00, 0.000e+00, 4.677e+00, 0.000e+00 }, // NOx
        { 1.727e+00, 1.239e-02, 3.746e-01, 0.000e+00, 1.379e-04, 3.378e-02, 3.835e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-IV_SCRs
        { 2.681e+03, 5.551e+02, 6.238e+03, 0.000e+00, 0.000e+00, 1.213e+03, 0.000e+00 }, // CO2(total)
        { 1.630e+01, 6.392e-01, 1.756e+01, 0.000e+00, 8.984e-04, 2.554e+00, 0.000e+00 }, // CO
        { 1.085e-01, 1.041e-02, 1.555e-01, 0.000e+00, 0.000e+00, 2.319e-02, 0.000e+00 }, // HC
        { 8.617e+02, 1.784e+02, 2.005e+03, 0.000e+00, 0.000e+00, 3.898e+02, 0.000e+00 }, // FC
        { 2.967e+01, 5.502e+00, 5.750e+01, 0.000e+00, 0.000e+00, 1.210e+01, 0.000e+00 }, // NOx
        { 1.727e+00, 1.239e-02, 3.746e-01, 0.000e+00, 1.379e-04, 3.378e-02, 3.835e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-V_EGR
        { 1.185e+03, 6.728e+02, 1.382e+03, 0.000e+00, 0.000e+00, 1.614e+03, 0.000e+00 }, // CO2(total)
        { 5.617e+00, 2.377e-01, 1.130e+01, 0.000e+00, 0.000e+00, 2.340e-01, 0.000e+00 }, // CO
        { 7.145e-01, 1.627e-02, 8.008e-01, 0.000e+00, 2.508e-05, 2.546e-02, 2.148e-03 }, // HC
        { 3.808e+02, 2.162e+02, 4.442e+02, 0.000e+00, 0.000e+00, 5.189e+02, 0.000e+00 }, // FC
        { 1.927e+01, 2.813e+00, 3.162e+01, 0.000e+00, 0.000e+00, 5.967e+00, 0.000e+00 }, // NOx
        { 1.646e+00, 1.006e-02, 3.275e-01, 0.000e+00, 1.370e-04, 2.045e-02, 9.598e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-V_SCR
        { 1.130e+03, 6.618e+02, 1.274e+03, 0.000e+00, 0.000e+00, 1.590e+03, 0.000e+00 }, // CO2(total)
        { 1.571e+01, 9.141e-01, 2.996e+01, 0.000e+00, 2.692e-04, 1.499e+00, 0.000e+00 }, // CO
        { 1.070e-01, 1.392e-02, 2.613e-02, 0.000e+00, 0.000e+00, 3.457e-02, 0.000e+00 }, // HC
        { 3.632e+02, 2.127e+02, 4.095e+02, 0.000e+00, 0.000e+00, 5.109e+02, 0.000e+00 }, // FC
        { 2.422e+01, 6.067e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.056e+00, 4.076e-02 }, // NOx
        { 1.810e+00, 1.475e-02, 6.721e-01, 0.000e+00, 1.311e-04, 1.760e-02, 5.030e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-V_SCRs
        { 1.130e+03, 6.618e+02, 1.274e+03, 0.000e+00, 0.000e+00, 1.590e+03, 0.000e+00 }, // CO2(total)
        { 1.571e+01, 9.141e-01, 2.996e+01, 0.000e+00, 2.692e-04, 1.499e+00, 0.000e+00 }, // CO
        { 1.070e-01, 1.392e-02, 2.613e-02, 0.000e+00, 0.000e+00, 3.457e-02, 0.000e+00 }, // HC
        { 3.632e+02, 2.127e+02, 4.095e+02, 0.000e+00, 0.000e+00, 5.109e+02, 0.000e+00 }, // FC
        { 2.553e+01, 6.517e+00, 2.100e+01, 0.000e+00, 0.000e+00, 1.520e+01, 0.000e+00 }, // NOx
        { 1.810e+00, 1.475e-02, 6.721e-01, 0.000e+00, 1.311e-04, 1.760e-02, 5.030e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-VI_A-C
        { 6.377e+02, 6.844e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.666e+03, 0.000e+00 }, // CO2(total)
        { 2.101e+00, 0.000e+00, 2.304e+00, 0.000e+00, 4.911e-05, 0.000e+00, 1.260e-03 }, // CO
        { 1.393e-01, 7.328e-03, 4.641e-02, 0.000e+00, 0.000e+00, 1.730e-02, 0.000e+00 }, // HC
        { 2.049e+02, 2.200e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.353e+02, 0.000e+00 }, // FC
        { 4.529e+00, 0.000e+00, 5.443e-02, 0.000e+00, 1.247e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.549e+00, 0.000e+00, 1.283e-01, 0.000e+00, 1.263e-04, 2.772e-03, 1.759e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-VIs_A-C
        { 4.116e+02, 5.903e+02, 9.977e+02, 0.000e+00, 0.000e+00, 1.317e+03, 0.000e+00 }, // CO2(total)
        { 1.811e+00, 2.101e-02, 2.506e+00, 0.000e+00, 0.000e+00, 3.713e-02, 0.000e+00 }, // CO
        { 9.688e-02, 4.705e-03, 8.203e-04, 1.676e-04, 0.000e+00, 1.275e-02, 4.223e-04 }, // HC
        { 1.323e+02, 1.897e+02, 3.207e+02, 0.000e+00, 0.000e+00, 4.232e+02, 0.000e+00 }, // FC
        { 7.645e+00, 3.872e+00, 2.215e+01, 0.000e+00, 0.000e+00, 8.339e+00, 0.000e+00 }, // NOx
        { 1.531e+00, 0.000e+00, 1.583e-01, 0.000e+00, 1.258e-04, 1.350e-03, 8.970e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-VI_D-E
        { 1.934e+02, 7.077e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.596e+03, 4.021e+00 }, // CO2(total)
        { 9.441e-01, 0.000e+00, 7.025e-01, 0.000e+00, 2.066e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.976e-01, 5.032e-03, 0.000e+00, 8.333e-05, 0.000e+00, 2.010e-02, 8.898e-07 }, // HC
        { 6.216e+01, 2.274e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.128e+02, 1.292e+00 }, // FC
        { 1.692e+00, 4.764e-02, 7.204e-02, 0.000e+00, 0.000e+00, 0.000e+00, 3.103e-03 }, // NOx
        { 1.441e+00, 1.880e-03, 0.000e+00, 0.000e+00, 1.260e-04, 5.440e-03, 7.919e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt14-20t_Euro-VIs_D-E
        { 1.884e+02, 5.980e+02, 3.397e+02, 0.000e+00, 0.000e+00, 1.345e+03, 0.000e+00 }, // CO2(total)
        { 8.133e-01, 0.000e+00, 1.002e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 2.375e-01, 0.000e+00, 1.084e-01, 0.000e+00, 6.980e-06, 0.000e+00, 3.397e-04 }, // HC
        { 6.054e+01, 1.922e+02, 1.092e+02, 0.000e+00, 0.000e+00, 4.321e+02, 0.000e+00 }, // FC
        { 1.956e+01, 4.053e+00, 6.143e+01, 0.000e+00, 0.000e+00, 7.462e+00, 0.000e+00 }, // NOx
        { 1.438e+00, 1.207e-03, 0.000e+00, 1.566e-05, 1.258e-04, 4.876e-03, 1.560e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_50ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_60ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_70ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_80ties
        { 0.000e+00, 5.855e+02, 0.000e+00, 2.572e+00, 0.000e+00, 1.267e+03, 2.356e-01 }, // CO2(total)
        { 1.565e+01, 1.285e+00, 0.000e+00, 7.331e-02, 0.000e+00, 4.061e+00, 1.056e-01 }, // CO
        { 1.569e+01, 0.000e+00, 4.644e+00, 0.000e+00, 7.508e-04, 0.000e+00, 8.152e-03 }, // HC
        { 0.000e+00, 1.882e+02, 0.000e+00, 8.266e-01, 0.000e+00, 4.073e+02, 7.572e-02 }, // FC
        { 1.103e+01, 6.156e+00, 0.000e+00, 5.903e-02, 0.000e+00, 1.488e+01, 4.508e-02 }, // NOx
        { 2.833e+00, 4.414e-01, 0.000e+00, 0.000e+00, 1.278e-04, 7.954e-01, 1.347e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-I
        { 0.000e+00, 5.834e+02, 0.000e+00, 1.727e+00, 0.000e+00, 1.258e+03, 0.000e+00 }, // CO2(total)
        { 1.017e+01, 1.246e-01, 1.151e+01, 1.563e-02, 0.000e+00, 0.000e+00, 3.686e-02 }, // CO
        { 3.479e+00, 0.000e+00, 1.163e+00, 0.000e+00, 2.869e-04, 1.309e-01, 8.355e-03 }, // HC
        { 0.000e+00, 1.875e+02, 0.000e+00, 5.550e-01, 0.000e+00, 4.041e+02, 0.000e+00 }, // FC
        { 3.625e+00, 5.508e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.184e+01, 0.000e+00 }, // NOx
        { 2.600e+00, 1.316e-01, 0.000e+00, 1.562e-03, 1.268e-04, 2.677e-01, 2.631e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-II
        { 1.016e+03, 3.980e+02, 0.000e+00, 6.894e+00, 0.000e+00, 1.112e+03, 4.459e+00 }, // CO2(total)
        { 1.036e+01, 2.724e-01, 1.828e+01, 0.000e+00, 0.000e+00, 3.306e-01, 0.000e+00 }, // CO
        { 2.383e+00, 0.000e+00, 6.374e-01, 0.000e+00, 1.790e-04, 0.000e+00, 8.020e-03 }, // HC
        { 3.266e+02, 1.279e+02, 0.000e+00, 2.215e+00, 0.000e+00, 3.574e+02, 1.433e+00 }, // FC
        { 1.044e+01, 5.247e+00, 8.778e+00, 0.000e+00, 0.000e+00, 1.127e+01, 0.000e+00 }, // NOx
        { 2.254e+00, 4.329e-02, 5.531e-01, 1.145e-03, 1.253e-04, 1.349e-01, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-III
        { 6.886e+02, 4.788e+02, 0.000e+00, 4.216e+00, 0.000e+00, 1.172e+03, 2.898e+00 }, // CO2(total)
        { 1.176e+01, 2.334e-01, 9.207e+00, 0.000e+00, 0.000e+00, 4.144e-01, 0.000e+00 }, // CO
        { 2.324e+00, 0.000e+00, 8.327e-01, 0.000e+00, 1.137e-04, 0.000e+00, 5.577e-03 }, // HC
        { 2.213e+02, 1.539e+02, 0.000e+00, 1.355e+00, 0.000e+00, 3.766e+02, 9.313e-01 }, // FC
        { 1.000e+01, 3.902e+00, 7.203e+00, 0.000e+00, 0.000e+00, 9.012e+00, 0.000e+00 }, // NOx
        { 2.724e+00, 0.000e+00, 3.934e-01, 0.000e+00, 1.922e-04, 1.169e-02, 3.273e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-IV_EGR
        { 0.000e+00, 5.244e+02, 0.000e+00, 3.309e+00, 0.000e+00, 1.219e+03, 1.676e+00 }, // CO2(total)
        { 6.722e+00, 1.467e-01, 1.429e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.374e-01, 2.592e-02, 7.390e-01, 0.000e+00, 0.000e+00, 4.166e-03, 0.000e+00 }, // HC
        { 0.000e+00, 1.685e+02, 0.000e+00, 1.063e+00, 0.000e+00, 3.919e+02, 5.386e-01 }, // FC
        { 2.809e+01, 1.909e+00, 6.047e+01, 0.000e+00, 0.000e+00, 4.202e+00, 0.000e+00 }, // NOx
        { 1.742e+00, 5.504e-03, 6.174e-01, 0.000e+00, 1.254e-04, 2.172e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-IV_SCR
        { 0.000e+00, 5.204e+02, 0.000e+00, 3.173e+00, 0.000e+00, 1.209e+03, 1.443e+00 }, // CO2(total)
        { 2.111e+01, 0.000e+00, 4.039e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.162e-02, 4.479e-03, 7.566e-02, 0.000e+00, 1.865e-05, 2.063e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.673e+02, 0.000e+00, 1.020e+00, 0.000e+00, 3.884e+02, 4.636e-01 }, // FC
        { 1.052e+01, 1.411e+00, 0.000e+00, 1.521e-02, 0.000e+00, 2.650e+00, 4.038e-02 }, // NOx
        { 1.805e+00, 2.760e-03, 7.167e-01, 0.000e+00, 1.289e-04, 2.319e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-IV_SCRs
        { 0.000e+00, 5.204e+02, 0.000e+00, 3.173e+00, 0.000e+00, 1.209e+03, 1.443e+00 }, // CO2(total)
        { 2.111e+01, 0.000e+00, 4.039e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 9.162e-02, 4.479e-03, 7.566e-02, 0.000e+00, 1.865e-05, 2.063e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.673e+02, 0.000e+00, 1.020e+00, 0.000e+00, 3.884e+02, 4.636e-01 }, // FC
        { 3.563e+00, 5.536e+00, 7.666e-01, 0.000e+00, 0.000e+00, 1.173e+01, 0.000e+00 }, // NOx
        { 1.805e+00, 2.760e-03, 7.167e-01, 0.000e+00, 1.289e-04, 2.319e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-V_EGR
        { 0.000e+00, 5.161e+02, 0.000e+00, 2.687e+00, 0.000e+00, 1.204e+03, 1.018e+00 }, // CO2(total)
        { 6.291e+00, 0.000e+00, 1.024e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 4.937e-01, 7.378e-03, 3.758e-01, 0.000e+00, 3.528e-05, 4.773e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.659e+02, 0.000e+00, 8.635e-01, 0.000e+00, 3.870e+02, 3.271e-01 }, // FC
        { 2.603e+01, 1.006e+00, 5.663e+01, 0.000e+00, 0.000e+00, 1.436e+00, 0.000e+00 }, // NOx
        { 1.554e+00, 0.000e+00, 9.193e-02, 0.000e+00, 1.762e-04, 2.802e-03, 2.004e-03 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-V_SCR
        { 0.000e+00, 5.072e+02, 0.000e+00, 2.535e+00, 0.000e+00, 1.183e+03, 7.498e-01 }, // CO2(total)
        { 1.941e+01, 0.000e+00, 3.546e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.249e-02, 7.048e-03, 3.485e-02, 0.000e+00, 1.173e-05, 2.281e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.630e+02, 0.000e+00, 8.148e-01, 0.000e+00, 3.802e+02, 2.410e-01 }, // FC
        { 1.518e+01, 2.835e-01, 0.000e+00, 1.586e-02, 0.000e+00, 0.000e+00, 7.208e-02 }, // NOx
        { 1.827e+00, 2.001e-03, 6.742e-01, 0.000e+00, 1.273e-04, 2.921e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-V_SCRs
        { 0.000e+00, 5.072e+02, 0.000e+00, 2.535e+00, 0.000e+00, 1.183e+03, 7.498e-01 }, // CO2(total)
        { 1.941e+01, 0.000e+00, 3.546e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 8.249e-02, 7.048e-03, 3.485e-02, 0.000e+00, 1.173e-05, 2.281e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.630e+02, 0.000e+00, 8.148e-01, 0.000e+00, 3.802e+02, 2.410e-01 }, // FC
        { 5.880e+00, 5.446e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.078e+01, 4.016e-02 }, // NOx
        { 1.827e+00, 2.001e-03, 6.742e-01, 0.000e+00, 1.273e-04, 2.921e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-VI_A-C
        { 0.000e+00, 5.000e+02, 0.000e+00, 2.803e+00, 0.000e+00, 1.166e+03, 2.644e+00 }, // CO2(total)
        { 1.383e+00, 2.558e-02, 2.189e+00, 0.000e+00, 1.106e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.982e-02, 1.174e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.097e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.607e+02, 0.000e+00, 9.009e-01, 0.000e+00, 3.747e+02, 8.497e-01 }, // FC
        { 2.327e+00, 2.144e-02, 0.000e+00, 5.407e-03, 0.000e+00, 0.000e+00, 5.745e-03 }, // NOx
        { 1.480e+00, 0.000e+00, 7.698e-02, 0.000e+00, 1.362e-04, 1.563e-03, 1.308e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-VIs_A-C
        { 0.000e+00, 5.000e+02, 0.000e+00, 2.803e+00, 0.000e+00, 1.166e+03, 2.644e+00 }, // CO2(total)
        { 1.383e+00, 2.558e-02, 2.189e+00, 0.000e+00, 1.106e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.982e-02, 1.174e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.097e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.607e+02, 0.000e+00, 9.009e-01, 0.000e+00, 3.747e+02, 8.497e-01 }, // FC
        { 5.888e-01, 3.272e+00, 0.000e+00, 1.961e-02, 0.000e+00, 7.277e+00, 3.013e-02 }, // NOx
        { 1.480e+00, 0.000e+00, 7.698e-02, 0.000e+00, 1.362e-04, 1.563e-03, 1.308e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-VI_D-E
        { 0.000e+00, 4.903e+02, 0.000e+00, 3.054e+00, 0.000e+00, 1.141e+03, 3.487e+00 }, // CO2(total)
        { 5.022e-01, 0.000e+00, 6.107e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.979e-01, 0.000e+00, 7.798e-02, 0.000e+00, 1.131e-05, 4.849e-03, 0.000e+00 }, // HC
        { 0.000e+00, 1.576e+02, 0.000e+00, 9.816e-01, 0.000e+00, 3.665e+02, 1.121e+00 }, // FC
        { 7.158e-01, 4.177e-02, 1.748e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.445e+00, 0.000e+00, 0.000e+00, 5.679e-05, 1.267e-04, 4.605e-03, 9.898e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_gt7_5-14t_Euro-VIs_D-E
        { 0.000e+00, 4.903e+02, 0.000e+00, 3.054e+00, 0.000e+00, 1.141e+03, 3.487e+00 }, // CO2(total)
        { 5.022e-01, 0.000e+00, 6.107e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.979e-01, 0.000e+00, 7.798e-02, 0.000e+00, 1.131e-05, 4.849e-03, 0.000e+00 }, // HC
        { 0.000e+00, 1.576e+02, 0.000e+00, 9.816e-01, 0.000e+00, 3.665e+02, 1.121e+00 }, // FC
        { 1.513e+01, 3.057e+00, 4.129e+01, 0.000e+00, 2.357e-04, 4.854e+00, 2.970e-02 }, // NOx
        { 1.445e+00, 0.000e+00, 0.000e+00, 5.679e-05, 1.267e-04, 4.605e-03, 9.898e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_le7_5t_Euro-IV
        { 2.172e+03, 0.000e+00, 0.000e+00, 1.830e+01, 2.494e-02, 5.966e+02, 1.413e+01 }, // CO2(total)
        { 2.707e+00, 4.080e-01, 4.701e+00, 0.000e+00, 0.000e+00, 4.767e-01, 0.000e+00 }, // CO
        { 2.108e+00, 7.983e-02, 2.908e+00, 0.000e+00, 3.418e-04, 0.000e+00, 1.666e-02 }, // HC
        { 6.989e+02, 0.000e+00, 0.000e+00, 5.889e+00, 8.024e-03, 1.920e+02, 4.545e+00 }, // FC
        { 1.532e+00, 3.575e+00, 0.000e+00, 2.516e-02, 0.000e+00, 6.741e+00, 1.464e-02 }, // NOx
        { 1.439e+00, 1.519e-03, 2.808e-02, 0.000e+00, 1.265e-04, 5.278e-04, 1.632e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_le7_5t_Euro-V
        { 2.117e+03, 0.000e+00, 0.000e+00, 1.800e+01, 9.596e-03, 5.824e+02, 1.409e+01 }, // CO2(total)
        { 1.572e+00, 0.000e+00, 0.000e+00, 1.338e-02, 7.129e-06, 4.326e-01, 1.047e-02 }, // CO
        { 7.419e-01, 0.000e+00, 0.000e+00, 6.311e-03, 3.364e-06, 2.041e-01, 4.938e-03 }, // HC
        { 6.811e+02, 0.000e+00, 0.000e+00, 5.794e+00, 3.088e-03, 1.874e+02, 4.533e+00 }, // FC
        { 2.859e+00, 0.000e+00, 0.000e+00, 2.432e-02, 1.296e-05, 7.868e-01, 1.903e-02 }, // NOx
        { 1.440e+00, 0.000e+00, 0.000e+00, 1.044e-04, 1.270e-04, 3.376e-03, 2.246e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_le7_5t_Euro-VI
        { 2.109e+03, 0.000e+00, 0.000e+00, 1.766e+01, 6.975e-03, 6.004e+02, 1.310e+01 }, // CO2(total)
        { 1.366e+00, 0.000e+00, 0.000e+00, 1.144e-02, 4.518e-06, 3.889e-01, 8.487e-03 }, // CO
        { 3.619e-01, 0.000e+00, 0.000e+00, 3.031e-03, 1.197e-06, 1.030e-01, 2.249e-03 }, // HC
        { 6.786e+02, 0.000e+00, 0.000e+00, 5.684e+00, 2.244e-03, 1.932e+02, 4.217e+00 }, // FC
        { 9.067e-01, 0.000e+00, 0.000e+00, 7.594e-03, 2.999e-06, 2.581e-01, 5.634e-03 }, // NOx
        { 1.438e+00, 0.000e+00, 0.000e+00, 1.024e-04, 1.268e-04, 3.480e-03, 2.030e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_gt7_5-12t_Euro-IV
        { 0.000e+00, 5.555e+02, 0.000e+00, 3.505e+00, 0.000e+00, 1.292e+03, 1.775e+00 }, // CO2(total)
        { 8.067e+00, 1.760e-01, 1.715e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.649e+00, 3.110e-01, 8.868e+00, 0.000e+00, 0.000e+00, 4.999e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.787e+02, 0.000e+00, 1.128e+00, 0.000e+00, 4.156e+02, 5.712e-01 }, // FC
        { 3.652e+01, 2.482e+00, 7.861e+01, 0.000e+00, 0.000e+00, 5.463e+00, 0.000e+00 }, // NOx
        { 1.466e+00, 5.506e-04, 6.176e-02, 0.000e+00, 1.254e-04, 2.172e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_gt7_5-12t_Euro-V
        { 0.000e+00, 5.526e+02, 0.000e+00, 2.762e+00, 0.000e+00, 1.289e+03, 8.169e-01 }, // CO2(total)
        { 0.000e+00, 4.105e-01, 0.000e+00, 2.052e-03, 0.000e+00, 9.576e-01, 6.069e-04 }, // CO
        { 0.000e+00, 1.937e-01, 0.000e+00, 9.682e-04, 0.000e+00, 4.518e-01, 2.863e-04 }, // HC
        { 0.000e+00, 1.778e+02, 0.000e+00, 8.888e-01, 0.000e+00, 4.148e+02, 2.629e-01 }, // FC
        { 0.000e+00, 7.465e-01, 0.000e+00, 3.732e-03, 0.000e+00, 1.741e+00, 1.104e-03 }, // NOx
        { 1.438e+00, 3.203e-03, 0.000e+00, 1.601e-05, 1.255e-04, 1.039e-02, 4.735e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_gt7_5-12t_Euro-VI
        { 0.000e+00, 5.447e+02, 0.000e+00, 3.054e+00, 0.000e+00, 1.270e+03, 2.880e+00 }, // CO2(total)
        { 0.000e+00, 3.528e-01, 0.000e+00, 1.978e-03, 0.000e+00, 8.227e-01, 1.865e-03 }, // CO
        { 0.000e+00, 9.348e-02, 0.000e+00, 5.241e-04, 0.000e+00, 2.180e-01, 4.943e-04 }, // HC
        { 0.000e+00, 1.753e+02, 0.000e+00, 9.827e-01, 0.000e+00, 4.088e+02, 9.268e-01 }, // FC
        { 0.000e+00, 2.342e-01, 0.000e+00, 1.313e-03, 0.000e+00, 5.461e-01, 1.238e-03 }, // NOx
        { 1.431e+00, 3.157e-03, 0.000e+00, 1.770e-05, 1.267e-04, 8.926e-03, 1.160e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_gt12t_Euro-IV
        { 2.006e+03, 6.813e+02, 4.173e+03, 0.000e+00, 0.000e+00, 1.564e+03, 0.000e+00 }, // CO2(total)
        { 5.339e+00, 5.351e-01, 4.470e+00, 0.000e+00, 2.071e-04, 1.507e+00, 0.000e+00 }, // CO
        { 3.433e+00, 1.750e-01, 6.052e+00, 7.192e-03, 0.000e+00, 2.353e-01, 2.080e-02 }, // HC
        { 6.456e+02, 2.192e+02, 1.343e+03, 0.000e+00, 0.000e+00, 5.033e+02, 0.000e+00 }, // FC
        { 3.194e+01, 3.734e+00, 6.048e+01, 0.000e+00, 1.457e-03, 7.102e+00, 9.891e-02 }, // NOx
        { 1.468e+00, 0.000e+00, 3.802e-02, 0.000e+00, 1.292e-04, 2.913e-03, 1.514e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_gt12t_Euro-V
        { 1.231e+03, 7.210e+02, 1.388e+03, 0.000e+00, 0.000e+00, 1.732e+03, 0.000e+00 }, // CO2(total)
        { 9.146e-01, 5.356e-01, 1.031e+00, 0.000e+00, 0.000e+00, 1.287e+00, 0.000e+00 }, // CO
        { 4.315e-01, 2.527e-01, 4.866e-01, 0.000e+00, 0.000e+00, 6.070e-01, 0.000e+00 }, // HC
        { 3.961e+02, 2.320e+02, 4.467e+02, 0.000e+00, 0.000e+00, 5.573e+02, 0.000e+00 }, // FC
        { 1.663e+00, 9.740e-01, 1.875e+00, 0.000e+00, 0.000e+00, 2.340e+00, 0.000e+00 }, // NOx
        { 1.446e+00, 4.179e-03, 1.489e-02, 0.000e+00, 1.254e-04, 1.251e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_CNG_gt12t_Euro-VI
        { 6.947e+02, 7.457e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.815e+03, 0.000e+00 }, // CO2(total)
        { 4.499e-01, 4.829e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.175e+00, 0.000e+00 }, // CO
        { 1.192e-01, 1.280e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.114e-01, 0.000e+00 }, // HC
        { 2.235e+02, 2.399e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.839e+02, 0.000e+00 }, // FC
        { 2.987e-01, 3.206e-01, 0.000e+00, 0.000e+00, 0.000e+00, 7.802e-01, 0.000e+00 }, // NOx
        { 1.437e+00, 4.322e-03, 0.000e+00, 0.000e+00, 1.262e-04, 1.329e-02, 1.759e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_CNG_Euro-IV
        { 8.416e+03, 7.982e+02, 1.979e+04, 0.000e+00, 0.000e+00, 1.944e+03, 0.000e+00 }, // CO2(total)
        { 6.253e+00, 5.930e-01, 1.470e+01, 0.000e+00, 0.000e+00, 1.444e+00, 0.000e+00 }, // CO
        { 2.950e+00, 2.798e-01, 6.938e+00, 0.000e+00, 0.000e+00, 6.815e-01, 0.000e+00 }, // HC
        { 2.708e+03, 2.568e+02, 6.369e+03, 0.000e+00, 0.000e+00, 6.257e+02, 0.000e+00 }, // FC
        { 1.137e+01, 1.078e+00, 2.674e+01, 0.000e+00, 0.000e+00, 2.627e+00, 0.000e+00 }, // NOx
        { 1.490e+00, 4.627e-03, 1.147e-01, 0.000e+00, 1.250e-04, 1.372e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_CNG_Euro-V
        { 8.416e+03, 7.982e+02, 1.979e+04, 0.000e+00, 0.000e+00, 1.944e+03, 0.000e+00 }, // CO2(total)
        { 6.253e+00, 5.930e-01, 1.470e+01, 0.000e+00, 0.000e+00, 1.444e+00, 0.000e+00 }, // CO
        { 2.950e+00, 2.798e-01, 6.938e+00, 0.000e+00, 0.000e+00, 6.815e-01, 0.000e+00 }, // HC
        { 2.708e+03, 2.568e+02, 6.369e+03, 0.000e+00, 0.000e+00, 6.257e+02, 0.000e+00 }, // FC
        { 1.137e+01, 1.078e+00, 2.674e+01, 0.000e+00, 0.000e+00, 2.627e+00, 0.000e+00 }, // NOx
        { 1.490e+00, 4.627e-03, 1.147e-01, 0.000e+00, 1.250e-04, 1.372e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_CNG_Euro-VI
        { 8.426e+03, 7.838e+02, 1.997e+04, 0.000e+00, 0.000e+00, 1.908e+03, 0.000e+00 }, // CO2(total)
        { 5.457e+00, 5.076e-01, 1.293e+01, 0.000e+00, 0.000e+00, 1.236e+00, 0.000e+00 }, // CO
        { 1.446e+00, 1.345e-01, 3.427e+00, 0.000e+00, 0.000e+00, 3.274e-01, 0.000e+00 }, // HC
        { 2.711e+03, 2.522e+02, 6.426e+03, 0.000e+00, 0.000e+00, 6.138e+02, 0.000e+00 }, // FC
        { 3.623e+00, 3.370e-01, 8.586e+00, 0.000e+00, 0.000e+00, 8.202e-01, 0.000e+00 }, // NOx
        { 1.491e+00, 4.543e-03, 1.158e-01, 0.000e+00, 1.249e-04, 1.348e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_le7_5t_Euro-IV
        { 2.172e+03, 0.000e+00, 0.000e+00, 1.830e+01, 2.494e-02, 5.966e+02, 1.413e+01 }, // CO2(total)
        { 2.707e+00, 4.080e-01, 4.701e+00, 0.000e+00, 0.000e+00, 4.767e-01, 0.000e+00 }, // CO
        { 2.108e+00, 7.983e-02, 2.908e+00, 0.000e+00, 3.418e-04, 0.000e+00, 1.666e-02 }, // HC
        { 6.989e+02, 0.000e+00, 0.000e+00, 5.889e+00, 8.024e-03, 1.920e+02, 4.545e+00 }, // FC
        { 1.532e+00, 3.575e+00, 0.000e+00, 2.516e-02, 0.000e+00, 6.741e+00, 1.464e-02 }, // NOx
        { 1.439e+00, 1.519e-03, 2.808e-02, 0.000e+00, 1.265e-04, 5.278e-04, 1.632e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_le7_5t_Euro-V
        { 2.117e+03, 0.000e+00, 0.000e+00, 1.800e+01, 9.596e-03, 5.824e+02, 1.409e+01 }, // CO2(total)
        { 1.572e+00, 0.000e+00, 0.000e+00, 1.338e-02, 7.129e-06, 4.326e-01, 1.047e-02 }, // CO
        { 7.419e-01, 0.000e+00, 0.000e+00, 6.311e-03, 3.364e-06, 2.041e-01, 4.938e-03 }, // HC
        { 6.811e+02, 0.000e+00, 0.000e+00, 5.794e+00, 3.088e-03, 1.874e+02, 4.533e+00 }, // FC
        { 2.859e+00, 0.000e+00, 0.000e+00, 2.432e-02, 1.296e-05, 7.868e-01, 1.903e-02 }, // NOx
        { 1.440e+00, 0.000e+00, 0.000e+00, 1.044e-04, 1.270e-04, 3.376e-03, 2.246e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_le7_5t_Euro-VI
        { 2.109e+03, 0.000e+00, 0.000e+00, 1.766e+01, 6.975e-03, 6.004e+02, 1.310e+01 }, // CO2(total)
        { 1.366e+00, 0.000e+00, 0.000e+00, 1.144e-02, 4.518e-06, 3.889e-01, 8.487e-03 }, // CO
        { 3.619e-01, 0.000e+00, 0.000e+00, 3.031e-03, 1.197e-06, 1.030e-01, 2.249e-03 }, // HC
        { 6.786e+02, 0.000e+00, 0.000e+00, 5.684e+00, 2.244e-03, 1.932e+02, 4.217e+00 }, // FC
        { 9.067e-01, 0.000e+00, 0.000e+00, 7.594e-03, 2.999e-06, 2.581e-01, 5.634e-03 }, // NOx
        { 1.438e+00, 0.000e+00, 0.000e+00, 1.024e-04, 1.268e-04, 3.480e-03, 2.030e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_gt7_5-12t_Euro-IV
        { 0.000e+00, 5.555e+02, 0.000e+00, 3.505e+00, 0.000e+00, 1.292e+03, 1.775e+00 }, // CO2(total)
        { 8.067e+00, 1.760e-01, 1.715e+01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 1.649e+00, 3.110e-01, 8.868e+00, 0.000e+00, 0.000e+00, 4.999e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.787e+02, 0.000e+00, 1.128e+00, 0.000e+00, 4.156e+02, 5.712e-01 }, // FC
        { 3.652e+01, 2.482e+00, 7.861e+01, 0.000e+00, 0.000e+00, 5.463e+00, 0.000e+00 }, // NOx
        { 1.466e+00, 5.506e-04, 6.176e-02, 0.000e+00, 1.254e-04, 2.172e-03, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_gt7_5-12t_Euro-V
        { 0.000e+00, 5.526e+02, 0.000e+00, 2.762e+00, 0.000e+00, 1.289e+03, 8.169e-01 }, // CO2(total)
        { 0.000e+00, 4.105e-01, 0.000e+00, 2.052e-03, 0.000e+00, 9.576e-01, 6.069e-04 }, // CO
        { 0.000e+00, 1.937e-01, 0.000e+00, 9.682e-04, 0.000e+00, 4.518e-01, 2.863e-04 }, // HC
        { 0.000e+00, 1.778e+02, 0.000e+00, 8.888e-01, 0.000e+00, 4.148e+02, 2.629e-01 }, // FC
        { 0.000e+00, 7.465e-01, 0.000e+00, 3.732e-03, 0.000e+00, 1.741e+00, 1.104e-03 }, // NOx
        { 1.438e+00, 3.203e-03, 0.000e+00, 1.601e-05, 1.255e-04, 1.039e-02, 4.735e-06 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_gt7_5-12t_Euro-VI
        { 0.000e+00, 5.447e+02, 0.000e+00, 3.054e+00, 0.000e+00, 1.270e+03, 2.880e+00 }, // CO2(total)
        { 0.000e+00, 3.528e-01, 0.000e+00, 1.978e-03, 0.000e+00, 8.227e-01, 1.865e-03 }, // CO
        { 0.000e+00, 9.348e-02, 0.000e+00, 5.241e-04, 0.000e+00, 2.180e-01, 4.943e-04 }, // HC
        { 0.000e+00, 1.753e+02, 0.000e+00, 9.827e-01, 0.000e+00, 4.088e+02, 9.268e-01 }, // FC
        { 0.000e+00, 2.342e-01, 0.000e+00, 1.313e-03, 0.000e+00, 5.461e-01, 1.238e-03 }, // NOx
        { 1.431e+00, 3.157e-03, 0.000e+00, 1.770e-05, 1.267e-04, 8.926e-03, 1.160e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_gt12t_Euro-IV
        { 2.006e+03, 6.813e+02, 4.173e+03, 0.000e+00, 0.000e+00, 1.564e+03, 0.000e+00 }, // CO2(total)
        { 5.339e+00, 5.351e-01, 4.470e+00, 0.000e+00, 2.071e-04, 1.507e+00, 0.000e+00 }, // CO
        { 3.433e+00, 1.750e-01, 6.052e+00, 7.192e-03, 0.000e+00, 2.353e-01, 2.080e-02 }, // HC
        { 6.456e+02, 2.192e+02, 1.343e+03, 0.000e+00, 0.000e+00, 5.033e+02, 0.000e+00 }, // FC
        { 3.194e+01, 3.734e+00, 6.048e+01, 0.000e+00, 1.457e-03, 7.102e+00, 9.891e-02 }, // NOx
        { 1.468e+00, 0.000e+00, 3.802e-02, 0.000e+00, 1.292e-04, 2.913e-03, 1.514e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_gt12t_Euro-V
        { 1.231e+03, 7.210e+02, 1.388e+03, 0.000e+00, 0.000e+00, 1.732e+03, 0.000e+00 }, // CO2(total)
        { 9.146e-01, 5.356e-01, 1.031e+00, 0.000e+00, 0.000e+00, 1.287e+00, 0.000e+00 }, // CO
        { 4.315e-01, 2.527e-01, 4.866e-01, 0.000e+00, 0.000e+00, 6.070e-01, 0.000e+00 }, // HC
        { 3.961e+02, 2.320e+02, 4.467e+02, 0.000e+00, 0.000e+00, 5.573e+02, 0.000e+00 }, // FC
        { 1.663e+00, 9.740e-01, 1.875e+00, 0.000e+00, 0.000e+00, 2.340e+00, 0.000e+00 }, // NOx
        { 1.446e+00, 4.179e-03, 1.489e-02, 0.000e+00, 1.254e-04, 1.251e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // HGV_LNG_gt12t_Euro-VI
        { 6.947e+02, 7.457e+02, 0.000e+00, 0.000e+00, 0.000e+00, 1.815e+03, 0.000e+00 }, // CO2(total)
        { 4.499e-01, 4.829e-01, 0.000e+00, 0.000e+00, 0.000e+00, 1.175e+00, 0.000e+00 }, // CO
        { 1.192e-01, 1.280e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.114e-01, 0.000e+00 }, // HC
        { 2.235e+02, 2.399e+02, 0.000e+00, 0.000e+00, 0.000e+00, 5.839e+02, 0.000e+00 }, // FC
        { 2.987e-01, 3.206e-01, 0.000e+00, 0.000e+00, 0.000e+00, 7.802e-01, 0.000e+00 }, // NOx
        { 1.437e+00, 4.322e-03, 0.000e+00, 0.000e+00, 1.262e-04, 1.329e-02, 1.759e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_LNG_Euro-IV
        { 8.416e+03, 7.982e+02, 1.979e+04, 0.000e+00, 0.000e+00, 1.944e+03, 0.000e+00 }, // CO2(total)
        { 6.253e+00, 5.930e-01, 1.470e+01, 0.000e+00, 0.000e+00, 1.444e+00, 0.000e+00 }, // CO
        { 2.950e+00, 2.798e-01, 6.938e+00, 0.000e+00, 0.000e+00, 6.815e-01, 0.000e+00 }, // HC
        { 2.708e+03, 2.568e+02, 6.369e+03, 0.000e+00, 0.000e+00, 6.257e+02, 0.000e+00 }, // FC
        { 1.137e+01, 1.078e+00, 2.674e+01, 0.000e+00, 0.000e+00, 2.627e+00, 0.000e+00 }, // NOx
        { 1.490e+00, 4.627e-03, 1.147e-01, 0.000e+00, 1.250e-04, 1.372e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_LNG_Euro-V
        { 8.416e+03, 7.982e+02, 1.979e+04, 0.000e+00, 0.000e+00, 1.944e+03, 0.000e+00 }, // CO2(total)
        { 6.253e+00, 5.930e-01, 1.470e+01, 0.000e+00, 0.000e+00, 1.444e+00, 0.000e+00 }, // CO
        { 2.950e+00, 2.798e-01, 6.938e+00, 0.000e+00, 0.000e+00, 6.815e-01, 0.000e+00 }, // HC
        { 2.708e+03, 2.568e+02, 6.369e+03, 0.000e+00, 0.000e+00, 6.257e+02, 0.000e+00 }, // FC
        { 1.137e+01, 1.078e+00, 2.674e+01, 0.000e+00, 0.000e+00, 2.627e+00, 0.000e+00 }, // NOx
        { 1.490e+00, 4.627e-03, 1.147e-01, 0.000e+00, 1.250e-04, 1.372e-02, 0.000e+00 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_LNG_Euro-VI_(CI)
        { 7.082e+03, 6.588e+02, 1.679e+04, 0.000e+00, 0.000e+00, 1.603e+03, 0.000e+00 }, // CO2(total)
        { 2.762e+00, 5.547e-02, 3.229e+00, 0.000e+00, 0.000e+00, 1.469e-01, 0.000e+00 }, // CO
        { 3.894e+00, 3.744e-01, 9.575e+00, 0.000e+00, 0.000e+00, 8.888e-01, 0.000e+00 }, // HC
        { 2.279e+03, 2.120e+02, 5.401e+03, 0.000e+00, 0.000e+00, 5.159e+02, 0.000e+00 }, // FC
        { 6.535e+00, 0.000e+00, 1.371e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.652e-03 }, // NOx
        { 1.599e+00, 0.000e+00, 1.509e-01, 0.000e+00, 1.251e-04, 2.421e-03, 2.235e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_BEV
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.277e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.407e-04, 0.000e+00, 7.340e-05 }, // PM + PM (non-exhaust)
        { 2.148e+00, 1.517e+00, 3.458e+00, 0.000e+00, 0.000e+00, 7.210e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_BEV_le7.5t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.420e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.272e-04, 0.000e+00, 1.316e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 4.011e-01, 0.000e+00, 1.554e-03, 6.693e-04, 1.552e+00, 3.263e-03 }, // FC_MJ
    },
    {
        // RigidTruck_BEV_gt7.5-12t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.431e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.282e-04, 1.646e-03, 1.758e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 5.451e-01, 0.000e+00, 1.477e-02, 0.000e+00, 2.678e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_BEV_gt12t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.385e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.304e-04, 0.000e+00, 9.027e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 9.041e-01, 4.224e-02, 3.050e-03, 0.000e+00, 3.855e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_PHEV_le7_5t_Euro-VI-(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.420e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.272e-04, 0.000e+00, 1.316e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 4.011e-01, 0.000e+00, 1.554e-03, 6.693e-04, 1.552e+00, 3.263e-03 }, // FC_MJ
    },
    {
        // RigidTruck_PHEV_le7_5t_Euro-VI-(D)
        { 1.372e+03, 2.284e+01, 7.058e+02, 1.592e+01, 0.000e+00, 5.428e+02, 1.501e+01 }, // CO2(total)
        { 1.053e+00, 3.609e-03, 1.179e+00, 8.138e-04, 0.000e+00, 0.000e+00, 3.190e-04 }, // CO
        { 8.609e-02, 0.000e+00, 1.124e-02, 1.815e-04, 8.715e-07, 4.578e-03, 2.644e-04 }, // HC
        { 4.410e+02, 7.339e+00, 2.268e+02, 5.115e+00, 0.000e+00, 1.745e+02, 4.822e+00 }, // FC
        { 1.158e-01, 2.321e-01, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.005e-02 }, // NOx
        { 1.483e+00, 0.000e+00, 4.753e-02, 0.000e+00, 1.279e-04, 0.000e+00, 1.270e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_PHEV_gt7_5-12t_Euro-VI-(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.431e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.282e-04, 1.646e-03, 1.758e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 5.451e-01, 0.000e+00, 1.477e-02, 0.000e+00, 2.678e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_PHEV_gt7_5-12t_Euro-VI-(D)
        { 0.000e+00, 4.426e+02, 0.000e+00, 5.675e+00, 0.000e+00, 1.288e+03, 3.471e-01 }, // CO2(total)
        { 1.383e+00, 2.558e-02, 2.189e+00, 0.000e+00, 1.106e-05, 0.000e+00, 0.000e+00 }, // CO
        { 2.982e-02, 1.174e-02, 0.000e+00, 0.000e+00, 0.000e+00, 2.097e-02, 0.000e+00 }, // HC
        { 0.000e+00, 1.422e+02, 0.000e+00, 1.824e+00, 0.000e+00, 4.139e+02, 1.115e-01 }, // FC
        { 2.327e+00, 2.144e-02, 0.000e+00, 5.407e-03, 0.000e+00, 0.000e+00, 5.745e-03 }, // NOx
        { 1.480e+00, 0.000e+00, 7.698e-02, 0.000e+00, 1.362e-04, 1.563e-03, 1.308e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_PHEV_gt12t_Euro-VI-(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.385e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.304e-04, 0.000e+00, 9.027e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 9.041e-01, 4.224e-02, 3.050e-03, 0.000e+00, 3.855e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_PHEV_gt12t_Euro-VI-(D)
        { 3.127e+02, 6.979e+02, 3.658e+03, 0.000e+00, 0.000e+00, 1.516e+03, 0.000e+00 }, // CO2(total)
        { 1.970e+00, 0.000e+00, 1.758e+00, 0.000e+00, 6.669e-05, 0.000e+00, 2.808e-03 }, // CO
        { 1.453e-01, 6.710e-03, 6.744e-02, 0.000e+00, 0.000e+00, 1.511e-02, 0.000e+00 }, // HC
        { 1.005e+02, 2.243e+02, 1.176e+03, 0.000e+00, 0.000e+00, 4.871e+02, 0.000e+00 }, // FC
        { 4.309e+00, 0.000e+00, 3.291e-02, 0.000e+00, 1.527e-04, 0.000e+00, 0.000e+00 }, // NOx
        { 1.547e+00, 0.000e+00, 1.211e-01, 0.000e+00, 1.266e-04, 1.972e-03, 5.441e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_PHEV_Euro-VI-(El)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.277e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.407e-04, 0.000e+00, 7.340e-05 }, // PM + PM (non-exhaust)
        { 2.148e+00, 1.517e+00, 3.458e+00, 0.000e+00, 0.000e+00, 7.210e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_PHEV_Euro-VI-(D)
        { 6.259e+03, 8.178e+02, 2.107e+04, 0.000e+00, 0.000e+00, 1.737e+03, 0.000e+00 }, // CO2(total)
        { 2.762e+00, 5.547e-02, 3.229e+00, 0.000e+00, 0.000e+00, 1.469e-01, 0.000e+00 }, // CO
        { 3.050e-01, 9.227e-03, 4.805e-01, 0.000e+00, 0.000e+00, 2.104e-02, 0.000e+00 }, // HC
        { 2.012e+03, 2.628e+02, 6.770e+03, 0.000e+00, 0.000e+00, 5.581e+02, 0.000e+00 }, // FC
        { 6.535e+00, 0.000e+00, 1.363e-01, 0.000e+00, 0.000e+00, 0.000e+00, 3.652e-03 }, // NOx
        { 1.599e+00, 0.000e+00, 1.509e-01, 0.000e+00, 1.251e-04, 2.421e-03, 2.235e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_FCEV_le7_5t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 2.221e+01, 0.000e+00, 8.607e-02, 3.707e-02, 8.594e+01, 1.807e-01 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.420e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.272e-04, 0.000e+00, 1.316e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_FCEV_gt7_5-12t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 3.019e+01, 0.000e+00, 8.179e-01, 0.000e+00, 1.483e+02, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.431e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.282e-04, 1.646e-03, 1.758e-04 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // RigidTruck_FCEV_gt12t
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 0.000e+00, 5.007e+01, 2.339e+00, 1.689e-01, 0.000e+00, 2.135e+02, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.385e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.304e-04, 0.000e+00, 9.027e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
    {
        // TT_AT_FCEV
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO2(total)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // CO
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // HC
        { 1.190e+02, 8.403e+01, 1.915e+02, 0.000e+00, 0.000e+00, 3.993e+02, 0.000e+00 }, // FC
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // NOx
        { 1.277e+00, 0.000e+00, 0.000e+00, 0.000e+00, 1.407e-04, 0.000e+00, 7.340e-05 }, // PM + PM (non-exhaust)
        { 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00 }, // FC_MJ
    },
};


// ===========================================================================
// method definitions
// ===========================================================================
HelpersHBEFA4::HelpersHBEFA4() : PollutantsInterface::Helper("HBEFA4", HBEFA4_BASE, -1) {
    int index = HBEFA4_BASE;
    myEmissionClassStrings.insert("PC_petrol_ltECE", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_ECE-15_00", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_ECE-15_01_02", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_ECE-15_03", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_ECE-15_04", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_AGV82_(CH)", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_conv_other_concepts", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Ucat", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_PreEuro_3WCat_lt1987", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_PreEuro_3WCat_1987-90", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("PC_petrol_Euro-7", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_conv", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_1986-1988", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-2_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-3_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-4_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-5_other_SU_before_software_update", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-5_EA189_before_software_update", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-5_EA189_after_software_update", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-5_other_SU_after_software_update", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-6ab_SU_before_software_update", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-6ab_SU_after_software_update", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("PC_diesel_Euro-7", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-2_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-2_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-3_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-3_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-4_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-4_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-5_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-6_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("PC_CNG_petrol_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-3__(E85)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-3__(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-4__(E85)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-4__(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-5__(E85)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-5__(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-6__(E85)", index);
    index++;
    myEmissionClassStrings.insert("PC_FFV_Euro-6__(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_BEV", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-4_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-4_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-6d_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-6d_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-6ab_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_petrol_Euro-6ab_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-4_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-4_(D)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-5_(D)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-6d_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-6d_(D)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-6ab_(El)", index);
    index++;
    myEmissionClassStrings.insert("PC_PHEV_diesel_Euro-6ab_(D)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-2_(LPG)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-2_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-3_(LPG)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-3_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-4_(LPG)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-4_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-5_(LPG)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-6_(LPG)", index);
    index++;
    myEmissionClassStrings.insert("PC_LPG_petrol_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("PC_FuelCell", index);
    index++;
    myEmissionClassStrings.insert("PC_2S_EE", index);
    index++;
    myEmissionClassStrings.insert("PC_4S_EE", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Conv_lt1981", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Conv_gt1981", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_3WCat_1987-1990", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_M+N1-I_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Conv_lt1981", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Conv_gt1981", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_3WCat_1987-1990", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-II_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Conv_lt1981", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Conv_gt1981", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_3WCat_1987-1990", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("LCV_petrol_N1-III_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_convlt_1986", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_XXIII", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-3_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-4_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_M+N1-I_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_convlt_1986", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_XXIII", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-3_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-4_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-II_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_convlt_1986", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_XXIII", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-3_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-4_(DPF)", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-6ab", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-6c", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-6d-temp", index);
    index++;
    myEmissionClassStrings.insert("LCV_diesel_N1-III_Euro-6d", index);
    index++;
    myEmissionClassStrings.insert("LCV_2S_EE", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-2_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-2_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-3_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-3_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-4_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-4_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-5_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-6_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_M+N1-I_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-2_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-2_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-3_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-3_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-4_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-4_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-5_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-6_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-II_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-2_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-2_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-3_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-3_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-4_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-4_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-5_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-6_(CNG)", index);
    index++;
    myEmissionClassStrings.insert("LCV_CNG_petrol_N1-III_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-3__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-3__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-4__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-4__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-5__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-5__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-6__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_M+N1-I_Euro-6__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-3__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-3__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-4__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-4__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-5__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-5__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-6__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-II_Euro-6__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-3__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-3__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-4__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-4__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-5__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-5__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-6__(E85)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FFV_N1-III_Euro-6__(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_BEV_M+N1-I", index);
    index++;
    myEmissionClassStrings.insert("LCV_BEV_N1-II", index);
    index++;
    myEmissionClassStrings.insert("LCV_BEV_N1-IIII", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_M+N1-I_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_M+N1-I_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_M+N1-I_Euro-6_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_M+N1-I_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-II_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-II_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-II_Euro-6_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-II_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-III_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-III_Euro-5_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-III_Euro-6_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_petrol_N1-III_Euro-6_(P)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_M+N1-I_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_M+N1-I_Euro-5_(D)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_M+N1-I_Euro-6_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_M+N1-I_Euro-6_(D)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-II_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-II_Euro-5_(D)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-II_Euro-6_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-II_Euro-6_(D)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-III_Euro-5_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-III_Euro-5_(D)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-III_Euro-6_(El)", index);
    index++;
    myEmissionClassStrings.insert("LCV_PHEV_diesel_N1-III_Euro-6_(D)", index);
    index++;
    myEmissionClassStrings.insert("LCV_FuelCell_N1-III", index);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_CNG_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_CNG_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_CNG_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_CNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_CNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_CNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_CNG_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_CNG_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_CNG_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_CNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_CNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_3-Axes_gt18t_CNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_CNG_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_CNG_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_CNG_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_CNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_CNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Midi_le15t_CNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_BEV_Std_le18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_BEV_3-Axes_gt18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_BEV_Midi", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_FuelCell_Std_le18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_FuelCell_Std_3-Axes_gt18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_FuelCell_Std_Midi", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("Coach_Std_le18t_EE", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_P_le15t_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_P_le15t_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_P_le15t_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-I_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-II_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-III_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-IV_EGR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-IV_SCR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-IV_SCRs_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-V_EGR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-V_SCR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-V_SCRs_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_le15t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-I_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-II_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-III_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-IV_EGR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-IV_SCR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-IV_SCRs_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-V_EGR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-V_SCR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-V_SCRs_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-I_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-II_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-III_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-IV_EGR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-IV_SCR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-IV_SCRs_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-V_EGR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-V_SCR_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-V_SCRs_(DPF)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_le18t_EE", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_EE", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_HEV_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_HEV_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_HEV_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_HEV_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_HEV_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_HEV_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_HEV_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_HEV_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_HEV_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_HEV_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_HEV_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_HEV_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_CNG_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_CNG_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_CNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_CNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_CNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_CNG_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_CNG_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_CNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_CNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_CNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_CNG_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_CNG_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_CNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_CNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_CNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_Ethanol_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_Ethanol_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_Ethanol_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_Ethanol_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_Ethanol_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Ethanol_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Ethanol_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Ethanol_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Ethanol_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_Ethanol_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Ethanol_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Ethanol_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Ethanol_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Ethanol_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_Ethanol_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_FuelCell_Midi_lt15t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_FuelCell_Std_gt15-18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_FuelCell_Artic_gt18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Electric_Midi_lt15t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Electric_Std_gt15-18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Electric_Artic_gt18t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_LNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_LNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Midi_lt15t_LNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_LNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_LNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Std_gt15-18t_LNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_LNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_LNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("UBus_Artic_gt18t_LNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("MC_4S_le250cc_preEuro", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_le250cc_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_le250cc_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_le250cc_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_le250cc_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_le250cc_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_le250cc_Euro-6", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_gt250cc_preEuro", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_gt250cc_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_gt250cc_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_gt250cc_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_gt250cc_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_gt250cc_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("MC_4S_gt250cc_Euro-6", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_(vlt30)_without_cat", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_(vlt30)_with_cat___FAV4", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_(vlt30)_EU2", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_(vlt30)_EU3", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_(vlt30)_EU4", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_(vlt30)_EU5", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_preEuro", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("Moped_le50cc_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("MC_2S_le250cc_preEuro", index);
    index++;
    myEmissionClassStrings.insert("MC_2S_le250cc_Euro-1", index);
    index++;
    myEmissionClassStrings.insert("MC_2S_le250cc_Euro-2", index);
    index++;
    myEmissionClassStrings.insert("MC_2S_le250cc_Euro-3", index);
    index++;
    myEmissionClassStrings.insert("MC_2S_le250cc_Euro-4", index);
    index++;
    myEmissionClassStrings.insert("MC_2S_le250cc_Euro-5", index);
    index++;
    myEmissionClassStrings.insert("MC_2S_le250cc_Euro-6", index);
    index++;
    myEmissionClassStrings.insert("eBike", index);
    index++;
    myEmissionClassStrings.insert("eScooter", index);
    index++;
    myEmissionClassStrings.insert("MC_BEV", index);
    index++;
    myEmissionClassStrings.insert("RT_petrol", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7_5t_EE", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_le7.5t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_EE", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt7_5-12t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt12-14t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt14-20t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt20-26t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt26-28t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt28-32t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RT_gt32t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_le7_5t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_lt28t_EE", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt20-28t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_28-34t_EE", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt28-34t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt34-40t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt40-50t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt50-60t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt60t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt14-20t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_50ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_60ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_70ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_80ties", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-I", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-II", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-III", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-IV_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-IV_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-IV_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-V_EGR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-V_SCR", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-V_SCRs", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-VI_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-VIs_A-C", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-VI_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_gt7_5-14t_Euro-VIs_D-E", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_le7_5t_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_le7_5t_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_le7_5t_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_gt7_5-12t_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_gt7_5-12t_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_gt7_5-12t_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_gt12t_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_gt12t_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_CNG_gt12t_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_CNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_CNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_CNG_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_le7_5t_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_le7_5t_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_le7_5t_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_gt7_5-12t_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_gt7_5-12t_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_gt7_5-12t_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_gt12t_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_gt12t_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("HGV_LNG_gt12t_Euro-VI", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_LNG_Euro-IV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_LNG_Euro-V", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_LNG_Euro-VI_(CI)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_BEV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_BEV_le7.5t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_BEV_gt7.5-12t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_BEV_gt12t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_PHEV_le7_5t_Euro-VI-(El)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_PHEV_le7_5t_Euro-VI-(D)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_PHEV_gt7_5-12t_Euro-VI-(El)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_PHEV_gt7_5-12t_Euro-VI-(D)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_PHEV_gt12t_Euro-VI-(El)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_PHEV_gt12t_Euro-VI-(D)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_PHEV_Euro-VI-(El)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_PHEV_Euro-VI-(D)", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_FCEV_le7_5t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_FCEV_gt7_5-12t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("RigidTruck_FCEV_gt12t", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.insert("TT_AT_FCEV", index | PollutantsInterface::HEAVY_BIT);
    index++;
    myEmissionClassStrings.addAlias("unknown", myEmissionClassStrings.get("PC_petrol_Euro-4"));
    myEmissionClassStrings.addAlias("default", myEmissionClassStrings.get("PC_petrol_Euro-4"));
}


SUMOEmissionClass
HelpersHBEFA4::getClass(const SUMOEmissionClass base, const std::string& vClass, const std::string& fuel, const std::string& eClass, const double /* weight */) const {
    std::string eClassOffset = "0";
    if (eClass.length() == 5 && eClass.substr(0, 4) == "Euro") {
        if (eClass[4] >= '0' && eClass[4] <= '6') {
            eClassOffset = eClass.substr(4, 1);
        }
    }
    std::string desc;
    if (vClass == "Passenger") {
        desc = "PC_";
        if (fuel == "Gasoline") {
            desc += "G_";
        } else if (fuel == "Diesel") {
            desc += "D_";
        }
        desc += "EU" + eClassOffset;
    } else if (vClass == "Delivery") {
        desc = "LDV_";
        if (fuel == "Gasoline") {
            desc += "G_";
        } else if (fuel == "Diesel") {
            desc += "D_";
        }
        desc += "EU" + eClassOffset;
    } else if (vClass == "UrbanBus") {
        desc = "Bus";
    } else if (vClass == "Coach") {
        desc = "Coach";
    } else if (vClass == "Truck" || vClass == "Trailer") {
        if (fuel == "Gasoline") {
            desc = "HDV_G";
        } else if (fuel == "Diesel") {
            desc = "HDV_D_EU" + eClassOffset;
        }
    }
    if (myEmissionClassStrings.hasString(desc)) {
        return myEmissionClassStrings.get(desc);
    }
    return base;
}


std::string
HelpersHBEFA4::getAmitranVehicleClass(const SUMOEmissionClass c) const {
    const std::string name = myEmissionClassStrings.getString(c);
    if (name.find("CO_") != std::string::npos) {
        return "Coach";
    } else if (name.find("CB_") != std::string::npos) {
        return "UrbanBus";
    } else if (name.find("LCV") != std::string::npos) {
        return "Delivery";
    } else if (name.find("HGV") != std::string::npos) {
        return "Truck";
    }
    return "Passenger";
}


std::string
HelpersHBEFA4::getFuel(const SUMOEmissionClass c) const {
    const std::string name = myEmissionClassStrings.getString(c);
    std::string fuel = "Gasoline";
    if (name.find("_diesel_") != std::string::npos) {
        fuel = "Diesel";
    }
    if (name.find("_BEV") != std::string::npos) {
        fuel = "Electricity";
    }
    if (name.find("_PHEV") != std::string::npos) {
        fuel = "Hybrid" + fuel;
    }
    return fuel;
}


int
HelpersHBEFA4::getEuroClass(const SUMOEmissionClass c) const {
    const std::string name = myEmissionClassStrings.getString(c);
    if (name.find("_Euro-1") != std::string::npos) {
        return 1;
    } else if (name.find("_Euro-2") != std::string::npos) {
        return 2;
    } else if (name.find("_Euro-3") != std::string::npos) {
        return 3;
    } else if (name.find("_Euro-4") != std::string::npos) {
        return 4;
    } else if (name.find("_Euro-5") != std::string::npos) {
        return 5;
    } else if (name.find("_Euro-6") != std::string::npos) {
        return 6;
    }
    return 0;
}


/****************************************************************************/
