/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CipherProcMain.c,v 1.5 1999/03/10 02:24:38 heller Exp $
____________________________________________________________________________*/

#include "string.h"

#include "PGPDiskEncryptDecrypt.h"
#include "PGPDisk.h"

#include "CipherProc.h"
#include "CipherContext.h"

#include "A4Stuff.h"

#ifdef __cplusplus
extern "C" {
#endif

OSStatus	main( CipherProcAPIStruct *	api );

#ifdef __cplusplus
}
#endif

#if TARGET_RT_MAC_CFM	// [

#pragma export on

RoutineDescriptor cipherRD = BUILD_ROUTINE_DESCRIPTOR(uppCipherProcInfo, main);

#pragma export off

#endif	// ]


	
	
	OSStatus
main( CipherProcAPIStruct *	api )
{
#if PGP_DEBUG
	// make sure main() is same type as it should be
	CipherProcPtr	proc	= main;	
#endif

	OSStatus				err	= noErr;
	CipherOp				op		= api->op;
	const CipherContext *	context	= api->context;
	
	EnterCodeResource();
	
	pgpAssert( StackSpace() >= 1024UL );
	
	if ( op == kCipherOp_Encrypt || op == kCipherOp_Decrypt )
		{
		pgpa((
			pgpaAddrValid( api->doCipher.dest, VoidAlign ),
			pgpaAssert( api->doCipher.numBlocks != 0 ),
			pgpaAddrValid( context, CipherContext )
			));
		
		CipherBlocks( context, api->doCipher.startBlock,
				api->doCipher.numBlocks, api->doCipher.src,
				api->doCipher.dest, op );
		}
	else if ( op == kCipherOp_Init )
		{
		CipherContext *	contextMod	= (CipherContext *)context;

		pgpAssertAddrValid( contextMod, CipherContext );
		
		CASTCFB_Init( &contextMod->castCFB,
				(const byte *) api->doInit.keyToExpand );
		
		err	= VerifyCastSBoxesValid() ? noErr : kCastSBoxesInvalidError;
		}
	else if ( op == kCipherOp_Verify )
		{
		err	= VerifyCastSBoxesValid() ? noErr : kCastSBoxesInvalidError;
		}
	else
		{
		err	= paramErr;
		}
		
	ExitCodeResource();
	
	return( err );
}








