/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CFileTable.cp,v 1.4 1999/03/10 02:33:18 heller Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>
#include <UDrawingUtils.h>
#include <LTableArrayStorage.h>
#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>

#include "CFileTable.h"

#include "CMacBinaryPipe.h"
#include "PGPFoneUtils.h"
#include "PGPFMacUtils.h"

#define ICONWIDTHHEIGHT		16

CFileTable*
CFileTable::CreateFileTableStream(
	LStream	*inStream)
{
	return (new CFileTable(inStream));
}


CFileTable::CFileTable(
	LStream	*inStream)
		: LTableView(inStream)
{
	mTableGeometry = new LTableMonoGeometry(this, mFrameSize.width, 20);
	mTableSelector = new LTableSingleSelector(this);
	mTableStorage = new LTableArrayStorage(this, sizeof(FileTableRec));
	// Open the Desktop Manager to get file icons
	mDTRefNum = pgp_GetDTRef(); 
}

void
CFileTable::FinishCreateSelf()
{
	Rect iconFrame;
	GDHandle maxDevice;
	OSErr err;

	FocusDraw();
	maxDevice = GetMaxDevice(&qd.screenBits.bounds);
	if(!maxDevice)
		mPixDepth = 1;
	else
		mPixDepth = (*(*maxDevice)->gdPMap)->pixelSize;
	if(mPixDepth>8)
		mPixDepth = 8;
	iconFrame.top=iconFrame.left = 0;
	iconFrame.right = iconFrame.bottom = 16;
	// Create the GWorld to store the icon in
	err = NewGWorld(&mGWorld,mPixDepth,&iconFrame,NIL,NIL,0);
	pgpAssert(!err);
}

CFileTable::~CFileTable()
{
	DisposeGWorld(mGWorld);
}

	void
CFileTable::DrawSelf()
{
	Rect frame;

	CalcLocalFrameRect(frame);
	::RGBBackColor(&UGAColorRamp::GetColor(colorRamp_White));
	::EraseRect(&frame);
	LTableView::DrawSelf();
}

void
CFileTable::DrawCell(
	const STableCell	&inCell,
	const Rect			&inLocalRect)
{
	FileTableRec	iconAndName;
	char			iconType;
	long			iconSize;
	Rect			iconFrame, iconRect;
	OSErr			err;
	DTPBRec			dtpb;
	Uint32			dataSize = sizeof(FileTableRec);
	GrafPtr			savePort;
	char *p, *u;
	short inx;
	
	GetPort(&savePort);
	GetCellData(inCell, &iconAndName, dataSize);
	iconRect.left = inLocalRect.left + 3;
	iconRect.right = iconRect.left + 16;
	iconRect.bottom = inLocalRect.bottom - 2;
	iconRect.top = iconRect.bottom - 16;
	if(iconAndName.xi->fdType)
	{
		switch(mPixDepth)
		{
			case 1:
				iconType = kSmallIcon;
				iconSize = kSmallIconSize;
				break;
			case 4:
				iconType = kSmall4BitIcon;
				iconSize = kSmall4BitIconSize;
				break;
			default:
				iconType = kSmall8BitIcon;
				iconSize = kSmall8BitIconSize;
				break;
		}
		dtpb.ioCompletion = NIL;
		dtpb.ioDTRefNum = mDTRefNum;
		dtpb.ioTagInfo = 0;
		dtpb.ioDTBuffer = &mIconBits[0];
		dtpb.ioDTReqCount = iconSize;
		dtpb.ioIconType = iconType;
		dtpb.ioFileCreator = iconAndName.xi->fdCreator;
		dtpb.ioFileType = iconAndName.xi->fdType;
		err = PBDTGetIconSync(&dtpb);
	}
	else
		err = 1;
	if(!err)
	{
        if(p = GetPixBaseAddr(mGWorld->portPixMap))
        {
			//because NewGWorld usually adds a long word of padding so that
			//it can more easily keep the pixel map long word aligned we
			//can't just BlockMove the data directly.  Instead we have to
			//move one row from our source and then advance the pointer of the
			//destination to the next row
			u=&mIconBits[0];
			for(inx=0;inx<ICONWIDTHHEIGHT;inx++)
			{
				BlockMoveData(u, p, (ICONWIDTHHEIGHT / 8) * mPixDepth);
                p += ((**(mGWorld->portPixMap)).rowBytes ) & 0x7fff;
				u += (ICONWIDTHHEIGHT / 8) * mPixDepth;
			}
        }
        iconFrame = (**(mGWorld->portPixMap)).bounds;
        iconFrame.right = iconFrame.left + ICONWIDTHHEIGHT;
        CopyBits((BitMap *)(*(mGWorld->portPixMap)),&GetMacPort()->portBits,
                    &iconFrame,&iconRect,srcCopy,NULL);
	}
	else
		::PlotIconID(&iconRect, atNone, ttNone, -4000);
	SetPort(savePort);
	::TextSize(9);
	::TextFont(1);
	::TextFace(0);
	::MoveTo(inLocalRect.left + 22, inLocalRect.bottom - 4);
	::DrawString(iconAndName.name);
}

void
CFileTable::HiliteCellActively(
	const STableCell	&inCell,
	Boolean				/*inHilite*/)
{
	Rect	cellFrame;
	if(GetLocalCellRect(inCell, cellFrame) && FocusExposed())
	{
		ForeColor(blackColor);
		BackColor(whiteColor);
		UDrawingUtils::SetHiliteModeOn();
		::InvertRect(&cellFrame);
	}
}

void
CFileTable::HiliteCellInactively(
	const STableCell	&inCell,
	Boolean				/* inHilite */)
{
	Rect	cellFrame;
	if (GetLocalCellRect(inCell, cellFrame) && FocusExposed())
	{
		ForeColor(blackColor);
		BackColor(whiteColor);
		UDrawingUtils::SetHiliteModeOn();
		::PenNormal();
		::PenMode(srcXor);
		::FrameRect(&cellFrame);
	}
}

void
CFileTable::ClickSelf(
	const SMouseDownEvent &inMouseDown)
{
	BroadcastMessage('ckFT', this);
	LTableView::ClickSelf(inMouseDown);
}

