/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CFileTable.h,v 1.4 1999/03/10 02:33:20 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LTableView.h>
#include <LBroadcaster.h>

class	CFileTable :	public LTableView,
						public LBroadcaster
{
public:
	enum { class_ID = 'Cftb' };
	static CFileTable*	CreateFileTableStream(LStream *inStream);
	
						CFileTable(LStream *inStream);
	virtual				~CFileTable();
	void				FinishCreateSelf();

protected:
	virtual void		ClickSelf(
								const SMouseDownEvent &inMouseDown);
	virtual void		DrawCell(
								const STableCell		&inCell,
								const Rect				&inLocalRect);
	virtual void		HiliteCellActively(
								const STableCell	&inCell,
								Boolean				/* inHilite */);
	virtual void		HiliteCellInactively(
								const STableCell	&inCell,
								Boolean				/* inHilite */);
	virtual void		DrawSelf();
private:
	short				mPixDepth, mDTRefNum;
	char				mIconBits[kSmall8BitIconSize];
	GWorldPtr			mGWorld;
};

struct XferInfo;

typedef struct FileTableRec
{
	Str31		name;
	XferInfo	*xi;
} FileTableRec;

