/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPacketWatch.cp,v 1.4 1999/03/10 02:35:21 heller Exp $
____________________________________________________________________________*/
#include <LStaticText.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>

#include "CPacketWatch.h"

#include "PGPFoneUtils.h"
#include "PGPFMacUtils.h"
#include "CPriorityQueue.h"
#include "CMessageQueue.h"
#include "CSoundInput.h"
#include "CSoundOutput.h"

CPacketWatch *gPacketWatch;

CPacketWatch *CPacketWatch::CreatePacketWatchStream(LStream *inStream)
{
	return (new CPacketWatch(inStream));
}

CPacketWatch::CPacketWatch()
{
}

CPacketWatch::CPacketWatch(LStream *inStream)
		: LView(inStream)
{
	mPW1 = mPW2 = NIL;
	InitCall();
	mGSMFullTime = mGSMLiteTime = mGSMFullDecTime = mGSMLiteDecTime = 0;
	mBandwidth = 0;
	mSoundOutQ = NIL;
	mSoundOutput = NIL;
	mLastUpdate = 0;
	StartIdling();
	gPacketWatch = this;
}

CPacketWatch::~CPacketWatch()
{
}

void
CPacketWatch::FinishCreateSelf()
{
	mPW1 = (LStaticText *)FindPaneByID('cPW1');
	mPW2 = (LStaticText *)FindPaneByID('cPW2');
}

void
CPacketWatch::GotPacket(Boolean good)
{
	if(!good)
		mBadPackets++;
	else
		mGoodPackets++;
}

void
CPacketWatch::InitCall()
{
	if(mPW1)
	{
		mPW1->FocusDraw();
		mPW1->SetDescriptor("\p");	mPW1->Refresh();
		mPW1->FocusDraw();
		mPW2->SetDescriptor("\p");	mPW2->Refresh();
	}
	mRTTime = mOutOverflowLost = mOutputUnderflows = mSentPackets =
				mGoodPackets = mBadPackets = mEscapedBytes = 0;
	mBandwidth = 0;
	mJitter = 0;
	for(short inx = 0;inx<PWOUTQUEUEENTRIES;inx++)
		mOutQueueSizes[inx] = 0;
	mAvgHPP = mMaxQueueSize = mEntryPos = 0;
	mLastSampleTime = LMGetTicks();
}

void
CPacketWatch::SetGSMTimes(long full, long lite, long fullDec, long liteDec)
{
	mGSMFullTime = full;
	mGSMLiteTime = lite;
	mGSMFullDecTime = fullDec;
	mGSMLiteDecTime = liteDec;
}

void
CPacketWatch::SpendTime(const EventRecord &/*inMacEvent*/)
{
	Str255 sf, s;
	short samp, inx;
	
	if(mSoundOutQ)
	{
		samp = mSoundOutQ->GetSize();
		if(samp > mMaxQueueSize)
			mMaxQueueSize = samp;
		if(mLastSampleTime + 60 <= LMGetTicks())
		{
			mOutQueueSizes[mEntryPos] = samp;
			mEntryPos ++;
			mEntryPos %= PWOUTQUEUEENTRIES;
			mLastSampleTime = LMGetTicks();
			for(inx = mAvgHPP = 0; inx < PWOUTQUEUEENTRIES; inx++)
				mAvgHPP += mOutQueueSizes[inx];
			mAvgHPP /= PWOUTQUEUEENTRIES;
			if(mAvgHPP >= SOUNDINPUTQUEUEAVGMAX)
			{	// we have become very backed up
				mOutOverflowLost += samp;
				for(inx = mAvgHPP = 0; inx < PWOUTQUEUEENTRIES; inx++)
					mOutQueueSizes[inx] = 0;
				mSoundOutQ->FreeType(_mt_voicePacket);	//so ditch outgoing voice
			}
		}
	}
	if(mLastUpdate + PWFREQUENCY < LMGetTicks())
	{
		if(IsVisible())
		{
			if(mRTTime == -1)
				pstrcpy(s, "\p?");
			else
				num2str(s, mRTTime, -1, 10);
			sprintf((char *)sf, "%ld\r"
								"%ld\r"
								"%ld\r"
								"%sms\r"
								"%ld%%",
								mSentPackets,			// Packets Sent
								mGoodPackets,			// Good Rcvd:
								mBadPackets,			// Bad Rcvd:
								s,						// Round Trip:
								mGSMFullTime / 10		// GSM Load:
								);
			c2pstr((char *)sf);
			mPW1->SetDescriptor(sf);
			s[0]=0;
			if(mSoundOutput)
				num2str(s, mSoundOutput->GetNumPlaying(), -1, 10);
			sprintf((char *)sf, "%s\r"
								"%ld\r"
								"%ld\r"
								"%ldms\r"
								"N/A",
								s,						// Samples Queued:
								mOutputUnderflows,		// Sound Underflows:
								mOutOverflowLost,		// Sound Overflows:
								mJitter				// Jitter:
								//mBandwidth				// Est. Bandwidth:
								);
			c2pstr((char *)sf);
			mPW2->SetDescriptor(sf);
		}
		mLastUpdate = LMGetTicks();
	}
}

