/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: UPGPDConException.h,v 1.2.10.1 1999/07/09 23:05:43 heller Exp $
____________________________________________________________________________*/
#pragma once 

#if DCON
#include "DCon.h"
#endif

#include "Errors.h"
#include "PGPErrors.h"

// Define DCON_LOG_LEVEL to be 0 (No Logging), 1 (Error Logging), 2 (Warning Logging)
// or 3 (Note Logging)

#ifndef DCON_LOG_LEVEL
#define DCON_LOG_LEVEL	0
#endif

#ifdef	__cplusplus

inline void
DConLogNote(
	const char *	inFormat,
	...)
{
#if DCON_LOG_LEVEL >= 3
	va_list	args;
	
	va_start(args, inFormat);
	vdprintf(inFormat, args);
	va_end(args);
#else
	(void) inFormat;
#endif
}



inline void
DConDumpNote(
	const char *	inLabel,
	const void *	inMemory,
	size_t			inLen)
{
#if DCON_LOG_LEVEL >= 3
	dprintf(inLabel);
	dprintmem(inMemory, inLen);
#else
	(void) inLabel;
	(void) inMemory;
	(void) inLen;
#endif
}



inline void
DConLogWarning(
	const char *	inFormat,
	...)
{
#if DCON_LOG_LEVEL >= 2
	va_list	args;
	
	va_start(args, inFormat);
	vdprintf(inFormat, args);
	va_end(args);
#else
	(void) inFormat;
#endif
}



inline void
DConDumpWarning(
	const char *	inLabel,
	const void *	inMemory,
	size_t			inLen)
{
#if DCON_LOG_LEVEL >= 2
	dprintf(inLabel);
	dprintmem(inMemory, inLen);
#else
	(void) inLabel;
	(void) inMemory;
	(void) inLen;
#endif
}



inline void
DConLogError(
	const char *	inFormat,
	...)
{
#if DCON_LOG_LEVEL >= 1
	va_list	args;
	
	va_start(args, inFormat);
	vdprintf(inFormat, args);
	va_end(args);
#else
	(void) inFormat;
#endif
}



inline void
DConDumpError(
	const char *	inLabel,
	const void *	inMemory,
	size_t			inLen)
{
#if DCON_LOG_LEVEL >= 1
	dprintf(inLabel);
	dprintmem(inMemory, inLen);
#else
	(void) inLabel;
	(void) inMemory;
	(void) inLen;
#endif
}



inline void
DConThrowPGPError(
	PGPError	inError)
{
	if (inError != kPGPError_UserAbort) {
		DConLogError("PGPError: %ld in %s at %s\n", inError, __FILE__, __LINE__);
	}
	throw inError;
}



inline void
DConThrowIfPGPError(
	PGPError	inError)
{
	if (inError != kPGPError_NoErr) {
		DConThrowPGPError(inError);
	}
}



inline void
DConThrowOSError(
	OSStatus	inError)
{
	if (inError != userCanceledErr) {
		DConLogError("OS Error: %ld in %s at %s\n", inError, __FILE__, __LINE__);
	}
	throw inError;
}



inline void
DConThrowIfOSError(
	OSStatus	inError)
{
	if (inError != noErr) {
		DConThrowOSError(inError);
	}
}

#endif

/* Defines the following macros
	PGPThrow_Err
	PGPThrowComboErr_
	PGPThrowIfPGPErr_
	PGPThrowPGPErr_
	PGPThrowIfOSErr_
	PGPThrowOSErr_
	PGPThrowIfNil_
	PGPThrowIfNULL_
	PGPThrowIfResError_
	PGPThrowIfMemError_
	PGPThrowIfResFail_
	PGPThrowIfMemFail_
	PGPThrowIf_
	PGPThrowIfNot_

#define PGPThrow_Err(err)		throw(err)


#ifdef Debug_Throw
extern Str15	gErrorString;
#define	PGPThrowComboErr_(comboerr)										\
	do {																\
		if (! comboerr.IsCancelError()) {								\
			if (comboerr.HavePGPError()) {								\
				::NumToString(comboerr.pgpErr, gErrorString);			\
			} else {													\
				::NumToString(comboerr.err, gErrorString);				\
			}															\
			if (PP_PowerPlant::UDebugging::gDebugThrow ==				\
					debugAction_Alert) {								\
				UDebugging::AlertThrowAt(	gErrorString,				\
											"\p" __FILE__, __LINE__);	\
			} else if (PP_PowerPlant::UDebugging::gDebugThrow ==		\
					debugAction_LowLevelDebugger) {						\
				BreakStrToLowLevelDebugger_(gErrorString);				\
			} else if (PP_PowerPlant::UDebugging::gDebugThrow ==		\
					debugAction_SourceDebugger) {						\
				BreakToSourceDebugger_();								\
			}															\
		}																\
		PGPThrow_Err(comboerr);											\
	} while (false)
#else
#define PGPThrowComboErr_(comboerr)		PGPThrow_Err(comboerr)
#endif


#define PGPThrowIfPGPErr_(pgpErr)										\
	if (pgpErr != kPGPError_NoErr) {									\
		PGPThrowComboErr_(CComboError(CComboError::kPGPError, pgpErr));	\
	}

#define PGPThrowPGPErr_(err)	PGPThrowComboErr_(							\
									CComboError(CComboError::kPGPError, err))



#define PGPThrowIfOSErr_(err)											\
	if (err != noErr) {													\
		PGPThrowComboErr_(CComboError(CComboError::kPlatformError, err));	\
	}



#define PGPThrowOSErr_(err)	PGPThrowComboErr_(								\
							CComboError(CComboError::kPlatformError, err))



#define	PGPThrowIfNil_(ptr)													\
		if ((ptr) == nil) PGPThrowComboErr_(								\
				CComboError(CComboError::kPGPError, kPGPError_BadMemAddress));



#define	PGPThrowIfNULL_(ptr)												\
		if ((ptr) == nil) PGPThrowComboErr_(								\
			CComboError(CComboError::kPGPError, kPGPError_BadMemAddress));

#define	PGPThrowIfResError_()	PGPThrowIfOSErr_(ResError())
#define	PGPThrowIfMemError_()	PGPThrowIfOSErr_(MemError())


#define	PGPThrowIfResFail_(h)												\
	if ((h) == nil) {														\
		OSErr	__theErr = ResError();										\
		if (__theErr == noErr) {											\
			__theErr = resNotFound;											\
		}																	\
	PGPThrowComboErr_(CComboError(CComboError::kPlatformError, __theErr));	\
	}


	
#define	PGPThrowIfMemFail_(p)												\
	if ((p) == nil) {														\
		OSErr	__theErr = MemError();										\
		if (__theErr == noErr) __theErr = memFullErr;						\
	PGPThrowComboErr_(CComboError(CComboError::kPlatformError, __theErr));	\
	}



#define	PGPThrowIf_(test)													\
		if (test) PGPThrowComboErr_(CComboError(CComboError::kPGPError,		\
										kPGPError_AssertFailed));



#define	PGPThrowIfNot_(test)												\
		if (!(test)) PGPThrowComboErr_(CComboError(CComboError::kPGPError,	\
					kPGPError_AssertFailed));
*/
