/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPGPnetWindow.cp,v 1.11 1999/05/08 05:49:26 wprice Exp $
____________________________________________________________________________*/
#include <MacWindows.h>
#include <LRadioButton.h>
#include <LMultiPanelView.h>
#include <LTabsControl.h>
#include <PP_Messages.h>
#include <UWindows.h>

#include "CPGPnetWindow.h"
#include "CPGPnet.h"
#include "pgpNetPrefs.h"
#include "pflPrefTypes.h"
#include "PGPnetIPC.h"


const Int16	kMinimumWindowHeight	=	175;

namespace {
	const ResIDT		ppob_StatusPanel	=	1001;
	const ResIDT		ppob_LogPanel		=	1002;
	const ResIDT		ppob_HostsPanel		=	1003;

	enum {
		panel_First			=	1,
		panel_Status		=	panel_First,
		panel_Log,
		panel_Hosts
	};

	const PaneIDT	tabs_PGPnet		=	1001;
	const PaneIDT	multi_Panels	=	1005;
	const PaneIDT	button_On		=	'rOn ';
	const PaneIDT	button_Off		=	'rOff';
}

CPGPnetWindow::~CPGPnetWindow()
{
	Rect		windowPos;
	PGPError	err;
	size_t		length;	
	
	length = sizeof(Rect);
	windowPos = UWindows::GetWindowContentRect(mMacWindowP);
	
	if(windowPos.bottom - windowPos.top >= kMinimumWindowHeight)
	{
		err = PGPSetPrefData(	CPGPnet::GetNetPrefs(),
								kPGPNetPrefMainWindowPos,
								length,
								&windowPos);
		pgpAssertNoErr(err);
	}
}

	void
CPGPnetWindow::FinishCreateSelf()
{
	PGPBoolean	on;
	size_t		length;
	Rect		*windPosPtr,
				windowPos,
				monitorIntersectRect,
				windowTitleBarRect;
	PGPError	err;
	
	// Add panels to view
	mTabsControl = (LTabsControl *) FindPaneByID(tabs_PGPnet);
	mPanelView = (LMultiPanelView *) FindPaneByID(multi_Panels);
	
	mPanelView->AddPanel(	ppob_StatusPanel,
							nil,
							panel_Status );
	mPanelView->AddPanel(	ppob_LogPanel,
							nil,
							panel_Log );
	mPanelView->AddPanel(	ppob_HostsPanel,
							nil,
							panel_Hosts );
	mPanelView->CreateAllPanels();
	mPanelView->SwitchToPanel(panel_First);
	
	( (LRadioButton *)FindPaneByID( button_On ) )->AddListener( this );
	( (LRadioButton *)FindPaneByID( button_Off ) )->AddListener( this );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(), kPGPNetPrefEnablePGPnet, &on );
	if( !on )
		( (LRadioButton *)FindPaneByID( button_Off ) )->SetValue( 1 );
	
	
	length = sizeof(Rect);
	err = PGPGetPrefData(	CPGPnet::GetNetPrefs(),
							kPGPNetPrefMainWindowPos,
							&length,
							&windPosPtr);
	if( IsntPGPError(err) )
	{
		windowPos = *windPosPtr;
		PGPDisposePrefData( CPGPnet::GetNetPrefs(), windPosPtr );
		windowTitleBarRect = windowPos;
		windowTitleBarRect.bottom = windowTitleBarRect.top + 20;
		// sanity check
		if((windowPos.left > 0) && (windowPos.right > 0)
			&& (windowPos.top > 0) && (windowPos.bottom > 0)
			&& SectRect(&windowTitleBarRect, &qd.screenBits.bounds,
						&monitorIntersectRect))
		{
			DoSetBounds( windowPos );
		}
	}
}

	void
CPGPnetWindow::AttemptClose()
{
	ProcessCommand(cmd_Quit);
}

	void
CPGPnetWindow::ShowPanel(
	UInt16		inIndex )
{
	mTabsControl->SetValue( inIndex );
}

	void
CPGPnetWindow::ListenToMessage(
	MessageT	inMessage,
	void *		ioParam )
{
	PGPError	err;
	
	switch (inMessage)
	{
		case button_On:
		case button_Off:
			if( *(Int32 *)ioParam == 1 )
			{
				PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
					kPGPNetPrefEnablePGPnet, inMessage == button_On );
				err = PGPSavePrefFile( CPGPnet::GetNetPrefs() );
				pgpAssertNoErr(err);
				CPGPnet::PostPNEvent( kPGPnetHLEvent_UpdateConfig );
			}
			break;
	};
}

