/*____________________________________________________________________________
	CManualTranslator.h
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CManualTranslator.h,v 1.8 1999/04/26 09:40:07 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CTranslator.h"

class CManualTranslator : public CTranslator
{
public:
	
protected:
	
public:
			CManualTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CTranslator( context, tlsContext, progressHook)
				{
				}
};



class CManualDecryptVerifyTranslator : public CManualTranslator
{
protected:

	virtual PGPError	PGPDecodeEventHandler(PGPContextRef context,
							PGPEvent *event,
							DecryptVerifyEventHandlerData *data );
							
public:
			CManualDecryptVerifyTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CManualTranslator( context, tlsContext, progressHook)
				{
				}
				
	virtual PluginError	TranslateFile(emsTranslatorP trans, emsDataFileP inFile,
    							emsDataFileP outFile, emsResultStatusP transStatus);
};



class CManualAddKeyTranslator : public CManualTranslator
{
public:
			CManualAddKeyTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CManualTranslator( context, tlsContext, progressHook)
				{
				}
				
	virtual PluginError	TranslateFile(emsTranslatorP trans, emsDataFileP inFile,
    							emsDataFileP outFile, emsResultStatusP transStatus);
};


class CManualEncryptSignTranslator : public CManualTranslator
{
protected:
	Boolean			mDoSign;
	
public:
		CManualEncryptSignTranslator( PGPContextRef context,
			PGPtlsContextRef tlsContext, emsProgress progressHook,
			Boolean sign );
					
	virtual PluginError	TranslateFile(emsTranslatorP trans, emsDataFileP inFile,
    							emsDataFileP outFile, emsResultStatusP transStatus);
};


class CManualSignTranslator : public CManualTranslator
{
public:
			CManualSignTranslator( PGPContextRef context,
				PGPtlsContextRef tlsContext, emsProgress progressHook)
				: CManualTranslator( context, tlsContext, progressHook)
				{
				}
				
	virtual PluginError	TranslateFile(emsTranslatorP trans, emsDataFileP inFile,
    							emsDataFileP outFile, emsResultStatusP transStatus);
};


