/*____________________________________________________________________________
	TranslatorIDs.h
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: TranslatorIDs.h,v 1.5 1999/04/26 09:41:26 heller Exp $
____________________________________________________________________________*/

#pragma once


typedef enum TranslatorID
{
	kInvalidTranslatorID = 0,
	
	// note: ids must start at 1 and be sequential
	kFirstTranslatorID = 1,
	
	kEncryptTranslatorID = kFirstTranslatorID,
	kSignTranslatorID,
	kEncryptAndSignTranslatorID,
	
	kDecryptTranslatorID,
	kVerifyTranslatorID,
	
	kManualSignTranslatorID,
	kManualEncryptTranslatorID,
	kManualEncryptSignTranslatorID,
	kManualDecryptVerifyTranslatorID,
	kManualAddKeyTranslatorID,
	
	kLastTranslatorIDPlusOne,
	
	kPGPNumTranslators	= kLastTranslatorIDPlusOne - kFirstTranslatorID
	
} TranslatorID;


const SInt16	kEncryptIconSuiteID	=	500;
const SInt16	kSignIconSuiteID	=	501;
