/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.
	
	$Id: CAVPairDialog.cp,v 1.9 1999/05/19 07:25:18 wprice Exp $
____________________________________________________________________________*/

#include <URegistrar.h>
#include <PP_Messages.h>
#include <LStaticText.h>
#include <LPushButton.h>
#include <LPopupButton.h>
#include <LEditText.h>
#include <string.h>

#include "PGPclientLibUtils.h"
#include "PGPclientLibDialogs.h"
#include "pgpMem.h"
#include "pgpErrors.h"
#include "pgpKeys.h"
#include "pgpUtilities.h"
#include "pgpClientLib.h"
#include "pgpClientPrefs.h"
#include "pgpAdminPrefs.h"

#include "pflPrefTypes.h"

#include "MacErrors.h"
#include "MacCursors.h"
#include "MacQuickdraw.h"
#include "MacStrings.h"
#include "CString.h"

#include "CAVPairDialog.h"

#define CKERR			if( err.IsError() ) goto done	
#define IPSECTYPETEST

const PGPInt16	kMaxAVPairs					=	20;

const ResIDT	ppob_AVPairID				=	4776;
const ResIDT	ppob_EditAVID				=	4777;

const PaneIDT	table_AVPairs				=	'tAVP';
const PaneIDT	button_Add					=	'bAdd';
const PaneIDT	button_Edit					=	'bEdi';
const PaneIDT	button_Remove				=	'bRmv';
const PaneIDT	caption_CAType				=	'cCAT';
const PaneIDT	button_OK					=	'bOK ';
const PaneIDT	button_Cancel				=	'bCAN';

const PaneIDT	popup_Attribute				=	'pAtt';
const PaneIDT	edit_Attribute				=	'eAtt';

const ResIDT	kAVPairsStringListResID		=	8948;

enum
{
	kNetToolsStrIndex	= 1,
	kVeriSignStrIndex,
	kEntrustStrIndex,
	
	kAVCommonNameStrIndex,
	kAVEmailStrIndex,
	kAVOrgNameStrIndex,
	kAVOrgUnitStrIndex,
	kAVCountryStrIndex,
	kAVCityStrIndex,
	kAVStateStrIndex,
	kAVStreetStrIndex,
	kAVZipCodeStrIndex,
	kAVPOBoxStrIndex,
	kAVTelephoneStrIndex,
	kAVInitialsStrIndex,
	kAVDomainNameStrIndex,
	kAVIPAddressStrIndex,
	kAVCertTypeStrIndex,
	
	kChallengeWarningStrIndex,
	kChallengePromptStrIndex
};

class CWhackWindowKind
{
protected:
	short			mSaveWindowKind;
	WindowRecord	*mFrontWindow;
	
public:
			CWhackWindowKind( void )
			{
				mFrontWindow = (WindowRecord *) FrontWindow();
				mSaveWindowKind	= mFrontWindow->windowKind;
				mFrontWindow->windowKind = kApplicationWindowKind;
			}
			
	virtual ~CWhackWindowKind()
			{
				mFrontWindow->windowKind = mSaveWindowKind;
			}
};

PGPError RealPGPGetAVAttributeString(
	PGPAVAttribute		attr,
	Str255				attrStr );

	static PGPError
sCreateCommonAVPairs (
	PGPContextRef		context,
	PGPKeyServerClass	serverclass,
	PGPUserIDRef		userid,
	PGPAttributeValue**	ppAVcur )
{
	PGPError			err			= kPGPError_NoErr;
	PGPByte*			pName;
	PGPSize				size;

	// first compute those attributes based on the userid
	if (PGPUserIDRefIsValid (userid))
	{
		// get the "common name" attribute from the userid
		err = PGPGetUserIDStringBuffer (
				userid, kPGPUserIDPropCommonName, 0, NULL, &size);

		if (size > 0)
		{
			pName = (PGPByte *)PGPNewData(PGPGetContextMemoryMgr (context), 
								size+1, kPGPMemoryMgrFlags_Clear);

			if (pName)
			{
				err = PGPGetUserIDStringBuffer (
						userid, kPGPUserIDPropCommonName, size, 
						(char *)pName, &size); 

				if (IsntPGPError (err))
				{
					if( 0 && ( serverclass == kPGPKeyServerClass_Verisign ) )
					{
						char* pFirstName;
						char* pMiddleName;
						char* pLastName;

						PGPParseCommonName (PGPGetContextMemoryMgr (context),
							(char *)pName, &pFirstName, &pMiddleName, &pLastName);

						if (pFirstName)
						{
							(*ppAVcur)->attribute = 
										kPGPAVAttribute_MailFirstName;
							(*ppAVcur)->size = strlen( pFirstName );
							(*ppAVcur)->value.pointervalue = pFirstName;
							++(*ppAVcur);
						}

						if (pMiddleName)
						{
							(*ppAVcur)->attribute = 
										kPGPAVAttribute_MailMiddleName;
							(*ppAVcur)->size = strlen( pMiddleName );
							(*ppAVcur)->value.pointervalue = pMiddleName;
							++(*ppAVcur);
						}

						if (pLastName)
						{
							(*ppAVcur)->attribute = 
										kPGPAVAttribute_MailLastName;
							(*ppAVcur)->size = strlen( pLastName );
							(*ppAVcur)->value.pointervalue = pLastName;
							++(*ppAVcur);
						}

						PGPFreeData (pName);
					}
					else
					{
						(*ppAVcur)->attribute = kPGPAVAttribute_CommonName;
						(*ppAVcur)->size = size;
						(*ppAVcur)->value.pointervalue = pName;
						++(*ppAVcur);
					}
				}
			}
			else
				err = kPGPError_OutOfMemory;
		}
		else
			err = kPGPError_InvalidProperty;
		if( IsPGPError( err ) )
			goto done;

		// get the "email" attribute from the userid
		err = PGPGetUserIDStringBuffer (
				userid, kPGPUserIDPropEmailAddress, 0, NULL, &size);

		if( IsntPGPError( err ) || ( err == kPGPError_BufferTooSmall ) )
		{
			(*ppAVcur)->value.pointervalue = PGPNewData (
					PGPGetContextMemoryMgr (context), size, 0);

			if ((*ppAVcur)->value.pointervalue)
			{
				err = PGPGetUserIDStringBuffer (
						userid, kPGPUserIDPropEmailAddress, size, 
						(char *)(*ppAVcur)->value.pointervalue, &size); 

				if (IsntPGPError (err))
				{
					(*ppAVcur)->attribute = kPGPAVAttribute_Email;
					(*ppAVcur)->size = size;
					++(*ppAVcur);
				}
			}
			else
				err = kPGPError_OutOfMemory;
		}
		else
			err = kPGPError_InvalidProperty;
		if( IsPGPError( err ) )
			goto done;
	}

done:
	return err;
}

	static PGPError
sGetAVPairsFromPrefs(
	PGPContextRef		context,
	PGPPrefRef			prefref,
	PGPAttributeValue**	ppAVcur )
{
	PGPError			err;
	PGPSize				size;
	PGPByte*			data;
	PGPUInt32			numAVs;
	PGPAttributeValue*	pAVlist;
	PGPUInt32			u;

	err = PGPGetPrefData (prefref, kPGPPrefExtraAVPairs, &size, &data);
	if (IsntPGPError (err))
	{
		err = PGPDataToAVPairs(PGPGetContextMemoryMgr (context),
					data, size, &pAVlist, &numAVs);
		PGPDisposePrefData (prefref, data);

		for (u=0; u<numAVs; u++)
		{
			(*ppAVcur)->attribute			= pAVlist[u].attribute;
			(*ppAVcur)->size				= pAVlist[u].size;
			(*ppAVcur)->value.pointervalue	= pAVlist[u].value.pointervalue;
			++(*ppAVcur);
		}

		PGPFreeData (pAVlist);
	}
	return err;
}

	static void
sCreateDefaultAVPairs (
	PGPContextRef		context,
	PGPKeyServerClass	serverclass,
	PGPAttributeValue**	ppAVcur)
{
	switch (serverclass)
	{
		case kPGPKeyServerClass_NetToolsCA :
			break;
		case kPGPKeyServerClass_Verisign :
		{
			char	vs_certtype[]		= "end-user";
			PGPSize	len;
			
			(*ppAVcur)->attribute = kPGPAVAttribute_OrganizationName;
			(*ppAVcur)->size = 0;
			(*ppAVcur)->value.pointervalue = NULL;
			++(*ppAVcur);

			(*ppAVcur)->attribute = kPGPAVAttribute_OrganizationalUnitName;
			(*ppAVcur)->size = 0;
			(*ppAVcur)->value.pointervalue = NULL;
			++(*ppAVcur);

			len = strlen( vs_certtype );
			(*ppAVcur)->attribute = kPGPAVAttribute_CertType;
			(*ppAVcur)->size = len;
			(*ppAVcur)->value.pointervalue = PGPNewData (
						PGPGetContextMemoryMgr( context ), len + 1, 0);
			strcpy( (char *)(*ppAVcur)->value.pointervalue, vs_certtype );
			++(*ppAVcur);
			break;
		}
		case kPGPKeyServerClass_Entrust :
			break;
		default :
			break;
	}
}

	static PGPError
sAppendClassAVPairs(
	PGPContextRef		context,
	PGPPrefRef			adminPrefs,
	PGPKeyServerClass	serverClass,
	PGPAttributeValue**	ppAVcur)
{
	PGPError			err					= kPGPError_NoErr;
	char *				passphrase			= NULL;
	PGPSize				len;
#if PGP_BUSINESS_SECURITY
	PGPBoolean			enforceLength,
						enforceQuality;
	PGPUInt32			minLength,
						minQuality;
#endif

	adminPrefs;
	switch( serverClass )
	{
		case kPGPKeyServerClass_NetToolsCA :
			return err;
		case kPGPKeyServerClass_Verisign :
#if PGP_BUSINESS_SECURITY
			PGPGetPrefBoolean( adminPrefs, kPGPPrefEnforceMinChars, &enforceLength);
			PGPGetPrefBoolean( adminPrefs, kPGPPrefEnforceMinQuality, &enforceQuality);
			PGPGetPrefNumber( adminPrefs, kPGPPrefMinChars, &minLength);
			PGPGetPrefNumber( adminPrefs, kPGPPrefMinQuality, &minQuality);
#endif
			{
				CWhackWindowKind	whackKind;	// ugly hack alert
				Str255				pstr;
				char				cstr[256];
				
				GetIndString( pstr, kAVPairsStringListResID, kChallengePromptStrIndex );
				PToCString( pstr, cstr );
				err = PGPConfirmationPassphraseDialog( context,
						PGPOUIDialogPrompt( context, cstr ),
						PGPOUIOutputPassphrase( context, &passphrase ),
#if PGP_BUSINESS_SECURITY
						enforceLength ?
							PGPOUIMinimumPassphraseLength(
								context, minLength ) :
							PGPONullOption( context ),
						enforceQuality ?
							PGPOUIMinimumPassphraseQuality(
								context, minQuality ) :
							PGPONullOption( context ),
#endif
						PGPOLastOption( context ) );
			}
			if (IsntPGPError (err))
			{
				len = strlen( passphrase );
				(*ppAVcur)->attribute = kPGPAVAttribute_Challenge;
				(*ppAVcur)->size = len;
				(*ppAVcur)->value.pointervalue = PGPNewData (
						PGPGetContextMemoryMgr (context), len + 1, 0);
				strcpy( (char *)(*ppAVcur)->value.pointervalue, passphrase );
				++(*ppAVcur);
			}
			if( passphrase )
				PGPFreeData( passphrase );

			return err;
		case kPGPKeyServerClass_Entrust :
			return err;
		default :
			return err;
	}
}

	static PGPError
RealPGPAVPairDialog(
	PGPContextRef			pgpContext,
	PGPKeyServerClass		serverClass,
	PGPAttributeValue *		pAVList,
	PGPAttributeValue **	pEndAVList )
{
	CComboError				err;
	DialogRef				avDialog;
	
	RegisterClass_( CAVPairDialog );
	RegisterClass_( CAVPairTable );
	
	// Create standard Macintosh window and overlay PowerPlant onto it
	avDialog = CPGPModalGrafPortView::CreateDialog( ppob_AVPairID );
	if( IsntNull( avDialog ) )
	{
		CAVPairDialog *avGrafPortView = nil;

		avGrafPortView =
				(CAVPairDialog *) GetWRefCon( avDialog );
		pgpAssert( IsntNull( avGrafPortView ) );
		
		err = avGrafPortView->Init( pgpContext, serverClass, pAVList, *pEndAVList );
		if( err.IsntError() )
		{
			ModalFilterUPP	filterUPP;
			MessageT		dismissMessage;
			short			itemHit = 0;
		
			InitCursor();
			
			SetPort( avDialog );
			ShowWindow( avDialog );
			SelectWindow( avDialog );
	
			avGrafPortView->Refresh();
			
			filterUPP = NewModalFilterProc(
						CPGPModalGrafPortView::ModalFilterProcHandler );
			
			avGrafPortView->SetDismissMessage( msg_Nothing );

			while( itemHit == 0 )
			{
				ModalDialog( filterUPP, &itemHit );
			}
		
			dismissMessage = avGrafPortView->GetDismissMessage();
			*pEndAVList = avGrafPortView->mEndAVList;
			if( dismissMessage != msg_OK )
				err.pgpErr = kPGPError_UserAbort;
		
			DisposeRoutineDescriptor( filterUPP );
		}
		
		delete avGrafPortView;
		DisposeDialog( avDialog );
	}
	else
	{
		err.pgpErr = kPGPError_OutOfMemory;
	}
	
	return err.ConvertToPGPError();
}

	PGPError
PGPGetAVAttributeString(
	PGPContextRef		pgpContext,
	PGPAVAttribute		attr,
	Str255				attrStr )
{
	PGPclientLibState	state;
	PGPError			err = kPGPError_NoErr;
	
	err = EnterPGPclientLib( pgpContext, &state );
	if( IsntPGPError( err ) )
		err = RealPGPGetAVAttributeString( attr, attrStr );
	ExitPGPclientLib( &state );
	return err;
}

	PGPError
RealPGPGetAVAttributeString(
	PGPAVAttribute	attr,
	Str255			attrStr )
{
	PGPError		err = kPGPError_NoErr;
	PGPInt16		strIndex = 0;
	
	attrStr[0] = 0;
	switch( attr )
	{
		case kPGPAVAttribute_CommonName:
			strIndex = kAVCommonNameStrIndex;
			break;
		case kPGPAVAttribute_Email:
			strIndex = kAVEmailStrIndex;
			break;
		case kPGPAVAttribute_OrganizationName:
			strIndex = kAVOrgNameStrIndex;
			break;
		case kPGPAVAttribute_OrganizationalUnitName:
			strIndex = kAVOrgUnitStrIndex;
			break;
		case kPGPAVAttribute_Country:
			strIndex = kAVCountryStrIndex;
			break;
		case kPGPAVAttribute_Locality:
			strIndex = kAVCityStrIndex;
			break;
		case kPGPAVAttribute_State:
			strIndex = kAVStateStrIndex;
			break;
		case kPGPAVAttribute_StreetAddress:
			strIndex = kAVStreetStrIndex;
			break;
		case kPGPAVAttribute_PostalCode:
			strIndex = kAVZipCodeStrIndex;
			break;
		case kPGPAVAttribute_POBOX:
			strIndex = kAVPOBoxStrIndex;
			break;
		case kPGPAVAttribute_TelephoneNumber:
			strIndex = kAVTelephoneStrIndex;
			break;
		case kPGPAVAttribute_Initials:
			strIndex = kAVInitialsStrIndex;
			break;
		case kPGPAVAttribute_DNSName:
			strIndex = kAVDomainNameStrIndex;
			break;
		case kPGPAVAttribute_IPAddress:
			strIndex = kAVIPAddressStrIndex;
			break;
		case kPGPAVAttribute_CertType:
			strIndex = kAVCertTypeStrIndex;
			break;
		default:
			err = kPGPError_ItemNotFound;
			break;
	}
	if( strIndex )
		GetIndString( attrStr, kAVPairsStringListResID, strIndex );
	return err;
}

	PGPError
PGPFreeCACertReqAVList(
	PGPAttributeValue *	pAVList,
	PGPUInt32			numAVs )
{
	PGPUInt32			u;

	if(pAVList) 
	{
		for(u=0; u<numAVs; u++)
		{
			if ((pAVList[u].attribute >= kPGPAVAttributeFirstPointer) &&
				(pAVList[u].attribute < kPGPAVAttributeFirstBoolean))
			{
				if(pAVList[u].value.pointervalue)
					PGPFreeData(pAVList[u].value.pointervalue);
			}
		}

		PGPFreeData(pAVList);
	}
	return kPGPError_NoErr;
}

	PGPError
PGPGetCACertReqAVList(
	PGPContextRef			context,
	PGPBoolean				force,
	PGPUserIDRef			userID,
	PGPKeyServerClass		serverClass,
	PGPAttributeValue **	pAVList,
	PGPUInt32 *				pNumAVs )
{
	PGPError				err = kPGPError_NoErr;
	PGPclientLibState		state;
	PGPAttributeValue		tempAVList[kMaxAVPairs];
	PGPUInt32				numAVs = 0;
	PGPAttributeValue *		pAVCur = &tempAVList[0];
	
	force;
	PGPValidateParam( IsntNull( context ) );
	PGPValidateParam( IsntNull( pAVList ) );
	PGPValidateParam( IsntNull( pNumAVs ) );
	*pAVList = NULL;
	*pNumAVs = 0;
	err = EnterPGPclientLib( context, &state );
	if( IsntPGPError( err ) )
	{
		err = sCreateCommonAVPairs( context, serverClass, userID, &pAVCur );
		if( IsntPGPError( err ) )
		{
#if PGP_BUSINESS_SECURITY
			if( !force )
			{
				err = sGetAVPairsFromPrefs( context,
						state.adminPrefsRef, &pAVCur );
			}
			if( IsPGPError( err ) || force )
#endif
			{
				sCreateDefaultAVPairs( context, serverClass, &pAVCur );
				err = RealPGPAVPairDialog( context, serverClass, tempAVList, &pAVCur );
			}
		}
		if( IsntPGPError( err ) )
		{
			if( PGPUserIDRefIsValid( userID ) )
			{
				err = sAppendClassAVPairs( context, state.adminPrefsRef, serverClass, &pAVCur );
			}
		}
		numAVs = pAVCur - &tempAVList[0];
		if( IsntPGPError(err) )
		{
			PGPSize		avSize;

			avSize = numAVs * sizeof(PGPAttributeValue);

			*pAVList = (PGPAttributeValue *)PGPNewData (
				PGPGetContextMemoryMgr( context ), avSize, 0 );
			if( IsntNull( *pAVList ) )
			{
				pgpCopyMemory( tempAVList, *pAVList, avSize );
				*pNumAVs = numAVs;
			}
			else 
				err = kPGPError_OutOfMemory;
		}
		
		if( IsPGPError(err) )
		{
			PGPUInt32	u;

			for( u=0; u < numAVs; u++ )
			{
				if( tempAVList[u].value.pointervalue )
					PGPFreeData( tempAVList[u].value.pointervalue );
			}
		}
	}
	ExitPGPclientLib( &state );
	
	return( err );
}

CAVPairDialog::CAVPairDialog(
	LStream *	inStream)
		: CPGPModalGrafPortView(inStream)
{
	mEditAVDialog = NULL;
}

CAVPairDialog::~CAVPairDialog()
{
}

	CComboError
CAVPairDialog::Init(
	PGPContextRef			pgpContext,
	PGPKeyServerClass		serverClass,
	PGPAttributeValue *		avList,
	PGPAttributeValue *		endAVList )
{
	CComboError				err;
	Str255					pstr;
	Int16					caStrInx;
	PGPUInt32				numAVs,
							avInx;
	
	mPGPContext = pgpContext;
	mAVList		= avList;
	mEndAVList	= endAVList;
	numAVs		= endAVList - avList;
	switch( serverClass )
	{
		case kPGPKeyServerClass_NetToolsCA:
			caStrInx = kNetToolsStrIndex;
			break;
		case kPGPKeyServerClass_Verisign:
			caStrInx = kVeriSignStrIndex;
			break;
		case kPGPKeyServerClass_Entrust:
			caStrInx = kEntrustStrIndex;
			break;
	}
	GetIndString( pstr, kAVPairsStringListResID, caStrInx );
	((LStaticText *)FindPaneByID( caption_CAType ))->SetDescriptor( pstr );
	
	for( avInx = 0; avInx < numAVs; avInx++ )
	{
		mAVTable->InsertRows( 1, LArray::index_Last,
			&avList, sizeof(PGPAttributeValue *), TRUE );
		avList++;
	}
done:
	return err;
}

	void
CAVPairDialog::FinishCreateSelf()
{
	CPGPModalGrafPortView::FinishCreateSelf();
	
	mAVTable = (CAVPairTable *) FindPaneByID( table_AVPairs );
	pgpAssert( IsntNull( mAVTable ) );
	
	mAVTable->AddListener(this);
	
	( mAddButton = (LPushButton *)FindPaneByID( button_Add ) )->
		AddListener( this );
	( mEditButton = (LPushButton *)FindPaneByID( button_Edit ) )->
		AddListener( this );
	( mRemoveButton = (LPushButton *)FindPaneByID( button_Remove ) )->
		AddListener( this );
	
	SetLatentSub( mAVTable );
}

	void
CAVPairDialog::ListenToMessage(
	MessageT			inMessage,
	void *				ioParam)
{
	STableCell			cell;
	PGPAttributeValue *	avPair;
	UInt32				len = sizeof(PGPAttributeValue);
	Str255				pstr;
	
	cell = mAVTable->GetFirstSelectedCell();
	if( cell.row > 0 )
		mAVTable->GetCellData( cell, &avPair, len );
	switch (inMessage)
	{
		case button_Add:
			if( EditAVDialog( mEndAVList, TRUE ) )
			{
				mAVTable->InsertRows( 1, LArray::index_Last,
					&mEndAVList, sizeof(PGPAttributeValue *), TRUE );
				mEndAVList++;
			}
			break;
		case button_Edit:
		case coltable_DoubleClick:
			if( cell.row > 0 )
			{
				if( EditAVDialog( avPair, FALSE ) )
				{
					STableCell	brCell;
					
					brCell.row = cell.row;	brCell.col = cell.col + 1;
					mAVTable->RefreshCellRange( cell, brCell );
				}
			}
			break;
		case button_Remove:
			TableIndexT		rows,
							cols;
			
			if( IsntNull( avPair->value.pointervalue ) )
				PGPFreeData( avPair->value.pointervalue );
			if( mEndAVList - avPair > 1 )
				pgpCopyMemory( avPair + 1, avPair,
					( mEndAVList - avPair - 1 ) * sizeof(PGPAttributeValue) );
			mEndAVList--;
			mAVTable->RemoveRows( 1, cell.row, TRUE );
			mAVTable->GetWideOpenTableSize( rows, cols );
			for( ; cell.row <= rows; cell.row++ )
			{
				mAVTable->GetCellData( cell, &avPair, len );
				avPair --;
				mAVTable->SetCellData( cell, &avPair, len );
			}
			break;
		case coltable_SelectChange:
			if( cell.row > 0 )
			{
				mEditButton->Enable();
				mRemoveButton->Enable();
			}
			else
			{
				mEditButton->Disable();
				mRemoveButton->Disable();
			}
			break;
		case edit_Attribute:
			((LEditText *)mEditAVDialog->FindPaneByID( edit_Attribute ))->
				GetDescriptor( pstr );
			if( pstr[0] > 0 )
				((LPushButton *)mEditAVDialog->FindPaneByID( button_OK ) )->Enable();
			else
				((LPushButton *)mEditAVDialog->FindPaneByID( button_OK ) )->Disable();
			break;
		default:
			CPGPModalGrafPortView::ListenToMessage( inMessage, ioParam );
			break;
	}
}

	PGPInt16
CAVPairDialog::AttributeToMenuIndex(
	PGPAVAttribute			attribute )
{
	PGPInt16				index = -1;
	
	switch( attribute )
	{
		case kPGPAVAttribute_CommonName:
			index = 1;
			break;
		case kPGPAVAttribute_Email:
			index = 2;
			break;
		case kPGPAVAttribute_OrganizationName:
			index = 3;
			break;
		case kPGPAVAttribute_OrganizationalUnitName:
			index = 4;
			break;
		case kPGPAVAttribute_Country:
			index = 5;
			break;
		case kPGPAVAttribute_Locality:
			index = 6;
			break;
		case kPGPAVAttribute_State:
			index = 7;
			break;
		case kPGPAVAttribute_StreetAddress:
			index = 8;
			break;
		case kPGPAVAttribute_PostalCode:
			index = 9;
			break;
		case kPGPAVAttribute_POBOX:
			index = 10;
			break;
		case kPGPAVAttribute_TelephoneNumber:
			index = 11;
			break;
		case kPGPAVAttribute_Initials:
			index = 12;
			break;
		case kPGPAVAttribute_DNSName:
			index = 13;
			break;
		case kPGPAVAttribute_IPAddress:
			index = 14;
			break;
		case kPGPAVAttribute_CertType:
			index = 15;
			break;
	}
	return index;
}

	PGPAVAttribute
CAVPairDialog::MenuIndexToAttribute(
	PGPInt16			index )
{
	PGPAVAttribute		attr;
	
	switch( index )
	{
		case 1:
			attr = kPGPAVAttribute_CommonName;
			break;
		case 2:
			attr = kPGPAVAttribute_Email;
			break;
		case 3:
			attr = kPGPAVAttribute_OrganizationName;
			break;
		case 4:
			attr = kPGPAVAttribute_OrganizationalUnitName;
			break;
		case 5:
			attr = kPGPAVAttribute_Country;
			break;
		case 6:
			attr = kPGPAVAttribute_Locality;
			break;
		case 7:
			attr = kPGPAVAttribute_State;
			break;
		case 8:
			attr = kPGPAVAttribute_StreetAddress;
			break;
		case 9:
			attr = kPGPAVAttribute_PostalCode;
			break;
		case 10:
			attr = kPGPAVAttribute_POBOX;
			break;
		case 11:
			attr = kPGPAVAttribute_TelephoneNumber;
			break;
		case 12:
			attr = kPGPAVAttribute_Initials;
			break;
		case 13:
			attr = kPGPAVAttribute_DNSName;
			break;
		case 14:
			attr = kPGPAVAttribute_IPAddress;
			break;
		case 15:
			attr = kPGPAVAttribute_CertType;
			break;
	}
	return attr;
}

	Boolean
CAVPairDialog::EditAVDialog(
	PGPAttributeValue *		avPair,
	PGPBoolean				newPair )
{
	DialogRef				editAVDialog;
	GrafPtr					savePort;
	Boolean					result = FALSE;
	CWhackWindowKind		whackWindowKind;
	
	GetPort( &savePort );
	editAVDialog = CPGPModalGrafPortView::CreateDialog( ppob_EditAVID );
	if( IsntNull( editAVDialog ) )
	{
#define kMaxAVEditDisabledAttrs		20

		ModalFilterUPP			filterUPP;
		MessageT				dismissMessage;
		short					itemHit = 0;
		LEditText *				attrEdit;
		Str255					pstr;
		LPopupButton *			attrPopup;
		PGPAttributeValue *		attrWalk;
		MenuHandle				attrMenu;
		PGPBoolean				disabledAttrs[kMaxAVEditDisabledAttrs];
		PGPUInt16				daIndex;
		
		mEditAVDialog = (CPGPModalGrafPortView *) GetWRefCon( editAVDialog );
		InitCursor();
		
		SetPort( editAVDialog );
		ShowWindow( editAVDialog );
		SelectWindow( editAVDialog );
		
		// Init
		attrEdit = (LEditText *)mEditAVDialog->FindPaneByID( edit_Attribute );
		attrEdit->AddListener( this );
		attrPopup = (LPopupButton *)mEditAVDialog->FindPaneByID( popup_Attribute );
		if( !newPair )
		{
			if( avPair->size > 0 )
			{
				pstr[0] = avPair->size;
				pgpCopyMemory( avPair->value.pointervalue, &pstr[1], avPair->size );
				attrEdit->SetDescriptor( pstr );
			}
			attrPopup->SetValue( AttributeToMenuIndex( avPair->attribute ) );
		}
		else
			pgpClearMemory( avPair, sizeof(PGPAttributeValue) );
		for( daIndex = 0; daIndex < kMaxAVEditDisabledAttrs; daIndex++ )
			disabledAttrs[daIndex] = FALSE;
		attrMenu = attrPopup->GetMacMenuH();
		for( attrWalk = mAVList; attrWalk != mEndAVList; attrWalk++ )
		{
			if( newPair || ( avPair->attribute != attrWalk->attribute ) )
			{
				PGPInt16	menuIndex;
				
				menuIndex = AttributeToMenuIndex( attrWalk->attribute );
				DisableItem( attrMenu, menuIndex );
				disabledAttrs[menuIndex - 1] = TRUE;
			}
		}
		if( newPair )
		{
			for( daIndex = 0; daIndex < kMaxAVEditDisabledAttrs; daIndex++ )
				if( !disabledAttrs[daIndex] )
				{
					attrPopup->SetValue( daIndex + 1 );
					break;
				}
			if( daIndex == kMaxAVEditDisabledAttrs )
			{
				SysBeep( 1 );
				goto error;
			}
		}
		attrEdit->GetDescriptor( pstr );
		if( pstr[0] == 0 )
			((LPushButton *)mEditAVDialog->FindPaneByID( button_OK ) )->Disable();
		mEditAVDialog->Refresh();
		
		filterUPP = NewModalFilterProc(
					CPGPModalGrafPortView::ModalFilterProcHandler );
		
		mEditAVDialog->SwitchTarget( attrEdit );
		mEditAVDialog->SetDismissMessage( msg_Nothing );

		while( itemHit == 0 )
			ModalDialog( filterUPP, &itemHit );
	
		dismissMessage = mEditAVDialog->GetDismissMessage();
		if( dismissMessage == msg_OK )
		{
			avPair->attribute = MenuIndexToAttribute( attrPopup->GetValue() );
			if( IsntNull( avPair->value.pointervalue ) )
				PGPFreeData( avPair->value.pointervalue );
			attrEdit->GetDescriptor( pstr );
			avPair->value.pointervalue = PGPNewData (
					PGPGetContextMemoryMgr( mPGPContext ), pstr[0], 0);
			if( IsntNull( avPair->value.pointervalue ) )
				pgpCopyMemory( &pstr[1], avPair->value.pointervalue, pstr[0] );
			avPair->size = pstr[0];
			result = TRUE;
		}
	error:
		DisposeRoutineDescriptor( filterUPP );
		delete mEditAVDialog;
		DisposeDialog( editAVDialog );
		mEditAVDialog = NULL;
	}
	SetPort( savePort );
	return result;
}

	Boolean
CAVPairTable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&,
	Int16				&,
	Str255				data,
	StyleParameter		& )
{
	PGPAttributeValue *	avPair;
	UInt32				len = sizeof(PGPAttributeValue *);
	TableIndexT			col;
	
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &avPair, len );
	switch( col )
	{
		case 1:		// Attribute
			RealPGPGetAVAttributeString( avPair->attribute, data );
			break;
		case 2:		// Value
			if( avPair->size > 0 )
			{
				data[0] = avPair->size;
				pgpCopyMemory( avPair->value.pointervalue, &data[1], avPair->size );
			}
			break;
	}
	return FALSE;
}

