/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CKeyWindow.cp,v 1.10 1999/03/10 02:34:55 heller Exp $
____________________________________________________________________________*/
#include <UGAColorRamp.h>
#include <UWindows.h>
#include <UReanimator.h>
#include <LWindowHeader.h>

#include "CKeyWindow.h"
#include "CKeyView.h"
#include "CPGPKeys.h"

#include "pgpErrors.h"
#include "pgpClientPrefs.h"

const Int16	kMinimumWindowHeight	=	150;

const PaneIDT	kToolbarPaneID		=	'Tlbr';


CKeyWindow::CKeyWindow()
{
}

CKeyWindow::CKeyWindow(LStream *inStream)
	:	LWindow(inStream)
{
}

CKeyWindow::~CKeyWindow()
{
	Rect		windowPos;
	PGPError	err;
	size_t		length;	
	
	length = sizeof(Rect);
	windowPos = UWindows::GetWindowContentRect(mMacWindowP);
	
	if(windowPos.bottom - windowPos.top >= kMinimumWindowHeight)
	{
		err = PGPSetPrefData(	gPrefRef,
								kPGPPrefPGPkeysMacMainWinPos,
								length,
								&windowPos);
		pgpAssertNoErr(err);
	}
}

	void
CKeyWindow::FinishCreateSelf()
{
	PGPError	err;
	Rect		*windPosPtr,
				windowPos,
				monitorIntersectRect,
				windowTitleBarRect;
	size_t		length;
	
	LWindow::FinishCreateSelf();
		
	LCommander::SetDefaultCommander( this );
	LPane::SetDefaultView( this );

	mKeyView = (CKeyView *)
		UReanimator::ReadObjects( 'PPob', kKeyViewResID );
	mToolbar = (LWindowHeader *)FindPaneByID( kToolbarPaneID );
	
	mKeyView->FinishCreate();
	mKeyView->ResizeFrameBy(1,2,false);
	PGPGetPrefBoolean( gPrefRef, kPGPPrefPGPkeysMacShowToolbar, &mShowToolbar );
	if( mShowToolbar )
		DoToolbar();

	length = sizeof(Rect);
	err = PGPGetPrefData(	gPrefRef,
							kPGPPrefPGPkeysMacMainWinPos,
							&length,
							&windPosPtr);
	if(IsntPGPError(err))
	{
		windowPos = *windPosPtr;
		PGPDisposePrefData(gPrefRef, windPosPtr);
		windowTitleBarRect = windowPos;
		windowTitleBarRect.bottom = windowTitleBarRect.top + 20;
		// sanity check
		if((windowPos.left > 0) && (windowPos.right > 0)
			&& (windowPos.top > 0) && (windowPos.bottom > 0)
			&& SectRect(&windowTitleBarRect, &qd.screenBits.bounds,
						&monitorIntersectRect))
		{
			DoSetBounds(windowPos);
		}
	}
	
	Show();
}

	void
CKeyWindow::DoToolbar()
{
	Rect	keyFrame,
			barFrame;
	Int16	barHeight;
	
	mKeyView->CalcLocalFrameRect( keyFrame );
	mToolbar->CalcLocalFrameRect( barFrame );
	barHeight = barFrame.bottom - barFrame.top;
	if( mShowToolbar )
	{
		mKeyView->PlaceInSuperFrameAt(	-1, barFrame.bottom - 2, true );
		mKeyView->ResizeFrameBy( 0, -barHeight + 1, true );
		mToolbar->Show();
	}
	else
	{
		mToolbar->Hide();
		mKeyView->PlaceInSuperFrameAt(	-1, -1, true );
		mKeyView->ResizeFrameBy( 0, barHeight - 1, true );
	}
}

	void
CKeyWindow::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	switch(inCommand) 
	{
		case cmd_Toolbar:
			outEnabled = true;
			outUsesMark = true;
			if( mShowToolbar )
				outMark = checkMark;
			else
				outMark = ' ';
			break;
		default:
			 LWindow::FindCommandStatus(inCommand, outEnabled,
										outUsesMark, outMark, outName);
			break;
	}
}

	Boolean
CKeyWindow::ObeyCommand(
	CommandT	inCommand,
	void		*ioParam)
{
	Boolean		cmdHandled = true;
	
	switch( inCommand )
	{
		case cmd_Toolbar:
			mShowToolbar = !mShowToolbar;
			PGPSetPrefBoolean( gPrefRef, kPGPPrefPGPkeysMacShowToolbar,
								mShowToolbar );
			DoToolbar();
			break;
		default:
			cmdHandled = LWindow::ObeyCommand(inCommand, ioParam);
			break;
	}
	
	return cmdHandled;
}

