/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CColumnTable.h,v 1.8 1999/04/19 03:34:55 wprice Exp $
____________________________________________________________________________*/
#pragma once

#include "CPGPHierarchyTable.h"
#include <LBroadcaster.h>
#include <LCommander.h>

#define kColumnTableMaxColumns		16

const MessageT	coltable_DoubleClick	= 'ctDB';
const MessageT	coltable_SelectChange	= 'ctSC';

class	CColumnTable	:	public CPGPHierarchyTable,
							public LBroadcaster,
							public LCommander
{
public:
	enum { class_ID = 'colT' };
						CColumnTable(LStream *inStream);
	virtual				~CColumnTable();
	void				FinishCreateSelf();
	virtual void		DrawSelf();
	virtual Boolean		HandleKeyPress(const EventRecord&	inKeyEvent);
	virtual Boolean		ObeyCommand(CommandT inCommand, void *ioParam);
	virtual void		ResizeFrameBy(
								Int16				inWidthDelta,
								Int16				inHeightDelta,
								Boolean				inRefresh);
	virtual void		SetSortColumn( TableIndexT col );

protected:
	virtual void		DrawCell(
								const STableCell		&inCell,
								const Rect				&inLocalRect);
	virtual void		HiliteCellActively(
								const STableCell	&inCell,
								Boolean				inHilite);
	virtual void		HiliteCellInactively(
								const STableCell	&inCell,
								Boolean				inHilite);
	virtual void		ClickSelf(
								const SMouseDownEvent &inMouseDown);
	virtual void		ClickCell(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);
	virtual void		SelectionChanged();
	virtual void		SetupColumns();
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style ) = 0;
	virtual Boolean		DrawCellCustom(
								const STableCell		&inCell,
								const Rect				&inLocalRect,
								Boolean					hilite );
	void				DrawIcon(
								const STableCell	&inCell,
								ResIDT				iconID,
								Rect				cellRect,
								UInt32				indentLevel,
								IconTransformType	transform );
	
private:
	void				DrawCell1(
								const STableCell	&inCell,
								const Rect			&inLocalRect,
								Boolean				hilite,
								Boolean				inactive );
	
	UInt32				mNumColumns;
	UInt16				mColumnWidths[kColumnTableMaxColumns];
	Boolean				mHas85Themes;
	Boolean				mAllowSelect;
	Boolean				mMultiSelect;
	Boolean				mHierarchical;
	UInt16				mStretchColumn;
	Int16				mRowHeight;
	TableIndexT			mSortColumn;
	Int16				mLowVertUpdate,
						mHighVertUpdate;
};

