/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CMenuSelectPatcher.cp,v 1.5 1999/04/02 09:01:07 jason Exp $
____________________________________________________________________________*/

#include <Traps.h>

#include <SetupA4.h>

#include "CMenuSelectPatcher.h"



// Define statics
CMenuSelectPatcher *	CMenuSelectPatcher::sMenuSelectPatcher = nil;

CMenuSelectPatcher::CMenuSelectPatcher()
{
	// Current version will only install one patch
	if (sMenuSelectPatcher == nil) {
		Patch(_MenuSelect, kProcInfo, (ProcPtr) MenuSelectCallback);
		sMenuSelectPatcher = this;
	}
}



CMenuSelectPatcher::~CMenuSelectPatcher()
{
}



	long
CMenuSelectPatcher::NewMenuSelect(
	Point	startPt)
{
	// default just calls through to the original
	return OldMenuSelect(startPt);
}



	long
CMenuSelectPatcher::OldMenuSelect(
	Point	startPt)
{
#if TARGET_RT_MAC_CFM
	return (long) ::CallUniversalProc(	mOldRoutine,
										kProcInfo,
										startPt);
#else
	return ((MenuSelectProc) mOldRoutine)(startPt);
#endif
}



	pascal long
CMenuSelectPatcher::MenuSelectCallback(
	Point	startPt)
{
	EnterCallback();

	long	result = 0;
	
	try {
		result = sMenuSelectPatcher->NewMenuSelect(startPt);
	}
	
	catch(...) {
	}
	
	ExitCallback();
	return result;
}
