/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPOpenPrefs.cp,v 1.20 1999/04/23 22:53:11 heller Exp $
____________________________________________________________________________*/

#include <Folders.h>
#include <TextUtils.h>

#include "PGPOpenPrefs.h"

#include "MacErrors.h"
#include "MacFiles.h"
#include "pgpClientPrefs.h"
#include "pgpAdminPrefs.h"
#include "pgpMem.h"
#include "pgpSDKPrefs.h"
#include "pgpFileSpec.h"
#include "CComboError.h"
#include "pgpClientErrors.h"

const ResID		kPrefsNameListID			=	14444;
const short		kClientPrefsFilenameStrIndex=	1;


	PGPError
PGPGetClientPrefsFileFSSpec(FSSpec *fileSpec)
{
	CComboError		err;
	
	PGPValidatePtr( fileSpec );
	
	err.err = FindPGPPreferencesFolder( kOnSystemDisk, &fileSpec->vRefNum,
						&fileSpec->parID);
	if( err.IsntError() )
	{
		GetIndString( fileSpec->name, kPrefsNameListID,
				kClientPrefsFilenameStrIndex);
		pgpAssert( fileSpec->name[0] != 0 );
	}
	
	return( err.ConvertToPGPError() );
}

	PGPError
PGPOpenClientPrefs(
	PGPMemoryMgrRef	memoryMgr,
	PGPPrefRef		*prefRef)
{
	CComboError		err;
	FSSpec			fsSpec;
	Boolean			created = FALSE;
	
	PGPValidatePtr( prefRef );
	*prefRef	= NULL;
	
	err.err = PGPGetClientPrefsFileFSSpec( &fsSpec );

	if ( err.IsntError() )
	{
		PFLFileSpecRef	fsRef	= NULL;

		err.pgpErr = PFLNewFileSpecFromFSSpec( memoryMgr, &fsSpec, &fsRef);
		if ( err.IsntError() )
		{
			PFLFileSpecMacMetaInfo		info;
			
			pgpClearMemory( &info, sizeof( info ) );
			
			info.fInfo.fileCreator	= kPGPMacFileCreator_Keys;
			info.fInfo.fileType		= 'pref';
			info.fInfo.location.h	= -1;
			info.fInfo.location.v	= -1;

			err.pgpErr = PFLSetFileSpecMetaInfo( fsRef, &info );
		}
		
		if ( err.IsntError() )
		{
			err.pgpErr = PGPOpenPrefFile(fsRef, clientDefaults, 
							clientDefaultsSize, prefRef);
			
			PFLFreeFileSpec( fsRef );
		}
	}
	
	return( err.ConvertToPGPError() );
}

	PGPError
PGPGetGroupsFileFSSpec(FSSpec *fileSpec)
{
	PGPError		err;
	PGPContextRef	context;
	
	PGPValidatePtr( fileSpec );

	err = PGPNewContext( kPGPsdkAPIVersion, &context );
	if( IsntPGPError( err ) )
	{
		err = PGPsdkLoadDefaultPrefs( context );
		if( IsntPGPError( err ) )
		{
			PGPFileSpecRef	fileSpecRef;
		
			err = PGPsdkPrefGetFileSpec( context, kPGPsdkPref_GroupsFile,
						&fileSpecRef );
			if( IsntPGPError( err ) )
			{
				err = PGPGetFSSpecFromFileSpec( fileSpecRef, fileSpec );
				
				PGPFreeFileSpec( fileSpecRef );
			}
		}
		
		PGPFreeContext( context );
	}
	
	return( err );
}

