/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: MacInternet.c,v 1.7 1999/05/03 08:15:49 heller Exp $
____________________________________________________________________________*/

#include <AppleEvents.h>
#include <Errors.h>
#include <InternetConfig.h>

#include "MacDesktop.h"
#include "MacFiles.h"
#include "MacInternet.h"
#include "MacProcesses.h"
#include "pgpMem.h"

enum
{
	kOpenURLEventClass	= 'WWW!',		/* These are Mac "standards" */
	kOpenURLEventID		= 'OURL'
};

static OSType	sBrowserCreators[] =
				{
					'MSIE',		/* Internet Explorer */
					'MOSS'		/* Netscape */
				 };

	static OSStatus
SendURLToProcess(
	ConstStringPtr 		theURL,
	ProcessSerialNumber	appPSN)
{
	AEDesc		addressDesc;
	OSStatus	status;
	
	status = AECreateDesc( typeProcessSerialNumber, &appPSN, sizeof( appPSN ),
									&addressDesc );
	if( IsntErr( status ) )
	{
		AppleEvent	theAppleEvent;
		
		status = AECreateAppleEvent( kOpenURLEventClass,
					kOpenURLEventID, &addressDesc,
					kAutoGenerateReturnID, kAnyTransactionID, &theAppleEvent );
		if( IsntErr( status ) )
		{
			status = AEPutParamPtr( &theAppleEvent, keyDirectObject, typeChar,
								&theURL[1], theURL[0] );
			if( IsntErr( status ) )
			{
				AppleEvent	replyEvent;
				
				status = AESend( &theAppleEvent,
						&replyEvent, kAENoReply | kAECanInteract,
						kAENormalPriority, kAEDefaultTimeout, nil, nil );
				if( IsntErr( status ) )
				{
					SetFrontProcess( &appPSN );
				}
			}
			
			(void) AEDisposeDesc( &theAppleEvent );
		}
		
		(void) AEDisposeDesc( &addressDesc );
	}

	return( status );
}

	static OSStatus
OpenURLWithActiveBrowser(ConstStringPtr theURL)
{
	UInt32				browserIndex;
	UInt32				numBrowsers;
	ProcessSerialNumber	browserPSN;
	OSStatus			status;
	
	pgpAssertAddrValid( theURL, uchar );

	numBrowsers 	= sizeof( sBrowserCreators )/sizeof( sBrowserCreators[0] );
	status			= fnfErr;
		
	for( browserIndex = 0; browserIndex < numBrowsers; browserIndex++ )
	{
		if( FindProcess( 'APPL', sBrowserCreators[browserIndex], &browserPSN,
				nil, nil, nil ) )
		{
			status = SendURLToProcess( theURL, browserPSN );
			break;
		}
	}
	
	return( status );
}

	static OSStatus
OpenURLWithInactiveBrowser(ConstStringPtr theURL)
{
	UInt32		browserIndex;
	UInt32		numBrowsers;
	Boolean		foundBrowser;
	OSStatus	status;
	FSSpec		browserSpec;
	OSType		browserCreator;
	
	pgpAssertAddrValid( theURL, uchar );

	numBrowsers = sizeof( sBrowserCreators ) / sizeof( sBrowserCreators[0] );
	foundBrowser 	= FALSE;
	status 			= fnfErr;
	
	/* Try the full browser list on local volumes only,
		then retry the list for all volumes (local and remote).
		This means well find a locat Internet Explorer before
		a remote Navigator. */
	for( browserIndex = 0; browserIndex < numBrowsers; browserIndex++ )
	{
		if( FindApplication( 'APPL', sBrowserCreators[browserIndex],
						kFindAppOnLocalVolumes, &browserSpec ) )
		{
			foundBrowser 	= TRUE;
			browserCreator	= sBrowserCreators[browserIndex];
			break;
		}
	}

	if( ! foundBrowser )
	{
		for( browserIndex = 0; browserIndex < numBrowsers; browserIndex++ )
		{
			if( FindApplication( 'APPL', sBrowserCreators[browserIndex],
							kFindAppOnRemoteVolumes, &browserSpec ) )
			{
				foundBrowser 	= TRUE;
				browserCreator	= sBrowserCreators[browserIndex];
				break;
			}
		}
	}
	
	if( foundBrowser )
	{
		LaunchParamBlockRec	launchPB;

		pgpClearMemory( &launchPB, sizeof( launchPB ) );
	
		launchPB.launchBlockID			= extendedBlock;
		launchPB.launchEPBLength		= extendedBlockLen;
		launchPB.launchFileFlags		= 0;
		launchPB.launchControlFlags		= launchContinue | launchNoFileFlags;
		launchPB.launchAppSpec			= &browserSpec;
		launchPB.launchAppParameters	= nil;
		
		status = LaunchApplication( &launchPB );
		if( IsntErr( status ) )
		{
			status = SendURLToProcess( theURL, launchPB.launchProcessSN );
		}
	}
	
	return( status );
}

	static OSStatus
OpenURLWithInternetConfig(
	ConstStringPtr 	theURL,
	OSType			appCreator)
{
	OSStatus	err = noErr;
	
#if TARGET_RT_MAC_CFM
	if( (void *) ICStart == (void *) kUnresolvedCFragSymbolAddress )
		err = cfragNoLibraryErr;
#endif

	if( IsntErr( err ) )
	{
		ICInstance	icInstance = NULL;
		
		err = ICStart( &icInstance, appCreator );
		if( IsntErr( err ) )
		{
			err = ICFindConfigFile( icInstance, 0, NULL );
			if( IsntErr( err ) )
			{
				long	selStart	= 0;
				long	selEnd		= theURL[0];
				
				err = ICLaunchURL( icInstance, "\p", (Ptr) &theURL[1], theURL[0], &selStart, &selEnd );
			}
			
			(void) ICStop( icInstance );
		}
	}
	
	return( err );
}

	OSStatus
OpenURL(
	ConstStringPtr 	theURL,
	OSType			appCreator)
{
	OSStatus	status;
	
	pgpAssertAddrValid( theURL, uchar );
	
	status = OpenURLWithInternetConfig( theURL, appCreator );
	if( IsErr( status ) )
	{
		status = OpenURLWithActiveBrowser( theURL );
		if( IsErr( status ) )
		{
			status = OpenURLWithInactiveBrowser( theURL );
		}
	}
	
	return( status );
}