/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPKeyServerGrafPort.h,v 1.6 1999/03/10 02:36:56 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "pgpKeyServer.h"
#include "pgpUserInterface.h"

#include "CPGPUIGrafPortView.h"

class CPGPKeyServerDialogOptions;
class LStaticText;

class CPGPKeyServerGrafPortView : public CPGPUIGrafPortView
{
public:

	enum
	{
		class_ID = 'KGPV',
		
		kServerNamePaneID	= 'Srvr',
		kStatusPaneID		= 'Stat',
		kKeyNamePaneID		= 'Key ',
		kProgressBarPaneID	= 'Prog'
		
	};

						CPGPKeyServerGrafPortView(LStream *inStream);
	virtual				~CPGPKeyServerGrafPortView();

	virtual void		DoIdle(const EventRecord &inMacEvent);
	PGPError			SetOptions(PGPContextRef context, 
								CPGPKeyServerDialogOptions *options);
	
	static PGPError		KeyServerCallbackProc(PGPContextRef context,
								struct PGPEvent *event,
								PGPUserValue userValue);
		
protected:

	LStaticText			*mServerNameText;
	LStaticText			*mServerStatusText;
	LStaticText			*mKeyNameText;
	
	virtual void		FinishCreateSelf(void);
	virtual PGPError	KeyServerCallback(PGPEvent *event);
	
private:
	
	ModalFilterUPP						mFilterUPP;
	PGPUInt32							mLastEventTicks;
	PGPKeyServerState					mLastKeyServerState;
	PGPKeyServerRef						mLastKeyServer;
	const CPGPKeyServerDialogOptions 	*mOptions;
};

