/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPSignPassphraseGrafPort.cp,v 1.11 1999/03/10 02:37:53 heller Exp $
____________________________________________________________________________*/

#include <LStaticText.h>
#include <PP_Messages.h>

#include "MacStrings.h"
#include "pgpErrors.h"
#include "pgpMem.h"
#include "pgpPassphraseUtils.h"

#include "CPassphraseEdit.h"
#include "CPGPSignPassphraseGrafPort.h"
#include "CPrivateKeysPopup.h"
#include "PGPsdkUILibDialogs.h"
#include "PGPsdkUILibUtils.h"

CPGPSigningPassphraseGrafPortView::
	CPGPSigningPassphraseGrafPortView(LStream *inStream)
	: CPGPKeySetPassphraseGrafPortView(inStream)
{
	mOptions 			= NULL;
	mShowingSplitKey	= FALSE;
}

CPGPSigningPassphraseGrafPortView::~CPGPSigningPassphraseGrafPortView()
{
}

	void
CPGPSigningPassphraseGrafPortView::FinishCreateSelf()
{
	CPGPKeySetPassphraseGrafPortView::FinishCreateSelf();
	
	mKeysPopup = (CPrivateKeysPopup *) FindPaneByID( kKeysPopupPaneID );
	pgpAssertAddrValid( mKeysPopup, VoidAlign );
	
	mPassphraseEdit = (CPassphraseEdit *) FindPaneByID(
							kPassphraseEditPaneID );
	pgpAssertAddrValid( mPassphraseEdit, VoidAlign );
	
	mSplitMsgText = (LStaticText *) FindPaneByID( kSplitMsgCaptionPaneID );
	pgpAssertAddrValid( mSplitMsgText, VoidAlign );
	
	mKeysPopup->AddListener( this );
}

	PGPError
CPGPSigningPassphraseGrafPortView::SetOptions(
	PGPContextRef						context,
	CPGPSigningPassphraseDialogOptions	*options)
{
	PGPError	err = kPGPError_NoErr;
	
	PGPValidatePtr( options );
	
	err = CPGPKeySetPassphraseGrafPortView::SetOptions( context, options );
	if( IsntPGPError( err ) )
	{
		mOptions = options;
		
		pgpAssertAddrValid( mOptions->mPassphraseKeyPtr, PGPKeyRef );
		pgpAssert( PGPKeySetRefIsValid( mOptions->mKeySet ) );
		
		mKeysPopup->BuildKeyList( mOptions->mKeySet,
						mOptions->mDefaultKey );
		SwitchTarget( mPassphraseEdit );
		AdjustDisplay();
	}
	
	return( err );
}


	PGPKeyRef
CPGPSigningPassphraseGrafPortView::FindKeyForPassphrase(
	PGPKeySetRef 	keySet,
	const char 		*passphrase)
{
	PGPKeyRef	passphraseKey;
	
	passphraseKey = GetKeyForPassphrase( keySet, passphrase, TRUE );
	if ( PGPKeyRefIsValid( passphraseKey ) )
	{
		char		cName[256];
		PGPError	err	= kPGPError_NoErr;
		PGPSize		len;

		/* Confirm the matching key */
		
		err = PGPGetPrimaryUserIDNameBuffer( passphraseKey,
					sizeof( cName ), cName, &len );
		if( IsntPGPError( err ) )
		{
			MessageT	result;
			Str255		pName;
			
			SysBeep( 1 );
			
			CToPString( cName, pName );
			result	= PGPUIWarningAlert(
						kPGPUIGenericOKCancelAlert,
						kPGPLibDialogsStringListResID,
						kConfirmMatchingKeyStrIndex, pName );
					
			if ( result != msg_OK )
			{
				passphraseKey = kInvalidPGPKeyRef;
			}
		}
	}
	
	return( passphraseKey );
}

	PGPKeyRef
CPGPSigningPassphraseGrafPortView::GetPassphraseKey(void)
{
	return( mKeysPopup->GetSigningKey() );
}

	void
CPGPSigningPassphraseGrafPortView::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	switch( inMessage )
	{
		case kKeysPopupPaneID:
			AdjustDisplay();
			break;
			
		default:
			CPGPKeySetPassphraseGrafPortView::ListenToMessage( inMessage,
						ioParam );
			break;
	}
}

	void
CPGPSigningPassphraseGrafPortView::AdjustDisplay(void)
{
	PGPKeyRef	signingKey;
	
	signingKey = GetPassphraseKey();
	if( PGPKeyRefIsValid( signingKey ) )
	{
		PGPBoolean	isSplitKey;
		PGPError	err;
		
		err = PGPGetKeyBoolean( signingKey, kPGPKeyPropIsSecretShared,
					&isSplitKey );
		pgpAssertNoErr( err );
		
		if( isSplitKey && ! mShowingSplitKey )
		{
			mPassphraseEdit->Hide();
			mSplitMsgText->Show();
			
			mShowingSplitKey = TRUE;
			
		}
		else if( ! isSplitKey )
		{
			PGPBoolean	needsPassphrase;

			err = PGPGetKeyBoolean( signingKey, kPGPKeyPropNeedsPassphrase,
						&needsPassphrase );
			pgpAssertNoErr( err );

			mSplitMsgText->Hide();
			mShowingSplitKey = FALSE;

			if( needsPassphrase )
			{
				if( ! mPassphraseEdit->IsVisible() )
				{
					mPassphraseEdit->Show();
					SwitchTarget( mPassphraseEdit );
				}
			}
			else
			{
				mPassphraseEdit->Hide();
			}
		}
	}
}

	Boolean
CPGPSigningPassphraseGrafPortView::VerifyPassphrase(void)
{
	Boolean	valid;
	
	if( mShowingSplitKey )
	{
		valid = TRUE;
		
		*mOptions->mPassphraseKeyPtr = GetPassphraseKey();
	}
	else
	{
		valid = CPGPKeySetPassphraseGrafPortView::VerifyPassphrase();
	}

	return( valid );
}

	MessageT
CPGPSigningPassphraseGrafPortView::HandleMessage(MessageT theMessage)
{
	theMessage = CPGPKeySetPassphraseGrafPortView::HandleMessage(theMessage);
	if( theMessage == msg_OK &&
		mShowingSplitKey &&
		IsntPGPError( mDialogError ) )
	{
		mDialogError = kPGPError_KeyUnusableForSignature;
	}
	
	return( theMessage );
}