/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPsdkUILibUtils.h,v 1.9 1999/03/10 02:55:59 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <Files.h>
#include <Memory.h>
#include <Quickdraw.h>

#include <LCommander.h>
#include <LView.h>

#include "pflPrefs.h"
#include "pgpBase.h"
#include "pgpPubTypes.h"
#include "CComboError.h"

typedef struct PGPsdkUILibState
{
	GrafPtr			savedPort;
	THz				savedZone;
	short			savedResFile;
	PGPBoolean		savedResLoad;
	
	LView			*savedView;
	LCommander		*savedCommander;
	
} PGPsdkUILibState;

PGP_BEGIN_C_DECLARATIONS

PGPError	EnterPGPsdkUILib(PGPContextRef context, PGPsdkUILibState *state);
void		ExitPGPsdkUILib(const PGPsdkUILibState *state);
Boolean		HaveNetworkLib(void);
OSStatus	SetLibraryFSSpec(const FSSpec *fileSpec);

PGP_END_C_DECLARATIONS
