/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CMacTCPTCPSocket.cp,v 1.19 1999/03/10 02:34:42 heller Exp $
____________________________________________________________________________*/

#include <Devices.h>
#include <string.h>

#include "pgpMem.h"

#include "CMacTCPTCPSocket.h"



const SInt32	kReceiveBufferSize	=	16*1024;



CMacTCPTCPSocket::CMacTCPTCPSocket()
		: mStream(nil), mReceiveBuffer(nil), mConnectionAborted(false),
		  mIsListening(false), mNotifyProcUPP(nil), mFirstListenQ(nil),
		  mLastListenQ(nil), mNext(nil)
{
	TCPiopb	paramBlock;
	
	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.csParam.create.rcvBuff =
		mReceiveBuffer = new char[kReceiveBufferSize];
	if (mReceiveBuffer == nil) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	paramBlock.csParam.create.rcvBuffLen = kReceiveBufferSize;
	mNotifyProcUPP = NewTCPNotifyProc(TCPNotifyProc);
	if (mNotifyProcUPP == nil) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	paramBlock.csParam.create.notifyProc = mNotifyProcUPP;
	paramBlock.csParam.create.userDataPtr = (Ptr) this;
	ProcessCommand(TCPCreate, (IPParamBlock *) &paramBlock);
	mStream = paramBlock.tcpStream;
	mSocketType = kPGPSocketTypeStream;
}



CMacTCPTCPSocket::~CMacTCPTCPSocket()
{
	if (mStream != nil) {
		TCPiopb	paramBlock;
		
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.ioCRefNum = sRefNum;
		paramBlock.tcpStream = mStream;
		if (mAbort) {
			paramBlock.csCode = TCPAbort;
		} else {
			paramBlock.csCode = TCPClose;
		}
		::PBControlSync((ParmBlkPtr) &paramBlock);
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.ioCRefNum = sRefNum;
		paramBlock.tcpStream = mStream;
		paramBlock.csCode = TCPRelease;
		::PBControlSync((ParmBlkPtr) &paramBlock);
	}
		
	CMacTCPTCPSocket * nextSocket;
	
	for (CMacTCPTCPSocket * theSocket = mFirstListenQ;
	theSocket != nil; theSocket = nextSocket) {
		nextSocket = theSocket->mNext;
		theSocket->mAbort = true;
		theSocket->Close();
	}
	delete [] mReceiveBuffer;
	::DisposeRoutineDescriptor(mNotifyProcUPP);
}



	void
CMacTCPTCPSocket::Connect(
	const PGPSocketAddressInternet *	inAddress)
{
	if (mIsListening) {
		ThrowPGPError_(kPGPError_SocketsAddressInUse);
	}

	TCPiopb	paramBlock;
	
	mConnectionAborted = false;
	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.tcpStream = mStream;
	paramBlock.csParam.open.userDataPtr = (Ptr) this;
	paramBlock.csParam.open.remoteHost = inAddress->sin_addr.s_addr;
	paramBlock.csParam.open.remotePort = inAddress->sin_port;
	paramBlock.csParam.open.localPort = mBoundPort;
	ProcessCommand(TCPActiveOpen, (IPParamBlock *) &paramBlock);
	mConnected = true;
}


	SInt32
CMacTCPTCPSocket::Send(
	const void *	inBuffer,
	SInt32			inLength,
	SInt32			inFlags)
{
	SInt32			toSend = inLength;
	char *			next = (char *) inBuffer;
	TCPiopb			paramBlock;
	wdsEntry		wds[2] = {	{0, 0},
								{0, 0}};
	(void) inFlags;
	
	while (toSend > 0) {
		wds[0].length = (toSend > USHRT_MAX) ? USHRT_MAX : toSend;
		wds[0].ptr = next;
		toSend -= wds[0].length;
		next += wds[0].length;
		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.tcpStream = mStream;
		paramBlock.csParam.send.wdsPtr = (Ptr) wds;
		ProcessCommand(TCPSend, (IPParamBlock *) &paramBlock);
	}

	return inLength;
}



	SInt32
CMacTCPTCPSocket::SendTo(
	const void *						inBuffer,
	SInt32								inLength,
	const PGPSocketAddressInternet *	inAddress)
{
	(void) inAddress;
	
	return Send(inBuffer, inLength, kPGPSendFlagNone);
}



	SInt32
CMacTCPTCPSocket::Receive(
	void *	outBuffer,
	SInt32	inLength,
	SInt32	inFlags)
{
	SInt32	result = 0;
	TCPiopb	paramBlock;
	
	(void) inFlags;
	
	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.tcpStream = mStream;
	paramBlock.csParam.receive.rcvBuff = (Ptr) outBuffer;
	paramBlock.csParam.receive.rcvBuffLen =
		(inLength > USHRT_MAX) ? USHRT_MAX : inLength;
	try {
		ProcessCommand(TCPRcv, (IPParamBlock *) &paramBlock);
		result = paramBlock.csParam.receive.rcvBuffLen;
	}
	
	catch (PGPError exception) {
		if (exception != connectionClosing) {
			throw;
		}
	}

	return result;
}



	SInt32
CMacTCPTCPSocket::ReceiveFrom(
	void *						outBuffer,
	SInt32						inSize,
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	(void) outAddress;

	if (ioAddressLength != 0) {
		*ioAddressLength = 0;
	}

	return Receive(outBuffer, inSize, kPGPReceiveFlagNone);	
}



	Boolean
CMacTCPTCPSocket::IsReadable()
{
	Boolean	result = false;
	TCPiopb	paramBlock;
	
	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.ioCRefNum = sRefNum;
	paramBlock.csCode = TCPStatus;
	if (mIsListening) {
		paramBlock.tcpStream = mFirstListenQ->mStream;
		::PBControlSync((ParmBlkPtr) &paramBlock);
		if (paramBlock.csParam.status.connectionState != 2) {
			result = true;
		}
	} else {
		paramBlock.tcpStream = mStream;
		::PBControlSync((ParmBlkPtr) &paramBlock);

		if ((paramBlock.csParam.status.amtUnreadData > 0)
		|| (paramBlock.csParam.status.connectionState >= 10)) {
			result = true;
		}
	}
	
	return result;
}



	Boolean
CMacTCPTCPSocket::IsWriteable()
{
	Boolean	result = false;
	TCPiopb	paramBlock;
	
	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.ioCRefNum = sRefNum;
	paramBlock.tcpStream = mStream;
	paramBlock.csCode = TCPStatus;
	::PBControlSync((ParmBlkPtr) &paramBlock);

	if ((paramBlock.csParam.status.connectionState == 8)
	|| (paramBlock.csParam.status.connectionState == 14)) {
		result = true;
	}
	
	return result;
}



	void
CMacTCPTCPSocket::PushListenQ()
{
	CMacTCPTCPSocket *	childSocket;
	OSStatus			err;

	childSocket = new CMacTCPTCPSocket;
	if (childSocket == nil) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	childSocket->mBoundPort = mBoundPort;
	childSocket->mBoundAddress = mBoundAddress;
	childSocket->mBound = true;
	
	pgpClearMemory(&childSocket->mListenParams,
			sizeof(childSocket->mListenParams));
	childSocket->mListenParams.ioCRefNum = sRefNum;
	childSocket->mListenParams.csCode = TCPPassiveOpen;
	childSocket->mListenParams.tcpStream = childSocket->mStream;
	childSocket->mListenParams.csParam.open.localPort = mBoundPort;
	err = ::PBControlAsync((ParmBlkPtr) &childSocket->mListenParams);
	if (err != noErr) {
		delete childSocket;
		ThrowPGPError_(err);
	}
	if (mFirstListenQ == nil) {
		mFirstListenQ = childSocket;
	}
	if (mLastListenQ != nil) {
		mLastListenQ->mNext = childSocket;
	}
	mLastListenQ = childSocket;
}


	void
CMacTCPTCPSocket::Listen(
	SInt32	inMaxBacklog)
{
	if (! mBound) {
		ThrowPGPError_(kPGPError_SocketsNotBound);
	}
	
	if (mIsListening || mConnected) {
		ThrowPGPError_(kPGPError_SocketsAddressInUse);
	}

	// Free up this sockets resources
	TCPiopb	paramBlock;
		
	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.ioCRefNum = sRefNum;
	paramBlock.tcpStream = mStream;
	paramBlock.csCode = TCPRelease;
	::PBControlSync((ParmBlkPtr) &paramBlock);
	mStream = nil;
	delete[] mReceiveBuffer;
	mReceiveBuffer = nil;
	
	while (inMaxBacklog > 0) {
		PushListenQ();
		inMaxBacklog--;
	}
	
	mIsListening = true;
}

	CSocket *
CMacTCPTCPSocket::Accept(
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	if (! mIsListening) {
		ThrowPGPError_(kPGPError_SocketsOperationNotSupported);
	}
	
	TCPiopb		paramBlock;
	PGPError	pgpError;

	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.ioCRefNum = sRefNum;
	paramBlock.csCode = TCPStatus;
	paramBlock.tcpStream = mFirstListenQ->mStream;
	::PBControlSync((ParmBlkPtr) &paramBlock);
	while ((paramBlock.csParam.status.connectionState == 2)
	&& (! mAbort)) {
		mInCallback = true;
		pgpError = CallIdleEventHandler();
		if (IsPGPError(pgpError)) {
			Close();
			mInCallback = false;
			break;
		}
		mInCallback = false;

		pgpClearMemory(&paramBlock, sizeof(paramBlock));
		paramBlock.ioCRefNum = sRefNum;
		paramBlock.csCode = TCPStatus;
		paramBlock.tcpStream = mFirstListenQ->mStream;
		::PBControlSync((ParmBlkPtr) &paramBlock);
	}
	if (mAbort) {
		Close();
		ThrowPGPError_(kPGPError_UserAbort);
	}
	
	CMacTCPTCPSocket *	theSocket = mFirstListenQ;
	
	mFirstListenQ = mFirstListenQ->mNext;
	outAddress->sin_family = kPGPAddressFamilyInternet;
	outAddress->sin_port = paramBlock.csParam.status.remotePort;
	outAddress->sin_addr.s_addr = paramBlock.csParam.status.remoteHost;
	*ioAddressLength = sizeof(PGPSocketAddressInternet);
	theSocket->mConnected = true;
	theSocket->mBound = true;
	theSocket->mBoundPort = mBoundPort;
	theSocket->mBoundAddress = mBoundAddress;

	try {
		PushListenQ();
	}
	
	catch (...) {
		delete theSocket;
		throw;
	}
	
	return theSocket;
}



	void
CMacTCPTCPSocket::IOControlSocket(
	SInt32		inCommand,
	UInt32 *	ioParam)
{
	switch (inCommand) {
		case kPGPSocketCommandGetUnreadData:
		{
			TCPiopb	paramBlock;
			
			pgpClearMemory(&paramBlock, sizeof(paramBlock));
			paramBlock.ioCRefNum = sRefNum;
			paramBlock.tcpStream = mStream;
			paramBlock.csCode = TCPStatus;
			::PBControlSync((ParmBlkPtr) &paramBlock);
			
			*ioParam = paramBlock.csParam.status.amtUnreadData;
		}
		break;
	}
}

	pascal void
CMacTCPTCPSocket::TCPNotifyProc(
	StreamPtr			inTCPStream,
	UInt16				inEventCode,
	Ptr					inUserData,
	UInt16				inTermReason,
	struct ICMPReport *	inICMPMsg)
{
	(void) inTCPStream;
	(void) inICMPMsg;

	if ((inEventCode == TCPTerminate)
	&& ((inTermReason == TCPRemoteAbort)
	|| (inTermReason == TCPULPTimeoutTerminate))
	&& (inUserData != 0)) {
		((CMacTCPTCPSocket *) inUserData)->mConnectionAborted = true;
	}
}



	void
CMacTCPTCPSocket::GetSocketName(
	PGPSocketAddressInternet *	outName)
{
	TCPiopb	paramBlock;

	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.ioCRefNum = sRefNum;
	paramBlock.tcpStream = mStream;
	paramBlock.csCode = TCPStatus;
	::PBControlSync((ParmBlkPtr) &paramBlock);

	if ((paramBlock.csParam.status.connectionState >= 8)
	&& (paramBlock.csParam.status.connectionState <= 18)) {
		pgpClearMemory(outName, sizeof(PGPSocketAddressInternet));
		outName->sin_family = kPGPAddressFamilyInternet;
		outName->sin_port = paramBlock.csParam.status.localPort;
		outName->sin_addr.s_addr = paramBlock.csParam.status.localHost;
	} else {
		CMacTCPInternetSocket::GetSocketName(outName);
	}
}



	void
CMacTCPTCPSocket::GetPeerName(
	PGPSocketAddressInternet *	outName)
{
	TCPiopb	paramBlock;

	pgpClearMemory(&paramBlock, sizeof(paramBlock));
	paramBlock.ioCRefNum = sRefNum;
	paramBlock.tcpStream = mStream;
	paramBlock.csCode = TCPStatus;
	::PBControlSync((ParmBlkPtr) &paramBlock);

	if ((paramBlock.csParam.status.connectionState >= 8)
	&& (paramBlock.csParam.status.connectionState <= 18)) {
		pgpClearMemory(outName, sizeof(PGPSocketAddressInternet));
		outName->sin_family = kPGPAddressFamilyInternet;
		outName->sin_port = paramBlock.csParam.status.remotePort;
		outName->sin_addr.s_addr = paramBlock.csParam.status.remoteHost;
	} else {
		ThrowPGPError_(kPGPError_SocketsNotConnected);
	}
}
