// ===========================================================================
//	FrDropApp.cp			   (C)1994-1998 Metrowerks Inc. All rights reserved.
// ===========================================================================
//
//	A very simple Application-level class for a drag-and-drop file filter
//	program. The OpenDocument() function gets called with the FSSpec for
//	each file dropped on the program's icon in the Finder.
//
//	This class uses pieces of the PowerPlant library to handle AppleEvents
//	and work with Files.
//
//	To do something useful, replace the OpenDocument() function (or create
//	a subclass which overrides OpenDocument()).
//

#include "FrDropApp.h"
#include <LModelDirector.h>
#include <LFileStream.h>
#include <UAppleEventsMgr.h>

const ResIDT	ALRT_NoFiles	= 200;

SInt32 gRunTime;

// ===========================================================================
//		 Main Program
// ===========================================================================

void main(void)
{
	FrDropApp	theApp;
	theApp.Run();
}


// ===========================================================================
//		 FrDropApp Class
// ===========================================================================

FrDropApp::FrDropApp()
{
	MaxApplZone();

	InitGraf((Ptr) &qd.thePort);		// Toolbox Managers
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(nil);
	gRunTime = LMGetTime();
	
	new LModelDirector(this);			// AppleEvent Handlers
	
	mRunning = true;
}


void
FrDropApp::Run()
{
		// This program has no user interface. We only care
		// about AppleEvents.
		
	while (mRunning) {
		EventRecord		macEvent;
		if (WaitNextEvent(everyEvent, &macEvent, 2, nil)) {
		
			if (macEvent.what == kHighLevelEvent) {
				AEProcessAppleEvent(&macEvent);
			}
		}
	}
}


void
FrDropApp::HandleAppleEvent(
	const AppleEvent	&inAppleEvent,
	AppleEvent			&outAEReply,
	AEDesc				&outResult,
	long				inAENumber)
{
	switch (inAENumber) {
	
		case ae_OpenApp:
			StartUp();
			break;
			
		case ae_OpenDoc:
			DoAEOpenDoc(inAppleEvent, outAEReply, inAENumber);
			break;
			
		case ae_Quit:
			DoQuit();
			break;
			
		default:
			LModelObject::HandleAppleEvent(inAppleEvent, outAEReply, outResult, inAENumber);
			break;
	}
}


void
FrDropApp::StartUp()
{
		// User double-clicked on the Program's icon
		
		// This program only works when files are dragged on the
		// program's icon in the Finder. So we just display an
		// Alert (which could have instructions for using the program)
		// and then quit.
	
	//::Alert(ALRT_NoFiles, nil);
	DoQuit();
}


void
FrDropApp::DoAEOpenDoc(
	const AppleEvent	&inAppleEvent,
	AppleEvent&			/* outAEReply */,
	long				/* inAENumber */)
{
	AEDescList	docList;
	OSErr		err = AEGetParamDesc(&inAppleEvent, keyDirectObject,
							typeWildCard, &docList);
	if (err != noErr) Throw_(err);
	
	Int32	numDocs;
	err = AECountItems(&docList, &numDocs);
	if (err != noErr) Throw_(err);
	
		// Loop through all items in the list
			// Extract descriptor for the document
			// Coerce descriptor data into a FSSpec
			// Tell Program object to open document
		
	for (Int32 i = 1; i <= numDocs; i++) {
		AEKeyword	theKey;
		DescType	theType;
		FSSpec		theFileSpec;
		Size		theSize;
		err = AEGetNthPtr(&docList, i, typeFSS, &theKey, &theType,
							(Ptr) &theFileSpec, sizeof(FSSpec), &theSize);
		if (err != noErr) Throw_(err);
		OpenDocument(&theFileSpec);
	}
	
	AEDisposeDesc(&docList);
	
	DoQuit();
}


void
FrDropApp::OpenDocument(
	FSSpec	*inMacFSSpec)
{
	OSStatus	err	= noErr;
	HFileInfo	pb;
	short		refNum;
	short		oldResFile;
	
	oldResFile = CurResFile();
	refNum = FSpOpenResFile( inMacFSSpec, fsRdWrPerm );
	if( refNum != -1 )
	{
		Handle res;
		
		UseResFile( refNum );
		res = Get1Resource( 'mcvs', 128 );
		if( res )
		{
			RemoveResource( res );
			DisposeHandle( res );
		}
		UseResFile( oldResFile );
		CloseResFile( refNum );
	}
	pb.ioNamePtr = (unsigned char *)inMacFSSpec->name;
	pb.ioVRefNum = inMacFSSpec->vRefNum;
	pb.ioDirID = inMacFSSpec->parID;
	pb.ioFDirIndex = 0;
	if ( PBGetCatInfoSync( (CInfoPBPtr)&pb ) == noErr )
	{
		pb.ioNamePtr = (unsigned char *)inMacFSSpec->name;
		pb.ioVRefNum = inMacFSSpec->vRefNum;
		pb.ioDirID = inMacFSSpec->parID;
		pb.ioFDirIndex = 0;
		pb.ioFlCrDat = gRunTime;
		pb.ioFlMdDat = gRunTime;
		if( pb.ioFlFndrInfo.fdType == 'APPL' )
			pb.ioFlFndrInfo.fdFlags |= kHasCustomIcon;
		err = PBSetCatInfoSync( (CInfoPBPtr)&pb );
		if( err )
		{
			Str255 p;
			
			NumToString( err, p );
			DebugStr( p );
		}
	}
}


void
FrDropApp::DoQuit()
{
	mRunning = false;
}
