/*
 * Lynx - Hypertext navagation system
 *
 *   (c) Copyright 1992, 1993, 1994 University of Kansas
 */

/*******************************************************************
 * There are three sections to this document
 *  Section 1.  Things you MUST change or verify
 *	Section 1a)  VMS specific things
 *	Section 1b)  UNIX specific things
 *	Section 1c)  ALL Platforms
 *
 *  Section 2.  Things you should probably check!
 *
 *  Section 3.  Things you should only change after you have a good
 *              understanding of the program!
 *
 */

#ifndef USERDEFS_H
#define USERDEFS_H

/*******************************************************************
 * Things you must change
 *  Section 1. 
 */

/*******************************************************************
 * Things you must change  VMS specific
 *  Section 1a). 
 */
#ifdef VMS
/**************************
 * TEMP_SPACE is where Lynx tempory cache files will be placed.
 * Tempory files are removed automatically as long as nothing
 * goes terribly wrong :)
 */
#define TEMP_SPACE "sys$scratch:"

/**************************
 * LYNX_CFG_FILE is the location and name of the lynx system
 * configuration file.
 */
#define LYNX_CFG_FILE "sys$public:lynx.cfg"

/**************************
 * the full path and name of the xloadimage command
 * put 'echo' or something like it here if you don't have it
 * you may also use 'xv' or anything that will handle GIF,
 * TIFF and other popular image formats
 */
#define XLOADIMAGE_COMMAND "xv"

/**************************
 * the full path and name of the standard VMS "mail" command
 * The mail command will be spawned as a subprocess of lynx
 * and used to send replies and error messages.
 * SYSTEM_MAIL must be able to accept a subject line through
 * the use of the /subject="SUBJECT" option
 * if your mailer uses anonther syntax, some hacking of
 * the "mailmsg.c" and "reply_by_mail.c" files may be required.
 */
#define SYSTEM_MAIL "mail"

/*************************
 * below is the argument for a sprintf command that will
 * add "in%""ADDRESS""" to the internet mail address given by the user.
 * It is structured for PMDF's in%"INTERNET_ADDRESS"
 * scheme.   The %s is replaced with the address given by the user.
 */
#define MAIL_ADRS "\"in%%\"\"%s\"\"\""

/*************************
 * the full path and name of the inews program
 * a "mini" inews has been included in the utils directory.
 */
#define INEWS "inews"

/*******************************************************************
 * Things you must change  UNIX specific
 *  Section 1b). 
 */
#else     /* UNIX */

/**************************
 * LYNX_CFG_FILE is the location and name of the lynx system
 * configuration file.
 */
#define LYNX_CFG_FILE "/usr/local/lib/lynx.cfg"

/*********************
 * LOCAL_DOMAIN is used to determin if a user is local
 * to your campus or organization
 */
#define LOCAL_DOMAIN "ukans.edu"		/* CHANGE THIS! */

/**************************
 * the full path and name of the telnet command
 */
#define TELNET_COMMAND "telnet"

/**************************
 * the full path and name of the tn3270 command
 */
#define TN3270_COMMAND "tn3270"

/**************************
 * the full path and name of the rlogin command
 */
#define RLOGIN_COMMAND "rlogin"

/*************************
 * if you don't have xloadimage just set this to "echo" or
 * something else that is harmless, 'xv' also works really well if
 * not better!
 */
#define XLOADIMAGE_COMMAND "xv"

/*************************
 * the full path and name of the inews program
 * a "mini" inews has been included in the utils directory.
 */
#define INEWS "inews"

/**************************
 * For UNIX systems this should be sendmail
 * sendmail should be in /usr/lib 
 * you definately want sendmail, not mail or elm or something else.
 *
 * Except in the case where MMDF is your mail agent.
 * for MMDF you should use submit (SCO)

 */
#ifdef MMDF
#define SYSTEM_MAIL "/usr/mmdf/bin/submit" 
#else
#define SYSTEM_MAIL "/usr/lib/sendmail" 
#endif /* MMDF */

/**************************
 * a place to put temporary files, its almost always "/tmp/" on
 * UNIX systems
 */
#define TEMP_SPACE "/tmp/"

/**************************
 * this "utmp" stuff is used to determine the calling address of
 * the user.  
 * do a "find / -name utmp -print" if you don't know where to find
 * the utmp file, its usually in /etc/utmp.
 * If you system doesn't have utmp support comment out the
 * following lines.
 */
#include <sys/types.h>
#include <utmp.h>
#define UTMP_FNAME "/etc/utmp"

#endif /* VMS OR UNIX */

/*************************************************************
 *  Section 1c)   Every platform must change or verify these
 *
 */

/*****************************
 * STARTFILE is the default file if none is specified on the command line 
 * note: these files can be remote (ie 0-0/start@host.cc.ukans.edu or
 * http://info.cern.ch/default.html) or local (i.e. /u/home/cwis.screen) 
 * if a local file is chosen the directory that it resides in
 * should be fully specified in the path.  
 */
#define STARTFILE "http://www.cc.ukans.edu/about_lynx/www_start.html"  /* */
/* #define STARTFILE "http://info.cern.ch/default.html"    */
/* #define STARTFILE "http://kufacts.cc.ukans.edu/cwis/kufacts_start.html"  */

/*****************************
 *
 * HELPFILE must be defined as a URL and must have a 
 * complete local path name if local 
 * (file://localhost/DIRECTORY/FILENAME
 *  replace DIRECTORY with the current directory path and
 *  FILENAME with the name of the file.
 *  file://localhost/dua#:[DIRECTORY]:FILENAME on VMS systems.)
 * the default HELPFILE is:
 * http://kufacts.cc.ukans.edu/lynx_help/lynx_help_main.html
 * This file will be updated as needed.
 */
#define HELPFILE "http://www.cc.ukans.edu/lynx_help/lynx_help_main.html"

/*****************************
 * DEFAULT_INDEX_FILE is the default file retrieved when the
 * user presses the 'I' key when viewing any document.
 * An index to your CWIS can be placed here or a document containing
 * pointers to lots of interesting places on the web.
 */
#define DEFAULT_INDEX_FILE "http://info.cern.ch/default.html"

/********************************
* The DEFAULT_CACHE_SIZE specifies the number of WWW documents to be
* cached in memory at one time.  When the number is exceded the oldest
* document will be removed from memory.
* The cache size may be modified with the command line argument -cache=NUMBER
*
*/
#define DEFAULT_CACHE_SIZE 10

/****************************************************************
 *   Section 2.   Things that you probably want to change or review
 *
 */

/*****************************
 * Enter the name of your anonymous account if you have one
 * as ANONYMOUS_USER.  UNIX systems will use a cuserid
 * or get_login call to determine if the current user is
 * the ANONYMOUS_USER.
 *
 * VMS systems cannot use this feature, so they must specify
 * anonymous accounts using the "-anonymous" command line option.
 *
 * Other systems may use the "-anonymous" option for multiple
 * accounts or percautionary reasons as well.
 *
 * It is very important to have this correctly defined if you 
 * have an anonymous account.  If you do not you will be putting 
 * yourself at GREAT security risk!
 *
 * Later on in this file you can specify priviliges for the
 * anonymous account.
 */
#define ANONYMOUS_USER "" 

/******************************
 * SHOW_CURSER controls whether or not the cursor is hidden
 * or appears over the link.  This is just the default, it
 * can be turned on with the -show_cursor command line option.
 * Showing the cursor is handy if you have really stupid terminals
 * that can't do bold and reverse video at the same time or at all.
 */
#define SHOW_CURSOR FALSE;

/*******************************
 * set to FALSE if you don't want users of your anonymous account
 * who are calling from inside your local domain 
 * to be able to telnet back out
 */
#define CAN_ANONYMOUS_INSIDE_DOMAIN_TELNET	       TRUE  

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account who are calling from outside your
 * local domain to be able to telnet back out
 */
#define CAN_ANONYMOUS_OUTSIDE_DOMAIN_TELNET       TRUE  

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account to be able to print
 */
#define CAN_ANONYMOUS_PRINT	       FALSE

/*******************************
 * set to FALSE if you don't want users of your anonymous
 * account to be able goto random URL's. (The 'g' command)
 */
#define CAN_ANONYMOUS_GOTO		TRUE

/*******************************
 * Execution links/scripts configuration.
 *
 * Execution links and scripts allow you to run
 * local programs by activating links within Lynx.
 * an execution link is of the form:
 *     lynxexec:<COMMAND>
 * where <COMMAND> is a command that Lynx will
 * run when the link is activated.
 * Execution scripts take the form of a standard
 * URL.  Extension mapping or MIME typing is used
 * to decide if the file is a script and should be
 * executed.  The current extensions are:
 * .csh, .ksh, and .sh on UNIX systems and .com on
 * VMS systems.  Any time a file of this type is
 * accessed Lynx will look at the users options
 * settings to decide if the script can be executed
 * Current options include: Only exec files that
 * reside on the local machine and are referenced
 * with a "file://localhost" URL, All execution
 * off, and all execution on.
 *
 * The following definitions will add execution
 * capibilities to Lynx.  You may define none, one
 * or both.
 *
 * I strongly recommend that you define neither one
 * of these since execution links/scripts can represent
 * very serious security risk to your system and it's
 * users.  If you do define these I suggest that
 * you only allow users to execution from files/scripts
 * that reside on your local machine. 
 *
 * YOU HAVE BEEN WARNED!
 *
 * Note: if you are enabling execution scripts you should
 * also see src/HTInit.c to verify/change the execution
 * script extensions and/or commands.
 */
/* #define EXEC_LINKS */ 
/* #define EXEC_SCRIPTS */ 


#if defined(EXEC_LINKS) || defined(EXEC_SCRIPTS)
/*****************************
 * These are for executable shell scripts and links.
 * Set to FALSE unless you really know what your
 * doing.
 *
 * This only applies if you are compiling with EXEC_LINKS or
 * EXEC_SCRIPTS defined.
 *
 * The first two settings:
 * LOCAL_EXECUTION_LINKS_ALWAYS_ON 
 * LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE
 * specify the default setting of the users execution link
 * options.
 *
 * if LOCAL_EXECUTION_LINKS_ALWAYS_OFF_FOR_ANONYMOUS is 
 * true all execution links will be disabled when the
 * -anonymous command line option is used.  Anonymous
 * users are not allowed to change the execution options
 * from within the Lynx options menu so you might be able
 * to use this option to enable execution links and set
 * LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE to true to
 * give anonymous execution link capibility without comprimising
 * your system.
 *
 */
#define LOCAL_EXECUTION_LINKS_ALWAYS_ON          FALSE
#define LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE  FALSE
#define LOCAL_EXECUTION_LINKS_ALWAYS_OFF_FOR_ANONYMOUS FALSE

#endif /*  defined(EXEC_LINKS) || defined(EXEC_SCRIPTS) */

/*********************************
 *  MAIL_SYSTEM_ERROR_LOGGING will send a message to the owner of 
 *  the information if there is one, every time
 *  that a document cannot be accessed!
 *
 *  NOTE: This can generate ALOT of mail, be warned.
 *
 *  VMS USERS !!!
 * You will probably want to set 'MAIL_SYSTEM_ERROR_LOGGING' to FALSE.
 * It can be nice to have automatic error logging but this is done
 * by doing a system command and running mail.  This is VERY slow under
 * VMS and just takes too darn long.
 */
#define MAIL_SYSTEM_ERROR_LOGGING   FALSE  /*mail a message for every error?*/

/*********************************
 * VI_KEYS can be turned on by the user in the options
 * screen or the .lynxrc file.  This is just the default.
 */
#define VI_KEYS_ALWAYS_ON           FALSE /* familiar h,j,k, & l */

/*********************************
 * EMACS_KEYS can be turned on by the user in the options
 * screen or the .lynxrc file.  This is just the default.
 */
#define EMACS_KEYS_ALWAYS_ON           FALSE /* familiar ^N, ^P, ^F, ^B */

/*********************************
 * DEFAULT_KEYPAD_MODE specifies whether by default the user
 * has numbers that work like arrows or else numbered links
 * DEFAULT KEYPAD MODE may be set to 
 *	LINKS_ARE_NUMBERED  or
 *	NUMBERS_AS_ARROWS
 */
#define DEFAULT_KEYPAD_MODE	       NUMBERS_AS_ARROWS

/********************************
 * The default search.
 * This is a default that can be overridden by the user!
 */
#define CASE_SENSITIVE_ALWAYS_ON    FALSE /* case sensitive user search */


/****************************************************************
 *   Section 3.   Things that you should not change until you
 *  		  have a good knowledge of the program
 */

#define LYNX_VERSION "2.2"
#ifndef MAXINT
#define MAXINT 2147483647
#endif /*MAXINT*/

/* text strings for certain actions */
/* changing these text strings is a way to customize 
 * your environment to better suit your tastes
 */
#define HELP "Commands: Use arrow keys to move, '?' for help, 'q' to quit, '<-' to go back"
#define MOREHELP \
  "-- press space for more, use arrow keys to move, '?' for help, 'q' to quit"
#define MORE "-- press space for next page --"
#define FORM_LINK_TEXT_MESSAGE "(Text entry field) Enter text. Use arrows or tab to move off of field."
#define FORM_LINK_PASSWORD_MESSAGE "(Password entry field) Enter text. Use arrows or tab to move off of field."
#define FORM_LINK_CHECKBOX_MESSAGE "(Checkbox Field)   Use right-arrow or <return> to toggle."
#define FORM_LINK_SUBMIT_MESSAGE "(Form submit button)   Use right-arrow or <return> to submit form."
#define FORM_LINK_RESET_MESSAGE "(Form reset button)   Use right-arrow or <return> to reset form to defaults."
#define NORMAL_LINK_MESSAGE "(NORMAL LINK)   Use right-arrow or <return> to activate"
#define LINK_NOT_FOUND "The resource requested is not available at this time."
#define WWW_WAIT_MESSAGE "Getting %s"
#define ADVANCED_URL_MESSAGE "URL: %s"
#define WWW_FAIL_MESSAGE "Unable to access WWW file!!!"
#define WWW_INDEX_MESSAGE "This is a searchable index.  Use 's' to search"
#define WWW_INDEX_MORE_MESSAGE "--More--  This is a searchable index.  Use 's' to search"
#define BAD_LINK_NUM_ENTERED "You have entered an invalid link number"
#define SOURCE_HELP "Currently viewing document source.  Press '\\' to return to rendered version"
#define NOVICE_LINE_ONE "  Arrow keys: Up and Down to move. Right to follow a link; Left to go back.  \n"
#define NOVICE_LINE_TWO "    O)ptions P)rint G)o M)ain menu Q)uit /=search [delete]=history list      \n"
#define FORM_NOVICELINE_ONE "            Enter text into the field by typing on the keyboard              "
#define FORM_NOVICELINE_TWO "    Ctrl-U to delete all text in field, [Backspace] to delete a character    "

#define MAXBASE 100       /* max length of base directory */
#define MAXHIGHLIGHT 160 /* max length of highlighted text */
#define MAXTARGET 130    /* max length of target string */
#define LINESIZE 1024    /* max length of line to read from file*/
#define MAXFNAME 1280	/* max filename length DDD/FILENAME.EXT */
#define MAXCOMMAND MAXFNAME /* max lengh of command should be the same */
#define MAXHIST  512	/* number of links we remember in history */
#define MAXLINKS 256	/* max links on one screen */
   /* traversal lookup table file, don't worry about it for now */
#define TRAVERSE_FILE "/homea/local/lynx2-0-8/traverse.file"
#define TRAVERSE_ERRORS "/homea/local/lynx2-0-8/traverse.errors"
#define TRAVERSE_FOUND_FILE "/homea/local/lynx2-0-8/traverse.found"

#endif /* USERDEFS_H */
