;LZW support for The Gimp
;
;notes: This installer should only replace existing libtiff.dll and add gif.exe
;to the plug-ins. They will be uninstalled automatically by the normal
;uninstaller. If you try to add any other files, they won't be removed by the
;normal uninstaller.
;
!packhdr tempfile.exe "upx --best tempfile.exe"
;!packhdr tempfile.exe "cmp tempfile.exe"

Name "LZW support for The Gimp 1.2.3-20020525"
Caption "LZW support for The Gimp"
SubCaption 0 " "
BrandingText " "
FileErrorText "File $0 could not be written.$\rMake sure that The Gimp isn't running"

OutFile "gimp-1.2.3-20020525-lzw.exe"

;get The Gimp installation directory from registry (1st try)
InstallDir "<>"
InstallDirRegKey HKLM SOFTWARE\GTK\1.3 Path

LicenseText "LZW support for The Gimp notes" "Install"
LicenseData info

InstallColors /windows
InstProgressFlags smooth colored
ShowInstDetails nevershow

; Check the installation directory
Section
  SetDetailsView show
  StrCmp $INSTDIR "<>" GTKUser GTKFound

GTKUser:
  ReadRegStr $9 HKCU SOFTWARE\GTK\1.3 Path
  StrCmp $INSTDIR "" Bad GTKFound
GTKFound:
  ReadRegStr $9 HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\WinGimp-1.2.3_is1 "Inno Setup: App Path"
  StrCmp $9 "" User Found
;try to find install dir if Gimp was installed in non-admin account on NT
User:
  ReadRegStr $9 HKCU SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\WinGimp-1.2.3_is1 "Inno Setup: App Path"
  StrCmp $9 "" Bad Found
;duh, Gimp not found
Bad:
  MessageBox MB_OK "GTK 1.3 or The Gimp do not appear to be installed on this computer. You cannot install LZW libraries without The Gimp."
  Abort "The Gimp was not found on your computer."

;found Gimp, let's install the files.
Found:
  DetailPrint 'The Gimp was found installed in "$9"'
  DetailPrint 'GTK+ 1.3 was found installed in "$INSTDIR"'

;  SetDetailsPrint none
;  SetOutPath "$INSTDIR\lib"
;  SetDetailsPrint both
;  File "libtiff.dll"

  SetDetailsPrint none
  SetOutPath "$9\lib\gimp\1.2\plug-ins"
  SetDetailsPrint both
  File "gif.exe"

;  SetDetailsView hide
SectionEnd
