[= AutoGen5 Template texi

(setenv "SHELL" "/bin/sh")

=]
[= (dne "  " "@ignore ") =]
@end ignore
@node Comparison
@section Competitive Feature Analysis

Here is a feature comparison of AutoOpts and six other command line
parser generators.  Nearly all of them share these characteristics:

@itemize @bullet
@item
They read a file that describes the program
options and produce code to parse command line options.  Each has their
own format for describing options.
@item
All versions support both short options (flags) and GNU-type long
options.  clig, however, is unique in that you must choose one or the
other.  Either way, clig options are introduced with a single hyphen.
The other packages identify long options with doubled hyphens.
@item
They produce tailored code for parsing the command line.
@item
They support the C programming language.
@item
The global option state is stored in a global structure.
@item
They produce usage text.
@end itemize

@noindent
The [=(count "competitor")=] parsers compared are:

@enumerate[=

(define fraction (sprintf " .%02d" (quotient 70 (count "competitor")))) =][=

FOR competitor =]
@item
[= ?% disc "%s" (sprintf
"Little is known by me [Bruce] about @strong{%s}." (get "name")) =]
[=ENDFOR
=]@end enumerate[=

do-multitable

=][=

FOR competitor =][=
  FOR note     =]

[[=(for-index) =]] [=note=][=
  ENDFOR       =][=
ENDFOR
=]
@*
 -- James R. Van Zandt
@*
 -- Bruce Korb[=

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # =][=

DEFINE do-multitable

=]
@center Comparative Analysis of Differentiating Features
@*
If a feature is present (or absent) in only one or two implementations,
then the "yes" or "no" is upper cased for emphasis.

@multitable @columnfractions .26[=
FOR competitor =][=(. fraction)=][=ENDFOR=]
@item Feature \ Package #[=
FOR competitor =]
@tab [=(for-index)=][=
ENDFOR =]
@item shell script app[=
FOR competitor =]
@tab [=? does_sh "YES" "no"=][=
ENDFOR =]
@item Scheme app[=
FOR competitor =]
@tab [=? does_scheme "YES" "no"=][=
ENDFOR =]
@item Perl app[=
FOR competitor =]
@tab [=? does_perl "YES" "no"=][=
ENDFOR =]
@item config file input[=
FOR competitor =]
@tab [=? config "yes" "no"=][=
ENDFOR =]
@item environment input[=
FOR competitor =]
@tab [=? env "YES" "no"=][=
ENDFOR =]
@item config file output[=
FOR competitor =]
@tab [=? conf-out "YES" "no"=][=
ENDFOR =]
@item callback functions[=
FOR competitor =]
@tab [=? callback "yes" "NO"=][=
ENDFOR =]
@item multiple occurrence[=
FOR competitor =]
@tab [=? multi-parms "YES" "no"=][=
ENDFOR =]
@item parameter types[=
FOR competitor =]
@tab [=argtyp=][=
ENDFOR =]
@item enumeration opts[=
FOR competitor =]
@tab [=? enum-opts "YES" "no"=][=
ENDFOR =]
@item optional argument[=
FOR competitor =]
@tab [=? opt-args "YES" "no"=][=
ENDFOR =]
@item default values[=
FOR competitor =]
@tab [=? default-vals "yes" "NO"=][=
ENDFOR =]
@item interactive[=
FOR competitor =]
@tab [=? interactive "YES" "no"=][=
ENDFOR =]
@item reset/restart[=
FOR competitor =]
@tab [=? reset "YES" "no"=][=
ENDFOR =]
@item range checks[=
FOR competitor =]
@tab [=? range-chk "yes" "no"=][=
ENDFOR =]
@item consistency checks[=
FOR competitor =]
@tab [=? consistency "YES" "no"=][=
ENDFOR =]
@item standard opts[=
FOR competitor =]
@tab [=? std-opts "YES" "no"=][=
ENDFOR =]
@item man page[=
FOR competitor =]
@tab [=? man-page "YES" "no"=][=
ENDFOR =]
@item texinfo invoking[=
FOR competitor =]
@tab [=? texi-usage "YES" "no"=][=
ENDFOR =]
@item developer dependencies[=
FOR competitor =]
@tab [=?% dependency "%s" "none"=][=
ENDFOR =]
@item user dependencies[=
FOR competitor =]
@tab [=?% user-dep "%s" "none"=][=
ENDFOR =]
@end multitable

"multiple occurrence" options may appear multiple times on the command line.
Some of the parsers constrain options to appearing once only.

"optional argument" refers to the argument to an option.
POSIX and most command line parsers require an option to either not have
an argument or else the argument must be supplied on the command line.
GNU's getopt_long and some of these parsers support the notion of
letting the option argument be "optional".

"consistency checks" verify that conflicting options do not appear
together, and options that require other options are allowed only
if those other options are present.

"standard options" are pre-defined options that can be trivially
incorporated into a user's set of options.  They can also thereby
be used for standardizing on the flag character and option name.

"interactive" means that the option processing package is able to
interactively query the user for option state.

"reset/restart" means that you can save your current (possibly initial)
processing state and reprocess options.  In this fashion, a daemon
process could reload its initialization (config) files.
[=

ENDDEF do-multitable

=]
