/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 toolbar.c - toolbar with actions

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "toolbar.h"

GtkWidget* w_toolbar[W_TOOLBAR_N];

void toolbar_create(void) {
  GtkTooltips* tips;
  GtkWidget* tmp;
  
  w_toolbar[W_TOOLBAR] = gtk_toolbar_new();
  gtk_toolbar_set_tooltips(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]), TRUE);
  gtk_toolbar_set_style(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]), GTK_TOOLBAR_ICONS);
  
  w_toolbar[W_TOOLBAR_ADD] = GTK_WIDGET(gtk_tool_button_new_from_stock(GTK_STOCK_ADD));
  tips = gtk_tooltips_new();
  gtk_tool_item_set_tooltip(GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_ADD]), tips,
			    "add new package",
			    "add");
  gtk_toolbar_insert(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]),
		     GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_ADD]), -1);
  
  w_toolbar[W_TOOLBAR_REMOVE] = GTK_WIDGET(gtk_tool_button_new_from_stock(GTK_STOCK_REMOVE));
  gtk_tool_item_set_tooltip(GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_REMOVE]), tips,
			    "remove package",
			    "remove");
  gtk_toolbar_insert(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]),
		     GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_REMOVE]), -1);

  w_toolbar[W_TOOLBAR_INSTALL] = GTK_WIDGET(gtk_tool_button_new_from_stock(GTK_STOCK_FLOPPY));
  gtk_tool_item_set_tooltip(GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_INSTALL]), tips,
			    "install package",
			    "install");
  gtk_toolbar_insert(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]),
		     GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_INSTALL]), -1);
  
  w_toolbar[W_TOOLBAR_UNINSTALL] = GTK_WIDGET(gtk_tool_button_new_from_stock(GTK_STOCK_CLEAR));
  gtk_tool_item_set_tooltip(GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_UNINSTALL]), tips,
			    "uninstall package",
			    "uninstall");
  gtk_toolbar_insert(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]),
		     GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_UNINSTALL]), -1);
  
  tmp = GTK_WIDGET(gtk_separator_tool_item_new());
  gtk_tool_item_set_expand(GTK_TOOL_ITEM(tmp), TRUE);
  gtk_separator_tool_item_set_draw(GTK_SEPARATOR_TOOL_ITEM(tmp), FALSE);
  gtk_toolbar_insert(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]),
		     GTK_TOOL_ITEM(tmp), -1);
  
  w_toolbar[W_TOOLBAR_STOP] = GTK_WIDGET(gtk_tool_button_new_from_stock(GTK_STOCK_STOP));
  gtk_tool_item_set_tooltip(GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_STOP]), tips,
			    "stop",
			    "stop");
  gtk_toolbar_insert(GTK_TOOLBAR(w_toolbar[W_TOOLBAR]),
		     GTK_TOOL_ITEM(w_toolbar[W_TOOLBAR_STOP]), -1);
}

void toolbar_update(void) {
  /* update toolbar basing on current state */

  if (state.actions_locked) {
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_ADD], FALSE);
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_REMOVE], FALSE);
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_INSTALL], FALSE);
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_UNINSTALL], FALSE);

    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_STOP], TRUE);
    return;
  }
  /* actions not locked */

  gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_ADD], TRUE);

  if (state.package != 0) { 
    /* a package is selected */
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_REMOVE], TRUE);
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_INSTALL], 
			     srcinst_is_source_available(state.package) &&
			     !srcinst_is_installed(state.package)?
			     TRUE : FALSE);
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_UNINSTALL],
			     srcinst_is_installed(state.package) ? 
			     TRUE : FALSE);

  } else {
    /* no packages selected */
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_REMOVE], FALSE);
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_INSTALL], FALSE);
    gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_UNINSTALL], FALSE);
  }
  gtk_widget_set_sensitive(w_toolbar[W_TOOLBAR_STOP], FALSE);
}
