/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <string.h>
#include <stdio.h>
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#ifdef HAVE_DMALLOC_H
#include <dmalloc.h>
#endif /* HAVE_DMALLOC_H */

#include <strsubs.h>
#include <salloc.h>
#include <timer.h>

#include <sqlutil.h>

static int verbose = 0;

void sqlutil_verbose(int level)
{
  verbose += level;
}

void smysql_queries(MYSQL* mysql, const char** queries, int queries_length)
{
  int i;
  for(i = 0; i < queries_length; i++)
    smysql_query(mysql, queries[i]);
}

int smysql_query(MYSQL* mysql, const char* query)
{
  int ret;
  if(verbose > 1) fprintf(stderr, "smysql_query: %s\n", query);
  if((ret = mysql_query(mysql, query))) {
    fprintf(stderr, "%s: %s\n", query, mysql_error(mysql));
    exit(1);
  }
  return ret;
}

MYSQL_RES* smysql_store_result(MYSQL* mysql)
{
  MYSQL_RES* res;

  if(!(res = mysql_store_result(mysql))) {
    fprintf(stderr, "mysql_store_result: %s\n", mysql_error(mysql));
    exit(1);
  }

  return res;
}

char* sql_quote_char_simple(char* from, int from_size)
{
  static char* to = 0;
  static int to_size = 0;

  return sql_quote_char(&to, &to_size, from, from_size);
}

/*
 * Quote special characters ' \ " and null char.
 */
char* sql_quote_char(char** to, int* to_size, char* from, int from_size)
{
  int i, j;

  static_alloc(to, to_size, from_size + 1);

  for(i = 0, j = 0; i < from_size; i++, j++) {
    char c = from[i];
    switch(c) {
    case '\0':
      c = '0';
    case '\\':
    case '\'':
    case '"':
      static_alloc(to, to_size, *to_size + 1);
      (*to)[j++] = '\\';
      break;
    }
    (*to)[j] = c;
  }

  (*to)[j] = '\0';

  return *to;
}

#if 0
/*
 * 1970-01-01 01:00:00
 * 0123456789012345678
 */
time_t sql_date2time(char* date)
{
  struct tm tm_object;
  char d[32];
  strcpy(d, date);
  memset(&tm_object, '\0', sizeof(struct tm));

  d[4] = d[7] = d[10] = d[13] = d[16] = 0;
  tm_object.tm_year = atoi(&d[2]);
  tm_object.tm_mon = atoi(&d[5]) - 1;
  tm_object.tm_mday = atoi(&d[8]);
  tm_object.tm_hour = atoi(&d[11]);
  tm_object.tm_min = atoi(&d[14]);
  tm_object.tm_sec = atoi(&d[17]);

  return mktime(&tm_object);
}
#endif

char* sql_itoa(int value)
{
  static char string[32];
  sprintf(string, "%d", value);
  return string;
}

int sql_select_value(MYSQL* mysql, char* query, char* value, int value_size)
{
  MYSQL_RES *res;
  MYSQL_ROW row;
  int found = 0;

  if(verbose > 1) fprintf(stderr, "sql_select_value: %s\n", query);

  smysql_query(mysql, query);
  res = smysql_store_result(mysql);

  if(mysql_num_rows(res) > 0) {
    if((row = mysql_fetch_row(res))) {
      if(row[0] && (value_size > strlen(row[0]))) {
	strcpy(value, row[0]);
	found = 1;
      }
    }
  }

  mysql_free_result(res);
  return found;
}

int sql_select(MYSQL* mysql, char* header, char* query, sql_select_callback callback, char* callback_arg)
{
  MYSQL_RES *res;
  MYSQL_ROW row;
  MYSQL_FIELD* field;
  int num_rows;

  if(verbose) time_register(0);
  if(verbose > 1) fprintf(stderr, "sql_select: %s\n", query);
  smysql_query(mysql, query);
  res = smysql_store_result(mysql);
  if(verbose) time_show(query, 0);

  if((num_rows = mysql_num_rows(res))) {
    if(verbose) time_register(0);
    if(header) {
      printf("%s%s\n", header, query);
      printf("---------------------\n");
    }
    while((row = mysql_fetch_row(res))) {
      if(callback) {
	(*callback)(callback_arg, res, row);
      } else {
	int i;
	for(i = 0; i < mysql_num_fields(res); i++) {
	  mysql_field_seek(res, i);
	  field = mysql_fetch_field(res);
	  printf("%s -> %s\n", field->name, row[i] ? row[i] : "NULL");
	}
      }
    }
    if(verbose) time_show("sql_select action", 0);
  }
  mysql_free_result(res);
  return num_rows;
}
