/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <stdio.h>
#include <fcntl.h>

#include <logfile.h>
#include <file_exists.h>
#include <file_size.h>

static int verbose = 0;

void logfile(char* file)
{
  char* logdir = getenv("LOGDIR");
  char path[512];
  int fd;
  int mode;
  if(!logdir) {
    if(verbose) fprintf(stderr, "no LOGDIR environment variable, set to .\n");
    logdir = ".";
  }
  sprintf(path, "%s/%s", logdir, file);
  if(file_exists(path) && file_size(path) < (100 * 1024))
    mode = O_APPEND | O_WRONLY;
  else
    mode = O_TRUNC | O_CREAT | O_WRONLY;
  if((fd = open(path, mode, 0777)) < 0) {
    fprintf(stderr, "could not open %s for writing\n", path);
    perror("");
    exit(0);
  }
  fflush(stderr);
  if(dup2(fd, 2) < 0) {
    fprintf(stderr, "could not dup2\n");
    perror("");
    exit(0);
  }
  close(fd);
}
