;;; $Id: jtelnet.el 1.2 1997/08/02 12:36:12 iganza Exp iganza $
;;; jtelnet.el --- run a telnet session from within an Emacs buffer

;; Copyright (C) 1997 Free Software Foundation, Inc.

;; Author: Ivan Ganza
;; Maintainer: Ivan Ganza (iganza@watchit.com)

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Simply redefines the function 'telnet' from 'telnet-mode' to allow use of a 
;; java program for 'telnet-mode'.

(require 'telnet)

(defvar jtelnet-java-path nil
  "Path to your favorite Java Interpreter (including the FULL name of the 
executable.")

(defvar jtelnet-class-arg nil
  "The command line option that specifies a classpath directory for a particular 
VM.  The Sun JDK uses -classpath and the JRE uses -cp.")

(defvar jtelnet-class-path nil
  "Your $CLASSPATH enviorment variable.  Add the directory where you installed
the jtelnet.class files to $CLASSPATH.  Or you can just place the jtelnet.class
files somewhere within your $CLASSPATH and leave it at that."
)

(defvar jtelnet-program "jtelnet"
  "Name of the jtelnet application.")

;;
;(setq telnet-font-lock-keywords			
;  (list (cons telnet-prompt-pattern 'font-lock-keyword-face)
;	 '("[ \t]\\([+-][^ \t\n]+\\)" 1 font-lock-type-face)
;	 '("^[^ \t\n]+:.*" . font-lock-string-face)	
;	 '("^\\[[1-9][0-9]*\\]" . font-lock-reference-face))
;  "Additional expressions to highlight in Telnet mode.")

(defun telnet (host)
  "Open a network login connection to host named HOST (a string).
Communication with HOST is recorded in a buffer `*telnet-HOST*'.
Normally input is edited in Emacs and sent a line at a time."
  (interactive "sOpen telnet connection to host: ")
  (let* ((comint-delimiter-argument-list '(?\  ?\t))
         (name (concat "telnet-" (comint-arguments host 0 nil) ))
	 (buffer (get-buffer (concat "*" name "*")))
	 process)
    (if (and buffer (get-buffer-process buffer))
	(pop-to-buffer (concat "*" name "*"))
      (pop-to-buffer 
       (make-comint name jtelnet-java-path nil 
		    jtelnet-class-arg jtelnet-class-path jtelnet-program))
      (setq process (get-buffer-process (current-buffer)))
      (set-process-filter process 'telnet-initial-filter)
      ;; Don't send the `open' cmd till telnet is ready for it.
      (accept-process-output process)
      (erase-buffer)
      (send-string process (concat "open " host "\n"))
      (telnet-mode)
      (setq comint-input-sender 'telnet-simple-send)
      (setq telnet-count telnet-initial-count)
      (make-local-variable 'font-lock-defaults)
      ;(setq font-lock-defaults '(telnet-font-lock-keywords t))
      )))

(provide 'jtelnet)

;; jtelnet.el ends
