/// <reference types="react" />
import { EditableSelectInputProps } from './base/types';
export interface IEditableSelectInputCell extends Omit<React.HTMLProps<HTMLElement | HTMLDivElement>, 'onSelect' | 'onToggle'> {
    /** Row index of this select input cell */
    rowIndex: number;
    /** Cell index of this select input cell */
    cellIndex: number;
    /** Props to build the select component */
    props: EditableSelectInputProps;
    /** Event handler which fires when user selects an option in this cell */
    onSelect: (event: React.MouseEvent | React.ChangeEvent, newValue: any | any[], rowIndex: number, cellIndex: number, isPlaceholder?: boolean) => void;
    /** Options to display in the expandable select menu */
    options?: React.ReactElement<any>[];
    /** Flag indicating the select input is disabled */
    isDisabled?: boolean;
    /** Flag indicating the toggle gets placeholder styles **/
    isPlaceholder?: boolean;
    /** Current selected options to display as the read only value of the table cell */
    selections?: any | any[];
    /** Flag indicating the select menu is open */
    isOpen?: boolean;
    /** Event handler which fires when the select toggle is toggled */
    onToggle?: (event: React.MouseEvent | undefined) => void;
    /** Event handler which fires when the user clears the selections */
    clearSelection?: (event: React.MouseEvent, rowIndex: number, cellIndex: number) => void;
}
export declare const EditableSelectInputCell: React.FunctionComponent<IEditableSelectInputCell>;
//# sourceMappingURL=EditableSelectInputCell.d.ts.map