import { IVec2 } from "../point/interface";
import { Offset2, Point2 } from "../point/point";
import { Arc, DerivableFunction, ShapeTransform } from "./interface";
export declare class FromXY implements Arc {
    private readonly x;
    private readonly y;
    constructor(x: DerivableFunction, y: DerivableFunction);
    eval(t: number): Point2;
    derivative(t: number): Offset2;
}
export declare class Bez3 implements Arc {
    readonly a: IVec2;
    readonly b: IVec2;
    readonly c: IVec2;
    readonly d: IVec2;
    constructor(a: IVec2, b: IVec2, c: IVec2, d: IVec2);
    eval(t: number): Point2;
    derivative(t: number): Offset2;
    isStraight(): boolean;
    static fromStraightSegment(ss: StraightSegment): Bez3;
}
export declare class Reparametrized implements Arc {
    curve: Arc;
    fn: DerivableFunction;
    constructor(c: Arc, fn: DerivableFunction);
    eval(t: number): IVec2;
    derivative(t: number): Offset2;
}
export declare class Reverted implements Arc {
    curve: Arc;
    constructor(c: Arc);
    eval(t: number): IVec2;
    derivative(t: number): Offset2;
}
export declare class Circle implements Arc {
    centerX: number;
    centerY: number;
    radius: number;
    constructor(cx: number, cy: number, radius: number);
    eval(t: number): Point2;
    derivative(t: number): Offset2;
}
export declare class StraightSegment implements Arc {
    readonly a: IVec2;
    readonly b: IVec2;
    constructor(a: IVec2, b: IVec2);
    eval(t: number): Point2;
    derivative(): Offset2;
}
export declare class Mixed implements Arc {
    a: Arc;
    b: Arc;
    mix: DerivableFunction;
    constructor(a: Arc, b: Arc, mix: DerivableFunction);
    eval(t: number): Point2;
    derivative(t: number): Offset2;
}
export declare class Mixed3 implements Arc {
    n: Arc;
    a: Arc;
    b: Arc;
    f: DerivableFunction;
    g: DerivableFunction;
    constructor(n: Arc, f: DerivableFunction, a: Arc, g: DerivableFunction, b: Arc);
    eval(t: number): Point2;
    derivative(t: number): Offset2;
}
export declare class Transformed implements Arc {
    c: Arc;
    tfm: ShapeTransform;
    constructor(t: ShapeTransform, c: Arc);
    eval(t: number): IVec2;
    derivative(t: number): Offset2;
}
export interface CurveMeasurer<T> {
    measureLength(a: T): number;
}
export declare class CombinedArc<T extends Arc> implements Arc {
    readonly segments: T[];
    protected readonly totalLength: number;
    protected readonly stops: number[];
    protected readonly endAdjustments: Offset2[];
    constructor(measurer: CurveMeasurer<T>, _segments: T[]);
    isEmpty(): boolean;
    eval(t: number): Point2;
    derivative(t: number): Offset2;
}
