// SPDX-License-Identifier: Apache-2.0
// ----------------------------------------------------------------------------
// Copyright 2011-2021 Arm Limited
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not
// use this file except in compliance with the License. You may obtain a copy
// of the License at:
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
// WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
// License for the specific language governing permissions and limitations
// under the License.
// ----------------------------------------------------------------------------

/**
 * @brief Data tables for quantization transfer.
 */

#include "astcenc_internal.h"

#define _ 0 // Using _ to indicate an entry that will not be used.

const quant_and_transfer_table quant_and_xfer_tables[12] {
	// Quantization method 0, range 0..1
	{
		QUANT_2,
		{0, 64},
		{0, 1},
		{0, 64},
		{0x4000,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
		 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
		 0x4000}
	},
	// Quantization method 1, range 0..2
	{
		QUANT_3,
		{0, 32, 64},
		{0, 1, 2},
		{0, 32, 64},
		{0x2000,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
		 _,_,0x4000,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
		 _,_,_,_,0x4020}
	},
	// Quantization method 2, range 0..3
	{
		QUANT_4,
		{0, 21, 43, 64},
		{0, 1, 2, 3},
		 {0, 21, 43, 64},
		{0x1500,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,0x2b00,_,_,_,_,
		 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,0x4015,_,_,_,_,_,_,_,_,_,_,_,_,
		 _,_,_,_,_,_,_,_,0x402b}
	},
	// Quantization method 3, range 0..4
	{
		QUANT_5,
		{0, 16, 32, 48, 64},
		{0, 1, 2, 3, 4},
		{0, 16, 32, 48, 64},
		{0x1000,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,0x2000,_,_,_,_,_,_,_,_,_,
		 _,_,_,_,_,_,0x3010,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,0x4020,_,_,_,
		 _,_,_,_,_,_,_,_,_,_,_,_,0x4030}
	},
	// Quantization method 4, range 0..5
	{
		QUANT_6,
		{0, 12, 25, 39, 52, 64},
		{0, 2, 4, 5, 3, 1},
		{0, 64, 12, 52, 25, 39},
		{0x0c00,_,_,_,_,_,_,_,_,_,_,_,0x1900,_,_,_,_,_,_,_,_,_,_,_,_,
		 0x270c,_,_,_,_,_,_,_,_,_,_,_,_,_,0x3419,_,_,_,_,_,_,_,_,_,_,
		 _,_,0x4027,_,_,_,_,_,_,_,_,_,_,_,0x4034}
	},
	// Quantization method 5, range 0..7
	{
		QUANT_8,
		{0, 9, 18, 27, 37, 46, 55, 64},
		{0, 1, 2, 3, 4, 5, 6, 7},
		{0, 9, 18, 27, 37, 46, 55, 64},
		{0x0900,_,_,_,_,_,_,_,_,0x1200,_,_,_,_,_,_,_,_,0x1b09,_,_,
		 _,_,_,_,_,_,0x2512,_,_,_,_,_,_,_,_,_,0x2e1b,_,_,_,_,_,_,_,_,
		 0x3725,_,_,_,_,_,_,_,_,0x402e,_,_,_,_,_,_,_,_,0x4037}
	},
	// Quantization method 6, range 0..9
	{
		QUANT_10,
		{0, 7, 14, 21, 28, 36, 43, 50, 57, 64},
		{0, 2, 4, 6, 8, 9, 7, 5, 3, 1},
		{0, 64, 7, 57, 14, 50, 21, 43, 28, 36},
		{0x0700,_,_,_,_,_,_,0x0e00,_,_,_,_,_,_,0x1507,_,_,_,_,_,_,
		 0x1c0e,_,_,_,_,_,_,0x2415,_,_,_,_,_,_,_,0x2b1c,_,_,_,_,_,
		 _,0x3224,_,_,_,_,_,_,0x392b,_,_,_,_,_,_,0x4032,_,_,_,_,_,
		 _,0x4039}
	},
	// Quantization method 7, range 0..11
	{
		QUANT_12,
		{0, 5, 11, 17, 23, 28, 36, 41, 47, 53, 59, 64},
		{0, 4, 8, 2, 6, 10, 11, 7, 3, 9, 5, 1},
		{0, 64, 17, 47, 5, 59, 23, 41, 11, 53, 28, 36},
		{0x0500,_,_,_,_,0x0b00,_,_,_,_,_,0x1105,_,_,_,_,_,
		 0x170b,_,_,_,_,_,0x1c11,_,_,_,_,0x2417,_,_,_,_,_,_,_,
		 0x291c,_,_,_,_,0x2f24,_,_,_,_,_,0x3529,_,_,_,_,_,
		 0x3b2f,_,_,_,_,_,0x4035,_,_,_,_,0x403b}
	},
	// Quantization method 8, range 0..15
	{
		QUANT_16,
		{0, 4, 8, 12, 17, 21, 25, 29, 35, 39, 43, 47, 52, 56, 60, 64},
		{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
		{0, 4, 8, 12, 17, 21, 25, 29, 35, 39, 43, 47, 52, 56, 60, 64},
		{0x0400,_,_,_,0x0800,_,_,_,0x0c04,_,_,_,0x1108,_,_,_,_,
		 0x150c,_,_,_,0x1911,_,_,_,0x1d15,_,_,_,0x2319,_,_,_,_,
		 _,0x271d,_,_,_,0x2b23,_,_,_,0x2f27,_,_,_,0x342b,_,_,_,
		 _,0x382f,_,_,_,0x3c34,_,_,_,0x4038,_,_,_,0x403c}
	},
	// Quantization method 9, range 0..19
	{
		QUANT_20,
		{0, 3, 6, 9, 13, 16, 19, 23, 26, 29, 35, 38, 41, 45, 48, 51, 55, 58, 61, 64},
		{0, 4, 8, 12, 16, 2, 6, 10, 14, 18, 19, 15, 11, 7, 3, 17, 13, 9, 5, 1},
		{0, 64, 16, 48, 3, 61, 19, 45, 6, 58, 23, 41, 9, 55, 26, 38, 13, 51, 29, 35},
		{0x0300,_,_,0x0600,_,_,0x0903,_,_,0x0d06,_,_,_,
		 0x1009,_,_,0x130d,_,_,0x1710,_,_,_,0x1a13,_,_,
		 0x1d17,_,_,0x231a,_,_,_,_,_,0x261d,_,_,0x2923,_,_,
		 0x2d26,_,_,_,0x3029,_,_,0x332d,_,_,0x3730,_,_,_,
		 0x3a33,_,_,0x3d37,_,_,0x403a,_,_,0x403d}
	},
	// Quantization method 10, range 0..23
	{
		QUANT_24,
		{0, 2, 5, 8, 11, 13, 16, 19, 22, 24, 27, 30, 34, 37, 40, 42, 45, 48, 51, 53, 56, 59, 62, 64},
		{0, 8, 16, 2, 10, 18, 4, 12, 20, 6, 14, 22, 23, 15, 7, 21, 13, 5, 19, 11, 3, 17, 9, 1},
		{0, 64, 8, 56, 16, 48, 24, 40, 2, 62, 11, 53, 19, 45, 27, 37, 5, 59, 13, 51, 22, 42, 30, 34},
		{0x0200,_,0x0500,_,_,0x0802,_,_,0x0b05,_,_,0x0d08,
		 _,0x100b,_,_,0x130d,_,_,0x1610,_,_,0x1813,_,
		 0x1b16,_,_,0x1e18,_,_,0x221b,_,_,_,0x251e,_,_,
		 0x2822,_,_,0x2a25,_,0x2d28,_,_,0x302a,_,_,0x332d,
		 _,_,0x3530,_,0x3833,_,_,0x3b35,_,_,0x3e38,_,_,
		 0x403b,_,0x403e}
	},
	// Quantization method 11, range 0..31
	{
		QUANT_32,
		{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64},
		{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31},
		{0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64},
		{0x0200,_,0x0400,_,0x0602,_,0x0804,_,0x0a06,_,
		 0x0c08,_,0x0e0a,_,0x100c,_,0x120e,_,0x1410,_,
		 0x1612,_,0x1814,_,0x1a16,_,0x1c18,_,0x1e1a,_,
		 0x221c,_,_,_,0x241e,_,0x2622,_,0x2824,_,0x2a26,_,
		 0x2c28,_,0x2e2a,_,0x302c,_,0x322e,_,0x3430,_,
		 0x3632,_,0x3834,_,0x3a36,_,0x3c38,_,0x3e3a,_,
		 0x403c,_,0x403e}
	}
};
