#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import subprocess
import sys
from typing import Any

sys.path.insert(0, os.path.abspath("."))
sys.path.insert(0, os.path.abspath("../"))
from pystac.version import STACVersion, __version__  # noqa:E402

git_branch = (
    subprocess.check_output(["git", "rev-parse", "--abbrev-ref", "HEAD"])
    .decode("utf-8")
    .strip()
)

# -- Project information -----------------------------------------------------

project = "pystac"
copyright = "2019, Azavea"
author = "stac-utils"

# The short X.Y version
version = __version__
# The full version, including alpha/beta/rc tags
release = __version__


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx_design",
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.viewcode",
    "sphinx.ext.intersphinx",
    "sphinx.ext.napoleon",
    "sphinx.ext.githubpages",
    "sphinx.ext.extlinks",
    "nbsphinx",
]

extlinks = {
    "tutorial": (
        "https://github.com/stac-utils/pystac/tree/{}/docs/tutorials/%s".format(
            git_branch
        ),
        "%s tutorial",
    ),
    "stac-spec": (
        "https://github.com/radiantearth/stac-spec/tree/v{}/%s".format(
            STACVersion.DEFAULT_STAC_VERSION
        ),
        "%s path",
    ),
    "stac-api-spec": (
        "https://github.com/radiantearth/stac-api-spec/tree/v{}/%s".format(
            STACVersion.DEFAULT_STAC_API_VERSION
        ),
        "%s path",
    ),
    "stac-ext": ("https://github.com/stac-extensions/%s", "%s extension"),
}

# Add any paths that contain templates here, relative to this directory.
# templates_path = ["_templates"]

# Static CSS files
# html_css_files = ["custom.css"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store", "**.ipynb_checkpoints"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "pydata_sphinx_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    "icon_links": [
        {
            "name": "GitHub",
            "url": "https://github.com/stac-utils/pystac",
            "icon": "fab fa-github-square",
        },
        {
            "name": "Gitter",
            "url": "https://gitter.im/SpatioTemporal-Asset-Catalog/"
            "python?utm_source=share-link&utm_medium=link&utm_campaign=share-link",
            "icon": "fab fa-gitter",
        },
    ],
    "external_links": [
        {"name": "STAC Spec", "url": "https://github.com/radiantearth/stac-spec"}
    ],
    "header_links_before_dropdown": 7,
    "navigation_with_keys": False,
    # "navbar_end": ["navbar-icon-links.html", "search-field.html"]
}

html_logo = "_static/STAC-03.png"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
html_sidebars: dict[str, list[str]] = {"index": []}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "pystacdoc"


# -- Options for LaTeX output ------------------------------------------------

latex_elements: dict[str, Any] = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, "pystac.tex", "pystac Documentation", "stac-utils", "manual"),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "pystac", "pystac Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "pystac",
        "pystac Documentation",
        author,
        "pystac",
        "Python library for SpatioTemporal Asset Catalogs (STAC).",
        "Miscellaneous",
    ),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]


# -- Extension configuration -------------------------------------------------

intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "dateutil": ("https://dateutil.readthedocs.io/en/stable", None),
    "urllib3": ("https://urllib3.readthedocs.io/en/stable", None),
}

# -- Substutition variables

rst_epilog = f".. |stac_version| replace:: {STACVersion.DEFAULT_STAC_VERSION}"

nitpick_ignore = [
    ("py:class", "Datetime"),
    ("py:class", "L"),
    ("py:class", "pystac.summaries.T"),
    ("py:class", "HREF"),  # this one partially works
    ("py:class", "jsonschema.validators.Draft7Validator"),
]
