/************************************************************************
 *
 * Copyright (C) 2009-2025 IRCAD France
 * Copyright (C) 2012-2021 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#pragma once

#include <cppunit/extensions/HelperMacros.h>

namespace sight::data::ut
{

class color_test : public CPPUNIT_NS::TestFixture
{
private:

    CPPUNIT_TEST_SUITE(color_test);
    CPPUNIT_TEST(basic);
    CPPUNIT_TEST(accessors);
    CPPUNIT_TEST(string);
    CPPUNIT_TEST(equality_test);
    CPPUNIT_TEST(rgba_u8_test);
    CPPUNIT_TEST_SUITE_END();

public:

    // interface
    void setUp() override;
    void tearDown() override;

    static void basic();
    static void accessors();
    static void string();
    static void equality_test();
    static void rgba_u8_test();
};

} // namespace sight::data::ut
