/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote.internal;

import android.content.Context;
import android.util.Log;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import pl.com.salsoft.sqlitestudioremote.internal.AuthService;
import pl.com.salsoft.sqlitestudioremote.internal.AuthServiceImpl;
import pl.com.salsoft.sqlitestudioremote.internal.ClientHandler;
import pl.com.salsoft.sqlitestudioremote.internal.ClientJobContainer;
import pl.com.salsoft.sqlitestudioremote.internal.Utils;

public class SQLiteStudioListener
implements Runnable,
ClientJobContainer {
    private static final int interval = 1000;
    private ServerSocket serverSocket;
    private int port = 12121;
    private boolean running = true;
    private ThreadPoolExecutor threadPool;
    private BlockingDeque<Runnable> jobsQueue;
    private List<ClientHandler> clientJobs;
    private Context context;
    private String password;
    private List<String> ipWhiteList;
    private List<String> ipBlackList;
    private AuthService authService;

    public SQLiteStudioListener(Context context) {
        this.context = context;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public synchronized void close() {
        this.running = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        if (this.threadPool != null && this.clientJobs != null) {
            this.threadPool.shutdown();
            for (ClientHandler handler : this.clientJobs) {
                handler.close();
            }
            try {
                this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        if (!this.init()) {
            return;
        }
        Log.d((String)Utils.LOG_TAG, (String)"Listening for clients...");
        while (this.isRunning()) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                ClientHandler clientHandler = new ClientHandler(clientSocket, this.context, this, this.authService);
                this.clientJobs.add(clientHandler);
                this.threadPool.execute(clientHandler);
            }
            catch (IOException e) {}
        }
        Log.d((String)Utils.LOG_TAG, (String)"Listener thread finished.");
    }

    private boolean init() {
        try {
            this.serverSocket = new ServerSocket(this.port, 5);
            this.serverSocket.setSoTimeout(1000);
        }
        catch (IOException e) {
            Log.e((String)Utils.LOG_TAG, (String)("Error while opening listening socket: " + e.getMessage()), (Throwable)e);
            return false;
        }
        this.jobsQueue = new LinkedBlockingDeque<Runnable>(1);
        this.clientJobs = new CopyOnWriteArrayList<ClientHandler>();
        this.threadPool = new ThreadPoolExecutor(20, 20, 10L, TimeUnit.SECONDS, this.jobsQueue);
        this.authService = new AuthServiceImpl(this.password, this.ipBlackList, this.ipWhiteList);
        return true;
    }

    @Override
    public void removeJob(ClientHandler handler) {
        this.clientJobs.remove(handler);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIpWhiteList(List<String> ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public void setIpBlackList(List<String> ipBlackList) {
        this.ipBlackList = ipBlackList;
    }
}

