( cd usr/lib ; rm -rf libgnokii.so.3 )
( cd usr/lib ; ln -sf libgnokii.so.3.8.0 libgnokii.so.3 )
( cd usr/lib ; rm -rf libgnokii.so )
( cd usr/lib ; ln -sf libgnokii.so.3.8.0 libgnokii.so )

ldconfig -r .

function install_file() {
  # $1 = File to process

  FILE="$(dirname "$1")/$(basename "$1" .new)"
  if [ ! -e "$FILE" ]
  then
    mv "$FILE.new" "$FILE"
  elif [ "$(cat "$FILE" | md5sum)" != "$(cat "$FILE.new" | md5sum)" ]
  then
    #     |--------|--------------------------------------------------|
    echo "WARNING: $FILE has been customised."
    echo "         Examine the $FILE.new file"
    echo "         and integrate any changes into the custom file."
    echo
  else
    rm -f "$FILE.new"
  fi
}

install_file etc/gnokiirc.new
install_file etc/udev/rules.d/45-nokiadku2.rules.new

if [ -x usr/bin/update-desktop-database ]; then
  usr/bin/update-desktop-database 1> /dev/null 2> /dev/null
fi
