# -*- coding: UTF-8 -*-
# -*- python -*-
# Copyright (C) 2005 by Sebastien Estienne
#
# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "COPYING" in the source distribution for more information.
#
# $Id: gconfterminal.py.in 127 2007-02-25 12:56:18Z sebest $
#

from sdapplet.pluginutils import *

import os
import pwd
import subprocess

try:
    import gettext
    gettext.bindtextdomain("service-discovery-applet", "/usr/share/locale")
    gettext.textdomain("service-discovery-applet")
    _ = gettext.gettext
    import pygtk
    pygtk.require('2.0')
    import gtk
    import gconf
    import gnome
except ImportError, e:
    error_msg(_("A required python module is missing!\n%s") % (e))
    os._exit()

class plugin_gnometerminal:
    def __init__(self):
        self.service_type = ["_ssh._tcp", "_sftp-ssh._tcp" ]
        self.author = "Sébastien Estienne"

    def enter_callback(self, widget, win):
        win.response(gtk.RESPONSE_OK)

    def SshLogin(self, hostname, username = None):
        self.win = gtk.Dialog(_("SSH Connection"), None,
                              gtk.DIALOG_MODAL,
                              (gtk.STOCK_OK, gtk.RESPONSE_OK,
                               gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))

        vbox = gtk.VBox(False, 5)
        self.win.vbox.pack_start(vbox, True, True, 0)
        vbox.set_border_width(5)
    
        label = gtk.Label()
        label.set_markup(_("Connecting to <b>%s</b>.\nPlease enter your <b>login</b>:") % (hostname))
        
        vbox.pack_start(label, False, False, 0)
    
        # Create our entry
        entry = gtk.Entry()
        if username!= None:
            entry.set_text(username)
        entry.connect("activate", self.enter_callback, self.win)
        vbox.pack_start(entry, False, False, 0)
    
        # Create the completion object
        completion = gtk.EntryCompletion()
    
        # Assign the completion to the entry
        entry.set_completion(completion)
    
        # Create a tree model and use it as the completion model
        completion_model = self.__create_completion_model()
        completion.set_model(completion_model)
    
        # Use model column 0 as the text column
        completion.set_text_column(0)
    
        self.win.show_all()
        if self.win.run() == gtk.RESPONSE_OK:
            self.win.destroy()
            return entry.get_text()
        else:
            self.win.destroy()
            return None
    
    def __create_completion_model(self):
        ''' Creates a tree model containing the completions.
        '''
        store = gtk.ListStore(str)
        
        iter = store.append()
        store.set(iter, 0, "root")
    
        current_user = pwd.getpwuid(os.getuid())[0]
        iter = store.append()
        store.set(iter, 0, current_user)
    
        return store

    def connect(self, use_host_names, name, stype, hostname, address, port, txts):
        try:
	   terminal = gconf.client_get_default().get_string ("/desktop/gnome/applications/terminal/exec")
	   terminal = terminal + " " + gconf.client_get_default().get_string ("/desktop/gnome/applications/terminal/exec_arg")
	except:
	    terminal = "gnome-terminal -x"
        if use_host_names == True:
            address = hostname
        print "connecting using %s" % (terminal)
        if txts.has_key("u"):
            username = self.SshLogin(name, txts["u"])
        else:
            username = self.SshLogin(name)


        if stype == "_ssh._tcp":
            scheme = "/usr/share/service-discovery-applet/tools//exec_wrapper ssh -X -p %d" % (port)
        else:
            scheme = "/usr/share/service-discovery-applet/tools//exec_wrapper sftp -oPort=%d" % (port)
        if username == None:
            return
        elif username != "":
            sshline = "%s %s@%s" % (scheme, username, address)
        else:
            sshline = "%s %s " % (scheme, address)

        cmdline = terminal.split(" ")
        cmdline.extend(sshline.split(" "))
        print cmdline
        subprocess.Popen(cmdline).wait()
        
def load():
    return plugin_gnometerminal()
