# -*- coding: utf-8 -*-
# -*- python -*-
# Copyright (C) 2005 by Sebastien Estienne
#
# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "COPYING" in the source distribution for more information.
#
# $Id: nautilus.py.in 142 2007-09-22 14:57:58Z sebest $
#

from sdapplet.pluginutils import *
import subprocess

class plugin_nautilus:
    def __init__(self):
        self.service_type = ["_ftp._tcp" , "_ftps._tcp" , "_webdav._tcp", "_webdavs._tcp", "_sftp-ssh._tcp"]
        self.author = "Sébastien Estienne"
        self.description = "Accessing zeroconf services using Nautilus"

    def connect(self, use_host_names, name, stype, hostname, address, port, txts):
        if use_host_names == True:
            address = hostname
        print "connecting using nautilus"
        path = get_txt_value(txts,"path")
        username = get_txt_value(txts,"u")
        password = get_txt_value(txts,"p")
        if stype == "_http._tcp":
            url = build_url("http",address,port, path, username,password)
        if stype == "_https._tcp":
            url = build_url("https",address,port, path, username,password)
        if stype == "_ftp._tcp":
            url = build_url("ftp",address,port, path, username,password)
        if stype == "_ftps._tcp":
            url = build_url("ftps",address,port, path, username,password)
        if stype == "_sftp-ssh._tcp":
            url = build_url("sftp",address,port, path, username,password)
        if stype == "_webdav._tcp":
            url = build_url("dav",address,port, path, username,password)
        if stype == "_webdavs._tcp":
            url = build_url("davs",address,port, path, username,password)

	cmdline = ["nautilus", url ]
	subprocess.Popen(cmdline).wait()

def load():
    return plugin_nautilus()
